/*
 * Decompiled with CFR 0.152.
 */
package xcodegen.generator.bean;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import xcodegen.exceptions.XCodeGenException;
import xcodegen.generator.AbstractCodeGenerator;
import xcodegen.structure.XClass;
import xcodegen.structure.XPackage;

public abstract class AbstractBeanCodeGenerator
extends AbstractCodeGenerator {
    private static Properties __langProperties = null;
    private File _pkgdir;

    public AbstractBeanCodeGenerator(String string) {
        super(string);
    }

    public String getPackagename(XPackage xPackage) {
        String string = this.getConfigProperty("package.suffix", null);
        return (string == null ? xPackage.getName() : xPackage.getName() + "." + string).toLowerCase();
    }

    public String getClassname(XClass xClass) {
        String string = this.getConfigProperty("class.suffix", "");
        String string2 = this.getConfigProperty("class.prefix", "");
        return string2 + xClass.getBeanName() + string;
    }

    public String getType(String string) {
        return __langProperties.getProperty("type." + string);
    }

    public void init(Properties properties) throws XCodeGenException {
        super.init(properties);
        String string = this.getConfigProperty("language", "java");
        String string2 = "resources/conf/" + string + ".properties";
        this.getLogger().info((Object)("Loading language resources: " + string2));
        __langProperties = this.loadResourceAsProperties(string2);
    }

    public String getVelocityTemplatePath() {
        return "resources/templates/" + this.getConfigProperty("language", "java") + "/" + this.getName() + ".vm";
    }

    protected void generate(XPackage xPackage, VelocityContext velocityContext, Template template) throws XCodeGenException, IOException {
        if (xPackage == null) {
            throw new IllegalArgumentException("pkg is null");
        }
        Logger logger = this.getLogger();
        String string = this.getPackagename(xPackage);
        velocityContext.put("pkgname", (Object)string);
        String string2 = this.getConfigProperty("class.output.dir", "./");
        this._pkgdir = new File(string2, string.replace('.', File.separatorChar));
        if (!this._pkgdir.exists()) {
            logger.debug((Object)("Creating package directory: " + this._pkgdir.getAbsolutePath()));
            this._pkgdir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generate(XClass xClass, VelocityContext velocityContext, Template template) throws XCodeGenException, IOException {
        if (xClass == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        Logger logger = this.getLogger();
        String string = this.getClassname(xClass);
        velocityContext.put("classname", (Object)string);
        StringWriter stringWriter = new StringWriter();
        try {
            template.merge((Context)velocityContext, (Writer)stringWriter);
        }
        catch (Exception exception) {
            throw new XCodeGenException("Unable to generate the code", exception);
        }
        String string2 = string + __langProperties.getProperty("extension");
        File file = new File(this._pkgdir, string2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringWriter.getBuffer().toString().getBytes());
            Object var11_11 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }
}

