/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    public static final String WARN = "warn";
    public static final String FAIL = "fail";
    public static final String TRUNCATE = "truncate";
    public static final String GNU = "gnu";
    public static final String OMIT = "omit";
    File tarFile;
    File baseDir;
    private TarLongFileMode longFileMode = new TarLongFileMode();
    Vector filesets = new Vector();
    Vector fileSetFiles = new Vector();
    private boolean longWarningGiven = false;
    private TarCompressionMethod compression = new TarCompressionMethod();

    public TarFileSet createTarFileSet() {
        TarFileSet fileset = new TarFileSet();
        this.filesets.addElement(fileset);
        return fileset;
    }

    public void setTarfile(File tarFile) {
        this.tarFile = tarFile;
    }

    public void setDestFile(File destFile) {
        this.tarFile = destFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setLongfile(String mode) {
        this.log("DEPRECATED - The setLongfile(String) method has been deprecated. Use setLongfile(Tar.TarLongFileMode) instead.");
        this.longFileMode = new TarLongFileMode();
        this.longFileMode.setValue(mode);
    }

    public void setLongfile(TarLongFileMode mode) {
        this.longFileMode = mode;
    }

    public void setCompression(TarCompressionMethod mode) {
        this.compression = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Vector savedFileSets;
        block27: {
            if (this.tarFile == null) {
                throw new BuildException("tarfile attribute must be set!", this.location);
            }
            if (this.tarFile.exists() && this.tarFile.isDirectory()) {
                throw new BuildException("tarfile is a directory!", this.location);
            }
            if (this.tarFile.exists() && !this.tarFile.canWrite()) {
                throw new BuildException("Can not write to the specified tarfile!", this.location);
            }
            savedFileSets = (Vector)this.filesets.clone();
            try {
                if (this.baseDir != null) {
                    if (!this.baseDir.exists()) {
                        throw new BuildException("basedir does not exist!", this.location);
                    }
                    TarFileSet mainFileSet = new TarFileSet(this.fileset);
                    mainFileSet.setDir(this.baseDir);
                    this.filesets.addElement(mainFileSet);
                }
                if (this.filesets.size() == 0) {
                    throw new BuildException("You must supply either a basedir attribute or some nested filesets.", this.location);
                }
                boolean upToDate = true;
                Enumeration e = this.filesets.elements();
                block9: while (true) {
                    if (!e.hasMoreElements()) {
                        if (!upToDate) break;
                        this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
                        Object var15_12 = null;
                        this.filesets = savedFileSets;
                        return;
                    }
                    TarFileSet fs = (TarFileSet)e.nextElement();
                    String[] files = fs.getFiles(this.project);
                    if (!this.archiveIsUpToDate(files)) {
                        upToDate = false;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= files.length) continue block9;
                        if (this.tarFile.equals(new File(fs.getDir(this.project), files[i]))) {
                            throw new BuildException("A tar file cannot include itself", this.location);
                        }
                        ++i;
                    }
                    break;
                }
                this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
                TarOutputStream tOut = null;
                try {
                    try {
                        tOut = new TarOutputStream(this.compression.compress(new BufferedOutputStream(new FileOutputStream(this.tarFile))));
                        tOut.setDebug(true);
                        if (this.longFileMode.isTruncateMode()) {
                            tOut.setLongFileMode(1);
                        } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
                            tOut.setLongFileMode(0);
                        } else {
                            tOut.setLongFileMode(2);
                        }
                        this.longWarningGiven = false;
                        Enumeration e2 = this.filesets.elements();
                        while (e2.hasMoreElements()) {
                            TarFileSet fs = (TarFileSet)e2.nextElement();
                            String[] files = fs.getFiles(this.project);
                            if (files.length > 1 && fs.getFullpath().length() > 0) {
                                throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
                            }
                            int i = 0;
                            while (i < files.length) {
                                File f = new File(fs.getDir(this.project), files[i]);
                                String name = files[i].replace(File.separatorChar, '/');
                                this.tarFile(f, tOut, name, fs);
                                ++i;
                            }
                        }
                    }
                    catch (IOException ioe) {
                        String msg = "Problem creating TAR: " + ioe.getMessage();
                        throw new BuildException(msg, ioe, this.location);
                    }
                    Object var12_19 = null;
                    if (tOut == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    if (tOut == null) throw throwable;
                    try {
                        tOut.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e3) {}
                tOut.close();
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                this.filesets = savedFileSets;
                throw throwable;
            }
        }
        Object var15_13 = null;
        this.filesets = savedFileSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tarFile(File file, TarOutputStream tOut, String vPath, TarFileSet tarFileSet) throws IOException {
        FileInputStream fIn;
        block19: {
            block18: {
                fIn = null;
                String fullpath = tarFileSet.getFullpath();
                if (fullpath.length() > 0) {
                    vPath = fullpath;
                } else {
                    String prefix;
                    if (vPath.length() <= 0) {
                        return;
                    }
                    if (file.isDirectory() && !vPath.endsWith("/")) {
                        vPath = vPath + "/";
                    }
                    if ((prefix = tarFileSet.getPrefix()).length() > 0 && !prefix.endsWith("/")) {
                        prefix = prefix + "/";
                    }
                    vPath = prefix + vPath;
                }
                if (vPath.startsWith("/") && !tarFileSet.getPreserveLeadingSlashes()) {
                    int l = vPath.length();
                    if (l <= 1) {
                        return;
                    }
                    vPath = vPath.substring(1, l);
                }
                try {
                    if (vPath.length() >= 100) {
                        if (this.longFileMode.isOmitMode()) {
                            this.log("Omitting: " + vPath, 2);
                            Object var11_10 = null;
                            if (fIn == null) return;
                            break block18;
                        }
                        if (this.longFileMode.isWarnMode()) {
                            this.log("Entry: " + vPath + " longer than " + 100 + " characters.", 1);
                            if (!this.longWarningGiven) {
                                this.log("Resulting tar file can only be processed successfully by GNU compatible tar commands", 1);
                                this.longWarningGiven = true;
                            }
                        } else if (this.longFileMode.isFailMode()) {
                            throw new BuildException("Entry: " + vPath + " longer than " + 100 + "characters.", this.location);
                        }
                    }
                    TarEntry te = new TarEntry(vPath);
                    te.setModTime(file.lastModified());
                    if (!file.isDirectory()) {
                        te.setSize(file.length());
                        te.setMode(tarFileSet.getMode());
                    }
                    te.setUserName(tarFileSet.getUserName());
                    te.setGroupName(tarFileSet.getGroup());
                    tOut.putNextEntry(te);
                    if (!file.isDirectory()) {
                        fIn = new FileInputStream(file);
                        byte[] buffer = new byte[8192];
                        int count = 0;
                        do {
                            tOut.write(buffer, 0, count);
                        } while ((count = fIn.read(buffer, 0, buffer.length)) != -1);
                    }
                    tOut.closeEntry();
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (fIn == null) throw throwable;
                    fIn.close();
                    throw throwable;
                }
            }
            fIn.close();
            return;
        }
        Object var11_11 = null;
        if (fIn == null) return;
        fIn.close();
    }

    protected boolean archiveIsUpToDate(String[] files) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        MergingMapper mm = new MergingMapper();
        mm.setTo(this.tarFile.getAbsolutePath());
        return sfs.restrict(files, this.baseDir, null, mm).length == 0;
    }

    static {
        WARN = WARN;
        FAIL = FAIL;
        TRUNCATE = TRUNCATE;
        GNU = GNU;
        OMIT = OMIT;
    }

    public static final class TarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public TarCompressionMethod() {
            this.setValue(NONE);
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private OutputStream compress(OutputStream ostream) throws IOException {
            String value = this.getValue();
            if (GZIP.equals(value)) {
                return new GZIPOutputStream(ostream);
            }
            if (BZIP2.equals(value)) {
                ostream.write(66);
                ostream.write(90);
                return new CBZip2OutputStream(ostream);
            }
            return ostream;
        }

        static {
            NONE = NONE;
            GZIP = GZIP;
            BZIP2 = BZIP2;
        }
    }

    public static class TarLongFileMode
    extends EnumeratedAttribute {
        public static final String WARN = "warn";
        public static final String FAIL = "fail";
        public static final String TRUNCATE = "truncate";
        public static final String GNU = "gnu";
        public static final String OMIT = "omit";
        private final String[] validModes = new String[]{"warn", "fail", "truncate", "gnu", "omit"};

        public TarLongFileMode() {
            this.setValue("warn");
        }

        public String[] getValues() {
            return this.validModes;
        }

        public boolean isTruncateMode() {
            return "truncate".equalsIgnoreCase(this.getValue());
        }

        public boolean isWarnMode() {
            return "warn".equalsIgnoreCase(this.getValue());
        }

        public boolean isGnuMode() {
            return "gnu".equalsIgnoreCase(this.getValue());
        }

        public boolean isFailMode() {
            return "fail".equalsIgnoreCase(this.getValue());
        }

        public boolean isOmitMode() {
            return "omit".equalsIgnoreCase(this.getValue());
        }

        static {
            WARN = "warn";
            FAIL = "fail";
            TRUNCATE = "truncate";
            GNU = "gnu";
            OMIT = "omit";
        }
    }

    public static class TarFileSet
    extends FileSet {
        private String[] files = null;
        private int mode = 33188;
        private String userName = "";
        private String groupName = "";
        private String prefix = "";
        private String fullpath = "";
        private boolean preserveLeadingSlashes = false;

        public TarFileSet(FileSet fileset) {
            super(fileset);
        }

        public TarFileSet() {
        }

        public String[] getFiles(Project p) {
            if (this.files == null) {
                DirectoryScanner ds = this.getDirectoryScanner(p);
                String[] directories = ds.getIncludedDirectories();
                String[] filesPerSe = ds.getIncludedFiles();
                this.files = new String[directories.length + filesPerSe.length];
                System.arraycopy(directories, 0, this.files, 0, directories.length);
                System.arraycopy(filesPerSe, 0, this.files, directories.length, filesPerSe.length);
            }
            return this.files;
        }

        public void setMode(String octalString) {
            this.mode = 0x8000 | Integer.parseInt(octalString, 8);
        }

        public int getMode() {
            return this.mode;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setGroup(String groupName) {
            this.groupName = groupName;
        }

        public String getGroup() {
            return this.groupName;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setFullpath(String fullpath) {
            this.fullpath = fullpath;
        }

        public String getFullpath() {
            return this.fullpath;
        }

        public void setPreserveLeadingSlashes(boolean b) {
            this.preserveLeadingSlashes = b;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }
    }
}

