/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;

public class DependSelector
extends BaseSelector {
    private String targetdir = null;
    private File targetbase = null;
    private Mapper mapperElement = null;
    private FileNameMapper map = null;
    private int granularity = 0;

    public String toString() {
        StringBuffer buf = new StringBuffer("{dependselector targetdir: ");
        buf.append(this.targetdir);
        buf.append(" granularity: ");
        buf.append(this.granularity);
        if (this.map != null) {
            buf.append(" mapper: ");
            buf.append(this.map.toString());
        } else if (this.mapperElement != null) {
            buf.append(" mapper: ");
            buf.append(this.mapperElement.toString());
        }
        buf.append("}");
        return buf.toString();
    }

    public void setTargetdir(String targetdir) {
        this.targetdir = SelectorUtils.fixPath(targetdir);
        this.targetbase = new File(this.targetdir);
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    public void verifySettings() {
        if (this.targetdir == null) {
            this.setError("The targetdir attribute is required.");
        }
        this.map = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
        if (this.map == null) {
            this.setError("Could not set <mapper> element.");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        String[] destfiles;
        this.validate();
        File target = this.targetbase;
        if (target == null) {
            target = new File(basedir, this.targetdir);
        }
        if ((destfiles = this.map.mapFileName(filename)).length != 1 || destfiles[0] == null) {
            throw new BuildException("Invalid destination file results for " + this.targetdir + " with filename " + filename);
        }
        String destname = destfiles[0];
        File destfile = new File(target, destname);
        return SelectorUtils.isOutOfDate(file, destfile, this.granularity);
    }
}

