/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] pGpointArray) {
        this();
        this.points = pGpointArray;
    }

    public PGpolygon(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGpolygon() {
        this.setType("polygon");
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara(string), ',');
        int n = pGtokenizer.getSize();
        this.points = new PGpoint[n];
        int n2 = 0;
        while (n2 < n) {
            this.points[n2] = new PGpoint(pGtokenizer.getToken(n2));
            ++n2;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PGpolygon) {
            PGpolygon pGpolygon = (PGpolygon)object;
            if (pGpolygon.points.length != this.points.length) {
                return false;
            }
            int n = 0;
            while (n < this.points.length) {
                if (!this.points[n].equals(pGpolygon.points[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        PGpoint[] pGpointArray = new PGpoint[this.points.length];
        int n = 0;
        while (n < this.points.length) {
            pGpointArray[n] = (PGpoint)this.points[n].clone();
            ++n;
        }
        return new PGpolygon(pGpointArray);
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = 0;
        while (n < this.points.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.points[n].toString());
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

