/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Text;
import org.jdom.Verifier;

public class CDATA
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: CDATA.java,v $ $Revision: 1.20 $ $Date: 2002/03/12 07:11:39 $ $Name: jdom_1_0_b8 $";
    private static final String EMPTY_STRING = "";
    protected String value;
    protected Object parent;

    protected CDATA() {
    }

    public CDATA(String str) {
        this.setText(str);
    }

    public void append(String str) {
        if (str == null) {
            return;
        }
        String reason = Verifier.checkCDATASection(str);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = this.value == EMPTY_STRING ? str : String.valueOf(this.value) + str;
    }

    public void append(CDATA cdata) {
        if (cdata == null) {
            return;
        }
        this.value = String.valueOf(this.value) + cdata.getText();
    }

    public Object clone() {
        CDATA cdata = null;
        try {
            cdata = (CDATA)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        cdata.parent = null;
        cdata.value = this.value;
        return cdata;
    }

    public CDATA detach() {
        if (this.parent != null) {
            ((Element)this.parent).removeContent(this);
        }
        this.parent = null;
        return this;
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }

    public Document getDocument() {
        if (this.parent != null) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    public Element getParent() {
        return (Element)this.parent;
    }

    public String getText() {
        return this.value;
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected CDATA setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public CDATA setText(String str) {
        if (str == null) {
            this.value = EMPTY_STRING;
            return this;
        }
        String reason = Verifier.checkCDATASection(str);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = str;
        return this;
    }

    public String toString() {
        return new StringBuffer(64).append("[CDATA: ").append(this.getText()).append("]").toString();
    }
}

