/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.filter.Filter;

class ContentList
extends AbstractList
implements Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: ContentList.java,v $ $Revision: 1.11 $ $Date: 2002/03/16 12:15:40 $ $Name: jdom_1_0_b8 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    private static final int CREATE = 0;
    private static final int HASPREV = 1;
    private static final int HASNEXT = 2;
    private static final int PREV = 3;
    private static final int NEXT = 4;
    private static final int ADD = 5;
    private static final int REMOVE = 6;
    protected ArrayList list;
    protected Object parent;

    private ContentList() {
    }

    protected ContentList(Document document) {
        this.parent = document;
        this.ensureCapacity(5);
    }

    protected ContentList(Element parent) {
        this.parent = parent;
        this.ensureCapacity(5);
    }

    public void add(int index, Object obj) {
        if (obj instanceof Element) {
            this.add(index, (Element)obj);
        } else if (obj instanceof Text) {
            this.add(index, (Text)obj);
        } else if (obj instanceof Comment) {
            this.add(index, (Comment)obj);
        } else if (obj instanceof ProcessingInstruction) {
            this.add(index, (ProcessingInstruction)obj);
        } else if (obj instanceof CDATA) {
            this.add(index, (CDATA)obj);
        } else if (obj instanceof EntityRef) {
            this.add(index, (EntityRef)obj);
        } else {
            if (obj == null) {
                throw new IllegalAddException("Cannot add null object");
            }
            throw new IllegalAddException("Class " + obj.getClass().getName() + " is of unrecognized type and cannot be added");
        }
    }

    protected void add(int index, CDATA cdata) {
        if (cdata == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.parent instanceof Document) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (cdata.getParent() != null) {
            throw new IllegalAddException("The CDATA already has an existing parent \"" + cdata.getParent().getQualifiedName() + "\"");
        }
        if (this.list == null) {
            if (index == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        }
        this.list.add(index, cdata);
        cdata.setParent((Element)this.parent);
        ++this.modCount;
    }

    protected void add(int index, Comment comment) {
        if (comment == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (comment.getParent() != null) {
            throw new IllegalAddException("The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (this.list == null) {
            if (index == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        }
        if (this.parent instanceof Document) {
            comment.setDocument((Document)this.parent);
        } else {
            comment.setParent((Element)this.parent);
        }
        this.list.add(index, comment);
        ++this.modCount;
    }

    protected void add(int index, Element element) {
        if (element == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (element.getParent() != null) {
            throw new IllegalAddException("The element already has an existing parent \"" + element.getParent().getQualifiedName() + "\"");
        }
        if (element == this.parent) {
            throw new IllegalAddException("The element cannot be added to itself");
        }
        if (this.parent instanceof Element && ((Element)this.parent).isAncestor(element)) {
            throw new IllegalAddException("The element cannot be added as a descendent of itself");
        }
        if (this.list == null) {
            if (index == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        }
        if (this.parent instanceof Document) {
            if (this.indexOfFirstElement() >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            element.setDocument((Document)this.parent);
        } else {
            element.setParent((Element)this.parent);
        }
        this.list.add(index, element);
        ++this.modCount;
    }

    protected void add(int index, EntityRef entity) {
        if (entity == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.parent instanceof Document) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
        if (entity.getParent() != null) {
            throw new IllegalAddException("The EntityRef already has an existing parent \"" + entity.getParent().getQualifiedName() + "\"");
        }
        if (this.list == null) {
            if (index == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        }
        this.list.add(index, entity);
        entity.setParent((Element)this.parent);
        ++this.modCount;
    }

    protected void add(int index, ProcessingInstruction pi) {
        if (pi == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (pi.getParent() != null) {
            throw new IllegalAddException("The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (this.list == null) {
            if (index == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        }
        if (this.parent instanceof Document) {
            pi.setDocument((Document)this.parent);
        } else {
            pi.setParent((Element)this.parent);
        }
        this.list.add(index, pi);
        ++this.modCount;
    }

    protected void add(int index, Text text) {
        if (text == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.parent instanceof Document) {
            throw new IllegalAddException("A Text not allowed at the document root");
        }
        if (text.getParent() != null) {
            throw new IllegalAddException("The Text already has an existing parent \"" + text.getParent().getQualifiedName() + "\"");
        }
        if (this.list == null) {
            if (index == 0) {
                this.ensureCapacity(5);
            } else {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        }
        this.list.add(index, text);
        text.setParent((Element)this.parent);
        ++this.modCount;
    }

    /*
     * Unable to fully structure code
     */
    public boolean addAll(int index, Collection collection) {
        block6: {
            if (this.list == null && index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
            if (collection == null || collection.size() == 0) {
                return false;
            }
            count = 0;
            try {
                i = collection.iterator();
                while (i.hasNext()) {
                    obj = i.next();
                    this.add(index + count, (Object)obj);
                    ++count;
                }
                break block6;
            }
            catch (RuntimeException exception) {
                i = 0;
                ** while (i < count)
            }
lbl-1000:
            // 1 sources

            {
                this.remove(index + i);
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            throw exception;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    protected void clearAndSet(Collection collection) {
        ArrayList old = this.list;
        this.list = null;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException exception) {
                this.list = old;
                throw exception;
            }
        }
        if (old != null) {
            int i = 0;
            while (i < old.size()) {
                this.removeParent(old.get(i));
                ++i;
            }
        }
    }

    protected void ensureCapacity(int minCapacity) {
        if (this.list == null) {
            this.list = new ArrayList(minCapacity);
        } else {
            this.list.ensureCapacity(minCapacity);
        }
    }

    public Object get(int index) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        return this.list.get(index);
    }

    private int getModCount() {
        return this.modCount;
    }

    protected List getView(Filter filter) {
        return new FilterList(filter);
    }

    protected int indexOfFirstElement() {
        if (this.list != null) {
            int i = 0;
            while (i < this.list.size()) {
                if (this.list.get(i) instanceof Element) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object remove(int index) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        Object old = this.list.get(index);
        this.removeParent(old);
        this.list.remove(index);
        ++this.modCount;
        return old;
    }

    private void removeParent(Object obj) {
        if (obj instanceof Element) {
            Element element = (Element)obj;
            element.setParent(null);
        } else if (obj instanceof Text) {
            Text text = (Text)obj;
            text.setParent(null);
        } else if (obj instanceof Comment) {
            Comment comment = (Comment)obj;
            comment.setParent(null);
        } else if (obj instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)obj;
            pi.setParent(null);
        } else if (obj instanceof CDATA) {
            CDATA cdata = (CDATA)obj;
            cdata.setParent(null);
        } else if (obj instanceof EntityRef) {
            EntityRef entity = (EntityRef)obj;
            entity.setParent(null);
        } else {
            throw new IllegalArgumentException("Object '" + obj + "' unknown");
        }
    }

    public Object set(int index, Object obj) {
        int root;
        if (this.list == null) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
        if (obj instanceof Element && this.parent instanceof Document && (root = this.indexOfFirstElement()) >= 0 && root != index) {
            throw new IllegalAddException("Cannot add a second root element, only one is allowed");
        }
        Object old = this.remove(index);
        try {
            this.add(index, obj);
        }
        catch (RuntimeException exception) {
            this.add(index, old);
            throw exception;
        }
        return old;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public String toString() {
        if (this.list != null && this.list.size() > 0) {
            return this.list.toString();
        }
        return "[]";
    }

    class FilterList
    extends AbstractList {
        protected Filter filter;
        int count = 0;
        int expected = -1;

        FilterList(Filter filter) {
            this.filter = filter;
        }

        public void add(int index, Object obj) {
            if (this.filter.canAdd(obj)) {
                int adjusted = this.getAdjustedIndex(index);
                ContentList.this.add(adjusted, obj);
                ++this.expected;
                ++this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + obj.getClass().getName() + " '" + obj + "' to be added to the list");
            }
        }

        public Object get(int index) {
            int adjusted = this.getAdjustedIndex(index);
            return ContentList.this.get(adjusted);
        }

        private final int getAdjustedIndex(int index) {
            int adjusted = 0;
            int i = 0;
            while (i < ContentList.this.list.size()) {
                Object obj = ContentList.this.list.get(i);
                if (this.filter.matches(obj)) {
                    if (index == adjusted) {
                        return i;
                    }
                    ++adjusted;
                }
                ++i;
            }
            if (index == adjusted) {
                return ContentList.this.list.size();
            }
            return ContentList.this.list.size() + 1;
        }

        public Iterator iterator() {
            return new FilterListIterator(this.filter, 0);
        }

        public ListIterator listIterator() {
            return new FilterListIterator(this.filter, 0);
        }

        public ListIterator listIterator(int index) {
            return new FilterListIterator(this.filter, index);
        }

        public Object remove(int index) {
            int adjusted = this.getAdjustedIndex(index);
            Object old = ContentList.this.get(adjusted);
            if (this.filter.canRemove(old)) {
                old = ContentList.this.remove(adjusted);
                ++this.expected;
                --this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + old.getClass().getName() + " '" + old + "' (index " + index + ") to be removed");
            }
            return old;
        }

        public Object set(int index, Object obj) {
            Object old = null;
            if (this.filter.canAdd(obj)) {
                int adjusted = this.getAdjustedIndex(index);
                old = ContentList.this.get(adjusted);
                if (!this.filter.canRemove(old)) {
                    throw new IllegalAddException("Filter won't allow the " + old.getClass().getName() + " '" + old + "' (index " + index + ") to be removed");
                }
                old = ContentList.this.set(adjusted, obj);
                this.expected += 2;
            } else {
                throw new IllegalAddException("Filter won't allow index " + index + " to be set to " + obj.getClass().getName());
            }
            return old;
        }

        public int size() {
            if (this.expected == ContentList.this.getModCount()) {
                return this.count;
            }
            this.count = 0;
            int i = 0;
            while (i < ContentList.this.size()) {
                Object obj = ContentList.this.list.get(i);
                if (this.filter.matches(obj)) {
                    ++this.count;
                }
                ++i;
            }
            this.expected = ContentList.this.getModCount();
            return this.count;
        }
    }

    class FilterListIterator
    implements ListIterator {
        Filter filter;
        int lastOperation;
        int initialCursor;
        int cursor;
        int last;
        int expected;

        FilterListIterator(Filter filter, int start) {
            this.filter = filter;
            this.initialCursor = this.initializeCursor(start);
            this.last = -1;
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 0;
        }

        public void add(Object obj) {
            this.checkConcurrentModification();
            if (this.filter.canAdd(obj)) {
                ++this.last;
            } else {
                throw new IllegalAddException("Filter won't allow add of " + obj.getClass().getName());
            }
            ContentList.this.add(this.last, obj);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 5;
        }

        private void checkConcurrentModification() {
            if (this.expected != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    break;
                }
                case 3: {
                    this.cursor = this.last;
                    break;
                }
                case 4: 
                case 5: {
                    this.cursor = this.moveForward(this.last + 1);
                    break;
                }
                case 6: {
                    this.cursor = this.moveForward(this.last);
                    break;
                }
                case 1: {
                    this.cursor = this.moveForward(this.cursor + 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
                case 2: 
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 2;
            }
            return this.cursor < ContentList.this.size();
        }

        public boolean hasPrevious() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    if (this.cursor < ContentList.this.size()) break;
                    this.cursor = this.moveBackward(this.initialCursor);
                    break;
                }
                case 3: 
                case 6: {
                    this.cursor = this.moveBackward(this.last - 1);
                    break;
                }
                case 2: {
                    this.cursor = this.moveBackward(this.cursor - 1);
                    break;
                }
                case 4: 
                case 5: {
                    this.cursor = this.last;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
                case 1: 
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 1;
            }
            return this.cursor >= 0;
        }

        private int initializeCursor(int start) {
            if (start < 0) {
                throw new IndexOutOfBoundsException("Index: " + start);
            }
            int count = 0;
            int i = 0;
            while (i < ContentList.this.size()) {
                Object obj = ContentList.this.get(i);
                if (this.filter.matches(obj)) {
                    if (start == count) {
                        return i;
                    }
                    ++count;
                }
                ++i;
            }
            if (start > count) {
                throw new IndexOutOfBoundsException("Index: " + start + " Size: " + count);
            }
            return ContentList.this.size();
        }

        private int moveBackward(int start) {
            if (start >= ContentList.this.size()) {
                start = ContentList.this.size() - 1;
            }
            int i = start;
            while (i >= 0) {
                Object obj = ContentList.this.get(i);
                if (this.filter.matches(obj)) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        private int moveForward(int start) {
            if (start < 0) {
                start = 0;
            }
            int i = start;
            while (i < ContentList.this.size()) {
                Object obj = ContentList.this.get(i);
                if (this.filter.matches(obj)) {
                    return i;
                }
                ++i;
            }
            return ContentList.this.size();
        }

        public Object next() {
            this.checkConcurrentModification();
            if (!this.hasNext()) {
                this.last = ContentList.this.size();
                throw new NoSuchElementException();
            }
            this.last = this.cursor;
            this.lastOperation = 4;
            return ContentList.this.get(this.last);
        }

        public int nextIndex() {
            this.checkConcurrentModification();
            this.hasNext();
            int count = 0;
            int i = 0;
            while (i < ContentList.this.size()) {
                if (this.filter.matches(ContentList.this.get(i))) {
                    if (i == this.cursor) {
                        return count;
                    }
                    ++count;
                }
                ++i;
            }
            this.expected = ContentList.this.getModCount();
            return count;
        }

        public Object previous() {
            this.checkConcurrentModification();
            if (!this.hasPrevious()) {
                this.last = -1;
                throw new NoSuchElementException();
            }
            this.last = this.cursor;
            this.lastOperation = 3;
            return ContentList.this.get(this.last);
        }

        public int previousIndex() {
            this.checkConcurrentModification();
            if (this.hasPrevious()) {
                int count = 0;
                int i = 0;
                while (i < ContentList.this.size()) {
                    if (this.filter.matches(ContentList.this.get(i))) {
                        if (i == this.cursor) {
                            return count;
                        }
                        ++count;
                    }
                    ++i;
                }
            }
            return -1;
        }

        public void remove() {
            this.checkConcurrentModification();
            if (this.last < 0 || this.lastOperation == 6) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.lastOperation == 5) {
                throw new IllegalStateException("cannot call remove() after add()");
            }
            Object old = ContentList.this.get(this.last);
            if (!this.filter.canRemove(old)) {
                throw new IllegalAddException("Filter won't allow " + old.getClass().getName() + " (index " + this.last + ") to be removed");
            }
            ContentList.this.remove(this.last);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 6;
        }

        public void set(Object obj) {
            this.checkConcurrentModification();
            if (this.lastOperation == 5 || this.lastOperation == 6) {
                throw new IllegalStateException("cannot call set() after add() or remove()");
            }
            if (this.last < 0) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.filter.canAdd(obj)) {
                Object old = ContentList.this.get(this.last);
                if (!this.filter.canRemove(old)) {
                    throw new IllegalAddException("Filter won't allow " + old.getClass().getName() + " (index " + this.last + ") to be removed");
                }
            } else {
                throw new IllegalAddException("Filter won't allow index " + this.last + " to be set to " + obj.getClass().getName());
            }
            ContentList.this.set(this.last, obj);
            this.expected = ContentList.this.getModCount();
        }
    }
}

