/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS ReportMaker v 0.1                                                   
* Descripcion:
* Clase encargada de manejar el dialogo que permite visualizar,
* salvar e imprimir un reporte.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class ReportMaker {

 String pageData = "";
 HtmlProperties html;
 JTextArea LogWin; 
 Language idiom;

 public ReportMaker(String path,String pattern,String numPerPage,Language leng,Vector names,Vector data,int[] posic,Vector combox,HtmlProperties prop,JTextArea lw)
  {
   html = prop;
   LogWin = lw;
   idiom = leng;
   Vector pages = new Vector();
   Double doub = new Double(numPerPage); 
   double p = Math.ceil(data.size()/doub.doubleValue());
   int cycles = (int)p * 1;
   int npages  = new Integer(numPerPage).intValue();

   int bottom = 0;
   int top = npages;
   String fileName="";

   for(int j=0;j<cycles;j++)
    {
     String fileN = "";;

     if(j!=0)
        fileN = path + pattern + "-" + j + ".html";
     else
      {
       fileN = path + pattern + ".html";
       fileName = fileN;
      }

     try {
          addTextLogMonitor(idiom.getWord("REPCR") + fileN);
          PrintStream fileLog = new PrintStream(new FileOutputStream(fileN));
          fileLog.print("<!-- " + idiom.getWord("HCRE") + " -->\n");
          fileLog.print(formatter(cycles,j,pattern,bottom,top,names,data,posic,combox,html));
          fileLog.close();
         }
       catch(Exception ex)
        {
         System.out.println("Error: " + ex);
         ex.printStackTrace();
        }

       bottom = top;
       top = npages * (j + 2);

       if(top > data.size())
          top = data.size(); 
    }

   String OS = System.getProperty("os.name");

   try {
        addTextLogMonitor(idiom.getWord("OBR"));
        if(OS.equals("Linux") || OS.equals("Solaris") || OS.equals("FreeBSD"))
         try {
              Runtime.getRuntime().exec("netscape " + fileName);
              System.out.println("Trying netscape...");
             }
          catch(Exception xp) {
                 try {
                      Runtime.getRuntime().exec("konqueror " + fileName);
                      System.out.println("Trying konqueror...");
                     }
                   catch(Exception xp2) {
                      try {
                            Runtime.getRuntime().exec("nautilus " + fileName);
                            System.out.println("Trying nautilus...");
                          }
                        catch(Exception xp3) {
                           System.out.println("No Browsers Found");
                                             }
                                        }
                              }

        if(OS.startsWith("Windows"))
          try {
                Runtime.getRuntime().exec("start netscape " + fileName);
              }
           catch(Exception xp) {
                 try {
                 Runtime.getRuntime().exec("start iexplore " + fileName);
                     }
                   catch(Exception xp2) {
                       System.out.println("No Browsers Found");
                                        }
                               }
      }
    catch(Exception ex) {
                          System.out.println("Error: " + ex);
                          ex.printStackTrace();
                         } 
 }


 public String formatter(int cycles,int indexPage,String pattern,int bottom,int top,Vector columns,Vector data,int[] posic,Vector combox,HtmlProperties prop)
 {
  boolean Results = false;

  for(int m=0;m<combox.size();m++)
   {
    String operation = (String) combox.elementAt(m);
    if(!operation.equals("0"))
     {
      Results = true;
      break;
     }
   }

  String font = "<font face=arial,helvetica size=3>";
  pageData = "<html><body bgcolor=white><br>\n";

  if(prop.getHeader().length()>0)
     pageData += "<b>" + prop.getHeader() + "</b><p>";

  pageData +="<center>" + prop.getTableConfig() + "\n<tr>";

  for(int i=0;i<columns.size();i++)
   { 
     String fieldName = (String) columns.elementAt(i);
     pageData += "<td bgcolor=\"" + prop.getTHBackground() + "\"><center>" + prop.getTHFontSettings() + "<b>" + fieldName + "</td>\n";
   }

  int[] counters = new int[columns.size()];

  if (top > data.size())
      top = data.size(); 

  for(int i=bottom;i<top;i++)
   {
    Vector row = (Vector) data.elementAt(i);
    pageData += "<tr>\n";

    for(int m=0;m<columns.size();m++)
     {
      String value;
      String operation = (String) combox.elementAt(m);
      Object o = row.elementAt(posic[m]);
      if (o != null)
        value = o.toString();
      else
        value = "NULL";
      pageData += "<td bgcolor=\"" + prop.getTCBackground() + "\"><center>" + prop.getTCFontSettings() + value + "</td>\n";
      if(operation.equals("0"))
         counters[m] = -1;
      if(operation.equals("1") || operation.equals("2"))
         counters[m] += Integer.parseInt(value);
     }

   }

  if(Results) 
   {
     pageData += "<tr>\n";

     for(int m=0;m<combox.size();m++)
      {
       String operation = (String) combox.elementAt(m);

       if(operation.equals("0")) 
        pageData += "<td>" + "</td>\n";

       if(operation.equals("1")) 
        pageData += "<td><center>" + font + idiom.getWord("TOTAL") + ": " + counters[m] + "</td>\n";

       if(operation.equals("2")) 
        pageData += "<td><center>" + font + idiom.getWord("AVER") + ": " + counters[m]/data.size() + "</td>\n";

      } // fin for
    } // fin if

  pageData += "</table>";

  if(prop.FOOTER.length()>0)
     pageData += prop.FOOTER;

  String link = "";

  if(indexPage < cycles-1)
   {
    indexPage++;
    link = pattern + "-" + indexPage + ".html";
    pageData += "<p><center><a href=\"" + link + "\">" + idiom.getWord("NEXT") + "</a></center>";
   }
  else
   {
    link = pattern + ".html";     
    pageData += "<p><center><a href=\"" + link + "\">" + idiom.getWord("INI") + "</a></center>";
   }

  pageData += "</body></html>"; 
  return pageData;
}

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
 public void addTextLogMonitor(String msg)
  {
   LogWin.append(msg + "\n");
   int longiT = LogWin.getDocument().getLength();

   if(longiT > 0)
      LogWin.setCaretPosition(longiT - 1);
  }

}
