CREATE OR REPLACE FUNCTION CREATE_TREE(INTEGER,INTEGER,INTEGER) RETURNS BOOLEAN AS '
DECLARE
    v_node INTEGER;
    v_times INTEGER;
    v_root INTEGER;
    v_parent ALIAS FOR $2;
BEGIN
    v_root := $1;
    v_times := $3; -- append subtree for specified times
    FOR i IN 0..v_times LOOP
        v_node := createElement(v_root,''edge'');
        PERFORM addchildelement(v_node,''from'');
        PERFORM addchildelement(v_node,''to'');
        PERFORM appendChild(v_parent,v_node);
    END LOOP;
    RETURN TRUE;
END;
' LANGUAGE 'plpgsql' WITH (ISSTRICT);

CREATE OR REPLACE FUNCTION CREATE_SUBTREE(INTEGER,INTEGER) RETURNS BOOLEAN AS '
DECLARE
    v_node INTEGER;
    v_times INTEGER;
    v_root INTEGER;
BEGIN
    v_root := $1;
    v_times := $2; -- append subtree for specified times
    FOR i IN 0..v_times LOOP
        v_node := createElement(v_root,''edge'');
        PERFORM new_childelement(v_node,''from'');
        PERFORM new_childelement(v_node,''to'');
    END LOOP;
    RETURN TRUE;
END;
' LANGUAGE 'plpgsql' WITH (ISSTRICT);
