/**
 - gc_pathexp.sql,v 1.1 2003/07/17 14:10:45 myui Exp
 */

--BEGIN;

/*
CREATE OR REPLACE FUNCTION plpgsql_call_handler () RETURNS LANGUAGE_HANDLER AS
    '$libdir/plpgsql' LANGUAGE C;

CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql
    HANDLER plpgsql_call_handler;
*/

CREATE OR REPLACE FUNCTION gc_pathexp() RETURNS BOOL AS'
DECLARE
    mviews RECORD;
BEGIN
    RAISE NOTICE ''[gc_pathexp] start'';
    FOR mviews IN
    				-- find duplicate pathexp entry.
                    SELECT
                       xp.pathid as oldpid,
                       p1.pathid as newpid
                    FROM
                        xml_path xp,
                        (SELECT
                            pathexp,
                            min(pathid) as pathid
                        FROM
                            xml_path
                        GROUP BY
                            pathexp
                        ) p1
                    WHERE
                        xp.pathexp = p1.pathexp and
                        xp.pathid != p1.pathid
    LOOP
        -- replace old pathid in xml_node with new.
        UPDATE
		    xml_node
        SET
            pathid=mviews.newpid
        WHERE
            pathid=mviews.oldpid;
        -- delete duplicated old pathid entry.
        DELETE FROM
            xml_path
        WHERE
            pathid=mviews.oldpid;
    END LOOP;
    RAISE NOTICE ''[gc_pathexp] finish'';
    RETURN TRUE;
END;'
LANGUAGE 'plpgsql';

--END;
