<?php
/*
Htmltemplate for PHP4
Copyright (C) 2003 Hiroshi Ayukawa

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

-----  Class diagram ------------------

+--------------+     (use)
| htmltemplate |<----------  Client
+--------------+
           <>
            | (use to parse documents)
            V
+--------------+
|StandardParser|
+--------------+
            |
            |
           --
           V
+----------------+
| TemplateParser |
+----------------+
            <>
             |
             | (use to parse each tags)
             |
             V
    +----------+     +----------+         +-------------+
    | TagBasis |<|---| DataTag  |---------| ConcreteTags|
    +----------+     | ArrayTag |         +-------------+
                     +----------+            tag_val,tag_each,,,,etc.

*/


/*
* Tag definition
*/

/* the origine class of all tags */
class TagBasis{
	var $matchregexp;
	var $fromstring;
	var $tostring;
	var $closestring;
	var $regardasarray=false;
	
	function getLabelArray($str){
		$ans=array();
		preg_match_all($this->matchregexp,$str,$regans,PREG_SET_ORDER);
		foreach($regans as $x){
			$ans[]=$x[1];
		}
		return $ans;
	}
	
	function parse($str,$multilabels){
		while(preg_match($this->matchregexp,$str,$match)){
			$ind=$this->getIndex($match[1],$multilabels);
			
			$str=str_replace(
				call_user_func_array("sprintf",array_merge(array($this->fromstring),array_slice($match,1))),
				call_user_func_array("sprintf",array_merge(array($this->tostring),array($ind),array_slice($match,1))),
			$str);
		}
		$str=$this->closeTag($str);
		return $str;
	}
	
	function closeTag($str){
		if($this->closestring){
			$str=str_replace($this->closestring,
			"<?php
				}
			?>",
			$str);
		}
		return $str;
	}
	
	function getIndex($m,$multilabels){}
}

/* the super class of tags which handle non-array data  */
class DataTag extends TagBasis{
	 function getIndex($m,$multilabels){
		$ar=split("/",$m);
		$ind="";
		$rui=array();
		foreach($ar as $x){
			array_push($rui,$x);
			$ind.="[\"$x\"]";
			if(in_array(join("/",$rui),$multilabels)){ 
				$ind.="[\$cnt[\"".join("/",$rui)."\"]]";
			}
		}
		return $ind;
	}
}

/* the super class of tags which handle array structure
 like {each *}  */
class ArrayTag extends TagBasis{
	function getIndex($m,$multilabels){
		$ar=split("/",$m);
		$ind="";
		$rui=array();
		$mattan=0;
		foreach($ar as $x){
			array_push($rui,$x);
			$ind.="[\"$x\"]";
			if($mattan!=count($ar)-1 && in_array(join("/",$rui),$multilabels)) {
				$ind.="[\$cnt[\"".join("/",$rui)."\"]]";
			}
			$mattan++;
		}
		return $ind;
	}
}


/*
*  parser classes
*/

/* main definition of parser */
class TemplateParser{
	var $tags=array("simple"=>array(),"multi"=>array());
	
	function add($tag){
		if($tag->regardasarray) $this->tags["multi"][]=$tag;
		else $this->tags["simple"][]=$tag;
		return $this;
	}
	
	function parse($str){
		reset($this->tags["multi"]);
		$multilabels=array();
		foreach($this->tags["multi"] as $x){
			$multilabels=array_merge($multilabels,$x->getLabelArray($str));
		}
		
		reset($this->tags["multi"]);
		foreach($this->tags["multi"] as $x){
			$str=$x->parse($str,$multilabels);
		}
		
		reset($this->tags["simple"]);
		foreach($this->tags["simple"] as $x){
			$str=$x->parse($str,$multilabels);
		}
		return $str;
	}
}


////////////////////////////////////////////////////


/*
*   Standard tag classes
*   these tags are defined as previous version of htmltemplate
*/

class tag_val extends DataTag{
	var $matchregexp='/\{val ([^\}]+)\}/i';
	var $fromstring="{val %s}";
	var $tostring="<?php @print nl2br(\$val%1\$s); ?>\n";
}

class tag_rval extends DataTag{
	var $matchregexp='/\{rval ([^\}]+)\}/i';
	var $fromstring="{rval %s}";
	var $tostring="<?php @print \$val%1\$s; ?>\n";
}


class tag_def extends ArrayTag{
	var $matchregexp='/<!--\{def ([^\}]+)\}-->/i';
	var $fromstring="<!--{def %s}-->";
	var $tostring="<?php
		if(@\$val%1\$s &&((gettype(\$val%1\$s)!='array' && \$val%1\$s!=\"\") or (gettype(\$val%1\$s)=='array' && count(\$val%1\$s)>0))){ ?>";
	var $closestring="<!--{/def}-->";
}

class tag_vdef extends DataTag{
	var $matchregexp='/<!--\{vdef ([^\}]+)\}-->/i';
	var $fromstring="<!--{vdef %s}-->";
	var $tostring="<?php
		if(@\$val%1\$s && ((gettype(\$val%1\$s)!='array' && \$val%1\$s!=\"\") or (gettype(\$val%1\$s)=='array' && count(\$val%1\$s)>0))){ ?>";
	var $closestring="<!--{/vdef}-->";
	var $regardasarray=1;
}

class tag_each extends ArrayTag{
	var $matchregexp='/<!--\{each ([^\}]+)\}-->/i';
	var $fromstring="<!--{each %s}-->";
	var $tostring="<?php
			for(\$cnt[\"%2\$s\"]=0;\$cnt[\"%2\$s\"]<count(\$val%1\$s);\$cnt[\"%2\$s\"]++){
				?>";
	var $closestring="<!--{/each}-->";
	var $regardasarray=true;
}

/*
*   StandardParser
*   parser defined with above tags.
*   behave as previous htmltemplate
*/
class StandardParser extends TemplateParser{
	function StandardParser(){
		$this->add(new tag_val());
		$this->add(new tag_rval());
		$this->add(new tag_def());
		$this->add(new tag_vdef());
		$this->add(new tag_each());
	}
}

/*
*  htmltemplate
*  the APIs defined after the manner of htmltemplate for PHP4
*  tmp file generation has not been implemented yet.(2003-07-08)
*/

class htmltemplate{
	var $parser;
	
	function htmltemplate(){
		$this->parser=new StandardParser();
	}
	
	function &getInstance(){
		static $instance;
		if(! $instance) $instance=new htmltemplate();
		return $instance;
	}
	
	function add($tag){
		$inst=&htmltemplate::getInstance();
		$inst->parser->add($tag);
	}
	
	function setParser($parser){
		$inst=&htmltemplate::getInstance();
		$inst->parser=$parser;
	}
	
	function parse($str){
		$inst=&htmltemplate::getInstance();
		return $inst->parser->parse($str);
	}
	
	function t_include($file,$data){
		print htmltemplate::t_buffer($file,$data);
	}
	
	function t_buffer($file,$data){
		$val=$data;
		$all=fread(fopen($file,"rb"),filesize($file));
		$code=htmltemplate::parse($all);
		ob_start();
		eval('?>' .$code);
		$cnt=ob_get_contents();
		ob_end_clean();
		return $cnt;
	}
}
?>
