#!/usr/sbin/dtrace -qs

/*
 * Usage      : txn_count.d
 * Description: Count all started, committed, and aborted transactions and
 *              the total processing time
 * Author     : Robert Lor
 */

postgresql*:::transaction-start
{
	@start[pid, "New"] = count();
	@startpersec[pid, "New"] = count();
}

postgresql*:::transaction-commit
{
	@commit[pid, "Commit"] = count();
	@commitpersec[pid, "Commit"] = count();
}

postgresql*:::transaction-abort
{
	@abort[pid, "Abort"] = count();
}

profile:::tick-1s
{

        printf("Transactions Per Second \n");
	
	printa("%5d %20s %@15d\n", @startpersec);
	printa("%5d %20s %@15d\n", @commitpersec);

        printf("\n");

        printf("Total Transactions\n");
        printa("%5d %20s %@15d\n",@start);
        printa("%5d %20s %@15d\n",@commit);
        printa("%5d %20s %@15d\n",@abort);

        printf("\n--------------------------------------------\n\n");

	clear(@startpersec);
	clear(@commitpersec);
}


