/************************************************************************
 *                                                                      *
 * Geomedia BLOB CODEC                                                  *
 * Copyright (C) 2009 Claudio Rocchini                                  *
 * Istituto Geografico Militare Italiano                                *
 * web:   www.igmi.org                                                  *
 * email: ad2prod@geomil.esercito.difesa.it                             *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the  Free Software Foundation, either  version 3 of the  License, or *
 * any later version.                                                   *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without  even the implied warranty of    *
 *   MERCHANTABILITY or  FITNESS  FOR A PARTICULAR PURPOSE.  See the    *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program.  If not, see <http://www.gnu.org/licenses/> *
 *                                                                      *
 ************************************************************************/


#ifndef __SHQN__BLOB4__
#define __SHQN__BLOB4__

#include <vector>
#include <string>

namespace blo
{


typedef unsigned char byte;


class point
{
public:
	double x;
	double y;
	double z;
};


class polyline
{
public:
	std::vector<point> l;
};


typedef std::vector< point > ring;


class polygon
{
public:
	std::vector< ring > r;
};


class arc
{
public:
	point start;
	point end;
	point normal;
	double radius;
};


class BlobCache
{
protected:
	bool decode_collection( byte * buf );

public:
	enum  TYPES { T_NONE, T_POINT, T_OPOINT, T_LINE, T_AREA, T_ARC, T_TEXT, T_COLLECTION };
	int      type;
	point    pt;
	double   an;
	polyline pl;
	polygon  pg;
	arc      ar;
	std::vector<byte> tx;

	std::vector<BlobCache> co;

	bool decode( byte * buf );
	bool encode( byte * buf, size_t & len );
};


}	// end namespace blo


#endif
