.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SELECT INTO" "" "2008-02-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
SELECT INTO \- define a new table from the results of a query

.SH SYNOPSIS
.sp
.nf
SELECT [ ALL | DISTINCT [ ON ( \fIexpression\fR [, ...] ) ] ]
    * | \fIexpression\fR [ AS \fIoutput_name\fR ] [, ...]
    INTO [ TEMPORARY | TEMP ] [ TABLE ] \fInew_table\fR
    [ FROM \fIfrom_item\fR [, ...] ]
    [ WHERE \fIcondition\fR ]
    [ GROUP BY \fIexpression\fR [, ...] ]
    [ HAVING \fIcondition\fR [, ...] ]
    [ { UNION | INTERSECT | EXCEPT } [ ALL ] \fIselect\fR ]
    [ ORDER BY \fIexpression\fR [ ASC | DESC | USING \fIoperator\fR ] [ NULLS { FIRST | LAST } ] [, ...] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]
    [ FOR { UPDATE | SHARE } [ OF \fItable_name\fR [, ...] ] [ NOWAIT ] [...] ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSELECT INTO\fR creates a new table and fills it
with data computed by a query. The data is not returned to the
client, as it is with a normal \fBSELECT\fR. The new
table's columns have the names and data types associated with the
output columns of the \fBSELECT\fR.
.SH "PARAMETERS"
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created as a temporary table. Refer
to CREATE TABLE [\fBcreate_table\fR(l)] for details.
.TP
\fB\fInew_table\fB\fR
The name (optionally schema-qualified) of the table to be created.
.PP
All other parameters are described in detail under SELECT [\fBselect\fR(l)].
.PP
.SH "NOTES"
.PP
CREATE TABLE AS [\fBcreate_table_as\fR(l)] is functionally similar to
\fBSELECT INTO\fR. \fBCREATE TABLE AS\fR
is the recommended syntax, since this form of \fBSELECT
INTO\fR is not available in \fBECPG\fR
or \fBPL/pgSQL\fR, because they interpret the
INTO clause differently. Furthermore,
\fBCREATE TABLE AS\fR offers a superset of the
functionality provided by \fBSELECT INTO\fR.
.PP
Prior to PostgreSQL 8.1, the table created by
\fBSELECT INTO\fR included OIDs by default. In
PostgreSQL 8.1, this is not the case
\(em to include OIDs in the new table, the default_with_oids configuration variable must be
enabled. Alternatively, \fBCREATE TABLE AS\fR can be
used with the WITH OIDS clause.
.SH "EXAMPLES"
.PP
Create a new table films_recent consisting of only
recent entries from the table films:
.sp
.nf
SELECT * INTO films_recent FROM films WHERE date_prod >= '2002-01-01';
.sp
.fi
.SH "COMPATIBILITY"
.PP
The SQL standard uses \fBSELECT INTO\fR to
represent selecting values into scalar variables of a host program,
rather than creating a new table. This indeed is the usage found
in \fBECPG\fR (see in the documentation) and
\fBPL/pgSQL\fR (see in the documentation).
The PostgreSQL usage of \fBSELECT
INTO\fR to represent table creation is historical. It is
best to use \fBCREATE TABLE AS\fR for this purpose in
new code.
.SH "SEE ALSO"
CREATE TABLE AS [\fBcreate_table_as\fR(l)]
