/***************************************************************************
 *  Copyright (C) 2009 Nippon Telegraph and Telephone Corporation
 ***************************************************************************/
/**
 * @file    target_db.h
 * @brief   Stored procedure for mnitoring target DB
 *
 */

#ifndef TARGET_DB_H
#define TARGET_DB_H

/**
 * @def     SP_NAME_STATS_AUTOVACUUMINFO
 * @brief   stored-procedure name（stats_autovacuuminfo）
 */
#define SP_NAME_STATS_AUTOVACUUMINFO  "stats_autovacuuminfo"

/**
 * @def     SP_NAME_STATS_CHECKPOINTINFO
 * @brief   stored-procedure name（stats_checkpointinfo）
 */
#define SP_NAME_STATS_CHECKPOINTINFO  "stats_checkpointinfo"

/**
 * @def     SP_NAME_STATS_HOSTINFO
 * @brief   stored-procedure name（stats_hostinfo）
 */
#define SP_NAME_STATS_HOSTINFO  "stats_hostinfo"

/**
 * @def     KEY_CPUINFO_PROCESSOR
 * @brief   cpuinfo key-word（processor）
 */
#define KEY_CPUINFO_PROCESSOR    "processor"

/**
 * @def     KEY_CPUINFO_MHZ
 * @brief   cpuinfo key-word（cpu_MHz）
 */
#define KEY_CPUINFO_MHZ    "cpu MHz"

/**
 * @def     KEY_CPUINFO_MODEL
 * @brief   cpuinfo key-word（model_name）
 */
#define KEY_CPUINFO_MODEL    "model name"

/**
 * @def     KEY_CPUINFO_BOGOMIPS
 * @brief   cpuinfo key-word（bogomips）
 */
#define KEY_CPUINFO_BOGOMIPS    "bogomips"

/**
 * @def     KEY_MEMINFO_MEMTOTAL
 * @brief   cpuinfo key-word（MemTotal）
 */
#define KEY_MEMINFO_MEMTOTAL     "MemTotal"

/**
 * @def     KEY_MEMINFO_MEMFREE
 * @brief   cpuinfo key-word（MemFree）
 */
#define KEY_MEMINFO_MEMFREE     "MemFree"

/**
 * @def     KEY_MEMINFO_BUFFERS
 * @brief   meminfo key-word（Buffers）
 */
#define KEY_MEMINFO_BUFFERS     "Buffers"

/**
 * @def     KEY_MEMINFO_CACHED
 * @brief   meminfo key-word（Cached）
 */
#define KEY_MEMINFO_CACHED     "Cached"

/**
 * @def     KEY_MEMINFO_ACTIVE
 * @brief   meminfo key-word（Active）
 */
#define KEY_MEMINFO_ACTIVE     "Active"

/**
 * @def     KEY_MEMINFO_INACTIVE
 * @brief   meminfo key-word（Inactive）
 */
#define KEY_MEMINFO_INACTIVE     "Inactive"

/**
 * @def     KEY_MEMINFO_SWAPTOTAL
 * @brief   meminfo key-word（SwapTotal）
 */
#define KEY_MEMINFO_SWAPTOTAL    "SwapTotal"

/**
 * @def     KEY_MEMINFO_SWAPFREE
 * @brief   meminfo key-word（SwapFree）
 */
#define KEY_MEMINFO_SWAPFREE     "SwapFree"

/**
 * @def     TRIM_TRGT
 * @brief   triming target character
 */
#define TRIM_TRGT         " \t"

/**
 * @def     TRIM_TRGT_KB
 * @brief   triming target character（for meminfo）
 */
#define TRIM_TRGT_KB    "kbKB \t"

/**
 * @def     Delimiter
 * @brief   delimiter
 */
#define Delimiter   '\t'

/**
 * @def     nautovacuuminfo
 * @brief   number of column（for autovacuum info）
 */
#define nautovacuuminfo 7

/**
 * @def     ncheckpointinfo
 * @brief   number of column（for checkpoint info）
 */
#define ncheckpointinfo 9

/**
 * @def     nhostinfo
 * @brief   number of column（for host info）
 */
#define nhostinfo 4

/**
 * @def     ncpuinfo
 * @brief   number of column（for cpu info）
 */
#define ncpuinfo 4


/**
 * @def     nmeminfo
 * @brief   number of column（for mem info）
 */
#define nmeminfo 8

/**
 * @def     LITOSTR_BUFSZ
 * @brief   size of string of lon-int display digit
 */
#define LITOSTR_BUFSZ    32

/**
 * @def     READBUFSIZE
 * @brief   buffer size of reading one-record
 */
#define READBUFSIZE    1024

/**
 * @def     RCODE_OK
 * @brief   return value : valid
 */
#define RCODE_OK    0

/**
 * @def     RCODE_NG_READ
 * @brief   return value : read error
 */
#define RCODE_NG_READ    1

/**
 * @def     RCODE_NG_WRITE
 * @brief   return value : write error
 */
#define RCODE_NG_WRITE    2

/**
 * @def     Cmd_select_pgdata
 * @brief   getting path to $PGDATA from pg_setting table
 */
#define Cmd_select_pgdata \
    "SELECT setting FROM pg_settings WHERE name = 'data_directory';"

/**
 * @def     get_dbname()
 * @brief   getting DB name now connecting
 */
#define get_dbname() \
    DatumGetCString(DirectFunctionCall1(current_database, BoolGetDatum(0)))

/**
 * @def     trim()
 * @brief   trimming side of string
 */ 
#define trim(_str_, _trgt_) \
    DatumGetTextP(DirectFunctionCall2(btrim, (Datum)(_str_), (Datum)(_trgt_)))

/**
 * @def     trim_right()
 * @brief   trimming tail of string
 */
#define trim_right(_str_, _trgt_) \
    DatumGetTextP(DirectFunctionCall2(rtrim, (Datum)(_str_), (Datum)(_trgt_)))

/**
 * @def     fclose_logfile()
 * @brief   macro for closing log file
 */
#define fclose_logfile(fp__) { if (fp__ != NULL) fclose(fp__); }

/**
 * @def     unlock_pg_statslog()
 * @brief   release lock for file access
 */
#define unlock_pg_statslog(fd__) { if (fd__ != -1) close(fd__); }

/**
 * @def     LOCK_FILE_PREFIX
 * @brief   path to lock file 
 */
#define LOCK_FILE_PREFIX   "/tmp/lock_pg_statsinfo"

/* reading target file                  */
/*  identification flag for ReadLogFileInfo.trgt_cd */
#define READ_TRGT_IS_NONE       -1
#define READ_TRGT_IS_LOG_FILE    0
#define READ_TRGT_IS_DONE_FILE   1

/* directory for storing some filtered-logs */
const char *dir_statslog = "pg_statslog";

/* filtered-log files and some OS-information files */
char *file_autovacuuminfo = "autovacuum.log";
char *file_checkpointinfo = "checkpoint.log";
char *path_cpuinfo = "/proc/cpuinfo";
char *path_meminfo = "/proc/meminfo";
char *suffix_done = ".done";

/**
 * @struct  FileInfo
 * @brief   ファイル情報
 * @brief   File information
 *
 *   It has some information of file attributes.
 */
typedef struct fileInfo
{
	TupleDesc  tupdesc;    /* Tuple descriptor */
	FILE  *fp;             /* File pointer */
	char   delimiter;      /* delimiter */
	char  *path;           /* relative path name（from pg_statslog）*/
	char  *fullpath;       /* absolute path name */
	int    lock_fd;        /* file descriptor of lock file */
	int    cur_line_no;    /* Number of record current reading */
} FileInfo;

/**
 * @struct  ReadLogFileInfo
 * @brief   Reading File information
 */
typedef struct readLogFileInfo
{
	int         trgt_cd;   /* identification flag. 0:filtered-log file 1:filtered-log-done file */
	FileInfo   *log_info;  /* file information (for filtered-log file)*/
	FileInfo   *done_info; /* file information (for filtered-log-done file)*/
} ReadLogFileInfo;


/**
 * @struct  AttrType
 * @brief   data type information for output
 */
typedef struct attrtype
{
	char  *name;    /* column name */
	Oid  oid;       /* OID of data type */
} AttrType;

/*
 * External declarations
 */
extern Datum stats_autovacuuminfo(PG_FUNCTION_ARGS);
extern Datum stats_checkpointinfo(PG_FUNCTION_ARGS);
extern Datum stats_kernel_info(PG_FUNCTION_ARGS);
extern Datum stats_cpu_info(PG_FUNCTION_ARGS);
extern Datum stats_mem_info(PG_FUNCTION_ARGS);

#endif   /* TARGET_DB_H */
