<?
/*
Autor (Author): Guilherme Augusto da Rocha Silva <gars.dba@gmail.com>
Criao (Created) - ISO: 2007/04/19
Verso (Version): 0.1

Desenvolvido, testado e funcionou bem em/com (Developed, tested and worked well in/with):
   - Intel Pentium IV 1.7GHZ, 256kb cache, 512mb RAM.
   - GNU/Linux with kernel 2.6, distro Debian 3.1.
   - PostgreSQL 8.1.
   - PHP 4.3.10 +  Zend Engine 1.3.0.
   - Apache 2.0.54 + PHP module.
   - Mozilla Firefox 2.0.0.3.
*/
// Classe de conexo com banco de dados.
class database {
   var $db_host,            // nome / ip do servidor
       $db_port,            // porta do servidor
       $db_name,            // nome do banco de dados
       $db_user,            // usuario de conexo
       $db_pass,            // senha de conexo
       $connect,            // id da conexo
       $result,             // id do result set da query
       $cmdtuples,          // nmero de tuplas afetadas por insert, update, delete
       $num_rows,           // nmero de linhas retornadas por query() (select)
       $num_fields,         // nmero de atributos
       $last_oid,           // ltimo oid
       $options,            // opes
       $tty,                // terminal
       $error,              // ltimo erro
       $row,                // resultado atual da linha retornada por fetch()
       $num_row,            // numero atual da linha retornada por fetch()
       $query,              // ltima query
       $affected_rows,      // resultado retornado por pg_affected_rows()
       $client_encoding,    // resultado retornado por pg_client_encoding()
       $connection_status,  // resultado retornado por pg_connection_status()
       $get_notify,         // resultado retornado por pg_get_notify()
       $get_pid,            // resultado retornado por pg_get_pid()
       $get_result,         // resultado retornado por pg_get_result()
       $last_error,         // resultado retornado por pg_last_error()
       $last_notice,        // resultado retornado por pg_last_notice()
       $last_oid,           // resultado retornado por pg_last_oid()
       $meta_data,          // resultado retornado por pg_meta_data()
       $num_fields,         // resultado retornado por pg_num_fields()
       $num_rows,           // resultado retornado por pg_num_rows()
       $options,            // resultado retornado por pg_options()
       $parameter_status,   // resultado retornado por pg_parameter_status()
       $query_params,       // resultado retornado por pg_query_params()
       $result_error_field, // resultado retornado por pg_result_error_field()
       $result_error,       // resultado retornado por pg_result_error()
       $result_seek,        // resultado retornado por pg_result_seek()
       $result_status,      // resultado retornado por pg_result_status()
       $transaction_status, // resultado retornado por pg_transaction_status()
       $tty                 // resultado retornado por pg_tty()
   ;
   function database() {
      $this->db_host = NULL;
      $this->db_port = NULL;
      $this->db_name = NULL;
      $this->db_user = NULL;
      $this->db_pass = NULL;
      $this->connect = NULL;
      $this->result = NULL;
      $this->cmdtuples = NULL;
      $this->num_rows = NULL;
      $this->num_fields = NULL;
      $this->last_oid = NULL;
      $this->options = NULL;
      $this->tty = NULL;
      $this->error = NULL;
      $this->num_row = NULL;
      $this->row = NULL;
      $this->query = NULL;
      $this->affected_rows = NULL;
      $this->client_encoding = NULL;
      $this->connection_status = NULL;
      $this->get_notify = NULL;
      $this->get_pid = NULL;
      $this->get_result = NULL;
      $this->last_error = NULL;
      $this->last_notice = NULL;
      $this->last_oid = NULL;
      $this->meta_data = NULL;
      $this->num_fields = NULL;
      $this->num_rows = NULL;
      $this->options = NULL;
      $this->parameter_status = NULL;
      $this->query_params = NULL;
      $this->result_error_field = NULL;
      $this->result_error = NULL;
      $this->result_seek = NULL;
      $this->result_status = NULL;
      $this->transaction_status = NULL;
      $this->tty = NULL;
   }
   function connect($db_host = NULL, $db_port = NULL, $db_name = NULL, $db_user = NULL, $db_pass = NULL) {
      $cfg = $GLOBALS['cfg']['db'];   // $cfg  definido em include na lib (ver em 'inc_cfg' / 'inc_var').
      $this->db_host = $db_host? $db_host:$cfg['host'];
      $this->db_port = $db_port? $db_port:$cfg['port'];
      $this->db_name = $db_name? $db_name:$cfg['name'];
      $this->db_user = $db_user? $db_user:$cfg['user'];
      $this->db_pass = $db_user? $db_user:$cfg['pass'];
      @$this->connect = pg_connect ('host = '.$this->db_host.' port = '.$this->db_port.' dbname = '.$this->db_name.' user = '.$this->db_user.' password = '.$this->db_pass);
      if (!$this->connect) {
         $this->error = $this->error();
      }
      return $this->connect;
   }
   function close() {
      $ok = pg_close($this->connect);
      if (!$ok) $this->error = $this->error();
      return $ok;
   }
   function error() {
      if (!$this->connect) {
         $this->error = ' Erro ao conectar com o banco de dados! ';
      } else {
         $this->error.= pg_errormessage($this->connect);
      }
      return $this->error;
   }
   function query($sql) {
      if ($sql) {
         $this->result = pg_exec($this->connect, $sql);
         if (!$this->result) {
            $this->error = pg_errormessage($this->connect);
         } else {
            $this->query = $sql;
            $this->num_rows = $this->num_rows();
            $this->cmdtuples = $this->cmdtuples();
         }
      }
      return $this->result;
   }
   function num_rows() {
      $this->num_rows = pg_numrows($this->result);
      return $this->num_rows;
   }
   function cmdtuples() {
      $this->cmdtuples = pg_cmdtuples($this->result);
      return $this->tuples;
   }
   function fetch($tipo = 'A') {
      if (ereg("[Aa]", $tipo)) $tipo = PGSQL_ASSOC;
      else if (ereg("[Nn]", $tipo)) $tipo = PGSQL_NUM;
      else if (ereg("[Bb]", $tipo)) $tipo = PGSQL_BOTH;
      if ($this->result) {
         if ($this->num_row == NULL) {
            $this->num_row = 0;
         } else if ($this->num_row >= $this->num_rows) {
            $this->num_row = NULL;
            return FALSE;
         }
         $this->row = pg_fetch_array($this->result, $this->num_row, $tipo);
      }
      if ($this->row) {
         $this->num_row++;
         return $this->row;
      } else {
         return FALSE;
      }
   }
   function free_result() {
      return pg_free_result($this->connect);
   }
   function version() {
      unset($this->num_row);
      unset($this->num_rows);
      unset($this->row);
      $this->query('SELECT version();');
      $this->fetch();
      return $this->row['version'] ? $this->row['version'] : NULL;
   }
   function postmaster_times() {
      unset($this->num_row);
      unset($this->num_rows);
      unset($this->row);
      $this->query('SELECT pg_postmaster_start_time() AS start, ((TIMEOFDAY()::TIMESTAMP) - pg_postmaster_start_time()) AS uptime;');
      $this->fetch();
      $traducao = array('year'  => 'ano'
                       ,'month' => 'mes'
                       ,'week'  => 'semana'
                       ,'day'   => 'dia'
                       ,'hour'  => 'hora'
                       ,'min'   => 'minuto'
                       ,'sec'   => 'segundo');
      if ($this->row['uptime']) {
         $this->row['uptime'] = trim(str_replace('@', '', $this->row['uptime']));
         foreach ($traducao as $en => $pt) {
            $this->row['uptime'] = str_replace($en, $pt, $this->row['uptime']);
         }
      }
      $aux = array('start' => ($this->row['start'] ? $this->row['start'] : NULL), 'uptime' => ($this->row['uptime'] ? $this->row['uptime'] : NULL));
      return $aux;
   }
   function trace($opcao='off') {
      if ($opcao == 'on') {
         return pg_trace('/tmp/pg_trace.log', 'w', $this->connect);
      } else if ($opcao == 'off') {
         return pg_untrace($this->connect);
      }
      return false;
   }
   function connection_status() {
      if (pg_connection_status($this->connect) === PGSQL_CONNECTION_OK) {
         return true;
      } else if (pg_connection_status($this->connect) === PGSQL_CONNECTION_BAD) {
         return false;
      }
      return null;
   }

   ////////////////////////////////////////////////////////////////////////////////
   // Funes para estatsticas
   ////////////////////////////////////////////////////////////////////////////////
   function get_databases($show_size = false, $istemplate = false, $allowconn = true, $name = null) {
      $sql = 'SELECT d.oid, d.datname, d.datdba, d.dattablespace, d.encoding, d.datistemplate, d.datallowconn, d.datacl, sd.numbackends, sd.blks_read, sd.blks_hit, CASE WHEN (sd.blks_hit + sd.blks_read) > 0 THEN ROUND(100.0 * sd.blks_hit / (sd.blks_hit + sd.blks_read), 2) ELSE 0 END AS cache_stat'
           . ($show_size? ', pg_database_size(d.oid)' : '')
           . ' FROM pg_database d'
           . ' JOIN pg_stat_database sd ON (d.oid = sd.datid)'
           . ' WHERE TRUE '
           . ($istemplate?' AND d.datistemplate IS TRUE' : ' AND d.datistemplate IS FALSE')
           . ($allowconn?' AND d.datallowconn  IS TRUE' : ' AND d.datallowconn  IS FALSE')
           . ($name?' AND d.datname = \''.$name.'\'' : '')
           . ' ORDER BY d.datname;';
   
      $this->query($sql);
      if (!$this->error and $this->num_rows) {
         $info = array();
         while ($this->fetch()) {
            $info[$this->row['oid']] = array('name' => $this->row['datname']
                                            ,'owner' => $this->row['datdba']
                                            ,'tablespace' => $this->row['dattablespace']
                                            ,'encoding' => $this->row['encoding']
                                            ,'istemplate' => $this->row['datistemplate']
                                            ,'allowconn' => $this->row['datallowconn']
                                            ,'numbackends' => $this->row['numbackends']
                                            ,'blks_read' => $this->row['blks_read']
                                            ,'blks_hit' => $this->row['blks_hit']
                                            ,'cache_stat' => $this->row['cache_stat']
                                            ,'pg_database_size' => $this->row['pg_database_size']
                                            ,'acl' => $this->row['datacl']
                                            );
         }
      }
      return $info;
   }
   function get_tablespaces($name = NULL) {
      $sql = 'SELECT oid, spcname, spcowner, spclocation, spcacl'
           . ' FROM pg_tablespace'
           . ($name?' WHERE spcname = \''.$name.'\'' : '')
           . ' ORDER BY spcname;';
      $this->query($sql);
      if (!$this->error and $this->num_rows) {
         $info = array();
         while ($this->fetch()) {
            $info[$this->row['oid']] = array('name' => $this->row['spcname']
                                            ,'owner' => $this->row['spcowner']
                                            ,'location' => $this->row['spclocation']
                                            ,'acl' => $this->row['spcacl']
                                            );
         }
      }
      return $info;
   }
   function get_schemas() {}
   function get_tables() {}
   function get_indexes() {}
   function get_sequences() {}
   function get_views() {}
   function get_users($name = NULL) {
      $sql = 'SELECT usesysid, usename, usesuper'
           . ' FROM pg_user'
           . ($name?' WHERE usename = \''.$name.'\'' : '')
           . ' ORDER BY usename;';
      $this->query($sql);
      if (!$this->error and $this->num_rows) {
         $info = array();
         while ($this->fetch()) {
            $info[$this->row['usesysid']] = array('name'=>$this->row['usename']
                                                 ,'super'=>$this->row['usesuper']
                                                 );
         }
      }
      return $info;
   }
   function get_stat_activity($datname = NULL, $usename = NULL) {
      $sql = 'SET DATESTYLE=\'SQL,DMY\'; SELECT datname, usename, client_addr, client_port, procpid, backend_start, query_start, current_query, (query_start - TIMEOFDAY()::TIMESTAMP) AS query_time, (backend_start - TIMEOFDAY()::TIMESTAMP) AS backend_time'
           . ' FROM pg_stat_activity'
           . ' WHERE datname NOT IN (\'postgres\', \'template1\')';
      if ($datname or $usename) {
         $sql .= ($datname? ' AND datname = \''.$datname.'\'' : '');
         $sql .= ($usename? ' AND usename = \''.$usename.'\'' : '');
      }
      $sql .= ' ORDER BY datname, usename, procpid;';
      $this->query($sql);
      if (!$this->error and $this->num_rows) {
         $info = array();
         while ($this->fetch()) {
            $info[] = $this->row;
         }
      }
      return $info;
   }
   function get_database_size($name = null) {
      $sql = 'SELECT datname, pg_database_size(datname)'
           . ' FROM pg_database'
           . ($name? " WHERE datname = '".$name."'" : '');
      $this->query($sql);
      if (!$this->error and $this->num_rows) {
         $info = array();
         while ($this->fetch()) {
            $info[$this->row['datname']] = $this->row['pg_database_size'];
         }
      }
      return $info;
   }
   // function affected_rows         () { pg_affected_rows         () ; }
   // function cancel_query          () { pg_cancel_query          () ; }
   // function client_encoding       () { pg_client_encoding       () ; }
   // function close                 () { pg_close                 () ; }
   // function connect               () { pg_connect               () ; }
   // function connection_busy       () { pg_connection_busy       () ; }
   // function connection_reset      () { pg_connection_reset      () ; }
   // function connection_status     () { pg_connection_status     () ; }
   // function convert               () { pg_convert               () ; }
   // function copy_from             () { pg_copy_from             () ; }
   // function copy_to               () { pg_copy_to               () ; }
   // function dbname                () { pg_dbname                () ; }
   // function delete                () { pg_delete                () ; }
   // function end_copy              () { pg_end_copy              () ; }
   // function escape_bytea          () { pg_escape_bytea          () ; }
   // function escape_string         () { pg_escape_string         () ; }
   // function execute               () { pg_execute               () ; }
   // function fetch_all_columns     () { pg_fetch_all_columns     () ; }
   // function fetch_all             () { pg_fetch_all             () ; }
   // function fetch_array           () { pg_fetch_array           () ; }
   // function fetch_assoc           () { pg_fetch_assoc           () ; }
   // function fetch_object          () { pg_fetch_object          () ; }
   // function fetch_result          () { pg_fetch_result          () ; }
   // function fetch_row             () { pg_fetch_row             () ; }
   // function field_is_null         () { pg_field_is_null         () ; }
   // function field_name            () { pg_field_name            () ; }
   // function field_num             () { pg_field_num             () ; }
   // function field_prtlen          () { pg_field_prtlen          () ; }
   // function field_size            () { pg_field_size            () ; }
   // function field_table           () { pg_field_table           () ; }
   // function field_type_oid        () { pg_field_type_oid        () ; }
   // function field_type            () { pg_field_type            () ; }
   // function free_result           () { pg_free_result           () ; }
   // function get_notify            () { pg_get_notify            () ; }
   // function get_pid               () { pg_get_pid               () ; }
   // function get_result            () { pg_get_result            () ; }
   // function host                  () { pg_host                  () ; }
   // function insert                () { pg_insert                () ; }
   // function last_error            () { pg_last_error            () ; }
   // function last_notice           () { pg_last_notice           () ; }
   // function last_oid              () { pg_last_oid              () ; }
   // function meta_data             () { pg_meta_data             () ; }
   // function num_fields            () { pg_num_fields            () ; }
   // function num_rows              () { pg_num_rows              () ; }
   // function options               () { pg_options               () ; }
   // function parameter_status      () { pg_parameter_status      () ; }
   // function pconnect              () { pg_pconnect              () ; }
   // function ping                  () { pg_ping                  () ; }
   // function port                  () { pg_port                  () ; }
   // function prepare               () { pg_prepare               () ; }
   // function put_line              () { pg_put_line              () ; }
   // function query_params          () { pg_query_params          () ; }
   // function query                 () { pg_query                 () ; }
   // function result_error_field    () { pg_result_error_field    () ; }
   // function result_error          () { pg_result_error          () ; }
   // function result_seek           () { pg_result_seek           () ; }
   // function result_status         () { pg_result_status         () ; }
   // function select                () { pg_select                () ; }
   // function send_execute          () { pg_send_execute          () ; }
   // function send_prepare          () { pg_send_prepare          () ; }
   // function send_query_params     () { pg_send_query_params     () ; }
   // function send_query            () { pg_send_query            () ; }
   // function set_client_encoding   () { pg_set_client_encoding   () ; }
   // function set_error_verbosity   () { pg_set_error_verbosity   () ; }
   // function trace                 () { pg_trace                 () ; }
   // function transaction_status    () { pg_transaction_status    () ; }
   // function tty                   () { pg_tty                   () ; }
   // function unescape_bytea        () { pg_unescape_bytea        () ; }
   // function untrace               () { pg_untrace               () ; }
   // function update                () { pg_update                () ; }
   // function version               () { pg_version               () ; }
}
?>
