<?php
/*
  Author: Greg Feigenson
  File: workorder_object.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/
class workorder {
        var $id,$start_date,$due_date,$first_name,$last_name,$phone1,$phone2,$problems,$cust_id,$staff,$notes,$status,$email;

        function workorder($start_date,$due_date,$first_name,$last_name,$phone1,$phone2,$id,$cust_id = "")
        {
                 $this->id          = $id;
		 $this->start_date  = $start_date;
                 $this->due_date    = $due_date;
                 $this->first_name  = $first_name;
                 $this->last_name   = $last_name;
                 $this->phone1      = $phone1;
                 $this->phone2      = $phone2;
                 $this->problems = "";
                 $this->staff = "";
                 $this->notes = "";
                 $this->status = 0;
		 $this->cust_id = $cust_id;
        }

        function addProblem($problem)
        {
                 $this->problems = $problem;
        }

        function isOurID($theirid,$id)
        {
                 return $theirid == $id;
        }
        
        function setStaff($staff)
        {
        	$this->staff = $staff;
        }
        
        function addNote($note)
        {
        	$this->notes = $note;
        }
        
        function setStatus($status)
        {
        	$this->status = $status;
        }
        
        //Mutators
        function setComplete()
        {
        	 $this->status = $this->status + 1;
        }
        
        /*
	PRE: Input must be a positive int
	POST: produces a string
	*/
	function checkStatus($n)
	{
		if ($n< 0)
			return "Invalid Status";

		$status = "";
		
		switch($n)
		{
				case 0:
						$status.="Open";
						break;
				case 1:
						$status.="Completed";
						break;
				case 2:
						$status.="On Hold";
						break;
				case 4:
						$status.="Debug";
						break;
				case 8:
						$status.="Unknown";
						break;
		}
			
		return $status;
	}
	
	/*
	PRE: Input must be a positive int
	POST: produces a string of HTML formatted for displaying status
	*/
	function highlightStatus($n)
	{
		if ($n< 0)
			return "Invalid Status";

		$status = "";
		
		switch($n)
		{
				case 0:
						$status.="<b>Open</b>";
						break;
				case 1:
						$status.="<b><i>Completed</i></b>";
						break;
				case 2:
						$status.="<b><font color='red'>On Hold</font></b>";
						break;
				case 4:
						$status.="<b><font color='444444'>Debug</font></b>";
						break;
				case 8:
						$status.="<u>Unknown</u>";
						break;
		}
			
		return $status;
	}
}
?>
