/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransitionDispatchNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;

public class CGTrackingDFAStateNode
extends DFAStateNode {
    private final DFACaptureGroupPartialTransition anchoredFinalStateTransition;
    private final DFACaptureGroupPartialTransition unAnchoredFinalStateTransition;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final short[] captureGroupTransitions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final short[] precedingCaptureGroupTransitions;
    @Node.Child
    private DFACaptureGroupPartialTransitionDispatchNode transitionDispatchNode;

    public CGTrackingDFAStateNode(short id, byte flags, DFAStateNode.LoopOptimizationNode loopOptimizationNode, short[] successors, CharMatcher[] matchers, AllTransitionsInOneTreeMatcher allTransitionsInOneTreeMatcher, short[] captureGroupTransitions, short[] precedingCaptureGroupTransitions, DFACaptureGroupPartialTransition anchoredFinalStateTransition, DFACaptureGroupPartialTransition unAnchoredFinalStateTransition) {
        super(id, flags, loopOptimizationNode, successors, matchers, null, allTransitionsInOneTreeMatcher);
        this.captureGroupTransitions = captureGroupTransitions;
        this.precedingCaptureGroupTransitions = precedingCaptureGroupTransitions;
        this.transitionDispatchNode = precedingCaptureGroupTransitions.length > 1 ? DFACaptureGroupPartialTransitionDispatchNode.create(precedingCaptureGroupTransitions) : null;
        this.anchoredFinalStateTransition = anchoredFinalStateTransition;
        this.unAnchoredFinalStateTransition = unAnchoredFinalStateTransition;
    }

    private CGTrackingDFAStateNode(CGTrackingDFAStateNode copy, short copyID) {
        super(copy, copyID);
        this.captureGroupTransitions = copy.captureGroupTransitions;
        this.precedingCaptureGroupTransitions = copy.precedingCaptureGroupTransitions;
        this.anchoredFinalStateTransition = copy.anchoredFinalStateTransition;
        this.unAnchoredFinalStateTransition = copy.unAnchoredFinalStateTransition;
        this.transitionDispatchNode = this.precedingCaptureGroupTransitions.length > 1 ? DFACaptureGroupPartialTransitionDispatchNode.create(this.precedingCaptureGroupTransitions) : null;
    }

    private DFACaptureGroupLazyTransition getCGTransitionToSelf(TRegexDFAExecutorNode executor) {
        return executor.getCGTransitions()[this.captureGroupTransitions[this.getLoopToSelf()]];
    }

    @Override
    public DFAStateNode createNodeSplitCopy(short copyID) {
        return new CGTrackingDFAStateNode(this, copyID);
    }

    @Override
    public void executeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((boolean)compactString);
        this.beforeFindSuccessor(locals, executor);
        if (!executor.hasNext(locals)) {
            locals.setSuccessorIndex(this.atEnd(locals, executor));
            return;
        }
        if (this.treeTransitionMatching()) {
            this.doTreeMatch(locals, executor, compactString);
            return;
        }
        if (this.checkMatch(locals, executor, compactString)) {
            int preLoopIndex = locals.getIndex();
            if (this.doIndexof(executor)) {
                int indexOfResult = this.loopOptimizationNode.getIndexOfNode().execute(locals.getInput(), preLoopIndex, locals.getCurMaxIndex(), this.loopOptimizationNode.getIndexOfChars());
                this.indexofApplyLoopReorders(locals, executor, preLoopIndex, indexOfResult < 0 ? locals.getCurMaxIndex() : indexOfResult);
                if (indexOfResult < 0) {
                    locals.setIndex(locals.getCurMaxIndex());
                    locals.setSuccessorIndex(this.atEndLoop(locals, executor, preLoopIndex));
                    return;
                }
                if (this.successors.length == 2) {
                    int successor = (this.getLoopToSelf() + 1) % 2;
                    CompilerAsserts.partialEvaluationConstant((int)successor);
                    locals.setIndex(indexOfResult + 1);
                    locals.setSuccessorIndex(successor);
                    this.successorFoundLoop(locals, executor, successor, preLoopIndex);
                    return;
                }
                locals.setIndex(indexOfResult);
            }
            while (executor.hasNext(locals)) {
                if (this.checkMatchLoop(locals, executor, compactString, preLoopIndex)) continue;
                return;
            }
            locals.setSuccessorIndex(this.atEndLoop(locals, executor, preLoopIndex));
        }
    }

    public boolean doIndexof(TRegexDFAExecutorNode executor) {
        return executor.isForward() && this.hasLoopToSelf() && this.loopOptimizationNode.getIndexOfChars() != null;
    }

    public void indexofApplyLoopReorders(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex, int postLoopIndex) {
        DFACaptureGroupPartialTransition transition = this.getCGTransitionToSelf(executor).getPartialTransitions()[this.getLoopToSelf()];
        if (transition.doesReorderResults()) {
            for (int i = preLoopIndex; i < postLoopIndex; ++i) {
                transition.apply(executor, locals.getCGData(), i);
            }
        }
    }

    private void doTreeMatch(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        char c = executor.getChar(locals);
        executor.advance(locals);
        int successor = this.getTreeMatcher().checkMatchTree(locals, executor, this, c);
        assert (this.sameResultAsRegularMatchers(executor, c, compactString, successor)) : this.toString();
        locals.setSuccessorIndex(successor);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private boolean checkMatch(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        char c = executor.getChar(locals);
        executor.advance(locals);
        for (int i = 0; i < this.matchers.length; ++i) {
            if (!this.matchers[i].execute(c, compactString)) continue;
            CompilerAsserts.partialEvaluationConstant((int)i);
            this.successorFound(locals, executor, i);
            locals.setSuccessorIndex(i);
            return this.isLoopToSelf(i);
        }
        locals.setSuccessorIndex(-1);
        return false;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private boolean checkMatchLoop(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString, int preLoopIndex) {
        char c = executor.getChar(locals);
        executor.advance(locals);
        for (int i = 0; i < this.matchers.length; ++i) {
            if (!this.matchers[i].execute(c, compactString)) continue;
            CompilerAsserts.partialEvaluationConstant((int)i);
            this.successorFoundLoop(locals, executor, i, preLoopIndex);
            locals.setSuccessorIndex(i);
            return this.isLoopToSelf(i);
        }
        locals.setSuccessorIndex(-1);
        this.noSuccessorLoop(locals, executor, preLoopIndex);
        return false;
    }

    private void beforeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (executor.isSearching()) {
            this.checkFinalState(locals, executor);
        }
    }

    @Override
    void successorFound(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int i) {
        this.applyPartialTransition(locals, executor, i);
    }

    @Override
    int atEnd(TRegexDFAExecutorLocals frame, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (this.isAnchoredFinalState() && executor.atEnd(frame)) {
            this.applyAnchoredFinalStateTransition(frame, executor);
        } else {
            this.checkFinalState(frame, executor);
        }
        return -1;
    }

    private boolean canSkipPartialTransitionsOfLoop(TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((Object)((Object)executor));
        boolean ret = this.hasLoopToSelf() && !this.getCGTransitionToSelf(executor).getPartialTransitions()[this.getLoopToSelf()].doesReorderResults();
        CompilerAsserts.partialEvaluationConstant((boolean)ret);
        return ret;
    }

    void successorFoundLoop(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int i, int preLoopIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((int)i);
        if (!this.isLoopToSelf(i)) {
            this.applyLoopTransitions(locals, executor, preLoopIndex, this.prevIndex(locals));
            if (executor.isSearching()) {
                this.checkFinalStateLoop(locals, executor);
            }
        }
        if (!this.isLoopToSelf(i) || !this.canSkipPartialTransitionsOfLoop(executor)) {
            this.getCGTransitionToSelf(executor).getPartialTransitions()[i].apply(executor, locals.getCGData(), this.prevIndex(locals));
            locals.setLastTransition(this.captureGroupTransitions[i]);
        }
    }

    void noSuccessorLoop(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        assert (executor.isSearching());
        this.applyLoopTransitions(locals, executor, preLoopIndex, this.prevIndex(locals));
        this.checkFinalStateLoop(locals, executor);
    }

    private int atEndLoop(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        this.applyLoopTransitions(locals, executor, preLoopIndex, this.curIndex(locals));
        assert (locals.getLastTransition() == this.captureGroupTransitions[this.getLoopToSelf()]);
        if (this.isAnchoredFinalState() && executor.atEnd(locals)) {
            this.getCGTransitionToSelf(executor).getTransitionToAnchoredFinalState().applyPreFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.curIndex(locals));
            this.anchoredFinalStateTransition.applyFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.nextIndex(locals));
            this.storeResult(locals, executor);
        } else if (this.isFinalState()) {
            this.getCGTransitionToSelf(executor).getTransitionToFinalState().applyPreFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.curIndex(locals));
            this.unAnchoredFinalStateTransition.applyFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.nextIndex(locals));
            this.storeResult(locals, executor);
        }
        return -1;
    }

    private void applyLoopTransitions(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex, int postLoopIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (this.canSkipPartialTransitionsOfLoop(executor) && preLoopIndex < postLoopIndex) {
            this.getCGTransitionToSelf(executor).getPartialTransitions()[this.getLoopToSelf()].apply(executor, locals.getCGData(), postLoopIndex - 1);
        }
    }

    private void checkFinalState(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (this.isFinalState()) {
            this.applyUnAnchoredFinalStateTransition(locals, executor);
        }
    }

    private void checkFinalStateLoop(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        assert (locals.getLastTransition() == this.captureGroupTransitions[this.getLoopToSelf()]);
        if (this.isFinalState()) {
            this.getCGTransitionToSelf(executor).getTransitionToFinalState().applyPreFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.prevIndex(locals));
            this.unAnchoredFinalStateTransition.applyFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.curIndex(locals));
            this.storeResult(locals, executor);
        }
    }

    public void applyPartialTransition(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int i) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((int)i);
        if (this.precedingCaptureGroupTransitions.length == 1) {
            executor.getCGTransitions()[this.precedingCaptureGroupTransitions[0]].getPartialTransitions()[i].apply(executor, locals.getCGData(), this.prevIndex(locals));
        } else {
            this.transitionDispatchNode.applyPartialTransition(locals, executor, locals.getLastTransition(), i, this.prevIndex(locals));
        }
        locals.setLastTransition(this.captureGroupTransitions[i]);
    }

    private void applyAnchoredFinalStateTransition(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        if (this.precedingCaptureGroupTransitions.length == 1) {
            executor.getCGTransitions()[this.precedingCaptureGroupTransitions[0]].getTransitionToAnchoredFinalState().applyPreFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.curIndex(locals));
        } else {
            this.transitionDispatchNode.applyPreAnchoredFinalTransition(locals, executor, locals.getLastTransition(), this.curIndex(locals));
        }
        this.anchoredFinalStateTransition.applyFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.nextIndex(locals));
        this.storeResult(locals, executor);
    }

    public void applyUnAnchoredFinalStateTransition(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        if (this.precedingCaptureGroupTransitions.length == 1) {
            executor.getCGTransitions()[this.precedingCaptureGroupTransitions[0]].getTransitionToFinalState().applyPreFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.curIndex(locals));
        } else {
            this.transitionDispatchNode.applyPreFinalTransition(locals, executor, locals.getLastTransition(), this.curIndex(locals));
        }
        this.unAnchoredFinalStateTransition.applyFinalStateTransition(executor, locals.getCGData(), executor.isSearching(), this.nextIndex(locals));
        this.storeResult(locals, executor);
    }

    private void storeResult(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (!executor.isSearching()) {
            locals.getCGData().exportResult((byte)0);
        }
        locals.setResultInt(0);
    }
}

