/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.polyglot.FunctionProxyHandler;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.ObjectProxyNode;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

final class ObjectProxyHandler
implements InvocationHandler,
HostWrapper {
    final Object obj;
    final PolyglotLanguageContext languageContext;
    final CallTarget invoke;

    ObjectProxyHandler(Object obj, PolyglotLanguageContext languageContext, Class<?> interfaceClass) {
        this.obj = obj;
        this.languageContext = languageContext;
        this.invoke = ObjectProxyNode.lookup(languageContext, obj.getClass(), interfaceClass);
    }

    @Override
    public Object getGuestObject() {
        return this.obj;
    }

    @Override
    public PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    @Override
    public PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        CompilerAsserts.neverPartOfCompilation();
        Object[] resolvedArguments = arguments == null ? HostInteropReflect.EMPTY : arguments;
        try {
            return this.invoke.call(this.languageContext, this.obj, method, resolvedArguments);
        }
        catch (UnsupportedOperationException e) {
            try {
                return FunctionProxyHandler.invokeDefault(this, proxy, method, resolvedArguments);
            }
            catch (Exception innerE) {
                e.addSuppressed(innerE);
                throw e;
            }
        }
    }
}

