/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ProxyInvokeNode;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ProxyInvokeNode.class)
final class ProxyInvokeNodeGen
extends ProxyInvokeNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private CachedMethod0Data cachedMethod0_cache;
    @Node.Child
    private CachedMethod1Data cachedMethod1_cache;

    private ProxyInvokeNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(PolyglotLanguageContext arg0Value, Object arg1Value, Method arg2Value, Object[] arg3Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedMethod0Data s1_ = this.cachedMethod0_cache;
                while (s1_ != null) {
                    if (s1_.receivers_.accepts(arg1Value) && s1_.cachedMethod_ == arg2Value) {
                        return this.doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.name_, s1_.returnClass_, s1_.returnType_, s1_.receivers_, s1_.members_, s1_.branchProfile_, s1_.toHost_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                CachedMethod1Data s2_ = this.cachedMethod1_cache;
                while (s2_ != null) {
                    if (s2_.cachedMethod_ == arg2Value) {
                        return this.cachedMethod1Boundary(state, s2_, arg0Value, arg1Value, arg2Value, arg3Value);
                    }
                    s2_ = s2_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object cachedMethod1Boundary(int state, CachedMethod1Data s2_, PolyglotLanguageContext arg0Value, Object arg1Value, Method arg2Value, Object[] arg3Value) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            Object object = this.doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s2_.cachedMethod_, s2_.name_, s2_.returnClass_, s2_.returnType_, INTEROP_LIBRARY_.getUncached(arg1Value), s2_.members_, s2_.branchProfile_, s2_.toHost_);
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Method arg2Value, Object[] arg3Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                int count1_ = 0;
                CachedMethod0Data s1_ = this.cachedMethod0_cache;
                if ((state & 1) != 0) {
                    while (!(s1_ == null || s1_.receivers_.accepts(arg1Value) && s1_.cachedMethod_ == arg2Value)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < Integer.MAX_VALUE) {
                    s1_ = super.insert(new CachedMethod0Data(this.cachedMethod0_cache));
                    s1_.cachedMethod_ = arg2Value;
                    s1_.name_ = arg2Value.getName();
                    s1_.returnClass_ = HostInteropReflect.getMethodReturnType(arg2Value);
                    s1_.returnType_ = HostInteropReflect.getMethodGenericReturnType(arg2Value);
                    s1_.receivers_ = s1_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                    s1_.members_ = s1_.insertAccessor(INTEROP_LIBRARY_.createDispatched(Integer.MAX_VALUE));
                    s1_.branchProfile_ = ConditionProfile.createBinaryProfile();
                    s1_.toHost_ = s1_.insertAccessor(ToHostNodeGen.create());
                    this.cachedMethod0_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.name_, s1_.returnClass_, s1_.returnType_, s1_.receivers_, s1_.members_, s1_.branchProfile_, s1_.toHost_);
                    return object;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                int count2_ = 0;
                CachedMethod1Data s2_ = this.cachedMethod1_cache;
                if ((state & 2) != 0) {
                    while (s2_ != null && s2_.cachedMethod_ != arg2Value) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && count2_ < Integer.MAX_VALUE) {
                    s2_ = super.insert(new CachedMethod1Data(this.cachedMethod1_cache));
                    s2_.cachedMethod_ = arg2Value;
                    s2_.name_ = arg2Value.getName();
                    s2_.returnClass_ = HostInteropReflect.getMethodReturnType(arg2Value);
                    s2_.returnType_ = HostInteropReflect.getMethodGenericReturnType(arg2Value);
                    s2_.members_ = s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(Integer.MAX_VALUE));
                    s2_.branchProfile_ = ConditionProfile.createBinaryProfile();
                    s2_.toHost_ = s2_.insertAccessor(ToHostNodeGen.create());
                    this.cachedMethod1_cache = s2_;
                    this.exclude_ = exclude |= 1;
                    this.cachedMethod0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s2_.cachedMethod_, s2_.name_, s2_.returnClass_, s2_.returnType_, INTEROP_LIBRARY_.getUncached(arg1Value), s2_.members_, s2_.branchProfile_, s2_.toHost_);
                    return object;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            CachedMethod0Data s1_ = this.cachedMethod0_cache;
            CachedMethod1Data s2_ = this.cachedMethod1_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ProxyInvokeNode create() {
        return new ProxyInvokeNodeGen();
    }

    @GeneratedBy(value=ProxyInvokeNode.class)
    private static final class CachedMethod1Data
    extends Node {
        @Node.Child
        CachedMethod1Data next_;
        @CompilerDirectives.CompilationFinal
        Method cachedMethod_;
        @CompilerDirectives.CompilationFinal
        String name_;
        @CompilerDirectives.CompilationFinal
        Class<?> returnClass_;
        @CompilerDirectives.CompilationFinal
        Type returnType_;
        @Node.Child
        InteropLibrary members_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile branchProfile_;
        @Node.Child
        ToHostNode toHost_;

        CachedMethod1Data(CachedMethod1Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }

    @GeneratedBy(value=ProxyInvokeNode.class)
    private static final class CachedMethod0Data
    extends Node {
        @Node.Child
        CachedMethod0Data next_;
        @CompilerDirectives.CompilationFinal
        Method cachedMethod_;
        @CompilerDirectives.CompilationFinal
        String name_;
        @CompilerDirectives.CompilationFinal
        Class<?> returnClass_;
        @CompilerDirectives.CompilationFinal
        Type returnType_;
        @Node.Child
        InteropLibrary receivers_;
        @Node.Child
        InteropLibrary members_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile branchProfile_;
        @Node.Child
        ToHostNode toHost_;

        CachedMethod0Data(CachedMethod0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

