/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;

public final class DFACaptureGroupTrackingData {
    public final int[] results;
    public final int[] currentResultOrder;
    public final int[] currentResult;

    public DFACaptureGroupTrackingData(int maxNumberOfNFAStates, int getNumberOfCaptureGroups, TRegexDFAExecutorProperties props) {
        if (props.isSimpleCG()) {
            this.results = new int[getNumberOfCaptureGroups * 2];
            this.currentResultOrder = null;
            this.currentResult = props.isSimpleCGMustCopy() ? new int[getNumberOfCaptureGroups * 2] : null;
        } else {
            this.results = new int[maxNumberOfNFAStates * getNumberOfCaptureGroups * 2];
            this.currentResultOrder = new int[maxNumberOfNFAStates];
            this.currentResult = new int[getNumberOfCaptureGroups * 2];
        }
    }

    public void exportResult(byte index) {
        System.arraycopy(this.results, this.currentResultOrder[Byte.toUnsignedInt(index)], this.currentResult, 0, this.currentResult.length);
    }
}

