/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DefaultToolchainManager
extends AbstractLogEnabled
implements ToolchainManager,
ToolchainManagerPrivate,
Contextualizable {
    private PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public ToolchainPrivate[] getToolchainsForType(String type) throws MisconfiguredToolchainException {
        try {
            List lst;
            PersistedToolchains pers = this.readToolchainSettings();
            Map factories = this.container.lookupMap(ToolchainFactory.class);
            ArrayList<ToolchainPrivate> toRet = new ArrayList<ToolchainPrivate>();
            if (pers != null && (lst = pers.getToolchains()) != null) {
                for (ToolchainModel toolchainModel : lst) {
                    ToolchainFactory fact = (ToolchainFactory)factories.get(toolchainModel.getType());
                    if (fact != null) {
                        toRet.add(fact.createToolchain(toolchainModel));
                        continue;
                    }
                    this.getLogger().error("Missing toolchain factory for type:" + toolchainModel.getType() + ". Possibly caused by misconfigured project.");
                }
            }
            for (ToolchainFactory toolchainFactory : factories.values()) {
                ToolchainPrivate tool = toolchainFactory.createDefaultToolchain();
                if (tool == null) continue;
                toRet.add(tool);
            }
            ToolchainPrivate[] tc = new ToolchainPrivate[toRet.size()];
            return toRet.toArray(tc);
        }
        catch (ComponentLookupException ex) {
            this.getLogger().fatalError("Error in component lookup", (Throwable)ex);
            return new ToolchainPrivate[0];
        }
    }

    public Toolchain getToolchainFromBuildContext(String type, MavenSession session) {
        Object obj;
        ToolchainModel model;
        Map context = this.retrieveContext(session);
        if ("javac".equals(type)) {
            type = "jdk";
        }
        if ((model = (ToolchainModel)(obj = context.get(DefaultToolchainManager.getStorageKey(type)))) != null) {
            try {
                ToolchainFactory fact = (ToolchainFactory)this.container.lookup(ToolchainFactory.class, type);
                return fact.createToolchain(model);
            }
            catch (ComponentLookupException ex) {
                this.getLogger().fatalError("Error in component lookup", (Throwable)ex);
            }
            catch (MisconfiguredToolchainException ex) {
                this.getLogger().error("Misconfigured toolchain.", (Throwable)ex);
            }
        }
        return null;
    }

    private MavenProject getCurrentProject(MavenSession session) {
        try {
            Method meth = session.getClass().getMethod("getCurrentProject", new Class[0]);
            return (MavenProject)meth.invoke((Object)session, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map retrieveContext(MavenSession session) {
        if (session == null) {
            return new HashMap();
        }
        PluginDescriptor desc = new PluginDescriptor();
        desc.setGroupId(PluginDescriptor.getDefaultPluginGroupId());
        desc.setArtifactId(PluginDescriptor.getDefaultPluginArtifactId((String)"toolchains"));
        MavenProject current = this.getCurrentProject(session);
        if (current != null) {
            return session.getPluginContext(desc, current);
        }
        return new HashMap();
    }

    public void storeToolchainToBuildContext(ToolchainPrivate toolchain, MavenSession session) {
        Map context = this.retrieveContext(session);
        context.put(DefaultToolchainManager.getStorageKey(toolchain.getType()), toolchain.getModel());
    }

    public static final String getStorageKey(String type) {
        return "toolchain-" + type;
    }

    private PersistedToolchains readToolchainSettings() throws MisconfiguredToolchainException {
        File tch = new File(System.getProperty("user.home"), ".m2/toolchains.xml");
        if (tch.exists()) {
            MavenToolchainsXpp3Reader reader = new MavenToolchainsXpp3Reader();
            InputStreamReader in = null;
            try {
                in = new InputStreamReader(new BufferedInputStream(new FileInputStream(tch)));
                PersistedToolchains persistedToolchains = reader.read(in);
                return persistedToolchains;
            }
            catch (Exception ex) {
                throw new MisconfiguredToolchainException("Cannot read toolchains file at " + tch.getAbsolutePath(), ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return null;
    }
}

