/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class InstallMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="installAtEnd")
    private boolean installAtEnd;
    @Parameter(property="maven.install.skip", defaultValue="false")
    private boolean skip;
    private static final String INSTALL_PROCESSED_MARKER = InstallMojo.class.getName() + ".processed";

    private void putState(State state) {
        this.getPluginContext().put(INSTALL_PROCESSED_MARKER, state.name());
    }

    private State getState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return State.valueOf((String)pluginContext.get(INSTALL_PROCESSED_MARKER));
    }

    private boolean hasState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return pluginContext.containsKey(INSTALL_PROCESSED_MARKER);
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact installation");
            this.putState(State.SKIPPED);
        } else if (!this.installAtEnd) {
            InstallRequest request = new InstallRequest();
            this.processProject(this.project, request);
            this.installProject(request);
            this.putState(State.INSTALLED);
        } else {
            this.getLog().info((CharSequence)("Deferring install for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
            this.putState(State.TO_BE_INSTALLED);
        }
        List<MavenProject> allProjectsUsingPlugin = this.getAllProjectsUsingPlugin();
        if (this.allProjectsMarked(allProjectsUsingPlugin)) {
            InstallRequest request = new InstallRequest();
            for (MavenProject reactorProject : allProjectsUsingPlugin) {
                State state = this.getState(reactorProject);
                if (state != State.TO_BE_INSTALLED) continue;
                this.processProject(reactorProject, request);
            }
            this.installProject(request);
        }
    }

    private boolean allProjectsMarked(List<MavenProject> allProjectsUsingPlugin) {
        for (MavenProject reactorProject : allProjectsUsingPlugin) {
            if (this.hasState(reactorProject)) continue;
            return false;
        }
        return true;
    }

    private List<MavenProject> getAllProjectsUsingPlugin() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject reactorProject : this.reactorProjects) {
            if (!this.hasExecution(reactorProject.getPlugin("org.apache.maven.plugins:maven-install-plugin"))) continue;
            result.add(reactorProject);
        }
        return result;
    }

    private boolean hasExecution(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        for (PluginExecution execution : plugin.getExecutions()) {
            if (execution.getGoals().isEmpty() || "none".equalsIgnoreCase(execution.getPhase())) continue;
            return true;
        }
        return false;
    }

    private void installProject(InstallRequest request) throws MojoExecutionException {
        try {
            this.repositorySystem.install(this.session.getRepositorySession(), request);
        }
        catch (InstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void processProject(MavenProject project, InstallRequest request) throws MojoExecutionException {
        if (!this.isFile(project.getFile())) {
            throw new MojoExecutionException("The project POM could not be attached");
        }
        request.addArtifact(RepositoryUtils.toArtifact((Artifact)new ProjectArtifact(project)));
        if (!"pom".equals(project.getPackaging())) {
            Artifact mavenMainArtifact = project.getArtifact();
            if (this.isFile(mavenMainArtifact.getFile())) {
                request.addArtifact(RepositoryUtils.toArtifact((Artifact)mavenMainArtifact));
            } else {
                if (!project.getAttachedArtifacts().isEmpty()) {
                    throw new MojoExecutionException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                }
                throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
            }
        }
        for (Artifact attached : project.getAttachedArtifacts()) {
            this.getLog().debug((CharSequence)("Attaching for install: " + attached.getId()));
            request.addArtifact(RepositoryUtils.toArtifact((Artifact)attached));
        }
    }

    private boolean isFile(File file) {
        return file != null && file.isFile();
    }

    private static enum State {
        SKIPPED,
        INSTALLED,
        TO_BE_INSTALLED;

    }
}

