/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.CoreLocations;
import com.oracle.truffle.object.LocationImpl;

abstract class CoreLocation
extends LocationImpl {
    protected CoreLocation() {
    }

    @Override
    public abstract Object get(DynamicObject var1, boolean var2);

    protected long getLong(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return CoreLocation.expectLong(this.get(store, condition));
    }

    protected int getInt(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return CoreLocation.expectInteger(this.get(store, condition));
    }

    protected double getDouble(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return CoreLocation.expectDouble(this.get(store, condition));
    }

    protected boolean getBoolean(DynamicObject store, boolean condition) throws UnexpectedResultException {
        return CoreLocation.expectBoolean(this.get(store, condition));
    }

    protected void set(DynamicObject store, Object value, boolean condition) throws IncompatibleLocationException {
        this.setInternal(store, value, condition);
    }

    protected abstract void setInternal(DynamicObject var1, Object var2, boolean var3) throws IncompatibleLocationException;

    protected static boolean checkShape(DynamicObject store, Shape shape) {
        return store.getShape() == shape;
    }

    @Override
    protected final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
        this.setInternal(store, value, false);
    }

    @Override
    public void set(DynamicObject store, Object value, Shape shape) throws IncompatibleLocationException, FinalLocationException {
        this.setInternal(store, value, CoreLocation.checkShape(store, shape));
    }

    @Override
    public String toString() {
        String typeString = this instanceof CoreLocations.TypedLocation ? ((CoreLocations.TypedLocation)((Object)this)).getType().getSimpleName() : "Object";
        return typeString + this.getWhereString();
    }

    static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }
}

