/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.AbstractParser;
import com.oracle.js.parser.ECMAErrors;
import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.Namespace;
import com.oracle.js.parser.Options;
import com.oracle.js.parser.ParserContext;
import com.oracle.js.parser.ParserContextBlockNode;
import com.oracle.js.parser.ParserContextBreakableNode;
import com.oracle.js.parser.ParserContextClassNode;
import com.oracle.js.parser.ParserContextFunctionNode;
import com.oracle.js.parser.ParserContextLabelNode;
import com.oracle.js.parser.ParserContextLoopNode;
import com.oracle.js.parser.ParserContextModuleNode;
import com.oracle.js.parser.ParserContextSwitchNode;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.RecompilableScriptFunctionData;
import com.oracle.js.parser.ScriptEnvironment;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenKind;
import com.oracle.js.parser.TokenLookup;
import com.oracle.js.parser.TokenStream;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BaseNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BlockStatement;
import com.oracle.js.parser.ir.BreakNode;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.CaseNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ContinueNode;
import com.oracle.js.parser.ir.DebuggerNode;
import com.oracle.js.parser.ir.EmptyNode;
import com.oracle.js.parser.ir.ErrorNode;
import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.ExportSpecifierNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.ExpressionList;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.ForNode;
import com.oracle.js.parser.ir.FromNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.IfNode;
import com.oracle.js.parser.ir.ImportClauseNode;
import com.oracle.js.parser.ir.ImportNode;
import com.oracle.js.parser.ir.ImportSpecifierNode;
import com.oracle.js.parser.ir.IndexNode;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LabelNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.js.parser.ir.NameSpaceImportNode;
import com.oracle.js.parser.ir.NamedExportsNode;
import com.oracle.js.parser.ir.NamedImportsNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.ParameterNode;
import com.oracle.js.parser.ir.PropertyKey;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.ReturnNode;
import com.oracle.js.parser.ir.RuntimeNode;
import com.oracle.js.parser.ir.Scope;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.SwitchNode;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.TernaryNode;
import com.oracle.js.parser.ir.ThrowNode;
import com.oracle.js.parser.ir.TryNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.WhileNode;
import com.oracle.js.parser.ir.WithNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.graalvm.collections.Pair;

public class Parser
extends AbstractParser {
    private static final String ARGUMENTS_NAME = "arguments";
    private static final String EVAL_NAME = "eval";
    private static final String CONSTRUCTOR_NAME = "constructor";
    private static final String PRIVATE_CONSTRUCTOR_NAME = "#constructor";
    private static final String PROTO_NAME = "__proto__";
    private static final String NEW_TARGET_NAME = "new.target";
    private static final String IMPORT_META_NAME = "import.meta";
    private static final String PROTOTYPE_NAME = "prototype";
    private static final String APPLY_NAME = "apply";
    private static final String EXEC_NAME = "$EXEC";
    private static final String ANONYMOUS_FUNCTION_NAME = ":anonymous";
    private static final String PROGRAM_NAME = ":program";
    private static final String ERROR_BINDING_NAME = ":error";
    private static final String SWITCH_BINDING_NAME = ":switch";
    private static final String ARROW_FUNCTION_NAME = ":=>";
    private static final String INITIALIZER_FUNCTION_NAME = ":initializer";
    private static final String FUNCTION_PARAMETER_CONTEXT = "function parameter";
    private static final String CATCH_PARAMETER_CONTEXT = "catch parameter";
    private static final String IMPORTED_BINDING_CONTEXT = "imported binding";
    private static final String CLASS_NAME_CONTEXT = "class name";
    private static final String VARIABLE_NAME_CONTEXT = "variable name";
    private static final String ASSIGNMENT_TARGET_CONTEXT = "assignment target";
    private static final boolean ES6_FOR_OF = Options.getBooleanProperty("parser.for.of", true);
    private static final boolean ES6_CLASS = Options.getBooleanProperty("parser.class", true);
    private static final boolean ES6_ARROW_FUNCTION = Options.getBooleanProperty("parser.arrow.function", true);
    private static final boolean ES6_REST_PARAMETER = Options.getBooleanProperty("parser.rest.parameter", true);
    private static final boolean ES6_SPREAD_ARGUMENT = Options.getBooleanProperty("parser.spread.argument", true);
    private static final boolean ES6_GENERATOR_FUNCTION = Options.getBooleanProperty("parser.generator.function", true);
    private static final boolean ES6_DESTRUCTURING = Options.getBooleanProperty("parser.destructuring", true);
    private static final boolean ES6_SPREAD_ARRAY = Options.getBooleanProperty("parser.spread.array", true);
    private static final boolean ES6_COMPUTED_PROPERTY_NAME = Options.getBooleanProperty("parser.computed.property.name", true);
    private static final boolean ES6_DEFAULT_PARAMETER = Options.getBooleanProperty("parser.default.parameter", true);
    private static final boolean ES6_NEW_TARGET = Options.getBooleanProperty("parser.new.target", true);
    private static final boolean ES8_TRAILING_COMMA = Options.getBooleanProperty("parser.trailing.comma", true);
    private static final boolean ES8_ASYNC_FUNCTION = Options.getBooleanProperty("parser.async.function", true);
    private static final boolean ES8_REST_SPREAD_PROPERTY = Options.getBooleanProperty("parser.rest.spread.property", true);
    private static final boolean ES8_FOR_AWAIT_OF = Options.getBooleanProperty("parser.for.await.of", true);
    private static final boolean ES2019_OPTIONAL_CATCH_BINDING = Options.getBooleanProperty("parser.optional.catch.binding", true);
    private static final boolean ES2020_CLASS_FIELDS = Options.getBooleanProperty("parser.class.fields", true);
    private static final int REPARSE_IS_PROPERTY_ACCESSOR = 1;
    private static final int REPARSE_IS_METHOD = 2;
    private static final int PARSE_EVAL = 4;
    private static final int PARSE_FUNCTION_CONTEXT_EVAL = 8;
    private static final String MESSAGE_INVALID_LVALUE = "invalid.lvalue";
    private static final String MESSAGE_EXPECTED_STMT = "expected.stmt";
    private static final String MESSAGE_ESCAPED_KEYWORD = "escaped.keyword";
    private static final String MESSAGE_INVALID_PROPERTY_INITIALIZER = "invalid.property.initializer";
    private static final String MESSAGE_INVALID_ARROW_PARAMETER = "invalid.arrow.parameter";
    private static final String MESSAGE_EXPECTED_OPERAND = "expected.operand";
    private static final String MESSAGE_PROPERTY_REDEFINITON = "property.redefinition";
    private final ScriptEnvironment env;
    private final boolean scripting;
    private final boolean shebang;
    private final boolean allowBigInt;
    private List<Statement> functionDeclarations;
    private final ParserContext lc = new ParserContext();
    private final List<Object> defaultNames = new ArrayList<Object>();
    private final Namespace namespace;
    protected final Lexer.LineInfoReceiver lineInfoReceiver;
    private RecompilableScriptFunctionData reparsedFunction;
    private boolean isModule;
    public static final boolean PROFILE_PARSING = Options.getBooleanProperty("parser.profiling", false);
    public static final boolean PROFILE_PARSING_PRINT = Options.getBooleanProperty("parser.profiling.print", true);

    public Parser(ScriptEnvironment env, Source source, ErrorManager errors) {
        this(env, source, errors, env.strict);
    }

    public Parser(ScriptEnvironment env, Source source, ErrorManager errors, boolean strict) {
        this(env, source, errors, strict, 0);
    }

    public Parser(ScriptEnvironment env, Source source, ErrorManager errors, boolean strict, int lineOffset) {
        super(source, errors, strict, lineOffset);
        this.env = env;
        this.namespace = new Namespace(env.getNamespace());
        this.scripting = env.scripting && env.syntaxExtensions;
        this.shebang = env.shebang || this.scripting;
        this.allowBigInt = env.allowBigInt;
        this.lineInfoReceiver = this.scripting ? new Lexer.LineInfoReceiver(){

            @Override
            public void lineInfo(int receiverLine, int receiverLinePosition) {
                Parser.this.line = receiverLine;
                Parser.this.linePosition = receiverLinePosition;
            }
        } : null;
    }

    public FunctionNode parse() {
        return this.parse(PROGRAM_NAME, 0, this.source.getLength(), 0, null);
    }

    public void setReparsedFunction(RecompilableScriptFunctionData reparsedFunction) {
        this.reparsedFunction = reparsedFunction;
    }

    private void scanFirstToken() {
        this.k = -1;
        this.next();
    }

    private void prepareLexer(int startPos, int len) {
        this.stream = new TokenStream();
        this.lexer = new Lexer(this.source, startPos, len, this.stream, this.scripting, this.env.ecmaScriptVersion, this.shebang, this.isModule, this.reparsedFunction != null, this.allowBigInt);
        this.lexer.line = this.lexer.pendingLine = this.lineOffset + 1;
        this.line = this.lineOffset;
    }

    private TokenType lookahead() {
        int i = 1;
        TokenType t;
        while ((t = this.T(this.k + i)) == TokenType.EOL || t == TokenType.COMMENT) {
            ++i;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionNode parse(String scriptName, int startPos, int len, int reparseFlags, Scope parentScope) {
        long startTime = PROFILE_PARSING ? System.nanoTime() : 0L;
        try {
            this.prepareLexer(startPos, len);
            this.scanFirstToken();
            FunctionNode functionNode = this.program(scriptName, reparseFlags, parentScope);
            return functionNode;
        }
        catch (Exception e) {
            this.handleParseException(e);
            FunctionNode functionNode = null;
            return functionNode;
        }
        finally {
            if (PROFILE_PARSING) {
                long duration = System.nanoTime() - startTime;
                if (PROFILE_PARSING_PRINT) {
                    System.out.println("Parsing: " + duration / 1000000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionNode parseModule(String moduleName, int startPos, int len) {
        boolean oldModule = this.isModule;
        boolean oldStrictMode = this.isStrictMode;
        try {
            this.isModule = true;
            this.isStrictMode = true;
            this.prepareLexer(startPos, len);
            this.scanFirstToken();
            FunctionNode functionNode = this.module(moduleName);
            return functionNode;
        }
        catch (Exception e) {
            this.handleParseException(e);
            FunctionNode functionNode = null;
            return functionNode;
        }
        finally {
            this.isStrictMode = oldStrictMode;
            this.isModule = oldModule;
        }
    }

    public FunctionNode parseModule(String moduleName) {
        return this.parseModule(moduleName, 0, this.source.getLength());
    }

    public FunctionNode parseEval(boolean functionContext, Scope parentScope) {
        return this.parse(PROGRAM_NAME, 0, this.source.getLength(), 4 | (functionContext ? 8 : 0), parentScope);
    }

    public void parseFormalParameterList() {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.scripting, this.env.ecmaScriptVersion, this.shebang, this.isModule, this.allowBigInt);
            this.scanFirstToken();
            this.formalParameterList(TokenType.EOF, false, false);
        }
        catch (Exception e) {
            this.handleParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionNode parseFunctionBody(boolean generator, boolean async) {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.scripting, this.env.ecmaScriptVersion, this.shebang, this.isModule, this.allowBigInt);
            int functionLine = this.line;
            this.scanFirstToken();
            long functionToken = Token.toDesc(TokenType.FUNCTION, 0, this.source.getLength());
            IdentNode ident = new IdentNode(functionToken, Token.descPosition(functionToken), PROGRAM_NAME);
            int functionFlags = (generator ? 0x1000000 : 0) | (async ? 0x2000000 : 0);
            ParserContextFunctionNode function = this.createParserContextFunctionNode(ident, functionToken, functionFlags, functionLine, Collections.emptyList(), 0);
            function.clearFlag(8192);
            assert (this.lc.getCurrentScope() == null);
            this.lc.push(function);
            ParserContextBlockNode body = this.newBlock(function.createBodyScope());
            this.functionDeclarations = new ArrayList<Statement>();
            try {
                this.sourceElements(0);
                this.addFunctionDeclarations(function);
            }
            finally {
                this.functionDeclarations = null;
                this.restoreBlock(body);
                this.lc.pop(function);
            }
            body.setFlag(1);
            Block functionBody = new Block(functionToken, this.finish, body.getFlags() | 0x10 | 0x20, body.getScope(), body.getStatements());
            this.expect(TokenType.EOF);
            FunctionNode functionNode = this.createFunctionNode(function, functionToken, ident, functionLine, functionBody);
            return functionNode;
        }
        catch (Exception e) {
            this.handleParseException(e);
            return null;
        }
    }

    private void handleParseException(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if (e instanceof ParserException) {
            this.errors.error((ParserException)e);
        } else {
            this.errors.error(message);
        }
        if (this.env.dumpOnError) {
            e.printStackTrace(this.env.getErr());
        }
    }

    private void recover(Exception e) {
        if (e != null) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            if (e instanceof ParserException) {
                this.errors.error((ParserException)e);
            } else {
                this.errors.error(message);
            }
            if (this.env.dumpOnError) {
                e.printStackTrace(this.env.getErr());
            }
        }
        block4: while (true) {
            switch (this.type) {
                case EOF: {
                    break block4;
                }
                case EOL: 
                case SEMICOLON: 
                case RBRACE: {
                    this.next();
                    break block4;
                }
                default: {
                    this.nextOrEOL();
                    continue block4;
                }
            }
            break;
        }
    }

    private ParserContextBlockNode newBlock() {
        Scope scope = Scope.createBlock(this.lc.getCurrentScope());
        return this.newBlock(scope);
    }

    private ParserContextBlockNode newBlock(Scope scope) {
        return this.lc.push(new ParserContextBlockNode(this.token, scope));
    }

    private ParserContextFunctionNode createParserContextFunctionNode(IdentNode ident, long functionToken, int functionFlags, int functionLine) {
        return this.createParserContextFunctionNode(ident, functionToken, functionFlags, functionLine, null, 0);
    }

    private ParserContextFunctionNode createParserContextFunctionNode(IdentNode ident, long functionToken, int functionFlags, int functionLine, List<IdentNode> parameters, int functionLength) {
        return this.createParserContextFunctionNode(ident, functionToken, functionFlags, functionLine, parameters, functionLength, null);
    }

    private ParserContextFunctionNode createParserContextFunctionNode(IdentNode ident, long functionToken, int functionFlags, int functionLine, List<IdentNode> parameters, int functionLength, Scope functionTopScope) {
        ParserContextFunctionNode parentFunction = this.lc.getCurrentFunction();
        String name = ident == null ? "" : ident.getName();
        int flags = functionFlags;
        if (this.isStrictMode) {
            flags |= 4;
        }
        if (parentFunction == null) {
            flags |= 0x2000;
            flags |= 1;
        }
        Scope parentScope = this.lc.getCurrentScope();
        return new ParserContextFunctionNode(functionToken, ident, name, this.namespace, functionLine, flags, parameters, functionLength, parentScope, functionTopScope);
    }

    private FunctionNode createFunctionNode(ParserContextFunctionNode function, long startToken, IdentNode ident, int functionLine, Block body) {
        assert (body.isFunctionBody() || body.isParameterBlock() && ((BlockStatement)body.getLastStatement()).getBlock().isFunctionBody());
        VarNode varNode = function.getBodyScope().verifyHoistedVarDeclarations();
        if (varNode != null) {
            throw this.error(ECMAErrors.getMessage("syntax.error.redeclare.variable", varNode.getName().getName()), varNode.getToken());
        }
        long lastTokenWithDelimiter = Token.withDelimiter(function.getLastToken());
        int lastTokenFinish = Token.descPosition(lastTokenWithDelimiter) + (Token.descType(lastTokenWithDelimiter) == TokenType.EOL ? 0 : Token.descLength(lastTokenWithDelimiter));
        FunctionNode functionNode = new FunctionNode(this.source, functionLine, body.getToken(), lastTokenFinish, startToken, function.getLastToken(), ident, function.getName(), function.getLength(), function.getParameterCount(), Parser.optimizeList(function.getParameters()), function.getFlags(), body, function.getEndParserState(), function.getModule(), function.getInternalName());
        return functionNode;
    }

    private ParserContextBlockNode restoreBlock(ParserContextBlockNode block) {
        block.getScope().close();
        return this.lc.pop(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block getBlock(boolean needsBraces) {
        int realFinish;
        long blockToken = this.token;
        ParserContextBlockNode newBlock = this.newBlock();
        try {
            if (needsBraces) {
                this.expect(TokenType.LBRACE);
            }
            this.statementList();
        }
        finally {
            this.restoreBlock(newBlock);
        }
        if (needsBraces) {
            this.expectDontAdvance(TokenType.RBRACE);
            realFinish = Token.descPosition(this.token) + Token.descLength(this.token);
            this.expect(TokenType.RBRACE);
        } else {
            realFinish = this.finish;
        }
        int flags = newBlock.getFlags() | (needsBraces ? 0 : 16);
        return new Block(blockToken, Math.max(realFinish, Token.descPosition(blockToken)), flags, newBlock.getScope(), newBlock.getStatements());
    }

    private List<Statement> caseStatementList() {
        ParserContextBlockNode newBlock = this.newBlock(this.lc.getCurrentScope());
        try {
            this.statementList();
        }
        finally {
            this.lc.pop(newBlock);
        }
        return newBlock.getStatements();
    }

    private Block getStatement() {
        return this.getStatement(false, false);
    }

    private Block getStatement(boolean labelledStatement, boolean mayBeFunctionDeclaration) {
        return this.getStatement(labelledStatement, mayBeFunctionDeclaration, mayBeFunctionDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block getStatement(boolean labelledStatement, boolean mayBeFunctionDeclaration, boolean maybeLabeledFunctionDeclaration) {
        if (this.type == TokenType.LBRACE) {
            return this.getBlock(true);
        }
        ParserContextBlockNode newBlock = this.newBlock();
        try {
            this.statement(false, 0, true, labelledStatement, mayBeFunctionDeclaration, maybeLabeledFunctionDeclaration);
        }
        finally {
            this.restoreBlock(newBlock);
        }
        return new Block(newBlock.getToken(), this.finish, newBlock.getFlags() | 0x10, newBlock.getScope(), newBlock.getStatements());
    }

    private IdentNode detectSpecialProperty(IdentNode ident) {
        if (Parser.isArguments(ident)) {
            return this.markArguments(ident);
        }
        return ident;
    }

    private IdentNode markArguments(IdentNode ident) {
        if (this.lc.getCurrentScope().inClassFieldInitializer()) {
            throw this.error(AbstractParser.message("arguments.in.field.initializer", new String[0]), ident.getToken());
        }
        this.lc.getCurrentNonArrowFunction().setFlag(8);
        return ident.setIsArguments();
    }

    private boolean useBlockScope() {
        return this.isES6();
    }

    private boolean isES6() {
        return this.env.ecmaScriptVersion >= 6;
    }

    private boolean isES2017() {
        return this.env.ecmaScriptVersion >= 8;
    }

    private boolean isES2020() {
        return this.env.ecmaScriptVersion >= 11;
    }

    private boolean isES2021() {
        return this.env.ecmaScriptVersion >= 12;
    }

    private boolean isClassFields() {
        return ES2020_CLASS_FIELDS && this.env.classFields;
    }

    private static boolean isArguments(String name) {
        return ARGUMENTS_NAME.equals(name);
    }

    static boolean isArguments(IdentNode ident) {
        return Parser.isArguments(ident.getName());
    }

    private static boolean checkIdentLValue(IdentNode ident) {
        return ident.tokenType().getKind() != TokenKind.KEYWORD;
    }

    private Expression verifyAssignment(long op, Expression lhs, Expression rhs, boolean inPatternPosition) {
        TokenType opType = Token.descType(op);
        Expression rhsExpr = rhs;
        switch (opType) {
            case ASSIGN: 
            case ASSIGN_INIT: 
            case ASSIGN_ADD: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_EXP: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_SHR: 
            case ASSIGN_SUB: {
                if (lhs instanceof IdentNode) {
                    IdentNode ident = (IdentNode)lhs;
                    if (!Parser.checkIdentLValue(ident) || ident.isMetaProperty()) {
                        throw this.invalidLHSError(lhs);
                    }
                    this.verifyStrictIdent(ident, ASSIGNMENT_TARGET_CONTEXT);
                    if (lhs.isParenthesized() || !Parser.isAnonymousFunctionDefinition(rhsExpr)) break;
                    rhsExpr = this.setAnonymousFunctionName(rhsExpr, ident.getName());
                    break;
                }
                if (lhs instanceof AccessNode || lhs instanceof IndexNode) {
                    if (!((BaseNode)lhs).isOptional()) break;
                    throw this.invalidLHSError(lhs);
                }
                if (!(opType != TokenType.ASSIGN && opType != TokenType.ASSIGN_INIT || !this.isDestructuringLhs(lhs) || !inPatternPosition && lhs.isParenthesized())) {
                    this.verifyDestructuringAssignmentPattern(lhs, ASSIGNMENT_TARGET_CONTEXT);
                    break;
                }
                throw this.invalidLHSError(lhs);
            }
        }
        assert (!BinaryNode.isLogical(opType));
        return new BinaryNode(op, lhs, rhsExpr);
    }

    private boolean isDestructuringLhs(Expression lhs) {
        if (lhs instanceof ObjectNode || lhs instanceof LiteralNode.ArrayLiteralNode) {
            return ES6_DESTRUCTURING && this.isES6();
        }
        return false;
    }

    private void verifyDestructuringAssignmentPattern(Expression pattern, final String contextString) {
        assert (pattern instanceof ObjectNode || pattern instanceof LiteralNode.ArrayLiteralNode);
        pattern.accept(new VerifyDestructuringPatternNodeVisitor(new LexicalContext()){

            @Override
            protected void verifySpreadElement(Expression lvalue) {
                if (!Parser.this.checkValidLValue(lvalue, contextString)) {
                    throw Parser.this.error(AbstractParser.message(Parser.MESSAGE_INVALID_LVALUE, new String[0]), lvalue.getToken());
                }
                lvalue.accept(this);
            }

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                if (!Parser.checkIdentLValue(identNode) || identNode.isMetaProperty()) {
                    throw Parser.this.error(AbstractParser.message(Parser.MESSAGE_INVALID_LVALUE, new String[0]), identNode.getToken());
                }
                Parser.this.verifyStrictIdent(identNode, contextString);
                return false;
            }

            @Override
            public boolean enterAccessNode(AccessNode accessNode) {
                if (accessNode.isOptional()) {
                    throw Parser.this.error(AbstractParser.message(Parser.MESSAGE_INVALID_LVALUE, new String[0]), accessNode.getToken());
                }
                return false;
            }

            @Override
            public boolean enterIndexNode(IndexNode indexNode) {
                if (indexNode.isOptional()) {
                    throw Parser.this.error(AbstractParser.message(Parser.MESSAGE_INVALID_LVALUE, new String[0]), indexNode.getToken());
                }
                return false;
            }

            @Override
            protected boolean enterDefault(Node node) {
                throw Parser.this.error(String.format("unexpected node in AssignmentPattern: %s", node));
            }
        });
    }

    private Expression newBinaryExpression(long op, Expression lhs, Expression rhs) {
        TokenType opType = Token.descType(op);
        if (BinaryNode.isLogical(opType)) {
            if (Parser.forbiddenNullishCoalescingUsage(opType, lhs, rhs)) {
                throw this.error(String.format("nullish coalescing operator cannot immediately contain, or be contained within, an && or || operation", new Object[0]));
            }
            return new BinaryNode(op, (Expression)new JoinPredecessorExpression(lhs), (Expression)new JoinPredecessorExpression(rhs));
        }
        return new BinaryNode(op, lhs, rhs);
    }

    private static boolean forbiddenNullishCoalescingUsage(TokenType opType, Expression lhs, Expression rhs) {
        if (opType == TokenType.NULLISHCOALESC) {
            return Parser.forbiddenNullishCoalescingChaining(lhs) || Parser.forbiddenNullishCoalescingChaining(rhs);
        }
        assert (opType == TokenType.AND || opType == TokenType.OR);
        return !lhs.isParenthesized() && lhs.isTokenType(TokenType.NULLISHCOALESC) || !rhs.isParenthesized() && rhs.isTokenType(TokenType.NULLISHCOALESC);
    }

    private static boolean forbiddenNullishCoalescingChaining(Expression expression) {
        return !expression.isParenthesized() && (expression.isTokenType(TokenType.AND) || expression.isTokenType(TokenType.OR));
    }

    private static UnaryNode incDecExpression(long firstToken, TokenType tokenType, Expression expression, boolean isPostfix) {
        assert (tokenType == TokenType.INCPREFIX || tokenType == TokenType.DECPREFIX);
        if (isPostfix) {
            long postfixToken = Token.recast(firstToken, tokenType == TokenType.DECPREFIX ? TokenType.DECPOSTFIX : TokenType.INCPOSTFIX);
            return new UnaryNode(postfixToken, expression.getStart(), Token.descPosition(firstToken) + Token.descLength(firstToken), expression);
        }
        return new UnaryNode(firstToken, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode program(String scriptName, int parseFlags, Scope parentScope) {
        int functionStart = Math.min(Token.descPosition(Token.withDelimiter(this.token)), this.finish);
        long functionToken = Token.toDesc(TokenType.FUNCTION, functionStart, this.source.getLength() - functionStart);
        int functionLine = this.line;
        Scope topScope = (parseFlags & 4) != 0 ? this.createEvalScope(parseFlags, parentScope) : Scope.createGlobal();
        IdentNode ident = null;
        ParserContextFunctionNode script = this.createParserContextFunctionNode(ident, functionToken, 1024, functionLine, Collections.emptyList(), 0, topScope);
        script.setInternalName(scriptName);
        this.lc.push(script);
        ParserContextBlockNode body = this.newBlock(topScope);
        this.functionDeclarations = new ArrayList<Statement>();
        try {
            this.sourceElements(parseFlags);
            this.addFunctionDeclarations(script);
        }
        finally {
            this.functionDeclarations = null;
            this.restoreBlock(body);
            this.lc.pop(script);
        }
        body.setFlag(1);
        Block programBody = new Block(functionToken, this.finish, body.getFlags() | 0x10 | 0x20, body.getScope(), body.getStatements());
        script.setLastToken(this.token);
        this.expect(TokenType.EOF);
        return this.createFunctionNode(script, functionToken, ident, functionLine, programBody);
    }

    private Scope createEvalScope(int parseFlags, Scope parentScope) {
        assert ((parseFlags & 4) != 0);
        if (this.isStrictMode || (parseFlags & 8) != 0) {
            return Scope.createEval(parentScope, this.isStrictMode);
        }
        return Scope.createGlobal();
    }

    private String getDirective(Node stmt) {
        LiteralNode lit;
        long litToken;
        TokenType tt;
        Expression expr;
        if (stmt instanceof ExpressionStatement && (expr = ((ExpressionStatement)stmt).getExpression()) instanceof LiteralNode && ((tt = Token.descType(litToken = (lit = (LiteralNode)expr).getToken())) == TokenType.STRING || tt == TokenType.ESCSTRING)) {
            return this.source.getString(lit.getStart() + 1, Token.descLength(litToken) - 2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceElements(int parseFlags) {
        boolean checkDirective = true;
        int functionFlags = parseFlags;
        boolean oldStrictMode = this.isStrictMode;
        try {
            while (this.type != TokenType.EOF) {
                TokenType elementType = this.type;
                if (elementType == TokenType.RBRACE) {
                    break;
                }
                try {
                    this.statement(true, functionFlags, false, false, true);
                    functionFlags = 0;
                    if (checkDirective) {
                        Statement lastStatement = elementType == TokenType.STRING || elementType == TokenType.ESCSTRING ? this.lc.getLastStatement() : null;
                        String directive = this.getDirective(lastStatement);
                        boolean bl = checkDirective = directive != null;
                        if (checkDirective && elementType == TokenType.STRING && "use strict".equals(directive)) {
                            ParserContextFunctionNode function = this.lc.getCurrentFunction();
                            if (!function.isSimpleParameterList()) {
                                throw this.error(AbstractParser.message("use.strict.non.simple.param", new String[0]), lastStatement.getToken());
                            }
                            if (!oldStrictMode) {
                                function.setFlag(4);
                                this.isStrictMode = true;
                                this.verifyUseStrict(function, parseFlags);
                            } else assert (function.isStrict());
                        }
                    }
                }
                catch (Exception e) {
                    int errorLine = this.line;
                    long errorToken = this.token;
                    this.recover(e);
                    ErrorNode errorExpr = new ErrorNode(errorToken, this.finish);
                    ExpressionStatement expressionStatement = new ExpressionStatement(errorLine, errorToken, this.finish, errorExpr);
                    this.appendStatement(expressionStatement);
                }
                this.stream.commit(this.k);
            }
        }
        finally {
            this.isStrictMode = oldStrictMode;
        }
    }

    private void verifyUseStrict(ParserContextFunctionNode function, int parseFlags) {
        for (Node node : this.lc.peek().getStatements()) {
            this.getValue(node.getToken());
        }
        if (function.getIdent() != null) {
            this.verifyStrictIdent(function.getIdent(), "function name");
        }
        for (IdentNode identNode : function.getParameters()) {
            this.verifyStrictIdent(identNode, FUNCTION_PARAMETER_CONTEXT);
        }
        if ((parseFlags & 4) != 0) {
            this.setupStrictEvalScope();
        }
    }

    private void setupStrictEvalScope() {
        ParserContextBlockNode body = this.lc.getCurrentBlock();
        assert (body.getScope().getSymbolCount() == 0);
        if (body.getScope().isGlobalScope()) {
            Scope evalScope = Scope.createEval(body.getScope(), true);
            body.setScope(evalScope);
            ParserContextFunctionNode function = this.lc.getCurrentFunction();
            function.replaceBodyScope(evalScope);
            assert (function.getBodyScope() == evalScope);
        }
    }

    private void statement() {
        this.statement(false, 0, false, false, false);
    }

    private void statement(boolean topLevel, int reparseFlags, boolean singleStatement, boolean labelledStatement, boolean mayBeFunctionDeclaration) {
        this.statement(topLevel, reparseFlags, singleStatement, labelledStatement, mayBeFunctionDeclaration, mayBeFunctionDeclaration);
    }

    private void statement(boolean topLevel, int reparseFlags, boolean singleStatement, boolean labelledStatement, boolean mayBeFunctionDeclaration, boolean maybeLabeledFunctionDeclaration) {
        switch (this.type) {
            case LBRACE: {
                this.block();
                return;
            }
            case VAR: {
                this.variableStatement(this.type);
                return;
            }
            case SEMICOLON: {
                this.emptyStatement();
                return;
            }
            case IF: {
                this.ifStatement();
                return;
            }
            case FOR: {
                this.forStatement();
                return;
            }
            case WHILE: {
                this.whileStatement();
                return;
            }
            case DO: {
                this.doStatement();
                return;
            }
            case CONTINUE: {
                this.continueStatement();
                return;
            }
            case BREAK: {
                this.breakStatement();
                return;
            }
            case RETURN: {
                this.returnStatement();
                return;
            }
            case WITH: {
                this.withStatement();
                return;
            }
            case SWITCH: {
                this.switchStatement();
                return;
            }
            case THROW: {
                this.throwStatement();
                return;
            }
            case TRY: {
                this.tryStatement();
                return;
            }
            case DEBUGGER: {
                this.debuggerStatement();
                return;
            }
            case EOF: 
            case RPAREN: 
            case RBRACKET: {
                this.expect(TokenType.SEMICOLON);
                return;
            }
            case FUNCTION: {
                if (singleStatement && (this.isStrictMode || !mayBeFunctionDeclaration)) {
                    throw this.error(AbstractParser.message(MESSAGE_EXPECTED_STMT, "function declaration"), this.token);
                }
                this.functionExpression(true, topLevel || labelledStatement, singleStatement);
                return;
            }
            case LET: {
                TokenType lookahead;
                if (!this.useBlockScope() || (lookahead = this.lookaheadOfLetDeclaration(false)) == null) break;
                if (singleStatement) {
                    if (lookahead != TokenType.LBRACKET && this.T(this.k + 1) != TokenType.IDENT) break;
                    throw this.error(AbstractParser.message(MESSAGE_EXPECTED_STMT, "let declaration"), this.token);
                }
                this.variableStatement(this.type);
                return;
            }
            case CONST: {
                if (this.useBlockScope()) {
                    if (singleStatement) {
                        throw this.error(AbstractParser.message(MESSAGE_EXPECTED_STMT, "const declaration"), this.token);
                    }
                    this.variableStatement(this.type);
                    return;
                }
                if (!this.env.constAsVar) break;
                this.variableStatement(TokenType.VAR);
                return;
            }
            case CLASS: {
                if (!ES6_CLASS || !this.isES6()) break;
                if (singleStatement) {
                    throw this.error(AbstractParser.message(MESSAGE_EXPECTED_STMT, "class declaration"), this.token);
                }
                this.classDeclaration(this.inGeneratorFunction(), this.inAsyncFunction(), false);
                return;
            }
            case ASYNC: {
                if (!this.isAsync() || !this.lookaheadIsAsyncFunction()) break;
                if (singleStatement) {
                    throw this.error(AbstractParser.message(MESSAGE_EXPECTED_STMT, "async function declaration"), this.token);
                }
                this.asyncFunctionExpression(true, topLevel || labelledStatement);
                return;
            }
        }
        if (this.isBindingIdentifier()) {
            if (!(this.T(this.k + 1) != TokenType.COLON || this.type == TokenType.YIELD && this.inGeneratorFunction() || this.isAwait() && this.inAsyncFunction())) {
                this.labelStatement(maybeLabeledFunctionDeclaration);
                return;
            }
            if (reparseFlags != 0 && this.reparseFunctionStatement(reparseFlags)) {
                return;
            }
        }
        this.expressionStatement();
    }

    private boolean reparseFunctionStatement(int reparseFlags) {
        boolean isES6Method;
        boolean allowPropertyFunction = (reparseFlags & 1) != 0;
        boolean bl = isES6Method = (reparseFlags & 2) != 0;
        if (allowPropertyFunction) {
            long propertyToken = this.token;
            int propertyLine = this.line;
            if (this.type == TokenType.GET) {
                this.next();
                this.addPropertyFunctionStatement(this.propertyGetterFunction(propertyToken, propertyLine, false, false, false));
                return true;
            }
            if (this.type == TokenType.SET) {
                this.next();
                this.addPropertyFunctionStatement(this.propertySetterFunction(propertyToken, propertyLine, false, false, false));
                return true;
            }
        } else if (isES6Method) {
            String ident = (String)this.getValue();
            IdentNode identNode = this.createIdentNode(this.token, this.finish, ident).setIsPropertyName();
            long propertyToken = this.token;
            int propertyLine = this.line;
            this.next();
            int flags = CONSTRUCTOR_NAME.equals(ident) ? 0x200000 : 0x100000;
            this.addPropertyFunctionStatement(this.propertyMethodFunction(identNode, propertyToken, propertyLine, false, flags, false, false));
            return true;
        }
        return false;
    }

    private void addPropertyFunctionStatement(PropertyFunction propertyFunction) {
        FunctionNode fn = propertyFunction.functionNode;
        this.functionDeclarations.add(new ExpressionStatement(fn.getLineNumber(), fn.getToken(), this.finish, fn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNode classDeclaration(boolean yield, boolean await, boolean defaultExport) {
        assert (this.type == TokenType.CLASS);
        int classLineNumber = this.line;
        long classToken = this.token;
        this.next();
        boolean oldStrictMode = this.isStrictMode;
        this.isStrictMode = true;
        try {
            IdentNode className = null;
            if (!defaultExport || this.isBindingIdentifier()) {
                className = this.bindingIdentifier(yield, await, CLASS_NAME_CONTEXT);
            }
            ClassNode classExpression = this.classTail(classLineNumber, classToken, className, yield, await);
            if (!defaultExport) {
                VarNode classVar = new VarNode(classLineNumber, Token.recast(classExpression.getToken(), TokenType.LET), classExpression.getFinish(), className, classExpression, 1);
                this.appendStatement(classVar);
                this.declareVar(this.lc.getCurrentScope(), classVar);
            }
            ClassNode classNode = classExpression;
            return classNode;
        }
        finally {
            this.isStrictMode = oldStrictMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNode classExpression(boolean yield, boolean await) {
        assert (this.type == TokenType.CLASS);
        int classLineNumber = this.line;
        long classToken = this.token;
        this.next();
        boolean oldStrictMode = this.isStrictMode;
        this.isStrictMode = true;
        try {
            IdentNode className = null;
            if (this.isBindingIdentifier()) {
                className = this.bindingIdentifier(yield, await, CLASS_NAME_CONTEXT);
            }
            ClassNode classNode = this.classTail(classLineNumber, classToken, className, yield, await);
            return classNode;
        }
        finally {
            this.isStrictMode = oldStrictMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNode classTail(int classLineNumber, long classToken, IdentNode className, boolean yield, boolean await) {
        assert (this.isStrictMode);
        Scope classScope = Scope.createClass(this.lc.getCurrentScope());
        if (className != null) {
            classScope.putSymbol(new Symbol(className.getName(), 2));
        }
        ParserContextClassNode classNode = new ParserContextClassNode(classScope);
        this.lc.push(classNode);
        try {
            Expression classHeritage = null;
            if (this.type == TokenType.EXTENDS) {
                this.next();
                classHeritage = this.leftHandSideExpression(yield, await);
                IdentNode invalidPrivateIdent = classNode.verifyAllPrivateIdentifiersValid(this.lc);
                if (invalidPrivateIdent != null) {
                    throw this.error(AbstractParser.message("invalid.private.ident", new String[0]), invalidPrivateIdent.getToken());
                }
            }
            this.expect(TokenType.LBRACE);
            PropertyNode constructor = null;
            ArrayList<PropertyNode> classElements = new ArrayList<PropertyNode>();
            HashMap<String, Integer> privateNameToAccessorIndexMap = new HashMap<String, Integer>();
            int instanceFieldCount = 0;
            int staticFieldCount = 0;
            boolean hasPrivateMethods = false;
            boolean hasPrivateInstanceMethods = false;
            while (true) {
                PropertyNode classElement;
                long classElementToken;
                block27: {
                    PropertyNode lastElement;
                    boolean isStatic;
                    block28: {
                        Integer existing;
                        block29: {
                            Expression classElementName;
                            boolean computed;
                            TokenType nameTokenType;
                            boolean generator;
                            boolean async;
                            int classElementLine;
                            block26: {
                                TokenType nextToken;
                                if (this.type == TokenType.SEMICOLON) {
                                    this.next();
                                    continue;
                                }
                                if (this.type == TokenType.RBRACE) break;
                                isStatic = false;
                                if (this.type == TokenType.STATIC && (nextToken = this.lookahead()) != TokenType.LPAREN && nextToken != TokenType.ASSIGN && nextToken != TokenType.SEMICOLON && nextToken != TokenType.RBRACE) {
                                    isStatic = true;
                                    this.next();
                                }
                                classElementToken = this.token;
                                classElementLine = this.line;
                                async = false;
                                if (this.isAsync() && this.lookaheadIsAsyncMethod(true)) {
                                    async = true;
                                    this.next();
                                }
                                generator = false;
                                if (this.type == TokenType.MUL && ES6_GENERATOR_FUNCTION && this.isES6()) {
                                    generator = true;
                                    this.next();
                                }
                                computed = (nameTokenType = this.type) == TokenType.LBRACKET;
                                classElementName = this.classElementName(yield, await, true);
                                if (generator || async || !this.isClassFieldDefinition(nameTokenType)) break block26;
                                classElement = this.fieldDefinition(classElementName, isStatic, classElementToken, computed);
                                if (isStatic) {
                                    ++staticFieldCount;
                                } else {
                                    ++instanceFieldCount;
                                }
                                break block27;
                            }
                            classElement = this.methodDefinition(classElementName, isStatic, classHeritage != null, generator, async, classElementToken, classElementLine, yield, await, nameTokenType, computed);
                            if (classElement.isComputed() || !classElement.isAccessor()) break block27;
                            if (!classElement.isPrivate()) break block28;
                            String privateName = classElement.getPrivateName();
                            existing = (Integer)privateNameToAccessorIndexMap.get(privateName);
                            if (existing != null) break block29;
                            privateNameToAccessorIndexMap.put(privateName, classElements.size());
                            break block27;
                        }
                        PropertyNode otherAccessor = classElements.get(existing);
                        if (isStatic != otherAccessor.isStatic()) break block27;
                        if (otherAccessor.getGetter() == null && classElement.getGetter() != null) {
                            classElements.set(existing, otherAccessor.setGetter(classElement.getGetter()));
                            continue;
                        }
                        if (otherAccessor.getSetter() == null && classElement.getSetter() != null) {
                            classElements.set(existing, otherAccessor.setSetter(classElement.getSetter()));
                            continue;
                        }
                        break block27;
                    }
                    if (!classElements.isEmpty() && !(lastElement = classElements.get(classElements.size() - 1)).isComputed() && lastElement.isAccessor() && isStatic == lastElement.isStatic() && !lastElement.isPrivate() && classElement.getKeyName().equals(lastElement.getKeyName())) {
                        PropertyNode merged = classElement.getGetter() != null ? lastElement.setGetter(classElement.getGetter()) : lastElement.setSetter(classElement.getSetter());
                        classElements.set(classElements.size() - 1, merged);
                        continue;
                    }
                }
                if (classElement.isPrivate()) {
                    hasPrivateMethods = hasPrivateMethods || !classElement.isClassField();
                    hasPrivateInstanceMethods = hasPrivateInstanceMethods || !classElement.isClassField() && !classElement.isStatic();
                    this.declarePrivateName(classScope, classElement);
                }
                if (!classElement.isStatic() && !classElement.isComputed() && classElement.getKeyName().equals(CONSTRUCTOR_NAME)) {
                    assert (!classElement.isClassField());
                    if (constructor == null) {
                        constructor = classElement;
                        continue;
                    }
                    throw this.error(AbstractParser.message("multiple.constructors", new String[0]), classElementToken);
                }
                classElements.add(classElement);
            }
            long lastToken = this.token;
            this.expect(TokenType.RBRACE);
            classElements.trimToSize();
            int classFinish = Token.descPosition(lastToken) + Token.descLength(lastToken);
            if (constructor == null) {
                constructor = this.createDefaultClassConstructor(classLineNumber, classToken, lastToken, className, classHeritage != null);
            } else {
                FunctionNode ctor = (FunctionNode)constructor.getValue();
                int flags = ctor.getFlags();
                if (className == null) {
                    flags |= 1;
                }
                constructor = constructor.setValue(new FunctionNode(ctor.getSource(), ctor.getLineNumber(), ctor.getToken(), classFinish, classToken, lastToken, className, className == null ? "" : className.getName(), ctor.getLength(), ctor.getNumOfParams(), ctor.getParameters(), flags, ctor.getBody(), ctor.getEndParserState(), ctor.getModule(), ctor.getInternalName()));
            }
            IdentNode invalidPrivateIdent = classNode.verifyAllPrivateIdentifiersValid(this.lc);
            if (invalidPrivateIdent != null) {
                throw this.error(AbstractParser.message("invalid.private.ident", new String[0]), invalidPrivateIdent.getToken());
            }
            if (hasPrivateMethods) {
                classScope.putSymbol(new Symbol(PRIVATE_CONSTRUCTOR_NAME, 1026));
            }
            classScope.close();
            ClassNode classNode2 = new ClassNode(classToken, classFinish, className, classHeritage, constructor, classElements, classScope, instanceFieldCount, staticFieldCount, hasPrivateMethods, hasPrivateInstanceMethods);
            return classNode2;
        }
        finally {
            this.lc.pop(classNode);
        }
    }

    private Expression classElementName(boolean yield, boolean await, boolean allowPrivate) {
        if (allowPrivate && this.type == TokenType.PRIVATE_IDENT) {
            return this.privateIdentifierDeclaration();
        }
        return this.propertyName(yield, await);
    }

    private IdentNode parsePrivateIdentifier() {
        assert (this.type == TokenType.PRIVATE_IDENT);
        if (!this.isClassFields() && !this.isES2021()) {
            throw this.error(AbstractParser.message("unexpected.token", this.type.getNameOrType()));
        }
        long identToken = this.token;
        String name = (String)this.getValue(identToken);
        this.next();
        return this.createIdentNode(identToken, this.finish, name).setIsPrivate();
    }

    private IdentNode privateIdentifierDeclaration() {
        IdentNode privateIdent = this.parsePrivateIdentifier();
        ParserContextClassNode currentClass = this.lc.getCurrentClass();
        if (currentClass == null) {
            throw this.error(AbstractParser.message("invalid.private.ident", new String[0]), privateIdent.getToken());
        }
        return privateIdent;
    }

    private void declarePrivateName(Scope classScope, PropertyNode classElement) {
        int privateFlags;
        int n = privateFlags = classElement.isStatic() ? 262144 : 0;
        if (!classElement.isClassField()) {
            privateFlags |= classElement.isAccessor() ? 0x100000 : 524288;
        }
        if (!classScope.addPrivateName(classElement.getPrivateName(), privateFlags)) {
            throw this.error(ECMAErrors.getMessage("syntax.error.redeclare.variable", classElement.getPrivateName()), classElement.getKey().getToken());
        }
    }

    private IdentNode privateIdentifierUse() {
        IdentNode privateIdent = this.parsePrivateIdentifier();
        ParserContextClassNode currentClass = this.lc.getCurrentClass();
        if (currentClass != null) {
            currentClass.usePrivateName(privateIdent);
        } else if (!this.lc.getCurrentScope().findPrivateName(privateIdent.getName())) {
            throw this.error(AbstractParser.message("invalid.private.ident", new String[0]), privateIdent.getToken());
        }
        return privateIdent;
    }

    private boolean isClassFieldDefinition(TokenType nameTokenType) {
        if (!this.isClassFields()) {
            return false;
        }
        switch (this.type) {
            case SEMICOLON: 
            case RBRACE: 
            case ASSIGN: {
                return true;
            }
            case LPAREN: {
                return false;
            }
        }
        if (nameTokenType == TokenType.GET || nameTokenType == TokenType.SET) {
            return false;
        }
        return this.last == TokenType.EOL;
    }

    private PropertyNode createDefaultClassConstructor(int classLineNumber, long classToken, long lastToken, IdentNode className, boolean derived) {
        List<IdentNode> parameters;
        List<Statement> statements;
        int ctorFinish = this.finish;
        long identToken = Token.recast(classToken, TokenType.IDENT);
        if (derived) {
            IdentNode superIdent = new IdentNode(identToken, ctorFinish, TokenType.SUPER.getName()).setIsDirectSuper();
            IdentNode argsIdent = new IdentNode(identToken, ctorFinish, "args").setIsRestParameter();
            UnaryNode spreadArgs = new UnaryNode(Token.recast(classToken, TokenType.SPREAD_ARGUMENT), (Expression)argsIdent);
            Expression superCall = CallNode.forCall(classLineNumber, classToken, Token.descPosition(classToken), ctorFinish, superIdent, Collections.singletonList(spreadArgs));
            statements = Collections.singletonList(new ExpressionStatement(classLineNumber, classToken, ctorFinish, superCall));
            parameters = Collections.singletonList(argsIdent);
        } else {
            statements = Collections.emptyList();
            parameters = Collections.emptyList();
        }
        int functionFlags = 0x300000;
        ParserContextFunctionNode function = this.createParserContextFunctionNode(className, classToken, functionFlags, classLineNumber, parameters, 0);
        function.setLastToken(lastToken);
        Scope scope = function.createBodyScope();
        scope.close();
        Block body = new Block(classToken, ctorFinish, 32, scope, statements);
        if (derived) {
            function.setFlag(0x400000);
            function.setFlag(262144);
        }
        if (className == null) {
            function.setFlag(1);
            function.setInternalName(CONSTRUCTOR_NAME);
        }
        PropertyNode constructor = new PropertyNode(classToken, ctorFinish, new IdentNode(identToken, ctorFinish, CONSTRUCTOR_NAME), this.createFunctionNode(function, classToken, className, classLineNumber, body), null, null, false, false, false, false);
        return constructor;
    }

    private PropertyNode methodDefinition(Expression propertyName, boolean isStatic, boolean derived, boolean generator, boolean async, long startToken, int methodLine, boolean yield, boolean await, TokenType nameTokenType, boolean computed) {
        int flags = 0x100000;
        if (!computed) {
            String name = ((PropertyKey)((Object)propertyName)).getPropertyName();
            if (!generator && nameTokenType == TokenType.GET && this.type != TokenType.LPAREN) {
                PropertyFunction methodDefinition = this.propertyGetterFunction(startToken, methodLine, yield, await, true);
                this.verifyAllowedMethodName(methodDefinition.key, isStatic, methodDefinition.computed, generator, true);
                return new PropertyNode(startToken, this.finish, methodDefinition.key, null, methodDefinition.functionNode, null, isStatic, methodDefinition.computed, false, false);
            }
            if (!generator && nameTokenType == TokenType.SET && this.type != TokenType.LPAREN) {
                PropertyFunction methodDefinition = this.propertySetterFunction(startToken, methodLine, yield, await, true);
                this.verifyAllowedMethodName(methodDefinition.key, isStatic, methodDefinition.computed, generator, true);
                return new PropertyNode(startToken, this.finish, methodDefinition.key, null, null, methodDefinition.functionNode, isStatic, methodDefinition.computed, false, false);
            }
            if (!isStatic && !generator && name.equals(CONSTRUCTOR_NAME)) {
                flags |= 0x200000;
                if (derived) {
                    flags |= 0x400000;
                }
            }
            this.verifyAllowedMethodName(propertyName, isStatic, computed, generator, false);
        }
        PropertyFunction methodDefinition = this.propertyMethodFunction(propertyName, startToken, methodLine, generator, flags, computed, async);
        return new PropertyNode(startToken, this.finish, methodDefinition.key, methodDefinition.functionNode, null, null, isStatic, computed, false, false);
    }

    private void verifyAllowedMethodName(Expression key, boolean isStatic, boolean computed, boolean generator, boolean accessor) {
        if (!computed) {
            String name = ((PropertyKey)((Object)key)).getPropertyName();
            if (!isStatic && generator && name.equals(CONSTRUCTOR_NAME)) {
                throw this.error(AbstractParser.message("generator.constructor", new String[0]), key.getToken());
            }
            if (!isStatic && accessor && name.equals(CONSTRUCTOR_NAME)) {
                throw this.error(AbstractParser.message("accessor.constructor", new String[0]), key.getToken());
            }
            if (isStatic && name.equals(PROTOTYPE_NAME)) {
                throw this.error(AbstractParser.message("static.prototype.method", new String[0]), key.getToken());
            }
            if (name.equals(PRIVATE_CONSTRUCTOR_NAME)) {
                throw this.error(AbstractParser.message("private.constructor.method", new String[0]), key.getToken());
            }
        }
    }

    private PropertyNode fieldDefinition(Expression propertyName, boolean isStatic, long startToken, boolean computed) {
        if (!computed && propertyName instanceof PropertyKey) {
            String name = ((PropertyKey)((Object)propertyName)).getPropertyName();
            if (CONSTRUCTOR_NAME.equals(name) || PRIVATE_CONSTRUCTOR_NAME.equals(name)) {
                throw this.error(AbstractParser.message("constructor.field", new String[0]), startToken);
            }
            if (isStatic && PROTOTYPE_NAME.equals(name)) {
                throw this.error(AbstractParser.message("static.prototype.field", new String[0]), startToken);
            }
        }
        FunctionNode initializer = null;
        boolean isAnonymousFunctionDefinition = false;
        if (this.type == TokenType.ASSIGN) {
            this.next();
            Pair<FunctionNode, Boolean> pair = this.fieldInitializer(this.line, startToken, propertyName, computed);
            initializer = (FunctionNode)pair.getLeft();
            isAnonymousFunctionDefinition = (Boolean)pair.getRight();
            this.endOfLine();
        }
        return new PropertyNode(startToken, this.finish, propertyName, initializer, null, null, isStatic, computed, false, false, true, isAnonymousFunctionDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<FunctionNode, Boolean> fieldInitializer(int lineNumber, long fieldToken, Expression propertyName, boolean computed) {
        Expression initializer;
        int functionFlags = 0x40100001;
        ParserContextFunctionNode function = this.createParserContextFunctionNode(null, fieldToken, functionFlags, lineNumber, Collections.emptyList(), 0);
        function.setInternalName(INITIALIZER_FUNCTION_NAME);
        this.lc.push(function);
        ParserContextBlockNode body = this.newBlock(function.createBodyScope());
        try {
            initializer = this.assignmentExpression(true, false, false);
        }
        finally {
            this.restoreBlock(body);
            this.lc.pop(function);
        }
        assert (function.getFlag(8) == 0);
        function.setLastToken(this.token);
        boolean isAnonymousFunctionDefinition = false;
        if (Parser.isAnonymousFunctionDefinition(initializer)) {
            if (!computed && propertyName instanceof IdentNode) {
                initializer = this.setAnonymousFunctionName(initializer, ((IdentNode)propertyName).getName());
            } else {
                isAnonymousFunctionDefinition = true;
            }
        }
        List<Statement> statements = Collections.singletonList(new ReturnNode(lineNumber, fieldToken, this.finish, initializer));
        Block bodyBlock = new Block(fieldToken, this.finish, 48, body.getScope(), statements);
        return Pair.create((Object)this.createFunctionNode(function, fieldToken, null, lineNumber, bodyBlock), (Object)isAnonymousFunctionDefinition);
    }

    private boolean isPropertyName(long currentToken) {
        TokenType currentType = Token.descType(currentToken);
        if (ES6_COMPUTED_PROPERTY_NAME && currentType == TokenType.LBRACKET && this.isES6()) {
            return true;
        }
        switch (currentType) {
            case IDENT: {
                return true;
            }
            case NON_OCTAL_DECIMAL: 
            case OCTAL_LEGACY: {
                if (this.isStrictMode) {
                    return false;
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case OCTAL: 
            case BINARY_NUMBER: 
            case BIGINT: 
            case FLOATING: {
                return true;
            }
        }
        return this.isIdentifierName(currentToken);
    }

    private void block() {
        this.appendStatement(new BlockStatement(this.line, this.getBlock(true)));
    }

    private void statementList() {
        block3: while (this.type != TokenType.EOF) {
            switch (this.type) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    break block3;
                }
                default: {
                    this.statement();
                    continue block3;
                }
            }
        }
    }

    private void verifyIdent(IdentNode ident, boolean yield, boolean await) {
        if (this.isES6()) {
            if (Parser.isEscapedIdent(ident) && Parser.isReservedWordSequence(ident.getName())) {
                throw this.error(AbstractParser.message(MESSAGE_ESCAPED_KEYWORD, ident.getName()), ident.getToken());
            }
            assert (!Parser.isReservedWordSequence(ident.getName())) : ident.getName();
        }
        if (yield) {
            if (ident.isTokenType(TokenType.YIELD)) {
                throw this.error(this.expectMessage(TokenType.IDENT, ident.getToken()), ident.getToken());
            }
            if (Parser.isEscapedIdent(ident) && TokenType.YIELD.getName().equals(ident.getName())) {
                throw this.error(AbstractParser.message(MESSAGE_ESCAPED_KEYWORD, ident.getName()), ident.getToken());
            }
            assert (!TokenType.YIELD.getName().equals(ident.getName()));
        }
        if (await || this.isModule) {
            if (ident.isTokenType(TokenType.AWAIT)) {
                throw this.error(this.expectMessage(TokenType.IDENT, ident.getToken()), ident.getToken());
            }
            if (Parser.isEscapedIdent(ident) && TokenType.AWAIT.getName().equals(ident.getName())) {
                throw this.error(AbstractParser.message(MESSAGE_ESCAPED_KEYWORD, ident.getName()), ident.getToken());
            }
            assert (!TokenType.AWAIT.getName().equals(ident.getName()));
        }
    }

    private static boolean isEscapedIdent(IdentNode ident) {
        return ident.getName().length() != Token.descLength(ident.getToken());
    }

    private static boolean isReservedWordSequence(String name) {
        TokenType tokenType = TokenLookup.lookupKeyword(name.toCharArray(), 0, name.length());
        return tokenType != TokenType.IDENT && !tokenType.isContextualKeyword() && !tokenType.isFutureStrict();
    }

    private void verifyStrictIdent(IdentNode ident, String contextString, boolean bindingIdentifier) {
        if (this.isStrictMode && !Parser.isValidStrictIdent(ident, bindingIdentifier)) {
            throw this.error(AbstractParser.message("strict.name", ident.getName(), contextString), ident.getToken());
        }
    }

    private void verifyStrictIdent(IdentNode ident, String contextString) {
        this.verifyStrictIdent(ident, contextString, true);
    }

    private static boolean isValidStrictIdent(IdentNode ident, boolean bindingIdentifier) {
        if (bindingIdentifier) {
            switch (ident.getName()) {
                case "eval": 
                case "arguments": {
                    return false;
                }
            }
        }
        return !Parser.isFutureStrictName(ident);
    }

    private static boolean isFutureStrictName(IdentNode ident) {
        if (ident.tokenType().isFutureStrict()) {
            return true;
        }
        if (Parser.isEscapedIdent(ident)) {
            TokenType tokenType = TokenLookup.lookupKeyword(ident.getName().toCharArray(), 0, ident.getName().length());
            return tokenType != TokenType.IDENT && tokenType.isFutureStrict();
        }
        return false;
    }

    private void variableStatement(TokenType varType) {
        this.variableDeclarationList(varType, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ForVariableDeclarationListResult variableDeclarationList(final TokenType varType, boolean isStatement, final int sourceOrder) {
        int varStart = Token.descPosition(this.token);
        assert (varType == TokenType.VAR || varType == TokenType.LET || varType == TokenType.CONST);
        this.next();
        int varFlags = 0;
        if (varType == TokenType.LET) {
            varFlags |= 1;
        } else if (varType == TokenType.CONST) {
            varFlags |= 2;
        }
        ForVariableDeclarationListResult forResult = isStatement ? null : new ForVariableDeclarationListResult();
        final Scope scope = this.lc.getCurrentScope();
        while (true) {
            boolean isDestructuring;
            final int varLine = this.line;
            final long varToken = Token.recast(this.token, varType);
            Expression binding = this.bindingIdentifierOrPattern(VARIABLE_NAME_CONTEXT);
            boolean bl = isDestructuring = !(binding instanceof IdentNode);
            if (isDestructuring) {
                final int finalVarFlags = varFlags | 0x10;
                this.verifyDestructuringBindingPattern(binding, new Consumer<IdentNode>(){

                    @Override
                    public void accept(IdentNode identNode) {
                        Parser.this.verifyStrictIdent(identNode, Parser.VARIABLE_NAME_CONTEXT);
                        if (varType != TokenType.VAR && identNode.getName().equals(TokenType.LET.getName())) {
                            throw Parser.this.error(AbstractParser.message("let.lexical.binding", new String[0]));
                        }
                        VarNode var = new VarNode(varLine, varToken, sourceOrder, identNode.getFinish(), identNode.setIsDeclaredHere(), null, finalVarFlags);
                        Parser.this.appendStatement(var);
                        Parser.this.declareVar(scope, var);
                    }
                });
            }
            Expression init = null;
            if (this.type == TokenType.ASSIGN) {
                if (!isStatement) {
                    forResult.recordDeclarationWithInitializer(varToken);
                }
                this.next();
                if (!isDestructuring) {
                    this.pushDefaultName(binding);
                }
                try {
                    init = this.assignmentExpression(isStatement);
                }
                finally {
                    if (!isDestructuring) {
                        this.popDefaultName();
                    }
                }
            } else if (isStatement) {
                if (isDestructuring) {
                    throw this.error(AbstractParser.message("missing.destructuring.assignment", new String[0]), this.token);
                }
                if (varType == TokenType.CONST) {
                    throw this.error(AbstractParser.message("missing.const.assignment", ((IdentNode)binding).getName()));
                }
            }
            if (!isDestructuring) {
                assert (init != null || varType != TokenType.CONST || !isStatement);
                IdentNode ident = (IdentNode)binding;
                if (varType != TokenType.VAR && ident.getName().equals(TokenType.LET.getName())) {
                    throw this.error(AbstractParser.message("let.lexical.binding", new String[0]));
                }
                if (!isStatement) {
                    if (init == null && varType == TokenType.CONST) {
                        forResult.recordMissingAssignment(binding);
                    }
                    forResult.addBinding(binding);
                }
                if (Parser.isAnonymousFunctionDefinition(init)) {
                    init = this.setAnonymousFunctionName(init, ident.getName());
                }
                VarNode var = new VarNode(varLine, varToken, sourceOrder, varStart, this.finish, ident.setIsDeclaredHere(), init, varFlags);
                this.appendStatement(var);
                this.declareVar(scope, var);
            } else {
                assert (init != null || !isStatement);
                if (init != null) {
                    Expression assignment = this.verifyAssignment(Token.recast(varToken, TokenType.ASSIGN_INIT), binding, init, true);
                    if (isStatement) {
                        this.appendStatement(new ExpressionStatement(varLine, assignment.getToken(), this.finish, assignment));
                    } else {
                        forResult.addAssignment(assignment);
                        forResult.addBinding(assignment);
                    }
                } else if (!isStatement) {
                    forResult.recordMissingAssignment(binding);
                    forResult.addBinding(binding);
                }
            }
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        if (isStatement) {
            this.endOfLine();
        }
        return forResult;
    }

    private void declareVar(Scope scope, VarNode varNode) {
        String name = varNode.getName().getName();
        if (this.detectVarNameConflict(scope, varNode)) {
            throw this.error(ECMAErrors.getMessage("syntax.error.redeclare.variable", name), varNode.getToken());
        }
        if (varNode.isBlockScoped()) {
            int symbolFlags = varNode.getSymbolFlags() | (scope.isSwitchBlockScope() ? 8192 : 0) | (varNode.isFunctionDeclaration() ? 65536 : 0);
            scope.putSymbol(new Symbol(name, symbolFlags));
            if (varNode.isFunctionDeclaration() && this.isAnnexB()) {
                ParserContextFunctionNode function = this.lc.getCurrentFunction();
                Scope varScope = function.getBodyScope();
                if (!(function.isStrict() || scope == varScope || !varScope.isGlobalScope() && name.equals(ARGUMENTS_NAME))) {
                    assert (!scope.isFunctionBodyScope() && !scope.isFunctionParameterScope());
                    if (varScope.getExistingSymbol(name) == null && !scope.getParent().isLexicallyDeclaredName(name, true, true)) {
                        varScope.recordHoistableBlockFunctionDeclaration(varNode, scope);
                    }
                }
            }
        } else {
            ParserContextFunctionNode function = this.lc.getCurrentFunction();
            Scope varScope = function.getBodyScope();
            int symbolFlags = varNode.getSymbolFlags() | (varNode.isHoistableDeclaration() ? 256 : 0) | (varScope.isGlobalScope() ? 8 : 0);
            if (function.hasParameterExpressions() && function.getParameterBlock().getScope().hasSymbol(name)) {
                symbolFlags |= 0x1000;
            }
            varScope.putSymbol(new Symbol(name, symbolFlags));
            if (scope != varScope) {
                assert (scope.isBlockScope());
                varScope.recordHoistedVarDeclaration(varNode, scope);
            }
        }
    }

    private boolean detectVarNameConflict(Scope scope, VarNode varNode) {
        String varName = varNode.getName().getName();
        if (varNode.isBlockScoped()) {
            Scope currentScope = scope;
            Symbol existingSymbol = currentScope.getExistingSymbol(varName);
            if (existingSymbol != null) {
                return !existingSymbol.isBlockFunctionDeclaration() || this.isStrictMode || !this.isAnnexB() || !varNode.isFunctionDeclaration();
            }
            Scope parentScope = scope.getParent();
            return parentScope != null && (parentScope.isCatchParameterScope() || parentScope.isFunctionParameterScope()) && parentScope.getExistingSymbol(varName) != null;
        }
        return scope.isLexicallyDeclaredName(varName, this.isAnnexB(), false);
    }

    private boolean isAnnexB() {
        return this.env.annexB;
    }

    private boolean isIdentifier() {
        return this.type == TokenType.IDENT || this.type.isContextualKeyword() || this.isNonStrictModeIdent();
    }

    private IdentNode identifier(boolean yield, boolean await, String contextString, boolean bindingIdentifier) {
        IdentNode ident = this.getIdent();
        this.verifyIdent(ident, yield, await);
        this.verifyStrictIdent(ident, contextString, bindingIdentifier);
        return ident;
    }

    private IdentNode identifierReference(boolean yield, boolean await) {
        return this.identifier(yield, await, "IdentifierReference", false);
    }

    private IdentNode labelIdentifier() {
        return this.identifier(this.inGeneratorFunction(), this.inAsyncFunction(), "LabelIdentifier", false);
    }

    private boolean isBindingIdentifier() {
        return this.type == TokenType.IDENT || this.type.isContextualKeyword() || this.isNonStrictModeIdent();
    }

    private IdentNode bindingIdentifier(boolean yield, boolean await, String contextString) {
        return this.identifier(yield, await, contextString, true);
    }

    private Expression bindingPattern(boolean yield, boolean await) {
        if (this.type == TokenType.LBRACKET) {
            return this.arrayLiteral(yield, await);
        }
        if (this.type == TokenType.LBRACE) {
            return this.objectLiteral(yield, await);
        }
        throw this.error(AbstractParser.message("expected.binding", new String[0]));
    }

    private Expression bindingIdentifierOrPattern(boolean yield, boolean await, String contextString) {
        if (this.isBindingIdentifier() || !ES6_DESTRUCTURING || !this.isES6()) {
            return this.bindingIdentifier(yield, await, contextString);
        }
        return this.bindingPattern(yield, await);
    }

    private Expression bindingIdentifierOrPattern(String contextString) {
        return this.bindingIdentifierOrPattern(this.inGeneratorFunction(), this.inAsyncFunction(), contextString);
    }

    private void verifyDestructuringBindingPattern(Expression pattern, final Consumer<IdentNode> identifierCallback) {
        assert (pattern instanceof ObjectNode || pattern instanceof LiteralNode.ArrayLiteralNode);
        pattern.accept(new VerifyDestructuringPatternNodeVisitor(new LexicalContext()){

            @Override
            protected void verifySpreadElement(Expression lvalue) {
                if (lvalue instanceof IdentNode) {
                    this.enterIdentNode((IdentNode)lvalue);
                } else if (Parser.this.isDestructuringLhs(lvalue)) {
                    Parser.this.verifyDestructuringBindingPattern(lvalue, identifierCallback);
                } else {
                    throw Parser.this.error("Expected a valid binding identifier", lvalue.getToken());
                }
            }

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                if (identNode.isParenthesized()) {
                    throw Parser.this.error("Expected a valid binding identifier", identNode.getToken());
                }
                identifierCallback.accept(identNode);
                return false;
            }

            @Override
            protected boolean enterDefault(Node node) {
                throw Parser.this.error(String.format("unexpected node in BindingPattern: %s", node));
            }
        });
    }

    private void emptyStatement() {
        if (this.env.emptyStatements) {
            this.appendStatement(new EmptyNode(this.line, this.token, Token.descPosition(this.token) + Token.descLength(this.token)));
        }
        this.next();
    }

    private void expressionStatement() {
        int expressionLine = this.line;
        long expressionToken = this.token;
        Expression expression = this.expression();
        if (expression != null) {
            this.endOfLine();
            ExpressionStatement expressionStatement = new ExpressionStatement(expressionLine, expressionToken, this.finish, expression);
            this.appendStatement(expressionStatement);
        } else {
            this.expect(null);
            this.endOfLine();
        }
    }

    private void ifStatement() {
        int ifLine = this.line;
        long ifToken = this.token;
        this.next();
        this.expect(TokenType.LPAREN);
        Expression test = this.expression();
        this.expect(TokenType.RPAREN);
        Block pass = this.getStatement(false, true, false);
        Block fail = null;
        if (this.type == TokenType.ELSE) {
            this.next();
            fail = this.getStatement(false, true, false);
        }
        this.appendStatement(new IfNode(ifLine, ifToken, fail != null ? fail.getFinish() : pass.getFinish(), test, pass, fail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forStatement() {
        long forToken = this.token;
        int forLine = this.line;
        int forStart = Token.descPosition(forToken);
        ParserContextBlockNode outer = this.useBlockScope() ? this.newBlock() : null;
        ParserContextLoopNode forNode = new ParserContextLoopNode();
        this.lc.push(forNode);
        Node body = null;
        Expression init = null;
        JoinPredecessorExpression test = null;
        JoinPredecessorExpression modify = null;
        ForVariableDeclarationListResult varDeclList = null;
        int flags = 0;
        boolean isForOf = false;
        boolean isForAwaitOf = false;
        try {
            this.next();
            if (this.env.syntaxExtensions && this.type == TokenType.IDENT && this.lexer.checkIdentForKeyword(this.token, "each")) {
                flags |= 2;
                this.next();
            } else if (ES8_FOR_AWAIT_OF && this.type == TokenType.AWAIT) {
                if (!this.inAsyncFunction()) {
                    throw this.error(AbstractParser.message("invalid.for.await.of", new String[0]), this.token);
                }
                isForAwaitOf = true;
                this.next();
            }
            this.expect(TokenType.LPAREN);
            Object varType = null;
            switch (this.type) {
                case VAR: {
                    varType = this.type;
                    varDeclList = this.variableDeclarationList((TokenType)((Object)varType), false, forStart);
                    break;
                }
                case SEMICOLON: {
                    break;
                }
                default: {
                    if (this.useBlockScope() && (this.type == TokenType.LET && this.lookaheadIsLetDeclaration(true) || this.type == TokenType.CONST)) {
                        varType = this.type;
                        varDeclList = this.variableDeclarationList((TokenType)((Object)varType), false, forStart);
                        if (varType != TokenType.LET || forNode.getStatements().isEmpty()) break;
                        flags |= 4;
                        break;
                    }
                    if (this.env.constAsVar && this.type == TokenType.CONST) {
                        varType = TokenType.VAR;
                        varDeclList = this.variableDeclarationList((TokenType)((Object)varType), false, forStart);
                        break;
                    }
                    init = this.expression(false, this.inGeneratorFunction(), this.inAsyncFunction(), true);
                }
            }
            switch (this.type) {
                case SEMICOLON: {
                    if (varDeclList != null) {
                        assert (init == null);
                        init = varDeclList.init;
                        if (varDeclList.missingAssignment != null) {
                            if (varDeclList.missingAssignment instanceof IdentNode) {
                                throw this.error(AbstractParser.message("missing.const.assignment", ((IdentNode)varDeclList.missingAssignment).getName()));
                            }
                            throw this.error(AbstractParser.message("missing.destructuring.assignment", new String[0]), varDeclList.missingAssignment.getToken());
                        }
                    } else if (Parser.hasCoverInitializedName(init)) {
                        throw this.error(AbstractParser.message(MESSAGE_INVALID_PROPERTY_INITIALIZER, new String[0]));
                    }
                    if ((flags & 2) != 0) {
                        throw this.error(AbstractParser.message("for.each.without.in", new String[0]), this.token);
                    }
                    this.expect(TokenType.SEMICOLON);
                    if (this.type != TokenType.SEMICOLON) {
                        test = this.joinPredecessorExpression();
                    }
                    this.expect(TokenType.SEMICOLON);
                    if (this.type == TokenType.RPAREN) break;
                    modify = this.joinPredecessorExpression();
                    break;
                }
                case OF: {
                    if (!ES8_FOR_AWAIT_OF || !isForAwaitOf) {
                        if (ES6_FOR_OF) {
                            isForOf = true;
                        } else {
                            this.expect(TokenType.SEMICOLON);
                            break;
                        }
                    }
                }
                case IN: {
                    if (isForAwaitOf) {
                        this.expectDontAdvance(TokenType.OF);
                        flags |= 0x10;
                    } else {
                        flags |= isForOf ? 8 : 1;
                    }
                    test = new JoinPredecessorExpression();
                    if (varDeclList != null) {
                        if (varDeclList.secondBinding != null) {
                            throw this.error(AbstractParser.message("many.vars.in.for.in.loop", isForOf || isForAwaitOf ? "of" : "in"), varDeclList.secondBinding.getToken());
                        }
                        if (varDeclList.declarationWithInitializerToken != 0L && (this.isStrictMode || this.type != TokenType.IN || varType != TokenType.VAR || varDeclList.init != null)) {
                            throw this.error(AbstractParser.message("for.in.loop.initializer", isForOf || isForAwaitOf ? "of" : "in"), varDeclList.declarationWithInitializerToken);
                        }
                        init = varDeclList.firstBinding;
                        assert (init instanceof IdentNode || this.isDestructuringLhs(init));
                        if (varType == TokenType.CONST) {
                            flags |= 4;
                        }
                    } else {
                        assert (init != null) : "for..in/of init expression can not be null here";
                        if (!this.checkValidLValue(init, isForOf || isForAwaitOf ? "for-of iterator" : "for-in iterator")) {
                            throw this.error(AbstractParser.message("not.lvalue.for.in.loop", isForOf || isForAwaitOf ? "of" : "in"), init.getToken());
                        }
                    }
                    this.next();
                    modify = isForOf || isForAwaitOf ? new JoinPredecessorExpression(this.assignmentExpression(true)) : this.joinPredecessorExpression();
                    break;
                }
                default: {
                    this.expect(TokenType.SEMICOLON);
                }
            }
            this.expect(TokenType.RPAREN);
            body = this.getStatement();
            this.lc.pop(forNode);
        }
        catch (Throwable throwable) {
            this.lc.pop(forNode);
            for (Statement var : forNode.getStatements()) {
                assert (var instanceof VarNode);
                this.appendStatement(var);
            }
            if (body != null) {
                this.appendStatement(new ForNode(forLine, forToken, body.getFinish(), (Block)body, forNode.getFlags() | flags, init, test, modify));
            }
            if (outer != null) {
                this.restoreBlock(outer);
                if (body != null) {
                    int blockFlags = isForOf ? 256 : 0;
                    this.appendStatement(new BlockStatement(forLine, new Block(outer.getToken(), body.getFinish(), blockFlags, outer.getScope(), outer.getStatements())));
                }
            }
            throw throwable;
        }
        for (Statement var : forNode.getStatements()) {
            assert (var instanceof VarNode);
            this.appendStatement(var);
        }
        if (body != null) {
            this.appendStatement(new ForNode(forLine, forToken, body.getFinish(), (Block)body, forNode.getFlags() | flags, init, test, modify));
        }
        if (outer != null) {
            this.restoreBlock(outer);
            if (body != null) {
                int blockFlags = isForOf ? 256 : 0;
                this.appendStatement(new BlockStatement(forLine, new Block(outer.getToken(), body.getFinish(), blockFlags, outer.getScope(), outer.getStatements())));
            }
        }
    }

    private boolean checkValidLValue(Expression init, String contextString) {
        if (init instanceof IdentNode) {
            IdentNode ident = (IdentNode)init;
            if (!Parser.checkIdentLValue(ident)) {
                return false;
            }
            if (ident.isMetaProperty()) {
                return false;
            }
            this.verifyStrictIdent(ident, contextString);
            return true;
        }
        if (init instanceof AccessNode || init instanceof IndexNode) {
            return !((BaseNode)init).isOptional();
        }
        if (this.isDestructuringLhs(init)) {
            this.verifyDestructuringAssignmentPattern(init, contextString);
            return true;
        }
        return false;
    }

    private boolean lookaheadIsLetDeclaration(boolean ofContextualKeyword) {
        return this.lookaheadOfLetDeclaration(ofContextualKeyword) != null;
    }

    private TokenType lookaheadOfLetDeclaration(boolean ofContextualKeyword) {
        assert (this.type == TokenType.LET);
        int i = 1;
        while (true) {
            TokenType t = this.T(this.k + i);
            switch (t) {
                case EOL: 
                case COMMENT: {
                    break;
                }
                case OF: {
                    if (ofContextualKeyword && ES6_FOR_OF) {
                        return null;
                    }
                }
                case LBRACE: 
                case IDENT: 
                case LBRACKET: {
                    return t;
                }
                default: {
                    if (t.isContextualKeyword() || !this.isStrictMode && t.isFutureStrict()) {
                        return t;
                    }
                    return null;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whileStatement() {
        long whileToken = this.token;
        int whileLine = this.line;
        this.next();
        ParserContextLoopNode whileNode = new ParserContextLoopNode();
        this.lc.push(whileNode);
        JoinPredecessorExpression test = null;
        Block body = null;
        try {
            this.expect(TokenType.LPAREN);
            test = this.joinPredecessorExpression();
            this.expect(TokenType.RPAREN);
            body = this.getStatement();
        }
        finally {
            this.lc.pop(whileNode);
        }
        if (body != null) {
            this.appendStatement(new WhileNode(whileLine, whileToken, body.getFinish(), false, test, body));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStatement() {
        long doToken = this.token;
        int doLine = 0;
        this.next();
        ParserContextLoopNode doWhileNode = new ParserContextLoopNode();
        this.lc.push(doWhileNode);
        Block body = null;
        JoinPredecessorExpression test = null;
        try {
            body = this.getStatement();
            this.expect(TokenType.WHILE);
            this.expect(TokenType.LPAREN);
            doLine = this.line;
            test = this.joinPredecessorExpression();
            this.expect(TokenType.RPAREN);
            if (this.type == TokenType.SEMICOLON) {
                this.endOfLine();
            }
        }
        finally {
            this.lc.pop(doWhileNode);
        }
        this.appendStatement(new WhileNode(doLine, doToken, this.finish, true, test, body));
    }

    private void continueStatement() {
        int continueLine = this.line;
        long continueToken = this.token;
        this.nextOrEOL();
        ParserContextLabelNode labelNode = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                IdentNode ident = this.labelIdentifier();
                labelNode = this.lc.findLabel(ident.getName());
                if (labelNode != null) break;
                throw this.error(AbstractParser.message("undefined.label", ident.getName()), ident.getToken());
            }
        }
        String labelName = labelNode == null ? null : labelNode.getLabelName();
        ParserContextLoopNode targetNode = this.lc.getContinueTo(labelName);
        if (targetNode == null) {
            throw this.error(AbstractParser.message("illegal.continue.stmt", new String[0]), continueToken);
        }
        this.endOfLine();
        this.appendStatement(new ContinueNode(continueLine, continueToken, this.finish, labelName));
    }

    private void breakStatement() {
        int breakLine = this.line;
        long breakToken = this.token;
        this.nextOrEOL();
        ParserContextLabelNode labelNode = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                IdentNode ident = this.labelIdentifier();
                labelNode = this.lc.findLabel(ident.getName());
                if (labelNode != null) break;
                throw this.error(AbstractParser.message("undefined.label", ident.getName()), ident.getToken());
            }
        }
        String labelName = labelNode == null ? null : labelNode.getLabelName();
        ParserContextBreakableNode targetNode = this.lc.getBreakable(labelName);
        if (targetNode == null) {
            throw this.error(AbstractParser.message("illegal.break.stmt", new String[0]), breakToken);
        }
        this.endOfLine();
        this.appendStatement(new BreakNode(breakLine, breakToken, this.finish, labelName));
    }

    private void returnStatement() {
        if (this.lc.getCurrentFunction().isScriptOrModule()) {
            throw this.error(AbstractParser.message("invalid.return", new String[0]));
        }
        int returnLine = this.line;
        long returnToken = this.token;
        this.nextOrEOL();
        Expression expression = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        this.endOfLine();
        this.appendStatement(new ReturnNode(returnLine, returnToken, this.finish, expression));
    }

    private Expression yieldExpression(boolean in, boolean await) {
        assert (this.inGeneratorFunction() && this.isES6());
        long yieldToken = this.token;
        assert (this.type == TokenType.YIELD);
        this.nextOrEOL();
        Expression expression = null;
        boolean yieldAsterisk = false;
        if (this.type == TokenType.MUL) {
            yieldAsterisk = true;
            yieldToken = Token.recast(yieldToken, TokenType.YIELD_STAR);
            this.next();
        }
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: 
            case RPAREN: 
            case RBRACKET: 
            case COMMARIGHT: 
            case COLON: {
                if (!yieldAsterisk) {
                    expression = Parser.newUndefinedLiteral(yieldToken, this.finish);
                    if (this.type != TokenType.EOL) break;
                    this.next();
                    break;
                }
            }
            default: {
                expression = this.assignmentExpression(in, true, await);
            }
        }
        return new UnaryNode(yieldToken, expression);
    }

    private Expression awaitExpression(boolean yield) {
        assert (this.inAsyncFunction());
        long awaitToken = this.token;
        this.nextOrEOL();
        Expression expression = this.unaryExpression(yield, true);
        return new UnaryNode(Token.recast(awaitToken, TokenType.AWAIT), expression);
    }

    private static UnaryNode newUndefinedLiteral(long token, int finish) {
        return new UnaryNode(Token.recast(token, TokenType.VOID), LiteralNode.newInstance(token, finish, 0));
    }

    private void withStatement() {
        int withLine = this.line;
        long withToken = this.token;
        this.next();
        if (this.isStrictMode) {
            throw this.error(AbstractParser.message("strict.no.with", new String[0]), withToken);
        }
        this.expect(TokenType.LPAREN);
        Expression expression = this.expression();
        this.expect(TokenType.RPAREN);
        Block body = this.getStatement();
        this.appendStatement(new WithNode(withLine, withToken, this.finish, expression, body));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchStatement() {
        int switchLine = this.line;
        long switchToken = this.token;
        ParserContextBlockNode outerBlock = this.useBlockScope() ? this.newBlock() : null;
        ParserContextBlockNode switchBlock = this.newBlock(Scope.createSwitchBlock(this.lc.getCurrentScope()));
        this.next();
        ParserContextSwitchNode switchNode = new ParserContextSwitchNode();
        this.lc.push(switchNode);
        int defaultCaseIndex = -1;
        ArrayList<CaseNode> cases = new ArrayList<CaseNode>();
        Node switchStatement = null;
        try {
            this.expect(TokenType.LPAREN);
            int expressionLine = this.line;
            Expression expression = this.expression();
            this.expect(TokenType.RPAREN);
            this.expect(TokenType.LBRACE);
            if (this.useBlockScope()) {
                IdentNode switchExprName = new IdentNode(Token.recast(expression.getToken(), TokenType.IDENT), expression.getFinish(), SWITCH_BINDING_NAME);
                VarNode varNode = new VarNode(expressionLine, Token.recast(expression.getToken(), TokenType.LET), expression.getFinish(), switchExprName, expression, 1);
                outerBlock.appendStatement(varNode);
                this.declareVar(outerBlock.getScope(), varNode);
                expression = switchExprName;
            }
            while (this.type != TokenType.RBRACE) {
                Expression caseExpression = null;
                long caseToken = this.token;
                switch (this.type) {
                    case CASE: {
                        this.next();
                        caseExpression = this.expression();
                        break;
                    }
                    case DEFAULT: {
                        if (defaultCaseIndex != -1) {
                            throw this.error(AbstractParser.message("duplicate.default.in.switch", new String[0]));
                        }
                        this.next();
                        break;
                    }
                    default: {
                        this.expect(TokenType.CASE);
                    }
                }
                this.expect(TokenType.COLON);
                List<Statement> statements = this.caseStatementList();
                CaseNode caseNode = new CaseNode(caseToken, this.finish, caseExpression, statements);
                if (caseExpression == null) {
                    assert (defaultCaseIndex == -1);
                    defaultCaseIndex = cases.size();
                }
                cases.add(caseNode);
            }
            this.next();
            switchStatement = new SwitchNode(switchLine, switchToken, this.finish, expression, Parser.optimizeList(cases), defaultCaseIndex);
            this.lc.pop(switchNode);
        }
        catch (Throwable throwable) {
            this.lc.pop(switchNode);
            this.restoreBlock(switchBlock);
            if (switchStatement != null) {
                this.appendStatement(new BlockStatement(switchLine, new Block(switchToken, switchStatement.getFinish(), switchBlock.getFlags() | 0x10 | 0x80, switchBlock.getScope(), new Statement[]{switchStatement})));
            }
            if (outerBlock != null) {
                this.restoreBlock(outerBlock);
                if (switchStatement != null) {
                    this.appendStatement(new BlockStatement(switchLine, new Block(switchToken, switchStatement.getFinish(), outerBlock.getFlags() | 0x10, outerBlock.getScope(), outerBlock.getStatements())));
                }
            }
            throw throwable;
        }
        this.restoreBlock(switchBlock);
        if (switchStatement != null) {
            this.appendStatement(new BlockStatement(switchLine, new Block(switchToken, switchStatement.getFinish(), switchBlock.getFlags() | 0x10 | 0x80, switchBlock.getScope(), new Statement[]{switchStatement})));
        }
        if (outerBlock != null) {
            this.restoreBlock(outerBlock);
            if (switchStatement != null) {
                this.appendStatement(new BlockStatement(switchLine, new Block(switchToken, switchStatement.getFinish(), outerBlock.getFlags() | 0x10, outerBlock.getScope(), outerBlock.getStatements())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void labelStatement(boolean mayBeFunctionDeclaration) {
        long labelToken = this.token;
        IdentNode ident = this.labelIdentifier();
        this.expect(TokenType.COLON);
        if (this.lc.findLabel(ident.getName()) != null) {
            throw this.error(AbstractParser.message("duplicate.label", ident.getName()), labelToken);
        }
        ParserContextLabelNode labelNode = new ParserContextLabelNode(ident.getName());
        Block body = null;
        try {
            this.lc.push(labelNode);
            body = this.getStatement(true, mayBeFunctionDeclaration);
        }
        finally {
            this.lc.pop(labelNode);
        }
        this.appendStatement(new LabelNode(this.line, labelToken, this.finish, ident.getName(), body));
    }

    private void throwStatement() {
        int throwLine = this.line;
        long throwToken = this.token;
        this.nextOrEOL();
        Expression expression = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        if (expression == null) {
            throw this.error(AbstractParser.message(MESSAGE_EXPECTED_OPERAND, this.type.getNameOrType()));
        }
        this.endOfLine();
        this.appendStatement(new ThrowNode(throwLine, throwToken, this.finish, expression, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStatement() {
        int tryLine = this.line;
        long tryToken = this.token;
        this.next();
        int startLine = this.line;
        ParserContextBlockNode outer = this.newBlock();
        try {
            Block tryBody = this.getBlock(true);
            ArrayList<Block> catchBlocks = new ArrayList<Block>();
            while (this.type == TokenType.CATCH) {
                Expression ifExpression;
                Expression pattern;
                IdentNode exception;
                int catchLine = this.line;
                long catchToken = this.token;
                this.next();
                if (this.type == TokenType.LBRACE && ES2019_OPTIONAL_CATCH_BINDING) {
                    catchBlocks.add(this.catchBlock(catchToken, catchLine, null, null, null));
                    break;
                }
                this.expect(TokenType.LPAREN);
                Expression catchParameter = this.bindingIdentifierOrPattern(CATCH_PARAMETER_CONTEXT);
                if (catchParameter instanceof IdentNode) {
                    exception = ((IdentNode)catchParameter).setIsCatchParameter();
                    pattern = null;
                } else {
                    exception = new IdentNode(Token.recast(catchParameter.getToken(), TokenType.IDENT), catchParameter.getFinish(), ERROR_BINDING_NAME).setIsCatchParameter();
                    pattern = catchParameter;
                }
                if (this.env.syntaxExtensions && this.type == TokenType.IF) {
                    this.next();
                    ifExpression = this.expression();
                } else {
                    ifExpression = null;
                }
                this.expect(TokenType.RPAREN);
                catchBlocks.add(this.catchBlock(catchToken, catchLine, exception, pattern, ifExpression));
                if (ifExpression != null) continue;
                break;
            }
            Block finallyStatements = null;
            if (this.type == TokenType.FINALLY) {
                this.next();
                finallyStatements = this.getBlock(true);
            }
            if (catchBlocks.isEmpty() && finallyStatements == null) {
                throw this.error(AbstractParser.message("missing.catch.or.finally", new String[0]), tryToken);
            }
            TryNode tryNode = new TryNode(tryLine, tryToken, this.finish, tryBody, Parser.optimizeList(catchBlocks), finallyStatements);
            assert (this.lc.peek() == outer);
            this.appendStatement(tryNode);
        }
        finally {
            this.restoreBlock(outer);
        }
        this.appendStatement(new BlockStatement(startLine, new Block(tryToken, this.finish, outer.getFlags() | 0x10, outer.getScope(), outer.getStatements())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block catchBlock(long catchToken, final int catchLine, IdentNode exception, Expression pattern, Expression ifExpression) {
        final ParserContextBlockNode catchBlock = this.newBlock(Scope.createCatch(this.lc.getCurrentScope()));
        try {
            if (exception != null) {
                VarNode exceptionVar = new VarNode(catchLine, Token.recast(exception.getToken(), TokenType.LET), exception.getFinish(), exception.setIsDeclaredHere(), null, 1);
                this.appendStatement(exceptionVar);
                this.declareVar(catchBlock.getScope(), exceptionVar);
                if (pattern != null) {
                    this.verifyDestructuringBindingPattern(pattern, new Consumer<IdentNode>(){

                        @Override
                        public void accept(IdentNode identNode) {
                            Parser.this.verifyStrictIdent(identNode, Parser.CATCH_PARAMETER_CONTEXT);
                            int varFlags = 17;
                            VarNode var = new VarNode(catchLine, Token.recast(identNode.getToken(), TokenType.LET), identNode.getFinish(), identNode.setIsDeclaredHere(), null, 17);
                            Parser.this.appendStatement(var);
                            Parser.this.declareVar(catchBlock.getScope(), var);
                        }
                    });
                }
            }
            Block catchBody = this.getBlock(true);
            CatchNode catchNode = new CatchNode(catchLine, catchToken, this.finish, exception, pattern, ifExpression, catchBody, false);
            this.appendStatement(catchNode);
        }
        finally {
            this.restoreBlock(catchBlock);
        }
        int catchFinish = Math.max(this.finish, Token.descPosition(catchBlock.getToken()));
        return new Block(catchBlock.getToken(), catchFinish, catchBlock.getFlags() | 0x10, catchBlock.getScope(), catchBlock.getStatements());
    }

    private void debuggerStatement() {
        int debuggerLine = this.line;
        long debuggerToken = this.token;
        this.next();
        this.endOfLine();
        this.appendStatement(new DebuggerNode(debuggerLine, debuggerToken, this.finish));
    }

    private Expression primaryExpression(boolean yield, boolean await) {
        int primaryLine = this.line;
        long primaryToken = this.token;
        switch (this.type) {
            case THIS: {
                String name = this.type.getName();
                this.next();
                this.markThis();
                return new IdentNode(primaryToken, this.finish, name).setIsThis();
            }
            case IDENT: {
                IdentNode ident = this.identifierReference(yield, await);
                if (ident == null) break;
                return this.detectSpecialProperty(ident);
            }
            case NON_OCTAL_DECIMAL: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.nonoctaldecimal", new String[0]), this.token);
                }
            }
            case OCTAL_LEGACY: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case OCTAL: 
            case BINARY_NUMBER: 
            case BIGINT: 
            case FLOATING: 
            case REGEX: 
            case XML: {
                return this.getLiteral();
            }
            case EXECSTRING: {
                return this.execString(primaryLine, primaryToken);
            }
            case FALSE: {
                this.next();
                return LiteralNode.newInstance(primaryToken, this.finish, false);
            }
            case TRUE: {
                this.next();
                return LiteralNode.newInstance(primaryToken, this.finish, true);
            }
            case NULL: {
                this.next();
                return LiteralNode.newInstance(primaryToken, this.finish);
            }
            case LBRACKET: {
                return this.arrayLiteral(yield, await);
            }
            case LBRACE: {
                return this.objectLiteral(yield, await);
            }
            case LPAREN: {
                return this.parenthesizedExpressionAndArrowParameterList(yield, await);
            }
            case TEMPLATE: 
            case TEMPLATE_HEAD: {
                return this.templateLiteral(yield, await);
            }
            default: {
                if (this.lexer.scanLiteral(primaryToken, this.type, this.lineInfoReceiver)) {
                    this.next();
                    return this.getLiteral();
                }
                if (!this.type.isContextualKeyword() && !this.isNonStrictModeIdent()) break;
                return this.identifierReference(yield, await);
            }
        }
        throw this.error(AbstractParser.message(MESSAGE_EXPECTED_OPERAND, this.type.getNameOrType()));
    }

    private Expression execString(int primaryLine, long primaryToken) {
        IdentNode execIdent = new IdentNode(primaryToken, this.finish, EXEC_NAME);
        this.next();
        this.expect(TokenType.LBRACE);
        List<Expression> arguments = Collections.singletonList(this.expression());
        this.expect(TokenType.RBRACE);
        long tokenWithDelimiter = Token.withDelimiter(primaryToken);
        return CallNode.forCall(primaryLine, tokenWithDelimiter, Token.descPosition(tokenWithDelimiter), this.finish, execIdent, arguments);
    }

    private LiteralNode<Expression[]> arrayLiteral(boolean yield, boolean await) {
        long arrayToken = this.token;
        this.next();
        ArrayList<Expression> elements = new ArrayList<Expression>();
        boolean elision = true;
        boolean hasSpread = false;
        boolean hasCoverInitializedName = false;
        block5: while (true) {
            long spreadToken = 0L;
            switch (this.type) {
                case RBRACKET: {
                    this.next();
                    break block5;
                }
                case COMMARIGHT: {
                    this.next();
                    if (elision) {
                        elements.add(null);
                    }
                    elision = true;
                    continue block5;
                }
                case ELLIPSIS: {
                    if (ES6_SPREAD_ARRAY) {
                        hasSpread = true;
                        spreadToken = this.token;
                        this.next();
                    }
                }
                default: {
                    if (!elision) {
                        throw this.error(AbstractParser.message("expected.comma", this.type.getNameOrType()));
                    }
                    Expression expression = this.assignmentExpression(true, yield, await, true);
                    if (expression != null) {
                        if (spreadToken != 0L) {
                            expression = new UnaryNode(Token.recast(spreadToken, TokenType.SPREAD_ARRAY), expression);
                        }
                        elements.add(expression);
                        hasCoverInitializedName = hasCoverInitializedName || Parser.hasCoverInitializedName(expression);
                    } else {
                        this.expect(TokenType.RBRACKET);
                    }
                    elision = false;
                    continue block5;
                }
            }
            break;
        }
        return LiteralNode.newInstance(arrayToken, this.finish, Parser.optimizeList(elements), hasSpread, elision, hasCoverInitializedName);
    }

    private ObjectNode objectLiteral(boolean yield, boolean await) {
        long objectToken = this.token;
        this.next();
        ArrayList<PropertyNode> elements = new ArrayList<PropertyNode>();
        HashMap<String, PropertyNode> map = new HashMap<String, PropertyNode>();
        boolean commaSeen = true;
        boolean hasCoverInitializedName = false;
        block4: while (true) {
            switch (this.type) {
                case RBRACE: {
                    this.next();
                    break block4;
                }
                case COMMARIGHT: {
                    if (commaSeen) {
                        throw this.error(AbstractParser.message("expected.property.id", this.type.getNameOrType()));
                    }
                    this.next();
                    commaSeen = true;
                    continue block4;
                }
                default: {
                    if (!commaSeen) {
                        throw this.error(AbstractParser.message("expected.comma", this.type.getNameOrType()));
                    }
                    commaSeen = false;
                    PropertyNode property = this.propertyDefinition(yield, await);
                    elements.add(property);
                    boolean bl = hasCoverInitializedName = hasCoverInitializedName || property.isCoverInitializedName() || Parser.hasCoverInitializedName(property.getValue());
                    if (property.isComputed() || property.getKey().isTokenType(TokenType.SPREAD_OBJECT)) continue block4;
                    String key = property.getKeyName();
                    PropertyNode existingProperty = (PropertyNode)map.get(key);
                    if (existingProperty == null) {
                        map.put(key, property);
                        continue block4;
                    }
                    Expression value = property.getValue();
                    FunctionNode getter = property.getGetter();
                    FunctionNode setter = property.getSetter();
                    Expression prevValue = existingProperty.getValue();
                    FunctionNode prevGetter = existingProperty.getGetter();
                    FunctionNode prevSetter = existingProperty.getSetter();
                    if (!this.isES6()) {
                        this.checkPropertyRedefinition(property, value, getter, setter, prevValue, prevGetter, prevSetter);
                    } else if (property.isProto() && existingProperty.isProto()) {
                        throw this.error(AbstractParser.message("multiple.proto.key", new String[0]), property.getToken());
                    }
                    if (this.isES6() || value != null || prevValue != null) continue block4;
                    if (getter != null) {
                        assert (prevGetter != null || prevSetter != null);
                        map.put(key, existingProperty.setGetter(getter));
                        continue block4;
                    }
                    if (setter == null) continue block4;
                    assert (prevGetter != null || prevSetter != null);
                    map.put(key, existingProperty.setSetter(setter));
                    continue block4;
                }
            }
            break;
        }
        return new ObjectNode(objectToken, this.finish, Parser.optimizeList(elements), hasCoverInitializedName);
    }

    private static boolean hasCoverInitializedName(Expression value) {
        return value != null && (value instanceof ObjectNode && ((ObjectNode)value).hasCoverInitializedName() || value instanceof LiteralNode.ArrayLiteralNode && ((LiteralNode.ArrayLiteralNode)value).hasCoverInitializedName());
    }

    private void checkPropertyRedefinition(PropertyNode property, Expression value, FunctionNode getter, FunctionNode setter, Expression prevValue, FunctionNode prevGetter, FunctionNode prevSetter) {
        boolean isAccessor;
        if (this.isStrictMode && value != null && prevValue != null) {
            throw this.error(AbstractParser.message(MESSAGE_PROPERTY_REDEFINITON, property.getKeyName()), property.getToken());
        }
        boolean isPrevAccessor = prevGetter != null || prevSetter != null;
        boolean bl = isAccessor = getter != null || setter != null;
        if (prevValue != null && isAccessor) {
            throw this.error(AbstractParser.message(MESSAGE_PROPERTY_REDEFINITON, property.getKeyName()), property.getToken());
        }
        if (isPrevAccessor && value != null) {
            throw this.error(AbstractParser.message(MESSAGE_PROPERTY_REDEFINITON, property.getKeyName()), property.getToken());
        }
        if (isAccessor && isPrevAccessor && (getter != null && prevGetter != null || setter != null && prevSetter != null)) {
            throw this.error(AbstractParser.message(MESSAGE_PROPERTY_REDEFINITON, property.getKeyName()), property.getToken());
        }
    }

    private PropertyKey literalPropertyName() {
        switch (this.type) {
            case IDENT: {
                return this.getIdent().setIsPropertyName();
            }
            case NON_OCTAL_DECIMAL: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.nonoctaldecimal", new String[0]), this.token);
                }
            }
            case OCTAL_LEGACY: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case OCTAL: 
            case BINARY_NUMBER: 
            case BIGINT: 
            case FLOATING: {
                return (PropertyKey)((Object)this.getLiteral());
            }
        }
        return this.getIdentifierName().setIsPropertyName();
    }

    private Expression computedPropertyName(boolean yield, boolean await) {
        this.expect(TokenType.LBRACKET);
        Expression expression = this.assignmentExpression(true, yield, await);
        this.expect(TokenType.RBRACKET);
        return expression;
    }

    private Expression propertyName(boolean yield, boolean await) {
        if (ES6_COMPUTED_PROPERTY_NAME && this.type == TokenType.LBRACKET && this.isES6()) {
            return this.computedPropertyName(yield, await);
        }
        return (Expression)((Object)this.literalPropertyName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyNode propertyDefinition(boolean yield, boolean await) {
        Expression propertyValue;
        Expression propertyName;
        boolean isIdentifier;
        boolean computed;
        long propertyToken = this.token;
        int functionLine = this.line;
        boolean async = false;
        if (this.isAsync() && this.lookaheadIsAsyncMethod(false)) {
            async = true;
            this.next();
        }
        boolean generator = false;
        if (this.type == TokenType.MUL && ES6_GENERATOR_FUNCTION && this.isES6()) {
            generator = true;
            this.next();
        }
        boolean bl = computed = this.type == TokenType.LBRACKET;
        if (this.type == TokenType.IDENT || this.isIdentifier() && this.type != TokenType.GET && this.type != TokenType.SET) {
            isIdentifier = true;
            propertyName = this.getIdent().setIsPropertyName();
        } else if (this.type == TokenType.GET || this.type == TokenType.SET) {
            TokenType getOrSet = this.type;
            this.next();
            if (this.type != TokenType.COLON && this.type != TokenType.COMMARIGHT && this.type != TokenType.RBRACE && (this.type != TokenType.ASSIGN && this.type != TokenType.LPAREN || !this.isES6())) {
                long getOrSetToken = propertyToken;
                if (getOrSet == TokenType.GET) {
                    PropertyFunction getter = this.propertyGetterFunction(getOrSetToken, functionLine, yield, await, false);
                    return new PropertyNode(propertyToken, this.finish, getter.key, null, getter.functionNode, null, false, getter.computed, false, false);
                }
                if (getOrSet == TokenType.SET) {
                    PropertyFunction setter = this.propertySetterFunction(getOrSetToken, functionLine, yield, await, false);
                    return new PropertyNode(propertyToken, this.finish, setter.key, null, null, setter.functionNode, false, setter.computed, false, false);
                }
            }
            isIdentifier = true;
            propertyName = new IdentNode(propertyToken, this.finish, getOrSet.getName()).setIsPropertyName();
        } else {
            if (this.type == TokenType.ELLIPSIS && ES8_REST_SPREAD_PROPERTY && this.isES2017() && !generator && !async) {
                long spreadToken = Token.recast(propertyToken, TokenType.SPREAD_OBJECT);
                this.next();
                Expression assignmentExpression = this.assignmentExpression(true, yield, await);
                UnaryNode spread = new UnaryNode(spreadToken, assignmentExpression);
                return new PropertyNode(propertyToken, this.finish, spread, null, null, null, false, false, false, false);
            }
            isIdentifier = false;
            propertyName = this.propertyName(yield, await);
        }
        if (generator || async) {
            this.expectDontAdvance(TokenType.LPAREN);
        }
        boolean coverInitializedName = false;
        boolean proto = false;
        boolean isAnonymousFunctionDefinition = false;
        if (this.type == TokenType.LPAREN && this.isES6()) {
            propertyValue = this.propertyMethodFunction((Expression)propertyName, (long)propertyToken, (int)functionLine, (boolean)generator, (int)0x100000, (boolean)computed, (boolean)async).functionNode;
        } else if (isIdentifier && (this.type == TokenType.COMMARIGHT || this.type == TokenType.RBRACE || this.type == TokenType.ASSIGN) && this.isES6()) {
            Expression ident = propertyName;
            this.verifyIdent((IdentNode)ident, yield, await);
            propertyValue = this.createIdentNode(propertyToken, this.finish, ((IdentNode)ident).getPropertyName());
            if (this.type == TokenType.ASSIGN && ES6_DESTRUCTURING) {
                long assignToken = this.token;
                coverInitializedName = true;
                this.next();
                Expression rhs = this.assignmentExpression(true, yield, await);
                propertyValue = this.verifyAssignment(assignToken, propertyValue, rhs, true);
            }
        } else {
            this.expect(TokenType.COLON);
            if (!computed && PROTO_NAME.equals(((PropertyKey)((Object)propertyName)).getPropertyName())) {
                proto = true;
            }
            this.pushDefaultName(propertyName);
            try {
                propertyValue = this.assignmentExpression(true, yield, await, true);
            }
            finally {
                this.popDefaultName();
            }
            if (!proto && Parser.isAnonymousFunctionDefinition(propertyValue)) {
                if (!computed && propertyName instanceof IdentNode) {
                    propertyValue = this.setAnonymousFunctionName(propertyValue, ((IdentNode)propertyName).getName());
                } else {
                    isAnonymousFunctionDefinition = true;
                }
            }
        }
        return new PropertyNode(propertyToken, this.finish, propertyName, propertyValue, null, null, false, computed, coverInitializedName, proto, false, isAnonymousFunctionDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyFunction propertyGetterFunction(long getSetToken, int functionLine, boolean yield, boolean await, boolean allowPrivate) {
        Block functionBody;
        boolean computed = this.type == TokenType.LBRACKET;
        Expression propertyName = this.classElementName(yield, await, allowPrivate);
        IdentNode getterName = computed ? null : this.createMethodNameIdent(propertyName, "get ");
        this.expect(TokenType.LPAREN);
        this.expect(TokenType.RPAREN);
        int functionFlags = 0x100800 | (computed ? 1 : 0);
        ParserContextFunctionNode functionNode = this.createParserContextFunctionNode(getterName, getSetToken, functionFlags, functionLine, Collections.emptyList(), 0);
        this.lc.push(functionNode);
        try {
            functionBody = this.functionBody(functionNode);
        }
        finally {
            this.lc.pop(functionNode);
        }
        FunctionNode function = this.createFunctionNode(functionNode, getSetToken, getterName, functionLine, functionBody);
        return new PropertyFunction(propertyName, function, computed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyFunction propertySetterFunction(long getSetToken, int functionLine, boolean yield, boolean await, boolean allowPrivate) {
        Block functionBody;
        boolean computed = this.type == TokenType.LBRACKET;
        Expression propertyName = this.classElementName(yield, await, allowPrivate);
        IdentNode setterName = computed ? null : this.createMethodNameIdent(propertyName, "set ");
        this.expect(TokenType.LPAREN);
        int functionFlags = 0x101000 | (computed ? 1 : 0);
        ParserContextFunctionNode functionNode = this.createParserContextFunctionNode(setterName, getSetToken, functionFlags, functionLine);
        this.lc.push(functionNode);
        try {
            ParserContextBlockNode parameterBlock = functionNode.createParameterBlock();
            this.lc.push(parameterBlock);
            try {
                if (!this.env.syntaxExtensions || this.type != TokenType.RPAREN) {
                    this.formalParameter(yield, await);
                }
                this.expect(TokenType.RPAREN);
                functionBody = this.functionBody(functionNode);
            }
            finally {
                this.restoreBlock(parameterBlock);
            }
            if (parameterBlock != null) {
                functionBody = Parser.wrapParameterBlock(parameterBlock, functionBody);
            }
        }
        finally {
            this.lc.pop(functionNode);
        }
        FunctionNode function = this.createFunctionNode(functionNode, getSetToken, setterName, functionLine, functionBody);
        return new PropertyFunction(propertyName, function, computed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyFunction propertyMethodFunction(Expression key, long methodToken, int methodLine, boolean generator, int flags, boolean computed, boolean async) {
        IdentNode methodNameNode = computed ? null : this.createMethodNameIdent(key, "");
        this.expect(TokenType.LPAREN);
        int functionFlags = flags | (computed ? 1 : 0) | (generator ? 0x1000000 : 0) | (async ? 0x2000000 : 0);
        ParserContextFunctionNode functionNode = this.createParserContextFunctionNode(methodNameNode, methodToken, functionFlags, methodLine);
        this.lc.push(functionNode);
        try {
            Block functionBody;
            ParserContextBlockNode parameterBlock = functionNode.createParameterBlock();
            this.lc.push(parameterBlock);
            try {
                this.formalParameterList(generator, async);
                this.expect(TokenType.RPAREN);
                functionBody = this.functionBody(functionNode);
            }
            finally {
                this.restoreBlock(parameterBlock);
            }
            this.verifyParameterList(functionNode);
            if (parameterBlock != null) {
                functionBody = Parser.wrapParameterBlock(parameterBlock, functionBody);
            }
            FunctionNode function = this.createFunctionNode(functionNode, methodToken, methodNameNode, methodLine, functionBody);
            PropertyFunction propertyFunction = new PropertyFunction(key, function, computed);
            return propertyFunction;
        }
        finally {
            this.lc.pop(functionNode);
        }
    }

    private IdentNode createMethodNameIdent(Expression propertyKey, String prefix) {
        String methodName;
        boolean intern = false;
        if (propertyKey instanceof IdentNode) {
            methodName = ((IdentNode)propertyKey).getPropertyName();
        } else if (propertyKey instanceof PropertyKey) {
            methodName = ((PropertyKey)((Object)propertyKey)).getPropertyName();
            intern = true;
        } else {
            return null;
        }
        if (!prefix.isEmpty()) {
            methodName = prefix.concat(methodName);
            intern = true;
        }
        if (intern) {
            methodName = this.lexer.stringIntern(methodName);
        }
        return this.createIdentNode(propertyKey.getToken(), propertyKey.getFinish(), methodName);
    }

    private static boolean isAnonymousFunctionDefinition(Expression expression) {
        if (expression instanceof FunctionNode && ((FunctionNode)expression).isAnonymous()) {
            return true;
        }
        return expression instanceof ClassNode && ((ClassNode)expression).isAnonymous();
    }

    private Expression setAnonymousFunctionName(Expression expression, String functionName) {
        if (!this.isES6()) {
            return expression;
        }
        if (expression instanceof FunctionNode && ((FunctionNode)expression).isAnonymous()) {
            return ((FunctionNode)expression).setName(null, functionName);
        }
        if (expression instanceof ClassNode && ((ClassNode)expression).isAnonymous()) {
            ClassNode classNode = (ClassNode)expression;
            FunctionNode constructorFunction = (FunctionNode)classNode.getConstructor().getValue();
            return classNode.setConstructor(classNode.getConstructor().setValue(constructorFunction.setName(null, functionName)));
        }
        return expression;
    }

    private Expression leftHandSideExpression(boolean yield, boolean await) {
        List<Expression> arguments;
        int callLine = this.line;
        long callToken = this.token;
        Expression lhs = this.memberExpression(yield, await);
        if (this.type == TokenType.LPAREN) {
            boolean async = ES8_ASYNC_FUNCTION && this.isES2017() && lhs.isTokenType(TokenType.ASYNC);
            arguments = this.argumentList(yield, await, async);
            if (async) {
                if (this.type == TokenType.ARROW && this.checkNoLineTerminator()) {
                    return new ExpressionList(callToken, callLine, Parser.optimizeList(arguments));
                }
                for (Expression argument : arguments) {
                    if (!Parser.hasCoverInitializedName(argument)) continue;
                    throw this.error(AbstractParser.message(MESSAGE_INVALID_PROPERTY_INITIALIZER, new String[0]));
                }
            }
            boolean eval = false;
            boolean applyArguments = false;
            if (lhs instanceof IdentNode) {
                IdentNode ident = (IdentNode)lhs;
                String name = ident.getName();
                if (EVAL_NAME.equals(name)) {
                    this.markEval();
                    eval = true;
                } else if (TokenType.SUPER.getName().equals(name)) {
                    assert (ident.isDirectSuper());
                    this.markSuperCall();
                }
            } else if (lhs instanceof AccessNode && !((AccessNode)lhs).isPrivate() && arguments.size() == 2 && arguments.get(1) instanceof IdentNode && ((IdentNode)arguments.get(1)).isArguments() && APPLY_NAME.equals(((AccessNode)lhs).getProperty()) && Parser.markApplyArgumentsCall(this.lc, arguments)) {
                applyArguments = true;
            }
            lhs = CallNode.forCall(callLine, callToken, lhs.getStart(), this.finish, lhs, Parser.optimizeList(arguments), false, false, eval, applyArguments);
        }
        boolean optionalChain = false;
        block12: while (true) {
            callLine = this.line;
            callToken = this.token;
            switch (this.type) {
                case LPAREN: {
                    arguments = Parser.optimizeList(this.argumentList(yield, await));
                    lhs = CallNode.forCall(callLine, callToken, lhs.getStart(), this.finish, lhs, arguments, false, optionalChain);
                    continue block12;
                }
                case LBRACKET: {
                    this.next();
                    Expression rhs = this.expression(true, yield, await);
                    this.expect(TokenType.RBRACKET);
                    lhs = new IndexNode(callToken, this.finish, lhs, rhs, false, false, optionalChain);
                    continue block12;
                }
                case PERIOD: {
                    this.next();
                    boolean isPrivate = this.type == TokenType.PRIVATE_IDENT;
                    IdentNode property = isPrivate ? this.privateIdentifierUse() : this.getIdentifierName();
                    lhs = new AccessNode(callToken, this.finish, lhs, property.getName(), false, isPrivate, false, optionalChain);
                    continue block12;
                }
                case TEMPLATE: 
                case TEMPLATE_HEAD: {
                    if (optionalChain) {
                        throw this.error(AbstractParser.message("optional.chain.template", new String[0]));
                    }
                    arguments = this.templateLiteralArgumentList(yield, await);
                    lhs = CallNode.forCall(callLine, callToken, lhs.getStart(), this.finish, lhs, arguments, false, optionalChain);
                    continue block12;
                }
                case OPTIONAL_CHAIN: {
                    Expression rhs;
                    if (!this.isES2020()) break block12;
                    this.next();
                    optionalChain = true;
                    switch (this.type) {
                        case LPAREN: {
                            arguments = Parser.optimizeList(this.argumentList(yield, await));
                            lhs = CallNode.forCall(callLine, callToken, lhs.getStart(), this.finish, lhs, arguments, true, optionalChain);
                            continue block12;
                        }
                        case LBRACKET: {
                            this.next();
                            rhs = this.expression(true, yield, await);
                            this.expect(TokenType.RBRACKET);
                            lhs = new IndexNode(callToken, this.finish, lhs, rhs, false, true, optionalChain);
                            continue block12;
                        }
                    }
                    IdentNode property = this.getIdentifierName();
                    lhs = new AccessNode(callToken, this.finish, lhs, property.getName(), false, false, true, optionalChain);
                    continue block12;
                }
            }
            break;
        }
        return lhs;
    }

    private Expression newExpression(boolean yield, boolean await) {
        ArrayList<Object> arguments;
        long newToken = this.token;
        assert (this.type == TokenType.NEW);
        this.next();
        if (ES6_NEW_TARGET && this.type == TokenType.PERIOD && this.isES6()) {
            this.next();
            if (this.type == TokenType.IDENT && "target".equals(this.getValueNoEscape())) {
                this.next();
                this.markNewTarget();
                return new IdentNode(newToken, this.finish, NEW_TARGET_NAME).setIsNewTarget();
            }
            throw this.error(AbstractParser.message("expected.target", new String[0]), this.token);
        }
        if (this.type == TokenType.IMPORT && this.isES2020() && this.lookahead() == TokenType.LPAREN) {
            throw this.error(AbstractParser.message(MESSAGE_EXPECTED_OPERAND, TokenType.IMPORT.getName()), this.token);
        }
        int callLine = this.line;
        Expression constructor = this.memberExpression(yield, await);
        if (this.type == TokenType.LPAREN) {
            arguments = this.argumentList(yield, await);
        } else {
            arguments = new ArrayList();
            if (this.type == TokenType.OPTIONAL_CHAIN) {
                throw this.error(AbstractParser.message("unexpected.token", this.type.getNameOrType()));
            }
        }
        if (this.env.syntaxExtensions && this.type == TokenType.LBRACE) {
            arguments.add(this.objectLiteral(yield, await));
        }
        Expression callNode = CallNode.forNew(callLine, newToken, Token.descPosition(newToken), this.finish, constructor, Parser.optimizeList(arguments));
        return new UnaryNode(newToken, callNode);
    }

    private Expression memberExpression(boolean yield, boolean await) {
        Expression lhs;
        boolean isSuper = false;
        block0 : switch (this.type) {
            case NEW: {
                lhs = this.newExpression(yield, await);
                break;
            }
            case FUNCTION: {
                lhs = this.functionExpression(false, false);
                break;
            }
            case CLASS: {
                if (ES6_CLASS && this.isES6()) {
                    lhs = this.classExpression(yield, await);
                    break;
                }
            }
            case SUPER: {
                Scope scope;
                if (ES6_CLASS && this.isES6() && (scope = this.lc.getCurrentScope()).inMethod()) {
                    long identToken = Token.recast(this.token, TokenType.IDENT);
                    this.next();
                    lhs = new IdentNode(identToken, this.finish, TokenType.SUPER.getName()).setIsSuper();
                    switch (this.type) {
                        case LBRACKET: 
                        case PERIOD: {
                            ParserContextFunctionNode currentFunction = this.lc.getCurrentNonArrowFunction();
                            if (currentFunction.isMethod()) {
                                currentFunction.setFlag(524288);
                            }
                            isSuper = true;
                            break block0;
                        }
                        case LPAREN: {
                            if (!scope.inDerivedConstructor()) break;
                            lhs = ((IdentNode)lhs).setIsDirectSuper();
                            break block0;
                        }
                    }
                    throw this.error(AbstractParser.message("invalid.super", new String[0]), identToken);
                }
            }
            case ASYNC: {
                if (this.isAsync() && this.lookaheadIsAsyncFunction()) {
                    lhs = this.asyncFunctionExpression(false, false);
                    break;
                }
            }
            case IMPORT: {
                if (this.isES2020() && this.type == TokenType.IMPORT) {
                    lhs = this.importExpression(yield, await);
                    break;
                }
            }
            default: {
                lhs = this.primaryExpression(yield, await);
            }
        }
        block17: while (true) {
            long callToken = this.token;
            switch (this.type) {
                case LBRACKET: {
                    this.next();
                    Expression index = this.expression(true, yield, await);
                    this.expect(TokenType.RBRACKET);
                    lhs = new IndexNode(callToken, this.finish, lhs, index, isSuper, false, false);
                    if (!isSuper) continue block17;
                    isSuper = false;
                    continue block17;
                }
                case PERIOD: {
                    this.next();
                    boolean isPrivate = this.type == TokenType.PRIVATE_IDENT;
                    IdentNode property = !isSuper && isPrivate ? this.privateIdentifierUse() : this.getIdentifierName();
                    lhs = new AccessNode(callToken, this.finish, lhs, property.getName(), isSuper, isPrivate, false, false);
                    if (!isSuper) continue block17;
                    isSuper = false;
                    continue block17;
                }
                case TEMPLATE: 
                case TEMPLATE_HEAD: {
                    int callLine = this.line;
                    List<Expression> arguments = this.templateLiteralArgumentList(yield, await);
                    lhs = CallNode.forCall(callLine, callToken, lhs.getStart(), this.finish, lhs, arguments, false, false);
                    continue block17;
                }
            }
            break;
        }
        return lhs;
    }

    private Expression importExpression(boolean yield, boolean await) {
        long importToken = this.token;
        int importLine = this.line;
        int importStart = this.start;
        assert (this.type == TokenType.IMPORT);
        this.next();
        if (this.type == TokenType.PERIOD) {
            this.next();
            this.expectDontAdvance(TokenType.IDENT);
            String meta = (String)this.getValueNoEscape();
            if ("meta".equals(meta)) {
                if (!this.isModule) {
                    throw this.error(AbstractParser.message("unexpected.import.meta", new String[0]), importToken);
                }
                this.next();
                return new IdentNode(importToken, this.finish, IMPORT_META_NAME).setIsImportMeta();
            }
            throw this.error(AbstractParser.message("unexpected.ident", meta), this.token);
        }
        if (this.type == TokenType.LPAREN) {
            this.next();
            Expression argument = this.assignmentExpression(true, yield, await);
            this.expect(TokenType.RPAREN);
            IdentNode importIdent = new IdentNode(importToken, Token.descPosition(importToken) + Token.descLength(importToken), TokenType.IMPORT.getName());
            return CallNode.forImport(importLine, importToken, importStart, this.finish, importIdent, Collections.singletonList(argument));
        }
        throw this.error(AbstractParser.message(MESSAGE_EXPECTED_OPERAND, TokenType.IMPORT.getName()), importToken);
    }

    private ArrayList<Expression> argumentList(boolean yield, boolean await) {
        return this.argumentList(yield, await, false);
    }

    private ArrayList<Expression> argumentList(boolean yield, boolean await, boolean inPatternPosition) {
        ArrayList<Expression> nodeList = new ArrayList<Expression>();
        this.next();
        boolean first = true;
        while (this.type != TokenType.RPAREN) {
            if (!first) {
                this.expect(TokenType.COMMARIGHT);
                if (ES8_TRAILING_COMMA && this.isES2017() && this.type == TokenType.RPAREN) {
                    break;
                }
            } else {
                first = false;
            }
            long spreadToken = 0L;
            if (ES6_SPREAD_ARGUMENT && this.type == TokenType.ELLIPSIS && this.isES6()) {
                spreadToken = this.token;
                this.next();
            }
            Expression expression = this.assignmentExpression(true, yield, await, inPatternPosition);
            if (spreadToken != 0L) {
                expression = new UnaryNode(Token.recast(spreadToken, TokenType.SPREAD_ARGUMENT), expression);
            }
            nodeList.add(expression);
        }
        this.expect(TokenType.RPAREN);
        return nodeList;
    }

    private static <T> List<T> optimizeList(ArrayList<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        list.trimToSize();
        return list;
    }

    private static <T> List<T> optimizeList(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        ((ArrayList)list).trimToSize();
        return list;
    }

    private Expression asyncFunctionExpression(boolean isStatement, boolean topLevel) {
        assert (this.isAsync() && this.lookaheadIsAsyncFunction());
        long asyncToken = this.token;
        this.nextOrEOL();
        return this.functionExpression(isStatement, topLevel, true, Token.recast(asyncToken, TokenType.FUNCTION), false);
    }

    private Expression functionExpression(boolean isStatement, boolean topLevel) {
        return this.functionExpression(isStatement, topLevel, false, this.token, false);
    }

    private Expression functionExpression(boolean isStatement, boolean topLevel, boolean expressionStatement) {
        return this.functionExpression(isStatement, topLevel, false, this.token, expressionStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression functionExpression(boolean isStatement, boolean topLevel, boolean async, long functionToken, boolean expressionStatement) {
        Block functionBody;
        int functionLine = this.line;
        assert (this.type == TokenType.FUNCTION);
        this.next();
        boolean generator = false;
        if (this.type == TokenType.MUL && ES6_GENERATOR_FUNCTION && this.isES6()) {
            if (expressionStatement) {
                throw this.error(AbstractParser.message(MESSAGE_EXPECTED_STMT, "generator function declaration"), this.token);
            }
            generator = true;
            this.next();
        }
        IdentNode name = null;
        if (this.isBindingIdentifier()) {
            boolean yield = !isStatement && generator || isStatement && this.inGeneratorFunction();
            boolean await = !isStatement && async || isStatement && this.inAsyncFunction();
            name = this.bindingIdentifier(yield, await, "function name");
        } else if (isStatement && !this.env.syntaxExtensions && this.reparsedFunction == null) {
            this.expect(TokenType.IDENT);
        }
        this.expect(TokenType.LPAREN);
        boolean isAnonymous = name == null;
        int functionFlags = (generator ? 0x1000000 : 0) | (async ? 0x2000000 : 0) | (isAnonymous ? 1 : 0);
        ParserContextFunctionNode functionNode = this.createParserContextFunctionNode(name, functionToken, functionFlags, functionLine);
        if (isAnonymous) {
            functionNode.setInternalName(this.getDefaultFunctionName());
        }
        this.lc.push(functionNode);
        this.hideDefaultName();
        try {
            ParserContextBlockNode parameterBlock = functionNode.createParameterBlock();
            this.lc.push(parameterBlock);
            try {
                this.formalParameterList(generator, async);
                this.expect(TokenType.RPAREN);
                functionBody = this.functionBody(functionNode);
            }
            finally {
                this.restoreBlock(parameterBlock);
            }
            if (parameterBlock != null) {
                functionBody = Parser.wrapParameterBlock(parameterBlock, functionBody);
            }
        }
        finally {
            this.popDefaultName();
            this.lc.pop(functionNode);
        }
        if (isStatement && !isAnonymous) {
            functionNode.setFlag(16);
            if (topLevel || this.useBlockScope() || !this.isStrictMode && this.env.functionStatement == ScriptEnvironment.FunctionStatementBehavior.ACCEPT) {
                functionNode.setFlag(2);
            } else {
                if (this.isStrictMode) {
                    throw this.error(JSErrorType.SyntaxError, AbstractParser.message("strict.no.func.decl.here", new String[0]), functionToken);
                }
                if (this.env.functionStatement == ScriptEnvironment.FunctionStatementBehavior.ERROR) {
                    throw this.error(JSErrorType.SyntaxError, AbstractParser.message("no.func.decl.here", new String[0]), functionToken);
                }
                if (this.env.functionStatement == ScriptEnvironment.FunctionStatementBehavior.WARNING) {
                    this.warning(JSErrorType.SyntaxError, AbstractParser.message("no.func.decl.here.warn", new String[0]), functionToken);
                }
            }
        }
        this.verifyParameterList(functionNode);
        FunctionNode function = this.createFunctionNode(functionNode, functionToken, name, functionLine, functionBody);
        if (isStatement) {
            if (isAnonymous) {
                this.appendStatement(new ExpressionStatement(functionLine, functionToken, this.finish, function));
                return function;
            }
            int varFlags = topLevel && !this.isModule || !this.useBlockScope() ? 0 : 1;
            VarNode varNode = new VarNode(functionLine, functionToken, this.finish, name, function, varFlags);
            this.declareVar(this.lc.getCurrentScope(), varNode);
            if (topLevel) {
                this.functionDeclarations.add(varNode);
            } else if (this.useBlockScope()) {
                this.prependStatement(varNode);
            } else {
                this.appendStatement(varNode);
            }
        }
        return function;
    }

    private static Block wrapParameterBlock(ParserContextBlockNode parameterBlock, Block functionBody) {
        assert (parameterBlock.getFlag(64) != 0 && functionBody.isFunctionBody());
        if (parameterBlock.getStatements().isEmpty()) {
            return functionBody;
        }
        parameterBlock.getStatements().add(new BlockStatement(functionBody.getFirstStatementLineNumber(), functionBody));
        return new Block(parameterBlock.getToken(), functionBody.getFinish(), parameterBlock.getFlags(), parameterBlock.getScope(), parameterBlock.getStatements());
    }

    private void verifyParameterList(ParserContextFunctionNode functionNode) {
        IdentNode duplicateParameter = functionNode.getDuplicateParameterBinding();
        if (duplicateParameter != null) {
            if (functionNode.isStrict() || functionNode.isMethod() || functionNode.isArrow() || !functionNode.isSimpleParameterList()) {
                throw this.error(AbstractParser.message("strict.param.redefinition", duplicateParameter.getName()), duplicateParameter.getToken());
            }
            List<IdentNode> parameters = functionNode.getParameters();
            int arity = parameters.size();
            HashSet<String> parametersSet = new HashSet<String>(arity);
            for (int i = arity - 1; i >= 0; --i) {
                IdentNode parameter = parameters.get(i);
                String parameterName = parameter.getName();
                if (parametersSet.contains(parameterName)) {
                    parameterName = functionNode.uniqueName(parameterName);
                    long parameterToken = parameter.getToken();
                    parameters.set(i, new IdentNode(parameterToken, Token.descPosition(parameterToken), functionNode.uniqueName(parameterName)));
                }
                parametersSet.add(parameterName);
            }
        }
    }

    private void pushDefaultName(Expression nameExpr) {
        this.defaultNames.add(nameExpr);
    }

    private Object popDefaultName() {
        return this.defaultNames.remove(this.defaultNames.size() - 1);
    }

    private String getDefaultFunctionName() {
        if (!this.defaultNames.isEmpty()) {
            Object nameExpr = this.defaultNames.get(this.defaultNames.size() - 1);
            if (nameExpr instanceof PropertyKey) {
                this.markDefaultNameUsed();
                return ((PropertyKey)nameExpr).getPropertyName();
            }
            if (nameExpr instanceof AccessNode) {
                AccessNode accessNode = (AccessNode)nameExpr;
                this.markDefaultNameUsed();
                if (accessNode.getBase() instanceof AccessNode) {
                    AccessNode base = (AccessNode)accessNode.getBase();
                    if (base.getBase() instanceof IdentNode && !base.isPrivate() && base.getProperty().equals(PROTOTYPE_NAME)) {
                        return ((IdentNode)base.getBase()).getName() + "." + accessNode.getProperty();
                    }
                } else if (accessNode.getBase() instanceof IdentNode) {
                    return ((IdentNode)accessNode.getBase()).getName() + "." + accessNode.getProperty();
                }
                return accessNode.getProperty();
            }
        }
        return ANONYMOUS_FUNCTION_NAME;
    }

    private void markDefaultNameUsed() {
        this.popDefaultName();
        this.hideDefaultName();
    }

    private void hideDefaultName() {
        this.defaultNames.add("");
    }

    private void formalParameterList(boolean yield, boolean async) {
        this.formalParameterList(TokenType.RPAREN, yield, async);
    }

    private void formalParameter(boolean yield, boolean await) {
        if (this.type == TokenType.YIELD && yield || this.isAwait() && await) {
            throw this.error(this.expectMessage(TokenType.IDENT));
        }
        ParserContextFunctionNode currentFunction = this.lc.getCurrentFunction();
        long paramToken = this.token;
        int paramLine = this.line;
        if (this.isBindingIdentifier() || !ES6_DESTRUCTURING || !this.isES6()) {
            IdentNode ident = this.bindingIdentifier(yield, await, FUNCTION_PARAMETER_CONTEXT);
            if (this.type == TokenType.ASSIGN && ES6_DEFAULT_PARAMETER && this.isES6()) {
                this.next();
                if (this.type == TokenType.YIELD && yield || this.isAwait() && await) {
                    throw this.error(this.expectMessage(TokenType.IDENT));
                }
                Expression initializer = this.assignmentExpression(true, yield, await);
                if (Parser.isAnonymousFunctionDefinition(initializer)) {
                    initializer = this.setAnonymousFunctionName(initializer, ident.getName());
                }
                if (currentFunction != null) {
                    Parser.addDefaultParameter(paramToken, this.finish, paramLine, ident, initializer, currentFunction);
                }
            } else if (currentFunction != null) {
                currentFunction.addParameter(ident);
            }
        } else {
            Expression pattern = this.bindingPattern(yield, await);
            this.verifyDestructuringParameterBindingPattern(pattern, paramToken, paramLine);
            Expression initializer = null;
            if (this.type == TokenType.ASSIGN) {
                this.next();
                initializer = this.assignmentExpression(true, yield, await);
            }
            if (currentFunction != null) {
                this.addDestructuringParameter(paramToken, this.finish, paramLine, pattern, initializer, currentFunction, false);
            }
        }
    }

    private void functionRestParameter(TokenType endType, boolean yield, boolean await) {
        long paramToken = this.token;
        int paramLine = this.line;
        ParserContextFunctionNode currentFunction = this.lc.getCurrentFunction();
        Expression pattern = this.bindingIdentifierOrPattern(yield, await, FUNCTION_PARAMETER_CONTEXT);
        if (pattern instanceof IdentNode) {
            IdentNode ident = ((IdentNode)pattern).setIsRestParameter();
            if (currentFunction != null) {
                currentFunction.addParameter(ident);
            }
        } else {
            this.verifyDestructuringParameterBindingPattern(pattern, paramToken, paramLine);
            if (currentFunction != null) {
                this.addDestructuringParameter(paramToken, this.finish, paramLine, pattern, null, currentFunction, true);
            }
        }
        this.expectDontAdvance(endType);
    }

    private void formalParameterList(TokenType endType, boolean yield, boolean await) {
        boolean first = true;
        while (this.type != endType) {
            if (!first) {
                this.expect(TokenType.COMMARIGHT);
                if (ES8_TRAILING_COMMA && this.isES2017() && this.type == endType) {
                    break;
                }
            } else {
                first = false;
            }
            if (ES6_REST_PARAMETER && this.type == TokenType.ELLIPSIS && this.isES6()) {
                this.next();
                this.functionRestParameter(endType, yield, await);
                break;
            }
            this.formalParameter(yield, await);
        }
    }

    private static void addDefaultParameter(long paramToken, int paramFinish, int paramLine, IdentNode target, Expression initializer, ParserContextFunctionNode function) {
        assert (target != null && initializer != null);
        int paramIndex = function.getParameterCount();
        ParameterNode param = new ParameterNode(paramToken, paramFinish, paramIndex);
        BinaryNode test = new BinaryNode(Token.recast(paramToken, TokenType.EQ_STRICT), (Expression)param, (Expression)Parser.newUndefinedLiteral(paramToken, paramFinish));
        TernaryNode value = new TernaryNode(Token.recast(paramToken, TokenType.TERNARY), (Expression)test, new JoinPredecessorExpression(initializer), new JoinPredecessorExpression(param));
        VarNode varNode = new VarNode(paramLine, Token.recast(paramToken, TokenType.LET), paramFinish, target, value, 1);
        function.addDefaultParameter(varNode);
    }

    private void addDestructuringParameter(long paramToken, int paramFinish, int paramLine, Expression target, Expression initializer, ParserContextFunctionNode function, boolean isRest) {
        Expression value;
        assert (this.isDestructuringLhs(target));
        int paramIndex = function.getParameterCount();
        ParameterNode param = new ParameterNode(paramToken, paramFinish, paramIndex, isRest);
        if (initializer == null) {
            value = param;
        } else {
            BinaryNode test = new BinaryNode(Token.recast(paramToken, TokenType.EQ_STRICT), (Expression)param, (Expression)Parser.newUndefinedLiteral(paramToken, paramFinish));
            value = new TernaryNode(Token.recast(paramToken, TokenType.TERNARY), (Expression)test, new JoinPredecessorExpression(initializer), new JoinPredecessorExpression(param));
        }
        BinaryNode assignment = new BinaryNode(Token.recast(paramToken, TokenType.ASSIGN_INIT), target, value);
        function.addParameterInitialization(paramLine, assignment, initializer != null);
    }

    private void verifyDestructuringParameterBindingPattern(final Expression pattern, final long paramToken, final int paramLine) {
        this.verifyDestructuringBindingPattern(pattern, new Consumer<IdentNode>(){

            @Override
            public void accept(IdentNode identNode) {
                Parser.this.verifyStrictIdent(identNode, Parser.FUNCTION_PARAMETER_CONTEXT);
                ParserContextFunctionNode currentFunction = Parser.this.lc.getCurrentFunction();
                if (currentFunction != null) {
                    VarNode declaration = new VarNode(paramLine, Token.recast(paramToken, TokenType.LET), pattern.getFinish(), identNode, null, 17);
                    currentFunction.addParameterBindingDeclaration(declaration);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block functionBody(ParserContextFunctionNode functionNode) {
        RecompilableScriptFunctionData data;
        int bodyFinish;
        boolean parseBody;
        ParserContextBlockNode body;
        ParserState endParserState;
        long bodyToken;
        block17: {
            bodyToken = this.token;
            endParserState = null;
            body = this.newBlock(functionNode.createBodyScope());
            try {
                int functionId = functionNode.getId();
                boolean bl = parseBody = this.reparsedFunction == null || functionId <= this.reparsedFunction.getFunctionNodeId();
                if ((this.env.syntaxExtensions || functionNode.isArrow()) && this.type != TokenType.LBRACE) {
                    Expression expr = this.assignmentExpression(true);
                    long lastToken = this.previousToken;
                    functionNode.setLastToken(this.previousToken);
                    assert (this.lc.getCurrentBlock().getScope().isFunctionBodyScope());
                    int lastFinish = Token.descPosition(lastToken) + (Token.descType(lastToken) == TokenType.EOL ? 0 : Token.descLength(lastToken));
                    if (parseBody) {
                        ReturnNode returnNode = new ReturnNode(functionNode.getLineNumber(), expr.getToken(), lastFinish, expr);
                        this.appendStatement(returnNode);
                    }
                    bodyFinish = this.finish;
                    break block17;
                }
                this.expectDontAdvance(TokenType.LBRACE);
                if (parseBody || !this.skipFunctionBody(functionNode)) {
                    this.next();
                    List<Statement> prevFunctionDecls = this.functionDeclarations;
                    this.functionDeclarations = new ArrayList<Statement>();
                    try {
                        this.sourceElements(0);
                        this.addFunctionDeclarations(functionNode);
                    }
                    finally {
                        this.functionDeclarations = prevFunctionDecls;
                    }
                    if (parseBody) {
                        endParserState = new ParserState(Token.descPosition(this.token), this.line, this.linePosition);
                    }
                }
                bodyFinish = Token.descPosition(this.token) + Token.descLength(this.token);
                functionNode.setLastToken(this.token);
                this.expect(TokenType.RBRACE);
            }
            finally {
                this.restoreBlock(body);
            }
        }
        if (parseBody) {
            functionNode.setEndParserState(endParserState);
        } else if (!body.getStatements().isEmpty()) {
            body.setStatements(Collections.emptyList());
        }
        if (this.reparsedFunction != null && (data = this.reparsedFunction.getScriptFunctionData(functionNode.getId())) != null) {
            functionNode.setFlag(data.getFunctionFlags());
            if (functionNode.hasNestedEval()) {
                assert (functionNode.hasScopeBlock());
                body.setFlag(1);
            }
        }
        return new Block(bodyToken, bodyFinish, body.getFlags() | 0x20, body.getScope(), body.getStatements());
    }

    private boolean skipFunctionBody(ParserContextFunctionNode functionNode) {
        if (this.reparsedFunction == null) {
            return false;
        }
        RecompilableScriptFunctionData data = this.reparsedFunction.getScriptFunctionData(functionNode.getId());
        if (data == null) {
            return false;
        }
        ParserState parserState = (ParserState)data.getEndParserState();
        assert (parserState != null);
        if (this.k < this.stream.last() && this.start < parserState.position && parserState.position <= Token.descPosition(this.stream.get(this.stream.last()))) {
            while (this.k < this.stream.last()) {
                long nextToken = this.stream.get(this.k + 1);
                if (Token.descPosition(nextToken) == parserState.position && Token.descType(nextToken) == TokenType.RBRACE) {
                    this.token = this.stream.get(this.k);
                    this.type = Token.descType(this.token);
                    this.next();
                    assert (this.type == TokenType.RBRACE && this.start == parserState.position);
                    return true;
                }
                ++this.k;
            }
        }
        this.stream.reset();
        this.lexer = parserState.createLexer(this.source, this.lexer, this.stream, this.scripting, this.env.ecmaScriptVersion, this.shebang, this.isModule, this.allowBigInt);
        this.line = parserState.line;
        this.linePosition = parserState.linePosition;
        this.type = TokenType.SEMICOLON;
        this.scanFirstToken();
        return true;
    }

    private void addFunctionDeclarations(ParserContextFunctionNode functionNode) {
        VarNode lastDecl = null;
        for (int i = this.functionDeclarations.size() - 1; i >= 0; --i) {
            Statement decl = this.functionDeclarations.get(i);
            if (lastDecl == null && decl instanceof VarNode) {
                lastDecl = ((VarNode)decl).setFlag(4);
                decl = lastDecl;
                functionNode.setFlag(0x10000000);
            }
            this.prependStatement(decl);
        }
    }

    private ParserException invalidLHSError(Expression lhs) {
        JSErrorType errorType = this.isES2020() ? JSErrorType.SyntaxError : JSErrorType.ReferenceError;
        return this.error(errorType, AbstractParser.message(MESSAGE_INVALID_LVALUE, new String[0]), lhs.getToken());
    }

    private Expression unaryExpression(boolean yield, boolean await) {
        int unaryLine = this.line;
        long unaryToken = this.token;
        switch (this.type) {
            case DELETE: {
                this.next();
                Expression expr = this.unaryExpression(yield, await);
                if (this.type == TokenType.EXP) {
                    throw this.error(AbstractParser.message("unexpected.token", this.type.getNameOrType()));
                }
                return this.verifyDeleteExpression(unaryLine, unaryToken, expr);
            }
            case VOID: 
            case TYPEOF: 
            case ADD: 
            case SUB: 
            case BIT_NOT: 
            case NOT: {
                this.next();
                Expression expr = this.unaryExpression(yield, await);
                if (this.type == TokenType.EXP) {
                    throw this.error(AbstractParser.message("unexpected.token", this.type.getNameOrType()));
                }
                return new UnaryNode(unaryToken, expr);
            }
            case INCPREFIX: 
            case DECPREFIX: {
                TokenType opType = this.type;
                this.next();
                Expression lhs = this.unaryExpression(yield, await);
                return this.verifyIncDecExpression(unaryToken, opType, lhs, false);
            }
        }
        if (this.isAwait() && await) {
            return this.awaitExpression(yield);
        }
        Expression expression = this.leftHandSideExpression(yield, await);
        if (this.last != TokenType.EOL) {
            switch (this.type) {
                case INCPREFIX: 
                case DECPREFIX: {
                    long opToken = this.token;
                    TokenType opType = this.type;
                    Expression lhs = expression;
                    this.next();
                    return this.verifyIncDecExpression(opToken, opType, lhs, true);
                }
            }
        }
        return expression;
    }

    private Expression verifyDeleteExpression(int unaryLine, long unaryToken, Expression expr) {
        if (expr instanceof BaseNode || expr instanceof IdentNode) {
            if (this.isStrictMode) {
                if (expr instanceof IdentNode) {
                    IdentNode ident = (IdentNode)expr;
                    if (!ident.isThis() && !ident.isMetaProperty()) {
                        throw this.error(AbstractParser.message("strict.cant.delete.ident", ident.getName()), unaryToken);
                    }
                } else if (expr instanceof AccessNode && ((AccessNode)expr).isPrivate()) {
                    throw this.error(AbstractParser.message("strict.cant.delete.private", new String[0]), unaryToken);
                }
            }
            return new UnaryNode(unaryToken, expr);
        }
        this.appendStatement(new ExpressionStatement(unaryLine, unaryToken, this.finish, expr));
        return LiteralNode.newInstance(unaryToken, this.finish, true);
    }

    private Expression verifyIncDecExpression(long unaryToken, TokenType opType, Expression lhs, boolean isPostfix) {
        assert (lhs != null);
        if (lhs instanceof IdentNode) {
            IdentNode ident = (IdentNode)lhs;
            if (!Parser.checkIdentLValue(ident) || ident.isMetaProperty()) {
                throw this.invalidLHSError(lhs);
            }
            assert (opType == TokenType.INCPREFIX || opType == TokenType.DECPREFIX);
            String contextString = opType == TokenType.INCPREFIX ? "operand for ++ operator" : "operand for -- operator";
            this.verifyStrictIdent((IdentNode)lhs, contextString);
        } else if (!(lhs instanceof AccessNode) && !(lhs instanceof IndexNode) || ((BaseNode)lhs).isOptional()) {
            throw this.invalidLHSError(lhs);
        }
        return Parser.incDecExpression(unaryToken, opType, lhs, isPostfix);
    }

    private Expression expression() {
        return this.expression(true, this.inGeneratorFunction(), this.inAsyncFunction());
    }

    private Expression expression(boolean in, boolean yield, boolean await) {
        return this.expression(in, yield, await, false);
    }

    private Expression expression(boolean in, boolean yield, boolean await, boolean inPatternPosition) {
        Expression assignmentExpression = this.assignmentExpression(in, yield, await, inPatternPosition);
        while (this.type == TokenType.COMMARIGHT) {
            long commaToken = this.token;
            this.next();
            Expression rhs = this.assignmentExpression(in, yield, await);
            assignmentExpression = new BinaryNode(commaToken, assignmentExpression, rhs);
        }
        return assignmentExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression parenthesizedExpressionAndArrowParameterList(boolean yield, boolean await) {
        long primaryToken = this.token;
        assert (this.type == TokenType.LPAREN);
        this.next();
        if (ES6_ARROW_FUNCTION && this.isES6()) {
            if (this.type == TokenType.RPAREN) {
                this.nextOrEOL();
                this.expectDontAdvance(TokenType.ARROW);
                return new ExpressionList(primaryToken, this.finish, Collections.emptyList());
            }
            if (ES6_REST_PARAMETER && this.type == TokenType.ELLIPSIS) {
                IdentNode name = null;
                ParserContextFunctionNode functionNode = this.createParserContextFunctionNode(name, primaryToken, 65536, 0);
                functionNode.setInternalName(ARROW_FUNCTION_NAME);
                this.lc.push(functionNode);
                ParserContextBlockNode parameterBlock = functionNode.createParameterBlock();
                this.lc.push(parameterBlock);
                try {
                    this.formalParameterList(false, false);
                    this.expectDontAdvance(TokenType.RPAREN);
                    this.nextOrEOL();
                    this.expectDontAdvance(TokenType.ARROW);
                    ExpressionList expressionList = new ExpressionList(primaryToken, this.finish, Collections.singletonList(functionNode.getParameters().get(0)));
                    return expressionList;
                }
                finally {
                    this.restoreBlock(parameterBlock);
                    this.lc.pop(functionNode);
                }
            }
        }
        Expression assignmentExpression = this.assignmentExpression(true, yield, await, true);
        boolean hasCoverInitializedName = Parser.hasCoverInitializedName(assignmentExpression);
        while (this.type == TokenType.COMMARIGHT) {
            long commaToken = this.token;
            this.next();
            boolean rhsRestParameter = false;
            if (ES6_ARROW_FUNCTION && ES6_REST_PARAMETER && this.isES6() && this.type == TokenType.ELLIPSIS) {
                if (this.isRestParameterEndOfArrowParameterList()) {
                    this.next();
                    rhsRestParameter = true;
                }
            } else if (ES6_ARROW_FUNCTION && ES8_TRAILING_COMMA && this.isES2017() && this.type == TokenType.RPAREN && this.lookaheadIsArrow()) break;
            Expression rhs = this.assignmentExpression(true, yield, await, true);
            boolean bl = hasCoverInitializedName = hasCoverInitializedName || Parser.hasCoverInitializedName(rhs);
            if (rhsRestParameter) {
                rhs = ((IdentNode)rhs).setIsRestParameter();
                assert (this.type == TokenType.RPAREN);
            }
            assignmentExpression = new BinaryNode(commaToken, assignmentExpression, rhs);
        }
        boolean arrowAhead = this.lookaheadIsArrow();
        if (hasCoverInitializedName && (this.type != TokenType.RPAREN || !arrowAhead)) {
            throw this.error(AbstractParser.message(MESSAGE_INVALID_PROPERTY_INITIALIZER, new String[0]));
        }
        this.expect(TokenType.RPAREN);
        if (!arrowAhead) {
            assignmentExpression.makeParenthesized(Token.descPosition(primaryToken), this.finish);
        }
        return assignmentExpression;
    }

    private Expression expression(int minPrecedence, boolean in, boolean yield, boolean await) {
        return this.expression(this.unaryExpression(yield, await), minPrecedence, in, yield, await);
    }

    private JoinPredecessorExpression joinPredecessorExpression() {
        return new JoinPredecessorExpression(this.expression());
    }

    private Expression expression(Expression exprLhs, int minPrecedence, boolean in, boolean yield, boolean await) {
        int precedence = this.type.getPrecedence();
        Expression lhs = exprLhs;
        while (this.checkOperator(in) && precedence >= minPrecedence) {
            long op = this.token;
            if (this.type == TokenType.TERNARY) {
                this.next();
                Expression trueExpr = this.assignmentExpression(true, yield, await);
                this.expect(TokenType.COLON);
                Expression falseExpr = this.assignmentExpression(in, yield, await);
                lhs = new TernaryNode(op, lhs, new JoinPredecessorExpression(trueExpr), new JoinPredecessorExpression(falseExpr));
            } else {
                this.next();
                assert (!Token.descType(op).isAssignment());
                Expression rhs = this.unaryExpression(yield, await);
                int nextPrecedence = this.type.getPrecedence();
                while (this.checkOperator(in) && (nextPrecedence > precedence || nextPrecedence == precedence && !this.type.isLeftAssociative())) {
                    rhs = this.expression(rhs, nextPrecedence, in, yield, await);
                    nextPrecedence = this.type.getPrecedence();
                }
                lhs = this.newBinaryExpression(op, lhs, rhs);
            }
            precedence = this.type.getPrecedence();
        }
        return lhs;
    }

    private boolean checkOperator(boolean in) {
        return !(!this.type.isOperator(in) || this.type == TokenType.EXP && !this.isES6() || this.type == TokenType.NULLISHCOALESC && !this.isES2020());
    }

    private Expression assignmentExpression(boolean in) {
        return this.assignmentExpression(in, this.inGeneratorFunction(), this.inAsyncFunction(), false);
    }

    private Expression assignmentExpression(boolean in, boolean yield, boolean await) {
        return this.assignmentExpression(in, yield, await, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression assignmentExpression(boolean in, boolean yield, boolean await, boolean inPatternPosition) {
        if (this.type == TokenType.YIELD && yield) {
            return this.yieldExpression(in, await);
        }
        boolean asyncArrow = this.isAsync() && this.lookaheadIsAsyncArrowParameterListStart();
        long startToken = this.token;
        int startLine = this.line;
        Expression exprLhs = this.conditionalExpression(in, yield, await);
        if (asyncArrow && exprLhs instanceof IdentNode && this.isBindingIdentifier() && this.lookaheadIsArrow()) {
            exprLhs = this.primaryExpression(yield, await);
        }
        if (ES6_ARROW_FUNCTION && this.type == TokenType.ARROW && this.isES6() && this.checkNoLineTerminator()) {
            Expression paramListExpr = exprLhs instanceof ExpressionList ? Parser.convertExpressionListToExpression((ExpressionList)exprLhs) : exprLhs;
            return this.arrowFunction(startToken, startLine, paramListExpr, asyncArrow);
        }
        assert (!(exprLhs instanceof ExpressionList));
        if (this.type.isAssignment()) {
            boolean isAssign;
            boolean bl = isAssign = this.type == TokenType.ASSIGN;
            if (isAssign) {
                this.pushDefaultName(exprLhs);
            }
            try {
                long assignToken = this.token;
                this.next();
                Expression exprRhs = this.assignmentExpression(in, yield, await);
                Expression expression = this.verifyAssignment(assignToken, exprLhs, exprRhs, inPatternPosition);
                return expression;
            }
            finally {
                if (isAssign) {
                    this.popDefaultName();
                }
            }
        }
        if (!inPatternPosition && Parser.hasCoverInitializedName(exprLhs)) {
            throw this.error(AbstractParser.message(MESSAGE_INVALID_PROPERTY_INITIALIZER, new String[0]));
        }
        return exprLhs;
    }

    private Expression conditionalExpression(boolean in, boolean yield, boolean await) {
        return this.expression(TokenType.TERNARY.getPrecedence(), in, yield, await);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression arrowFunction(long startToken, int functionLine, Expression paramListExpr, boolean async) {
        assert (this.type != TokenType.ARROW || this.checkNoLineTerminator());
        this.expect(TokenType.ARROW);
        long functionToken = Token.recast(startToken, TokenType.ARROW);
        IdentNode name = null;
        ParserContextFunctionNode functionNode = this.createParserContextFunctionNode(name, functionToken, 65536, functionLine);
        functionNode.setInternalName(ARROW_FUNCTION_NAME);
        functionNode.setFlag(1);
        if (async) {
            functionNode.setFlag(0x2000000);
        }
        this.lc.push(functionNode);
        try {
            FunctionNode function;
            Block functionBody;
            ParserContextBlockNode parameterBlock = functionNode.createParameterBlock();
            this.lc.push(parameterBlock);
            try {
                this.convertArrowFunctionParameterList(paramListExpr, functionNode);
                functionBody = this.functionBody(functionNode);
            }
            finally {
                this.restoreBlock(parameterBlock);
            }
            this.verifyParameterList(functionNode);
            if (parameterBlock != null) {
                this.markEvalInArrowParameterList(parameterBlock);
                functionBody = Parser.wrapParameterBlock(parameterBlock, functionBody);
            }
            FunctionNode functionNode2 = function = this.createFunctionNode(functionNode, functionToken, name, functionLine, functionBody);
            return functionNode2;
        }
        finally {
            this.lc.pop(functionNode);
        }
    }

    private void markEvalInArrowParameterList(ParserContextBlockNode parameterBlock) {
        Iterator<ParserContextFunctionNode> iter = this.lc.getFunctions();
        final ParserContextFunctionNode current = iter.next();
        ParserContextFunctionNode parent = iter.next();
        final int flagsToPropagate = parent.getFlag(0x8000020);
        if (flagsToPropagate != 0) {
            for (Statement st : parameterBlock.getStatements()) {
                st.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

                    @Override
                    public boolean enterCallNode(CallNode callNode) {
                        if (callNode.isEval()) {
                            current.setFlag(flagsToPropagate);
                        }
                        return true;
                    }
                });
            }
        }
    }

    private static Expression convertExpressionListToExpression(ExpressionList exprList) {
        if (exprList.getExpressions().isEmpty()) {
            return null;
        }
        if (exprList.getExpressions().size() == 1) {
            return exprList.getExpressions().get(0);
        }
        long recastToken = Token.recast(exprList.getToken(), TokenType.COMMARIGHT);
        Expression result = null;
        for (Expression expression : exprList.getExpressions()) {
            result = result == null ? expression : new BinaryNode(recastToken, result, expression);
        }
        return result;
    }

    private void verifyContainsNeitherYieldNorAwaitExpression(Expression expression) {
        expression.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public boolean enterUnaryNode(UnaryNode unaryNode) {
                switch (unaryNode.tokenType()) {
                    case AWAIT: 
                    case YIELD: 
                    case YIELD_STAR: {
                        throw Parser.this.error(AbstractParser.message(Parser.MESSAGE_INVALID_ARROW_PARAMETER, new String[0]), unaryNode.getToken());
                    }
                }
                return super.enterUnaryNode(unaryNode);
            }
        });
    }

    private void convertArrowFunctionParameterList(Expression paramListExpr, ParserContextFunctionNode function) {
        if (paramListExpr == null) {
            return;
        }
        this.verifyContainsNeitherYieldNorAwaitExpression(paramListExpr);
        int functionLine = function.getLineNumber();
        if (paramListExpr instanceof IdentNode || paramListExpr.isTokenType(TokenType.ASSIGN) || this.isDestructuringLhs(paramListExpr) || paramListExpr.isTokenType(TokenType.SPREAD_ARGUMENT)) {
            this.convertArrowParameter(paramListExpr, 0, functionLine, function);
        } else if (paramListExpr instanceof BinaryNode && Token.descType(paramListExpr.getToken()) == TokenType.COMMARIGHT) {
            ArrayList<Expression> params = new ArrayList<Expression>();
            Expression car = paramListExpr;
            do {
                Expression cdr = ((BinaryNode)car).getRhs();
                params.add(cdr);
            } while ((car = ((BinaryNode)car).getLhs()) instanceof BinaryNode && Token.descType(car.getToken()) == TokenType.COMMARIGHT);
            params.add(car);
            int i = params.size() - 1;
            int pos = 0;
            while (i >= 0) {
                Expression param = (Expression)params.get(i);
                if (i != 0 && param.isTokenType(TokenType.SPREAD_ARGUMENT)) {
                    throw this.error(AbstractParser.message(MESSAGE_INVALID_ARROW_PARAMETER, new String[0]), param.getToken());
                }
                this.convertArrowParameter(param, pos, functionLine, function);
                --i;
                ++pos;
            }
        } else {
            throw this.error(AbstractParser.message("expected.arrow.parameter", new String[0]), paramListExpr.getToken());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertArrowParameter(Expression param, int index, int paramLine, ParserContextFunctionNode currentFunction) {
        assert (index == currentFunction.getParameterCount());
        if (param instanceof IdentNode) {
            IdentNode ident = (IdentNode)param;
            this.verifyStrictIdent(ident, FUNCTION_PARAMETER_CONTEXT);
            if (ident.isParenthesized() || currentFunction.isAsync() && TokenType.AWAIT.getName().equals(ident.getName())) {
                throw this.error(AbstractParser.message(MESSAGE_INVALID_ARROW_PARAMETER, new String[0]), param.getToken());
            }
            currentFunction.addParameter(ident);
            return;
        }
        if (param.isTokenType(TokenType.ASSIGN)) {
            Expression lhs = ((BinaryNode)param).getLhs();
            long paramToken = lhs.getToken();
            Expression initializer = ((BinaryNode)param).getRhs();
            if (initializer instanceof IdentNode && ((IdentNode)initializer).getName().equals(TokenType.AWAIT.getName())) {
                throw this.error(AbstractParser.message(MESSAGE_INVALID_ARROW_PARAMETER, new String[0]), param.getToken());
            }
            if (this.lc.getCurrentNonArrowFunction().getFlag(32768) != 0) {
                currentFunction.setFlag(32768);
            }
            if (lhs instanceof IdentNode && !lhs.isParenthesized()) {
                IdentNode ident = (IdentNode)lhs;
                if (Parser.isAnonymousFunctionDefinition(initializer)) {
                    initializer = this.setAnonymousFunctionName(initializer, ident.getName());
                }
                Parser.addDefaultParameter(paramToken, param.getFinish(), paramLine, ident, initializer, currentFunction);
                return;
            }
            if (!this.isDestructuringLhs(lhs)) throw this.error(AbstractParser.message(MESSAGE_INVALID_ARROW_PARAMETER, new String[0]), paramToken);
            this.verifyDestructuringParameterBindingPattern(lhs, paramToken, paramLine);
            this.addDestructuringParameter(paramToken, param.getFinish(), paramLine, lhs, initializer, currentFunction, false);
            return;
        } else if (this.isDestructuringLhs(param)) {
            long paramToken = param.getToken();
            this.verifyDestructuringParameterBindingPattern(param, paramToken, paramLine);
            this.addDestructuringParameter(paramToken, param.getFinish(), paramLine, param, null, currentFunction, false);
            return;
        } else {
            if (!param.isTokenType(TokenType.SPREAD_ARGUMENT)) throw this.error(AbstractParser.message(MESSAGE_INVALID_ARROW_PARAMETER, new String[0]), param.getToken());
            Expression expression = ((UnaryNode)param).getExpression();
            if (!(expression instanceof IdentNode) || !this.identAtTheEndOfArrowParamList()) throw this.error(AbstractParser.message(MESSAGE_INVALID_ARROW_PARAMETER, new String[0]), param.getToken());
            IdentNode rest = ((IdentNode)expression).setIsRestParameter();
            this.convertArrowParameter(rest, index, paramLine, currentFunction);
        }
    }

    private boolean identAtTheEndOfArrowParamList() {
        TokenType t;
        int idx = this.k - 1;
        assert (this.T(idx) == TokenType.ARROW);
        while ((t = this.T(--idx)) == TokenType.COMMENT) {
        }
        if (t != TokenType.RPAREN) {
            return false;
        }
        while ((t = this.T(--idx)) == TokenType.COMMENT) {
        }
        return t == TokenType.IDENT;
        {
        }
    }

    private boolean checkNoLineTerminator() {
        assert (this.type == TokenType.ARROW);
        if (this.last == TokenType.RPAREN) {
            return true;
        }
        if (this.last == TokenType.IDENT) {
            return true;
        }
        block5: for (int i = this.k - 1; i >= 0; --i) {
            TokenType t = this.T(i);
            switch (t) {
                case RPAREN: 
                case IDENT: {
                    return true;
                }
                case EOL: {
                    return false;
                }
                case COMMENT: {
                    continue block5;
                }
                default: {
                    return t.isContextualKeyword() || t.isFutureStrict();
                }
            }
        }
        return false;
    }

    private boolean isRestParameterEndOfArrowParameterList() {
        TokenType t;
        assert (this.type == TokenType.ELLIPSIS);
        int i = 1;
        while ((t = this.T(this.k + i++)) != TokenType.IDENT && !t.isContextualKeyword()) {
            if (t == TokenType.EOL || t == TokenType.COMMENT) continue;
            return false;
        }
        while ((t = this.T(this.k + i++)) != TokenType.RPAREN) {
            if (t == TokenType.EOL || t == TokenType.COMMENT) continue;
            return false;
        }
        while ((t = this.T(this.k + i++)) != TokenType.ARROW) {
            if (t == TokenType.COMMENT) continue;
            return false;
        }
        return true;
    }

    private boolean lookaheadIsArrow() {
        TokenType t;
        int i = 1;
        while ((t = this.T(this.k + i++)) != TokenType.ARROW) {
            if (t == TokenType.COMMENT) continue;
            return false;
        }
        return true;
    }

    private void endOfLine() {
        switch (this.type) {
            case EOL: 
            case SEMICOLON: {
                this.next();
                break;
            }
            case EOF: 
            case RBRACE: 
            case RPAREN: 
            case RBRACKET: {
                break;
            }
            default: {
                if (this.last == TokenType.EOL) break;
                this.expect(TokenType.SEMICOLON);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression templateLiteral(boolean yield, boolean await) {
        assert (this.type == TokenType.TEMPLATE || this.type == TokenType.TEMPLATE_HEAD);
        boolean noSubstitutionTemplate = this.type == TokenType.TEMPLATE;
        long lastLiteralToken = this.token;
        boolean previousPauseOnRightBrace = this.lexer.pauseOnRightBrace;
        try {
            TokenType lastLiteralType;
            this.lexer.pauseOnRightBrace = true;
            LiteralNode<?> literal = this.getLiteral();
            if (noSubstitutionTemplate) {
                LiteralNode<?> literalNode = literal;
                return literalNode;
            }
            Expression concat = literal;
            do {
                Expression expression = this.templateLiteralExpression(yield, await);
                expression = new RuntimeNode(Token.recast(expression.getToken(), TokenType.VOID), expression.getFinish(), RuntimeNode.Request.TO_STRING, expression);
                concat = new BinaryNode(Token.recast(lastLiteralToken, TokenType.ADD), concat, expression);
                lastLiteralType = this.type;
                lastLiteralToken = this.token;
                literal = this.getLiteral();
                concat = new BinaryNode(Token.recast(lastLiteralToken, TokenType.ADD), concat, literal);
            } while (lastLiteralType == TokenType.TEMPLATE_MIDDLE);
            Expression expression = concat;
            return expression;
        }
        finally {
            this.lexer.pauseOnRightBrace = previousPauseOnRightBrace;
        }
    }

    private Expression templateLiteralExpression(boolean yield, boolean await) {
        assert (this.lexer.pauseOnRightBrace);
        Expression expression = this.expression(true, yield, await);
        if (this.type != TokenType.RBRACE) {
            throw this.error(AbstractParser.message("unterminated.template.expression", new String[0]), this.token);
        }
        this.lexer.scanTemplateSpan();
        this.next();
        assert (this.type == TokenType.TEMPLATE_MIDDLE || this.type == TokenType.TEMPLATE_TAIL);
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Expression> templateLiteralArgumentList(boolean yield, boolean await) {
        assert (this.type == TokenType.TEMPLATE || this.type == TokenType.TEMPLATE_HEAD);
        ArrayList<Expression> argumentList = new ArrayList<Expression>();
        ArrayList<Expression> rawStrings = new ArrayList<Expression>();
        ArrayList<Expression> cookedStrings = new ArrayList<Expression>();
        argumentList.add(null);
        long templateToken = this.token;
        boolean hasSubstitutions = this.type == TokenType.TEMPLATE_HEAD;
        boolean previousPauseOnRightBrace = this.lexer.pauseOnRightBrace;
        try {
            this.lexer.pauseOnRightBrace = true;
            this.addTemplateLiteralString(rawStrings, cookedStrings);
            if (hasSubstitutions) {
                TokenType lastLiteralType;
                do {
                    Expression expression = this.templateLiteralExpression(yield, await);
                    argumentList.add(expression);
                    lastLiteralType = this.type;
                    this.addTemplateLiteralString(rawStrings, cookedStrings);
                } while (lastLiteralType == TokenType.TEMPLATE_MIDDLE);
            }
            LiteralNode<Expression[]> rawStringArray = LiteralNode.newInstance(templateToken, this.finish, rawStrings);
            LiteralNode<Expression[]> cookedStringArray = LiteralNode.newInstance(templateToken, this.finish, cookedStrings);
            RuntimeNode templateObject = new RuntimeNode(templateToken, this.finish, RuntimeNode.Request.GET_TEMPLATE_OBJECT, rawStringArray, cookedStringArray);
            argumentList.set(0, templateObject);
            List<Expression> list = Parser.optimizeList(argumentList);
            return list;
        }
        finally {
            this.lexer.pauseOnRightBrace = previousPauseOnRightBrace;
        }
    }

    private void addTemplateLiteralString(ArrayList<Expression> rawStrings, ArrayList<Expression> cookedStrings) {
        long stringToken = this.token;
        String rawString = this.lexer.valueOfRawString(stringToken);
        String cookedString = this.lexer.valueOfTaggedTemplateString(stringToken);
        this.next();
        Expression cookedExpression = cookedString == null ? Parser.newUndefinedLiteral(stringToken, this.finish) : LiteralNode.newInstance(stringToken, cookedString);
        rawStrings.add(LiteralNode.newInstance(stringToken, rawString));
        cookedStrings.add(cookedExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode module(String moduleName) {
        int functionStart = Math.min(Token.descPosition(Token.withDelimiter(this.token)), this.finish);
        long functionToken = Token.toDesc(TokenType.FUNCTION, functionStart, this.source.getLength() - functionStart);
        int functionLine = this.line;
        Scope moduleScope = Scope.createModule();
        IdentNode ident = null;
        ParserContextFunctionNode script = this.createParserContextFunctionNode(ident, functionToken, 131072, functionLine, Collections.emptyList(), 0, moduleScope);
        script.setInternalName(moduleName);
        this.lc.push(script);
        ParserContextModuleNode module = new ParserContextModuleNode(moduleName, moduleScope, this);
        ParserContextBlockNode body = this.newBlock(moduleScope);
        this.functionDeclarations = new ArrayList<Statement>();
        try {
            this.moduleBody(module);
            long yieldToken = Token.toDesc(TokenType.YIELD, functionStart, 0);
            this.prependStatement(new ExpressionStatement(functionLine, yieldToken, functionLine, new UnaryNode(yieldToken, (Expression)Parser.newUndefinedLiteral(yieldToken, this.finish))));
            script.setFlag(0x1000000);
            this.addFunctionDeclarations(script);
        }
        finally {
            this.functionDeclarations = null;
            this.restoreBlock(body);
            this.lc.pop(script);
        }
        body.setFlag(1);
        Block programBody = new Block(functionToken, this.finish, body.getFlags() | 0x10 | 0x20 | 0x400, body.getScope(), body.getStatements());
        script.setLastToken(this.token);
        this.expect(TokenType.EOF);
        script.setModule(module.createModule());
        return this.createFunctionNode(script, functionToken, ident, functionLine, programBody);
    }

    private void moduleBody(ParserContextModuleNode module) {
        block5: while (this.type != TokenType.EOF) {
            switch (this.type) {
                case EOF: {
                    break block5;
                }
                case EXPORT: {
                    this.exportDeclaration(module);
                    continue block5;
                }
                case IMPORT: {
                    if (!this.isImportExpression()) {
                        this.importDeclaration(module);
                        continue block5;
                    }
                }
                default: {
                    this.statement(true, 0, false, false, false);
                    continue block5;
                }
            }
        }
    }

    private boolean isImportExpression() {
        assert (this.type == TokenType.IMPORT);
        if (!this.isES2020()) {
            return false;
        }
        TokenType la = this.lookahead();
        return la == TokenType.PERIOD || la == TokenType.LPAREN;
    }

    private void declareImportBinding(IdentNode ident, boolean star) {
        Scope moduleScope = this.lc.getCurrentBlock().getScope();
        assert (moduleScope.isModuleScope());
        if (moduleScope.hasSymbol(ident.getName())) {
            throw this.error(ECMAErrors.getMessage("syntax.error.redeclare.variable", ident.getName()), ident.getToken());
        }
        moduleScope.putSymbol(new Symbol(ident.getName(), 0x402 | (star ? 0 : 16384)));
    }

    private void declareImportBinding(IdentNode ident) {
        this.declareImportBinding(ident, false);
    }

    private void declareImportStarBinding(IdentNode ident) {
        this.declareImportBinding(ident, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importDeclaration(ParserContextModuleNode module) {
        long importToken = this.token;
        this.expect(TokenType.IMPORT);
        if (this.type == TokenType.STRING || this.type == TokenType.ESCSTRING) {
            String moduleSpecifier = (String)this.getValue();
            long specifierToken = this.token;
            this.next();
            LiteralNode<String> specifier = LiteralNode.newInstance(specifierToken, moduleSpecifier);
            module.addModuleRequest(moduleSpecifier);
            module.addImport(new ImportNode(importToken, Token.descPosition(importToken), this.finish, specifier));
        } else {
            List<Module.ImportEntry> importEntries;
            ImportClauseNode importClause;
            long startToken = this.token;
            if (this.type == TokenType.MUL) {
                NameSpaceImportNode namespaceNode = this.nameSpaceImport();
                importClause = new ImportClauseNode(startToken, Token.descPosition(startToken), this.finish, namespaceNode);
                importEntries = Collections.singletonList(Module.ImportEntry.importStarAsNameSpaceFrom(namespaceNode.getBindingIdentifier().getName()));
            } else if (this.type == TokenType.LBRACE) {
                NamedImportsNode namedImportsNode = this.namedImports();
                importClause = new ImportClauseNode(startToken, Token.descPosition(startToken), this.finish, namedImportsNode);
                importEntries = Parser.convert(namedImportsNode);
            } else {
                if (!this.isBindingIdentifier()) throw this.error(AbstractParser.message("expected.import", new String[0]));
                IdentNode importedDefaultBinding = this.bindingIdentifier(false, false, IMPORTED_BINDING_CONTEXT);
                this.declareImportBinding(importedDefaultBinding);
                Module.ImportEntry defaultImport = Module.ImportEntry.importDefault(importedDefaultBinding.getName());
                if (this.type == TokenType.COMMARIGHT) {
                    this.next();
                    if (this.type == TokenType.MUL) {
                        NameSpaceImportNode namespaceNode = this.nameSpaceImport();
                        importClause = new ImportClauseNode(startToken, Token.descPosition(startToken), this.finish, importedDefaultBinding, namespaceNode);
                        importEntries = new ArrayList<Module.ImportEntry>(2);
                        importEntries.add(defaultImport);
                        importEntries.add(Module.ImportEntry.importStarAsNameSpaceFrom(namespaceNode.getBindingIdentifier().getName()));
                    } else {
                        if (this.type != TokenType.LBRACE) throw this.error(AbstractParser.message("expected.named.import", new String[0]));
                        NamedImportsNode namedImportsNode = this.namedImports();
                        importClause = new ImportClauseNode(startToken, Token.descPosition(startToken), this.finish, importedDefaultBinding, namedImportsNode);
                        importEntries = Parser.convert(namedImportsNode);
                        importEntries.add(0, defaultImport);
                    }
                } else {
                    importClause = new ImportClauseNode(startToken, Token.descPosition(startToken), this.finish, importedDefaultBinding);
                    importEntries = Collections.singletonList(defaultImport);
                }
            }
            FromNode fromNode = this.fromClause();
            module.addImport(new ImportNode(importToken, Token.descPosition(importToken), this.finish, importClause, fromNode));
            String moduleSpecifier = fromNode.getModuleSpecifier().getValue();
            module.addModuleRequest(moduleSpecifier);
            for (int i = 0; i < importEntries.size(); ++i) {
                module.addImportEntry(importEntries.get(i).withFrom(moduleSpecifier));
            }
        }
        this.endOfLine();
    }

    private NameSpaceImportNode nameSpaceImport() {
        long startToken = this.token;
        assert (this.type == TokenType.MUL);
        this.next();
        this.expect(TokenType.AS);
        IdentNode localNameSpace = this.bindingIdentifier(false, false, IMPORTED_BINDING_CONTEXT);
        this.declareImportStarBinding(localNameSpace);
        return new NameSpaceImportNode(startToken, Token.descPosition(startToken), this.finish, localNameSpace);
    }

    private NamedImportsNode namedImports() {
        long startToken = this.token;
        assert (this.type == TokenType.LBRACE);
        this.next();
        ArrayList<ImportSpecifierNode> importSpecifiers = new ArrayList<ImportSpecifierNode>();
        while (this.type != TokenType.RBRACE) {
            boolean bindingIdentifier = this.isBindingIdentifier();
            long nameToken = this.token;
            IdentNode importName = this.getIdentifierName();
            if (this.type == TokenType.AS) {
                this.next();
                IdentNode localName = this.bindingIdentifier(false, false, IMPORTED_BINDING_CONTEXT);
                importSpecifiers.add(new ImportSpecifierNode(nameToken, Token.descPosition(nameToken), this.finish, localName, importName));
                this.declareImportBinding(localName);
            } else if (bindingIdentifier) {
                this.verifyIdent(importName, false, false);
                this.verifyStrictIdent(importName, IMPORTED_BINDING_CONTEXT);
                importSpecifiers.add(new ImportSpecifierNode(nameToken, Token.descPosition(nameToken), this.finish, importName, null));
                this.declareImportBinding(importName);
            } else {
                throw this.error(AbstractParser.message("expected.binding.identifier", new String[0]), nameToken);
            }
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        this.expect(TokenType.RBRACE);
        return new NamedImportsNode(startToken, Token.descPosition(startToken), this.finish, Parser.optimizeList(importSpecifiers));
    }

    private FromNode fromClause() {
        int fromStart = this.start;
        long fromToken = this.token;
        this.expect(TokenType.FROM);
        if (this.type == TokenType.STRING || this.type == TokenType.ESCSTRING) {
            String moduleSpecifier = (String)this.getValue();
            long specifierToken = this.token;
            this.next();
            LiteralNode<String> specifier = LiteralNode.newInstance(specifierToken, moduleSpecifier);
            return new FromNode(fromToken, fromStart, this.finish, specifier);
        }
        throw this.error(this.expectMessage(TokenType.STRING));
    }

    private void exportDeclaration(ParserContextModuleNode module) {
        long exportToken = this.token;
        this.expect(TokenType.EXPORT);
        switch (this.type) {
            case MUL: {
                this.next();
                IdentNode exportName = null;
                if (this.type == TokenType.AS && this.isES2020()) {
                    this.next();
                    exportName = this.getIdentifierName();
                }
                FromNode from = this.fromClause();
                String moduleRequest = from.getModuleSpecifier().getValue();
                module.addModuleRequest(moduleRequest);
                module.addExport(new ExportNode(exportToken, Token.descPosition(exportToken), this.finish, exportName, from));
                this.endOfLine();
                break;
            }
            case LBRACE: {
                NamedExportsNode exportClause = this.namedExports();
                FromNode from = null;
                if (this.type == TokenType.FROM) {
                    from = this.fromClause();
                    String moduleRequest = from.getModuleSpecifier().getValue();
                    module.addModuleRequest(moduleRequest);
                }
                module.addExport(new ExportNode(exportToken, Token.descPosition(exportToken), this.finish, exportClause, from));
                this.endOfLine();
                break;
            }
            case DEFAULT: {
                FunctionNode functionNode;
                Expression assignmentExpression;
                this.next();
                IdentNode ident = null;
                int lineNumber = this.line;
                long rhsToken = this.token;
                boolean hoistableDeclaration = false;
                switch (this.type) {
                    case FUNCTION: {
                        assignmentExpression = this.functionExpression(false, true);
                        hoistableDeclaration = true;
                        break;
                    }
                    case CLASS: {
                        assignmentExpression = this.classDeclaration(false, false, true);
                        ident = ((ClassNode)assignmentExpression).getIdent();
                        break;
                    }
                    default: {
                        if (this.isAsync() && this.lookaheadIsAsyncFunction()) {
                            assignmentExpression = this.asyncFunctionExpression(false, true);
                            hoistableDeclaration = true;
                            break;
                        }
                        assignmentExpression = this.assignmentExpression(true, false, false);
                        this.endOfLine();
                    }
                }
                if (hoistableDeclaration && !(functionNode = (FunctionNode)assignmentExpression).isAnonymous()) {
                    ident = functionNode.getIdent();
                    assignmentExpression = functionNode.setFlag(null, 2);
                }
                if (ident == null) {
                    ident = new IdentNode(Token.recast(rhsToken, TokenType.IDENT), this.finish, "*default*");
                    if (Parser.isAnonymousFunctionDefinition(assignmentExpression)) {
                        assignmentExpression = this.setAnonymousFunctionName(assignmentExpression, "default");
                    }
                }
                VarNode varNode = new VarNode(lineNumber, Token.recast(rhsToken, hoistableDeclaration ? TokenType.VAR : TokenType.LET), this.finish, ident, assignmentExpression, (hoistableDeclaration ? 0 : 1) | 8);
                this.declareVar(this.lc.getCurrentScope(), varNode);
                if (hoistableDeclaration) {
                    this.functionDeclarations.add(varNode);
                } else {
                    this.lc.appendStatementToCurrentNode(varNode);
                }
                module.addExport(new ExportNode(exportToken, Token.descPosition(exportToken), this.finish, ident, assignmentExpression, true));
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                List<Statement> statements = this.lc.getCurrentBlock().getStatements();
                int previousEnd = statements.size();
                this.variableStatement(this.type);
                for (Statement statement : statements.subList(previousEnd, statements.size())) {
                    if (!(statement instanceof VarNode)) continue;
                    VarNode varNode = (VarNode)statement;
                    module.addExport(new ExportNode(exportToken, Token.descPosition(exportToken), this.finish, varNode.getName(), varNode));
                }
                break;
            }
            case CLASS: {
                ClassNode classDeclaration = this.classDeclaration(false, false, false);
                module.addExport(new ExportNode(exportToken, Token.descPosition(exportToken), this.finish, classDeclaration.getIdent(), classDeclaration, false));
                break;
            }
            case FUNCTION: {
                FunctionNode functionDeclaration = (FunctionNode)this.functionExpression(true, true);
                module.addExport(new ExportNode(exportToken, Token.descPosition(exportToken), this.finish, functionDeclaration.getIdent(), functionDeclaration, false));
                break;
            }
            default: {
                if (this.isAsync() && this.lookaheadIsAsyncFunction()) {
                    FunctionNode functionDeclaration = (FunctionNode)this.asyncFunctionExpression(true, true);
                    module.addExport(new ExportNode(exportToken, Token.descPosition(exportToken), this.finish, functionDeclaration.getIdent(), functionDeclaration, false));
                    break;
                }
                throw this.error(AbstractParser.message("invalid.export", new String[0]), this.token);
            }
        }
    }

    private NamedExportsNode namedExports() {
        long startToken = this.token;
        assert (this.type == TokenType.LBRACE);
        this.next();
        ArrayList<ExportSpecifierNode> exports = new ArrayList<ExportSpecifierNode>();
        long reservedWordToken = 0L;
        while (this.type != TokenType.RBRACE) {
            long nameToken = this.token;
            TokenType nameType = this.type;
            IdentNode localName = this.getIdentifierName();
            if ((Parser.isReservedWord(nameType) || Parser.isEscapedIdent(localName) && (Parser.isReservedWordSequence(localName.getName()) || Parser.isFutureStrictName(localName))) && reservedWordToken == 0L) {
                reservedWordToken = nameToken;
            }
            if (this.type == TokenType.AS) {
                this.next();
                IdentNode exportName = this.getIdentifierName();
                exports.add(new ExportSpecifierNode(nameToken, Token.descPosition(nameToken), this.finish, localName, exportName));
            } else {
                exports.add(new ExportSpecifierNode(nameToken, Token.descPosition(nameToken), this.finish, localName, null));
            }
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        this.expect(TokenType.RBRACE);
        if (reservedWordToken != 0L && this.type != TokenType.FROM) {
            throw this.error(this.expectMessage(TokenType.IDENT, reservedWordToken), reservedWordToken);
        }
        return new NamedExportsNode(startToken, Token.descPosition(startToken), this.finish, Parser.optimizeList(exports));
    }

    private static boolean isReservedWord(TokenType type) {
        return type.getKind() == TokenKind.KEYWORD || type.getKind() == TokenKind.FUTURE || type.getKind() == TokenKind.FUTURESTRICT;
    }

    public String toString() {
        return "'JavaScript Parsing'";
    }

    private void markEval() {
        Iterator<ParserContextFunctionNode> iter = this.lc.getFunctions();
        boolean flaggedCurrentFn = false;
        while (iter.hasNext()) {
            ParserContextFunctionNode fn = iter.next();
            if (!flaggedCurrentFn) {
                flaggedCurrentFn = true;
                fn.setFlag(32);
                if (fn.isArrow()) {
                    this.lc.getCurrentNonArrowFunction().setFlag(0x8000000);
                }
            } else {
                fn.setFlag(64);
            }
            fn.setFlag(128);
        }
    }

    private void prependStatement(Statement statement) {
        this.lc.prependStatementToCurrentNode(statement);
    }

    private void appendStatement(Statement statement) {
        this.lc.appendStatementToCurrentNode(statement);
    }

    private void markSuperCall() {
        Iterator<ParserContextFunctionNode> iter = this.lc.getFunctions();
        while (iter.hasNext()) {
            ParserContextFunctionNode fn = iter.next();
            if (fn.isArrow()) continue;
            if (fn.isProgram()) break;
            assert (fn.isDerivedConstructor());
            fn.setFlag(262144);
            break;
        }
    }

    private void markThis() {
        Iterator<ParserContextFunctionNode> iter = this.lc.getFunctions();
        while (iter.hasNext()) {
            ParserContextFunctionNode fn = iter.next();
            fn.setFlag(32768);
            if (fn.isArrow()) continue;
            break;
        }
    }

    private void markNewTarget() {
        if (!this.lc.getCurrentScope().inFunction()) {
            throw this.error(AbstractParser.message("new.target.in.function", new String[0]), this.token);
        }
        Iterator<ParserContextFunctionNode> iter = this.lc.getFunctions();
        while (iter.hasNext()) {
            ParserContextFunctionNode fn = iter.next();
            if (fn.isArrow()) continue;
            if (fn.isProgram()) break;
            fn.setFlag(0x800000);
            break;
        }
    }

    private static boolean markApplyArgumentsCall(ParserContext lc, List<Expression> arguments) {
        assert (arguments.size() == 2 && arguments.get(1) instanceof IdentNode && ((IdentNode)arguments.get(1)).isArguments());
        ParserContextFunctionNode currentFunction = lc.getCurrentFunction();
        if (!currentFunction.isArrow()) {
            currentFunction.setFlag(0x20000000);
            arguments.set(1, ((IdentNode)arguments.get(1)).setIsApplyArguments());
            return true;
        }
        return false;
    }

    private boolean inGeneratorFunction() {
        if (!ES6_GENERATOR_FUNCTION) {
            return false;
        }
        ParserContextFunctionNode currentFunction = this.lc.getCurrentFunction();
        return currentFunction != null && currentFunction.isGenerator();
    }

    private boolean inAsyncFunction() {
        if (!ES8_ASYNC_FUNCTION) {
            return false;
        }
        ParserContextFunctionNode currentFunction = this.lc.getCurrentFunction();
        return currentFunction != null && currentFunction.isAsync();
    }

    private boolean isAwait() {
        return ES8_ASYNC_FUNCTION && this.isES2017() && this.type == TokenType.AWAIT;
    }

    private boolean isAsync() {
        return ES8_ASYNC_FUNCTION && this.isES2017() && this.type == TokenType.ASYNC;
    }

    private boolean lookaheadIsAsyncArrowParameterListStart() {
        TokenType t;
        assert (this.isAsync());
        int i = 1;
        while ((t = this.T(this.k + i++)) != TokenType.LPAREN && t != TokenType.IDENT && !t.isContextualKeyword()) {
            if (t == TokenType.COMMENT) continue;
            return false;
        }
        return true;
    }

    private boolean lookaheadIsAsyncFunction() {
        assert (this.isAsync());
        int i = 1;
        while (true) {
            long currentToken = this.getToken(this.k + i);
            TokenType t = Token.descType(currentToken);
            switch (t) {
                case COMMENT: {
                    break;
                }
                case FUNCTION: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
    }

    private boolean lookaheadIsAsyncMethod(boolean allowPrivate) {
        assert (this.isAsync());
        int i = 1;
        long currentToken;
        TokenType t;
        while ((t = Token.descType(currentToken = this.getToken(this.k + i))) == TokenType.COMMENT) {
            ++i;
        }
        return this.isPropertyName(currentToken) || t == TokenType.MUL || allowPrivate && t == TokenType.PRIVATE_IDENT;
    }

    public Expression parseExpression() {
        try {
            this.prepareLexer(0, this.source.getLength());
            this.scanFirstToken();
            return this.expression();
        }
        catch (Exception e) {
            this.handleParseException(e);
            return null;
        }
    }

    private static List<Module.ImportEntry> convert(NamedImportsNode namedImportsNode) {
        ArrayList<Module.ImportEntry> importEntries = new ArrayList<Module.ImportEntry>(namedImportsNode.getImportSpecifiers().size());
        for (ImportSpecifierNode s : namedImportsNode.getImportSpecifiers()) {
            if (s.getIdentifier() != null) {
                importEntries.add(Module.ImportEntry.importSpecifier(s.getIdentifier().getName(), s.getBindingIdentifier().getName()));
                continue;
            }
            importEntries.add(Module.ImportEntry.importSpecifier(s.getBindingIdentifier().getName()));
        }
        return importEntries;
    }

    private static class ParserState {
        private final int position;
        private final int line;
        private final int linePosition;

        ParserState(int position, int line, int linePosition) {
            this.position = position;
            this.line = line;
            this.linePosition = linePosition;
        }

        Lexer createLexer(Source source, Lexer lexer, TokenStream stream, boolean scripting, int ecmaScriptVersion, boolean shebang, boolean isModule, boolean allowBigInt) {
            Lexer newLexer = new Lexer(source, this.position, lexer.limit - this.position, stream, scripting, ecmaScriptVersion, shebang, isModule, true, allowBigInt);
            newLexer.restoreState(new Lexer.State(this.position, Integer.MAX_VALUE, this.line, -1, this.linePosition, TokenType.SEMICOLON));
            return newLexer;
        }
    }

    private static final class PropertyFunction {
        final Expression key;
        final FunctionNode functionNode;
        final boolean computed;

        PropertyFunction(Expression key, FunctionNode function, boolean computed) {
            this.key = key;
            this.functionNode = function;
            this.computed = computed;
        }
    }

    private abstract class VerifyDestructuringPatternNodeVisitor
    extends NodeVisitor<LexicalContext> {
        VerifyDestructuringPatternNodeVisitor(LexicalContext lc) {
            super(lc);
        }

        @Override
        public boolean enterLiteralNode(LiteralNode<?> literalNode) {
            if (literalNode.isArray()) {
                if (literalNode.isParenthesized()) {
                    throw Parser.this.error(AbstractParser.message(Parser.MESSAGE_INVALID_LVALUE, new String[0]), literalNode.getToken());
                }
                if (((LiteralNode.ArrayLiteralNode)literalNode).hasSpread() && ((LiteralNode.ArrayLiteralNode)literalNode).hasTrailingComma()) {
                    throw Parser.this.error("Rest element must be last", literalNode.getElementExpressions().get(literalNode.getElementExpressions().size() - 1).getToken());
                }
                boolean restElement = false;
                for (Expression element : literalNode.getElementExpressions()) {
                    if (element == null) continue;
                    if (restElement) {
                        throw Parser.this.error("Unexpected element after rest element", element.getToken());
                    }
                    if (element.isTokenType(TokenType.SPREAD_ARRAY)) {
                        restElement = true;
                        Expression lvalue = ((UnaryNode)element).getExpression();
                        this.verifySpreadElement(lvalue);
                        continue;
                    }
                    element.accept(this);
                }
                return false;
            }
            return this.enterDefault(literalNode);
        }

        protected abstract void verifySpreadElement(Expression var1);

        @Override
        public boolean enterObjectNode(ObjectNode objectNode) {
            if (objectNode.isParenthesized()) {
                throw Parser.this.error(AbstractParser.message(Parser.MESSAGE_INVALID_LVALUE, new String[0]), objectNode.getToken());
            }
            boolean restElement = false;
            for (PropertyNode property : objectNode.getElements()) {
                if (property == null) continue;
                if (restElement) {
                    throw Parser.this.error("Unexpected element after rest element", property.getToken());
                }
                Expression key = property.getKey();
                if (key.isTokenType(TokenType.SPREAD_OBJECT)) {
                    restElement = true;
                    Expression lvalue = ((UnaryNode)key).getExpression();
                    this.verifySpreadElement(lvalue);
                    continue;
                }
                property.accept(this);
            }
            return false;
        }

        @Override
        public boolean enterPropertyNode(PropertyNode propertyNode) {
            if (propertyNode.getValue() != null) {
                propertyNode.getValue().accept(this);
                return false;
            }
            return this.enterDefault(propertyNode);
        }

        @Override
        public boolean enterBinaryNode(BinaryNode binaryNode) {
            if (binaryNode.isTokenType(TokenType.ASSIGN)) {
                binaryNode.getLhs().accept(this);
                return false;
            }
            return this.enterDefault(binaryNode);
        }
    }

    private static final class ForVariableDeclarationListResult {
        Expression missingAssignment;
        long declarationWithInitializerToken;
        Expression init;
        Expression firstBinding;
        Expression secondBinding;

        private ForVariableDeclarationListResult() {
        }

        void recordMissingAssignment(Expression binding) {
            if (this.missingAssignment == null) {
                this.missingAssignment = binding;
            }
        }

        void recordDeclarationWithInitializer(long token) {
            if (this.declarationWithInitializerToken == 0L) {
                this.declarationWithInitializerToken = token;
            }
        }

        void addBinding(Expression binding) {
            if (this.firstBinding == null) {
                this.firstBinding = binding;
            } else if (this.secondBinding == null) {
                this.secondBinding = binding;
            }
        }

        void addAssignment(Expression assignment) {
            this.init = this.init == null ? assignment : new BinaryNode(Token.recast(this.init.getToken(), TokenType.COMMARIGHT), this.init, assignment);
        }
    }
}

