/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.CompiledRegexObject;
import com.oracle.truffle.regex.RegexCompiler;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.tregex.TRegexCompilationRequest;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecRootNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorNode;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavorProcessor;

public final class TRegexCompiler
implements RegexCompiler {
    private final RegexLanguage language;
    private final RegexOptions options;

    public TRegexCompiler(RegexLanguage language, RegexOptions options) {
        this.language = language;
        this.options = options;
    }

    public RegexLanguage getLanguage() {
        return this.language;
    }

    public RegexOptions getOptions() {
        return this.options;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public CompiledRegexObject compile(RegexSource source) throws RegexSyntaxException {
        RegexFlavor flavor = this.options.getFlavor();
        RegexSource ecmascriptSource = source;
        if (flavor != null) {
            RegexFlavorProcessor flavorProcessor = flavor.forRegex(source);
            ecmascriptSource = flavorProcessor.toECMAScriptRegex();
        }
        return new TRegexCompilationRequest(this, ecmascriptSource).compile();
    }

    @CompilerDirectives.TruffleBoundary
    public TRegexDFAExecutorNode compileEagerDFAExecutor(RegexSource source) {
        return new TRegexCompilationRequest(this, source).compileEagerDFAExecutor();
    }

    @CompilerDirectives.TruffleBoundary
    public TRegexExecRootNode.LazyCaptureGroupRegexSearchNode compileLazyDFAExecutor(NFA nfa, TRegexExecRootNode rootNode, boolean allowSimpleCG) {
        return new TRegexCompilationRequest(this, nfa).compileLazyDFAExecutor(rootNode, allowSimpleCG);
    }

    @CompilerDirectives.TruffleBoundary
    public TRegexBacktrackingNFAExecutorNode compileBacktrackingExecutor(NFA nfa) {
        return new TRegexCompilationRequest(this, nfa).compileBacktrackingExecutor();
    }
}

