/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.dyn.ConstantObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import java.util.Set;

public class AccessRestArgumentsNode
extends AccessIndexedArgumentNode {
    private final JSContext context;
    private final int trailingArgCount;

    AccessRestArgumentsNode(JSContext context, int paramIndex, int trailingArgCount) {
        super(paramIndex);
        this.context = context;
        this.trailingArgCount = trailingArgCount;
    }

    public static AccessRestArgumentsNode create(JSContext context, int paramIndex) {
        return new AccessRestArgumentsNode(context, paramIndex, 0);
    }

    public static AccessRestArgumentsNode create(JSContext context, int paramIndex, int trailingArgCount) {
        return new AccessRestArgumentsNode(context, paramIndex, trailingArgCount);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] jsArguments = frame.getArguments();
        int restLength = JSArguments.getUserArgumentCount(jsArguments) - this.index - this.trailingArgCount;
        if (this.profile(restLength > 0)) {
            return JSArray.create(this.context, ConstantObjectArray.createConstantObjectArray(), JSArguments.extractUserArguments(jsArguments, this.index, this.trailingArgCount), restLength);
        }
        return JSArray.createEmptyZeroLength(this.context);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new AccessRestArgumentsNode(this.context, this.index, this.trailingArgCount);
    }
}

