/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class DefaultScope {
    DefaultScope() {
    }

    static Iterable<Scope> topScope(Object global) {
        Object globalObject = global != null && InteropLibrary.getFactory().getUncached().hasMembers(global) ? global : new EmptyGlobalBindings();
        return Collections.singletonList(Scope.newBuilder("global", globalObject).build());
    }

    static Iterable<Scope> lexicalScope(Node node, Frame frame) {
        RootNode root = node.getRootNode();
        String name = root.getName();
        if (name == null) {
            name = "local";
        }
        return Collections.singletonList(Scope.newBuilder(name, DefaultScope.getVariables(root, frame)).node(root).arguments(DefaultScope.getArguments(frame)).build());
    }

    private static boolean isInternal(FrameSlot slot) {
        Object identifier = slot.getIdentifier();
        if (identifier == null) {
            return true;
        }
        return EngineAccessor.INSTRUMENT.isInputValueSlotIdentifier(identifier);
    }

    /*
     * WARNING - void declaration
     */
    private static Object getVariables(RootNode root, Frame frame) {
        Map<Object, Object> slotsMap;
        List<? extends FrameSlot> slots;
        if (frame == null) {
            slots = root.getFrameDescriptor().getSlots();
        } else {
            void var5_8;
            slots = frame.getFrameDescriptor().getSlots();
            ArrayList<? extends FrameSlot> nonNulls = null;
            int lastI = 0;
            boolean bl = false;
            while (var5_8 < slots.size()) {
                FrameSlot slot = slots.get((int)var5_8);
                if (frame.getValue(slot) == null || DefaultScope.isInternal(slot)) {
                    if (nonNulls == null) {
                        nonNulls = new ArrayList<FrameSlot>(slots.size());
                    }
                    nonNulls.addAll(slots.subList(lastI, (int)var5_8));
                    lastI = var5_8 + true;
                }
                ++var5_8;
            }
            if (nonNulls != null) {
                if (lastI < slots.size()) {
                    nonNulls.addAll(slots.subList(lastI, slots.size()));
                }
                slots = nonNulls;
            }
        }
        if (slots.isEmpty()) {
            slotsMap = Collections.emptyMap();
        } else if (slots.size() == 1) {
            FrameSlot slot = slots.get(0);
            slotsMap = Collections.singletonMap(Objects.toString(slot.getIdentifier()), slot);
        } else {
            slotsMap = new LinkedHashMap(slots.size());
            for (FrameSlot frameSlot : slots) {
                slotsMap.put(Objects.toString(frameSlot.getIdentifier()), frameSlot);
            }
        }
        return new VariablesMapObject(slotsMap, frame);
    }

    private static Object getArguments(Frame frame) {
        Object[] args = frame == null ? new Object[]{} : frame.getArguments();
        return new ArgumentsArrayObject(args);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class EmptyGlobalBindings
    implements TruffleObject {
        EmptyGlobalBindings() {
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object readMember(String member) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create(member);
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return VariableNamesObject.EMPTY;
        }

        @ExportMessage
        boolean isMemberReadable(String member) {
            return false;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ArgumentsArrayObject
    implements TruffleObject {
        final Object[] args;

        ArgumentsArrayObject(Object[] args) {
            this.args = args;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.args.length;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create(index);
            }
            return this.args[(int)index];
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable")})
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.args.length;
        }

        @ExportMessage
        boolean isArrayElementInsertable(long index) {
            return false;
        }

        @ExportMessage
        void writeArrayElement(long index, Object value) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create(index);
            }
            try {
                this.args[(int)index] = value;
            }
            catch (IndexOutOfBoundsException ioob) {
                throw InvalidArrayIndexException.create(index);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariableNamesObject
    implements TruffleObject {
        static final VariableNamesObject EMPTY = new VariableNamesObject(Collections.emptySet());
        final List<String> names;

        VariableNamesObject(Set<String> names) {
            this.names = new ArrayList<String>(names);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.names.size();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create(index);
            }
            return this.names.get((int)index);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.names.size();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class NullValue
    implements TruffleObject {
        private static final NullValue INSTANCE = new NullValue();

        NullValue() {
        }

        @ExportMessage
        boolean isNull() {
            return true;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariablesMapObject
    implements TruffleObject {
        final Map<String, ? extends FrameSlot> slots;
        final Frame frame;

        private VariablesMapObject(Map<String, ? extends FrameSlot> slots, Frame frame) {
            this.slots = slots;
            this.frame = frame;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof VariablesMapObject;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readMember(String member) throws UnknownIdentifierException {
            if (this.frame == null) {
                return NullValue.INSTANCE;
            }
            FrameSlot slot = this.slots.get(member);
            if (slot == null) {
                throw UnknownIdentifierException.create(member);
            }
            return this.frame.getValue(slot);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object getMembers(boolean includeInternal) {
            return new VariableNamesObject(this.slots.keySet());
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberReadable(String member) {
            return this.slots.containsKey(member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberModifiable(String member) {
            return this.slots.containsKey(member) && this.frame != null;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void writeMember(String member, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
            if (this.frame == null) {
                throw UnsupportedMessageException.create();
            }
            FrameSlot slot = this.slots.get(member);
            if (slot == null) {
                throw UnknownIdentifierException.create(member);
            }
            this.frame.setObject(slot, value);
        }

        @ExportMessage
        boolean isMemberInsertable(String member) {
            return false;
        }
    }
}

