/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropCallNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSInteropInvokeNode.class)
public final class JSInteropInvokeNodeGen
extends JSInteropInvokeNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private IsCallableNode isCallable;
    @Node.Child
    private JSFunctionCallNode call;
    @Node.Child
    private JSForeignToJSTypeNode importValue;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
    @CompilerDirectives.CompilationFinal
    private String cached_cachedName_;
    @Node.Child
    private PropertyGetNode cached_functionPropertyGetNode_;
    @Node.Child
    private ReadElementNode uncached_readNode_;

    private JSInteropInvokeNodeGen() {
    }

    @Override
    public Object execute(DynamicObject arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
        int state = this.state_;
        if ((state & 3) != 0) {
            if ((state & 1) != 0 && this.cached_cachedName_.equals(arg1Value)) {
                return this.doCached(arg0Value, arg1Value, arg2Value, this.cached_cachedName_, this.javaScriptLanguageReference_, this.cached_functionPropertyGetNode_, this.isCallable, this.call, this.importValue);
            }
            if ((state & 2) != 0) {
                return this.doUncached(arg0Value, arg1Value, arg2Value, this.javaScriptLanguageReference_, this.uncached_readNode_, this.isCallable, this.call, this.importValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(DynamicObject arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            TruffleLanguage.LanguageReference javaScriptLanguageReference__;
            Object object;
            if (exclude == 0) {
                boolean Cached_duplicateFound_ = false;
                if ((state & 1) != 0 && this.cached_cachedName_.equals(arg1Value)) {
                    Cached_duplicateFound_ = true;
                }
                if (!Cached_duplicateFound_ && (state & 1) == 0) {
                    this.cached_cachedName_ = arg1Value;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__2 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__2 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__2 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.cached_functionPropertyGetNode_ = (PropertyGetNode)super.insert((Node)this.createGetProperty(this.cached_cachedName_, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)javaScriptLanguageReference__2));
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert((Node)IsCallableNode.create());
                    }
                    if (this.call == null) {
                        this.call = (JSFunctionCallNode)super.insert((Node)JSFunctionCallNode.createCall());
                    }
                    if (this.importValue == null) {
                        this.importValue = (JSForeignToJSTypeNode)super.insert((Node)JSForeignToJSTypeNode.create());
                    }
                    this.state_ = state |= 1;
                    Cached_duplicateFound_ = true;
                }
                if (Cached_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    object = this.doCached(arg0Value, arg1Value, arg2Value, this.cached_cachedName_, this.javaScriptLanguageReference_, this.cached_functionPropertyGetNode_, this.isCallable, this.call, this.importValue);
                    return object;
                }
            }
            if ((javaScriptLanguageReference__ = this.javaScriptLanguageReference_) == null) {
                this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
            }
            this.uncached_readNode_ = (ReadElementNode)super.insert((Node)ReadElementNode.create(((JavaScriptLanguage)javaScriptLanguageReference__.get()).getJSContext()));
            if (this.isCallable == null) {
                this.isCallable = (IsCallableNode)super.insert((Node)IsCallableNode.create());
            }
            if (this.call == null) {
                this.call = (JSFunctionCallNode)super.insert((Node)JSFunctionCallNode.createCall());
            }
            if (this.importValue == null) {
                this.importValue = (JSForeignToJSTypeNode)super.insert((Node)JSForeignToJSTypeNode.create());
            }
            this.exclude_ = exclude |= 1;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            object = this.doUncached(arg0Value, arg1Value, arg2Value, (TruffleLanguage.LanguageReference<JavaScriptLanguage>)javaScriptLanguageReference__, this.uncached_readNode_, this.isCallable, this.call, this.importValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 3) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 3 & (state & 3) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCached";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(new Object[]{this.cached_cachedName_, this.javaScriptLanguageReference_, this.cached_functionPropertyGetNode_, this.isCallable, this.call, this.importValue}));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncached";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[]{this.javaScriptLanguageReference_, this.uncached_readNode_, this.isCallable, this.call, this.importValue}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSInteropInvokeNode create() {
        return new JSInteropInvokeNodeGen();
    }

    public static JSInteropInvokeNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=JSInteropInvokeNode.class)
    private static final class Uncached
    extends JSInteropInvokeNode {
        private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);

        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(DynamicObject arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
            return this.doUncached(arg0Value, arg1Value, arg2Value, this.javaScriptLanguageReference_, JSInteropInvokeNode.getUncachedRead(), IsCallableNodeGen.getUncached(), JSInteropCallNode.getUncachedCall(), JSForeignToJSTypeNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

