.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP USER" "" "2007-04-20" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP USER \- remove a database user account

.SH SYNOPSIS
.sp
.nf
DROP USER \fIname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP USER\fR removes the specified user.
It does not remove tables, views, or other objects owned by the user. If the
user owns any database, an error is raised.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the user to remove.
.SH "NOTES"
.PP
PostgreSQL includes a program dropuser [\fBdropuser\fR(1)] that has the
same functionality as this command (in fact, it calls this command)
but can be run from the command shell.
.PP
To drop a user who owns a database, first drop the database or change
its ownership.
.PP
It is unwise to drop a user who either owns any database objects or has any
granted permissions on objects. Currently, this is only enforced for
the case of owners of databases, but it is likely that future versions of
PostgreSQL will check other cases.
.SH "EXAMPLES"
.PP
To drop a user account:
.sp
.nf
DROP USER jonathan;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBDROP USER\fR statement is a
PostgreSQL extension. The SQL standard
leaves the definition of users to the implementation.
.SH "SEE ALSO"
ALTER USER [\fBalter_user\fR(l)], CREATE USER [\fBcreate_user\fR(l)]
