.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE USER" "" "2010-05-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE USER \- define a new database user account

.SH SYNOPSIS
.sp
.nf
CREATE USER \fIname\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:
    
      SYSID \fIuid\fR 
    | CREATEDB | NOCREATEDB
    | CREATEUSER | NOCREATEUSER
    | IN GROUP \fIgroupname\fR [, ...]
    | [ ENCRYPTED | UNENCRYPTED ] PASSWORD '\fIpassword\fR'
    | VALID UNTIL '\fIabstime\fR' 
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE USER\fR adds a new user to a
PostgreSQL database cluster. Refer to
the documentation and the documentation for information about managing
users and authentication. You must be a database superuser to use
this command.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the new user.
.TP
\fB\fIuid\fB\fR
The SYSID clause can be used to choose the
PostgreSQL user ID of the new user.
This is normally not necessary, but may
be useful if you need to recreate the owner of an orphaned
object.

If this is not specified, the highest assigned user ID plus one
(with a minimum of 100) will be used as default.
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
These clauses define a user's ability to create databases. If
CREATEDB is specified, the user being
defined will be allowed to create his own databases. Using
NOCREATEDB will deny a user the ability to
create databases. If not specified,
NOCREATEDB is the default.
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
These clauses determine whether a user will be permitted to
create new users himself. CREATEUSER will also make
the user a superuser, who can override all access restrictions.
If not specified,
NOCREATEUSER is the default.
.TP
\fB\fIgroupname\fB\fR
A name of an existing group into which to insert the user as a new
member. Multiple group names may be listed.
.TP
\fB\fIpassword\fB\fR
Sets the user's password. If you do not plan to use password
authentication you can omit this option, but then the user
won't be able to connect if you decide to switch to password
authentication. The password can be set or changed later,
using ALTER USER [\fBalter_user\fR(l)].
.TP
\fBENCRYPTED\fR
.TP
\fBUNENCRYPTED\fR
These key words control whether the password is stored
encrypted in the system catalogs. (If neither is specified,
the default behavior is determined by the configuration
parameter password_encryption.) If the
presented password string is already in MD5-encrypted format,
then it is stored encrypted as-is, regardless of whether
ENCRYPTED or UNENCRYPTED is specified
(since the system cannot decrypt the specified encrypted
password string). This allows reloading of encrypted
passwords during dump/restore.

Note that older clients may lack support for the MD5
authentication mechanism that is needed to work with passwords
that are stored encrypted.
.TP
\fB\fIabstime\fB\fR
The VALID UNTIL clause sets an absolute
time after which the user's password is no longer valid. If
this clause is omitted the password will be valid for all time.
.SH "NOTES"
.PP
Use ALTER USER [\fBalter_user\fR(l)] to
change the attributes of a user, and DROP USER [\fBdrop_user\fR(l)] to remove a user. Use ALTER GROUP [\fBalter_group\fR(l)] to add the
user to groups or remove the user from groups.
.PP
PostgreSQL includes a program createuser [\fBcreateuser\fR(1)] that has
the same functionality as \fBCREATE USER\fR (in fact, it calls this
command) but can be run from the command shell.
.PP
The VALID UNTIL clause defines an expiration time for a
password only, not for the user account \fIper se\fR. In
particular, the expiration time is not enforced when logging in using
a non-password-based authentication method.
.SH "EXAMPLES"
.PP
Create a user with no password:
.sp
.nf
CREATE USER jonathan;
.sp
.fi
.PP
Create a user with a password:
.sp
.nf
CREATE USER davide WITH PASSWORD 'jw8s0F4';
.sp
.fi
.PP
Create a user with a password that is valid until the end of 2004.
After one second has ticked in 2005, the password is no longer
valid.
.sp
.nf
CREATE USER miriam WITH PASSWORD 'jw8s0F4' VALID UNTIL '2005-01-01';
.sp
.fi
.PP
Create an account where the user can create databases:
.sp
.nf
CREATE USER manuel WITH PASSWORD 'jw8s0F4' CREATEDB;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBCREATE USER\fR statement is a
PostgreSQL extension. The SQL standard
leaves the definition of users to the implementation.
.SH "SEE ALSO"
ALTER USER [\fBalter_user\fR(l)], DROP USER [\fBdrop_user\fR(l)], \fBcreateuser\fR(1)
