.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE VIEW" "" "2007-09-16" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE VIEW \- define a new view

.SH SYNOPSIS
.sp
.nf
CREATE [ OR REPLACE ] [ TEMP | TEMPORARY ] VIEW \fIname\fR [ ( \fIcolumn_name\fR [, ...] ) ]
    AS \fIquery\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE VIEW\fR defines a view of a query. The view
is not physically materialized. Instead, the query is run every time
the view is referenced in a query.
.PP
\fBCREATE OR REPLACE VIEW\fR is similar, but if a view
of the same name already exists, it is replaced. You can only replace
a view with a new query that generates the identical set of columns
(i.e., same column names and data types).
.PP
If a schema name is given (for example, CREATE VIEW
myschema.myview ...) then the view is created in the specified
schema. Otherwise it is created in the current schema. Temporary
views exist in a special schema, so a schema name may not be given
when creating a temporary view. The name of the view must be
distinct from the name of any other view, table, sequence, or index
in the same schema.
.SH "PARAMETERS"
.TP
\fBTEMPORARY or TEMP\fR
If specified, the view is created as a temporary view.
Temporary views are automatically dropped at the end of the
current session. Existing
permanent relations with the same name are not visible to the
current session while the temporary view exists, unless they are
referenced with schema-qualified names.

If any of the tables referenced by the view are temporary,
the view is created as a temporary view (whether
TEMPORARY is specified or not).
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of a view to be created.
.TP
\fB\fIcolumn_name\fB\fR
An optional list of names to be used for columns of the view.
If not given, the column names are deduced from the query.
.TP
\fB\fIquery\fB\fR
A query (that is, a \fBSELECT\fR statement) which will
provide the columns and rows of the view.

Refer to SELECT [\fBselect\fR(l)]
for more information about valid queries.
.SH "NOTES"
.PP
Currently, views are read only: the system will not allow an insert,
update, or delete on a view. You can get the effect of an updatable
view by creating rules that rewrite inserts, etc. on the view into
appropriate actions on other tables. For more information see
CREATE RULE [\fBcreate_rule\fR(l)].
.PP
Use the DROP VIEW [\fBdrop_view\fR(l)]
statement to drop views.
.PP
Be careful that the names and types of the view's columns will be
assigned the way you want. For example,
.sp
.nf
CREATE VIEW vista AS SELECT 'Hello World';
.sp
.fi
is bad form in two ways: the column name defaults to ?column?,
and the column data type defaults to \fBunknown\fR. If you want a
string literal in a view's result, use something like
.sp
.nf
CREATE VIEW vista AS SELECT text 'Hello World' AS hello;
.sp
.fi
.PP
Access to tables referenced in the view is determined by permissions of
the view owner. However, functions called in the view are treated the
same as if they had been called directly from the query using the view.
Therefore the user of a view must have permissions to call all functions
used by the view.
.SH "EXAMPLES"
.PP
Create a view consisting of all comedy films:
.sp
.nf
CREATE VIEW comedies AS
    SELECT *
    FROM films
    WHERE kind = 'Comedy';
.sp
.fi
.SH "COMPATIBILITY"
.PP
The SQL standard specifies some additional capabilities for the
\fBCREATE VIEW\fR statement:
.sp
.nf
CREATE VIEW \fIname\fR [ ( \fIcolumn_name\fR [, ...] ) ]
    AS \fIquery\fR
    [ WITH [ CASCADED | LOCAL ] CHECK OPTION ]
.sp
.fi
.PP
The optional clauses for the full SQL command are:
.TP
\fBCHECK OPTION\fR
This option has to do with updatable views. All
\fBINSERT\fR and \fBUPDATE\fR commands on the view
will be checked to ensure data satisfy the view-defining
condition (that is, the new data would be visible through the
view). If they do not, the update will be rejected.
.TP
\fBLOCAL\fR
Check for integrity on this view.
.TP
\fBCASCADED\fR
Check for integrity on this view and on any dependent
view. CASCADED is assumed if neither
CASCADED nor LOCAL is specified.
.PP
.PP
\fBCREATE OR REPLACE VIEW\fR is a
PostgreSQL language extension.
So is the concept of a temporary view.
.SH "SEE ALSO"
DROP VIEW [\fBdrop_view\fR(l)]
