.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER TEXT SEARCH CONFIGURATION" "" "2012-02-23" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER TEXT SEARCH CONFIGURATION \- change the definition of a text search configuration

.SH SYNOPSIS
.sp
.nf
ALTER TEXT SEARCH CONFIGURATION \fIname\fR
    ADD MAPPING FOR \fItoken_type\fR [, ... ] WITH \fIdictionary_name\fR [, ... ]
ALTER TEXT SEARCH CONFIGURATION \fIname\fR
    ALTER MAPPING FOR \fItoken_type\fR [, ... ] WITH \fIdictionary_name\fR [, ... ]
ALTER TEXT SEARCH CONFIGURATION \fIname\fR
    ALTER MAPPING REPLACE \fIold_dictionary\fR WITH \fInew_dictionary\fR
ALTER TEXT SEARCH CONFIGURATION \fIname\fR
    ALTER MAPPING FOR \fItoken_type\fR [, ... ] REPLACE \fIold_dictionary\fR WITH \fInew_dictionary\fR
ALTER TEXT SEARCH CONFIGURATION \fIname\fR
    DROP MAPPING [ IF EXISTS ] FOR \fItoken_type\fR [, ... ]
ALTER TEXT SEARCH CONFIGURATION \fIname\fR RENAME TO \fInewname\fR
ALTER TEXT SEARCH CONFIGURATION \fIname\fR OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER TEXT SEARCH CONFIGURATION\fR changes the definition of
a text search configuration. You can modify
its mappings from token types to dictionaries,
or change the configuration's name or owner.
.PP
You must be the owner of the configuration to use
\fBALTER TEXT SEARCH CONFIGURATION\fR.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing text search
configuration.
.TP
\fB\fItoken_type\fB\fR
The name of a token type that is emitted by the configuration's
parser.
.TP
\fB\fIdictionary_name\fB\fR
The name of a text search dictionary to be consulted for the
specified token type(s). If multiple dictionaries are listed,
they are consulted in the specified order.
.TP
\fB\fIold_dictionary\fB\fR
The name of a text search dictionary to be replaced in the mapping.
.TP
\fB\fInew_dictionary\fB\fR
The name of a text search dictionary to be substituted for
\fIold_dictionary\fR.
.TP
\fB\fInewname\fB\fR
The new name of the text search configuration.
.TP
\fB\fInewowner\fB\fR
The new owner of the text search configuration.
.PP
The ADD MAPPING FOR form installs a list of dictionaries to be
consulted for the specified token type(s); it is an error if there is
already a mapping for any of the token types.
The ALTER MAPPING FOR form does the same, but first removing
any existing mapping for those token types.
The ALTER MAPPING REPLACE forms substitute \fInew_dictionary\fR for \fIold_dictionary\fR anywhere the latter appears.
This is done for only the specified token types when FOR
appears, or for all mappings of the configuration when it doesn't.
The DROP MAPPING form removes all dictionaries for the
specified token type(s), causing tokens of those types to be ignored
by the text search configuration. It is an error if there is no mapping
for the token types, unless IF EXISTS appears.
.PP
.SH "EXAMPLES"
.PP
The following example replaces the english dictionary
with the swedish dictionary anywhere that english
is used within my_config.
.sp
.nf
ALTER TEXT SEARCH CONFIGURATION my_config
  ALTER MAPPING REPLACE english WITH swedish;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER TEXT SEARCH CONFIGURATION\fR statement in
the SQL standard.
.SH "SEE ALSO"
CREATE TEXT SEARCH CONFIGURATION [\fBcreate_text_search_configuration\fR(l)], DROP TEXT SEARCH CONFIGURATION [\fBdrop_text_search_configuration\fR(l)]
