.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "START TRANSACTION" "" "2008-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
START TRANSACTION \- start a transaction block

.SH SYNOPSIS
.sp
.nf
START TRANSACTION [ \fItransaction_mode\fR [, ...] ]

where \fItransaction_mode\fR is one of:

    ISOLATION LEVEL { SERIALIZABLE | REPEATABLE READ | READ COMMITTED | READ UNCOMMITTED }
    READ WRITE | READ ONLY
.sp
.fi
.SH "DESCRIPTION"
.PP
This command begins a new transaction block. If the isolation level or
read/write mode is specified, the new transaction has those
characteristics, as if SET TRANSACTION [\fBset_transaction\fR(l)] was executed. This is the same
as the BEGIN [\fBbegin\fR(l)] command.
.SH "PARAMETERS"
.PP
Refer to SET TRANSACTION [\fBset_transaction\fR(l)] for information on the meaning
of the parameters to this statement.
.SH "COMPATIBILITY"
.PP
In the standard, it is not necessary to issue \fBSTART TRANSACTION\fR
to start a transaction block: any SQL command implicitly begins a block.
PostgreSQL's behavior can be seen as implicitly
issuing a \fBCOMMIT\fR after each command that does not
follow \fBSTART TRANSACTION\fR (or \fBBEGIN\fR),
and it is therefore often called ``autocommit''.
Other relational database systems might offer an autocommit feature
as a convenience.
.PP
The SQL standard requires commas between successive \fItransaction_modes\fR, but for historical
reasons PostgreSQL allows the commas to be
omitted.
.PP
See also the compatibility section of SET TRANSACTION [\fBset_transaction\fR(l)].
.SH "SEE ALSO"
BEGIN [\fBbegin\fR(l)], COMMIT [\fBcommit\fR(l)], ROLLBACK [\fBrollback\fR(l)], SAVEPOINT [\fBsavepoint\fR(l)], SET TRANSACTION [\fBset_transaction\fR(l)]
