.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "PREPARE" "" "2008-10-31" "SQL - Language Statements" "SQL Commands"
.SH NAME
PREPARE \- prepare a statement for execution

.SH SYNOPSIS
.sp
.nf
PREPARE \fIname\fR [ ( \fIdatatype\fR [, ...] ) ] AS \fIstatement\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBPREPARE\fR creates a prepared statement. A prepared
statement is a server-side object that can be used to optimize
performance. When the \fBPREPARE\fR statement is
executed, the specified statement is parsed, rewritten, and
planned. When an \fBEXECUTE\fR command is subsequently
issued, the prepared statement need only be executed. Thus, the
parsing, rewriting, and planning stages are only performed once,
instead of every time the statement is executed.
.PP
Prepared statements can take parameters: values that are
substituted into the statement when it is executed. When creating
the prepared statement, refer to parameters by position, using
$1, $2, etc. A corresponding list of
parameter data types can optionally be specified. When a
parameter's data type is not specified or is declared as
unknown, the type is inferred from the context
in which the parameter is used (if possible). When executing the
statement, specify the actual values for these parameters in the
\fBEXECUTE\fR statement. Refer to EXECUTE [\fBexecute\fR(l)] for more
information about that.
.PP
Prepared statements only last for the duration of the current
database session. When the session ends, the prepared statement is
forgotten, so it must be recreated before being used again. This 
also means that a single prepared statement cannot be used by
multiple simultaneous database clients; however, each client can create
their own prepared statement to use. The prepared statement can be
manually cleaned up using the DEALLOCATE [\fBdeallocate\fR(l)] command.
.PP
Prepared statements have the largest performance advantage when a
single session is being used to execute a large number of similar
statements. The performance difference will be particularly
significant if the statements are complex to plan or rewrite, for
example, if the query involves a join of many tables or requires
the application of several rules. If the statement is relatively simple
to plan and rewrite but relatively expensive to execute, the
performance advantage of prepared statements will be less noticeable.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
An arbitrary name given to this particular prepared
statement. It must be unique within a single session and is
subsequently used to execute or deallocate a previously prepared
statement.
.TP
\fB\fIdatatype\fB\fR
The data type of a parameter to the prepared statement. If the
data type of a particular parameter is unspecified or is
specified as unknown, it will be inferred
from the context in which the parameter is used. To refer to the
parameters in the prepared statement itself, use
$1, $2, etc.
.TP
\fB\fIstatement\fB\fR
Any \fBSELECT\fR, \fBINSERT\fR, \fBUPDATE\fR,
\fBDELETE\fR, or \fBVALUES\fR statement.
.SH "NOTES"
.PP
In some situations, the query plan produced for a prepared
statement will be inferior to the query plan that would have been
chosen if the statement had been submitted and executed
normally. This is because when the statement is planned and the
planner attempts to determine the optimal query plan, the actual
values of any parameters specified in the statement are
unavailable. PostgreSQL collects
statistics on the distribution of data in the table, and can use
constant values in a statement to make guesses about the likely
result of executing the statement. Since this data is unavailable
when planning prepared statements with parameters, the chosen plan
might be suboptimal. To examine the query plan
PostgreSQL has chosen for a prepared
statement, use EXPLAIN [\fBexplain\fR(l)].
.PP
For more information on query planning and the statistics collected
by PostgreSQL for that purpose, see
the ANALYZE [\fBanalyze\fR(l)]
documentation.
.PP
You can see all available prepared statements of a session by querying the
\fBpg_prepared_statements\fR
system view.
.SH "EXAMPLES"
.PP
Create a prepared statement for an \fBINSERT\fR
statement, and then execute it:
.sp
.nf
PREPARE fooplan (int, text, bool, numeric) AS
    INSERT INTO foo VALUES($1, $2, $3, $4);
EXECUTE fooplan(1, 'Hunter Valley', 't', 200.00);
.sp
.fi
.PP
Create a prepared statement for a \fBSELECT\fR
statement, and then execute it:
.sp
.nf
PREPARE usrrptplan (int) AS
    SELECT * FROM users u, logs l WHERE u.usrid=$1 AND u.usrid=l.usrid
    AND l.date = $2;
EXECUTE usrrptplan(1, current_date);
.sp
.fi
Note that the data type of the second parameter is not specified,
so it is inferred from the context in which $2 is used.
.SH "COMPATIBILITY"
.PP
The SQL standard includes a \fBPREPARE\fR statement,
but it is only for use in embedded SQL. This version of the
\fBPREPARE\fR statement also uses a somewhat different
syntax.
.SH "SEE ALSO"
DEALLOCATE [\fBdeallocate\fR(l)], EXECUTE [\fBexecute\fR(l)]
