/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
static void __attribute__((format(PG_PRINTF_ATTRIBUTE, 3, 0)))
vmmerror(int error_code, enum errortype type, const char *error, va_list ap)
{
	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	vfprintf(stderr, error, ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
	}
}

void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, type, error, ap);
	va_end(ap);
}

void
mmfatal(int error_code, const char *error, ...)
{
	va_list		ap;

	va_start(ap, error);
	vmmerror(error_code, ET_ERROR, error, ap);
	va_end(ap);

	if (yyin)
		fclose(yyin);
	if (yyout)
		fclose(yyout);

	if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
		fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
	exit(error_code);
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 645 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EVENT = 461,
    EXCEPT = 462,
    EXCLUDE = 463,
    EXCLUDING = 464,
    EXCLUSIVE = 465,
    EXECUTE = 466,
    EXISTS = 467,
    EXPLAIN = 468,
    EXTENSION = 469,
    EXTERNAL = 470,
    EXTRACT = 471,
    FALSE_P = 472,
    FAMILY = 473,
    FETCH = 474,
    FILTER = 475,
    FIRST_P = 476,
    FLOAT_P = 477,
    FOLLOWING = 478,
    FOR = 479,
    FORCE = 480,
    FOREIGN = 481,
    FORWARD = 482,
    FREEZE = 483,
    FROM = 484,
    FULL = 485,
    FUNCTION = 486,
    FUNCTIONS = 487,
    GLOBAL = 488,
    GRANT = 489,
    GRANTED = 490,
    GREATEST = 491,
    GROUP_P = 492,
    HANDLER = 493,
    HAVING = 494,
    HEADER_P = 495,
    HOLD = 496,
    HOUR_P = 497,
    IDENTITY_P = 498,
    IF_P = 499,
    ILIKE = 500,
    IMMEDIATE = 501,
    IMMUTABLE = 502,
    IMPLICIT_P = 503,
    IN_P = 504,
    INCLUDING = 505,
    INCREMENT = 506,
    INDEX = 507,
    INDEXES = 508,
    INHERIT = 509,
    INHERITS = 510,
    INITIALLY = 511,
    INLINE_P = 512,
    INNER_P = 513,
    INOUT = 514,
    INPUT_P = 515,
    INSENSITIVE = 516,
    INSERT = 517,
    INSTEAD = 518,
    INT_P = 519,
    INTEGER = 520,
    INTERSECT = 521,
    INTERVAL = 522,
    INTO = 523,
    INVOKER = 524,
    IS = 525,
    ISNULL = 526,
    ISOLATION = 527,
    JOIN = 528,
    KEY = 529,
    LABEL = 530,
    LANGUAGE = 531,
    LARGE_P = 532,
    LAST_P = 533,
    LATERAL_P = 534,
    LC_COLLATE_P = 535,
    LC_CTYPE_P = 536,
    LEADING = 537,
    LEAKPROOF = 538,
    LEAST = 539,
    LEFT = 540,
    LEVEL = 541,
    LIKE = 542,
    LIMIT = 543,
    LISTEN = 544,
    LOAD = 545,
    LOCAL = 546,
    LOCALTIME = 547,
    LOCALTIMESTAMP = 548,
    LOCATION = 549,
    LOCK_P = 550,
    MAPPING = 551,
    MATCH = 552,
    MATERIALIZED = 553,
    MAXVALUE = 554,
    MINUTE_P = 555,
    MINVALUE = 556,
    MODE = 557,
    MONTH_P = 558,
    MOVE = 559,
    NAME_P = 560,
    NAMES = 561,
    NATIONAL = 562,
    NATURAL = 563,
    NCHAR = 564,
    NEXT = 565,
    NO = 566,
    NONE = 567,
    NOT = 568,
    NOTHING = 569,
    NOTIFY = 570,
    NOTNULL = 571,
    NOWAIT = 572,
    NULL_P = 573,
    NULLIF = 574,
    NULLS_P = 575,
    NUMERIC = 576,
    OBJECT_P = 577,
    OF = 578,
    OFF = 579,
    OFFSET = 580,
    OIDS = 581,
    ON = 582,
    ONLY = 583,
    OPERATOR = 584,
    OPTION = 585,
    OPTIONS = 586,
    OR = 587,
    ORDER = 588,
    ORDINALITY = 589,
    OUT_P = 590,
    OUTER_P = 591,
    OVER = 592,
    OVERLAPS = 593,
    OVERLAY = 594,
    OWNED = 595,
    OWNER = 596,
    PARSER = 597,
    PARTIAL = 598,
    PARTITION = 599,
    PASSING = 600,
    PASSWORD = 601,
    PLACING = 602,
    PLANS = 603,
    POSITION = 604,
    PRECEDING = 605,
    PRECISION = 606,
    PRESERVE = 607,
    PREPARE = 608,
    PREPARED = 609,
    PRIMARY = 610,
    PRIOR = 611,
    PRIVILEGES = 612,
    PROCEDURAL = 613,
    PROCEDURE = 614,
    PROGRAM = 615,
    QUOTE = 616,
    RANGE = 617,
    READ = 618,
    REAL = 619,
    REASSIGN = 620,
    RECHECK = 621,
    RECURSIVE = 622,
    REF = 623,
    REFERENCES = 624,
    REFRESH = 625,
    REINDEX = 626,
    RELATIVE_P = 627,
    RELEASE = 628,
    RENAME = 629,
    REPEATABLE = 630,
    REPLACE = 631,
    REPLICA = 632,
    RESET = 633,
    RESTART = 634,
    RESTRICT = 635,
    RETURNING = 636,
    RETURNS = 637,
    REVOKE = 638,
    RIGHT = 639,
    ROLE = 640,
    ROLLBACK = 641,
    ROW = 642,
    ROWS = 643,
    RULE = 644,
    SAVEPOINT = 645,
    SCHEMA = 646,
    SCROLL = 647,
    SEARCH = 648,
    SECOND_P = 649,
    SECURITY = 650,
    SELECT = 651,
    SEQUENCE = 652,
    SEQUENCES = 653,
    SERIALIZABLE = 654,
    SERVER = 655,
    SESSION = 656,
    SESSION_USER = 657,
    SET = 658,
    SETOF = 659,
    SHARE = 660,
    SHOW = 661,
    SIMILAR = 662,
    SIMPLE = 663,
    SMALLINT = 664,
    SNAPSHOT = 665,
    SOME = 666,
    STABLE = 667,
    STANDALONE_P = 668,
    START = 669,
    STATEMENT = 670,
    STATISTICS = 671,
    STDIN = 672,
    STDOUT = 673,
    STORAGE = 674,
    STRICT_P = 675,
    STRIP_P = 676,
    SUBSTRING = 677,
    SYMMETRIC = 678,
    SYSID = 679,
    SYSTEM_P = 680,
    TABLE = 681,
    TABLES = 682,
    TABLESPACE = 683,
    TEMP = 684,
    TEMPLATE = 685,
    TEMPORARY = 686,
    TEXT_P = 687,
    THEN = 688,
    TIME = 689,
    TIMESTAMP = 690,
    TO = 691,
    TRAILING = 692,
    TRANSACTION = 693,
    TREAT = 694,
    TRIGGER = 695,
    TRIM = 696,
    TRUE_P = 697,
    TRUNCATE = 698,
    TRUSTED = 699,
    TYPE_P = 700,
    TYPES_P = 701,
    UNBOUNDED = 702,
    UNCOMMITTED = 703,
    UNENCRYPTED = 704,
    UNION = 705,
    UNIQUE = 706,
    UNKNOWN = 707,
    UNLISTEN = 708,
    UNLOGGED = 709,
    UNTIL = 710,
    UPDATE = 711,
    USER = 712,
    USING = 713,
    VACUUM = 714,
    VALID = 715,
    VALIDATE = 716,
    VALIDATOR = 717,
    VALUE_P = 718,
    VALUES = 719,
    VARCHAR = 720,
    VARIADIC = 721,
    VARYING = 722,
    VERBOSE = 723,
    VERSION_P = 724,
    VIEW = 725,
    VIEWS = 726,
    VOLATILE = 727,
    WHEN = 728,
    WHERE = 729,
    WHITESPACE_P = 730,
    WINDOW = 731,
    WITH = 732,
    WITHIN = 733,
    WITHOUT = 734,
    WORK = 735,
    WRAPPER = 736,
    WRITE = 737,
    XML_P = 738,
    XMLATTRIBUTES = 739,
    XMLCONCAT = 740,
    XMLELEMENT = 741,
    XMLEXISTS = 742,
    XMLFOREST = 743,
    XMLPARSE = 744,
    XMLPI = 745,
    XMLROOT = 746,
    XMLSERIALIZE = 747,
    YEAR_P = 748,
    YES_P = 749,
    ZONE = 750,
    NULLS_FIRST = 751,
    NULLS_LAST = 752,
    WITH_ORDINALITY = 753,
    WITH_TIME = 754,
    POSTFIXOP = 755,
    UMINUS = 756
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 579 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1202 "preproc.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1231 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   111903

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  521
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  718
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2841
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  5230

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   756

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   508,     2,     2,
     513,   514,   506,   504,   516,   505,   515,   507,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   518,   517,
     501,   500,   502,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   511,     2,   512,   509,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   519,     2,   520,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   503,   510
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1511,  1511,  1514,  1516,  1518,  1520,  1522,  1524,  1526,
    1528,  1530,  1532,  1534,  1536,  1538,  1540,  1542,  1544,  1546,
    1548,  1550,  1552,  1554,  1556,  1558,  1560,  1562,  1564,  1566,
    1568,  1570,  1572,  1590,  1592,  1594,  1596,  1598,  1600,  1602,
    1604,  1606,  1608,  1610,  1612,  1614,  1616,  1618,  1620,  1622,
    1624,  1626,  1628,  1630,  1632,  1634,  1636,  1638,  1640,  1642,
    1644,  1646,  1648,  1650,  1654,  1656,  1658,  1660,  1662,  1664,
    1666,  1668,  1670,  1672,  1674,  1676,  1678,  1680,  1682,  1684,
    1686,  1688,  1690,  1692,  1694,  1696,  1698,  1700,  1702,  1704,
    1706,  1708,  1710,  1712,  1714,  1716,  1718,  1720,  1722,  1729,
    1731,  1733,  1735,  1737,  1739,  1741,  1743,  1745,  1747,  1749,
    1751,  1757,  1759,  1761,  1763,  1765,  1767,  1769,  1771,  1773,
    1779,  1789,  1793,  1799,  1803,  1813,  1823,  1824,  1838,  1845,
    1851,  1862,  1868,  1877,  1884,  1890,  1899,  1906,  1914,  1919,
    1927,  1932,  1938,  1943,  1949,  1954,  1960,  1964,  1968,  1972,
    1976,  1980,  1984,  1988,  1992,  2000,  2004,  2008,  2012,  2016,
    2020,  2028,  2036,  2045,  2047,  2055,  2059,  2067,  2075,  2083,
    2087,  2095,  2099,  2107,  2115,  2123,  2127,  2135,  2139,  2147,
    2151,  2155,  2160,  2169,  2174,  2180,  2185,  2191,  2195,  2199,
    2203,  2207,  2211,  2219,  2223,  2227,  2235,  2239,  2243,  2251,
    2255,  2259,  2263,  2264,  2268,  2272,  2276,  2281,  2285,  2289,
    2293,  2297,  2301,  2305,  2313,  2317,  2325,  2329,  2337,  2341,
    2355,  2359,  2363,  2367,  2375,  2379,  2383,  2387,  2395,  2399,
    2403,  2407,  2411,  2415,  2419,  2427,  2431,  2436,  2442,  2446,
    2454,  2462,  2466,  2470,  2474,  2482,  2486,  2494,  2498,  2506,
    2510,  2518,  2522,  2526,  2530,  2534,  2543,  2551,  2555,  2563,
    2567,  2575,  2583,  2587,  2591,  2595,  2599,  2607,  2611,  2615,
    2619,  2623,  2627,  2631,  2635,  2639,  2643,  2647,  2651,  2655,
    2659,  2663,  2667,  2675,  2679,  2687,  2691,  2695,  2699,  2703,
    2707,  2711,  2715,  2719,  2723,  2727,  2731,  2735,  2739,  2743,
    2747,  2751,  2755,  2759,  2763,  2767,  2771,  2775,  2779,  2783,
    2787,  2791,  2795,  2799,  2803,  2807,  2811,  2815,  2819,  2823,
    2827,  2831,  2835,  2839,  2843,  2847,  2851,  2855,  2859,  2867,
    2871,  2879,  2883,  2888,  2894,  2899,  2905,  2910,  2916,  2920,
    2924,  2928,  2936,  2944,  2949,  2955,  2959,  2967,  2971,  2975,
    2979,  2987,  2995,  2999,  3007,  3011,  3015,  3019,  3027,  3032,
    3040,  3048,  3056,  3060,  3068,  3073,  3079,  3083,  3087,  3095,
    3099,  3107,  3112,  3118,  3122,  3126,  3130,  3134,  3138,  3142,
    3146,  3150,  3154,  3158,  3162,  3166,  3170,  3178,  3183,  3189,
    3194,  3200,  3205,  3211,  3216,  3222,  3226,  3234,  3242,  3246,
    3250,  3254,  3259,  3265,  3269,  3277,  3285,  3289,  3293,  3297,
    3305,  3309,  3313,  3317,  3321,  3325,  3329,  3334,  3340,  3345,
    3351,  3356,  3362,  3366,  3374,  3378,  3386,  3390,  3394,  3402,
    3406,  3414,  3422,  3430,  3435,  3441,  3445,  3449,  3453,  3461,
    3465,  3469,  3473,  3477,  3481,  3485,  3493,  3497,  3501,  3505,
    3513,  3521,  3525,  3530,  3536,  3540,  3544,  3548,  3552,  3556,
    3564,  3568,  3576,  3580,  3584,  3588,  3592,  3596,  3600,  3608,
    3613,  3619,  3624,  3630,  3634,  3642,  3650,  3654,  3659,  3664,
    3670,  3674,  3682,  3686,  3694,  3699,  3705,  3709,  3713,  3717,
    3722,  3728,  3736,  3744,  3748,  3752,  3756,  3760,  3768,  3773,
    3779,  3783,  3787,  3792,  3798,  3802,  3806,  3811,  3817,  3822,
    3828,  3833,  3839,  3847,  3855,  3859,  3864,  3870,  3878,  3886,
    3891,  3897,  3905,  3913,  3917,  3925,  3930,  3936,  3940,  3948,
    3952,  3956,  3960,  3964,  3968,  3972,  3976,  3980,  3984,  3988,
    3992,  4000,  4005,  4011,  4015,  4019,  4027,  4031,  4039,  4043,
    4051,  4056,  4062,  4066,  4074,  4079,  4085,  4089,  4097,  4102,
    4108,  4112,  4120,  4125,  4131,  4139,  4144,  4150,  4154,  4162,
    4166,  4174,  4179,  4185,  4189,  4193,  4201,  4209,  4214,  4220,
    4228,  4232,  4236,  4240,  4244,  4248,  4252,  4256,  4260,  4264,
    4268,  4272,  4276,  4280,  4284,  4288,  4292,  4296,  4300,  4304,
    4308,  4312,  4316,  4320,  4328,  4336,  4340,  4344,  4348,  4356,
    4360,  4368,  4373,  4379,  4383,  4391,  4395,  4403,  4408,  4414,
    4418,  4426,  4434,  4438,  4446,  4450,  4454,  4458,  4466,  4474,
    4482,  4490,  4498,  4503,  4509,  4513,  4521,  4526,  4532,  4536,
    4544,  4548,  4552,  4560,  4564,  4572,  4576,  4584,  4592,  4596,
    4600,  4608,  4612,  4620,  4628,  4632,  4640,  4644,  4648,  4656,
    4660,  4668,  4672,  4676,  4680,  4684,  4692,  4697,  4703,  4708,
    4714,  4718,  4726,  4731,  4737,  4741,  4746,  4752,  4756,  4760,
    4764,  4772,  4777,  4784,  4786,  4794,  4798,  4802,  4806,  4810,
    4814,  4822,  4826,  4834,  4838,  4846,  4850,  4858,  4866,  4870,
    4878,  4886,  4890,  4894,  4898,  4906,  4915,  4924,  4928,  4932,
    4936,  4940,  4944,  4948,  4952,  4956,  4960,  4964,  4968,  4972,
    4976,  4984,  4992,  4996,  5004,  5008,  5016,  5020,  5024,  5028,
    5032,  5040,  5048,  5052,  5060,  5068,  5073,  5079,  5083,  5091,
    5095,  5099,  5107,  5112,  5118,  5126,  5130,  5138,  5142,  5146,
    5150,  5154,  5162,  5167,  5173,  5178,  5184,  5188,  5193,  5199,
    5205,  5211,  5219,  5223,  5231,  5235,  5243,  5247,  5255,  5259,
    5267,  5271,  5279,  5287,  5295,  5299,  5303,  5307,  5315,  5319,
    5323,  5327,  5331,  5335,  5339,  5343,  5347,  5351,  5355,  5359,
    5363,  5367,  5371,  5375,  5379,  5387,  5391,  5399,  5403,  5411,
    5415,  5423,  5431,  5435,  5440,  5446,  5450,  5454,  5458,  5462,
    5466,  5470,  5474,  5478,  5482,  5486,  5490,  5494,  5502,  5506,
    5510,  5514,  5518,  5522,  5526,  5530,  5534,  5538,  5542,  5546,
    5550,  5554,  5558,  5562,  5566,  5570,  5574,  5578,  5582,  5586,
    5590,  5598,  5602,  5610,  5614,  5618,  5622,  5626,  5634,  5639,
    5645,  5649,  5653,  5657,  5661,  5665,  5669,  5673,  5677,  5681,
    5685,  5689,  5693,  5701,  5705,  5713,  5717,  5721,  5725,  5731,
    5737,  5743,  5749,  5755,  5761,  5767,  5777,  5788,  5799,  5810,
    5821,  5832,  5843,  5859,  5875,  5891,  5902,  5918,  5929,  5945,
    5960,  5964,  5972,  5977,  5983,  5991,  5995,  6003,  6007,  6011,
    6015,  6019,  6027,  6031,  6039,  6043,  6047,  6051,  6059,  6063,
    6067,  6071,  6075,  6079,  6083,  6087,  6091,  6095,  6099,  6103,
    6107,  6111,  6115,  6119,  6127,  6131,  6139,  6143,  6151,  6156,
    6162,  6166,  6174,  6182,  6190,  6194,  6202,  6207,  6213,  6218,
    6224,  6232,  6237,  6243,  6247,  6251,  6259,  6263,  6267,  6275,
    6279,  6283,  6287,  6295,  6303,  6308,  6314,  6319,  6325,  6330,
    6336,  6341,  6347,  6351,  6359,  6363,  6367,  6375,  6380,  6386,
    6390,  6395,  6401,  6405,  6410,  6416,  6420,  6425,  6431,  6435,
    6439,  6447,  6452,  6458,  6462,  6470,  6474,  6482,  6486,  6494,
    6498,  6506,  6510,  6514,  6518,  6522,  6530,  6534,  6538,  6542,
    6546,  6554,  6562,  6570,  6574,  6578,  6586,  6590,  6594,  6602,
    6611,  6615,  6619,  6623,  6631,  6635,  6643,  6647,  6655,  6659,
    6663,  6667,  6671,  6675,  6679,  6683,  6687,  6691,  6695,  6699,
    6703,  6707,  6711,  6719,  6723,  6727,  6731,  6739,  6743,  6751,
    6756,  6762,  6770,  6774,  6782,  6790,  6794,  6802,  6807,  6813,
    6817,  6825,  6829,  6837,  6841,  6849,  6853,  6857,  6861,  6869,
    6873,  6881,  6889,  6893,  6901,  6905,  6913,  6917,  6921,  6929,
    6933,  6938,  6944,  6952,  6957,  6963,  6967,  6971,  6979,  6983,
    6991,  6996,  7002,  7006,  7014,  7018,  7022,  7026,  7030,  7034,
    7038,  7042,  7046,  7050,  7054,  7058,  7062,  7066,  7070,  7074,
    7078,  7082,  7086,  7090,  7094,  7098,  7102,  7106,  7110,  7114,
    7118,  7122,  7126,  7130,  7134,  7138,  7142,  7146,  7150,  7154,
    7158,  7162,  7166,  7170,  7174,  7178,  7182,  7186,  7190,  7198,
    7203,  7209,  7214,  7220,  7224,  7228,  7232,  7236,  7240,  7244,
    7248,  7252,  7256,  7260,  7264,  7268,  7272,  7276,  7280,  7284,
    7288,  7292,  7296,  7300,  7304,  7308,  7312,  7320,  7324,  7328,
    7332,  7336,  7340,  7344,  7348,  7352,  7356,  7360,  7364,  7368,
    7372,  7376,  7380,  7384,  7388,  7392,  7400,  7408,  7412,  7416,
    7424,  7428,  7436,  7440,  7444,  7448,  7452,  7460,  7465,  7471,
    7475,  7479,  7483,  7491,  7495,  7500,  7506,  7510,  7518,  7526,
    7531,  7537,  7545,  7549,  7557,  7561,  7565,  7569,  7573,  7577,
    7581,  7585,  7589,  7593,  7597,  7601,  7605,  7609,  7617,  7621,
    7626,  7632,  7636,  7640,  7644,  7648,  7656,  7660,  7664,  7672,
    7677,  7683,  7687,  7691,  7696,  7705,  7709,  7713,  7718,  7724,
    7732,  7740,  7745,  7751,  7755,  7759,  7763,  7767,  7771,  7775,
    7779,  7783,  7787,  7791,  7795,  7799,  7803,  7807,  7811,  7819,
    7824,  7830,  7834,  7842,  7850,  7855,  7861,  7869,  7873,  7881,
    7885,  7893,  7901,  7905,  7909,  7913,  7917,  7921,  7925,  7933,
    7938,  7944,  7952,  7956,  7960,  7964,  7968,  7972,  7980,  7988,
    7992,  7996,  8004,  8009,  8015,  8019,  8023,  8027,  8031,  8039,
    8043,  8051,  8055,  8059,  8063,  8071,  8075,  8083,  8087,  8095,
    8100,  8106,  8111,  8117,  8122,  8128,  8133,  8139,  8143,  8147,
    8151,  8159,  8163,  8167,  8171,  8175,  8179,  8183,  8187,  8191,
    8199,  8203,  8211,  8219,  8223,  8231,  8235,  8240,  8246,  8252,
    8262,  8267,  8273,  8277,  8281,  8285,  8293,  8295,  8303,  8308,
    8314,  8322,  8326,  8330,  8338,  8342,  8350,  8358,  8363,  8369,
    8377,  8382,  8388,  8396,  8401,  8407,  8411,  8415,  8419,  8423,
    8427,  8431,  8435,  8443,  8448,  8454,  8462,  8466,  8474,  8478,
    8486,  8494,  8502,  8510,  8514,  8522,  8575,  8579,  8592,  8594,
    8598,  8602,  8606,  8615,  8621,  8625,  8633,  8637,  8645,  8649,
    8657,  8661,  8665,  8669,  8673,  8677,  8681,  8685,  8693,  8697,
    8705,  8709,  8713,  8717,  8721,  8725,  8733,  8737,  8745,  8749,
    8757,  8765,  8770,  8776,  8781,  8783,  8789,  8793,  8797,  8801,
    8805,  8809,  8813,  8817,  8821,  8829,  8834,  8840,  8844,  8849,
    8855,  8859,  8863,  8868,  8874,  8879,  8885,  8893,  8897,  8905,
    8909,  8917,  8921,  8925,  8929,  8937,  8942,  8948,  8952,  8957,
    8965,  8969,  8977,  8981,  8989,  8997,  9001,  9006,  9012,  9020,
    9024,  9032,  9036,  9044,  9049,  9055,  9060,  9066,  9070,  9078,
    9083,  9089,  9093,  9101,  9109,  9113,  9117,  9121,  9129,  9134,
    9140,  9144,  9152,  9157,  9163,  9167,  9175,  9179,  9183,  9187,
    9194,  9201,  9205,  9213,  9217,  9221,  9225,  9229,  9233,  9241,
    9245,  9249,  9253,  9261,  9266,  9272,  9276,  9280,  9284,  9289,
    9295,  9299,  9303,  9307,  9315,  9320,  9326,  9330,  9338,  9342,
    9346,  9350,  9358,  9362,  9370,  9374,  9378,  9386,  9390,  9398,
    9406,  9410,  9418,  9423,  9429,  9434,  9440,  9445,  9451,  9455,
    9461,  9467,  9472,  9478,  9482,  9490,  9498,  9500,  9502,  9506,
    9510,  9514,  9522,  9532,  9543,  9552,  9556,  9560,  9564,  9568,
    9572,  9576,  9584,  9588,  9592,  9596,  9604,  9608,  9616,  9621,
    9627,  9631,  9635,  9639,  9643,  9647,  9651,  9655,  9659,  9663,
    9667,  9675,  9680,  9686,  9690,  9698,  9702,  9710,  9718,  9726,
    9730,  9738,  9742,  9750,  9758,  9766,  9770,  9774,  9778,  9782,
    9786,  9794,  9799,  9805,  9810,  9816,  9820,  9824,  9828,  9836,
    9844,  9848,  9853,  9859,  9863,  9867,  9871,  9875,  9879,  9883,
    9887,  9891,  9895,  9899,  9903,  9907,  9912,  9918,  9922,  9930,
    9934,  9938,  9942,  9946,  9950,  9954,  9958,  9962,  9966,  9970,
    9974,  9978,  9982,  9986,  9990,  9994,  9998, 10002, 10006, 10010,
   10014, 10018, 10022, 10026, 10030, 10034, 10038, 10042, 10046, 10050,
   10054, 10058, 10062, 10066, 10070, 10074, 10078, 10082, 10086, 10090,
   10094, 10098, 10102, 10106, 10110, 10114, 10118, 10122, 10126, 10130,
   10134, 10138, 10142, 10146, 10150, 10154, 10159, 10163, 10171, 10175,
   10179, 10183, 10187, 10191, 10195, 10199, 10203, 10207, 10211, 10215,
   10219, 10223, 10227, 10231, 10235, 10239, 10243, 10247, 10251, 10255,
   10263, 10267, 10271, 10275, 10279, 10283, 10287, 10291, 10295, 10299,
   10303, 10307, 10315, 10319, 10323, 10327, 10331, 10335, 10339, 10347,
   10351, 10359, 10363, 10371, 10375, 10379, 10383, 10387, 10391, 10395,
   10399, 10403, 10407, 10411, 10415, 10419, 10423, 10427, 10431, 10435,
   10439, 10443, 10447, 10451, 10455, 10459, 10463, 10467, 10471, 10475,
   10479, 10483, 10487, 10491, 10495, 10499, 10503, 10507, 10511, 10515,
   10519, 10523, 10527, 10531, 10535, 10543, 10547, 10555, 10559, 10563,
   10568, 10574, 10582, 10586, 10594, 10598, 10606, 10610, 10618, 10622,
   10627, 10633, 10637, 10641, 10645, 10653, 10658, 10664, 10669, 10675,
   10680, 10686, 10690, 10698, 10706, 10710, 10715, 10721, 10729, 10733,
   10740, 10745, 10751, 10756, 10761, 10767, 10771, 10779, 10783, 10787,
   10791, 10795, 10803, 10807, 10811, 10819, 10823, 10827, 10835, 10839,
   10847, 10851, 10855, 10859, 10863, 10867, 10871, 10875, 10879, 10887,
   10891, 10899, 10903, 10911, 10915, 10919, 10923, 10927, 10931, 10939,
   10943, 10951, 10955, 10963, 10967, 10975, 10979, 10987, 10991, 10995,
   11003, 11007, 11015, 11020, 11026, 11030, 11034, 11038, 11042, 11046,
   11050, 11054, 11062, 11066, 11074, 11082, 11087, 11093, 11097, 11101,
   11105, 11109, 11114, 11120, 11128, 11136, 11140, 11144, 11152, 11156,
   11164, 11172, 11176, 11184, 11192, 11197, 11203, 11208, 11214, 11218,
   11226, 11230, 11234, 11238, 11246, 11250, 11259, 11261, 11269, 11274,
   11280, 11284, 11292, 11296, 11304, 11312, 11317, 11323, 11327, 11335,
   11339, 11343, 11347, 11355, 11359, 11367, 11371, 11379, 11383, 11391,
   11399, 11407, 11415, 11423, 11431, 11439, 11443, 11451, 11455, 11459,
   11463, 11467, 11471, 11475, 11479, 11483, 11487, 11491, 11495, 11499,
   11503, 11504, 11509, 11515, 11523, 11527, 11535, 11539, 11540, 11544,
   11552, 11556, 11560, 11564, 11572, 11576, 11580, 11584, 11588, 11592,
   11596, 11600, 11604, 11608, 11612, 11616, 11620, 11624, 11628, 11632,
   11636, 11640, 11644, 11648, 11652, 11656, 11660, 11664, 11668, 11672,
   11676, 11680, 11684, 11688, 11692, 11696, 11700, 11704, 11708, 11712,
   11716, 11720, 11724, 11728, 11732, 11736, 11740, 11744, 11748, 11752,
   11756, 11760, 11764, 11768, 11772, 11776, 11780, 11784, 11788, 11792,
   11796, 11800, 11804, 11808, 11812, 11816, 11820, 11824, 11828, 11832,
   11836, 11840, 11844, 11848, 11852, 11856, 11860, 11864, 11868, 11872,
   11876, 11880, 11884, 11888, 11892, 11896, 11900, 11904, 11908, 11912,
   11916, 11920, 11924, 11928, 11932, 11936, 11940, 11944, 11948, 11952,
   11956, 11960, 11964, 11968, 11972, 11976, 11980, 11984, 11988, 11992,
   11996, 12000, 12004, 12008, 12012, 12016, 12020, 12024, 12028, 12032,
   12036, 12040, 12044, 12048, 12052, 12056, 12060, 12064, 12068, 12072,
   12076, 12080, 12084, 12088, 12092, 12096, 12100, 12104, 12108, 12112,
   12116, 12120, 12124, 12128, 12132, 12136, 12140, 12144, 12148, 12152,
   12156, 12160, 12164, 12168, 12172, 12176, 12180, 12184, 12188, 12192,
   12196, 12200, 12204, 12208, 12212, 12216, 12220, 12224, 12228, 12232,
   12236, 12240, 12244, 12248, 12252, 12256, 12260, 12264, 12268, 12272,
   12276, 12280, 12284, 12288, 12292, 12296, 12300, 12304, 12308, 12312,
   12316, 12320, 12324, 12328, 12332, 12336, 12340, 12344, 12348, 12352,
   12356, 12360, 12364, 12368, 12372, 12376, 12380, 12384, 12388, 12392,
   12396, 12400, 12404, 12408, 12412, 12416, 12420, 12424, 12428, 12432,
   12436, 12440, 12444, 12448, 12452, 12456, 12460, 12464, 12468, 12472,
   12476, 12480, 12484, 12488, 12492, 12496, 12500, 12504, 12508, 12512,
   12516, 12520, 12524, 12528, 12532, 12536, 12540, 12544, 12548, 12552,
   12556, 12560, 12564, 12568, 12576, 12580, 12584, 12588, 12592, 12596,
   12600, 12604, 12608, 12612, 12616, 12620, 12624, 12628, 12632, 12636,
   12640, 12644, 12648, 12652, 12656, 12660, 12664, 12668, 12672, 12676,
   12680, 12684, 12688, 12692, 12696, 12700, 12704, 12708, 12712, 12716,
   12720, 12724, 12728, 12732, 12736, 12740, 12744, 12748, 12756, 12760,
   12764, 12768, 12772, 12776, 12780, 12784, 12788, 12792, 12796, 12800,
   12804, 12808, 12812, 12816, 12820, 12824, 12828, 12832, 12836, 12840,
   12848, 12852, 12856, 12860, 12864, 12868, 12872, 12876, 12880, 12884,
   12888, 12892, 12896, 12900, 12904, 12908, 12912, 12916, 12920, 12924,
   12928, 12932, 12936, 12940, 12944, 12948, 12952, 12956, 12960, 12964,
   12968, 12972, 12976, 12980, 12984, 12988, 12992, 12996, 13000, 13004,
   13008, 13012, 13016, 13020, 13024, 13028, 13032, 13036, 13040, 13044,
   13048, 13052, 13056, 13060, 13064, 13068, 13072, 13076, 13080, 13084,
   13088, 13092, 13096, 13100, 13104, 13108, 13112, 13116, 13120, 13124,
   13128, 13132, 13136, 13140, 13144, 13154, 13155, 13158, 13159, 13160,
   13166, 13167, 13168, 13169, 13170, 13183, 13183, 13192, 13207, 13209,
   13212, 13214, 13218, 13230, 13246, 13250, 13261, 13262, 13265, 13277,
   13286, 13287, 13290, 13291, 13292, 13295, 13296, 13299, 13300, 13303,
   13304, 13307, 13309, 13311, 13313, 13317, 13324, 13331, 13347, 13381,
   13391, 13394, 13398, 13411, 13412, 13414, 13416, 13420, 13434, 13441,
   13502, 13511, 13513, 13514, 13517, 13519, 13520, 13523, 13524, 13525,
   13526, 13527, 13534, 13533, 13543, 13545, 13547, 13548, 13551, 13552,
   13553, 13554, 13557, 13558, 13562, 13561, 13578, 13576, 13592, 13591,
   13605, 13611, 13612, 13615, 13617, 13618, 13621, 13622, 13623, 13624,
   13627, 13628, 13631, 13639, 13656, 13664, 13687, 13793, 13827, 13829,
   13831, 13835, 13839, 13838, 13889, 13891, 13890, 13905, 13911, 13918,
   13923, 13929, 13930, 13933, 13934, 13935, 13936, 13937, 13938, 13939,
   13947, 13955, 13958, 13959, 13960, 13961, 13962, 13963, 13971, 13979,
   13980, 13981, 13984, 13985, 13988, 13990, 13999, 14087, 14088, 14095,
   14096, 14097, 14103, 14112, 14115, 14116, 14117, 14118, 14121, 14122,
   14123, 14126, 14128, 14136, 14137, 14143, 14151, 14152, 14155, 14156,
   14159, 14164, 14171, 14176, 14183, 14190, 14190, 14192, 14199, 14200,
   14203, 14204, 14205, 14206, 14207, 14208, 14209, 14210, 14211, 14217,
   14224, 14236, 14242, 14249, 14257, 14258, 14270, 14281, 14292, 14296,
   14297, 14300, 14305, 14309, 14310, 14313, 14319, 14327, 14333, 14340,
   14344, 14345, 14348, 14351, 14355, 14356, 14359, 14365, 14374, 14379,
   14389, 14399, 14411, 14412, 14413, 14414, 14415, 14416, 14417, 14418,
   14419, 14420, 14421, 14422, 14423, 14424, 14425, 14432, 14433, 14436,
   14437, 14444, 14445, 14446, 14453, 14452, 14469, 14470, 14477, 14476,
   14546, 14552, 14558, 14566, 14572, 14578, 14584, 14590, 14596, 14602,
   14608, 14614, 14625, 14626, 14629, 14630, 14631, 14632, 14633, 14634,
   14635, 14636, 14637, 14638, 14639, 14640, 14641, 14642, 14643, 14644,
   14645, 14646, 14647, 14648, 14649, 14650, 14651, 14652, 14655, 14656,
   14657, 14658, 14659, 14660, 14664, 14665, 14666, 14667, 14668, 14669,
   14670, 14673, 14676, 14677, 14678, 14679, 14680, 14681, 14682, 14683,
   14696, 14697, 14698, 14699, 14700, 14701, 14702, 14707, 14708, 14709,
   14710, 14711, 14712, 14718, 14719, 14720, 14721, 14722, 14723, 14724,
   14725, 14726, 14727, 14728, 14731, 14732, 14733, 14734, 14735, 14738,
   14739, 14740, 14741, 14744, 14745, 14746, 14747, 14748, 14749, 14750,
   14767, 14768, 14769, 14772, 14773, 14774, 14775, 14776, 14777, 14781,
   14781, 14784, 14790, 14791, 14794, 14796, 14801, 14811, 14822, 14829,
   14830, 14831, 14834, 14867, 14869, 14871, 14874, 14884, 14894, 14904,
   14905, 14908, 14910, 14911, 14912, 14915, 14917, 14925, 14926, 14927,
   14931, 14932, 14936, 14937, 14940, 14941, 14944, 14945, 14946, 14947,
   14948, 14951, 14952, 14953, 14954, 14955, 14956, 14957, 14958, 14959,
   14960, 14961, 14962, 14963, 14964, 14965, 14966, 14967, 14968, 14969,
   14970, 14971, 14972, 14973, 14974, 14975, 14976, 14977, 14978, 14979,
   14980, 14981, 14982, 14983, 14984, 14985, 14986, 14987, 14988, 14989,
   14990, 14991, 14992, 14993, 14994, 14995, 14996, 14997, 14998, 14999,
   15000, 15001, 15002, 15003, 15004, 15005, 15006, 15009, 15010, 15011,
   15012, 15015, 15016, 15017, 15018, 15019, 15020, 15021, 15022, 15023,
   15024, 15031, 15032, 15033, 15034, 15035, 15038, 15039, 15042, 15043,
   15054, 15055
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FILTER", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR",
  "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION",
  "FUNCTIONS", "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P",
  "HANDLER", "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P",
  "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING",
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY",
  "INLINE_P", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT",
  "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO",
  "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LABEL",
  "LANGUAGE", "LARGE_P", "LAST_P", "LATERAL_P", "LC_COLLATE_P",
  "LC_CTYPE_P", "LEADING", "LEAKPROOF", "LEAST", "LEFT", "LEVEL", "LIKE",
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP",
  "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MATERIALIZED", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES",
  "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING",
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC",
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR",
  "OPTION", "OPTIONS", "OR", "ORDER", "ORDINALITY", "OUT_P", "OUTER_P",
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL",
  "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS", "POSITION",
  "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY",
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "PROGRAM", "QUOTE",
  "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REF",
  "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME",
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT",
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW",
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P",
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER",
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR",
  "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME", "STABLE", "STANDALONE_P",
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE",
  "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM_P",
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY",
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION",
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P",
  "TYPES_P", "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE",
  "UNKNOWN", "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER", "USING",
  "VACUUM", "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES",
  "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW",
  "VIEWS", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH",
  "WITHIN", "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P",
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS", "XMLFOREST",
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P",
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_ORDINALITY", "WITH_TIME",
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'",
  "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with",
  "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "generic_set", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "reset_rest", "generic_reset", "SetResetClause",
  "FunctionSetResetClause", "VariableShowStmt", "ConstraintsSetStmt",
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt",
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd",
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause",
  "alter_using", "replica_identity", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "opt_program", "copy_file_name", "copy_options",
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids",
  "copy_delimiter", "opt_using", "copy_generic_opt_list",
  "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "old_aggr_definition", "old_aggr_list", "old_aggr_elem",
  "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default", "aggr_arg",
  "aggr_args", "aggr_args_list", "createfunc_opt_list",
  "common_func_opt_item", "createfunc_opt_item", "func_as",
  "opt_definition", "table_func_column", "table_func_column_list",
  "AlterFunctionStmt", "alterfunc_opt_list", "opt_restrict",
  "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes",
  "any_operator", "DoStmt", "dostmt_opt_list", "dostmt_opt_item",
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists",
  "ReindexStmt", "reindex_type", "opt_force", "AlterTblSpcStmt",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "AlterSystemStmt",
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "for_locking_strength", "locked_rels_list", "values_clause",
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause",
  "opt_alias_clause", "func_alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "rowsfrom_item",
  "rowsfrom_list", "opt_col_def_list", "opt_ordinality", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_application", "func_expr", "func_expr_windowless",
  "func_expr_common_subexpr", "xml_root_version",
  "opt_xml_root_standalone", "xml_attributes", "xml_attribute_list",
  "xml_attribute_el", "document_or_content", "xml_whitespace_option",
  "xmlexists_argument", "within_group_clause", "filter_clause",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "opt_target_list", "target_list", "target_el",
  "qualified_name_list", "qualified_name", "name_list", "name",
  "database_name", "access_method", "attr_name", "index_name", "file_name",
  "func_name", "AexprConst", "Iconst", "RoleId", "role_list",
  "SignedIconst", "NonReservedWord", "unreserved_keyword",
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword",
  "statements", "statement", "CreateAsStmt", "$@1", "at", "ECPGConnect",
  "connection_target", "opt_database_name", "db_prefix", "server",
  "opt_server", "server_name", "opt_port", "opt_connection_name",
  "opt_user", "ora_user", "user_name", "char_variable", "opt_options",
  "connect_options", "opt_opt_value", "prepared_name", "ECPGCursorStmt",
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration",
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval",
  "ECPGDeclaration", "$@2", "sql_startdeclare", "sql_enddeclare",
  "var_type_declarations", "vt_declarations", "variable_declarations",
  "type_declaration", "$@3", "var_declaration", "$@4", "$@5",
  "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
      61,    60,    62,   755,    43,    45,    42,    47,    37,    94,
     756,    91,    93,    40,    41,    46,    44,    59,    58,   123,
     125
};
# endif

#define YYPACT_NINF -4802

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4802)))

#define YYTABLE_NINF -2682

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2682)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4802,   365, 24805, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, 25815, -4802,
   -4802, -4802, -4802, -4802,100556,   362, -4802, -4802, -4802,105497,
   -4802, -4802, -4802,   775, 67726, -4802, 70666,   378, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, 74586, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, 56443,  1302, -4802,
     821, -4802, -4802, -4802, -4802, -4802, -4802, -4802,  1322,  5861,
   -4802, -4802, 71156, -4802,    92, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, 71646,   692, -4802, -4802,   584,  1246, -4802,   116,
   15382, -4802, -4802, 64296, 68706, -4802, -4802, 75076,   536,  1899,
   13289,  1322, 25321, 75566, -4802,  1702, -4802, 52966, -4802, -4802,
   -4802, 68216, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, 82916,  2861,   880, 53466, -4802, -4802,
   -4802, -4802, 82916, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, 76056, -4802,  1099,  1120,  1203, 83406, 83896, 65766,
   -4802,  1409, -4802, 82916,  1247,  1260, 55461, -4802, 84386, -4802,
   -4802,  1122, -4802, 76546, -4802, -4802, -4802, -4802,   880, -4802,
   56443, 51982,   200,  1287, -4802, -4802, 84876, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802,  2035,  1028, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802,   692, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802,   594, -4802,  1271,   755,   851,   733,  1263,
   -4802, -4802, -4802, 12305, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802,102017,  2020, -4802, -4802, -4802,  1199, -4802,  1428, -4802,
   -4802, -4802,  1297, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
    1225, -4802, -4802, -4802, -4802,  1885,101043, 74586, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, 63806, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802,   191, -4802, -4802, -4802,
   -4802, -4802, 74586, 74586, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   74586,  1506, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802,   258,  1726, -4802, -4802, 56443,  2573,  2573,  2014,
  102017, -4802, -4802, -4802, 57916, 82916, 82916, 82916,  1785, 82916,
    1595, 82916,   303, 57916,109298, 77036,  1827,  1686, 47469, -4802,
  108454, 82916, 82916, 85366, 82916,  1502, 72136, 82916,  1768, 82916,
   82916,109720, 85856,  1945, -4802,  2200,  1456, -4802, -4802, -4802,
   82916, 15932,  2861, -4802, -4802, 82916,  1830, 57916, 82916,  1770,
   82916,  1847, 82916, -4802, 82916,  1868, 86346,   690,  1649,109298,
    1822, 47973,  1951,109298, 86836, 82916, 82916, -4802, -4802,  1941,
   82916, 82916, -4802,  2060,110142,  2204,  2110,  2263,  2162,   777,
   -4802, -4802,  2342,  1929, -4802, -4802,  2383, 74586, -4802, 72626,
   -4802, -4802, -4802,  2192, -4802, -4802, -4802, -4802, -4802, -4802,
  106766,  1899, -4802, -4802, 58407, 82916,  2231, -4802, -4802, 87326,
   -4802,  2019, -4802,   737, 58898,110564,  2330,  2022, 48477,  2390,
  110986, 87816, -4802, -4802, 88306, -4802, 88796,  2115, 89286, -4802,
  111408, -4802,  2253, 89776, -4802, 11542, -4802,  2004,   984,  2030,
    1400, 74586, 74586,   726,103354, -4802, -4802,   692, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802,   166,   152, 53966,   671,
   54466, -4802, -4802,  1250,  1266,  1333,   166,  2449,  2449,    90,
   74586, -4802, -4802,   152, -4802,   656,   472,  2043,  2043,  2043,
    2233,   887, -4802,  2043, -4802, -4802, -4802, -4802, 76546, 53966,
   54466, -4802,  2048,  2861,    40,  2450,  2108, 82916, -4802, 82916,
   -4802, 82916, 82916, -4802, -4802, -4802,  2469,  2096,  2323, -4802,
    2089, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
    2277,  2290,  2289,    77,  2861,  2187, -4802,  2411, -4802,  2321,
   31409,   853, 74586,  2861, 54966, 77526, 97616,   217,106766,  2861,
   90266,  2157,  1383,  2336, -4802, -4802, -4802,   801, -4802,  2554,
    2190,  2406,    14,  1456, 44985, -4802,  2184,  1767, 76546,102504,
   -4802, -4802, -4802, -4802,   232,  2476, 31918, -4802, 82916,  2199,
   -4802,  2206,  2209,  2223,   851, -4802, 82916,  1305,  1305,  2615,
    1305,  1765,  1838, -4802,  2086, -4802,  2512,  2480, 76546,  1287,
    1322,  2235, -4802, -4802, -4802,  2250, -4802,  2240,  2243, -4802,
     513,  2503, -4802, -4802, -4802, -4802,  2332,  2347,  2366,  2371,
    2281,  2376,   247, -4802, -4802, -4802, -4802,  2575, -4802, -4802,
   -4802, -4802, -4802, -4802,  2713,  2704,105922,105922,   558,   673,
     160,   203, -4802, -4802, -4802,  2558, -4802, -4802,  2562, 82916,
    2397, 82916, -4802, -4802, -4802, 90756, -4802, -4802,  2573,  2250,
    2327, -4802,   271, -4802,  1767, -4802,   330,   358,   403,  1530,
    2329,  1823,  1992, -4802,   201, 82916,  2448,   162,   529,  2374,
   78016,  3477,  2346,   787,  2622,  2660,  6048,   247, 78506, -4802,
   82916, 82916, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802,  2364, -4802, -4802,  2367,  2634,   576,  2559,  1728,  2675,
    7041,  1973, 91246, 98106,  2644,  2694,  8361,  1740,   768,  2582,
     854,  2693,  1671,  2701,  9360, 82916,  2405, -4802,  2640,  2759,
     878, -4802,   273, -4802,  2484,  2624,    -4, 57916,  2452, -4802,
   -4802, 82916, -4802, -4802, -4802,  2522, -4802,   774, 57916, -4802,
    2649,  2505, 48981, -4802, 82916, -4802, -4802, -4802, -4802, -4802,
    2587, 82916, -4802, -4802,  2710, 82916, -4802,  2043,  2630,  2491,
    2877, 61353,    71, 82916,  2542,  2921, 82916,  2721,  2542,  2563,
   91736, -4802, -4802,  2542, -4802, -4802, 82916, 82916,  2543,  1382,
    2542,  2742,  2951,  2974,  2656,  2774,   926,  1564,   115,  2900,
    2542,  2646, 82916, 92226, 82916,  2671, 82916,  2980, 57916, 82916,
   -4802,  2776, 78996, -4802,  2620,  2342, -4802, -4802, -4802, -4802,
   -4802,  1078, -4802, -4802, -4802, -4802,  2932,  2327,   592,  2933,
    2635,  2940, -4802, -4802,  2676, -4802,  2944,  2346,  2950, -4802,
    2651, 92716, -4802, 93206, 93696,  2959,  2364,109298,  2960,  2651,
    2971,  2865,  2984,   592,  2985, -4802,  1045,  2992,  2880,  3003,
    1624,  2651,107188,  3004,   106, -4802, 14761, 11542, -4802, 27356,
    1778, -4802, -4802, -4802, -4802, -4802, -4802, 35481,   744,  2798,
   -4802, -4802, -4802,  1864, -4802,104641, -4802,   726,   152, -4802,
   74586,   152, 74586,    90,   152, 74586,   152, 74586,    90,   152,
   74586, 74586, 74586,   152, -4802, -4802,  2024,   366, -4802, -4802,
   -4802, -4802, -4802, 74586,  2728, 82916, 82916, -4802, -4802, -4802,
   69196,109298, 69686, -4802, -4802,   150, 74586, -4802, 74586, -4802,
    2861, -4802, -4802,   984, 61353,  3140,109298,  2980,  3024,  3024,
    3024, -4802, -4802, -4802,  2973, 82916,  3036,  3039, 69196,109298,
   -4802, 94186,106766,  2937,  2753, -4802, -4802, -4802, -4802,  1987,
    2917,   412,  2983, 35481,  2754,   296,   296,  2755,  3045, -4802,
   -4802, -4802,   427,  2758,  2761, -4802,   457,   457,  2926,  2765,
    2766, -4802,   474,  2767, -4802,  3083,   483,  2768,  2770,  2772,
    2052,   296, 35481, -4802,  2773,   457,  2777,  2780,  2782,  3099,
    2783, -4802,  3113,  2785,   309,   374,  2786,  2788, -4802,  2765,
   -4802,   443,  2789,  2790,  2791,  2792,  2793,  2795,  2796,  2797,
   35481, 35481, -4802, 30391,  1767,  2861, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802,   107, -4802,   523,  3236, -4802,  2809, -4802,
   -4802,  2962, 35481, -4802, -4802,  3021,  2801, -4802,   533, -4802,
   -4802,  1767, -4802, -4802,  1522, -4802, -4802, -4802, -4802,  1979,
    1979,   221, -4802, 71156, 71156, -4802, -4802,   173,  2804, -4802,
    1197, -4802, -4802, -4802, -4802, -4802, -4802,106344,  3203, -4802,
    2029,  2861,   273,  1718,  3149,103779,104210,  3046,  3046,  3027,
   -4802, -4802, 82916, -4802, -4802, 35481, 50998, -4802,  1767,    98,
    3052, -4802, -4802, -4802,  2047, -4802, -4802, -4802,   692, -4802,
   14660, -4802,  2054,  2199, 82916, 82916,  3215, -4802, -4802,  2206,
   -4802, -4802,   851,   851, 35481,   851,   143,  1511, 32427, 35481,
    3101,  3001,  1451,  1023,  3104, -4802,  3009,  1765,  1838, 76546,
   82916, 94676,  2931, -4802, -4802,  2250,  2823,  1834, -4802, 63316,
  101530,101530,  3071, -4802, -4802,  1517,   975,  2942,  3034,  2449,
    1135,  1558, -4802, -4802,  2822, -4802,  3160, 71156,  2883,105922,
   -4802, -4802, 82916, -4802, -4802, 79486, -4802, -4802, -4802,   842,
    2826, -4802,  2843, 82916,  3331, -4802,  1558,  1558, -4802, -4802,
    2831, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,102017,
    2835, 82916, -4802,  2841,  2845, -4802,102504, 51490,  1915,  1767,
    2920,  2923,  2969, 56443,  2846,  2927,  2928,  2975,  2929,  2934,
   98596, -4802, -4802, -4802, -4802,  1495,  1248,  1083,  2939,   371,
     146,  3209, -4802,  1124,  2977, -4802, -4802, -4802,  5446, 82916,
    3157,  9522,  3049,   247,  2986, -4802, -4802,  3095,  2947,  2948,
    3064,   247,   170, 99086, -4802, -4802, -4802, -4802, -4802, -4802,
    4878, 28890, -4802,  2952,  2930,  2961, 82916, 64786,  1497,  3063,
    1270,  2135,   123, 82916,  3137,  3070, 82916,  2881,  2967,  2968,
    3152,  2884,  1531,  3243,  2889, -4802, -4802,  3065,  3158,  3196,
    9649,  2953,  2963, 60371,  1251, 49485,  3245,  1773,  2988, -4802,
    1773, 82916,  2989,  2990, 82916,   247, -4802,  3285,   247,   247,
    1282,  3295,  2991,   163,  1618,  2542,  2889,  1921, -4802,  2993,
    2994,  1940, -4802,  3100, -4802, -4802,  1492,  3005, 76546,   176,
    1888,  2889,  2996,  2998,  2884,  2884, 82916, 82916, 82916, 82916,
   82916,   144,  3321,  3326,  3007,   145,  3051,  2935, -4802,107610,
    3013, 97616, -4802, -4802, 82916,  3016,  1911,  2889,  1771, -4802,
    1784, -4802, -4802, -4802,  1456, -4802, 82916, -4802, 82916,  2327,
   61353,  3118, -4802,  2978, -4802,  2346,   247, -4802, 82916, 82916,
    2364,  1043,  1204,  3131, 82916,  3191,  2987, -4802,   347, 51490,
   -4802,  2543,  2954, -4802,  3002, -4802,  3002,  3002,  2957,  2957,
    2958, -4802, -4802,  2052,  3002,  2957, -4802, 62335, -4802,  1455,
    1869, -4802,  3364,  3356, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802,  1227, -4802,  2068, -4802, -4802, -4802, 82916,
   56443, -4802,  3376, -4802, -4802, 61353,  3150,  3264, -4802, 82916,
    3165,  2970, -4802,  3300,  3026, -4802, -4802,   516, -4802,  3274,
  109298,   791,  2861,  3018, 82916,  3194, 82916, 82916, 82916, 82916,
   -4802, -4802,  3166,   630,    56, -4802,107610, -4802, 82916,  1921,
    3177,  3383,   716,  2043, 82916,  3268, -4802, 82916,  2995,  3385,
    3220, -4802, -4802,  2982,  2449, -4802,  2620, -4802,  2121, -4802,
    3107, -4802, 57916,   592, -4802, -4802, -4802, -4802, 61353, 82916,
   95166, 57916,   592,109298,109298,  3288,   106,  3291,  3053,  3292,
    3055, 49485,   592,   117,109298, 82916, 82916, 82916, -4802, 82916,
   -4802, -4802, -4802, -4802, 82916, 82916,109298,107610,  3298,  3305,
     592, 82916, 82916, -4802, -4802, 27267,  1893, -4802, 11542, -4802,
   14660,  2094,  3046, -4802,  1506, 82916,  1338,   726,108032, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, 74586, -4802, 74586,
      90, -4802, -4802, 74586, -4802, 74586,    90, -4802, 74586, -4802,
   -4802, -4802, 74586, 82916,  3504,  3008, -4802,  1522, -4802, 82916,
    2105, -4802, -4802,  2128,    86, 82916, 82916,    99, 57916, 82916,
    3197, 82916, 82916, 82916, 82916, 82916,  3085,  2804,  1407, -4802,
     317, 76546,  3208, -4802, -4802, -4802, -4802, -4802,  2133,  2035,
     914, 82916, -4802, -4802, -4802, -4802, -4802, -4802, 69686, 68216,
    3302,    74, 82916, -4802, -4802,  3618, 35481, 30900, -4802, -4802,
   -4802,  3014, 14660,  3062, 35481, -4802, -4802, 35481,  3028,  2449,
    2449, 35481, -4802, -4802, -4802, -4802,  2825,  2449, -4802, 35481,
   35481,  2449,  2449,  3002,  3002, -4802,  4315, 35481, -4802, 49485,
   35481, 37008, 28380, 35481,  3105,  3047,  2449, -4802,  2449, -4802,
   35481, 29882, -4802, 35481,  3235, 38026, 35481,  1718,  3238, 35481,
    1718,  3456,  3456,  1287,  1703,  6330,  3029,  1767, -4802,  3143,
    2449, -4802,  2449,   879,   244, 61353, 35481, 56443,  3116,   154,
   82916, 35481,  3040,  2018, -4802, 35481,   845, -4802,  3041, 35481,
    3111, 35481, 35481, 35481, 35481, 35481, 35481, 35481, 35481, 35481,
   -4802, 39016,   269, -4802,  3319,  3337,   504,  1049, 70176,  3332,
   -4802, 31409, 27870, -4802,   263, 74586, -4802, -4802,  1767, -4802,
   -4802, -4802, -4802, -4802,   842,  3054, -4802,  3067, -4802, -4802,
   -4802, -4802, -4802, 82916,  3203, -4802, -4802,  3124, -4802, -4802,
   -4802, -4802,   582, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802,  3057, -4802, -4802, -4802, -4802,  3057, -4802, -4802,  3046,
    3060,  5362, -4802, -4802, -4802, -4802,  3320,  3343,   592,102017,
   82916,   232, 73116, -4802, 31918, -4802,  2145, -4802,  3056, -4802,
    3325, -4802,  3076, -4802, 10104,  3325, -4802, -4802,   205,  3182,
    3323,  3265, -4802, -4802, -4802,  3079, 14660, -4802,  2009, 14660,
    2076, -4802, -4802, -4802, -4802, -4802, -4802,  1342, -4802, 82916,
    3208,  3101,  1023,  3141,   615, 82916, -4802, 45480,  2002, -4802,
    2250, -4802, -4802, 26303, -4802, 26793, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802,  3084, -4802, -4802, -4802, -4802,
     247,  3086,  3568, -4802,105922, -4802, -4802, -4802,  3504, -4802,
    2383, -4802,  2383,  3593, -4802, 74586, -4802, -4802, -4802, -4802,
    1063, -4802, 11542, -4802, 11542, -4802,  3271, -4802,  3483, -4802,
   62335, -4802,  3096, -4802, 61844, 59389, -4802, -4802,   872, -4802,
    1151,  3175,  3176,  3222,109298, 82916, 82916, -4802, 56443,109298,
   82916, 82916,109298, 82916, 82916, -4802,  3462,   -48, 68216,  3224,
   66256, -4802, -4802,  3103, 82916,  3159,  3344,  3347,  1177, -4802,
   -4802, 95656, -4802,  3307,109298, 82916, 82916, 35481,  3308, 82916,
   82916, -4802,   394,  3192,  3193, -4802, 82916,  3195, 57916,  3114,
   82916, 82916, 82916,  3190,   805, 57916,  3167, 49989, 82916, 82916,
   82916, 82916,  3247, 82916, 82916,  3362,  1295, 76546,   245,  2000,
    2889,  3327, -4802,  1107, -4802,109298, 82916,  3314, -4802, -4802,
   -4802, 66746,  3529,  3237, -4802, -4802, 99576, -4802, -4802, -4802,
    2149, -4802,109298,109298, 82916,  9658, 82916,  1267, -4802, -4802,
   61353, -4802, 82916, 82916, 82916, 82916, 73606, 96146, 96636,  1328,
    1363, 82916, 74096, -4802, 82916, -4802, -4802, 56934,109298, 82916,
     834, 56443, -4802, 82916,  3322,   184, -4802, 82916,  7300,  3210,
    3221, 82916,   300,  2178,  2889, 82916, 82916,  3134,  2161,  3216,
    3260, -4802, 82916, -4802,109298,  2690, -4802,  3280,109298, 82916,
    7634, -4802, -4802,   247, -4802, -4802, -4802, -4802, -4802, 82916,
   82916,   247, 82916,   247,  1550, -4802,109298, 82916, -4802, -4802,
   -4802, 82916,  9813, 82916, 82916, 82916, 82916,109298, 82916, -4802,
   -4802,  1516,  1482,  1329,  1546,  3281, 82916,  3413, 82916, 97126,
  109298, 82916, 82916, 82916,  1187, -4802, -4802,  3259, -4802,109298,
    2690, 10069, 82916, 82916,  3225,  3226,   141,  3297, -4802, -4802,
   -4802, -4802, -4802, -4802,  3393,  3556, 82916, -4802,  3395,  3396,
    3211,  3213,  3402,  2058, 82916, -4802, -4802, -4802, -4802, 82916,
    3403,  2058,  3348,   714, -4802, -4802,  2542, -4802,  2165, -4802,
    3178, -4802, 35481,  3572, 61353,  3164,  3169,  3248, -4802,  3249,
    2449, -4802,  2186, -4802, -4802,  2193, -4802,  3181,   630,  2005,
   -4802, 56443, 82916,   619,  1032,  3474, 65276,  2506,  3463, 82916,
    3218, 82916,  2506, 82916, -4802,  1861, 68216, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802,  3465, -4802,  2861,  2543,
    2543,  2543,  2543, -4802, -4802, -4802, -4802,  3366,  1873, -4802,
    3180,  2543, 82916,  3294,  2506,  3183, -4802,  1921,  3485,  3487,
   82916, 65276,  2247,  3223,  3591,  2043,  2861,  3375, -4802, 29386,
    5607,  3377,106766, 78996, -4802,  3198,  3466,  3467,  3479, -4802,
    2327, -4802,  3598, -4802,  3497,   592,  2346, -4802,  2651, -4802,
   82916, -4802, 82916, 82916, 82916, 82916,  2364, -4802, -4802,  2651,
    3384,   592,   592, -4802,  3387,   592,  2651,  3310,  3488,106766,
   -4802,   106, -4802, -4802, -4802, -4802, -4802, 35481, -4802, -4802,
    2043,  2121, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, 74586,  2383, -4802,  2214, -4802, 82916, -4802,
    3468,  3469,  3470,  3199,  3206,  3242, 82916,  3212, -4802,  3199,
     247,  3199,  2804,  2804,  3199,  3206,108876,  3629,  3495,    78,
   -4802,   720,   546,  3429, -4802, -4802, -4802, -4802, 61353, -4802,
   -4802, -4802, -4802, -4802, 82916,  3255,   122,  3407,  3234,108876,
    3626,   592, -4802, 57916, -4802, -4802, -4802,  3312,  3328, 57916,
    3431,  3287, -4802, -4802, -4802, -4802, -4802, -4802, -4802,  3482,
   82916,  2219, -4802,  1927, -4802,  1942, 35481, 35481,   121, -4802,
   10464,  2230, 35481,  3250,  3253,  2237, -4802, -4802, -4802, -4802,
   -4802, -4802,  3257,  3530, -4802, -4802,  3258,  2249,  2257,  3261,
    3262, -4802, -4802,  6280,  3263, 11686,  3266, 37008, 37008,   981,
   -4802, -4802, 37008,  3269, -4802,  2265, 10395,  3246,  3272,  3279,
   -4802,  3277,  3283, 12755, 32936, 35481, 32936, 32936, 12792,  3246,
    3286,  2287, 56443,  3416, 13599,  2304, -4802, 35481, 56443,  6802,
   35481, -4802, 35481, 82916,  3289,  3303, -4802, -4802,  4315, -4802,
    3284, -4802, 37008, 37008, -4802,  4474, 30391, -4802, -4802,  3540,
   -4802, -4802,  1678, -4802,  3275, -4802, -4802,  5066,   156, 35481,
    3040, 35481,  3342, 49485,  4031, 35481,  4800,  3685,  3685,   453,
     453,   133,   133,   133,   289,  1049, -4802, -4802, -4802,  3282,
    3293,  3296,  3448,  2783, 35481, -4802,  2408,  2414, 82916, 12043,
   14003, 14169, -4802, -4802, 40529,  3334, -4802, 35481, 35481, 35481,
    3306, -4802,  3704, 14660,   447, -4802,  3711, -4802, -4802, -4802,
    1145,  3593,   842, -4802,  1456,  2449,   879,104641, -4802, -4802,
   -4802, 35481, -4802, -4802, -4802, -4802,  2206, -4802, -4802, -4802,
   -4802, -4802, 82916,  2035, 35481, -4802, -4802,   718,  2215, 35481,
    2009, -4802, -4802,  3346, -4802, 35481, -4802, -4802, -4802,  2804,
   -4802, -4802, -4802, 40529,  3338,  3341, 44490,  3430, -4802, -4802,
   82916,   212, -4802, -4802, -4802,  3329, -4802, -4802, -4802,  1626,
   -4802, -4802, -4802, -4802, -4802, -4802,  3304, -4802,  3309, -4802,
    3330, -4802, -4802, -4802, -4802,   178,  3317,  3316,  3324,  1780,
   -4802, 59389,  2068, -4802, 61844, -4802, 61844, -4802,  2068,  3689,
   -4802, 59389,  1817,109298, 82916, 82916, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802,  3531, -4802,109298,109298,
    3496, 82916,  3492,  3499, 35481,   611, 82916,  3333,  3335,  1362,
    3581, 82916, -4802,  3623,   592, -4802, -4802,  3400, -4802, 14660,
   -4802, -4802, -4802, -4802, -4802,109298, 82916, -4802,106766, -4802,
    2327, 61353, -4802, -4802, -4802, 82916,  3361, 82916, -4802, 82916,
   82916, 82916,  2364, -4802, -4802, -4802, -4802,  1210, -4802, -4802,
   82916, 82916,   637,  3401,  3414, 82916, -4802,   595,  3100, 10181,
   82916, 82916, 82916,  3596, -4802, -4802, -4802, -4802,  3535, -4802,
   -4802, 59389, -4802,  2651,   995,  3421,  2889, -4802,  3527, -4802,
    1219, -4802, -4802, -4802, -4802, -4802,  3648,   592,  3649,   592,
   82916, 82916, 82916, 82916, -4802, -4802, -4802, -4802, -4802, 56443,
   56443, 56443,  2340, -4802, -4802,  2861, -4802, -4802, -4802, -4802,
   -4802, -4802,  3611, -4802,  2344, -4802,   992, -4802, -4802, -4802,
   -4802, -4802, -4802,109298, 82916, 10344, 82916, 82916, 82916,  2012,
   -4802,   639, 61353, -4802, 60862,109298, 82916, -4802, -4802,  3576,
    3520, -4802,  2375,  3523,109298,  3418, -4802, -4802,  3435, -4802,
   -4802,  3439,  2183,  2889,  1921, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802,  1068,   323,  2226,  2889,  3440, -4802,  3441,
   -4802, -4802, -4802,  3582,  3583,  3585,  3446,  3449,  3493,  3451,
    3452,  3500, -4802,  3454,  3501,  3457,  3503,  3460,   592, 61353,
    3586,  2861,  3498,  3686,   592, -4802,  3464, -4802, -4802,  3788,
   -4802, 82916, -4802,  3471,  2259,  2889, -4802, -4802,109298, 82916,
   -4802, -4802, -4802,  2058, 61353,  3633,  2058,  2058, 82916, 82916,
    2058, -4802, -4802, -4802,  3634,  3635,  2058, -4802, -4802, -4802,
   -4802,  2630,  3398, -4802,  2192, 46965,  7028,  3397,  3169,  3392,
    2449, 43005,  1657,  3606,  3399, -4802, -4802, 56443, 46965,  1930,
    3624,  3415,  3415,  3415,  3415,  3415,  3415,  3415, -4802,  2358,
     260,  2542,106766, 82916,106766, -4802,  1032,  3527, 82916, 82916,
    3404,  3406, -4802, -4802, -4802, -4802,109298,  1047,109298,  2449,
   -4802, -4802,  3472, -4802, 82916,  2043,  3799,  2974,   791,  3543,
    2212,  3750,  3223, -4802, -4802, -4802, -4802, 82916, 82916,   630,
    2861, -4802,  3410,  3409, -4802, 82916, 82916, 82916, 82916,  2035,
    3419,  3417, 61353,   494,  3602,  3609,  2884,  3830,  2035,  3223,
    3505, 82916, -4802,  2362,    87, -4802,  2861,106766, 59880, -4802,
    4512, -4802, -4802,   759,  3701, -4802, 82916, -4802, -4802, 43995,
     592, 61353, 82916, -4802,   592,   106,  3484,   592,  3486,   592,
     592, 82916, -4802, -4802, 82916, -4802, 82916,107610,   592, -4802,
   14660,  3716, -4802, -4802, -4802, -4802,  3552,  3555,  3557, 82916,
    3199, 57916, -4802,  3434,109298,  1508, -4802, -4802,  3617, -4802,
   -4802, -4802, -4802, -4802,  3741,  3742, -4802, -4802, -4802,   756,
   -4802,109298, 69196,   177,109298, -4802,  2327, -4802, -4802,  2346,
     247, -4802, 82916,  3683, -4802, -4802, -4802,  3443,  2398, 14029,
   35481, -4802,  3754, 61353, -4802,  7375, -4802, -4802, -4802, -4802,
   35481, -4802, -4802, -4802, -4802, -4802, 35481, -4802, 35481,  3729,
   -4802,  3871,  3871, 61353, 37008,  1858,  2777, 37008, 37008, 37008,
   37008, 37008, 37008, 37008, 37008, 37008, 39525,   704, -4802, -4802,
   35481, 35481,  3737,  3729, -4802, -4802,  1540,  1540, 61353,  3450,
    3246,  3453,  3459, 35481, -4802, -4802,  2407, 38521,  3461, 56443,
   -4802, 35481, 10432,  2415,  3502, 14380,  1767,  7514, -4802,  3827,
    2861, 35481,  1855,  2284, 35481,  2433, 35481,  3736, -4802, -4802,
   -4802,  3455, -4802, -4802, 61353, 35481, 37008, 37008,  5557, -4802,
    6657, 35481,  3475,  8635, 30391, -4802,  3637,  3506, 45975, -4802,
     880,   880,   880,   880, -4802, 82916, 82916, 82916, 41024,  3745,
   40034, 79976,  3476,  1715, -4802, 79976, 80466, -4802,  3481, -4802,
    3473,  1767, 35481,  3740,   664,   664,  3637, -4802, 35481, 33445,
    3480, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802,  3494, -4802,  3491,
   -4802, -4802,   273,  3513, -4802, -4802,  5435,   178, -4802, -4802,
    3515, -4802,  3507, -4802,  2215, -4802, -4802, -4802,  7883,  3638,
   -4802, -4802,  3476, 33954,  3430, -4802,  2438, -4802, -4802, 31409,
   -4802, -4802,  2442, 45480,  3338, 31918,  1767,  2449,  3508, -4802,
    2383,  1145, -4802, -4802, -4802, -4802, -4802,  2456,  1829, -4802,
   -4802, 59389, -4802,  3536, -4802, -4802, -4802,  3415,  2651,  2651,
    1414,  3199,  3758,  1414,  7986, -4802, -4802, 41519, 82916, 82916,
   -4802, 82916,  2460,  1590, 82916, -4802, 82916, -4802, -4802, -4802,
   -4802,  3877, -4802, 82916, -4802, -4802,  3537,  3538, -4802, 82916,
   82916, 82916, 82916, -4802, -4802,  2329, -4802, -4802,109298, 82916,
   -4802, -4802, -4802,   325,  2297,  2889, -4802,  3561, -4802, -4802,
    3728, -4802,  3868,  3570, 82916,  3517, -4802,  1590,   213,  2884,
     610, -4802, -4802,  3554, 82916, -4802, 82916, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, 56934, -4802, -4802, 82916,
   -4802, 56443, 46965, 56443, -4802,  1111,   361,  2303,  2889, -4802,
    3564, -4802,  3575,  3577,  3625,  1281,   132,  3595,  3597,  3627,
    3518,  3524,  3526, -4802, -4802,   166,  2861, -4802, -4802,  2861,
    2651,  2861, 82916, 82916, 82916,  3892,  3614, 82916, 82916, 82916,
   82916, 82916,  3795,   825,  1972,109298, 82916, 82916,109298, 82916,
   82916, 82916, 82916, 82916, 82916, 82916, -4802,  3894,  3833,  2114,
    3874,  3604, 82916, -4802, 82916,  3100, 82916, 82916, -4802, -4802,
   -4802,  3539,  2058, -4802, -4802,  3782,  3784, -4802,  2058,  2058,
   -4802,   347, 56443, -4802,  2892, -4802,  3178,  3507,  2449,  1558,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802,  2449,  2508,  3545,
   -4802, 43500, -4802,  3542, -4802,  2292,   879, -4802, -4802, 82916,
    3415, -4802,  2787,  2748,  2946,  2955, 80956, 81446, 81936,  3546,
   82916, 82916, 37008, -4802,  1426,   126, -4802,  3786, 82916,  3584,
   -4802, -4802, -4802,  3699, 82916, -4802, -4802, -4802, -4802, -4802,
    3549, -4802,  3664, 65276,  2651,109298,109298,  2651, -4802, 61353,
    3558,  3223,109298,   791,  1551, 92226,  3587, -4802,  3551,  3841,
   -4802,  3559,  3560, -4802, -4802, 82916,  3527,  2475,   761,  2030,
    3255, 67236,  2247,  3815, -4802, -4802, -4802,  3924,  3646, -4802,
    2035,  3255,  3646,  2861,  3159, -4802, 59389, 35481, 35481, -4802,
    3562, -4802,  3566,  6225, -4802,  2543, -4802, -4802, -4802, -4802,
   -4802, -4802,  3639, 82916,  3992, -4802, -4802, -4802,  3567,   592,
   -4802, -4802, 82916, -4802, 82916, -4802, -4802,   592,   592, -4802,
    3680, -4802,  2035, 82916, 82916, 82916,  3199, -4802,   247, -4802,
    3848,108876, -4802, -4802, -4802, -4802, -4802,  3910,    74,  3856,
   -4802, -4802,  3816,  3819,  3820,  3821,  2396, -4802, -4802, 35481,
   14660, -4802,  3579, -4802, 14660,  8393, 14660,  3737, -4802,  1898,
    3867, -4802,  1086,  3588,  1898,  2598,  2598,   485,   485,   142,
     142,   142,  3871,   704, 14660, 14660, -4802, -4802, -4802, -4802,
    3589, -4802, -4802, -4802,  3246, -4802, 35990,  3730,  3972, -4802,
   -4802, -4802,  3630,  3631,  3590, -4802, 35481, 36499,  3592, 62335,
   -4802, -4802,   879,  1751, 37008, 37008,  2579, -4802,  1071, 35481,
   61353,  2487,  2579,  2541,  2568, 35481, 35481,  9459,   283, 35481,
    8556,  3599, 35481,100066, -4802, -4802, 82916, 82916, 82916, 82916,
   -4802, -4802, -4802, 79976, 80466,  3601, 42509,  1715,  3603, 82916,
   -4802, -4802,  3605, 40529,  3826,  3764, -4802, 40529,  3764,  1541,
    3764,  3829, -4802, 46470, -4802, -4802,  3608, -4802, -4802, 27870,
    1933, 14660,  3984,  3872, 35481,  3612,  3613,  3619, 14660, 35481,
   -4802,  2861,  1145,   649,  2861, -4802, -4802, -4802, 49485, -4802,
   -4802, -4802,  3787, 14660, -4802,  2035, 82916,  1767,   189,  3615,
   82916, -4802,  3430, -4802, -4802, 11542, -4802, -4802, -4802, -4802,
    3667,  2494, -4802,   166, -4802, -4802, -4802, -4802,  3687, 68216,
    3893, -4802, 35481,  2495, -4802,  3651,  3982,   110,  2504,  2511,
    1590, -4802,  3584, -4802,  1437,  3878,    80, -4802,   592, -4802,
   61353, -4802, 82916, 82916, -4802, -4802, -4802, -4802,  2846, -4802,
   -4802, 82916, 82916, 82916, 82916, -4802,109298, 82916, -4802, 56443,
    2358,  3813, -4802, -4802,  3823,   166, 82916, -4802, 61353,   592,
     592, -4802, -4802, -4802, -4802,  3652,  4013,  3721, 82916, 82916,
   82916, 82916,109298, 82916, 82916,  2449,  2449, 61353,  3640, -4802,
    2449,  2449,  3645, -4802,109298, 82916, 82916, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802,109298, 82916, -4802,
    3715, -4802, -4802, -4802, 82916, 82916, 82916, 82916,  3943, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   82916, -4802, -4802,  2861,  2861, 61353,   592,   592, -4802, -4802,
   -4802,  3895, -4802,  2058,  2058, -4802, -4802,   287,  2524, -4802,
  102926, -4802, -4802,  2921,  2861,  2921,  1575, -4802, -4802,  2921,
   -4802,  2921, -4802,  1590,  3650,  1806,  3932, -4802,  1982,102017,
   43500, 43500, 43500, 43500, 43500, -4802, -4802,  3935,   166, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802, 35481, -4802,  1432,  1898, -4802, -4802,
   -4802, -4802,  3584,  2043,  3708, 57916,  1200, -4802,  3918,   619,
   65276,  1542, 82916, -4802,  2651,  2651,  3712, 82916,  4061, -4802,
     784, 82916,  3973,  3702, -4802,  2861, -4802, -4802,  3223, 82916,
   65276,  3255, -4802,  2537, -4802, -4802, -4802,  3703,  3609,  3663,
    2247,  1410, 82916, -4802,  3705, -4802, -4802,  3949,  3666, -4802,
   14660, 14660,  2861, 62826,  4512, -4802, 82916,  3926, 82916, -4802,
     592, -4802,   592,   592, -4802, -4802, 82916,  3199,  3199,  3199,
   -4802,  3854, -4802, -4802,   592,108876,  2396,  2396,  2396,  2396,
   -4802, -4802, -4802, 14660, -4802, -4802, -4802, 37008,  3959, -4802,
    3688, 61353, -4802,  3690,  2548,  2565, 38026,  3831, -4802, -4802,
   -4802,  8847,  3735, 14660,  3791,  3691,  3692, -4802,  1269,  1269,
    1071,  2566, -4802, 37008, 37008,  2579,  2579, 35481,  2579, -4802,
   -4802,  8926,  3864, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   57425, 79976,  3697, 82916,  1715, 40529, -4802, -4802,  1629, -4802,
   40529,  3927, -4802, 40529, 82916,  3698, 82916,   447, 35481, 35481,
    3744, -4802, -4802, -4802,  3637, -4802, -4802,  1558, -4802, -4802,
   -4802, -4802,   879,  3710, 74586, -4802, -4802, -4802,  1287, -4802,
   -4802, -4802, -4802, -4802, -4802,108876,  3886,108876,  1590,  8962,
    3584, 41519, 50493, 82916, 82426, 82426,  3849,  3584,  3708, -4802,
   -4802, -4802, -4802, -4802, -4802,  3713, -4802, -4802, -4802,  3781,
   -4802, -4802,   -89,  3208,  2576, -4802, -4802, -4802, -4802, -4802,
    3894, -4802, -4802, 46965,109298, 82916, -4802,  3789, -4802, -4802,
   -4802, -4802, -4802, 42014, 49485, -4802,  1281,  3709,  3717,   132,
   -4802, -4802, -4802,   -73,  3208, 82916,  1527,   545,  3751,  3199,
    4005, -4802, -4802, -4802,  3894, -4802, -4802,  2058, -4802, -4802,
   -4802,  2542,  4044, -4802, 56443, -4802,105072, -4802, -4802, -4802,
    2861, -4802,  2861,  3914, 82916, 52474,  2861,  2861, -4802, 57916,
    4126,  4126, -4802,  3722,  2081,  2081, -4802, -4802, -4802, 82916,
   -4802, -4802,  9002,  3919, -4802,  3708,  3941,  3988, -4802,  3731,
   82916,  3882,  3732,  3734,   651,   651,  3527, 82916,  2580,  2035,
     791, 65276,  3527, -4802,  1821,  3738,  4032, -4802,  4134,  3419,
    3739, -4802, -4802, 67236,  3921,  3646, 82916,  3609,  3861, -4802,
    3869, -4802,  1209, -4802, 82916, 41519, -4802, 61844, -4802,  2594,
   -4802, -4802,  3334, 82916,   658, -4802,  3755, -4802, -4802, -4802,
   -4802, -4802, -4802,   177, -4802, -4802, -4802, -4802,   997, 37008,
   61353,  2597, 35481, -4802, 35481, -4802,  4131, -4802, -4802, -4802,
     815, -4802, -4802, -4802,  1269,  1269,  2579, -4802,  4135,  3637,
   -4802,  2613,  4151, -4802, 82916,  2617, -4802, 35481,  3748, -4802,
   -4802, 40529,  1629,  2637, 82916,  2654, 61353,  3749,  3246, 14660,
   82916, -4802,  3752, -4802, -4802, -4802, -4802, -4802, -4802,  1508,
    1414,   177,  3982,  3708, -4802,  3757, -4802, -4802, 82916, -4802,
     285,   285, 82916,  3708, -4802, -4802, 82916,  3834, -4802, -4802,
   56443,  3806, -4802,   -51,  3208, 82916, 61353,  2346,   118, -4802,
   61353, 61353, -4802,  3837, -4802, -4802, 82916, 82916, 82916, 82916,
   82916,   592, -4802,  3398,  2861, -4802, -4802,  2664, -4802, -4802,
   -4802, 82916,  3551, -4802,  3551, -4802, -4802,  4126,  1080, -4802,
   -4802, -4802, -4802,  2286,  3956, -4802,  1388,  3946,  3846,  3761,
   -4802, 57916,  4195,  3879, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802,  4060,  3223,  3705, -4802, -4802, -4802, -4802,
   35481,  3922,  2035,  2247,  3815, -4802, -4802, -4802,  2668,  3646,
   -4802, -4802,  4145,  3953,  4149, -4802,  2686, -4802, -4802,  6225,
   62826,  4095, -4802,  3828, 82916, -4802, -4802,  2839,  4204, -4802,
     997,  2689, -4802,  2692,  2697,  3923,  3832, -4802, 35481,  1394,
    3481, 57425,  3779, -4802,  2698, -4802, 14660, 82916, -4802, -4802,
   -4802,  2706, -4802, -4802,  3777, -4802,  4186, -4802, -4802,  4069,
   -4802, 82426,  3825, 49485, -4802,  2215,  2215,  2043, -4802,  1590,
   -4802, 82916, -4802, 35481, -4802,  3876, -4802, -4802,  2707, -4802,
    1178,  3939,  4082,  2711,  2714, 82916,  3206,  3835,  3206, -4802,
    3199, -4802, -4802, -4802, -4802,105072,  3551, -4802, -4802, -4802,
    4109,  4054, -4802, -4802, -4802, -4802,   281, -4802,  3987,  3989,
   82916, -4802,  3796, -4802,  2715, 82916, 82916,  4209,  4211, -4802,
    9278, 57916,  3705,  3609,  2247,  2358, -4802, -4802,  3990, -4802,
    3991,  3223, 41519,  4512, -4802,   931, -4802, -4802, -4802, -4802,
   -4802, 82916, -4802, -4802, -4802, -4802, -4802,  3246, 34463, 34463,
    3809, -4802, -4802, 82916, -4802,  2719, -4802, 82916,  3811,108876,
     285,  3814, -4802,  3812, -4802, -4802,  3941,  1590,  3208, 14660,
   82916, 57916,  4203, -4802, -4802, -4802,  3939, -4802, -4802,  3208,
   82916, -4802,  3942, -4802,   771,   771,  4146, -4802,  3880, -4802,
   -4802,  3818, -4802,  4248,  3527, -4802,  1281,  2035, -4802,  3824,
   -4802,  3646,  3609, -4802, -4802,  3646, -4802, -4802, -4802, -4802,
    1953, -4802, 37517,  3947,   633, 10736, -4802, -4802, -4802, -4802,
    2720, -4802, -4802, -4802,   177,  2215, 35481,  1590, -4802,  3946,
   -4802,  3208,  2346, 82916, -4802, -4802, -4802,  3702, -4802,  4239,
   -4802,   953, -4802, -4802, -4802, -4802, -4802,  3640,  3705, 55952,
   -4802,  3646,  3334, -4802,  2126, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802,  4233, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802,  9830, -4802, -4802, -4802, -4802,  4130, -4802, -4802, -4802,
   -4802,  2726, -4802, -4802, -4802, -4802, -4802, -4802, -4802,  1350,
   -4802, -4802,  1912,  2223, 34972, -4802,  1590,  3983, -4802, 55952,
   -4802,  2126, -4802, 57916, -4802, -4802,  3836, 55952,  2730, -4802
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2365,     0,     2,     1,  2795,  2799,  2803,  2804,  2721,  2805,
    2806,  2771,  2772,  2773,  2774,  2775,  2776,  2777,  2778,  2779,
    2780,  2781,  2782,  2784,  2783,  2785,  2786,  2787,  2788,  2789,
    2790,  2791,  2792,  2794,  2793,  2743,  2372,  2740,  2737,  2738,
    2739,  2744,  2742,  2735,  2736,  1962,  2808,  2796,  2809,  2797,
    2798,  2800,  2801,  2770,  2802,  2810,  2811,  2812,  2807,  2815,
    2766,  2767,  2765,  2768,  2769,  2813,  2814,  2757,  2758,  2759,
    2760,  2816,  2373,  2374,  2762,  2366,  2370,  2432,  2503,  2763,
    2764,  2761,  2371,  2756,  2503,     0,  2624,  2625,  2626,     0,
    2627,  2628,  2629,  2555,  2517,  2630,     0,     0,  2631,  2632,
    2633,  2634,  2635,  2636,  2637,  2638,     0,  2639,  2640,  2641,
    2642,  2502,  2643,  2644,  2645,  2646,  2647,  2479,  2485,  2608,
       0,  2459,  2460,  2456,  2458,  2457,  2461,  2444,  1220,   563,
    1308,  1307,     0,  2268,  1220,  2224,  2225,  2269,  2226,  2227,
    2228,   261,     0,  1310,  2229,  2270,     0,  1220,  2271,   388,
     982,  2272,  2273,  2387,     0,  2230,  2231,     0,     0,     0,
     563,  1220,     0,     0,  2232,  1422,  2233,     0,  2234,  2274,
    2275,     0,  2235,  2276,  2277,  2236,  2237,  2238,  2278,  2279,
    2280,  2239,  2281,  2282,     0,     0,  1436,     0,  2240,  2283,
    2241,  2242,     0,  2284,  2243,  2244,  2245,  2285,  2286,  2246,
    2247,  2248,     0,  2249,     0,     0,     0,     0,     0,     0,
    2287,  1220,  2250,     0,     0,  1443,     0,  2251,     0,  2288,
    2252,     0,  2253,     0,  2254,  2255,  2256,  2257,  1436,  2604,
    2480,     0,  1312,     0,  2258,  2289,     0,  2259,  2260,  2261,
    2262,  2263,  2264,  2265,  2266,  2267,     0,     0,    59,    60,
      24,    23,    29,    28,    82,    83,    47,    15,    73,    53,
     116,   115,   117,    35,    31,    67,    20,    22,    32,    36,
      55,    48,    94,    54,    18,    52,    77,    56,    80,    42,
       9,    10,    43,    71,    11,    44,    72,    12,    45,    13,
      61,    84,    27,    57,    81,    58,     3,    38,    69,    65,
       8,    49,    50,    51,    74,    75,    76,    99,    79,   111,
      34,   108,    88,    89,   105,    90,   106,     6,    91,    46,
      14,   102,   101,   103,    68,    39,    70,   100,    21,   104,
      16,    17,   107,    78,    97,    93,   112,   110,   118,    95,
      62,     4,     5,    85,    19,    41,     7,    26,    25,    40,
      33,   114,    30,  1310,    87,    98,    86,    92,    66,    96,
     113,    64,   109,  1409,  1396,  1445,  1408,  1421,     0,  1411,
    2700,  2701,    37,  1422,   120,   121,   126,  2369,  2421,  2422,
    2423,  2503,  2454,  2455,  2448,  2464,  2474,  2463,  2467,  2475,
    2462,  2481,     0,   123,   125,   127,   130,   124,   119,   122,
     129,   134,   128,   133,   131,   132,   135,   136,   137,  2702,
    1636,  2699,    63,  2439,  2438,     0,  2503,     0,  2732,  1974,
    1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,
    1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,
    2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,
    2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,
    2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,
    2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,
    2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,
    2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,
    2075,  2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,  2084,
    2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,  2103,  2104,
    2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,
    2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,  2124,
    2125,  2128,  2126,  2127,  2129,  2130,  2131,  2132,  2133,  2134,
    2135,  2136,  2137,  2138,  2139,  2140,  2141,  2142,  2143,  2144,
    2145,  2146,  2147,  2148,  2149,  2150,  2151,  2152,  2153,  2154,
    2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,  2163,  2164,
    2165,  2166,  2167,  2168,  2169,  2170,  2171,  2172,  2173,  2174,
    2175,  2176,  2177,  2178,  2179,  2180,  2181,  2182,  2183,  2184,
    2185,  2186,  2187,  2188,  2189,  2190,  2387,  2191,  2192,  2193,
    2194,  2195,  2196,  2197,  2198,  2199,  2200,  2201,  2202,  2203,
    2204,  2205,  2206,  2207,  2208,  2209,  2210,  2211,  2212,  2213,
    2214,  2215,  2216,  2217,  2218,  2219,  2220,  2221,  2222,  2223,
    2405,  1963,  1971,  1972,  1973,  2380,  2401,  2407,  2728,  2406,
    1970,  2554,     0,     0,  2648,  2649,  2650,  2651,  2652,  2653,
    2703,  2704,  2705,  2706,  2707,  2709,  2708,  2516,  2675,  2712,
    2515,  2713,  2519,  2714,  2715,  2716,  2717,  2676,  2718,  2518,
    2710,  2672,  2520,  2513,  2514,  2673,  2622,  2623,  1940,  2674,
    2671,  2711,  2408,  2670,  2524,  2523,  1386,  2727,  1939,  1387,
       0,  2526,  2654,  2655,  2656,  2657,  2659,  2658,  2660,  2290,
    2291,  2292,  2293,  2294,  2295,  2296,  2297,  2298,  2299,  2300,
    2301,  2685,  2302,  2303,  2304,  2698,  2305,  2306,  2686,  2307,
    2308,  2309,  2310,  2311,  2312,  2313,  2314,  2315,  2316,  2317,
    2318,  2319,  2320,  2321,  2322,  2323,  2324,  2325,  2326,  2327,
    2328,  2329,  2330,  2687,  2688,  2331,  2332,  2333,  2334,  2335,
    2336,  2337,  2338,  2339,  2340,  2341,  2342,  2343,  2344,  2345,
    2346,  2347,  2348,  2349,  2350,  2351,  2352,  2353,  2354,  2689,
    2355,  2356,  2690,  2357,  2358,  2359,  2691,  2360,  2361,  2362,
    2363,  2364,  2695,  2696,  2697,  2684,  2477,  2661,  2683,  2694,
    2692,  2693,  2487,  2483,  2491,  2486,     0,     0,     0,     0,
    2503,  1219,  1218,  1204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   562,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2377,     0,  1230,   359,   358,  1309,
    1290,   563,     0,  1207,   387,     0,     0,     0,     0,     0,
       0,     0,     0,   752,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,     0,     0,   411,   410,     0,
       0,     0,   954,   416,     0,     0,     0,     0,     0,   551,
    2386,  2381,  2391,     0,  2384,  2385,  2670,     0,  2819,  2126,
    2417,  2418,  2817,  2176,  1388,   262,   265,   266,   263,   264,
       0,  1061,  1062,  1064,     0,     0,  1074,   787,   788,     0,
     786,     0,   790,     0,     0,     0,   782,     0,     0,     0,
       0,     0,   789,   779,     0,   778,     0,     0,     0,   785,
       0,   780,     0,     0,  1208,     0,  2469,  2470,  2064,  1349,
     417,     0,     0,  1422,     0,  1327,  1328,  1310,  1317,  1329,
    1322,  1324,  1323,  1325,  1321,  1326,  1975,   893,  1989,   893,
    2054,   890,   891,   893,   893,   893,  2143,     0,     0,   865,
       0,   876,  1966,   893,  1967,  2728,   898,   472,   472,   472,
       0,   897,   902,   472,  1201,  1239,  1944,  1435,     0,  1989,
    2054,   866,  1200,  2191,  1341,     0,     0,     0,  1078,     0,
    1079,     0,  2158,  1212,   246,  2668,  2167,  2254,  2191,  2669,
     245,   240,   241,  2663,  2664,  2666,   214,  2667,  2665,  2662,
    1979,     0,     0,   897,     0,  1209,  1210,   849,  1442,  1440,
    1926,     0,     0,  1997,     0,  2009,  2090,   237,  2154,  2159,
    2167,  2254,  2191,  2221,   193,   203,   198,     0,   255,  2167,
    2254,  2191,     0,  1230,     0,  1412,  1528,  1935,     0,     0,
    2478,  1203,  1202,  1311,     0,  1314,     0,  1490,  2139,  1416,
    1418,  1316,  1409,     0,     0,  2368,  1305,  1439,  1439,     0,
    1439,     0,  1401,  1409,  1404,  1408,     0,     0,     0,     0,
    1220,     0,  2446,  2474,  2453,  2509,  2450,     0,     0,  2499,
    2495,  2492,  2500,  2501,  2494,  2482,  1625,  1626,  1627,  1624,
    1637,  1623,     0,  2427,  1628,  2466,  2433,     0,  2441,  2440,
    2745,  2746,  2556,  2379,  2398,     0,     0,     0,     0,     0,
       0,     0,  2525,  2527,  2529,  2489,  2488,  2484,     0,     0,
       0,     0,  2614,  2615,  2613,     0,  2610,  2612,     0,  2509,
       0,  2679,  2673,  2682,     0,  1945,  2674,  2671,  2670,     0,
     797,     0,   141,   942,     0,     0,     0,     0,  1939,     0,
       0,     0,     0,     0,     0,  2063,     0,     0,     0,  1838,
    2001,  2049,  1848,  1846,  1847,  1840,  1841,  1842,  1843,  1844,
    1845,     0,  1059,  1839,     0,   163,   141,     0,     0,  2063,
       0,     0,     0,     0,     0,  2063,     0,     0,     0,     0,
       0,  2093,   141,  2063,     0,     0,     0,  1224,     0,     0,
       0,  1226,  1229,  1205,  1293,     0,  1935,     0,     0,   828,
     818,     0,   829,   819,   824,     0,   831,     0,     0,   821,
       0,     0,     0,   832,     0,   820,   822,   834,   823,   830,
       0,     0,   825,   826,     0,     0,  1216,   472,   365,     0,
       0,     0,     0,     0,   141,  1280,     0,  2063,   141,     0,
       0,   415,   414,   141,   413,   412,  2001,  2049,     0,   981,
     141,  2063,     0,   186,   633,   566,     0,     0,   711,  2093,
     141,     0,     0,     0,     0,     0,     0,   957,     0,     0,
     550,   563,     0,  2390,  2396,     0,  2388,  2557,  2820,  2818,
    2512,     0,  1065,   238,   239,  1063,  2063,     0,   333,     0,
       0,  2063,  1267,   784,     0,   783,  2063,     0,  2063,  1964,
     177,     0,   781,  2001,  2049,  2063,     0,     0,  2063,   169,
    2063,     0,  2063,   333,  2063,   567,     0,  2063,     0,  2063,
    2093,   171,     0,  2063,   333,   795,     0,     0,  2750,  2754,
       0,  2752,  2747,  2468,  2522,  2521,  2420,     0,  2831,     0,
    1388,  1319,  1334,     0,  1330,  1337,  1333,  1422,   893,   892,
       0,   893,     0,  2840,   893,     0,   893,     0,  2840,   893,
       0,     0,     0,   893,  1968,  1969,     0,     0,  2839,  2837,
    2838,   867,   877,     0,   899,     0,     0,   906,   905,   904,
       0,     0,     0,   907,  1532,  1364,     0,   874,     0,   872,
       0,  1198,  1215,     0,     0,     0,     0,   957,  1081,  1081,
    1081,  1211,   244,   242,     0,     0,     0,     0,     0,     0,
    1217,     0,     0,     0,     0,  2734,  1951,  1849,  2733,     0,
    2225,  2226,  2227,  1907,     0,  2675,  2228,  2229,  2270,  1757,
    1744,  1753,  1758,  1745,  1747,  1754,  2230,  2231,  2033,  2232,
    2233,  1958,  2234,  2235,  1580,  2237,  2238,  2239,  1749,  1751,
    2240,  2241,     0,  1959,  2243,  2244,  2112,  2246,  2247,  2249,
    2250,  1755,  2252,  2253,  2254,  2255,  2256,  2257,  1957,     0,
    1756,  2258,  2260,  2261,  2262,  2263,  2264,  2265,  2266,  2267,
       0,     0,  1932,     0,  1726,     0,  1572,  1573,  1595,  1596,
    1574,  1601,  1602,  1614,  1575,     0,  1931,  1639,  1806,  1725,
    1740,  1731,     0,  1724,  1720,  1425,  1925,  1927,     0,  1721,
    1947,  1908,  1961,  1960,  2728,  1916,  1950,  1948,  1949,     0,
       0,     0,   206,     0,     0,  2603,   257,     0,   258,  1933,
    2167,   194,   236,   208,   235,   209,   207,     0,  1999,   195,
       0,     0,   196,     0,     0,     0,     0,     0,     0,     0,
     251,  1206,     0,  1530,  1529,     0,     0,  1914,  1936,   804,
       0,  1303,  1304,  1302,     0,  1299,  1301,  1313,  1310,  1921,
    1920,  1922,     0,  1417,     0,     0,     0,  1399,  1398,  1316,
    1437,  1438,     0,     0,     0,     0,     0,     0,     0,     0,
    1480,  1453,  1454,  1456,  1477,  1481,  1489,     0,  1405,     0,
       0,  1534,     0,  1491,  2367,  2509,  2510,     0,  2504,     0,
    2503,  2503,  2497,  2496,  2493,     0,     0,     0,     0,     0,
       0,     0,  2424,   545,  2426,   543,     0,     0,  2400,     0,
    2404,  2402,     0,  2549,  2552,     0,  2550,  2551,  2553,     0,
    2558,  2559,     0,     0,     0,  2741,     0,     0,  2540,  2528,
    2535,  2537,  2539,  2538,  2547,  2543,  2546,  2548,  2490,  2503,
    2621,     0,  2616,  2619,     0,  2611,     0,     0,     0,  1946,
       0,     0,     0,     0,   798,     0,     0,     0,     0,     0,
       0,   140,  1265,   248,  1263,     0,     0,     0,     0,     0,
       0,     0,  1272,     0,     0,   175,   176,   578,   563,     0,
    2063,     0,     0,     0,     0,  1021,  1028,     0,     0,     0,
       0,     0,     0,     0,  1022,  1020,  1023,   250,  1032,  1045,
    1048,     0,   932,     0,     0,     0,     0,     0,  1130,     0,
       0,  1130,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   271,   283,   328,     0,     0,  2063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,   530,   542,     0,     0,
       0,     0,     0,   539,     0,   141,   275,   523,   527,     0,
       0,     0,   642,   641,  1270,  1269,     0,     0,     0,  1130,
       0,   267,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   351,   352,     0,
       0,     0,   145,   168,     0,     0,     0,   277,     0,  2434,
       0,  1225,  1222,  1223,     0,  1228,     0,  1289,     0,     0,
       0,     0,   836,     0,   833,     0,     0,   827,  2001,  2049,
       0,     0,     0,     0,     0,     0,   390,   364,     0,     0,
     708,     0,     0,  1583,  1612,  1590,  1612,  1612,  1579,  1579,
    1592,  1581,  1619,     0,  1612,  1579,  1584,     0,  1582,  1622,
    1622,  1607,     0,  1564,  1565,  1566,  1567,  1593,  1594,  1568,
    1599,  1600,  1569,  1636,  2680,  1579,  2681,  2678,  2677,     0,
       0,   719,     0,  1242,  1279,     0,     0,     0,   572,     0,
    2063,     0,   143,   753,     0,   709,   416,     0,   143,     0,
       0,   180,     0,   637,     0,     0,     0,     0,     0,     0,
     657,   656,     0,     0,     0,   710,     0,   143,     0,   526,
    2063,     0,   472,   472,     0,     0,   956,   959,     0,     0,
       0,  2394,  2389,  2392,     0,  2382,  2396,  1391,  1393,  1392,
       0,  1390,     0,   333,   331,   332,   706,  1073,     0,     0,
       0,     0,   333,     0,     0,  2063,   333,  2063,     0,  2063,
       0,     0,   333,   333,     0,     0,     0,     0,   638,     0,
     794,   792,   791,   793,     0,     0,     0,     0,     0,  2063,
     333,     0,     0,   775,  2748,     0,     0,  2751,     0,  2471,
    1859,     0,  2834,  1346,  2835,     0,     0,  1422,     0,   225,
     226,   224,  1335,   227,  1336,  1332,  1318,     0,   885,     0,
    2840,  2841,   870,     0,   880,     0,  2840,   868,     0,   881,
     878,   879,     0,     0,     0,  2836,  2719,  2725,   884,     0,
       0,   473,   475,     0,     0,  2019,  2032,     0,  2055,  2081,
    2082,  2159,  2163,     0,  2186,  2195,     0,   908,   937,   903,
       0,     0,  1374,   875,   873,  1199,  1339,  1865,     0,  1422,
       0,     0,  1080,  1077,  1076,  1075,   243,   215,     0,     0,
       0,   939,  2158,  1214,   848,   563,     0,     0,  1729,  1730,
    1611,  1598,  1906,     0,     0,  1606,  1605,     0,     0,     0,
       0,     0,  1588,  1587,  1586,  1728,  1873,     0,  1585,     0,
       0,     0,     0,  1612,  1612,  1610,  1659,     0,  1589,     0,
       0,  1886,     0,  1892,     0,     0,     0,  1618,     0,  1616,
       0,     0,  1695,     0,     0,     0,     0,     0,     0,     0,
       0,  1643,  1644,  2676,  1726,  1859,     0,  1727,  1954,     0,
       0,  1604,     0,  1636,  1849,     0,     0,     0,     0,  1919,
       0,  1857,     0,     0,  1673,  1855,     0,  1675,     0,     0,
       0,  1848,  1846,  1847,  1840,  1841,  1842,  1843,  1844,  1845,
    1853,  1656,     0,  1930,     0,  1808,     0,  1655,     0,  1493,
    1424,     0,     0,  1952,  1909,     0,  2726,  2729,  1722,  2600,
    2599,  2598,  2597,  2568,     0,  2562,  2563,     0,  2601,  2602,
     259,   260,   256,     0,     0,   211,   210,     0,   233,   234,
     205,   232,     0,   228,   229,   213,  1797,  1796,   212,   204,
     201,   199,   216,   218,   219,   202,   200,   254,   252,     0,
       0,     0,  1911,  1910,  1942,  1915,     0,     0,   333,  2503,
    1297,     0,  1294,  1924,     0,  1419,     0,  1937,     0,  1306,
    1415,  1414,  1446,  1447,   974,  1413,  1471,  1472,  1467,     0,
       0,     0,  1486,  1484,  1463,  1457,  1462,  1460,     0,  1464,
    1639,  1479,  1403,  1451,  1452,  1455,  1402,     0,  1482,     0,
    1374,  1480,  1456,  1361,     0,     0,  1535,     0,     0,  2511,
    2509,  2449,  1564,  2503,  2442,  2503,  2498,  2430,  1630,  1631,
    1632,  1633,  1634,  1635,  2431,     0,  2428,  1629,  2429,   544,
       0,     0,     0,  2397,     0,  2378,  2403,  2534,  2643,  2566,
       0,  2567,     0,     0,  2531,     0,  2541,  2544,  2542,  2545,
       0,  1564,  2722,  2617,  2722,  1564,   996,   998,     0,   997,
       0,  1000,     0,  1009,     0,     0,   995,  1014,     0,  1003,
    1001,     0,     0,     0,     0,     0,     0,   799,     0,     0,
       0,     0,     0,     0,  2186,   247,  1261,     0,     0,     0,
       0,   941,   940,     0,     0,   961,     0,     0,     0,  1275,
     461,     0,   330,     0,     0,     0,     0,     0,     0,     0,
       0,   704,   701,     0,     0,   700,     0,   576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   612,     0,  1130,     0,
     645,     0,  1030,     0,  1029,     0,     0,     0,  1031,  1026,
    1027,  2159,  2167,  2191,   249,  1047,     0,  1046,  1044,   984,
       0,   985,     0,     0,     0,     0,     0,  2042,   285,   298,
       0,  1129,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   319,     0,   322,   321,     0,     0,     0,
       0,     0,   326,     0,     0,     0,   325,     0,     0,     0,
       0,     0,  1130,     0,   279,     0,     0,     0,     0,     0,
       0,  1060,     0,   166,     0,   162,   165,     0,     0,     0,
       0,   529,   541,     0,   533,   534,   531,   535,   536,     0,
       0,     0,     0,     0,     0,   528,     0,     0,   635,   634,
     640,     0,     0,     0,     0,     0,     0,     0,     0,  1083,
    1082,     0,     0,     0,     0,     0,     0,   743,     0,     0,
       0,     0,     0,     0,     0,   648,   649,     0,   650,     0,
     167,     0,     0,     0,     0,     0,     0,     0,   223,  1221,
    1227,  1292,  1943,  1291,     0,     0,     0,   835,     0,     0,
       0,     0,     0,     0,     0,   837,   838,   839,   840,     0,
       0,     0,     0,     0,   367,   368,   141,   366,     0,   732,
    2677,   707,     0,  1564,     0,  1560,  1556,  1625,  1624,  1623,
       0,  1570,  1579,  1576,   720,     0,   722,   725,     0,  1240,
     434,     0,     0,   569,   612,     0,   419,   173,     0,     0,
       0,     0,   139,   184,   186,   417,     0,   185,   187,   189,
     190,   191,   188,   192,   632,   636,     0,   565,     0,     0,
       0,     0,     0,   658,   662,   661,   665,   663,     0,   659,
       0,     0,  1552,     0,   161,     0,   522,   525,     0,  2375,
       0,   419,   503,   344,     0,   472,     0,     0,   958,     0,
       0,     0,     0,     0,  2395,     0,     0,     0,     0,  1389,
       0,  1051,     0,  1268,  2063,   333,     0,  1049,   178,  1965,
       0,   776,     0,     0,     0,     0,     0,  1053,   772,   170,
       0,   333,   333,   568,     0,   333,   172,     0,     0,     0,
     560,   333,   796,  2749,  2755,  2753,  1348,     0,  2832,  2833,
     472,  1393,  1320,  1331,   882,   889,   871,   888,   887,   869,
     886,   883,  2533,     0,     0,  2724,     0,   900,     0,   471,
       0,     0,     0,   914,   915,     0,     0,   913,   930,   916,
       0,   918,   910,   909,   919,   920,     0,     0,   939,     0,
    1371,     0,  1369,     0,  1533,  1373,  1362,  1340,     0,  1338,
    1343,  1345,  1344,  1342,     0,   516,     0,     0,   897,     0,
       0,   333,  1213,     0,   850,   851,   857,     0,     0,     0,
       0,     0,   858,   854,   855,   856,   859,   860,   861,     0,
       0,     0,  1869,     0,  1870,     0,     0,     0,  1905,  1901,
       0,     0,     0,     0,     0,     0,  1877,  1878,  1879,  1876,
    1880,  1875,     0,     0,  1881,  1874,     0,     0,     0,     0,
       0,  1609,  1608,     0,     0,     0,     0,     0,     0,     0,
    1698,  1731,     0,     0,  1833,     0,  1859,  1891,     0,     0,
    1620,     0,     0,     0,     0,     0,     0,     0,  1859,  1897,
       0,     0,     0,     0,  1795,     0,  1792,     0,     0,     0,
       0,  1916,     0,     0,     0,     0,  1955,  1640,  1657,  1929,
       0,  1918,     0,     0,  1641,  1664,     0,  1898,  1691,     0,
    1696,  1679,     0,  1672,     0,  1677,  1681,  1660,  1919,  1858,
       0,  1856,     0,     0,  1658,     0,  1653,  1651,  1652,  1645,
    1646,  1647,  1648,  1649,  1650,  1654,  1837,  1835,  1836,     0,
       0,     0,  1816,     0,     0,  1676,  2057,  2090,     0,  1436,
    1436,  1436,  1423,  1434,     0,  1547,  1928,     0,     0,     0,
       0,  1732,     0,  1863,  1445,  1861,  1945,  2731,  2730,  1917,
       0,     0,     0,  1934,     0,     0,  1636,     0,   253,  1531,
    1912,     0,   802,   803,   801,  1564,  1316,  1300,  1296,  1295,
    1923,  1315,     0,  1422,     0,   972,   973,     0,   977,     0,
       0,  1465,  1487,     0,  1478,     0,  1469,  1470,  1461,  1488,
    1483,  1407,  1406,     0,  1550,     0,     0,  1358,  1351,  1536,
       0,  1493,  1376,  1378,  1379,     0,  1916,  2447,  2505,  2452,
    2473,  2443,  2476,  1638,  2425,  2465,     0,  2399,  2569,  2570,
       0,  2560,  2561,  2530,  2536,  2607,     0,  2723,     0,     0,
     999,     0,  1579,  1010,     0,   994,     0,   993,  1579,     0,
    1011,     0,  1579,     0,     0,     0,  1158,  1085,  1134,   800,
    1159,  1086,  1135,  1160,  1087,  1262,     0,  1264,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   683,  2063,   333,  1273,  1161,     0,  1088,   329,
    1274,  1136,  1278,   703,   702,     0,     0,  1137,     0,   577,
       0,     0,   582,   583,   584,     0,     0,     0,   585,     0,
    2001,  2049,     0,   590,   597,   602,   592,     0,   603,   598,
       0,     0,     0,     0,     0,     0,   609,   611,     0,     0,
       0,     0,     0,     0,  1024,  1025,  1162,  1091,     0,  1138,
     983,     0,  1092,   174,     0,     0,   272,   286,   618,   683,
    1132,   305,   318,   313,   314,   312,  2063,   333,  2063,   333,
       0,     0,     0,     0,   315,   310,   311,   307,   320,  1978,
    2034,  2168,     0,   622,   624,     0,   629,   323,  1106,   340,
     339,   338,     0,   327,     0,   345,   348,   324,   303,   306,
     304,   300,   284,     0,     0,     0,     0,     0,     0,     0,
    1941,     0,     0,  1055,     0,     0,     0,   164,  1120,     0,
       0,   150,     0,     0,     0,     0,   144,   154,     0,  1168,
    1096,     0,     0,   276,   524,   532,   537,  1100,   540,  1148,
     538,  1174,  1097,     0,  1130,     0,   268,     0,  1098,     0,
    1142,  1170,  1122,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1281,     0,     0,     0,     0,     0,   333,     0,
       0,     0,  1132,  2063,   333,  1169,     0,  1127,  1156,     0,
     353,     0,  1121,     0,     0,   278,  1102,  1150,     0,     0,
     221,   220,   222,     0,     0,     0,     0,     0,     0,     0,
       0,   842,   811,   841,     0,     0,     0,   805,   389,   362,
     363,   365,   372,   731,     0,     0,     0,  1561,  1557,     0,
       0,     0,     0,     0,     0,  1577,   721,     0,     0,     0,
       0,  1260,  1260,  1260,  1260,  1260,  1260,  1260,  1241,  1271,
       0,   141,     0,     0,     0,   571,   611,   618,     0,     0,
       0,   418,   422,   426,   427,   428,     0,     0,     0,     0,
     155,   142,     0,   761,     0,   472,     0,   186,   179,     0,
       0,     0,   344,   718,   716,   715,   717,     0,     0,     0,
     736,   714,     0,  1551,  1553,     0,     0,     0,     0,     0,
     421,     0,   475,     0,     0,   507,     0,     0,     0,   344,
       0,     0,   988,     0,  1006,   989,     0,     0,     0,  1035,
    1040,  1036,  1016,     0,   548,  2393,  2387,  1394,  1395,     0,
     333,     0,     0,   613,   333,   333,     0,   333,     0,   333,
     333,     0,  1196,   639,     0,   691,     0,     0,   333,   774,
    1860,     0,  2532,  2720,   901,   474,     0,     0,     0,     0,
     912,     0,   546,   917,     0,   929,   924,   926,     0,   933,
    1372,  1365,  1367,  1366,     0,     0,  1363,  1866,   773,     0,
     521,     0,     0,   333,     0,   934,     0,   852,   853,     0,
       0,   862,     0,     0,  1441,  1867,  1868,     0,     0,     0,
       0,  1902,     0,     0,  1770,     0,  1746,  1748,  1578,  1760,
       0,  1591,  1771,  1772,  1750,  1752,     0,  1850,     0,     0,
    1761,  1700,  1701,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1713,  1712,  1762,  1832,
       0,     0,  1889,  1890,  1763,  1621,  1622,  1622,     0,     0,
    1896,     0,     0,     0,  1768,  1773,     0,     0,     0,     0,
    1779,     0,  1800,     0,     0,     0,  1723,  1860,  1613,  1614,
       0,     0,     0,     0,     0,     0,     0,     0,  1697,  1680,
    1674,     0,  1678,  1682,     0,     0,     0,     0,  1666,  1692,
    1662,     0,     0,  1668,     0,  1693,     0,     0,     0,  1739,
    1436,  1436,  1436,  1436,  1433,     0,     0,     0,     0,  2156,
       0,  1514,  1492,  1494,  1501,  1514,  1519,  1741,  1545,  1742,
       0,  1935,     0,  1474,  1445,  1445,  1445,  1738,     0,     0,
       0,  1444,  2582,  2584,  2585,  2586,  2587,  2588,  2590,  2591,
    2593,  2594,  2595,  2583,  2589,  2592,  2596,  2573,  2574,     0,
    2564,  2565,   197,     0,   230,   217,     0,  2607,  1298,  1938,
       0,  1448,     0,  1851,   977,   975,   976,  1450,     0,     0,
    1485,  1458,  1360,     0,  1358,  1353,     0,  1354,  1916,     0,
    1350,  1383,     0,     0,  1550,     0,  1382,     0,  2507,  2435,
       0,     0,  2606,  2609,  2620,  2618,  2445,     0,  1579,   991,
     992,     0,  1015,     0,  1157,  1084,  1133,  1260,   944,   945,
       0,   943,     0,     0,     0,   460,   960,     0,     0,     0,
     683,     0,     0,   464,     0,  1276,     0,  1175,  1119,   579,
     580,     0,   591,     0,   600,   599,     0,     0,   587,     0,
       0,     0,     0,   586,   605,   552,   606,   608,     0,     0,
     607,   610,   615,  1130,     0,   646,  1108,     0,  1154,  1018,
       0,   986,     0,     0,     0,     0,   434,   299,     0,     0,
       0,   287,   297,     0,     0,   302,     0,   295,   316,   308,
     317,   309,   626,   627,   625,   621,     0,   628,   630,     0,
     342,     0,     0,     0,  1164,     0,  1130,     0,   280,  1104,
       0,  1152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,  1139,     0,     0,   147,   146,     0,
     153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   354,   335,     0,   739,
       0,     0,     0,   356,     0,     0,     0,     0,  1163,  1093,
     806,     0,     0,   807,   815,     0,     0,   808,     0,     0,
     817,     0,     0,   361,   369,   733,     0,  2112,  1840,  1841,
     729,   734,   726,   728,   727,   730,   683,     0,     0,     0,
    1562,     0,  2821,  2829,  2828,     0,  1636,   723,   724,     0,
    1260,  1259,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   446,     0,     0,   440,     0,     0,  1040,
     433,   436,   437,     0,     0,   572,   575,   573,   574,   604,
       0,   453,     0,     0,   157,     0,     0,   158,   156,     0,
       0,   344,     0,   182,   417,     0,     0,   564,   664,   667,
     660,     0,   735,   737,   712,     0,   618,     0,     0,  1349,
     516,     0,   503,   499,   501,   500,   502,     0,   509,   343,
       0,   516,   509,     0,   961,   987,     0,     0,     0,  1033,
    1037,  1034,     0,     0,  1002,     0,  1017,   980,  1191,  1192,
    1189,  1190,     0,     0,  2410,  1385,  2419,  1052,     0,   333,
    1050,   777,     0,   768,     0,   770,  1054,   333,   333,   651,
       0,   561,     0,     0,     0,     0,   911,   931,     0,   927,
       0,     0,   894,   936,  1370,  1368,   514,     0,   939,     0,
     895,   938,     0,     0,     0,     0,     0,  1871,  1597,     0,
    1904,  1900,     0,  1743,  1872,     0,  1884,  1883,  1699,  1885,
       0,  1718,     0,     0,  1710,  1708,  1709,  1702,  1703,  1704,
    1705,  1706,  1707,  1711,  1894,  1893,  1887,  1888,  1617,  1615,
       0,  1765,  1766,  1767,  1895,  1774,     0,  1992,  1801,  1778,
    1794,  1793,     0,     0,     0,  1781,     0,     0,  1790,     0,
    1834,  1603,  1636,  1642,     0,     0,  1665,  1899,  1683,     0,
       0,     0,  1661,     0,     0,     0,     0,  1670,  1850,     0,
       0,     0,     0,  1819,  1814,  1815,     0,     0,     0,     0,
    1427,  1426,  1432,  1514,  1519,     0,  1409,     0,  1501,     0,
    1513,  1499,  1512,     0,     0,  1525,  1523,     0,  1525,     0,
    1525,     0,  1496,     0,  1515,  1497,  1512,  1544,  1537,     0,
    1936,  1546,     0,  1476,     0,     0,     0,     0,  1864,     0,
    1862,  1733,     0,     0,     0,  1913,  2605,  1420,     0,  1449,
    1466,  1459,     0,  1548,  1359,     0,     0,  1356,     0,     0,
       0,  1377,  1358,  1380,  2451,     0,  2506,  2571,  2572,  1012,
       0,     0,  1004,     0,   950,   951,   949,   952,     0,     0,
       0,   683,     0,     0,   480,     0,   968,   968,     0,     0,
     466,   512,  1040,   686,     0,     0,     0,   684,   333,  1089,
       0,   601,     0,     0,   596,   594,   593,   595,   553,  1173,
    1090,     0,     0,     0,     0,  1019,     0,     0,  1107,     0,
     431,     0,   292,  1131,     0,     0,     0,   291,     0,   333,
     333,   623,   341,   346,   347,   350,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   762,   745,
       0,     0,   763,   764,     0,     0,     0,  1057,  1058,  1056,
     151,   148,   149,   152,  1117,  1101,  1149,     0,     0,  1099,
       0,  1143,  1114,  1110,     0,     0,     0,     0,     0,  1172,
    1126,  1147,  1171,  1124,  1145,  1123,  1144,  1125,  1146,  1118,
       0,  1555,   742,     0,     0,     0,   333,   333,   653,  1103,
    1151,     0,   809,     0,     0,   810,   812,   392,     0,   395,
     402,   373,   378,  1280,     0,  1280,     0,   375,   379,  1280,
     374,  1280,   371,   705,     0,     0,     0,  1558,     0,  2503,
       0,     0,     0,     0,     0,  1563,  1571,   682,     0,  1251,
    1250,  1249,  1253,  1252,  1255,  1254,  1246,  1245,  1258,  1257,
    1244,  1243,  1248,  1247,     0,   438,     0,   444,   448,   449,
     447,   439,  1040,   472,   511,     0,     0,   695,     0,   570,
     419,   450,     0,   423,   160,   159,     0,     0,     0,   186,
       0,     0,   669,   673,   713,     0,  1554,   647,   344,     0,
     419,   516,  2376,     0,   424,   429,   430,     0,   507,     0,
     503,     0,     0,   513,  1238,   517,   518,     0,     0,   990,
    1007,  1008,     0,     0,  1040,  1039,     0,   555,     0,  2383,
     333,   614,   333,   333,  1197,   692,     0,   923,   922,   921,
     547,     0,   925,   515,   333,     0,     0,     0,     0,     0,
     864,   843,   863,  1903,  1759,  1769,  1882,     0,     0,  1719,
       0,     0,  1764,  2259,     0,     0,     0,     0,  1798,  1799,
    1780,     0,  2103,  1785,     0,     0,     0,  1956,  1689,  1687,
    1684,     0,  1685,     0,     0,  1667,  1663,     0,  1669,  1694,
    1805,     0,  1821,  1818,  1431,  1430,  1429,  1428,  1500,  1498,
       0,  1503,  1510,     0,  1495,     0,  1524,  1520,     0,  1521,
       0,     0,  1522,     0,     0,  1510,     0,  1445,     0,     0,
    1810,  1736,  1737,  1734,  1445,  1953,  2575,     0,  2578,  2576,
    2577,  2581,  1636,     0,     0,  1352,  1355,  1357,     0,  1384,
    1375,  2508,  1005,  1013,  1266,     0,     0,     0,   462,     0,
    1040,     0,     0,     0,   971,   971,     0,  1040,   511,   688,
     687,   690,   685,   689,  1277,     0,   588,   589,  1109,     0,
    1155,  1115,     0,  1374,     0,   619,   288,   289,   290,   293,
     335,   301,   294,     0,     0,     0,  1105,     0,  1153,  1112,
    1166,  1094,  1140,     0,     0,   751,     0,     0,     0,     0,
    1167,  1095,  1141,     0,  1374,     0,     0,     0,     0,  1286,
       0,   334,   741,   740,   335,   355,  1128,     0,   813,   814,
     393,   141,     0,   370,     0,   400,     0,   398,   397,   399,
       0,   386,     0,     0,     0,     0,     0,     0,  1559,     0,
    1071,  1071,  2822,     0,  2823,  2824,  2825,  2826,  2827,     0,
     683,  1256,     0,     0,   435,   511,   479,     0,   441,     0,
       0,     0,     0,     0,     0,     0,   618,     0,     0,     0,
     181,   419,   618,   668,     0,     0,     0,   738,     0,   421,
       0,  1347,   420,     0,     0,   509,     0,   507,     0,   504,
       0,   508,     0,  1231,     0,     0,  1038,     0,  1042,     0,
    1001,   978,  1547,     0,   559,  2409,  2413,  1072,   769,   771,
     652,   928,   935,   333,   844,   845,   846,   847,  1714,     0,
       0,     0,     0,  1775,     0,  1776,  1803,  1802,  1782,  1786,
       0,  1783,  1784,  1686,  1690,  1688,  1671,  1807,     0,  1445,
    1540,     0,  1543,  1502,     0,     0,  1504,     0,     0,  1506,
    1508,     0,     0,     0,     0,     0,  1939,     0,  1473,  1475,
       0,  1410,     0,  2580,  2579,   231,  1852,  1549,  1381,   929,
       0,   333,   968,   511,   481,  2112,   482,   967,     0,   969,
     974,   974,     0,   511,   683,   581,     0,     0,   273,   617,
       0,   337,   349,     0,  1374,     0,     0,     0,   758,   746,
       0,     0,   765,     0,   269,  1111,     0,     0,     0,     0,
       0,   333,   816,   372,     0,   396,   405,     0,   403,   376,
     381,     0,   385,   383,   382,   377,   380,  1071,     0,  1068,
    1067,  2830,   681,     0,   470,   442,     0,   490,     0,     0,
     696,     0,     0,     0,   459,   458,   455,   454,   456,   457,
     452,   451,   643,   755,   344,  1238,   631,   670,   671,   666,
       0,     0,     0,   503,   499,   425,   434,   408,     0,   509,
     505,   506,     0,     0,     0,  1288,     0,   962,  1041,     0,
       0,     0,   554,     0,     0,   558,   549,     0,  2411,   896,
    1715,     0,  1716,     0,     0,     0,  1788,  1787,     0,  1824,
    1545,     0,     0,  1539,     0,  1511,  1527,     0,  1507,  1505,
    1516,     0,  1518,  1733,  1809,  1811,     0,  1735,   946,     0,
     947,   971,   485,     0,   970,   977,   977,   472,   683,   463,
    1116,     0,   620,     0,   296,     0,   281,  1113,     0,   749,
       0,   760,   758,     0,     0,     0,  1282,     0,  1283,  1284,
    1287,   357,   360,   391,   401,     0,   384,  1066,  1070,  1069,
       0,     0,   443,   476,   477,   478,     0,   445,   486,   487,
       0,   693,     0,   698,     0,     0,     0,     0,     0,  1232,
       0,     0,  1238,   507,   503,   432,   498,   406,     0,  1235,
       0,   344,     0,  1040,  1043,  1195,   557,   556,  2414,  2416,
    2415,     0,  1717,  1791,  1777,  1804,  1789,  1820,     0,     0,
       0,  1538,  1541,     0,  1509,     0,  1517,     0,     0,     0,
     974,     0,   683,     0,   965,   964,   479,   465,  1374,   336,
       0,     0,     0,   756,   759,   747,   760,   767,   766,  1374,
       0,   404,     0,   469,     0,     0,     0,   488,     0,   489,
     510,     0,   697,     0,   618,   754,     0,     0,   672,     0,
    1233,   509,   507,  1236,  1237,   509,   963,   979,  1194,  1193,
    1422,  2412,  2224,     0,  2197,     0,  1822,  1825,  1823,  1817,
       0,  1526,  1812,  1813,   333,   977,     0,   467,   483,   490,
     274,  1374,     0,     0,   748,   270,  1285,   673,   495,     0,
     494,     0,   492,   491,   694,   699,   644,   744,  1238,   676,
     409,   509,  1547,  1177,  1422,  1176,  1178,  1186,  1183,  1185,
    1184,  1182,     0,  1829,  1828,  1827,  1831,  1830,  1542,   948,
     966,     0,   683,   282,   750,   757,     0,   493,   497,   496,
    1234,     0,   674,   677,   680,   678,   679,   407,   953,     0,
    1187,  1181,  1409,  1396,     0,   484,   468,     0,   654,     0,
    1179,  1422,  1826,     0,   675,  1180,     0,   676,     0,   655
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4802, -4802,  3970, -4802, -1219,   149,  2464,  -709, -4802, -4802,
   -4802,  3112, -4802, -4802, -4802, -4802, -4802, -4802, -4802,  3138,
   -4802, -4802,  1650, -2611, -4802, -4802,   -52,  3109, -1618,   -56,
    2738,  1318, -4802, -1392, -4802, -4802,  -845,    31, -4802,  3115,
   -1061, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -1174,
    1798,  1138,  3490, -2702, -4802, -4802, -1698, -3328, -4802,   518,
   -4802, -4802,  1746, -4802, -4802, -4802,   993,   451,  -500, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802,  -310, -4802, -4802,  -640,
     219,  -123, -2615,  -363, -4802, -4802,   396,  -366, -1619, -4802,
   -3662, -4802,   -46, -4802, -4802, -4802,  -344, -1737,  1237, -4802,
    -980, -1440,  1565,  -702, -4802,  -225, -4802,  -764,  -642,  -639,
    -717,  -534, -3840, -4283, -3877, -3375,  1242, -4802, -3771,   229,
   -4802, -4802,   266,   279, -4802, -4802, -1813, -1731, -4802,  -535,
   -4802, -4802, -4802, -3116, -4802, -4802, -4802, -4802,   -82, -4802,
   -4802, -4802, -4802,   417, -4802, -4802, -4802, -4802, -4802, -4802,
   -2391,  1699,  1700, -4802, -4802, -3307, -4802, -1199, -4802,   559,
   -3114,  1156, -4802, -4802, -4802,  2416, -4802, -4802, -4802, -4802,
   -4802, -4802, -1904, -4802, -4802,   288, -4802,  1710,   963, -4802,
   -4802, -4802,  -753,  -820,  -811, -4802, -3151, -4802, -4802, -4802,
   -4802,  -311, -4802, -4802, -4802, -4802, -4802, -4802, -1278, -4802,
    1026, -3251, -4802, -4802,  1036, -4802, -4802, -4802, -4802, -4802,
    -701,  -242,  2443, -4802,  -585,  -678, -4802, -4802, -4802,  -240,
   -4802, -4802, -4802, -4802, -4802, -4802, -1346,  6300, -1856, -4802,
   -4802, -4802, -4802, -2539, -4802, -4802, -4802, -1875, -4802,  4236,
       3,   114,   292, -4802,  -198,   -88,  2972, -1413, -2810,   349,
    -404, -4802, -2074, -4802, -4802, -4802, -2704, -4802, -4802, -4802,
   -4802, -3613,   318, -4802,  2964, -4802,   402, -4802, -4485, -4059,
   -4354, -4325, -3604, -4802, -4802, -1359, -4802, -4802, -4802, -1745,
    2007, -2206, -4802, -2370,   401,  1308, -1252, -2927, -3876, -1022,
   -3379, -4802, -3787,  -510, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -1342,  -899, -4802, -4802,  3509, -4802, -4379, -4802, -4802,
   -4802, -4802,  1081, -4802, -4802, -1717,  1103, -4802, -4802, -4802,
   -4802, -4802,  -693,  -782, -4802, -4802, -4802,   338, -4802, -4802,
   -4802, -4802,  1735, -1217, -1007,  3349,   339, -4065, -4802, -4802,
   -4802, -4802, -3193, -4802, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -2008, -4802, -4802, -4802, -4802, -4802, -4802, -4802,  2119,
    2122,   -67,  -215, -4802, -4802, -1525, -4802,  -822, -4802,  2363,
   -4802, -4802, -4802, -4802,  1390,   343,   436,   -72, -4802, -4802,
     220, -3531,   -71, -4802, -4802, -4802, -4802, -2324,   -69, -4802,
     715, -4802, -4802, -2937, -4802,   376,   -10,  3037,  1648,   -57,
     277,  -245,  -226,  -192,   -75,  3345,  2807, -4802, -4802, -4802,
    -196,  2127, -4802, -1109,  -349, -4802,  1398,  -929,  2092,  2794,
    2800, -4802,  1392, -4802, -4802,  1399, -4802, -4802, -4802,  -927,
    2101, -4802,  2802, -4802, -4802, -4802,  1384,  1395, -3464,   807,
   -3489, -3470,   295,   282,  -932,  -342,  -152,  3374,  2805,   817,
    -488, -4802, -4802,  -484, -4540,   743, -4802, -4367, -2486,  -455,
   -2191, -1884, -4802, -4802, -1437, 10202, -4802, -4802, -4802, 12084,
   13299, -4802, -4802, 13768, 14420, -4802, -1248,   859, 16269,  8196,
   -1473, -1912, -1567, 19843,  1449,  2080, -2902, -4802, -3612, -2858,
   -4802, -4802, -4802,  -303,   869,   284, -4802, -4802, -4802, -4802,
   -4802, -4802,  -595, -4802,  -594, -4802, -4802, -4802,  -586, -4801,
    2544, -4802,  -844, -4802, 20028,  1429, -4802, -1290, -2869, -2883,
   -3494, -2031, -4802, -4802, -4802, -4802, -4802, -4802, -4802, -1805,
   -3395,  -430,  1505, -4802, -4802,  1600, -4802, -4802, -4802, -1576,
   -1166, -2783,  1512, -2222, -4802, -1116, -4802,   760,  2232, -1063,
    6466, -1539, 17452,  -105, -2463, -1560, -1819, -4802,   363, -4802,
    2530,  3355,  -863,  -136,  -920,  6477,  4530,  5200, -3229, -4802,
   -4802,   380, -4802, -4802, -4802,  3855,  1016, -4802,  3153, -4802,
    1741,  2479, -4802, -4802,  2103,  -956,   111, -4802,  -562, -4802,
    -128, -4802, -4802, -4802,   167, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802, -4802, -4802,  2819, -4802, -4802, -1501, -4802, -4802,
   -4802, -4802, -4802,  4119,  -377, -4802,  3528,  -371, -4802, -4802,
   -4802, -4802, -4802, -4802, -4802, -4802, -4802,  2829,  2136, -4802,
    3336, -4802, -4802, -4802,    -9,  3048, -4802, -4802, -4802, -1239,
    -598,  3339,  3340,  2100, -4802, -4802, -4802, -4802, -4802, -4802,
   -4802, -4802,  2111, -4802, -4802,  1481, -2201,  2113, -4802, -4802,
     778, -4802, -4802,   302, -4802,   776, -4802,  2936, -4802, -4802,
   -4802,   816, -4802, -4802, -4802,  -582, 15261,   -54,   207,   198,
    1133, -4802,  9193, 11109,   -95,  2848,   -49, 12430, 19696,    11,
   -4802,  4113,  2116,  1720, -1032, -4802,  3006,  2422, 19165, -4802,
   -1027,   127,  1802, -4802,    -2,  -672, -1225,  3147,  -749, -2007,
   -4802,  4545, -4802, -3728, -4802, -1074,  3544, -1241
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1752,  2697,  2575,  3420,  3421,   249,
     250,  1827,   251,   252,   253,   254,   255,   256,   257,  1768,
     258,   259,  1322,  1981,  2707,   260,  2445,  1085,  1086,  1087,
    2301,  2302,  2639,  2303,  2290,  1603,  2083,  1787,  1051,  1052,
    1754,  1788,   262,   263,  1597,  2282,   264,   265,   266,  1814,
    1815,  1762,  2026,  4361,  4994,  3253,  2556,  3457,  3254,  3255,
     267,  1877,  1878,   268,   269,  3371,  1918,  2666,  3923,  3924,
    4392,   885,  2663,  4681,  4682,  4378,  4379,  4688,  4877,  4878,
    2708,  1977,  3451,  4012,  3411,  4463,  3412,  4464,  3413,  4465,
    3399,  3970,  3971,  3972,  3414,  4441,  4910,  3415,  2460,  5022,
    2742,  2113,  2111,  4897,  4253,  4254,  5082,  5027,  5028,  5029,
    5162,  4470,  3455,  4018,  4473,  4718,  3152,  2001,  3530,   985,
    2744,   916,   986,  2709,   274,  2736,  1847,  1848,  2583,  3930,
    3513,   275,  1341,  3794,  4764,  4945,  4946,   276,   873,   277,
    1985,   278,   279,  2693,  3405,   280,  2477,  3169,   281,   282,
    3196,  3197,  3198,   283,   284,  3816,  4634,  1816,  3242,  3243,
    3244,  3245,  3837,   285,  1983,  1853,  2716,   286,   287,   288,
     289,   290,  2627,   291,   292,  2710,  1993,  2728,  2729,  4453,
    4734,  4919,  4736,  5201,  5202,  4710,  3773,  4267,   294,   295,
    4436,  4437,  5034,   296,  2475,   297,   298,   299,  1961,  2685,
    2686,  3931,  1920,  2668,  2669,  4001,  4002,   300,  3331,   301,
    4318,  4319,   917,  5037,  5001,  5095,   302,   303,  4322,  4323,
     304,   305,   306,   307,   308,   973,  1394,  1395,  1744,   309,
    2318,   310,  1295,  3362,   311,  1483,  2880,  4511,   312,  1009,
    1419,  1420,  2711,   314,  1020,  2858,  1022,  2126,  3515,  3516,
    4072,  2827,  1211,   315,   316,  2838,  2861,   317,  1755,  2451,
    2452,  4248,  2712,   918,  2007,  2747,  3147,  4936,  4255,  4614,
    4840,  3058,  3717,   319,   919,  1792,  2520,  2750,  3463,  2423,
    2424,  2425,  4033,  2426,  3465,  2427,  1738,  2428,  3470,  3471,
    3472,  4029,  4037,  4758,  4759,   320,  1790,  2518,   321,   322,
     323,  1824,  1231,   324,   941,   942,   325,  4889,   326,  1360,
     327,  1041,  2143,   328,   329,  2533,  3823,   330,   331,   332,
    5175,  5209,  5210,  5211,  4042,  5130,   333,  5177,  1461,   335,
     336,   337,   876,  1261,  1262,  1263,  2713,  4753,   339,   340,
    2689,  3398,  3952,   341,   342,  2446,  3137,   343,   344,   345,
     346,  1965,   347,   348,   349,   350,  1897,   351,  1634,  1635,
     352,   353,   880,  1105,  1638,  1646,   354,   988,  1413,  1414,
    1415,  2085,   355,  1465,  2849,   989,  1408,   990,  3077,  3726,
    3727,  3730,   991,  3074,   359,  2132,  2843,  2846,   992,  3081,
    3082,  3083,  3084,  3085,  3732,   993,  1011,  1351,  2758,   994,
    1554,   364,   365,   366,  1114,  1109,  1110,   368,  2259,  3012,
    1028,  1652,  1070,  1121,  3681,  2332,  2333,  2355,  2356,  1661,
    1662,  2345,  2347,  3060,  2348,  3068,  2338,  4203,  4580,  2351,
    2352,  1664,  1665,  1666,  2360,   369,  3015,  3662,  3663,  3664,
    4180,  4181,  4195,  4191,  4567,  4809,  3665,  1455,  1672,  3666,
    4800,  4801,  4963,  4198,  3673,  3724,  3442,  3443,  3444,  2429,
    2676,  1943,  1555,  1944,  2683,  1556,  2178,  1946,  1557,  1558,
    1559,  1949,  1560,  1561,  1562,  1563,  2161,  2221,  1564,  1565,
    2197,  1153,  1154,  2070,  2919,  1567,  1568,  1569,  3668,  1570,
    4138,  4535,  4524,  2945,  2946,  2298,  4134,  3608,  2255,  3002,
    4821,  4974,  4975,  3649,  4164,  4552,  4799,  5070,  5136,  5137,
    1571,  2999,  2250,  1233,  1572,  3933,  2252,  2939,  3024,  3025,
    2138,  2159,  2885,  2902,  2903,  2916,  3569,  2923,  2928,  3592,
    3593,  2940,  2968,  1573,  2888,  2889,  3552,  2163,  1574,  1627,
    1628,  2268,  2963,  1641,  1642,  1107,  1575,  1576,  1577,  2127,
    1096,  4805,   726,   709,  3269,  2313,  1265,  1025,  1578,  1579,
    1580,  1369,  1370,  1693,   671,   710,   711,  1191,   823,     2,
      75,   995,  3449,   373,   374,   921,   922,   923,  1343,  1344,
    2012,  2015,  1698,  2395,   675,   676,   727,  4489,  4765,  4948,
     979,   375,   376,   377,   378,  1694,  2391,  1155,    76,    84,
      77,  1156,   415,   416,  2373,   379,   840,   380,  1675,  1135,
    3738,   381,   382,   383,   384,   385,   976,   386,  1137,   387,
    1138,   388,   389,   390,   391,  1145,   392,  1677,  1678,  4236,
    1679,   393,   394,   713,   714,  1406,   395,   396,  1172,  1173,
    1438,  1439,  1704,  1719,  1720,  1721,   397,   683,   398,   399,
     400,  1710,  1711,   401,  2275,  2276,  2400,  2277,   402,  3098,
    3099,   403,  3697,  3698,  4589,  3699,   404,  2271,   405,   406,
    1099,  3743,   407,   836,   408,  1186,   715,   716,   717,  1193,
     826,  1056,   728,  1195,  3246,   828,   829,   719,   720,   721,
    2105,    78,  3106,  2106,  1582,   729,  1583,  2266,  1584,  1585,
    1586,  1587,  1588,  1727,   723,  1162,  1398,  1399,  3107,  1401,
      82,  1402,   412,  3945,  2073,  1440,  2091,  2092
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,  1113,  1318,   367,  1132,  2110,   357,   358,  2032,   360,
    1133,  1062,  1598,  1673,  1232,  1667,  1122,  1829,  1620,  2459,
    1353,   362,   827,  2082,   409,  2036,   932,   915,  1739,   410,
     409,  1013,  1098,  1882,  2042,   410,  3070,  1447,  1448,  1449,
    1975,  2681,  1852,  1453,  2828,  1895,  2521,  1921,   920,  3533,
    1995,  1013,  2315,  2673,  3115,  3117,  3022,  1232,  1170,  1376,
    2529,  2795,  2199,   409,  1416,  2150,  1846,   827,  3817,  2172,
    2173,  1095,  1861,  3030,  1034,  1612,   411,  2641,   972,  3800,
    1887,  3410,   411,  1021,  2538,  1963,   725,   680,  2188,  1968,
     367,  4036,  2733,  3428,  1972,  1352,   731,  1379,   987,  2682,
    3979,  1978,  3050,  3271,  3997,  2023,  2326,  1391,   409,   261,
    4219,  1997,  3667,  2552,  1232,   411,  2595,  2071,  2380,  2382,
    2383,  1063,  3367,   874,  2329,  3832,  2884,  3834,   831,    79,
    3328,  4022,   878,  1174,  3519,   827,  3676,  3948,  1116,  1722,
    4151,  1124,  2605,  3731,  1724,  4476,  3934,   934,  3674,  3675,
    4250,   926,  1050,  2787,  4290,  4256,  3669,  4484,  1353,  3934,
     411,  1411,  1092,  2315,  1084,  2514,  2609,  2610,  3616,  2072,
    1010,  3667,  4468,   831,  2067,  1125,   409,  4194,  2528,  2374,
    2374,  3089,  4434,  2437,  3747,  4745,  2737,  2097,  2748,  1789,
    1010,  1883,  1660,  4224,  1663,  4192,  4177,  4116,  4615,  3953,
    3954,  3955,  3956,  3957,  3958,   712,  1059,  4813,  3742,  4815,
    1700,  1701,  1165,  4398,  1059,  3669,  1059,  1713,  3114,  1058,
    3105,  2225,  4941,  1994,  3109,  2539,  1400,  1058,   411,  1058,
    3573,  2273,   418,  1605,  2024,  -141,  3423,   884,   418,  4462,
    1714,   831,  2219,   712,  -141,  2024,  2228,  2165,  2166,  -141,
    4475,   414,    45,  4613,  2316,  1347,  1187,  1765,  2616,  2621,
    2730,  4841,  4622,  2216,   924,   931,  2961,  4027,  2961,  1463,
    4937,   875,  2825,  2185,   931,   418,  2230,   418,    37,    38,
      39,    40,  1436,  1175,    43,    44,  1485,  1715,  3520,    45,
    3350,    45,    37,    38,    39,    40,  1756,   270,   367,    44,
    1959,   357,   358,  3736,   360,  2024,  1479,   271,  4430,  2860,
    3487,  2956,  3489,   931,  4847,   825,   362,  1916,  2820,   418,
    3550,  2531,  4890, -1943,   824,  3259,  2467,   409,    43,  2603,
    4863,  5182,   410,    45,  2074,   130,   131,  3138, -1946, -1946,
   -1946, -1946,  5000, -1838,   272, -1946, -2680, -2680, -2680, -2680,
   -1838,  3531,  4995, -2680,  2509,   363,  2280,   273,  1436,  1766,
     825, -2680,   409,  4320,  2336,     3,   293,   410,  2996,   824,
     313, -1612, -1612, -1612, -1612,  2997,   417,  2225, -1612,   411,
    1713,  1001, -1854,  1910, -1622, -1622, -1622, -1622,  2217, -1854,
    2531, -1622,   730,  2462,  3055,  1895,   318,  1602,  1757,  2130,
    1591,  1002,  2228,  1714,   261, -2681, -2681, -2681, -2681,  3139,
    2839,  3178, -2681,  5222,   411,  2264,   334,   338,  2731,  2281,
   -2681,   356,    37,    38,    39,    40,   886,  2034,   825,    44,
    1103, -1612,  2230, -2678, -2678, -2678, -2678,   824,  1232,  2510,
   -2678,  3014,   363,  2034,  4431,  2531, -2101,  4971, -2678, -1622,
   -1622, -1622, -1622,  2337,   361,  1257, -1622,  1436,   372,  2468,
    1631,  4321,  1632,  1189,  4929,  2034,  5104,  2199,  2531,  1133,
    2531,  3973,  1353,  3056,  -394,  4618,  1209,  2317, -2677, -2677,
   -2677, -2677,  3378,  3521,  2821, -2677,  2025, -1612, -1612, -1612,
   -1612,  2172,  2173, -2677, -1612,  1353,  3163,  2025,  2188,  2826,
    2540,  2260, -2273, -2273, -2273, -2273,  2531,  1625,  5017, -2273,
    3260,  1626,  2541,  2822,  2043,  4985,  4986, -2273, -1607, -1607,
   -1607, -1607,  1176,  1112,  2465, -1607,  4291,  2840,  1161,  1475,
     841,   920, -1579, -1579, -1579, -1579,  2673,  2469,  1682, -1579,
    4623,  2225,  1758,  2307,  2308,  1258,  2648,  2060,  1437, -1592,
   -1592, -1592, -1592,  1464,  1168,  1169, -1592,  2025, -1619, -1619,
   -1619, -1619,  1353,  2542,  4243, -1619,  2228,  5126,  2652,  2732,
    1703,  1706,   842,  3573,  3122,  1759,  2823,  2962, -1607,  3636,
    2829,  2622,  2831,  1159,  1960,  2834,  1259,  4028,  2128,  3351,
    2034,  4304,   270,  1452,  2887,  2086,  2230,  2500,    37,    38,
      39,    40,   271,  2140,  1760,    44,  1735,  2617,    37,    38,
      39,    40,  2604,  3934,  2131,    44,  2151,  1692,  1767,  4260,
    2220,  1625,  2062,  1709,  2591,  1626,  2593,  5080,  1960,   246,
    4747,  1823,  5208,  2034,   926,   935,  1260,  2154,  1452,   272,
    1751,  2315,  2249,  2671,  1123,  4715,  2564,  2644,  2066,  1166,
     363,  3585,   273, -2101,  2600, -1838,  4541,    37,    38,    39,
      40,   293,  1761,  4448,    44,   313,  2131,  -141,  -141,  2816,
    1007,  1008,  4704,  4705,  4706,  4707,  4708,  2640,  2165,  2166,
    2998,  3200,  1817,  3766,  2274,  4194,  2185,  1353,  2315,  3381,
    4741,   318,  3029,  4071, -1854,  1353,  1353,  4761,  1167,  4457,
    1633,  4600,  4516,  4558,  2841,  2261,  5140,  1716,  1717,  1007,
    1008,   334,   338,  1104,  1246,  2791,   356, -2101,  3059,  4564,
    2024,   418,  2842,  4568,    37,    38,    39,    40,  3733,  1210,
      43,    44, -2101,  3974,  3855,    45,  3266,  5105,  2361,  1113,
    2362,  1178,  1202,  2396,  3749,  4680,  3750,   924,  2453,   361,
    4904,  1007,  1691,   372, -1397,  5145,  3667,  4408,  3667,  3877,
    5121,  4281,  2286,  2160,  2664,  2665,  2573,  3294,  2517,  2576,
    2824,  3164,  1417,  4981,  1625,  1668, -1946,  1683,  1626,  2835,
    1119,  3201,   409,  4293, -2680,  4393,   409,  1304,  2194,  1894,
    2467,   410,  3573,   931,   931,  3075,  4210,  4308,  4905,  1294,
    3669,  1349,  3669,  1219,   681,  4906,  3801,  2466,  2195, -1612,
    1174,  3022,  3022,  3022,  3910,  2724,  3993,  3913,  3914,  2455,
    4014,  3917,  2196,  4833,  4241,  1826,  1702,  3920, -1397,  1444,
    4843,  3701,  4907,  3191,   411,  2799,  3856,  2456,   411,  5171,
    2067,  1161,  1198, -2681,  1362,  3267,  1942,   831,  3402,  2806,
    5039,  1198,   680,  2194,  3707,  2809,  5184,  1409,   680,   837,
    1418,   838,  1424,  1309,  1429,  3667,  2881,  2883,  4927,   680,
    1433, -2678,  3091,  2195,  3091,  3796,  1454,  2891,  3129,  2160,
    2084,  2895,  1765,  2700,   936,  1198,   980,  2198,  1124,  2907,
    2908,  3003,  2725,  1424,  1429,  3915,  3916,   680,  2514,  5158,
    1001,   680,  2925,  2927,  4908,   981,  3192,  3217,   367,  3669,
    1364,   881,   680,  2941,   418, -1400, -2677,  1412,  1126,  1866,
    1002,  4867,  1125,  4294, -2408, -1612,  2571,  4487,    45,  4076,
    3522,  1350,  -797,  3524,   937,  2911,  2912,   982,   680, -2051,
   -2273,  1705,  1198,  3369,  4038,  4227,  1454,  1903,  4802,  1871,
    1828,  2705,  1198,   680,  -163,  1872, -1607,  1867,   680,  2246,
    2247,  2248,  2249,  3679,  2978,   938,  2457,   939,   680,  4943,
    2171,  1410,  2025,    81,  3575, -1397,  1671,  5120,  3176,  -163,
    3857,  1232,   680,  5185,  1766,  1445,  2701,  2177,  1423, -1400,
    1428,  3582,  3583,  3584,  3585,  1127, -1619,  1119,  2798,  4256,
    1442,  1422,  3525,  1427,  3464,  3932,  2595,  2551,  1338,  2137,
    3403,   215,  1436,  3858,  3249,  3801,  1437,  3004,  3932,  1457,
    1459,  4039,  4868,  2743,  1601,  2706,  4295,  4781,  1609,  4296,
    1614,  5128,  1456,  1458,   825,   682,  2222,  1636,  1161,  2740,
     931,   223,  3859,   824,  1743,   409,  2262,  3712,  2217,  4345,
    1630,  1873,  5047,  1751,  2677,  1404,   418,  3195,  1771,  2832,
    2833,  3052,  2458,  5053,  3250,  1595,  1487,  4077,  1198,  3573,
    4909, -1397,  4803,  2726,  1059,  2291,   680,  1986,  1059,   233,
    2304,  2304,  5159,  5043,  4459,  3573,  2727,  1058,  3404,  1405,
    2979,  1058,   236,   931,  2980,  3035,   205,   411,  4034,  3797,
    4608,  4806,    79,  5200,  1198,  4036,  4810,  2740, -1397,  4812,
    1868, -1397,  -616,  1425, -2408,  1987,  1310,  1430,  1431,  1432,
    4944,  1147,   215,  2551,  3704,  3523,  4956,  1443,  3076, -2051,
    4738,  1437,  2981,  5198,   839,   418, -1400,  2225,    37,    38,
      39,    40,  2776,  4256,    43,    44,  1485,  1715,  3251,    45,
    3370,  5160,   223,  3682,  4587,  4040,  3683,  3684,  1416,  2225,
     879,  1793,  2228,  1365,   680,   680,  1339,  3685,  3686,  3687,
    2768,  3688,  3689, -2408,  5161,  4635,  3690,  3691,  3692,  1148,
    4204,  2779,  2678,  1161,  2228,   712,  1050,  1856, -2051,  1128,
     233,  5018,  2230,  2786,  5129,  1874,  2050,  1232,  1869,  2017,
    1904,  4346,  1171,   236,  5122,  3119,  1892,  1190,  3580,  3581,
    3582,  3583,  3584,  3585,  2230,  4041,  1212,  4979,  1222,  1223,
    1224,  1340,  1225,  1226,  1227,  1228,  1229,  1230,  1875,  2741,
    3574,  3177, -1400,  1753,  2051,  3038,  2461,  1615,  2502,   246,
    1059,  1059,  1656,  4844,  5170,  3385,  2508,   215,  5172,  2018,
    1299,  3575,  2982,  1058,  1058,  2802,  3748,  1876, -1579,  2010,
     363,  1112,  3122,  2462,  5045,  1198,  5127, -2682,  1988, -1400,
    3191,  5199, -1400,  1150,  4460,  2381,  1198,   223,  4518,  1695,
    4519,  3667,  3339,  1753,  3985,  3667,  4951,  3510,  1872,  1589,
    2914,  3204,  3252,  4599,  5207,   977,  3069,  4731,  1725,  1958,
    2581,  1616,  1139,  2584,  2585,  4720,  1027,  1357,  1113,  4957,
    3576,  1658,  1607,  2653,  2471,   233,  1475,  1367,  3693,  2233,
    2234,  4210,  1140,  1451,  2472,  3669,  4584,   832,  5019,  3669,
    4577, -1579,  1141,  2284,  3322,  3812,  1198,   833,  4932,  2019,
    4895, -2682,   367,  3192,  1695,  1232,  4933,  4968,  1659,  4802,
    2854,  3216,  2411,  1590,  1487,  2655,  1989,  3573,  1133,  1068,
    1893,  3789,  4998,  1100,   246,  2237,  5003,  5004,  2568,  1150,
    2654,  2649,  2679,  4372,  4504,   680,  3205,  1037,  1722,  4375,
    4376,  5084,  5085,  1724,  1873,  2453,  3120,  2052,  3121,  2020,
     680,  1123,  4852,  2656,    81,    81,  2463,    81,  3813,  3790,
    1146,  2454,  2677,  1452,  1650,  1198,  3293,  3484,  3875,  4520,
    2088,  4721,  2090,   680,  3934,  2094,  3818,  2096,  1036,  4912,
    2099,  2100,  2101,  2322,  3485,  4916,  2330,  2331,  3306,  2335,
    2034,  1142,  3986,  2108,  3490,  2386,   834,  4067,  2387,  1035,
    4256,  3433,  3434,  3435,  3436,  2645,  2133,  3372,  2134,   680,
    3694,  4306,  1069,  3441,  2586,  1038,  2455,  3345,  4982,  2017,
    1125,  1125,  1958,  1125,   680,  2473,  3811,  1147,  4988,  1147,
    2021,  3876,  3932,  3022,  2456,  2053,  1174,   680,  1117,  1001,
     680,  3577,  3578,  3579, -1579,  3580,  3581,  3582,  3583,  3584,
    3585,  1198,  3842,  1143,  3195,  1001,  3695,  1651,  2474,  1002,
    4934,  3580,  3581,  3582,  3583,  3584,  3585,  3843,  3480,  2801,
    2690,  5092,  4315,  4233,  4307,  1002,  4087,  1671, -2083,  4456,
    1198,  3708,  1067,    79,    79,  1148,    79,  1148,  1149,  2388,
    2678,  2314,  2087,  3191, -2102,  2089,  2544,  1118,  2093,  3575,
    2095,  5190,  1695,  2098,  2265,  1115,  2657,  2102,  1198,  1198,
    1807,  1198,  3791,  2244,  2245,  2246,  2247,  2248,  2249,  4893,
    1093,  1144,  1001,  2595,  2253,  1257,   835,  1716,  1717,  3959,
    1198,  5093,   409,  2762,  1405,  2244,  2245,  2246,  2247,  2248,
    2249,  2587,  1002,  2588,  2278,  2279,  5038,  3878,  3182,  4492,
    3696,  4493,  2569,  4060,   418,  4748,  3548,  3819,  3576,  2019,
     882, -2129,  3761,  2457,  1119,   680,  3192,  4749,  2294,  4428,
    4316,  3313,  3962,   680,   680,   898,  2339,  3314,  5023,  1150,
    4619,  1150,  3820,  1198,   411,   409,   409,   409,  1039,  1040,
    1899,   410,   410,   898,  2658,  3150,  3193,   831,  1257,    43,
    3792,  1905,  2531,  1232,    45,  3600,  4244,  4942,  2314,  2020,
    2532, -1579,  1198,  2340,  2570,  1258,  1198,  1198,  3667,  2535,
    3213,  1990, -1579,  3667,  2171, -1579,  1743, -1579,  3667,  3194,
    1656,  3667,  4429,   900,  4036,   409,  3625,   411,   411,   411,
     410,  1991,   409,  4620,   841,  3385,  2495,  2415,  2393,   409,
    3151,   900,  2377,  4989,   363,  4773,  1259,   680,  -520,  2458,
    4317,  2008,  3669,  3323,   712,   712,  2602,  3669, -2083,  3667,
    2536,  3772,  3669,  3315,  2216,  3669,  1136,  3230,  1151,  2447,
    2679,  1120,  2586,  5125, -2102,  3146,   842,   411,  1258,  2448,
    2021,  5024,  3324,  3103,   411,  1958,  4992,  1695,  1152,  1658,
    2680,   411,  1695,  1695,  2449,  4713,  1260,  2342,  1059,  -417,
    3966,  4724,  3232,  3669,   831,  4015,  5068,  3195,  4019,  2378,
     841,  1058,  4750,  1064,  4097,  3459,  2158, -2083,  3231,  1259,
    2957,  4185,  4263,  3580,  3581,  3582,  3583,  3584,  3585,  1129,
    -961,  1059,  5069, -2102,   898,  2339,  2175,  3967,  4117,  1958,
    4184, -2129,  4725,  1611,  1058,  4829,  5025,  4831,  2343,  4186,
    1106,  3968,   842,  3233,    80,   130,   131,  5166,   712,  4626,
    4627,   907,  4245,   908,  4570,  2380,  2202,  2379,  2389,  1260,
    3150,  1958,  2340,  3319,   825,  4723,  4188,  1992,  5057,   907,
    2214,   908,  1353,   824,  4678,  4679,  1976,  5087,  4730,  2225,
    3788,  4246,   900,  2407,  2409,  4740,  4264,   841,  2057,  2587,
   -2129,  2588,  -417,  3667,   913,  3094,  3320,  3316,  1753,  4185,
    4247,  1753,   980,   843,  5220,  2687,  3286,  5221,  2058,  1353,
    3627,  1740,  3628,  2296,  2341,  3769,  4184,   680,  2450,  1059,
    1242,   981,   883,  3969,  2837,  3321,   824,  4186,  4693,   842,
    3317,   679,  1058,  4694,  2230,  3629,   974,  3669,  1958,  2378,
    1695,  4265,  4187,  4266,  1741,  1243,   409,  3474,  1695,  3667,
   -1409,  1150,  2297,   982,  4188,  3680,  2342,  2670,  3780,  3318,
    3325,  3286, -1409,  2034,  2763,  4190,     8, -1409,  1615,  1123,
    1123,  5147,  1123,  1742,  2194,  1958,  4695,  4189,  4851,  4278,
    1487,   825,  3045,  3573,  3498,  4185,  1065, -2472,  1133,  3326,
     824,  2857,  4261,  3669,  2195,   925,  4807,  2379,   411,  2553,
    4144,   943,  1695,  1958,  1171,  1695,  1695,  2343,  2196, -1409,
    4066,   831,  4871,  4186,    37,    38,    39,    40,   680,  2844,
     907,    44,   908,  1487,  1656,  4070,  3573,  1026,  4187,  1657,
    1177, -1409,  1616,  3022,   680,  1960,  3630,  3998,  3022,  3802,
    4188,  3631,   367,  3022,  4866,  1976,  4007,  1475,  2554,  2592,
    2555,  1412,  4588,  4190,   891,    37,    38,    39,    40,  2194,
    1198,  3822,    44,  4189,  4071,  3805,  1958,  3702, -1409,  1198,
    1188,   680,   680,  1695,  4406,  1205, -1409,  4699,  2103,  2195,
    3029,  5216,   680,  3052,  2551,  1880,  2553,  1835,  3295,   208,
    4100,  1150,  4101,  1658,   680,   680,  3298, -1444,  3300,  3667,
    2856,  2104, -1444,    81,   367,  4700,    81,  2850,  2851,  1832,
    2852,   122,   205,  2879,  1881,  3218,   680,  2804,  1311,  2805,
    1312,  1862,  2853,  2807,  3642,  2808,  4282,  4808,  2810,   126,
    1659,  3848,  2811,  1836,   898,  2554,   418,  2555,   215,  4190,
      35,   418,  1833,  3669,    37,    38,    39,    40,    41,    42,
      43,    44,  2634,  -955,  1863,    45,  1198,  1353,  1864,  4079,
    3632,  4292,  4297,  4118,  4119,  3575, -1444,  2702,   223,  4309,
    3633,  2551,  2959,    37,    38,    39,    40,  3381,  4872,  1232,
      44,  3502,  1203,  1865,  3737,  2635,  2734,  2636,  1751,  1217,
    3667,   208,   900, -1409,  1198,  1198,  1218,  3390,   825,  2637,
    3029,  1248,  1198, -1444,  1745,  1198,   233,   824,  3575,  1198,
     983,  4102,  1837,   409,  2905,   940,  1881,  1198,  1198,   236,
    4083,  4103,  3975,  2638,  3576,  1198,  2183,  2184,  1198,  1198,
    1198,  1198,    79,  3429,  3669,    79,  4347,  1746,  1198,  1198,
    3438,  1198,  3061,  1198,  1198,  3439,  3391,  1198,  4917,  2288,
    2969,  4363,  2970,  3713,  1625,   984,  4348,  1647,  1626,  3379,
    1838,  1255,  1839,  1958,  1198,   411,  1747,  3576,  4601,  1198,
    4537,  4364,  2594,  1198,  1256,  2971,  4918,  1198,   831,  1198,
    1198,  1198,  1198,  1198,  1198,  1198,  1198,  1198,  1353,  1198,
    3140,  1314,  3143,  1315,  1636,  4536,  2431,  3949,  2598,  1198,
    1198,  1841,  3439,    35,  4913,   409,  1298,  5173,   192,  5144,
     410,    41,    42,  3932,  4466,  3758,  3759,  4757,  1625,  2606,
    2531,  3464,  1626,  1301,  4082,  3392,  3393,  1303,  2537,  2432,
     907,  3381,   908,  1117,  2068,  3512,  1932,  3746,  2069,  3394,
    1843,   910,  2633,  2269,  1807, -1445,  2270,  3078,  1306,  4848,
   -1445,  3385,   912,  4124,  1849,  1976,  2553,   411,  2433,   409,
    2289,   409,  1198,  3779,   410,  3753,   410,  1319,  4258,  4259,
    2171,  2972,  2438,  1748,  1326,  1845,  2973,  4240,  3134,  2553,
    4864,  2974,  2171,  2314,  2438,  3199,  3395,  1850,  2194,   215,
    2370,  2371,  1118,  3852,   363,  3577,  3578,  3579,  -519,  3580,
    3581,  3582,  3583,  3584,  3585,  2554,  1749,  2555,  2195,  1487,
     208,   411,  3573,   411, -1445,  4690,  3361,  4692,  2077,   223,
    2078,  4696,  2198,  4697,   409,  2760,  3853,  4938,  2554,  4145,
    2555,  3202,   680,  3527,  2766,  1750,  3066,  3067,  3577,  3578,
    3579,  2551,  3580,  3581,  3582,  3583,  3584,  3585,  1335,  2068,
      81, -1445,    81,  2794,  1337,  3854,   363,   233,  1958,  1119,
    1336,  3870,  1958,  1958,  2551,   825,  1647,  1342,  2553, -1397,
     236,   215,   680,  3396,   824,  3397,   411,   680,   925,  3545,
     680,   192,  1851,  2797,  1625,  3991, -1946,  1345,  1626,   831,
      37,    38,    39,    40,  3546,   418,  3256,    44,  3547,  1363,
    2975,   223,   680, -1468, -1468,  1198,  5174,  3277,  4263,  1751,
    2976,    37,    38,    39,    40,  1359,  1198,  2554,    44,  2555,
    1371,  1212,  1353,  1198,  1353,  1895,  4400,  4401,  4402,  4403,
    4404,  2947,  1372,   409,  2950,  3959,  4702,   409,  2157,   233,
     246,  3960,  2304,   680,  3599,  4200,  3601,  3602,  1386,  2967,
    5020,  3961,   236,  2551,  1059,  1377,  1161,  1695,  2370,  3087,
     680,   680,   215,   975,  4497,  4498,  4499,  1058,  1958,  1392,
    4996,  3713,    74,  1007,  1691,    45,  1120,  1725,  3962,    79,
    3963,    79,  4264,  1407,  3713,   411,   680,  1353,   246,   411,
    2144,  2145,   223,  3984,  3575,  3987,  1446,  3976,   831,  3978,
    1450,  2320,   831,  2321,  1460,  4205,  4206,  4207,  2323,  3268,
    2324,  1331,   680,  3287,  3874,  1466,   680,    35,  1467,  1331,
    1179,  2171,  3430,  1743,  1472,    41,    42,  4402,  4403,  4404,
     233,  1473,  1180,  1181,   680,  1474,  3400,  4265,  2756,  4266,
    2757,  1332,  3416,   236,  1475,   680,  2553,  1476,  2796,  1332,
    2797,  2553,  1182,  3576,  3964,  1183,  1478,  3879,   680,  2817,
    1477,  2818,  4031,  1481,  2315,  4887,  1487,   680,  3287,  3573,
    1333,  4774,  4775,  4776,  4777,  1482,   825,   409,  3995,   246,
   -1188,   363,  2819, -1188,  2818,   824,  4543,  2847,  1484,  2848,
    3907,  3029,  1610,  1487,  2553,  2554,  3573,  2555,  3279,  3051,
    2554,  3052,  2555,  3210,  2224,  3211,  1613,  2225,  4078,  1617,
    1198,  3965,  1958,  4544,  1334,  3273,  3966,  3274,  1619,  3373,
    4825,  3374,  1334,  1487,  1296,  1618,  3573,  2553,  4283,   411,
    1624,  2551,  2228,  3867,  4310,  3287,  2551,  1012,  2229,  2171,
    3287,  2438,   831,  2554,  1637,  2555,  4368,  3386,  3280,  3387,
    1695,  3715,  3716,  3967,  4510,  1644,  3781,  1012,  1695,  1645,
    1695,  1113,  2230,  1647,  3453,  2553,  3454,  3968,  3504,  1184,
    2818,  2553,  3287,  3544,  4757,  2797,  2554,  1648,  2555,  2551,
    1654,  1669,  1354,   943,  3554,   825,  2797,  1958,  1670,   825,
     680,  3558,  1674,  2797,   824,  3417,  1676,  4485,   824,  1680,
    3281,    35,  1681,  3562,  5150,  2797,  1185,  1684,  1685,    41,
      42,  3563,  2551,  2797,  2554,  5155,  2555,    80,  1696,  3589,
    2554,  2797,  2555,  1686,  3577,  3578,  3579,   680,  3580,  3581,
    3582,  3583,  3584,  3585,  1689,  1198,  4400,  4401,  4402,  4403,
    4404,  3605,  1687,  2797,  4405,  4666,  4667,  1688,  4669,  3969,
    2551,  3575,  1690,  3655,  3656,  3657,  2551,  3860,  3610,  3862,
    3611,  1697,  1728,    37,    38,    39,    40,  5193,  2232,  1699,
      44,  1113,  1729,  1731,   680,  1462,  4525,  3650,  3575,  3651,
    1737,  3170,  3279,  3652,  1743,  3653,  1958,  3606,  1212,  2233,
    2234,  1764,  3282,  3613,  3835,  1769,  3836,   680,  3840,  1791,
    3841,  1198,    37,    38,    39,    40,  1480,  1198,  3575,    44,
    3576,  1795,  1796,    45,  3897,  1592,  4025,  1823,  4026,  1604,
    1354,  1606,  1825,  1826,  1198,  1198,  1831,  1834,   409,   825,
    1198,  3418,  3280,  1857,   409,  2237,    35,  3576,   824,  3911,
      37,    38,    39,    40,    41,    42,  1858,    44,  2238,  1870,
      35,   418,  4088,  1884,  2797,  1198,  1198,  1879,    41,    42,
    1198,  4125,  1889,  4126,  1161,    45,  1890,  3576,  4412,  4135,
    3419,  4136,  1198,  1198,  1198,  1198,    37,    38,    39,    40,
     411,  1891,  1896,    44,  3281,  1198,   411,  4147,  1198,  2797,
    1198,  1898,  4225,   831,  4226,  3283,  4229,  1695,  4230,   831,
    1198,  1198,  1902,  3284,  1198,  1900,  3285,  4409,   679,   679,
    4239,  1906,  3121,  1726,  4262,  1907,  2818,  1198,   367,  1198,
    1912,  2850,  2851,  1198,  2852,  4395,  1914,  4396,  4687,  4458,
    1917,  2818, -1583, -1583, -1583, -1583,  2853,  3218,  3713, -1583,
    2896,  4542,  1198,  2848,  1919,  4084,  4466,  4728,  4603,  4610,
    3121,  4611,  1198,  4381,  1922,  1198,  1198,  1198,  4616,  1751,
    2818,    37,    38,    39,    40,  4617,  4048,  2818,    44,  1964,
      37,    38,    39,    40,  1967,   680,  3282,    44,  4683,  1198,
    4684,  3577,  3578,  3579,  1969,  3580,  3581,  3582,  3583,  3584,
    3585,  4742,  1198,  4743,  4382,  1979,  1960,  1198, -1590, -1590,
   -1590, -1590,  4783,  1198,  4784, -1590,  1980,  2897,  3577,  3578,
    3579,  1198,  3580,  3581,  3582,  3583,  3584,  3585,  4383,  4785,
    4793,  2797,  2848,  2244,  2245,  2246,  2247,  2248,  2249,  -183,
    4849,  1739,  4850,  4384,  4914,   677,  2818,  4385,  4092, -2682,
   -2682,  1982,  3580,  3581,  3582,  3583,  3584,  3585,  4939,  1958,
    4940,  4952,  1958,  2848,  1958,  1984,  1998,  4386,  4098,  1958,
    4387,   680,  4444,  4445,  1996,  2898,  4414,  4960,  2899,  4961,
    2006,  4965,  4388,  3052,   859,  4416,   680,   680,  2014,  3283,
     825,  2004,  1198,  4120,  2022,  2027,   825,  3284,  2028,   824,
    3285,  4970,  2029,  4005,  4597,   824,  2031,  2030, -1581, -1581,
   -1581, -1581,  2033,   680,  1695, -1581,   680,  2034,  4972,  1958,
    4005,  2041,  2044,  1014, -1584, -1584, -1584, -1584,  5014,  2137,
    5015, -1584,  5046,  2045,  2283,   409,   409,   409, -1582, -1582,
   -1582, -1582,  2046,  1014,  1354, -1582,  2047,  2049,    80,    80,
    5051,    80,  5052,  5062,  2054,  2848,  5063,  2055,  3611,  1958,
    4389,  5064,  5074,  2797,  3052,  2056,  2061,  1354,  4390,  2900,
    5076,  5091,  4005,  2848,  2075,  5097,  3536,  2848,  5098,  5112,
    2848,  5113,  3539,  5141,  5188,  3052,  4005,   411,   411,   411,
    5218,  2109,  5219,  2214,  5229,  1653,  5219,  1655,  2139,  2142,
     831,   831,   831,  4391,  4882,  4884,  4569,  2967,  4572,  2146,
    2148,   680,  2135,  2149,  2155,  4964,  2156,  2164,  2167,  2168,
    1958,  2169,  1958,   680,  2170,  4964,  3645,  2174,   246,  2176,
    2179,  2180,   680,  2181,  1354,  2182,  2187,  2254,  4818,  2258,
    2189,  3661,  2687,  2190,  4876,  2191,  2192,  4161,  2193,  2200,
    2256,  2201,  2203,  2204,  2205,  2206,  2207,    35,  2208,  2209,
    2210,  2287,  2299,  2309,  1436,    41,    42,  2261,  2901,  4593,
    2283,  2224,  2319,  2328,  2225,  1657,  1659,  1958,  2357,  2369,
     363,  5010,  2359,   409,  2367,  2376,  1150,  2384,  2390,  2392,
    2394,  2226,  2402,  2403,  2227,  2405,   680,  2410,  2412,  2228,
    3661,  4046,  1958,  1112, -2624,  2229,  2434,  2218,  2414,  2435,
    2436,  2438,  2470,  2439,  2440,  2442,  2441,  2223,  2476,  2497,
    2443,   920,  3926,  1958,  1232,  2464,  2501,  3670,  2504,  2230,
    2263,  2503,  2507,  2505,  2506,   411,  1958,  2523,  2522,  2524,
    2534,  2544,  4010,  2545,  2547,  2550,  2557,  2551,   831,  1113,
     680,  4021,   680,  2548,  2549,  2558,  2559,  2560,  2561,  1354,
    2582,  2565,  2293,  2295,   680,  1113,   680,  1354,  1354,  2572,
    2589,  2566,  4045,  4632,  2574,  2578,  2579,  2590,  5075,  2596,
    2597,  1807,  2607,  2601,  2608,  2618,  3670,   825,   825,   825,
    2619,  5016,  2623,  2620,   670,  2646,   824,   824,   824,  2629,
    1958,  2624,  2632,  4716,  4166,  4167,  4168,  4169,  2659,  2647,
    1353,  2661,  4873,  2675,  2662,   680,  1958,  2672,  4817,  2160,
    2171,  2177,  2674,  2688,  4663,  4822,  2692,  2691,  2695,  1958,
     893,  2231,  4828,  2696,  2699,  2232,  2703,  1851,  2718,  2723,
    2738,  2739,  2746,  2751,  4954,   680,  2752,  2753,  4999,  2759,
    2770,   679,  1695,  2772,  2774,    74,  2233,  2234,  2749,  1198,
    2788,  2773,   680,  2775,  4130,  1695,  5002,  2789,  2813,  2830,
    5006,  2836,  5008,  2235,  2814,  2845,  1012,  2886,  1012,   680,
    1012,  2859,   680,  4500,  4446,  2887,  1012,  1434,  1435,  2929,
    2942,  2892,  2930,  2948,  2225,  2952,  2953,  2985,  1198,  2236,
    2960,  1958,  2237,  2966,  2983,   409,  3000,  3001,  1198,  1012,
    1012,  3014,  3034,  3042,  1198,  2238,  1198,  3032,  2239,  3053,
    3031,  1958,  1198,  3037,  3039,  1198,  1198,  1198,  1198,  1198,
    1198,  1198,  1198,  1198,  1198,   825,  3043,  3062,  1198,  1198,
     931,  1118,  3054,  3064,   824,  3065,  1958,  3063,  3093,  3073,
    3095,  1198,  3096,  2273,  1772,  1198,  3110,   411,  3111,  1198,
    3113,  3123,  3124,  3125,  3136,  3141,  3144,  3146,  3148,  1198,
     831,  3149,  1198,  4876,  1198,  3155,  3160,  3171,  3165,  3166,
    3175,  3168,  1958,  1198,  1198,  1198,  1773,  3179,  3190,  1198,
    3187,  3208,  1198,  2240,  1607,  3203,  3263,  1611,  3258,  3264,
    3272,  3276,  3275,  2599,  3288,  3327,  1198,  3330,  1198,  3341,
    3352,  3348,  3349,  3353,  3354,  3356,  3357,  1695,  5067,  3358,
    1198,  3359,  3360,  3366,  3368,  3380,  1198,  1198,  3375,  3377,
    3381,  3388,  1012,  4928,  3382,  3383,  3408,  3422,  3424,  3437,
    4959,  3431,  1774,  3440,  3445,  2137,  3446,  3447,  3448,  3458,
    3456,  1718,  3461,  3479,  3473,  3476,  3481,  3477,  3478,  3482,
    3496,  3491,  3497,  4836,  3494,  3052,  2863,  3506,  3507,  3508,
    2667,  1198,  2062,  3509,  1775,  3518,   363,  1198,  3511,  4330,
    2860,  3526,  3529,  1198,  3532,   363,  2241,  2242,  2243,  2350,
    2244,  2245,  2246,  2247,  2248,  2249,  3256,  1012,  4305,  1958,
    1452,  3534,  3537,  3540,  3538,  4858,   363,  3541,  3542,  3560,
    1776,  3607,  2797,  2864,  3556,  1198,  1353,  3557,  1232,  3626,
    2224,  3559,  3561,  2225,  3595,  3564,  3565,  3567,  3641,  3621,
    3570,  4853,   409,  3588,  2714,  3648,  3594,   409,  3634,   409,
    1777,  3596,  2865,  5194,  3678,  3644,   680,  3597,  2228,  3713,
    3604, -1001,  3720,  3619,  2229,  3725,  3646,   825,  3672,  3647,
    1232,  3729,  3723,  2866,  3751,  4625,   824,  3620,  1778,  3757,
    3677,  3739,  3762,  3760,  2867,  3740,  3763,  4380,  2230,  3735,
    3741,  3744,  2068,  3771,   411,  3774,  3776,  3798,  3745,   411,
    1958,   411,  3783,  4640,  2868,  4689,  3767,   831,  3768,  2869,
    3799,  1779,   831,  3810,   831,   208,  3809,  3814,  3815,  1780,
    3824,  3826,  4655,  3839,  3865,  1781,  3866,    80,   409,  3869,
      80,  3872,  1782,  3871,  1212,  3873,  3880,  3881,  3882,  3883,
    1783,  3884,  3885,   680,  3887,  3886,   680,  3888,  3889,  1784,
    3891,  3890,  3892,  3893,  3894,  2870,  3895,  1785,  3902,  3898,
    3904,  3900,  2616,  3912,  3918,  3919,  3938,  3906,  3937,  2387,
    4674,  3922,  3950,  3946,  3992,  3951,  2871,  3989,  3982,  3994,
     411,  2214,  3983,  3996,  4004,  4005,    74,    74,  4016,    74,
    2231,  4013,  4011,   831,  2232,  4173,  4017,  4176,  4020,  4043,
    4062,  4023,  4052,  4063,  4054,  1012,  4064,  4073,  4065,  1786,
    4068,  4074,  4075,  4086,  2157,  2233,  2234,  4091,  3591,  3573,
    1198,  3590,  2219,  4474,  4121,  4149,  4221,  4122,  4150,  1695,
    1119,  4137,  2235,  4123,  4175,  4129,   859,  4202,  2904,  4197,
    4162,  4242,  4249,   680,   680,  4270,  4199,  1958,  4285,  4158,
     680,  4213,  4183,  4286,  4211,  4272,  4273,  4284,  4287,  4298,
    4311,  2237,  1014,  2872,  1014,  4045,  1014,  5086,  4235,  2873,
    4212,  4312,  1014,  4313,  2238,  2874,  4314,  4337,  4326,  4344,
    4218,  3670,  4703,  3670,  1958,  1198,  1198,  4214,  1133,  4217,
    4289,  4324,  4327,  4325,   825,  1014,  1014,  4360,  4328,   825,
    4329,   825,  4338,   824,  2875,  4362,  2876,  4293,   824,  4365,
     824,  4606,  4373,  4371,  4374,  4399,  2389,  4397,  4435,  4424,
    4432,  4035,  4440,  2877,  4442,  4452,  2137,  2818,  4451,   680,
    4469,  4447,  4471,  4454,  4472,  4486,  4455,  4488,  4482,  4483,
    4496,  4490,  4501,  4503,  5083,  4505,  4506,  1198,  2878,  4507,
    4508,  4509,  2240,  4514,  3036,  1353,  4517,  4527,  4526,  4565,
    4566,  4521,  4573,  4522,  4530,  4528,  4529,  4604,  4534,  4578,
    4594,  4579,  4602,  4550,  4560,  4598,  2224,  4561,  4563,  2225,
     825,  4576,  4607,  4605,  1198,  4613,  4581,  4582,  4612,   824,
    3670,  4636,  4621,  4583,  1198,  1198,  2226,  1958,  4644,  1232,
    1012,  4637,  1198,  1198,  2228,  1012,  1012,  1198,  1958,  4645,
    2229,  4665,  4643,  1198,  1198,  4670,  4656,  1198,  1014,  4638,
    1198,  4659,  4698,  4701,  4709,  4677,  4717,  4722,  4595,  4729,
    4727,  4733,   677,   677,  2230,  4735,  4746,  1723,  4754,  4755,
    4744,  1198,  4752,  4763,  4771,  1198, -2682, -2682,  4779,  2244,
    2245,  2246,  2247,  2248,  2249,  1695,   679,  1198,  4789,  4787,
    4811,  4780,  1198,  4782,  4790,  4791,  4792,  1198,  4798,  1213,
    4804,  4814,  1726,  4830,    80,  1236,    80,  4846,  4842,  2385,
    4820,  1435,  4860,  1014,  4826,  4855,  1252,  4845,  4869,  4870,
    4861,  4874,  4881,    81,  4888,   409,  4891,  4431,  4896,  2399,
    4898,  4901,  4922,  4921,  4899,  4902,  2406,  2408,  4903,  4930,
    1198,  4920,  4926,  4924,  1313,  4947,  4955,  4931,  1320,  4962,
    4958,  4967,  4991,  4973,  4993,  5005,  4977,  5021,  1958,  1330,
    4983,  2920,  4711,  5026,  5030,  5031,  2231,  5033,  5036,  5035,
    2232,  5041,  5048,  5049,   680,  2943,  5050,   411,  5055,  5061,
    5056,  5065,  5073,  5077,  5078,  5066,  1958,   363,  5079,  5081,
     831,  2233,  2234,  1012,  5090,  5094,  5000,  5102,  5103,  5111,
     680,  1012,  5100,  1606,  5106,  1958,  5108,  5116,  2235,  5117,
    5123,  5124,   680,  5139,  4163,  2137,  5148,  5146,  5153,  5157,
    5165,  5104,  5164,  5197,  5183,   680,  5105,  5169,  5214,   363,
    4590,  5217,  5223,  1131,  2236,   409,  2630,  2237,  1830,  5227,
     410,  1794,  1855,  3426,  2306,  3705,  3262,  1854,  3821,  4303,
    2238,  3897,    79,  1958,  3921,  1012,  3571,  3572,  1012,  1012,
    3340,  3587,  4377,  5012,  4875,  5101,  4923,  4925,   680,  4443,
    4714,  4911,  3765,  3505,  5149,  5192,  4834,  5109,  5163,  5107,
    5044,  3770,  4439,  3406,  3407,  4301,  3833,   411,  3389,  2715,
    2224,  2137,  4000,  2225,  5196,  2137,  2137,  5228,  5224,  4900,
    3925,  3622,  3623,  3947,  4859,  5167,  2698,  5096,  5154,  4862,
    4502,  1014,  1198,  1031,  2129,  4978,  4478,  4479,  2228,  3752,
    5054,  2141,  3116,  1198,  2229,  3901,  1012,  5176,  2240,  5225,
    3047,  2803,  1621,  3710,  3048,  4461,  4596,  2076,  4231,  3501,
    1355,  2325,  3711,  1643,  3072,  3363,  2354,  3721,  2230,  3719,
    3661,  2353,  3071,  3363,  3661,  3734,  2358,  4178,  3722,  4559,
    4969,  4571,  1629,  5072,  2363,  4174,  5071,  4232,  4141,  4953,
    4131,  1958,  5142,  5138,  5143,  3639,  3714,   825,  3551,  4228,
    3637,  1164,  4044,  3016,  3475,  2755,   824,  3097,  2016,  5131,
    2375,  1134,   363,   680,  2368,  1403,  3088,  1695,  1707,  1708,
    3104,  2136,  3700,  3101,  4586,  1198,  3102,  4238,  4237,  1958,
    3432,   670,   670,  4216,  1198,  1736,  2272,  2372,  1157,  2815,
    3108,  2241,  2242,  2243,  3503,  2244,  2245,  2246,  2247,  2248,
    2249,  1198,  1198,  2065,  2754,  1198,  3670,    83,  3460,     0,
    3670,     0,     0,  1441,  1354,     0,     0,     0,  1198,  2224,
    2231,     0,  2225,  1198,  2232,     0,     0,     0,  1198,     0,
       0,  1198,     0,     0,     0,     0,  1198,  1198,     0,     0,
       0,     0,     0,     0,  4827,  2233,  2234,  2228,     0,  4380,
       0,  1354,     0,  2229,     0,    74,     0,     0,    74,     0,
       0,     0,  2235,   680,     0,   680,     0,     0,   370,  1198,
       0,     0,     0,     0,   370,     0,  1014,  2230,     0,   673,
    3466,  1014,  1014,     0,     0,     0,     0,     0,  2236,     0,
     409,  2237,     0,     0,     0,     0,     0,     0,     0,  1772,
       0,  1958,   680,     0,  2238,     0,     0,   370,     0,     0,
       0,  1198,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1773,  4915,     0,     0,     0,     0,     0,     0,  3624,
       0,     0,   411,     0,   680,     0,     0,     0,     0,     0,
       0,     0,   370,     0,     0,   831,     0,  1198,     0,  2893,
    2894,     0,     0,     0,     0,   677,     0,  2906,     0,     0,
       0,  2909,  2910,     0,  4824,     0,     0,     0,     0, -2682,
       0,     0,  2240,  2232,     0,     0,  2931,  1774,  2932,     0,
       0,     0,     0,     0,     0,  2921,     0,     0,  1054,     0,
       0,     0,     0,     0,  2233,  2234,  1054,     0,  1054,  2921,
    2954,     0,  2955,  1198,     0,  1958,     0,     0,     0,  1775,
     370, -2682,     0,     0,     0,     0,     0,     0,     0,     0,
    1695,     0,     0,     0,     0,     0,     0,  1198,  1958,  1014,
    1198,     0,  1198,     0,     0,     0,     0,  1014,  3467,     0,
    2237,     0,     0,     0,     0,  1776,   409,     0,  4719,     0,
    3005,     0,     0,  2238,  2399,  1198,     0,     0,     0,  1198,
       0,     0,     0,     0,  1958,  2241,  2242,  2243,     0,  2244,
    2245,  2246,  2247,  2248,  2249,  1777,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1354,
       0,  1014,  3661,     0,  1014,  1014,     0,  3661,   411,     0,
    3661,     0,     0,     0,  1958,     0,     0,     0,  1958,  1958,
       0,   831,     0,     0,     0,  5042,     0,     0,  1012,     0,
       0,     0,     0,  2048,     0,     0,     0,     0,     0,     0,
       0, -2682,   825,     0,  2063,  2224,     0,     0,  2225,     0,
     208,   824,     0,     0,  1780,     0,     0,     0,     0,  1198,
    1781,     0,     0,     0,     0,     0,     0,  1782,     0,     0,
       0,   370,  1014,  2228,     0,  2516,     0,     0,  1198,  2229,
    1012,     0,     0,  3670,  1784,     0,     0,     0,  3670,  5213,
       0,     0,  1785,  3670,     0,     0,  3670,     0,  1958,     0,
    1718,     0,    74,  2230,    74,  5060,   370,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1198,     0,     0,  1198,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1354,     0,     0,     0,  3670,     0,     0,     0,  2244,  2245,
    2246,  2247,  2248,  2249,  1786,     0,     0,     0,  3469,  4035,
       0,  1198,     0,     0,     0,     0,     0,  2920,  2920,     0,
       0,     0,  2920,     0,     0,  1772,   363,     0,     0,     0,
       0,     0,     0,   680,     0,     0,  4857,     0,     0,     0,
       0,     0,     0,  4099,     0,     0,  4104,  4105,  4106,  4107,
    4108,  4109,  4110,  4111,  4112,  4113,     0,  1773,     0,  1198,
       0,     0,  2920,  2920,     0,  2231,     0,  3838,   825,  2232,
    1198,     0,     0,     0,   670,   367,     0,   824,  5178,  5179,
    5168,  5180,  1212,     0,     0,     0,  1198,  1198,     0,     0,
    2233,  2234,     0,  5181,  5204,     0,     0,   680,     0,     0,
       0,     0,     0,     0,  3868,  4153,  4154,  2235,  3661,  1198,
       0,     0,     0,  1774,     0,     0,     0,     0,     0,   367,
       0,     0,  5178,  5179,     0,  5180,     0,     0,     0,     0,
       0,     0,     0,  1012,     0,   409,  2237,  5181,  3670,     0,
       0,  1012,     0,  1012,  5204,  1775,     0,     0,     0,  2238,
    1198,     0,  5204,  3899,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1198,     0,   367,     0,     0,  5178,
    5179,  2224,  5180,     0,  2225,  3363,     0,     0,  3363,  3363,
       0,  1776,  3363,     0,  5181,   409,     0,   411,  3363,     0,
       0,     0,     0,   409,  3670,     0,     0,  3935,     0,  2228,
     831,     0,     0,  3944,     0,  2229,     0,     0,     0,     0,
    3935,  1777,     0,     0,     0,     0,     0,     0,     0,   363,
       0,     0,     0,     0,  1354,     0,  1354,  2240,     0,  2230,
    3384,     0,  1198,     0,     0,     0,     0,   411,     0,     0,
       0,  1198,     0,     0,     0,   411,     0,     0,     0,     0,
     831,     0,     0,     0,  2628,     0,     0,     0,   831,     0,
       0,     0,  4003,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   208,     0,  2515,     0,
    1780,     0,     0,     0,  5032,     0,  1781,     0,  4030,  1354,
       0,  3635,     0,  1782,     0,     0,     0,     0,   371,     0,
       0,  2516,     0,     0,   371,     0,     0,     0,     0,   674,
    1784,     0,     0,     0,     0,     0,  5205,     0,  1785,     0,
    2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,
       0, -2682,     0,     0,     0,  2232,     0,   371,     0,     0,
       0,     0,     0,     0,  3670,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2704,  2233,  2234,     0,     0,
       0,     0,     0,     0,  1014,     0,  5205,     0,     0,     0,
    1786,  2628,     0, -2682,  5205,     0,     0,     0,     0,     0,
    1012,     0,   371,     0,     0,     0,   370,   825,     0,     0,
     370,     0,     0,     0,     0,     0,   824,     0,     0,     0,
       0,     0,  2237,     0,   673,     0,     0,     0,     0,  2769,
     673,     0,     0,     0,   363,  2238,  1014,     0,     0,     0,
     677,   673,     0,     0,  5119,     0,     0,   363,     0,     0,
       0,  4427,  2628,     0,     0,  3670,  1723,   825,     0,     0,
       0,     0,  4142,     0,     0,   825,   824,     0,     0,   673,
     371,     0,     0,   673,   824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   673,     0,     0,  2224,     0,     0,
    2225,  5212,     0,     0,  5152,     0,     0,     0,     0,     0,
       0,  2921,  2921,     0,     0,     0,  2921,  2226,     0,     0,
     673,     0,     0, -2682,     0,  2228,     0,     0,     0,     0,
       0,  2229,     0,     0,     0,   673,     0,     0,     0,     0,
     673,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     673,     0,     0,     0,     0,  2230,  2921,  2921,     0,     0,
       0,     0,     0,  2761,   673,     0,     0,     0,     0,     0,
    2224,     0,  2767,  2225,     0,     0,  2771,     0,     0,     0,
       0,     0,  2777,  2778,     0,     0,     0,     0,     0,     0,
    2226,     0,     0,     0,  2478,     0,     0,     0,  2228,     0,
    2790,     0,     0,     0,  2229,     0,     0,     0,     0,     0,
       0,     0,  2399,     0,     0,  3703,     0,  1012,     0,     0,
    2244,  2245,  2246,  2247,  2248,  2249,     0,  2479,  2230,     0,
       0,   371,     0,     0,     0,     0,  5226,     0,     0,  1014,
    2480,     0,     0,  4538,  4539,     0,     0,  1014,     0,  1014,
       0,     0,     0,  2481,     0,     0,  1054,  2231,   673,     0,
    1054,  2232,     0,     0,     0,     0,   371,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   370,
       0,     0,  2233,  2234,     0,     0,     0,     0,     0,     0,
       0,  2482,  2224,     0,  3935,  2225,     0,     0,     0,  2235,
       0,     0,  2483,     0,  2920,     0,     0,  2920,  2920,  2920,
    2920,  2920,  2920,  2920,  2920,  2920,  2920,     0,  4331,     0,
    2228,  4332,  2484,  4333,     0,  2236,  2229,  2485,  2237,     0,
    2231,     0,     0,     0,  2232,     0,     0,  4128,     0,     0,
       0,  2238,     0,     0,  2239,     0,   673,   673,     0,     0,
    2230,     0,     0,     0,     0,  2233,  2234,     0,     0,     0,
       0,     0,     0,     0,  3363,  3466,  2920,  2920,     0,     0,
    3363,  3363,  2235,  2667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1772,     0,     0,     0,     0,     0,
       0,     0,     0,  3944,  2486,     0,     0,     0,  2236,   670,
       0,  2237,     0,     0,  4411,  4413,  4415,  4417,     0,     0,
       0,     0,  4155,     0,  2238,     0,  1773,  2239,     0,  2240,
       0,     0,  1054,  1054,     0,  2487,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3126,
       0,     0,     0,     0,  3130,     0,     0,  3133,     0,     0,
       0,     0, -2682,     0,   859,     0,  2232,     0,  3044,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3156,
       0,     0,  1774,     0,     0,  4477,     0,  2233,  2234,     0,
       0,     0,     0,     0,     0,     0,  1014,  2488,     0,     0,
       0,     0,  2240,  2489, -2682,     0,  2490,     0,     0,     0,
       0,     0,     0,     0,  1775,     0,     0,     0,     0,     0,
    3206,     0,  2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,
    2248,  2249,  2491,  2237,  3040,     0,     0,  3212,  2492,     0,
    3041,     0,     0,  3467,     0,     0,  2238,     0,  4512,     0,
    1776,  2493,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3247,     0,  1012,     0,   673,     0,     0,
    3939,  3942,     0,     0,     0,     0,  2494,     0,  1012,     0,
    1777,     0,   673,     0,     0,     0,     0,     0,     0,  3278,
       0,     0,     0,  3289,     0,  2241,  2242,  2243,     0,  2244,
    2245,  2246,  2247,  2248,  2249,   673,     0,  4215,     0,  3988,
       0,  3301,     0,     0,     0,     0,     0,     0,     0,   844,
       0,     0,  3311,     0, -2682,     0,  4778,     0,     0,     0,
       0,     0,     0,     0,     0,  3335,     0,     0,     0,     0,
       0,   673,     0,     0,  3342,   208,     0,     0,     0,  3468,
       0,     0,  4794,  4795,     0,  1781,   673,     0,     0,     0,
       0,     0,  1782,     0,     0,   845,     0,     0,     0,   673,
    2516,     0,   673,  4585,     0,  4591,  4592,     0,   846,  1784,
       0,     0,     0,     0,     0,     0,     0,  1785,     0,     0,
       0,     0,     0,     0,     0,   847,   371,    80,     0,     0,
     371,   848,  2920,  1014,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   674,     0,   849,     0,     0,     0,
     674,  2244,  2245,  2246,  2247,  2248,  2249,   850,     0,     0,
    1012,   674,     0,     0,     0,   851,     0,     0,     0,  1786,
       0,     0,     0,  3469,     0,     0,     0,   852,     0,     0,
       0,     0,   853,     0,     0,     0,     0,     0,   854,   674,
       0,     0,     0,   674,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   855,   674,     0,     0,     0,  2921,     0,
       0,  2921,  2921,  2921,  2921,  2921,  2921,  2921,  2921,  2921,
    2921,     0,     0,     0,     0,     0,     0,   673,   856,     0,
     674,     0,     0,  1797,     0,   673,   673,     0,     0,  1798,
       0,  2921,     0,     0,     0,   674,   370,     0,     0,   857,
     674,     0,     0,     0,     0,  4672,  4673,     0,     0,     0,
     674,     0,     0,     0,     0,  3363,  3363,     0,     0,     0,
    2921,  2921,  1354,     0,   674,     0,  4691,     0,     0,  1799,
     858,  3517,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3944,  3944,  3944,  3944,  3944,     0,     0,   370,
     370,   370,     0,     0,  3517,     0,     0,     0,     0,   859,
       0,     0,     0,     0,  2920,  2920,     0,     0,  4950,   673,
       0,     0,     0,     0,     0,     0,     0,     0,  1800,     0,
       0,     0,     0,     0,     0,  1801,   860,     0,  1802,     0,
     861,     0,   862,     0,     0,  3483,     0,  4737,   863,   370,
       0,   864,     0,     0,     0,     0,   370,  4234,     0,     0,
       0,  3492,  3493,   370,     0,  3495,     0,     0,   674,     0,
    1054,  3499,     0,     0,  4756,     0,   865,   866,     0,   867,
       0,     0,     0,   868,     0,     0,     0,     0,     0,   371,
       0,   869,  1803,     0,     0,     0,   870,     0,  4512,  4512,
    4512,  4512,     0,  1054,     0,     0,     0,     0,   871,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   872,     0,  3466,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3535,  1772,     0,     0,     0,     0,     0,     0,  1804,
       0,  1805,     0,     0,     0,  2224,   674,   674,  2225,     0,
       0,  1806,  1012,     0,     0,     0,     0,     0,     0,  1807,
       0,  1014,     0,     0,  1773,  2226,     0,     0,     0,  1808,
       0,     0,     0,  2228,  1014,  1012,     0,     0,     0,  2229,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   673,
       0,  1054,     0,     0,     0,  2224,     0,     0,  2225,     0,
       0,     0,  1809,  2230,     0,  1810,  1811,     0,     0,     0,
       0,     0,     0,     0,     0,  2226,     0,     0,     0,     0,
    1774,     0,     0,  2228,     0,  3935,     0,     0,     0,  2229,
       0,  1812,     0,     0,     0,     0,     0,     0,  1434,  1435,
       0,     0,     0,     0,     0,     0,     0,  4394,     0,     0,
       0,  3942,  1775,  2230,     0,     0,     0,     0,  3754,  3363,
       0,     0,  4410,     0,     0,     0,     0,     0,  1354,     0,
     370,     0,  4879,     0,  4880,     0,     0,     0,  4885,  4886,
       0,  3467,     0,     0,     0,     0,  2921,     0,  1776,  1813,
     673,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3777,     0,     0,     0,     0,  2231,   673,     0,     0,  2232,
       0,     0,     0,     0,     0,     0,     0,     0,  1777,     0,
       0,     0,     0,     0,     0,     0,  1014,     0,     0,     0,
    2233,  2234,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   673,   673,     0,   672,  2235,     0,     0,
       0,     0,     0,     0,   673,  2231,     0,   674,     0,  2232,
       0,     0,     0,     0,     0,     0,   673,   673,     0,     0,
       0,     0,   674,  2236,   822,     0,  2237,  2920,  1012,     0,
    2233,  2234,     0,   208,     0,     0,  4786,  1780,   673,  2238,
       0,     0,  2239,  1781,     0,   674,     0,  2235,  3844,     0,
    1782,     0,     0,  2920,  2920,     0,     0,     0,  2516,     0,
    3863,     0,     0,     0,     0,     0,     0,  1784,     0,   822,
       0,     0,     0,  2236,  3775,  1785,  2237,     0,     0,     0,
       0,   674,     0,     0,     0,     0,     0,     0,     0,  2238,
       0,     0,  2239,     0,     0,     0,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  5013,     0,     0,   674,
       0,     0,   674,     0,     0,  1053,     0,  2240,  2921,  2921,
       0,     0,     0,  1053,     0,  1053,     0,  1786,     0,     0,
       0,  3469,     0,  3908,     0,     0,     0,   822,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3825,     0,  3827,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2240,     0,     0,
       0,     0,  2224,  2399,     0,  2225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   370,     0,     0,
       0,     0,     0,     0,     0,    74,     0,     0,     0,     0,
    2228,     0,     0,  1012,     0,     0,  2229,     0,     0,     0,
    2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,
       0,     0,     0,     0,     0,     0,  3566,     0,     0,     0,
    2230,     0,     0,     0,     0,     0,     0,   674,     0,     0,
       0,     0,     0,     0,     0,   674,   674,  1354,  3896,     0,
       0,     0,     0,     0,  3903,  1012,   371,     0,     0,     0,
    2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,
       0,     0,     0,     0,  2951,  4653,  4654,     0,  1014,   370,
    4657,  4658,  2628,     0,     0,     0,     0,     0,     0,  2920,
       0,     0,  4156,     0,     0,     0,     0,     0,     0,  4069,
       0,  1014,     0,     0,     0,     0,     0,     0,     0,   371,
     371,   371,     0,     0,     0,     0,     0,  2224,     0,  4081,
    2225,     0,     0,     0,     0,     0,     0,     0,     0,   674,
       0,     0, -2682,   370,     0,   370,  2232,  2226,     0,     0,
    1012,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,  2229,     0,     0,   673,     0,     0,  2233,  2234,   371,
    3942,  3942,  3942,  3942,  3942,     0,   371,     0,  1012,     0,
       0,     0,     0,   371, -2682,  2230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   673,     0,     0,     0,   370,   673,
    4047,  5206,   673,  2237,  4050,  4051,     0,  4053,     0,  4055,
    4056,     0,     0,     0,     0,     0,  2238,     0,  4061,     0,
       0,     0,     0,     0,   673,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  5206,     0,  4080,     0,     0,     0,     0,     0,  5206,
       0,     0,     0,     0,     0,   673,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1054,  2231,     0,     0,
       0,  2232,   673,   673,     0,     0,     0,     0,     0,     0,
       0,  2921,     0,     0, -2682,     0,     0,     0,     0,     0,
    2921,     0,  2233,  2234,  1014,     0,     0,   370,   673,   674,
       0,   370,     0,     0,     0,     0,     0,  2921,  2921,  2235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   673,     0,     0,     0,   673,     0,
       0,     0,     0,  2224,     0,  2236,  2225,  4823,  2237,     0,
       0,     0,     0,     0,     0,     0,   673,     0,     0,     0,
       0,  2238,     0,  2226,  2239,     0,  1797,   673,     0,     0,
       0,  2228,  1798,     0,     0,  1199,  1201,  2229,     0,  1204,
     673,  1206,     0,  4279,     0,     0,     0,     0,     0,   673,
     371,  2244,  2245,  2246,  2247,  2248,  2249,  1835,     0,     0,
    1250,  2230,     0,  1012,     0,     0,     0,     0,     0,     0,
     674,     0,  1799,     0,     0,     0,     0,     0,     0,     0,
    1302,     0,     0,     0,  1305,     0,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2240,
       0,  1328,     0,  1836,     0,     0,     0,     0,     0,     0,
       0,   370,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1800,     0,   674,   674,     0,     0,     0,  1801,     0,
    4349,  1802,     0,  4352,   674,     0,     0,     0,     0,  1014,
       0,     0,     0,     0,     0,     0,   674,   674,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2231,     0,     0,     0,  2232,   674,     0,
       0,     0,   673,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1837,     0,     0,  1803,     0,     0,  2233,  2234,
       0,  1014,  2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,
    2248,  2249,     0,   822,     0,  2235,     0,     0,  3614,   673,
       0,  1216,     0,  2921,     0,     0,     0,     0,     0,  1240,
       0,   672,     0,     0,     0,     0,     0,   672,  1254,     0,
    1838,  2236,  1839,     0,  2237,     0,  1264,  4449,   672,     0,
       0,  1297,  1840,     0,  1805,     0,     0,  2238,     0,     0,
    2239,     0,     0,     0,  1806,     0,   673,     0,     0,     0,
       0,     0,  1807,     0,     0,     0,   672,     0,     0,     0,
     672,  1841,  1808,     0,     0,     0,  1014,     0,     0,   673,
       0,   672,     0,     0,     0,  1797,     0,     0,     0,     0,
       0,  1798,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1014,  1842,     0,   672,  1810,  1811,
    1843,     0,     0,     0,     0,     0,  3517,   371,     0,     0,
       0,     0,   672,     0,     0,  2240,     0,   672,     0,     0,
       0,  1799,     0,     0,  1844,     0,     0,   672,     0,     0,
       0,     0,     0,     0,     0,  1845,     0,     0,     0,     0,
    2224,   672,     0,  2225,     0,     0,     0,     0,     0,     0,
       0,     0,   370,     0,     0,     0,     0,  5058,   370,     0,
    2226,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
    1800,     0,     0,     0,  2229,     0,     0,  1801,     0,     0,
    1802,     0,  1813,     0,     0,     0,     0,  1470,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2230,   371,
    1821,  1822,     0,     0,     0,     0,     0,     0,  2241,  2242,
    2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,     0,  4491,
       0,  1599,  3936,     0,     0,     0,     0,  4494,  4495,     0,
       0,     0,     0,  1053,  1803,   672,     0,  1053,     0,     0,
    1623,     0,     0,     0,     0,     0,     0,   673,     0,     0,
       0,     0,     0,   371,     0,   371,     0,     0,     0,     0,
       0,     0,  1649,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   674,  1915,     0,     0,     0,  2224,
       0,     0,  2225,     0,     0,     0,     0,     0,     0,     0,
       0,  1804,     0,  1805,     0,     0,  1973,  1974,     0,  2226,
    2231,     0,     0,  1806,  2232,     0,     0,  2228,     0,     0,
       0,  1807,     0,  2229,   674,     0,  2005,     0,   371,   674,
       0,  1808,   674,   672,   672,  2233,  2234,     0,     0,  1014,
       0,     0,     0,   673,     0,     0,     0,  2230,     0,     0,
       0,     0,  2235,     0,   674,     0,     0,  4650,   673,   673,
       0,     0,     0,  2038,  2040,     0,     0,  1810,  1811,  4660,
       0,     0,     0,     0,  1820,     0,     0,     0,  2236,     0,
       0,  2237,     0,     0,     0,   673,     0,     0,   673,  5203,
       0,     0,     0,  1812,  2238,   674,     0,  2239,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1053,
    1053,     0,   674,   674,     0,     0,     0,     0,     0,  1797,
       0,     0,     0,     0,     0,  1798,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   371,   674,  5203,
       0,   371,     0,     0,     0,     0,     0,  5203,  4624,  2231,
    1835,  1813,     0,  2232,     0,     0,     0,     0,     0,   370,
     370,   370,     0,     0,   674,  1799,  1971,     0,   674,     0,
       0,     0,  2240,     0,  2233,  2234,     0,     0,     0,  4641,
    4642,     0,     0,   673,     0,     0,   674,     0,  1999,  2002,
    2003,  2235,     0,     0,     0,   673,  1836,   674,     0,     0,
       0,     0,     0,     0,   673,     0,     0,     0,     0,     0,
     674,     0,     0,     0,  1800,     0,     0,  2236,     0,   674,
    2237,  1801,     0,     0,  1802,     0,     0,     0,     0,     0,
       0,     0,     0,  2238,     0,     0,  2239,     0,     0,     0,
       0,     0,     0,     0,   672,     0,  4675,  4676,     0,     0,
    3517,     0,     0,     0,     0,     0,     0,     0,     0,   672,
       0,     0,     0,     0,     0,  2241,  2242,  2243,   673,  2244,
    2245,  2246,  2247,  2248,  2249,  1837,     0,     0,  1803,  4093,
       0,   371,   672,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1599,   370,     0,     0,
       0,  2240,     0,     0,     0,     0,     0,     0,   672,     0,
       0,     0,   673,  1838,   673,  1839,     0,     0,     0,     0,
       0,     0,     0,   672,  1599,  1840,   673,  1805,   673,     0,
       0,     0,   674,  5059,     0,     0,   672,  1806,     0,   672,
    3517,     0,  3517,     0,     0,  1807,     0,     0,  2224,     0,
       0,  2225,     0,     0,  1841,  1808,     0,     0,     0,     0,
    4767,     0,  4768,  4769,     0,     0,     0,     0,  2226,   674,
       0,     0,     0,     0,  4772,     0,  2228,   673,     0,     0,
       0,     0,  2229,     0,     0,     0,     0,     0,  3291,     0,
       0,  1810,  1811,  1843,  2241,  2242,  2243,     0,  2244,  2245,
    2246,  2247,  2248,  2249,     0,     0,  2230,   673,  4140,     0,
       0,     0,     0,     0,     0,     0,   674,  3292,     0,     0,
       0,     0,     0,     0,   673,     0,     0,     0,  1845,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   674,
       0,   673,     0,     0,   673,     0,     0,     0,     0,     0,
       0,  2224,     0,     0,  2225,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,     0,     0,  2310,     0,
       0,  2226,   672,   672,     0,  1813,     0,     0,     0,  2228,
       0,     0,     0,   822,     0,  2229,  2546,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2231,  2230,
       0,     0,  2232,     0,     0,     0,  2364,     0,     0,   370,
       0,     0,   371,     0,     0,     0,     0,     0,   371,     0,
       0,     0,     0,  2233,  2234,     0,   822,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2611,  2612,  2613,  2614,
    2235,     0,     0,     0,     0,     0,   672,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2236,     0,     0,  2237,
       0,     0,     0,     0,     0,     0,     0,     0,  2650,  2651,
       0,     0,  2238,     0,  2660,  2239,     0,     0,     0,     0,
     822,     0,     0,     0,     0,     0,     0,  1053,     0,     0,
       0,  2231,     0,     0,     0,  2232,     0,   674,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2233,  2234,     0,  2684,
    1053,     0,  2525,  4949,     0,     0,     0,     0,     0,  2543,
       0,     0,     0,  2235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2719,  2720,  2721,  2722,
    2240,     0,     0,     0,     0,     0,     0,  2577,     0,  2236,
    2580,     0,  2237,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2238,     0,     0,  2239,     0,
       0,  4980,     0,   674,     0,     0,     0,     0,   673,     0,
       0,     0,     0,     0,     0,     0,  2615,     0,   674,   674,
       0,     0,     0,     0,     0,     0,  2781,     0,     0,     0,
    2631,     0,     0,     0,     0,  2785,   672,     0,  1053,     0,
       0,  5011,  2792,     0,  2643,   674,   370,     0,   674,     0,
       0,   370,     0,   370,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2241,  2242,  2243,     0,  2244,  2245,  2246,
    2247,  2248,  2249,  2240,     0,     0,     0,  4220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   673,     0,     0,   673,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3517,     0,     0,   822,     0,   371,
     371,   371,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   370,     0,     0,     0,  1797,   672,     0,     0,
       0,     0,  1798,   674,  2735,     0,     0,     0,     0,     0,
    2745,     0,     0,   672,     0,   674,     0,     0,  2224,     0,
       0,  2225,     0,     0,   674,     0,  2241,  2242,  2243,     0,
    2244,  2245,  2246,  2247,  2248,  2249,     0,     0,  2226,     0,
    4251,     0,  1799,     0,     0,     0,  2228,     0,     0,     0,
     672,   672,  2229,     0,     0,   673,   673,     0,     0,     0,
       0,   672,   673,     0,     0,     0,     0,     0,     0,     0,
    2964,     0,     0,   672,   672,     0,  2230,     0,     0,     0,
       0,  2800,     0,     0,     0,     0,     0,     0,   674,     0,
       0,  1800,     0,     0,     0,   672,     0,     0,  1801,     0,
       0,  1802,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   371,  1599,  1599,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   673,   674,     0,   674,     0,     0,  2855,     0,     0,
       0,     0,     0,     0,     0,  1803,   674,     0,   674,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5189,     0,     0,     0,  2231,     0,
       0,  2224,  2232,     0,  2225,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2226,     0,  2233,  2234,     0,     0,   674,     0,  2228,
       0,     0,  1804,     0,  1805,  2229,     0,     0,     0,     0,
    2235,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,  1807,     0,     0,     0,     0,   674,     0,  2230,
       0,     0,  1808,     0,   822,     0,  2236,     0,     0,  2237,
       0,     0,     0,     0,   674,     0,     0,     0,     0,     0,
    2224,     0,  2238,  2225,  3013,  2239,     0,     0,     0,     0,
       0,   674,     0,     0,   674,  1859,     0,     0,  1810,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,  2228,  3033,
       0,     0,     0,     0,  2229,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1860,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2230,     0,
    3172,  3173,  3174,     0,     0,     0,  3046,     0,  3049,  3184,
       0,  3186,     0,  3188,  3189,     0,     0,     0,     0,     0,
    2240,  2231,     0,     0,     0,  2232,     0,     0,     0,   371,
       0,     0,     0,     0,     0,     0,   673,     0,     0,   370,
       0,     0,  1813,     0,     0,  1599,  2233,  2234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4159,     0,   673,  2235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   673,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   673,     0,  2236,
       0,   672,  2237,     0,     0,     0,     0,     0,     0,     0,
   -2682,     0,     0,     0,  2232,  2238,     0,     0,  2239,  3296,
       0,     0,     0,  2241,  2242,  2243,     0,  2244,  2245,  2246,
    2247,  2248,  2249,     0,     0,  2233,  2234,  4515,     0,     0,
     673,   672,     0,     0,     0,   822,   672,     0,     0,   672,
       0,     0, -2682,     0,     0,     0,     0,     0,     0,   370,
       0,     0,  2224,     0,     0,  2225,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,  3355,     0,     0,     0,
       0,  2237,  2226,     0,  3364,     0,     0,     0,     0,  3365,
    2228,     0,     0,  2240,  2238,     0,  2229,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,     0,     0,     0,
    2230,     0,     0,  1053,     0,     0,     0,     0,   674,   672,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3238,  2224,     0,     0,  2225,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   822,   672,     0,  3265,   822,     0,
       0,  2226,     0,     0,     0,   673,   371,     0,     0,  2228,
    3450,   371, -2682,   371,     0,  2229,     0,  2224,     0,     0,
    2225,   672,     0,     0,     0,   672,  2241,  2242,  2243,     0,
    2244,  2245,  2246,  2247,  2248,  2249,     0,  2226,     0,  2230,
    4549,     0,  3486,   672,  3488,  2228,     0,     0,     0,     0,
       0,  2229,     0,     0,   672,   674,     0,  2224,   674,     0,
    2225,     0,  2231,     0,     0,     0,  2232,   672,     0,     0,
       0,     0,     0,     0,     0,  2230,   672,  2226,     0,     0,
       0,     0,     0,     0,     0,  2228,     0,  2233,  2234,     0,
       0,  2229,   371,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2235,   673,     0,   673,     0,  2244,
    2245,  2246,  2247,  2248,  2249,  2230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2236,     0,     0,  2237,     0,     0,     0,  3425,   822,     0,
       0,  2231,     0,     0,   673,  2232,  2238,     0,     0,  2239,
    3543,     0,     0,     0,     0,   674,   674,     0,     0,     0,
       0,     0,   674,     0,     0,     0,  2233,  2234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2231,     0,     0,
       0,  2232,     0,  2235,   370,     0,   673,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   672,
       0,     0,  2233,  2234,     0,     0,     0,     0,     0,  2236,
       0,     0,  2237,     0,     0,     0,     0,  2231,     0,  2235,
       0,  2232,     0,     0,  2240,  2238,     0,     0,  2239,     0,
       0,     0,     0,     0,     0,     0,   672,     0,     0,     0,
       0,   674,  2233,  2234,     0,  2236,     0,     0,  2237,     0,
       0,     0,     0,     0,     0,     0,     0,   718,     0,  2235,
       0,  2238,     0,     0,  2239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   672,     0,  2236,     0,     0,  2237,     0,
       0,     0,     0,     0,     0,   718,     0,     0,     0,     0,
       0,  2238,     0,  2240,  2239,     0,   672,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   718,  2241,  2242,  2243,
       0,  2244,  2245,  2246,  2247,  2248,  2249,     0,     0,     0,
       0,  4788,     0,  2224,  1023,     0,  2225,     0,     0,  2240,
       0,     0,     0,     0,     0,     0,     0,  1024,     0,     0,
     370,     0,     0,  2226,     0,  1032,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,     0,     0,  2229,     0,     0,
    1043,     0,  1023,     0,     0,     0,  1066,     0,     0,  2240,
       0,     0,     0,     0,     0,     0,  1097,     0,     0,   822,
       0,  2230,     0,     0,  1102,   822,  2241,  2242,  2243,     0,
    2244,  2245,  2246,  2247,  2248,  2249,     0,     0,     0,     0,
    4797,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1797,     0,     0,     0,     0,
       0,  1798,  2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,
    2248,  2249,     0,     0,  3654,     0,  4832,  3784,     0,  3785,
    3786,  3787,     0,     0,     0,     0,   674,     0,     0,   371,
       0,     0,     0,     0,     0,     0,     0,  1953,     0,     0,
       0,  1799,  2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,
    2248,  2249,   674,     0,   672,     0,  4894,     0,     0,     0,
       0,     0,     0,  2231,   674,     0,     0,  2232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   674,     0,     0,
       0,     0,     0,     0,  2224,   673,     0,  2225,  2233,  2234,
    1800,     0,     0,     0,     0,     0,     0,  1801,     0,     0,
    1802,     0,     0,     0,     0,  2235,     0,     0,     0,     0,
       0,     0,  2228,     0,     0,     0,     0,     0,  2229,     0,
     674,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2236,     0,     0,  2237,     0,     0,     0,     0,   371,
     672,     0,  2230,     0,     0,     0,     0,  2238,     0,   673,
    2239,     0,     0,     0,  1803,   672,   672,  1797,     0,     0,
       0,     0,     0,  1798,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,   672,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,  1799,  4547,     0,     0,     0,     0,     0,
       0,  1804,     0,  1805,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1806,     0,  2240,     0,     0,     0,     0,
       0,  1807,     0,     0,     0,     0,     0,     0,     0,   370,
       0,  1808,     0,     0, -2682,   674,     0,     0,  2232,     0,
       0,     0,  1800,     0,     0,     0,   822,   822,   822,  1801,
       0,     0,  1802,     0,     0,     0,     0,     0,     0,  2233,
    2234,     0,     0,     0,  1885,     0,     0,  1810,  1811,     0,
     672,     0,     0,     0,  1797,     0, -2682,     0,     0,   370,
    1798,     0,   672,  1797,     0,     0,     0,   370,     0,  1798,
       0,   672,     0,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2237,  1803,     0,  2241,  2242,
    2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,  2238,     0,
    1799,  4057,  5118,     0,  4058,     0,     0,     0,     0,  1799,
       0,     0,     0,     0,     0,   674,  2292,   674,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,   672,     0,     0,     0,   718,
       0,     0,     0,  1804,     0,  1805,     0,     0,     0,  1800,
       0,     0,  4085,     0,   674,  1806,  1801,     0,  1800,  1802,
       0,     0,     0,  1807,     0,  1801,     0,     0,  1802,     0,
       0,     0,     0,  1808,   822,     0, -2682,     0,     0,     0,
       0,     0,     0,     0,  3980,  3981,     0,     0,     0,   672,
       0,   672,     0,     0,   371,     0,   674,     0,     0,     0,
    3990,     0,     0,   672,     0,   672,  2498,     0,     0,  1810,
    1811,     0,     0,  1803,  3999,     0,     0,     0,  1797,     0,
       0,     0,  1803,  4008,  1798,  2224,     0,     0,  2225,     0,
       0,     0,     0,     0,     0,  2499,     0,  4024,     0,     0,
       0,     0,     0,  1953,     0,  2226,     0,     0,     0,     0,
       0,     0,     0,  2228,   672,     0,     0,     0,     0,  2229,
       0,     0,     0,     0,  1799,     0,     0,     0,     0,     0,
    1804,     0,  1805,  2244,  2245,  2246,  2247,  2248,  2249,  1804,
       0,  1805,  1806,  2230,   672,     0,     0,     0,     0,     0,
    1807,  1806,     0,  1813,     0,     0,     0,  1953,     0,  1807,
    1808,   672,     0,     0,     0,     0,     0,     0,  1599,  1808,
       0,     0,     0,  1800,     0,     0,     0,     0,   672,     0,
    1801,   672,     0,  1802,     0,     0,     0,     0,     0,  1953,
       0,     0,     0,  2562,     0,     0,  1810,  1811,     0,     0,
       0,     0,  3215,     0,     0,  1810,  1811,  1194,  1200,  1200,
     718,     0,  1200,     0,  1208,     0,  1194,     0,  1097,     0,
     371,  1234,  2563,     0,     0,     0,  1097,     0,     0,  1097,
       0,  1812,     0,  1200,     0,  1097,     0,  1803,     0,     0,
       0,     0,     0,  1266,     0,  2231,     0,     0,  1097,  2232,
    1194,     0,     0,  1200,     0,   718,   822,  1200,     0,  4274,
    4275,  4276,  4277,     0,  1234,     0,  1953,  1323,     0,     0,
    2233,  2234,     0,     0,  1200,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,     0,  1953,     0,  2235,     0,  1813,
       0,  4170,  4171,  4172,  1804,     0,  1805,     0,     0,     0,
       0,     0,     0,  1953,     0,     0,  1806,  1194,     0,     0,
       0,     0,   718,  2236,  1807,     0,  2237,  1194,     0,     0,
       0,  1234,     0,     0,  1808,     0,     0,     0,     0,  2238,
       0,  1953,  2239,     0,  1797,     0,  1200,     0,     0,     0,
    1798,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3304,     0,  2224,
    1810,  1811,  2225,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2226,
    1799,     0,     0,  3055,     0,   674,  3305,  2228,     0,     0,
       0,  1097,     0,  2229,  1953,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1097,  1471,     0,  2240,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2230,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1800,
    4425,     0,     0,  1581,     0,     0,  1801,   718,  1097,  1802,
       0,     0,     0,     0,  1813,   672,  1797,     0,     0,   674,
       0,     0,  1798,     0,     0,     0,     0,  1097,     0,     0,
       0,  1097,  3056,     0,     0,     0,     0,     0,     0,  1581,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1097,
       0,     0,     0,   822,     0,     0,     0,     0,   822,     0,
     822,  1097,  1799,  1803,     0,     0,     0,     0,     0,     0,
    2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,
       0,     0,     0,     0,  5215,     0,     0,     0,     0,  2231,
       0,     0,     0,  2232,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,   672,     0,     0,     0,   371,
       0,  1800,     0,     0,  2233,  2234,     0,     0,  1801,     0,
    1804,  1802,  1805,     0,     0,     0,     0,     0,     0,     0,
       0,  2235,  1806,     0,     0,     0,     0,     0,     0,   822,
    1807,     0,     0,  1097,     0,     0,     0,     0,     0,     0,
    1808,  1097,     0,  1200,  1200,  4407,     0,  2236,     0,   371,
    2237,  1953,     0,     0,     0,     0,     0,   371,     0,     0,
       0,     0,     0,  2238,  4433,  1803,  2239,     0,     0,  1797,
       0,     0,     0,  3343,     0,  1798,  1810,  1811,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1194,  4450,   672,   672,     0,     0,     0,     0,     0,   672,
       0,  1194,  3344,     0,     0,  1234,     0,     0,     0,     0,
    2224,     0,     0,  2225,     0,  1799,     0,     0,  1200,     0,
       0,     0,  1804,     0,  1805,     0,     0,     0,     0,     0,
    2226,     0,     0,  1097,  1806,     0,     0,     0,  2228,  1200,
    1200,  2240,  1807,     0,  2229,     0,     0,  2224,     0,     0,
    2225,     0,  1808,     0,     0,  1097,  1097,  1097,     0,  1200,
    1813,  1194,     0,     0,  1800,  2013,     0,  2226,  2230,     0,
       0,  1801,     0,     0,  1802,  2228,     0,     0,   672,  2224,
       0,  2229,  2225,     0,     0,  3803,     0,     0,  1810,  1811,
       0,     0,  3057,     0,  1200,     0,  1200,  1200,     0,  2226,
       0,     0,  3553,     0,     0,  2230,     0,  2228,     0,     0,
       0,     0,     0,  2229,  3804,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1803,     0,
    1581,     0,     0,     0,  2241,  2242,  2243,  2230,  2244,  2245,
    2246,  2247,  2248,  2249,     0,     0,  1953,     0,     0,  3590,
    1953,  1953,     0,     0,  3591,     0,     0,     0,     0,     0,
       0,     0,  4554,  4555,  4556,  4557,     0,     0,  2112,  2112,
    2231,     0,  1813,  1097,  2232,  1023,  4668,     0,     0,     0,
       0,     0,     0,     0,     0,  1804,     0,  1805,     0,     0,
    4671,     0,     0,     0,     0,  2233,  2234,  1806,  2147,     0,
       0,  1097,     0,     0,  2153,  1807,     0,  2231,     0,     0,
       0,  2232,  2235,     0,     0,  1808,  1581,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2233,  2234,     0,     0,     0,     0,  2236,  2231,
       0,  2237,     0,  2232,     0,  1581,     0,     0,  3846,  2235,
       0,  1810,  1811,     0,  2238,     0,  1953,  2239,     0,     0,
       0,     0,     0,     0,  2233,  2234,     0,     0,     0,     0,
       0,     0,     0,  1581,  1581,  2236,  1581,  3847,  2237,     0,
       0,  2235,     0,     0,     0,     0,     0,     0,     0,  4739,
       0,  2238,     0,   672,  2239,  1581,   822,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2236,     0,     0,
    2237,     0,     0,     0,  4132,     0,   718,   718,     0,   672,
       0,     0,     0,  2238,     0,     0,  2239,     0,     0,     0,
       0,   672,  2240,     0,     0,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,   672,  1097,     0,     0,  1581,     0,
       0,  2224,     0,     0,  2225,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2240,
       0,  2226,     0,     0,     0,     0,     0,  1581,     0,  2228,
       0,  1581,  1581,  4133,     0,  2229,     0,   672,     0,     0,
       0,     0,  1097,  1097,  2366,     0,     0,     0,     0,     0,
    1953,  2240,     0,     0,     0,     0,     0,     0,     0,  2230,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     718,     0,     0,     0,     0,  2241,  2242,  2243,     0,  2244,
    2245,  2246,  2247,  2248,  2249,     0,     0,     0,     0,     0,
       0,     0,     0,  4837,  4839,  4839,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,
    2248,  2249,     0,     0,     0,  1953,     0,     0,     0,     0,
       0,     0,  4762,     0,     0,     0,     0,     0,     0,  5186,
       0,     0,     0,     0,  2241,  2242,  2243,     0,  2244,  2245,
    2246,  2247,  2248,  2249,     0,     0,     0,     0,     0,     0,
       0,  2231,   672,     0,     0,  2232,     0,     0,     0,  1097,
    2530,     0,     0,     0,     0,     0,  1097,     0,     0,  1200,
       0,     0,     0,     0,     0,     0,  2233,  2234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1234,     0,
       0,     0,     0,  2235,  1097,     0,     0,  1097,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1953,     0,     0,     0,     0,  2236,
       0,  1097,  2237,     0,  4935,     0,     0,     0,     0,  1200,
    1200,  1200,  1200,  1097,     0,  2238,     0,     0,  2239,     0,
       0,     0,     0,     0,     0,     0,     0,  1097,     0,     0,
       0,     0,   672,     0,   672,     0,  5187,     0,     0,  2642,
       0,  1097,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1200,  1200,     0,     0,     0,     0,  1200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4984,     0,
       0,     0,     0,  2240,     0,     0,     0,     0,     0,     0,
       0,     0,  1200,     0,     0,     0,     0,     0,     0,     0,
       0,   822,     0,   672,     0,     0,     0,  5007,     0,  5009,
       0,     0,     0,     0,     0,  4892,     0,     0,     0,  1200,
    1200,  1200,  1200,     0,     0,     0,     0,     0,     0,     0,
       0,  1097,     0,     0,     0,     0,     0,  1097,     0,     0,
    2642,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1599,     0,     0,  1194,     0,     0,     0,     0,
       0,     0,   718,     0,  1194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1234,     0,  2241,  2242,  2243,  1200,
    2244,  2245,  2246,  2247,  2248,  2249,     0,     0,  1200,     0,
       0,     0,     0,     0,  1200,  1200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1097,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4839,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2112,     0,     0,     0,     0,  1953,  4987,  1200,
    1953,  1194,  1953,     0,     0,  1097,  1097,  1953,  1200,     0,
       0,     0,     0,     0,  1097,     0,     0,   822,     0,     0,
       0,     0,     0,     0,  1097,     0,  5115,     0,     0,     0,
       0,  1023,  1023,     0,     0,  2862,     0,     0,     0,  1581,
    1581,     0,     0,     0,     0,     0,     0,  1581,     0,     0,
    1581,     0,     0,     0,  1581,     0,     0,  1953,     0,     0,
       0,     0,  1581,  1581,     0,     0,     0,     0,     0,     0,
    1581,     0,  1234,  1581,  1581,  1581,  1581,     0,     0,     0,
       0,     0,     0,  1581,  1581,     0,  1581,     0,  1581,  1581,
    5156,     0,  1581,     0,     0,     0,     0,  1953,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1581,
       0,     0,     0,  1200,  1581,     0,     0,     0,  1581,     0,
       0,     0,  1581,     0,  1581,  1581,  1581,  1581,  1581,  1581,
    1581,  1581,  1581,     0,  1581,     0,     0,     0,     0,     0,
       0,  1097,     0,  5195,  1581,  1581,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1953,     0,
    1953,     0,     0,     0,     0,     0,  1097,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1945,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1097,     0,  1097,     0,  1581,     0,     0,
       0,     0,     0,     0,     0,  1953,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
    1953,     0,  1097,     0,     0,     0,   672,     0,  3079,     0,
    3086,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,  1953,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,  1953,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,   718,     0,     0,     0,
       0,  1023,     0,  1023,     0,     0,   822,     0,  1953,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1581,     0,     0,     0,  1953,     0,  1945,     0,     0,     0,
       0,  1194,     0,  1200,  1200,  1200,    46,  1953,  1194,     0,
    1234,     0,  1200,     0,  1200,     0,  1200,  1200,     0,     0,
    1097,     0,     0,     0,     0,     0,   822,     0,     0,     0,
       0,     0,     0,     0,   822,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2530,
       0,     0,     0,     0,     0,     0,  3220,     0,     0,     0,
       0,  3229,     0,     0,     0,     0,     0,  1097,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,  1953,
       0,     0,     0,     0,  1097,     0,     0,     0,  3270,  3270,
       0,     0,     0,     0,    48,   718,     0,     0,     0,  1953,
       0,  2224,     0,     0,  2225,     0,     0,     0,     0,     0,
       0,     0,  1200,     0,    49,     0,     0,     0,     0,     0,
       0,  2226,     0,     0,  1953,     0,     0,     0,     0,  2228,
       0,     0,     0,     0,     0,  2229,    50,     0,     0,  3329,
       0,  3332,  3334,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2230,
    1953,     0,     0,     0,     0,     0,     0,     0,     0,  1200,
       0,     0,    51,     0,     0,    52,     0,  1200,     0,     0,
       0,     0,  1200,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,     0,     0,  1581,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2530,
       0,     0,  3270,     0,  1097,     0,  3427,     0,     0,  1023,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3329,     0,     0,     0,     0,
       0,  2231,     0,  1200,  3452,  2232,    54,     0,     0,  1945,
       0,     0,     0,     0,     0,     0,  2013,  1953,     0,     0,
       0,     0,     0,     0,     0,     0,  2233,  2234,     0,     0,
       0,     0,     0,  1200,     0,  1200,  3270,  1200,  3270,     0,
       0,     0,     0,  2235,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1581,     0,    56,  1945,     0,     0,     0,     0,     0,  2236,
       0,     0,  2237,     0,     0,     0,     0,    57,     0,     0,
       0,  2112,     0,     0,     0,  2238,     0,     0,  2239,     0,
       0,     0,     0,     0,     0,  1945,     0,     0,     0,     0,
       0,     0,     0,  3568,     0,    58,     0,     0,  1953,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1396,  1194,     0,     0,     0,
      71,  1397,  1194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1200,     0,     0,     0,     0,     0,  1581,
    1581,     0,     0,     0,     0,  1581,     0,     0,     0,     0,
       0,     0,     0,  2240,     0,     0,     0,     0,     0,     0,
       0,     0,  1945,     0,     0,     0,     0,     0,     0,     0,
    1581,  1581,     0,     0,     0,  1581,     0,     0,     0,     0,
       0,  1945,     0,     0,     0,     0,     0,  1581,  1581,  1581,
    1581,     0,     0,     0,     0,     0,     0,     0,     0,  1945,
    1581,     0,     0,  1581,     0,  1581,  3618,     0,     0,     0,
       0,     0,     0,     0,     0,  1581,  1581,     0,     0,  1581,
       0,     0,     0,     0,     0,     0,     0,  1945,     0,     0,
       0,     0,  1581,     0,  1581,     0,  1234,     0,  1581,     0,
       0,     0,     0,     0,     0,  1953,  2241,  2242,  2243,     0,
    2244,  2245,  2246,  2247,  2248,  2249,     0,  1581,     0,     0,
       0,  1097,     0, -2187,     0,     0,     0,  3671,     0,     0,
    1581,  1581,  1581,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,     0,
    1945,     0,     0,     0,  1581,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1581,     0,     0,
   -2187,     0,  1581,     0,     0,     0,     0,     0,  1581,     0,
       0,     0, -2187,     0,     0,     0,  3671, -2187,     0,  3728,
       0,     0, -2187,  3086,     0,     0,     0, -2187,     0,     0,
   -2187,     0, -2187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    85, -2187,
       0,     0,     0,     0,    89,     0,     0,     0,    93,     0,
      94,     0,    96,    97,     0,     0,     0,     0,     0,     0,
       0, -2187,     0,   106,     0,  1953,     0,  1581,     0,  3270,
       0,     0,     0,     0,  2112,     0,  1953,     0,     0,     0,
     119,   120,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2187,     0,
    1200,     0,  1200,  1200,  1200,     0, -2187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,   130,   131,
    1955,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1130, -2187,     0,     0,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   141,     0,   142,   143,     0,     0,     0,
       0,   146,     0,   147,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   149,     0,   150,  1953,     0,     0,  1027,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   153,
       0,   154,     0,     0,   157,     0,     0,     0,     0,     0,
       0,     0,     0, -2187,  1953,     0,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   161,     0,
       0,     0,     0,  1953,     0,     0,   163, -2187,   165, -2187,
   -2187,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   171,
       0,     0,     0,     0,     0,     0,     0,   830,     0,     0,
       0,  3270,  3270,     0, -2187,     0,     0, -2187, -2187,     0,
   -2187,  1953,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1955,  3943,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   830,     0,   184,   185,     0,     0,     0,     0,
     186,  1097,  1097,     0,     0,     0,     0,     0,     0,   187,
       0,     0,     0,     0,     0,     0,     0,  1097,     0,     0,
     192,     0,  1945,     0,     0,     0,  1945,  1945,     0,     0,
    2112,  1097,     0,     0,     0,     0,     0,     0,  1057,  2112,
    1097,     0,     0,     0,     0,     0,  1057,     0,  1057,     0,
       0,     0,     0,     0,  1097,     0,     0,     0,   202,     0,
     830,     0,     0,     0,     0,     0,     0,     0,     0,   718,
     204,     0,     0,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,   208,  1200,     0,     0,  1200,   209,     0,
       0,   211,     0,     0,     0,   213,     0,     0,     0,     0,
     214,   215,     0,     0,  1194,     0,     0,     0,   216,     0,
       0,   218,     0,     0,     0,     0,     0,  1953,     0,   221,
       0,     0,     0,     0,     0,  1097,     0,     0,     0,     0,
       0,   223,  1945,     0,     0,  1200,     0,     0,     0,     0,
       0,     0,     0,  1581,     0,     0,     0,     0,   228,     0,
     229,     0,     0,  1581,     0,     0,     0,     0,   231,  1581,
       0,  1581,     0,     0,   232,     0,     0,  1581,     0,   233,
    1581,  1581,  1581,  1581,  1581,  1581,  1581,  1581,  1581,  1581,
       0,     0,   236,  1581,  1581,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1581,     0,     0,     0,
    1581,     0,     0,     0,  1581,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1581,     0,     0,  1581,   246,  1581,
       0,     0,  -138,     0,     0,     0,     0,     0,  1581,  1581,
    1581,     0,     0,     0,  1581,     0,     0,  1581,     0,  1953,
    2224,  4165,     0,  2225,     0,     0,  2430,     0,  1097,  1097,
    1097,  1194,     0,  3671,  4182,     0,     0,     0,  4182,  4196,
    2226,     0,     0,  3598,     0,  1581,     0,     0,  2228,     0,
       0,  1581,  1581,     0,  2229,     0,  1945,  2224,     0,     0,
    2225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,  2230,     0,
    2430,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,  2229,     0,     0,     0,     0,  1581,     0,     0,     0,
       0,     0,  1581,     0,     0,     0,  3086,     0,  1581,     0,
       0,     0,  1955,     0,     0,  2230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1945,     0,  1953,     0,     0,     0,     0,     0,     0,
    4257,  2112,  2112,     0,  2642,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1953,     0,     0,     0,
       0,     0,  1200,  1200,  1200,  1200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2231,     0,     0,     0,  2232,     0,     0,     0,     0,  1955,
       0,     0,  1953,     0,     0,     0,     0,     0,     0,  4300,
       0,  3603,     0,     0,     0,  2233,  2234,     0,  2430,     0,
       0,     0,     0,     0,     0,     0,     0,  2231,     0,     0,
       0,  2232,  2235,     0,     0,     0,  1955,     0,     0,     0,
    1945,     0,  1953,     0,     0,     0,  1953,  1953,     0,     0,
       0,     0,  2233,  2234,     0,     0,     0,     0,  2236,     0,
       0,  2237,     0,     0,  1955,     0,     0,     0,     0,  2235,
       0,     0,     0,     0,  2238,     0,     0,  2239,     0,     0,
       0,     0,     0,     0,     0,  4366,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2236,     0,     0,  2237,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2238,     0,     0,  2239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3943,     0,     0,  1955,     0,     0,
       0,     0,  1097,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1200,     0,  1581,     0,     0,     0,     0,
       0,  1097,  2240,     0,     0,     0,     0,  4438,     0,     0,
       0,     0,     0,     0,     0,     0,  2530,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1097,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3329,  2240,
       0,     0,     0,     0,  4467,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1581,  1581,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3270,     0,  3270,     0,     0,
       0,     0,     0,     0,     0,  2241,  2242,  2243,     0,  2244,
    2245,  2246,  2247,  2248,  2249,     0,   830,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,  1581,  1196,     0,     0,     0,     0,     0,     0,
       0,     0,  2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,
    2248,  2249,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1945,     0,     0,  1945,  1196,  1945,  1581,
       0,     0,     0,  1945,     0,     0,     0,     0,     0,  1581,
    1581,     0,     0,     0,  1955,     0,     0,  1581,  1581,     0,
       0,     0,  1581,     0,     0,     0,     0,     0,  1581,  1581,
       0,     0,  1581,     0,     0,  1581,  4553,     0,     0,  1097,
    1097,  1097,  1097,     0,     0,     0,  4182,  4196,     0,  4182,
       0,  3026,  4562,  1945,  1196,     0,  3671,     0,     0,     0,
    3671,     0,     0,     0,  1196,  1947,  4575,   944,     0,     0,
       0,     0,  1581,     0,     0,     0,     0,  1581,     0,   945,
       0,     0,  1581,     0,     0,     0,     0,     0,     0,     0,
       0,  1234,     0,  1945,     0,     0,     0,     0,     0,  3728,
     946,     0,     0,  3086,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   947,     0,     0,     0,     0,     0,     0,
       0,     0,  1023,     0,     0,  1581,   948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   949,     0,  3270,  3270,     0,     0,     0,
       0,     0,     0,     0,  1945,     0,  1945,     0,     0,     0,
       0,     0,     0,     0,   950,     0,     0,     0,     0,  4639,
       0,     0,     0,     0,     0,   951,     0,     0,     0,     0,
    1196,     0,     0,   952,     0,     0,  1057,     0,     0,     0,
    1057,     0,     0,     0,     0,   953,     0,     0,     0,     0,
     954,     0,     0,     0,     0,     0,   955,     0,     0,  3112,
       0,  1945,     0,  2430,  3118,     0,  1196,     0,     0,  1200,
       0,   956,     0,     0,     0,     0,     0,     0,  1947,     0,
       0,     0,     0,  1200,     0,     0,  1945,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   957,     0,     0,
    1945,     0,     0,  3943,  3943,  3943,  3943,  3943,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1581,   958,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1194,   959,
       0,     0,     0,  2530,     0,     0,     0,     0,     0,  1955,
    2112,     0,     0,     0,     0,     0,     0,   859,     0,     0,
       0,     0,  1200,  2530,  1945,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1945,     0,  1057,  1057,   960,     0,     0,     0,   961,  1097,
     962,  4766,     0,  1945,  2224,     0,   963,  2225,     0,   964,
       0,     0,     0,     0,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,  2226,     0,     0,  3609,  1196,     0,
    1581,     0,  2228,     0,     0,   965,     0,   966,  2229,  1581,
       0,   967,     0,     0,     0,     0,     0,     0,     0,   968,
       0,  1956,     0,     0,   969,     0,  1581,  1581,     0,     0,
    1581,     0,  2230,     0,     0,     0,   970,     0,     0,     0,
       0,     0,     0,  1194,  4182,  1945,     0,     0,  3671,   971,
       0,     0,     0,  3671,     0,     0,  3671,  3329,  1196,  4816,
       0,  1581,  1581,     0,     0,  1945,     0,     0,     0,     0,
       0,     0,     0,  1955,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1945,     0,     0,     0,  4257,  1234,  1200,  1200,  1200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1947,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1945,  1196,     0,     0,
       0,     0,     0,     0,  2231,     0,  1194,  1234,  2232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2430,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2233,
    2234,     0,     0,     0,     0,  1947,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2235,  2112,  2112,     0,
       0,     0,  1194,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,  1097,     0,     0,     0,     0,  1947,     0,     0,
       0,     0,  2236,  4438,     0,  2237,     0,     0,     0,     0,
    3270,     0,     0,  1196,  2530,     0,     0,     0,  2238,     0,
       0,  2239,     0,     0,     0,     0,  4467,     0,     0,  1097,
       0,     0,     0,     0,     0,     0,     0,  1200,  4257,     0,
       0,     0,  1196,  1945,     0,     0,     0,  1955,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1581,     0,     0,  1581,     0,  1581,     0,     0,
    1196,  1196,     0,  1196,  1947,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1581,     0,  1196,  1947,  3671,     0,  2240,  4816,     0,     0,
       0,     0,     0,  4976,     0,     0,     0,     0,     0,     0,
       0,  1947,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1200,     0,     0,     0,  1097,     0,     0,     0,     0,
       0,     0,     0,     0,  1945,     0,     0,     0,     0,  1947,
       0,     0,     0,     0,     0,  1196,   830,     0,     0,  1200,
    1200,  1200,  1200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2112,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,  1196,  1196,
       0,     0,     0,     0,  1194,     0,     0,     0,     0,  2241,
    2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,     0,
       0,     0,  1947,  1581,  2224,     0,     0,  2225,     0,     0,
       0,     0,     0,     0,     0,     0,  3026,  3026,  3026,     0,
       0,     0,     0,     0,  2226,     0,     0,     0,     0,     0,
       0,     0,  2228,     0,     0,     0,     0,     0,  2229,     0,
       0,  1581,     0,     0,  1194,     0,     0,     0,     0,     0,
       0,     0,     0, -2189,     0,     0,     0,  1956,     0,     0,
       0,     0,  2230,   830,  1200,     0,  1234,     0,     0,     0,
    1057,     0,     0,     0,     0,     0,  1581,     0,     0,     0,
       0,  1945,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2189,     0,     0,  1057,     0,     0,     0,     0,     0,     0,
    2430,  1956, -2189,  3118,     0,  3118,     0, -2189,  1945,  1200,
    2430,     0, -2189,     0,  1194,     0,     0, -2189,     0,     0,
   -2189,     0, -2189,     0,     0,  4257,     0,     0,     0,     0,
       0,     0,     0,  1956,  4766,     0,     0,     0,     0,     0,
       0,  1581,  1581,     0,     0,     0,  3329,     0,     0, -2189,
    4976,     0,     0,     0,  2231,     0,     0,     0,  2232,     0,
    1955,     0,     0,     0,  1194,     0,     0,     0,     0,     0,
       0, -2189,     0,  1200,     0,     0,     0,     0,     0,  2233,
    2234,     0,     0,     0,     0,     0,     0,     0,     0,  1947,
       0,  1057,     0,     0,     0,     0,  2235,     0,     0,     0,
    2430,     0,     0,     0,     0,  1581,     0,     0, -2189, -2202,
    1956,     0,     0,     0,     0,     0, -2189,     0,     0,  1581,
       0,  1945,  2236,     0,     0,  2237,  1200,     0,     0,  1956,
       0,     0,  1945,     0,     0,     0,     0,     0,  2238,     0,
       0,  2239,     0,     0,     0,     0,     0,  1956,     0,     0,
       0,     0,     0,     0,     0,     0, -2202,     0,     0,     0,
       0,  1955,     0,  1955, -2189,     0,     0,     0, -2202,     0,
     830,     0,     0, -2202,     0,  1956,     0,     0, -2202,     0,
       0,     0,     0, -2202,     0,     0, -2202,  1581, -2202,     0,
       0,     0,     0,     0,     0,     0,  1194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1027,
       0,     0,     0,     0,     0, -2202,  2240,     0,  1955,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196, -2189,     0,     0,     0, -2202,  1956,     0,
       0,  1196,  4089,  1955,     0,  2224,     0,     0,  2225,     0,
       0,     0,  1945,     0,     0,     0,     0, -2189,     0, -2189,
   -2189,     0,     0,     0,  3118,  2226,     0,     0,  4139,     0,
       0,     0,     0,  2228, -2202,     0,     0,  3118,     0,  2229,
    1945,     0, -2202,     0,  1947,     0,     0,     0,  1947,  1947,
       0,     0,     0,     0, -2189,     0,     0, -2189, -2189,  1945,
   -2189,     0,     0,  2230,     0,     0,     0,     0,     0,  2241,
    2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
   -2202,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1955,     0,     0,     0,     0,     0,  1945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3118,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,  1196,     0,     0,
    1955,     0,     0,     0,  1196,  1027,     0,  1196,     0,     0,
    1948,  1196,     0,     0,     0,     0,     0,     0,     0,  1196,
    1196,     0,     0,     0,  1947,     0,     0,  1196,     0, -2202,
    1196,  1196,  1196,  1196,     0,  2231,     0,     0,     0,  2232,
    1196,  1196,     0,  1196,     0,  1196,  1196,     0,     0,  1196,
       0,     0,     0, -2202,     0, -2202, -2202,     0,     0,     0,
    2233,  2234,     0,     0,     0,  1956,  1196,   830,     0,     0,
       0,  1196,  1955,     0,     0,  1196,     0,  2235,     0,  1196,
       0,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,  1196,
   -2202,  1196,  1955, -2202, -2202,     0, -2202,     0,     0,     0,
       0,  1196,  1196,  2236,     0,     0,  2237,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1955,     0,  2238,
       0,     0,  2239,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1945,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1955,     0,  2224,     0,     0,  2225,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,  1947,     0,
       0,     0,     0,  1948,     0,  2226,     4,     0,     0,     0,
       0,     0,     0,  2228,     0,     0,     0,     0,     0,  2229,
       0,     0,     0,     0,     0,     0,     5,  2240,  3026,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     0,  2230,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,  1947,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,  1945,     0,    45,     0,     0,
    1956,     0,     0,     0,  1956,  1956,     0,     0,     0,     0,
    2430,     0,     0,     0,     0,     0,     0,     0,   830,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,
       0,     0,     0,     0,     0,    46,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,  2231,     0,     0,  1196,  2232,
       0,     0,     0,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2233,  2234,  1947,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1057,  2235,     0,     0,
       0,  3118,     0,     0,     0,     0,     0,     0,     0,  1945,
    1956,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,  2236,     0,     0,  2237,   830,     0,     0,
       0,   830,  1945,    48,     0,     0,     0,     0,     0,  2238,
       0,     0,  2239,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1945,     0,
       0,     0,     0,     0,     0,    50,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1945,     0,
       0,    51,  1945,  1945,    52,     0,     0,  2240,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1948,     0,     0,     0,     0,     0,     0,     0,  1955,     0,
       0,     0,  1196,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   830,  1948,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2430,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
    2241,  2242,  2243,     0,  2244,  2245,  2246,  2247,  2248,  2249,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1956,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1947,     0,    55,  1947,  1948,
    1947,     0,     0,     0,     0,  1947,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,  1948,     0,
       0,     0,     0,     0,     0,     0,    57,  1196,     0,     0,
       0,     0,  1950,     0,     0,     0,  1948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1955,     0,
       0,     0,     0,     0,    58,  1947,     0,     0,     0,  1955,
       0,    59,     0,     0,  1948,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1396,  2064,     0,     0,  1956,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,  1947,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,  3026,     0,
       0,     0,     0,  3026,     0,     0,  1196,  1196,  3026,     0,
       0,     0,  1196,     0,     0,     0,     0,  1948,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,  1196,     0,
       0,     0,  1196,     0,     0,     0,  1947,     0,  1947,     0,
       0,     0,     0,     0,  1196,  1196,  1196,  1196,     0,     0,
       0,     0,   830,     0,     0,     0,     0,  1196,   830,  1955,
    1196,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,  1196,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1955,     0,  1196,
       0,  1196,     0,  1947,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1955,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,  1947,     0,
       0,     0,     0,     0,  1196,     0,     0,  1196,  1196,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1947,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1055,
       0,  1196,  1947,     0,  1955,     0,     0,  1055,     0,  1055,
     887,     0,     0,     0,  1196,     0,     0,     0,     0,  1196,
       0,     0,   888,     0,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,  1950,     0,     0,     0,     0,
       0,     0,     0,   889,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1948,     0,   890,     0,     0,     0,
       0,     0,     0,     0,     0,   891,  1947,     0,     0,  -753,
       0,  1956,     0,     0,  1956,     0,  1956,     0,     0,     0,
       0,  1956,  1947,     0,     0,     0,   892,     0,     0,  1950,
       0,     0,   893,     0,     0,  1947,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,   894,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   895,     0,
       0,  1950,  4760,     0,     0,     0,   896,     0,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,   897,     0,
       0,     0,     0,     0,     0,   898,     0,     0,     0,   899,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1955,     0,     0,     0,  -955,     0,     0,  1947,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1947,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1950,   830,
     830,   830,     0,   900,     0,     0,     0,     0,     0,     0,
    -520,     0,  1947,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,  1956,  1950,     0,     0,     0,     0,
       0,   901,     0,     0,   902,     0,     0,     0,  1947,  1948,
       0,  1951,     0,  1948,  1948,     0,     0,     0,     0,     0,
       0,     0,     0,  1950,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -417,
       0,     0,  3118,     0,     0,     0,     0,     0,     0,  1956,
       0,     0,     0,     0,     0,     0,     0,   903,     0,     0,
       0,     0,     0,   904,     0,     0,     0,     0,     0,  -417,
       0,     0,   905,     0,  1956,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,  1956,     0,     0,  -417,     0,
     906,   907,     0,   908,   909,     0,     0,   830,  1956,     0,
       0,     0,   910,     0,     0,     0,     0,   911,     0,  1948,
       0,     0,     0,   912,     0,  1947,   913,     0,     0,   914,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -417,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3118,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1956,     0,  1951,     0,     0,     0,     0,  1955,
       0,     0,     0,     0,     0,     0,     0,     0,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1956,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1955,  1947,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1955,     0,     0,     0,  1955,
    1955,     0,     0,  1948,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,  1956,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,  1950,     0,     0,  1196,     0,  1196,     0,
       0,     0,     0,  1956,  1196,     0,     0,  1196,  1196,  1196,
    1196,  1196,  1196,  1196,  1196,  1196,  1196,     0,     0,     0,
    1196,  1196,     0,     0,     0,     0,     0,     0,  1956,     0,
    1267,     0,     0,  1196,     0,     0,     0,  1196,     0,   830,
       0,  1196,     0,     0,     0,     0,     0,     0,  1948,  4760,
       0,  1196,     0,     0,  1196,     0,  1196,     0,     0,     0,
       0,     0,     0,  1268,  1956,  1196,  1196,  1196,     0,     0,
       0,  1196,     0,  1947,  1196,     0,  1269,  1270,     0,     0,
       0,     0,     0,     0,     0,  1271,     0,     0,  1196,  1272,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,     0,     0,  1192,  1273,     0,  1196,  1196,
    1947,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1275,     0,
       0,     0,     0,     0,     0,     0,  1276,  1948,  1192,     0,
       0,     0,     0,  1196,     0,     0,     0,  1951,  1277,  1196,
       0,     0,     0,  1278,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1956,     0,     0,  1279,     0,     0,     0,  1950,     0,
       0,     0,  1950,  1950,     0,     0,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,  1280,
       0,  1951,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,  1947,     0,     0,     0,     0,     0,     0,
    1281,     0,     0,     0,  1947,     0,     0,     0,     0,     0,
       0,     0,     0,  1951,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1282,     0,     0,     0,     0,   830,     0,     0,     0,
       0,   830,  1956,   830,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     859,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1283,     0,     0,
    1951,  1284,     0,  1285,     0,     0,     0,     0,     0,  1286,
       0,  1192,  1287,     0,     0,     0,     0,  1055,     0,  1951,
       0,  1055,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   830,     0,  1947,     0,     0,  1951,  1288,     0,
    1289,     0,     0,     0,  1290,     0,     0,  1192,     0,     0,
       0,     0,  1291,     0,     0,     0,     0,  1292,     0,     0,
       0,     0,  1947,     0,     0,  1951,     0,     0,     0,     0,
       0,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
       0,  1947,  1293,     0,     0,     0,     0,     0,     0,     0,
    1948,     0,     0,  1948,     0,  1948,     0,     0,     0,  1956,
    1948,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1950,     0,     0,     0,     0,     0,  1951,  1947,
       0,     0,     0,     0,     0,     0,  1956,  1196,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1948,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1055,  1055,     0,     0,     0,     0,     0,
    1948,     0,     0,     0,     0,     0,     0,  1950,     0,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,  1196,  1196,     0,  1956,
       0,  1948,     0,  1948,  1196,  1196,     0,     0,     0,  1196,
    1956,     0,     0,     0,     0,  1196,  1196,     0,     0,  1196,
       0,     0,  1196,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,  1947,     0,     0,     0,     0,
       0,     0,     0,  1196,     0,     0,  1950,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1948,  1196,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,  1951,     0,     0,     0,     0,
       0,     0,     0,  1948,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,  1948,     0,     0,     0,     0,     0,
       0,     0,  1196,     0,     0,     0,     0,  1948,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1956,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   830,
       0,     0,     0,     0,     0,  1954,     0,  1947,  1956,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1956,     0,     0,
       0,  1948,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1948,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1948,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1956,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,  1192,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
    1951,  1947,     0,     0,  1951,  1951,     0,     0,     0,     0,
       0,     0,  1948,     0,  1196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1947,  1196,     0,     0,     0,     0,
       0,     0,  1948,     0,     0,     0,     0,     0,     0,  1950,
       0,     0,  1950,     0,  1950,     0,  1192,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,  1948,     0,     0,
    1947,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1956,     0,  1192,     0,     0,     0,  1192,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1948,     0,     0,     0,     0,     0,  1950,
    1947,     0,     0,     0,  1947,  1947,     0,  1196,     0,     0,
    1951,  1956,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,  1196,     0,     0,  1196,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,  1196,     0,     0,  1954,     0,
    1196,     0,     0,  1196,     0,     0,     0,     0,  1196,  1196,
       0,  1055,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1950,  1196,  1950,     0,  1055,     0,     0,     0,     0,     0,
    1948,     0,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1956,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1196,  1954,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1951,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   830,     0,     0,     0,     0,     0,
       0,     0,  1950,     0,     0,     0,     0,     0,     0,  1196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1948,  1055,  1950,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,     0,     0,  1951,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1954,     0,     0,     0,     0,  1196,     0,  1956,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1954,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1196,
    1956,     0,  1196,     0,  1196,     0,     0,     0,     0,     0,
    1950,     0,     0,     0,     0,     0,  1954,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,  1196,     0,     0,
       0,  1196,     0,     0,     0,     0,  1956,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1951,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     830,     0,     0,  1192,     0,     0,  1956,     0,  1948,  1954,
    1956,  1956,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,  1948,     0,     0,     0,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1950,     0,     0,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
    1956,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,     0,     0,  1196,     0,
       0,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1950,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,  1192,     0,
       0,     0,     0,  1196,     0,  1192,     0,     0,  1192,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,  1948,     0,
    1192,  1192,     0,     0,     0,     0,     0,     0,  1192,  1948,
       0,  1192,  1192,  1192,  1192,     0,     0,     0,     0,     0,
       0,  1192,  1192,     0,  1192,     0,  1192,  1192,     0,     0,
    1192,  1196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,     0,     0,     0,  1954,  1192,     0,     0,
       0,     0,  1192,     0,     0,     0,  1192,     0,  1196,  1196,
    1192,     0,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,
    1192,     0,  1192,     0,     0,     0,     0,     0,     0,  1950,
       0,  1196,  1192,  1192,     0,     0,     0,     0,     0,     0,
       0,  1951,     0,     0,  1951,     0,  1951,     0,     0,     0,
       0,  1951,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1196,     0,     0,     0,     0,     0,     0,  1948,
    1952,     0,     0,     0,     0,     0,  1196,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,  1951,     0,     0,     0,     0,     0,  1948,     0,   830,
       0,     0,     0,     0,     0,     0,   930,     0,     0,     0,
    1950,     0,     0,     0,     0,   930,  1948,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1951,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1196,     0,     0,     0,     0,   830,
       0,     0,     0,  1196,   930,     0,     0,   830,     0,     0,
       0,     0,     0,     0,  1948,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,  1954,  1954,     0,  1111,     0,
       0,     0,  1951,     0,  1951,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,  1952,     0,     0,     0,     0,     0,  1192,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,  1951,
       0,     0,     0,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1951,     0,     0,  1055,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,  1950,  1951,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1951,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1948,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1160,
       0,     0,  1951,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1951,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1951,     0,     0,     0,     0,     0,  1950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,  1954,     0,     0,     0,     0,
       0,     0,  1948,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1951,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1951,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1952,     0,     0,     0,
    1954,     0,     0,     0,     0,     0,     0,     0,  1951,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1951,     0,  1948,     0,  1192,     0,
    1952,     0,     0,     0,     0,     0,  1950,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1948,
       0,     0,     0,     0,     0,  1950,     0,     0,     0,     0,
       0,     0,  1952,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,     0,  1948,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
    1192,     0,     0,  1950,   930,   930,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,  1192,     0,
       0,     0,     0,  1192,     0,  1948,     0,     0,     0,  1948,
    1948,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,  1951,     0,     0,     0,     0,     0,     0,  1192,  1192,
       0,     0,  1160,  1192,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,     0,  1192,  1192,  1192,  1192,     0,
       0,     0,     0,     0,     0,     0,  1952,     0,  1192,     0,
       0,  1192,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,  1192,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,  1952,     0,     0,     0,     0,     0,
    1192,     0,  1192,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1951,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,  1192,  1192,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,  1950,
       0,     0,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,  1192,  1207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1237,  1238,  1192,  1241,     0,     0,  1247,
    1192,  1249,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
    1300,     0,     0,     0,     0,     0,     0,     0,  1308,     0,
       0,     0,     0,     0,     0,     0,     0,  1324,  1325,     0,
       0,     0,  1327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,     0,  1954,     0,  1954,     0,  1160,
       0,   930,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1358,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,  1951,
       0,  1950,     0,  1381,     0,     0,  1383,     0,  1385,     0,
    1388,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,   930,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1951,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1468,
       0,  1469,     0,     0,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1160,  1950,     0,     0,     0,     0,
       0,     0,     0,  1954,     0,  1954,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1950,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1951,
    1111,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1951,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,     0,     0,
    1954,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1954,     0,     0,     0,     0,
       0,     0,     0,     0,  1950,     0,     0,     0,  1950,  1950,
       0,  1730,     0,  1732,     0,     0,  1954,  1734,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,     0,     0,     0,  1763,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
    1951,     0,     0,  1952,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1888,     0,     0,
       0,     0,     0,  1954,     0,     0,     0,     0,  1951,     0,
       0,     0,     0,  1901,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,     0,     0,  1911,  1951,     0,     0,
       0,     0,  1954,  1913,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1962,     0,     0,  1966,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1951,     0,     0,     0,     0,
       0,  2009,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,     0,     0,  1954,     0,     0,     0,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,  1192,     0,  1192,
       0,     0,     0,     0,  1954,  1192,     0,     0,  1192,  1192,
    1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,     0,     0,
       0,  1192,  1192,     0,     0,     0,     0,     0,     0,  1954,
       0,     0,     0,     0,  1192,     0,     0,     0,  1192,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,  1192,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,  1954,  1192,  1192,  1192,     0,
       0,     0,  1192,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,  1192,
    1192,  1951,     0,  1952,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1954,     0,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1951,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1111,  2327,     0,     0,
       0,     0,     0,  1954,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2397,     0,     0,  2397,     0,     0,
       0,     0,     0,     0,     0,  2404,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1951,     0,     0,
       0,     0,     0,  2413,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1951,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2496,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1951,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1954,     0,     0,     0,   678,     0,     0,     0,     0,   722,
       0,   722,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   722,     0,     0,     0,     0,  1951,     0,     0,     0,
    1951,  1951,     0,     0,     0,     0,     0,  1954,  1192,  1192,
       0,     0,     0,     0,     0,     0,     0,   722,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   722,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   722,   722,
       0,     0,   722,     0,     0,     0,     0,     0,   722,     0,
       0,     0,  1015,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1192,     0,  1015,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   722,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,  1952,     0,  1952,     0,  1192,     0,     0,
    1952,     0,     0,     0,     0,     0,     0,  1192,  1192,     0,
    1954,     0,     0,     0,     0,  1192,  1192,     0,     0,     0,
    1192,  1954,     0,     0,     0,     0,  1192,  1192,     0,     0,
    1192,  2694,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2717,     0,     0,     0,
    1952,     0,     0,     0,  1192,     0,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
    1192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,  2765,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2780,     0,  2782,
       0,  2783,     0,     0,     0,     0,  2784,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1952,     0,  1952,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2812,     0,     0,     0,  1954,
       0,     0,     0,     0,     0,     0,     0,  2327,     0,     0,
       0,  2327,     0,  2327,     0,     0,  2327,     0,  1954,     0,
       0,     0,   722,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1952,     0,     0,  1954,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1952,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3027,     0,     0,
       0,  1952,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,     0,     0,  1954,     0,     0,     0,     0,     0,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,  1954,     0,     0,     0,     0,  1192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   722,     0,     0,  1192,  1192,     0,     0,  1192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1192,  1952,     0,     0,     0,  1192,     0,     0,     0,
       0,  1192,     0,     0,  1192,     0,     0,     0,     0,  1192,
    1192,     0,  1952,     0,     0,     0,     0,   722,   722,     0,
       0,     0,     0,     0,     0,     0,     0,  1160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3127,  3128,     0,
       0,     0,  3131,  3132,     0,   722,  3135,     0,     0,     0,
       0,     0,     0,  1952,  1954,     0,  3145,     0,     0,     0,
       0,     0,     0,  3154,  1192,     0,     0,  3157,  3158,     0,
       0,  3161,  3162,     0,     0,     0,     0,     0,  3167,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3183,     0,  3185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3207,     0,
    1192,     0,     0,  3209,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3214,     0,     0,     0,
       0,     0,     0,     0,  3219,     0,  3221,  3222,  3225,  3227,
       0,     0,     0,  3234,  3237,     0,     0,     0,     0,     0,
       0,  3248,     0,     0,     0,  3257,     0,     0,     0,  3261,
       0,     0,     0,     0,     0,     0,  1192,     0,  1954,     0,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3290,     0,     0,     0,     0,     0,     0,     0,     0,
    1192,  1954,  3297,  1192,  3299,  1192,     0,     0,     0,  3302,
       0,     0,     0,  3303,     0,  3307,  3308,  3309,  3310,     0,
    3312,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,     0,  1192,  3336,  3337,  3338,     0,  1954,     0,     0,
       0,     0,     0,     0,  3346,  3347,     0,     0,     0,     0,
       0,  1346,   722,     0,   722,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1952,     0,     0,     0,     0,     0,  1954,     0,     0,
       0,  1954,  1954,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   722,  3401,     0,   722,   722,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   678,  1192,  1015,     0,  1015,     0,     0,     0,     0,
       0,   678,     0,     0,     0,   722,     0,     0,     0,     0,
       0,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1015,  1015,     0,     0,     0,     0,
       0,  1954,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   722,     0,   722,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,  1952,     0,
       0,     0,     0,     0,     0,  1160,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,  3528,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,   678,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1192,
    1192,   678,   678,     0,     0,  1712,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1192,  1952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1192,     0,     0,     0,     0,
       0,     0,     0,     0,  1192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3709,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1952,     0,     0,
       0,     0,     0,     0,     0,     0,  3755,  3756,     0,     0,
     678,     0,     0,  1197,     0,   722,  1952,   722,     0,     0,
     722,     0,   722,  2327,     0,   722,   722,   722,     0,     0,
       0,  2107,     0,     0,     0,     0,     0,     0,   722,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3778,     0,
       0,   722,     0,   722,     0,     0,     0,  3782,   722,     0,
       0,     0,     0,     0,  1952,     0,     0,     0,     0,     0,
    1197,     0,  3793,  3795,     0,     0,     0,  3795,     0,     0,
    1197,     0,  3806,  3807,  3808,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3828,  3829,  3830,  3831,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3845,     0,  3849,  3850,
    3851,     0,     0,     0,     0,     0,     0,     0,  3864,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2267,
       0,     0,     0,     0,     0,     0,     0,     0,   722,   722,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,     0,     0,     0,
     678,   678,     0,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,  3905,     0,     0,     0,     0,     0,     0,
       0,  3909,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3977,     0,     0,     0,     0,
       0,     0,   722,     0,   678,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2401,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4006,     0,     0,
    4009,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,  1566,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   930,     0,     0,  4049,     0,     0,     0,   678,     0,
       0,     0,     0,     0,     0,     0,   678,     0,  4059,  1640,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2327,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,     0,     0,
     678,     0,     0,   678,   678,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1952,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,     0,     0,     0,  1952,
    1952,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1957,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,  4268,     0,  4269,     0,
       0,     0,     0,     0,     0,  4271,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,  1197,     0,  1197,
       0,  4280,   722,     0,   722,     0,     0,     0,   722,     0,
     722,     0,     0,   722,     0,     0,  4288,   722,  1197,     0,
       0,     0,  2267,     0,     0,     0,  4299,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4302,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1197,     0,     0,  4334,  4335,  4336,     0,     0,  4339,
    4340,  4341,  4342,  4343,     0,     0,  2162,     0,  4350,  4351,
       0,  4353,  4354,  4355,  4356,  4357,  4358,  4359,     0,     0,
    1197,     0,     0,     0,  1197,  1197,  4367,     0,  4369,  4370,
       0,     0,     0,     0,     0,  2186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2211,  2212,     0,  2215,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4419,  4421,
    4423,     0,     0,  4426,     0,  2257,     0,     0,     0,     0,
       0,     0,     0,  2107,     0,     0,     0,     0,     0,     0,
    3028,     0,     0,  1957,     0,     0,     0,     0,     0,  2401,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,     0,     0,     0,  3795,     0,  2334,     0,     0,
       0,  2346,  2349,   678,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2327,  2327,  2327,     0,  1957,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,     0,     0,   678,
       0,     0,     0,     0,     0,  3100,     0,  1712,     0,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2251,     0,  1957,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1957,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1957,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1957,     0,     0,     0,     0,     0,     0,  2251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,  1957,     0,     0,  1197,     0,     0,
       0,     0,     0,  4628,  4629,  4630,  4631,     0,     0,  4633,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   678,     0,
    4646,  4647,  4648,  4649,     0,  4651,  4652,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4661,  4662,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4664,     0,     0,     0,     0,     0,  2327,  2327,     0,  2327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,  1197,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,  1197,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,  1197,  1197,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,  1197,  1197,  1197,  1197,
       0,     0,     0,     0,  4726,     0,  1197,  1197,     0,  1197,
       0,  1197,  1197,  4732,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1957,  1197,     0,  4751,     0,     0,  1197,     0,     0,
       0,  1197,     0,     0,     0,  1197,     0,  1197,  1197,  1197,
    1197,  1197,  1197,  1197,  1197,  1197,     0,  1197,  4770,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   722,  2107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2890,     0,     0,
       0,     0,     0,     0,     0,  2327,     0,     0,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,  2327,     0,
    2913,     0,     0,  2915,     0,     0,  2926,     0,     0,     0,
       0,     0,     0,  2933,  2938,     0,     0,     0,     0,  2944,
       0,     0,  2949,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2958,
       0,     0,     0,     0,  2965,     0,     0,     0,  2977,     0,
       0,     0,  2984,     0,  2986,  2987,  2988,  2989,  2990,  2991,
    2992,  2993,  2994,     0,  2995,     0,     0,  4854,  2251,     0,
       0,     0,     0,     0,  1566,  3023,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1957,  4865,     0,     0,
    1957,  1957,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,  1640,     0,     0,
       0,     0,     0,     0,  1197,     0,     0,     0,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,     0,     0,     0,
    2251,     0,     0,     0,     0,     0,     0,  2401,     0,     0,
       0,     0,   678,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2251,  3795,     0,     0,     0,  2922,
       0,     0,     0,     0,     0,     0,  1957,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2251,
    2251,     0,     0,  2251,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2251,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4990,     0,
       0,     0,     0,     0,     0,     0,     0,  4997,     0,     0,
    3159,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2251,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2251,     0,     0,     0,     0,     0,  1197,     0,
    1957,     0,     0,     0,  2251,     0,     0,  2251,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3795,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  5088,     0,  1957,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  5099,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5110,     0,     0,     0,     0,  5114,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3376,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,  5151,     0,  1957,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,  1197,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,  1197,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,  1197,  1197,  1197,     0,     0,     0,     0,     0,     0,
    3500,     0,     0,  1197,   722,     0,  1197,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,  1197,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,  1197,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,     0,     0,   678,     0,     0,     0,     0,
    1197,     0,     0,  1197,  1197,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3549,     0,     0,     0,     0,  3555,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,  1197,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,  2938,     0,  2938,
    2938,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3612,     0,     0,  3615,     0,  3617,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,     0,     0,
    1957,     0,  1957,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,  3638,     0,  3640,     0,     0,     0,  3643,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3023,  3023,  3023,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3706,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2334,     0,     0,
       0,     0,  3718,     0,     0,  3100,     0,  1957,  2349,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2251,     0,  2251,     0,  2922,  2922,  3586,     0,     0,
    2922,     0,     0,     0,  2251,     0,     0,     0,     0,     0,
       0,  2251,     0,     0,     0,     0,  2251,     0,  1957,     0,
    1957,     0,  2251,     0,     0,     0,     0,  2251,     0,     0,
       0,     0,     0,     0,     0,     0,  2251,  3764,     0,     0,
    2922,  2922,     0,  2251,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2251,     0,   678,     0,     0,
       0,     0,  2251,     0,  2251,  2251,  2251,  2251,  2251,  2251,
    2251,  2251,  2251,  2251,     0,  1957,     0,     0,     0,     0,
     678,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1957,  2251,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1957,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1957,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1957,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1957,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2251,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,  1957,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,  1197,     0,  1197,     0,     0,     0,     0,  1957,
    1197,     0,     0,  1197,  1197,  1197,  1197,  1197,  1197,  1197,
    1197,  1197,  1197,     0,     0,     0,  1197,  1197,     0,     0,
       0,     0,     0,     0,  1957,     0,     0,     0,     0,  1197,
       0,     0,     0,  1197,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
    1197,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
    1957,  1197,  1197,  1197,     0,     0,     0,  1197,     0,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1197,     0,  1197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,  1197,  1197,     0,     0,  2401,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4090,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4094,  2251,     0,     0,     0,   678,  4095,
       0,  4096,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,  1197,     0,  4114,  4115,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,     0,     0,
       0,     0,     0,     0,  2944,     0,     0,     0,     0,     0,
     678,     0,     0,  1197,  4143,     0,     0,  4146,     0,  4148,
       0,     0,     0,     0,     0,     0,     0,     0,  4152,     0,
       0,     0,     0,     0,  4157,     0,     0,  4160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4201,     0,     0,     0,     0,
       0,  4208,  3023,     0,     0,     0,     0,     0,  2251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1957,     0,
       0,     0,     0,     0,     0,   678,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4223,     0,     0,     0,
       0,     0,  1566,   678,     0,     0,     0,  2251,  1640,     0,
       0,     0,     0,  2251,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3586,
    3586,     0,  2922,     0,     0,  2922,  2922,  2922,  2922,  2922,
    2922,  2922,  2922,  2922,  2922,  3586,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2251,     0,     0,  2251,     0,  2251,     0,     0,     0,     0,
    3586,  3586,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,  2922,  2922,  2251,     0,  2251,     0,
       0,  2251,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1957,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1957,  1197,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2251,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2251,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   722,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,  2251,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1197,  1197,     0,  1957,     0,     0,     0,     0,
    1197,  1197,     0,     0,     0,  1197,  1957,     0,     0,     0,
       0,  1197,  1197,     0,     0,  1197,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4480,  4481,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
    1197,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4513,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1957,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4531,
    4533,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2922,     0,  4540,     0,  1957,     0,     0,     0,  4545,  4546,
       0,     0,  4548,     0,     0,  4551,     0,     0,     0,     0,
       0,     0,     0,  1957,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3023,     0,     0,     0,     0,  3023,     0,     0,
       0,     0,  3023,     0,     0,     0,     0,     0,     0,     0,
       0,  1957,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4609,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,     0,     0,     0,     0,  2251,     0,
    1197,     0,  2251,  2251,  2251,     0,     0,  3586,     0,     0,
       0,  1197,  3586,  3586,  3586,  3586,  3586,  3586,  3586,  3586,
    3586,  3586,  2251,  2251,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2251,  2922,  2922,  2251,     0,  2251,     0,     0,  1957,
    2251,  3586,  3586,     0,     0,  2251,     0,     0,  2251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,  1957,     0,     0,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,  2251,
       0,     0,     0,     0,     0,     0,  2251,     0,     0,  1197,
    1197,     0,     0,  1197,     0,     0,     0,     0,     0,     0,
       0,  2251,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,  1197,     0,     0,     0,     0,  1197,  4712,     0,  1197,
       0,     0,     0,     0,  1197,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1957,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4796,     0,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4819,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1197,     0,  1957,     0,  3586,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1197,  1957,     0,  1197,     0,
    1197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1197,     0,     0,     0,  1197,  2251,  2251,
       0,     0,  1957,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2251,     0,     0,     0,  2922,     0,     0,     0,     0,
       0,     0,  1957,     0,     0,     0,  1957,  1957,     0,  2251,
       0,  2251,     0,     0,     0,     0,  3586,  3586,  2251,     0,
       0,  2922,  2922,  2251,  2251,     0,  2251,     0,     0,  2251,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1197,     0,     0,     0,
       0,     0,     0,     0,     0,  2944,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1957,  2251,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4966,     0,     0,     0,  1197,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
    2251,     0,     0,     0,     0,     0,     0,     0,  1197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  5040,  1197,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3586,  2922,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3586,  3586,  2251,     0,     0,     0,  1197,     0,
       5,     0,     0,     0,     0,     0,  5089,     0,     0,     0,
       6,     7,  1197,     0,     0,     0,     8,  2251,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,    36,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1197,  5135,  5135,     0,     0,     0,     0,     0,     0,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  5135,     0,     0,  3586,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  5191,
       0,     0,     0,     0,  2251,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  5135,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2251,    50,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    51,     0,     0,    52,     0,
       0,     0,     0,     0,     0,     0,     0,  2251,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2251,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2251,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,     0,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,    67,    68,
       0,    69,    70,    71,    72,    73,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
     739,   427,   428,   429,   740,   741,   742,   743,   744,   745,
     746,   430,   431,   747,   432,   433,   133,   434,   435,   436,
     135,   136,   137,   138,   139,   748,   437,   438,   439,   440,
     441,   749,   750,   442,   443,   751,   140,   444,   752,   445,
     446,   447,   448,   144,   753,   145,   754,   449,   450,   451,
     452,   148,   453,   755,   756,   454,   455,   456,   457,   458,
     459,   757,   151,   460,   758,   759,   760,   761,   152,   762,
     763,   764,   461,   462,   463,   464,   701,   465,   155,   156,
     466,   765,   467,   766,   468,   469,   470,   471,   472,   767,
     473,   474,   475,   768,   769,   476,   477,   478,   479,   480,
     770,   481,   482,   483,   771,   484,   485,   486,   772,   487,
     488,   489,   490,   164,   491,   492,   493,   166,   773,   494,
     774,   495,   496,   168,   497,   775,   498,   776,   499,   169,
     777,   170,   500,   501,   502,   778,   503,   172,   779,   504,
     780,   505,   506,   703,   507,   508,   173,   509,   510,   511,
     781,   512,   513,   514,   515,   516,   517,   782,   518,   174,
     175,   783,   519,   520,   521,   784,   176,   785,   177,   786,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
     787,   529,   530,   788,   531,   181,   182,   532,   183,   789,
     533,   534,   535,   790,   791,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,   189,
     190,   547,   548,   191,   792,   549,   550,   193,   551,   793,
     194,   552,   195,   553,   554,   555,   794,   556,   795,   796,
     557,   558,   559,   797,   798,   560,   196,   197,   561,   198,
     199,   562,   563,   564,   565,   566,   567,   568,   799,   569,
     200,   570,   201,   571,   572,   573,   800,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
     801,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   802,   597,   598,   210,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,   803,   608,   609,
     610,   611,   612,   804,   613,   217,   614,   615,   219,   616,
     220,   617,   805,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   806,   628,   629,   807,   630,   631,
     632,   633,   634,   635,   808,   224,   225,   809,   810,   637,
     226,   638,   227,   811,   639,   640,   641,   642,   643,   644,
     645,   812,   813,   646,   647,   648,   649,   650,   814,   815,
     651,   652,   653,   654,   655,   816,   234,   817,   656,   235,
     657,   658,   659,   660,   818,   819,   661,   820,   821,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,     0,    85,     0,
       0,    86,    87,    88,    89,    90,    91,    92,    93,     0,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     975,   104,   105,   106,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
     119,   120,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,   127,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,   130,   131,
       0,     0,     0,     0,     0,     0,     0,     0,   132,     0,
     133,     0,     0,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,   141,     0,   142,   143,   144,     0,   145,
       0,   146,     0,   147,     0,   148,     0,     0,     0,     0,
       0,     0,     0,   149,     0,   150,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,     0,   153,
       0,   154,   155,   156,   157,     0,     0,     0,     0,     0,
   -1422,     0,     0,     0,     0,     0,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   161,   162,
       0,     0,     0,     0,     0,     0,   163,   164,   165,     0,
       0,   166,     0,     0,   167,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,   171,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0, -1422,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,     0,   183,     0,   184,   185,     0,     0,     0,     0,
     186,     0,     0,     0,     0,     0,     0,     0,     0,   187,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
     192,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,     0,   198,   199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,   208,     0,     0,     0,     0,   209,   210,
       0,   211,   212,     0,     0,   213,     0,     0,     0,     0,
     214,   215,     0,     0,     0,     0,     0,     0,   216,   217,
       0,   218,   219,     0,   220,     0,     0,     0,     0,   221,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,   223,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,   228,     0,
     229,     0,     0,     0,     0,   230,     0,     0,   231,     0,
       0, -1422,     0,     0,   232,     0,     0,     0,     0,   233,
     234,     0,     0,   235,     0,     0,     0,     0,     0,     0,
       0,     0,   236,     0,     0,     0,     0,     0,     0,   237,
     238,   239,   240,   241,   242,   243,   244,   245,     0,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   246,   104,
     105,     0,  -138,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,     0,   164,     0,     0,     0,   166,
       0,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   210,     0,     0,
     212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,     0,   230,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   234,     0,
       0,   235,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,     0,     0,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,  3090,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,     0,   164,     0,     0,     0,   166,
       0,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   210,     0,     0,
     212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,     0,   230,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   234,     0,
       0,   235,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     0,     0,     0,     0,     0,     0,
       9,    10,     0,  3092,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,    46,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,     0,     0,     0,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,    48,     0,
       0,     0,     0,     0,     0,    53,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,     0,    59,     0,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1396,  2793,     0,     0,     0,    71,     0,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    57,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    58,
       0,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1396,
       0,     0,     0,     0,    71,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1485,  1486,  1487,    45,  1488,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,  3017,
     427,   428,   429,     0,     0,     0,     0,  1489,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1490,   137,  1491,  1492,     0,   437,   438,   439,   440,   441,
    1493,  1494,   442,   443,  1495,  1496,   444,     0,   445,   446,
     447,   448,  1497,     0,  1498,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,
    1505,   461,   462,   463,   464,   701,   465,  1506,  1507,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,  3018,     0,   476,   477,  1508,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1509,   491,   492,   493,  1510,  1511,   494,     0,
     495,   496,  1512,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1513,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1514,  1515,     0,  1516,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1517,   182,   532,   183,     0,   533,
     534,   535,  1518,  1519,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1520,   189,  1521,
     547,   548,   191,  1522,   549,   550,   193,   551,  1523,  1524,
     552,  1525,   553,   554,   555,     0,   556,     0,     0,  1526,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1527,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1528,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1529,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1530,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1531,   613,   217,   614,   615,   219,   616,  1532,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1533,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1534,  1535,     0,     0,   637,  1536,
     638,  1537,  1538,   639,   640,   641,   642,   643,   644,   645,
       0,  1539,   646,   647,   648,   649,   650,  1540,     0,   651,
     652,   653,   654,   655,   707,  1541,  3019,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,  1551,  3020,     0,     0,     0,
       0,     0,     0,  1553,  3021,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1485,  1486,  1487,    45,  1488,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1489,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1490,   137,  1491,  1492,     0,   437,   438,   439,   440,   441,
    1493,  1494,   442,   443,  1495,  1496,   444,     0,   445,   446,
     447,   448,  1497,     0,  1498,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,
    1505,   461,   462,   463,   464,   701,   465,  1506,  1507,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1508,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1509,   491,   492,   493,  1510,  1511,   494,     0,
     495,   496,  1512,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1513,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1514,  1515,     0,  1516,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1517,   182,   532,   183,     0,   533,
     534,   535,  1518,  1519,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1520,   189,  1521,
     547,   548,   191,  1522,   549,   550,   193,   551,  1523,  1524,
     552,  1525,   553,   554,   555,     0,   556,     0,     0,  1526,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1527,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1528,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1529,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1530,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1531,   613,   217,   614,   615,   219,   616,  1532,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1533,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1534,  1535,     0,     0,   637,  1536,
     638,  1537,  1538,   639,   640,   641,   642,   643,   644,   645,
       0,  1539,   646,   647,   648,   649,   650,  1540,     0,   651,
     652,   653,   654,   655,   707,  1541,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,  1551,     0,     0,     0,     0,
       0,     0,     0,  1553,  2924,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1923,   137,  1924,  1925,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1926,  1927,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,  1928,  1929,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1508,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,  1930,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,  2416,
     512,   513,   514,   515,   516,   517,     0,   518,   174,  2417,
       0,   519,   520,   521,  1514,  1931,     0,  1932,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1933,   189,  1934,
     547,   548,     0,     0,   549,   550,   193,   551,     0,     0,
     552,  1935,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,  2419,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1936,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,  2420,   614,   615,   219,   616,  1938,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1939,  1940,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,  1941,  2421,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,     0,     0,     0,     0,
       0,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,  2519,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,     0,  1923,   137,  1924,  1925,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
    1926,  1927,   444,     0,   445,   446,   447,   448,     0,     0,
     145,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,   701,   465,  1928,  1929,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1508,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,     0,   491,
     492,   493,     0,     0,   494,     0,   495,   496,  1930,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,     0,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,  2416,   512,   513,   514,   515,
     516,   517,     0,   518,   174,  2417,     0,   519,   520,   521,
    1514,  1931,     0,  1932,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
       0,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1933,   189,  1934,   547,   548,     0,     0,
     549,   550,   193,   551,     0,     0,   552,  1935,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,  2419,   197,   561,   198,     0,   562,   563,   564,   565,
     566,   567,   568,     0,   569,     0,   570,     0,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1936,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
    2420,   614,   615,   219,   616,  1938,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,     0,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1939,  1940,     0,     0,   637,     0,   638,     0,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,  1941,  2421,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   708,
     668,   669,     0,     0,     0,     0,     0,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
    3462,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1485,  1486,  1487,    45,  1488,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,  1489,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,  1490,   137,  1491,  1492,  2934,   437,   438,   439,
     440,   441,  1493,  1494,   442,   443,  1495,  1496,   444,     0,
     445,   446,   447,   448,  1497,     0,  1498,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,  1499,  1500,  1501,  1502,
    1503,  1504,  1505,   461,   462,   463,   464,   701,   465,  1506,
    1507,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1508,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,  1509,   491,   492,   493,  1510,  1511,
     494,     0,   495,   496,  1512,   497,     0,   498,     0,   499,
     169,  2935,   170,   500,   501,   502,     0,   503,  1513,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,  1514,  1515,     0,  1516,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,  2936,   531,  1517,   182,   532,   183,
       0,   533,   534,   535,  1518,  1519,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1520,
     189,  1521,   547,   548,   191,  1522,   549,   550,   193,   551,
    1523,  1524,   552,  1525,   553,   554,   555,     0,   556,     0,
       0,  1526,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1527,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1528,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1529,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,  1530,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1531,   613,   217,   614,   615,   219,
     616,  1532,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1533,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1534,  1535,     0,  2937,
     637,  1536,   638,  1537,  1538,   639,   640,   641,   642,   643,
     644,   645,     0,  1539,   646,   647,   648,   649,   650,  1540,
       0,   651,   652,   653,   654,   655,   707,  1541,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1542,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,   708,   668,   669,     0,     0,
       0,     0,     0,     0,     0,     0,  1550,  1551,     0,     0,
       0,     0,     0,     0,     0,  1553,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1485,  1486,  1487,    45,  1488,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,  1489,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,  1490,   137,  1491,  1492,     0,   437,   438,   439,   440,
     441,  1493,  1494,   442,   443,  1495,  1496,   444,     0,   445,
     446,   447,   448,  1497,     0,  1498,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,  1499,  1500,  1501,  1502,  1503,
    1504,  1505,   461,   462,   463,   464,   701,   465,  1506,  1507,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1508,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1509,   491,   492,   493,  1510,  1511,   494,
       0,   495,   496,  1512,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1513,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1514,  1515,     0,  1516,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1517,   182,   532,   183,     0,
     533,   534,   535,  1518,  1519,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1520,   189,
    1521,   547,   548,   191,  1522,   549,   550,   193,   551,  1523,
    1524,   552,  1525,   553,   554,   555,     0,   556,     0,     0,
    1526,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1527,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1528,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1529,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1530,   601,
     602,   603,   604,   605,   606,   706,   607,   215,   608,   609,
     610,   611,   612,  1531,   613,   217,   614,   615,   219,   616,
    1532,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1533,     0,   628,   629,   223,   630,   631,
     632,   633,   634,   635,     0,  1534,  1535,     0,     0,   637,
    1536,   638,  1537,  1538,   639,   640,   641,   642,   643,   644,
     645,     0,  1539,   646,   647,   648,   649,   650,  1540,     0,
     651,   652,   653,   654,   655,  2213,  1541,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,   236,   662,
     663,   664,   665,   666,   667,   237,  1542,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,   708,   668,   669,     0,     0,     0,
       0,     0,     0,     0,     0,  1550,  1551,     0,     0,     0,
       0,     0,     0,     0,  1553,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1485,  1486,  1487,    45,  1488,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1489,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1490,   137,  1491,  1492,     0,   437,   438,   439,   440,   441,
    1493,  1494,   442,   443,  1495,  1496,   444,     0,   445,   446,
     447,   448,  1497,     0,  1498,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,
    1505,   461,   462,   463,   464,   701,   465,  1506,  1507,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1508,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1509,   491,   492,   493,  1510,  1511,   494,     0,
     495,   496,  1512,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1513,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1514,  1515,     0,  1516,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1517,   182,   532,   183,     0,   533,
     534,   535,  1518,  1519,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1520,   189,  1521,
     547,   548,   191,  1522,   549,   550,   193,   551,  1523,  1524,
     552,  1525,   553,   554,   555,     0,   556,     0,     0,  1526,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1527,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1528,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1529,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1530,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1531,   613,   217,   614,   615,   219,   616,  1532,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1533,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1534,  1535,     0,     0,   637,  1536,
     638,  1537,  1538,   639,   640,   641,   642,   643,   644,   645,
       0,  1539,   646,   647,   648,   649,   650,  1540,     0,   651,
     652,   653,   654,   655,   707,  1541,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,  1551,     0,     0,     0,     0,
       0,  2157,  2882,  1553,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1485,  1486,  1487,    45,  1488,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1489,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,  1490,
     137,  1491,  1492,     0,   437,   438,   439,   440,   441,  1493,
    1494,   442,   443,  1495,  1496,   444,     0,   445,   446,   447,
     448,  1497,     0,  1498,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,  1505,
     461,   462,   463,   464,   701,   465,  1506,  1507,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1508,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,  1509,   491,   492,   493,  1510,  1511,   494,     0,   495,
     496,  1512,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1513,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1514,  1515,     0,  1516,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1517,   182,   532,   183,     0,   533,   534,
     535,  1518,  1519,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1520,   189,  1521,   547,
     548,   191,  1522,   549,   550,   193,   551,  1523,  1524,   552,
    1525,   553,   554,   555,     0,   556,     0,     0,  1526,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1527,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1528,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1529,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1530,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1531,   613,   217,   614,   615,   219,   616,  1532,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1533,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1534,  1535,     0,     0,   637,  1536,   638,
    1537,  1538,   639,   640,   641,   642,   643,   644,   645,     0,
    1539,   646,   647,   648,   649,   650,  1540,     0,   651,   652,
     653,   654,   655,   707,  1541,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1542,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  1550,  1551,  1552,     0,     0,     0,     0,
       0,     0,  1553,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1485,  1486,  1487,    45,  1488,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,  1489,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1490,   137,
    1491,  1492,     0,   437,   438,   439,   440,   441,  1493,  1494,
     442,   443,  1495,  1496,   444,     0,   445,   446,   447,   448,
    1497,     0,  1498,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1499,  1500,  1501,  1502,  1503,  1504,  1505,   461,
     462,   463,   464,   701,   465,  1506,  1507,   466,  1639,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1508,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1509,   491,   492,   493,  1510,  1511,   494,     0,   495,   496,
    1512,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1513,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1514,  1515,     0,  1516,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1517,   182,   532,   183,     0,   533,   534,   535,
    1518,  1519,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1520,   189,  1521,   547,   548,
     191,  1522,   549,   550,   193,   551,  1523,  1524,   552,  1525,
     553,   554,   555,     0,   556,     0,     0,  1526,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1527,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1528,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1529,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1530,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1531,   613,   217,   614,   615,   219,   616,  1532,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1533,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1534,  1535,     0,     0,   637,  1536,   638,  1537,
    1538,   639,   640,   641,   642,   643,   644,   645,     0,  1539,
     646,   647,   648,   649,   650,  1540,     0,   651,   652,   653,
     654,   655,   707,  1541,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1542,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  1550,  1551,     0,     0,     0,     0,     0,     0,
       0,  1553,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1485,  1486,  1487,    45,  1488,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,  2344,   427,   428,   429,
       0,     0,     0,     0,  1489,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,  1490,   137,  1491,
    1492,     0,   437,   438,   439,   440,   441,  1493,  1494,   442,
     443,  1495,  1496,   444,     0,   445,   446,   447,   448,  1497,
       0,  1498,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,  1499,  1500,  1501,  1502,  1503,  1504,  1505,   461,   462,
     463,   464,   701,   465,  1506,  1507,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1508,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,  1509,
     491,   492,   493,  1510,  1511,   494,     0,   495,   496,  1512,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1513,     0,   504,     0,   505,   506,   703,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,  1514,  1515,     0,  1516,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,  1517,   182,   532,   183,     0,   533,   534,   535,  1518,
    1519,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1520,   189,  1521,   547,   548,   191,
    1522,   549,   550,   193,   551,  1523,  1524,   552,  1525,   553,
     554,   555,     0,   556,     0,     0,  1526,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1527,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1528,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1529,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,  1530,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1531,
     613,   217,   614,   615,   219,   616,  1532,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1533,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1534,  1535,     0,     0,   637,  1536,   638,  1537,  1538,
     639,   640,   641,   642,   643,   644,   645,     0,  1539,   646,
     647,   648,   649,   650,  1540,     0,   651,   652,   653,   654,
     655,   707,  1541,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
     708,   668,   669,     0,     0,     0,     0,     0,     0,     0,
       0,  1550,  1551,     0,     0,     0,     0,     0,     0,     0,
    1553,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1485,
    1486,  1487,    45,  1488,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1489,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1490,   137,  1491,  1492,
       0,   437,   438,   439,   440,   441,  1493,  1494,   442,   443,
    1495,  1496,   444,     0,   445,   446,   447,   448,  1497,     0,
    1498,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
    1499,  1500,  1501,  1502,  1503,  1504,  1505,   461,   462,   463,
     464,   701,   465,  1506,  1507,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1508,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1509,   491,
     492,   493,  1510,  1511,   494,     0,   495,   496,  1512,   497,
       0,   498,     0,   499,   169,  2935,   170,   500,   501,   502,
       0,   503,  1513,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1514,  1515,     0,  1516,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
    1517,   182,   532,   183,     0,   533,   534,   535,  1518,  1519,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1520,   189,  1521,   547,   548,   191,  1522,
     549,   550,   193,   551,  1523,  1524,   552,  1525,   553,   554,
     555,     0,   556,     0,     0,  1526,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1527,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1528,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1529,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1530,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1531,   613,
     217,   614,   615,   219,   616,  1532,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1533,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1534,  1535,     0,     0,   637,  1536,   638,  1537,  1538,   639,
     640,   641,   642,   643,   644,   645,     0,  1539,   646,   647,
     648,   649,   650,  1540,     0,   651,   652,   653,   654,   655,
     707,  1541,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1550,  1551,     0,     0,     0,     0,     0,     0,     0,  1553,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1485,  1486,
    1487,    45,  1488,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1489,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,  1490,   137,  1491,  1492,     0,
     437,   438,   439,   440,   441,  1493,  1494,   442,   443,  1495,
    1496,   444,     0,   445,   446,   447,   448,  1497,     0,  1498,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1499,
    1500,  1501,  1502,  1503,  1504,  1505,   461,   462,   463,   464,
     701,   465,  1506,  1507,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1508,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,  1509,   491,   492,
     493,  1510,  1511,   494,     0,   495,   496,  1512,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1513,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1514,
    1515,     0,  1516,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1517,
     182,   532,   183,     0,   533,   534,   535,  1518,  1519,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1520,   189,  1521,   547,   548,   191,  1522,   549,
     550,   193,   551,  1523,  1524,   552,  1525,   553,   554,   555,
       0,   556,     0,     0,  1526,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1527,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1528,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1529,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1530,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1531,   613,   217,
     614,   615,   219,   616,  1532,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1533,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1534,
    1535,     0,     0,   637,  1536,   638,  1537,  1538,   639,   640,
     641,   642,   643,   644,   645,     0,  1539,   646,   647,   648,
     649,   650,  1540,     0,   651,   652,   653,   654,   655,   707,
    1541,  4209,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  1550,
    1551,     0,     0,     0,     0,     0,     0,     0,  1553,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,   418,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1485,  1486,  1487,
      45,  1488,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,  1489,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,  1490,   137,  1491,  1492,     0,   437,
     438,   439,   440,   441,  1493,  1494,   442,   443,  1495,  1496,
     444,     0,   445,   446,   447,   448,  1497,     0,  1498,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,  4222,  1499,  1500,
    1501,  1502,  1503,  1504,  1505,   461,   462,   463,   464,   701,
     465,  1506,  1507,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1508,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,  1509,   491,   492,   493,
    1510,  1511,   494,     0,   495,   496,  1512,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1513,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,  1514,  1515,
       0,  1516,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1517,   182,
     532,   183,     0,   533,   534,   535,  1518,  1519,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1520,   189,  1521,   547,   548,   191,  1522,   549,   550,
     193,   551,  1523,  1524,   552,  1525,   553,   554,   555,     0,
     556,     0,     0,  1526,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1527,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1528,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1529,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,  1530,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1531,   613,   217,   614,
     615,   219,   616,  1532,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1533,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1534,  1535,
       0,     0,   637,  1536,   638,  1537,  1538,   639,   640,   641,
     642,   643,   644,   645,     0,  1539,   646,   647,   648,   649,
     650,  1540,     0,   651,   652,   653,   654,   655,   707,  1541,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1542,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,   668,   669,
       0,     0,     0,     0,     0,     0,     0,     0,  1550,  1551,
       0,     0,     0,     0,     0,     0,     0,  1553,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,   418,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1485,  1486,  1487,    45,
    1488,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
    1489,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,  5132,  1490,   137,  1491,  1492,     0,   437,   438,
     439,   440,   441,  1493,  1494,   442,   443,  1495,  1496,   444,
       0,   445,   446,   447,   448,  1497,     0,  1498,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,  5133,  1499,  1500,  1501,
    1502,  1503,  1504,  1505,   461,   462,   463,   464,   701,   465,
    1506,  1507,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1508,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,  1509,   491,   492,   493,  1510,
    1511,   494,     0,   495,   496,  1512,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,  1513,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,   175,     0,   519,   520,   521,  1514,  1515,     0,
    1516,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,  1517,   182,   532,
     183,     0,   533,   534,   535,  1518,  1519,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1520,   189,  1521,   547,   548,   191,  1522,   549,   550,   193,
     551,  1523,  1524,   552,  1525,   553,   554,   555,     0,   556,
       0,     0,  1526,   558,   559,     0,     0,   560,   196,   197,
     561,   198,  1527,   562,   563,   564,   565,   566,   567,   568,
       0,   569,  1528,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1529,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
    1530,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,  1531,   613,   217,   614,   615,
     219,   616,  1532,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1533,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1534,  1535,     0,
       0,   637,  1536,   638,  1537,  1538,   639,   640,   641,   642,
    5134,   644,   645,     0,  1539,   646,   647,   648,   649,   650,
    1540,     0,   651,   652,   653,   654,   655,   707,  1541,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,  1542,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,   708,   668,   669,     0,
       0,     0,     0,     0,     0,     0,     0,  1550,  1551,     0,
       0,     0,     0,     0,     0,     0,  1553,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1485,  1486,  1487,    45,  1488,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,  1489,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,  1490,   137,  1491,  1492,     0,   437,   438,   439,
     440,   441,  1493,  1494,   442,   443,  1495,  1496,   444,     0,
     445,   446,   447,   448,  1497,     0,  1498,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,  5133,  1499,  1500,  1501,  1502,
    1503,  1504,  1505,   461,   462,   463,   464,   701,   465,  1506,
    1507,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1508,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,  1509,   491,   492,   493,  1510,  1511,
     494,     0,   495,   496,  1512,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1513,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,  1514,  1515,     0,  1516,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,  1517,   182,   532,   183,
       0,   533,   534,   535,  1518,  1519,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1520,
     189,  1521,   547,   548,   191,  1522,   549,   550,   193,   551,
    1523,  1524,   552,  1525,   553,   554,   555,     0,   556,     0,
       0,  1526,   558,   559,     0,     0,   560,   196,   197,   561,
     198,  1527,   562,   563,   564,   565,   566,   567,   568,     0,
     569,  1528,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1529,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,  1530,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,  1531,   613,   217,   614,   615,   219,
     616,  1532,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,  1533,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1534,  1535,     0,     0,
     637,  1536,   638,  1537,  1538,   639,   640,   641,   642,  5134,
     644,   645,     0,  1539,   646,   647,   648,   649,   650,  1540,
       0,   651,   652,   653,   654,   655,   707,  1541,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,  1542,  1543,  1544,
    1545,  1546,  1547,  1548,  1549,   708,   668,   669,     0,     0,
       0,     0,     0,     0,     0,     0,  1550,  1551,     0,     0,
       0,     0,     0,     0,     0,  1553,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1485,  1486,  1487,    45,  1488,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,  1489,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,  1490,   137,  1491,  1492,     0,   437,   438,   439,   440,
     441,  1493,  1494,   442,   443,  1495,  1496,   444,     0,   445,
     446,   447,   448,  1497,     0,  1498,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,  1499,  1500,  1501,  1502,  1503,
    1504,  1505,   461,   462,   463,   464,   701,   465,  1506,  1507,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1508,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1509,   491,   492,   493,  1510,  1511,   494,
       0,   495,   496,  1512,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1513,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1514,  1515,     0,  1516,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1517,   182,   532,   183,     0,
     533,   534,   535,  1518,  1519,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1520,   189,
    1521,   547,   548,   191,  1522,   549,   550,   193,   551,  1523,
    1524,   552,  1525,   553,   554,   555,     0,   556,     0,     0,
    1526,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1527,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1528,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1529,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1530,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,  1531,   613,   217,   614,   615,   219,   616,
    1532,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1533,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1534,  1535,     0,     0,   637,
    1536,   638,  1537,  1538,   639,   640,   641,   642,   643,   644,
     645,     0,  1539,   646,   647,   648,   649,   650,  1540,     0,
     651,   652,   653,   654,   655,   707,  1541,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,  1542,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,   708,   668,   669,     0,     0,     0,
       0,     0,     0,     0,     0,  1550,  1551,     0,     0,     0,
       0,     0,     0,     0,  1553,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,   418,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1485,  1486,  1487,    45,  1488,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,  1489,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
    1490,   137,  1491,  1492,     0,   437,   438,   439,   440,   441,
    1493,  1494,   442,   443,  1495,  1496,   444,     0,   445,   446,
     447,   448,  1497,     0,  1498,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,
    1505,   461,   462,   463,   464,   701,   465,  1506,  1507,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1508,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,  1509,   491,   492,   493,  1510,  1511,   494,     0,
     495,   496,  1512,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1513,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,  1514,  1515,     0,  1516,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,  1517,   182,   532,   183,     0,   533,
     534,   535,  1518,  1519,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1520,   189,  1521,
     547,   548,   191,  1522,   549,   550,   193,   551,  1523,  1524,
     552,  1525,   553,   554,   555,     0,   556,     0,     0,  1526,
     558,   559,     0,     0,   560,   196,   197,   561,   198,  1527,
     562,   563,   564,   565,   566,   567,   568,     0,   569,  1528,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1529,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,  1530,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,  1531,   613,   217,   614,   615,   219,   616,  1532,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,  1533,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1534,  1535,     0,     0,   637,  1536,
     638,  1537,  1538,   639,   640,   641,   642,   643,   644,   645,
       0,  1539,   646,   647,   648,   649,   650,  1540,     0,   651,
     652,   653,   654,   655,   707,  1541,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,  4523,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,  1549,   708,   668,   669,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,  1551,     0,     0,     0,     0,
       0,     0,     0,  1553,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1485,  1486,  1487,    45,  1488,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,  1489,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,  1490,
     137,  1491,  1492,     0,   437,   438,   439,   440,   441,  1493,
    1494,   442,   443,  1495,  1496,   444,     0,   445,   446,   447,
     448,  1497,     0,  1498,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,  1505,
     461,   462,   463,   464,   701,   465,  1506,  1507,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1508,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,  1509,   491,   492,   493,  1510,  1511,   494,     0,   495,
     496,  1512,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1513,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,  1514,  1515,     0,  1516,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1517,   182,   532,   183,     0,   533,   534,
     535,  1518,  1519,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1520,   189,  1521,   547,
    4532,   191,  1522,   549,   550,   193,   551,  1523,  1524,   552,
    1525,   553,   554,   555,     0,   556,     0,     0,  1526,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1527,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1528,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1529,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,  1530,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1531,   613,   217,   614,   615,   219,   616,  1532,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1533,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1534,  1535,     0,     0,   637,  1536,   638,
    1537,  1538,   639,   640,   641,   642,   643,   644,   645,     0,
    1539,   646,   647,   648,   649,   650,  1540,     0,   651,   652,
     653,   654,   655,   707,  1541,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1542,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,   708,   668,   669,     0,     0,     0,     0,     0,
       0,     0,     0,  1550,  1551,     0,     0,     0,     0,     0,
       0,     0,  1553,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
     418,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1485,  1486,  1487,    45,  1488,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,  1489,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,  1490,   137,
    1491,  1492,     0,   437,   438,   439,   440,   441,  1493,  1494,
     442,   443,  1495,  1496,   444,     0,   445,   446,   447,   448,
    1497,     0,  1498,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,  1499,  1500,  1501,  1502,  1503,  1504,  1505,   461,
     462,   463,   464,   701,   465,  1506,  1507,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1508,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
    1509,   491,   492,   493,  1510,  1511,   494,     0,   495,   496,
    1512,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1513,     0,   504,     0,   505,   506,
     703,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,  1514,  1515,     0,  1516,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,  1517,   182,   532,   183,     0,   533,   534,   535,
    1518,  1519,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,  1520,   189,  1521,   547,   548,
     191,     0,   549,   550,   193,   551,  1523,  1524,   552,  1525,
     553,   554,   555,     0,   556,     0,     0,  1526,   558,   559,
       0,     0,   560,   196,   197,   561,   198,  1527,   562,   563,
     564,   565,   566,   567,   568,     0,   569,  1528,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,  1529,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,  1530,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
    1531,   613,   217,   614,   615,   219,   616,  1532,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
    1533,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,  1534,  1535,     0,     0,   637,  1536,   638,  1537,
    1538,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,  1540,     0,   651,   652,   653,
     654,   655,   707,  1541,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,  1542,  1543,  1544,  1545,  1546,  1547,  1548,
    1549,   708,   668,   669,     0,     0,     0,     0,     0,     0,
       0,     0,  2917,  2918,     0,     0,     0,     0,     0,     0,
       0,  1553,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1485,  1486,  1487,    45,  1488,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,  1489,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436, -2682,  1490,   137,  1491,
    1492,     0,   437,   438,   439,   440,   441,  1493,  1494,   442,
     443,  1495,  1496,   444,     0,   445,   446,   447,   448,  1497,
       0,  1498,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
    5133,  1499,  1500,  1501,  1502,  1503,  1504,  1505,   461,   462,
     463,   464,   701,   465,  1506,  1507,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1508,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,  1509,
     491,   492,   493,  1510,  1511,   494,     0,   495,   496,  1512,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,  1513,     0,   504,     0,   505,   506,   703,
     507,   508,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,  1514,  1515,     0,  1516,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,  1517,   182,   532,     0,     0,   533,   534,   535,  1518,
    1519,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,  1520,   189,  1521,   547,   548,   191,
       0,   549,   550,   193,   551,  1523,  1524,   552,  1525,   553,
     554,   555,     0,   556,     0,     0,  1526,   558,   559,     0,
       0,   560,   196,   197,   561,   198,  1527,   562,   563,   564,
     565,   566,   567,   568,     0,   569,  1528,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,  1529,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,  1530,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,  1531,
     613,   217,   614,   615,     0,   616,  1532,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1533,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,  1534,  1535,     0,     0,   637,  1536,   638,  1537,  1538,
     639,   640,   641,   642,  5134,   644,   645,     0,  1539,   646,
     647,   648,   649,   650,  1540,     0,   651,   652,   653,   654,
     655,   707,  1541,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,  1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,
     708,   668,   669,     0,     0,     0,     0,     0,     0,     0,
       0,  1550,  1551,     0,     0,     0,     0,     0,     0,     0,
    1553,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1485,
    1486,     0,    45,  1488,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1489,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,  1490,   137,  1491,  1492,
       0,   437,   438,   439,   440,   441,  1493,  1494,   442,   443,
    1495,  1496,   444,     0,   445,   446,   447,   448,  1497,     0,
    1498,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
    1499,  1500,  1501,  1502,  1503,  1504,  1505,   461,   462,   463,
     464,   701,   465,  1506,  1507,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1508,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,  1509,   491,
     492,   493,  1510,  1511,   494,     0,   495,   496,  1512,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1513,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1514,  1515,     0,  1516,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
    1517,   182,   532,   183,     0,   533,   534,   535,  1518,  1519,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1520,   189,  1521,   547,   548,   191,     0,
     549,   550,   193,   551,  1523,  1524,   552,  1525,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1527,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1528,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1529,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1530,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1531,   613,
     217,   614,   615,   219,   616,  1532,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1533,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1534,  1535,     0,     0,   637,  1536,   638,  1537,  1538,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,  1540,     0,   651,   652,   653,   654,   655,
     707,  1541,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,
     668,   669,     0,     0,     0,     0,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,  1553,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,   418,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1485,  1486,     0,    45,  1488,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,  1489,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,  1490,   137,  1491,  1492,     0,  4127,   438,   439,   440,
     441,  1493,  1494,   442,   443,  1495,  1496,   444,     0,   445,
     446,   447,   448,  1497,     0,  1498,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,  1499,  1500,  1501,  1502,  1503,
    1504,  1505,   461,   462,   463,   464,   701,   465,  1506,  1507,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1508,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,  1509,   491,   492,   493,  1510,  1511,   494,
       0,   495,   496,  1512,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,  1513,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,  1514,  1515,     0,  1516,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,  1517,   182,   532,   183,     0,
     533,   534,   535,  1518,  1519,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1520,   189,
    1521,   547,   548,   191,     0,   549,   550,   193,   551,  1523,
    1524,   552,  1525,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,   197,   561,   198,
    1527,   562,   563,   564,   565,   566,   567,   568,     0,   569,
    1528,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1529,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,  1530,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,  1531,   613,   217,   614,   615,   219,   616,
    1532,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1533,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1534,  1535,     0,     0,   637,
    1536,   638,  1537,  1538,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,  1540,     0,
     651,   652,   653,   654,   655,   707,  1541,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,  1542,  1543,  1544,  1545,
    1546,  1547,  1548,  1549,   708,   668,   669,     0,     0,     0,
       0,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,  1553,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1485,
    1486,  1487,    45,  1488,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,  1489,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,     0,  1490,   137,  1491,  1492,
       0,   437,   438,   439,   440,   441,  1493,  1494,   442,   443,
    1495,  1496,   444,     0,   445,   446,   447,   448,  1497,     0,
    1498,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
    1499,  1500,  1501,  1502,  1503,  1504,  1505,   461,   462,   463,
     464,   701,   465,  1506,  1507,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1508,   479,   480,     0,   481,   482,   483,     0,
     484,     0,   486,     0,   487,   488,   489,   490,  1509,   491,
     492,   493,  1510,  1511,   494,     0,   495,   496,  1512,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1513,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
    1514,  1515,     0,  1516,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
    1517,   182,   532,     0,     0,   533,   534,   535,  1518,  1519,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,  1520,   189,  1521,   547,   548,   191,     0,
     549,   550,   193,   551,  1523,  1524,   552,  1525,   553,   554,
     555,     0,   556,     0,     0,  1526,   558,   559,     0,     0,
     560,   196,   197,   561,   198,  1527,   562,   563,   564,   565,
     566,   567,   568,     0,   569,  1528,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
    1529,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,  1530,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,  1531,   613,
     217,   614,   615,     0,   616,  1532,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1533,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1534,  1535,     0,     0,   637,  1536,   638,  1537,  1538,   639,
     640,   641,   642,   643,   644,   645,     0,  1539,   646,   647,
     648,   649,   650,  1540,     0,   651,   652,   653,   654,   655,
     707,  1541,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,  1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1550,  1551,     0,     0,     0,     0,     0,     0,     0,  1553,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1485,  1486,
    1487,    45,  1488,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,  1489,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,     0,  1490,   137,  1491,  1492,     0,
     437,   438,   439,   440,   441,  1493,  1494,   442,   443,  1495,
    1496,   444,     0,   445,   446,   447,   448,  1497,     0,  1498,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1499,
    1500,  1501,  1502,  1503,  1504,  1505,   461,   462,   463,   464,
     701,   465,  1506,  1507,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1508,   479,   480,     0,   481,   482,   483,     0,   484,
       0,   486,     0,   487,   488,   489,   490,  1509,   491,   492,
     493,  1510,  1511,   494,     0,   495,   496,  1512,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1513,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,  1514,
    1515,     0,  1516,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1517,
     182,   532,     0,     0,   533,   534,   535,  1518,  1519,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1520,   189,  1521,   547,   548,   191,     0,   549,
     550,   193,   551,  1523,  1524,   552,  1525,   553,   554,   555,
       0,   556,     0,     0,  1526,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1527,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1528,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1529,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,  1530,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1531,   613,   217,
     614,   615,     0,   616,  1532,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1533,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1534,
    1535,     0,     0,   637,  1536,   638,  1537,  1538,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,  1540,     0,   651,   652,   653,   654,   655,   707,
    1541,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,   668,
     669,     0,     0,     0,     0,     0,     0,     0,     0,  2917,
    2918,     0,     0,     0,     0,     0,     0,     0,  1553,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,  1494,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,  1497,     0,  1498,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1499,  1500,
    1501,  1502,  1503,  1504,  1505,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
    1510,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1513,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,  3658,   529,   530,     0,   531,  1517,   182,
     532,   183,     0,   533,   534,   535,  1518,  1519,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,  1524,   552,   195,   553,   554,   555,     0,
     556,     0,  1094,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1527,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1528,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,  3659,   602,   603,   604,   605,   606,   706,   607,
     215,   608,   609,   610,   611,   612,  1531,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1533,     0,   628,   629,
     223,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,  1536,   638,  1537,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,  1540,     0,   651,   652,   653,   654,   655,  2213,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,   236,   662,   663,   664,   665,   666,   667,   237,  1542,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,   668,   669,
       0,     0,     0,     0,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  3660,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,   136,
     137,   138,   139,     0,   437,   438,   439,   440,   441,     0,
    1494,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,  1497,     0,  1498,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,  1505,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,  1510,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1513,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,  3658,   529,
     530,     0,   531,  1517,   182,   532,   183,     0,   533,   534,
     535,  1518,  1519,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,   189,   190,   547,
     548,   191,     0,   549,   550,   193,   551,     0,  1524,   552,
     195,   553,   554,   555,     0,   556,     0,  1094,   557,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1527,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1528,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,   212,  3659,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1531,   613,   217,   614,   615,   219,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1533,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,  1536,   638,
    1537,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,  1540,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1542,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,   708,   668,   669,     0,     0,     0,     0,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  3660,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,  1494,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,  1497,     0,  1498,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,  1499,  1500,
    1501,  1502,  1503,  1504,  1505,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
    1510,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1513,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,  1517,   182,
     532,   183,     0,   533,   534,   535,  1518,  1519,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,  1524,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,  1527,   562,   563,   564,   565,   566,   567,
     568,     0,   569,  1528,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,  3659,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,  1531,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,  1533,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,  1536,   638,  1537,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,  1540,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,  1542,
    1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,   668,   669,
       0,     0,     0,     0,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,   246,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,   136,
     137,   138,   139,     0,   437,   438,   439,   440,   441,     0,
    1494,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,  1497,     0,  1498,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,  1499,  1500,  1501,  1502,  1503,  1504,  1505,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,  1510,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1513,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,  1517,   182,   532,   183,     0,   533,   534,
     535,  1518,  1519,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,   189,   190,   547,
     548,   191,     0,   549,   550,   193,   551,     0,  1524,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,   197,   561,   198,  1527,   562,
     563,   564,   565,   566,   567,   568,     0,   569,  1528,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,  1531,   613,   217,   614,   615,   219,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1533,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,  1536,   638,
    1537,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,  1540,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,  1542,  1543,  1544,  1545,  1546,  1547,
    1548,  1549,   708,   668,   669,     0,     0,     0,     0,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,  4252,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,     0,     0,     0,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,  4856,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,  4179,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,   446,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
   -1514,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0, -1514,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518, -1514,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523, -1514,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181, -1514,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188, -1514,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598, -1514,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,     0,
       0,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,  1647,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,   446,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,     0,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,  3940,  3941,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,  3941,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,   446,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,   215,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,   223,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,  2213,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,   236,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,     0,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,   246,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,   215,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,   223,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,  2213,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,   236,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,   246,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,   446,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,     0,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,  1622,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
       0,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,  3080,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,   446,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,     0,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,  4163,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   687,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,     0,   434,   435,   436,   135,
     136,     0,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   698,   140,   444,     0,   445,   446,
     447,   448,   144,     0,     0,     0,   449,   450,   451,   452,
       0,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,     0,     0,     0,     0,     0,     0,     0,
       0,   461,   462,   463,   464,   701,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   703,   507,   508,     0,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,     0,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
       0,     0,   523,     0,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,     0,   532,     0,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,   188,     0,   190,
     547,   548,   191,     0,   549,   550,     0,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,     0,   561,     0,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   212,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,     0,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   707,   234,     0,   656,     0,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   708,   668,   669,     0,     0,     0,     0,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,  4574,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,   418,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
    1219,    45,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,   739,   427,   428,   429,   740,   741,
     742,   743,   744,   745,   746,   430,   431,   747,   432,   433,
     133,   434,   435,   436,     0,  1923,   137,  1924,  1925,   748,
     437,   438,   439,   440,   441,   749,   750,   442,   443,  1926,
    1927,   444,   752,   445,   446,   447,   448,     0,   753,   145,
     754,   449,   450,   451,   452,   148,   453,   699,   756,   454,
     455,   456,   457,   458,   459,   757,   151,   460,     0,   759,
     760,   761,   152,   762,   763,   764,   461,   462,   463,   464,
     701,   465,  1928,  1929,   466,   765,   467,   766,   468,   469,
     470,   471,   472,   767,   473,   474,   475,   768,   769,   476,
     477,  1508,   479,   480,   770,   481,   482,   483,   771,   484,
     485,   486,   772,   487,   488,   489,   490,     0,   491,   492,
     493,     0,   773,   494,   774,   495,   496,  1930,   497,   775,
     498,   776,   499,   169,   777,   170,   500,   501,   502,   778,
     503,     0,   779,   504,   780,   505,   506,   703,   507,   508,
     173,   509,   510,   511,   781,   512,   513,   514,   515,   516,
     517,   782,   518,   174,     0,     0,   519,   520,   521,  1514,
    1931,   785,  1932,   786,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,   787,   529,   530,   788,   531,     0,
     182,   532,   183,   789,   533,   534,   535,   790,   791,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1933,   189,  1934,   547,   548,     0,   792,   549,
     550,   193,   551,   793,     0,   552,  1935,   553,   554,   555,
     794,   556,   795,   796,  3927,   558,   559,   797,   798,   560,
       0,   197,   561,   198,     0,   562,   563,   564,   565,   566,
     567,   568,   799,   569,     0,   570,     0,   571,   572,   573,
     800,   574,   575,   576,   577,   578,   579,   580,   581,  1936,
     582,   583,   584,   585,   801,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   802,   597,   598,   210,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   706,
     607,   803,   608,   609,   610,   611,   612,   804,   613,  2420,
     614,   615,   219,   616,  1938,   617,   805,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,   806,   628,
     629,   807,   630,   631,   632,   633,   634,   635,   808,  1939,
    1940,     0,   810,   637,     0,   638,     0,   811,   639,   640,
     641,   642,   643,   644,   645,     0,   813,   646,   647,   648,
     649,   650,   814,   815,   651,   652,   653,   654,   655,     0,
    1941,   817,   656,   235,   657,   658,   659,   660,   818,   819,
     661,   820,   821,   662,   663,   664,   665,   666,   667,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   708,   668,
     669,     0,     0,     0,     0,  1222,  1223,  1224,     0,  3928,
    3929,  1227,  1228,  1229,  1230,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1219,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,  1220,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,  1221,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,  1222,
    1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,  1230,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1219,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,  1316,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,  1317,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,  1222,  1223,  1224,     0,  1225,  1226,  1227,
    1228,  1229,  1230,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   687,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1219,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,     0,   434,   435,   436,   135,   136,     0,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,  1373,   447,   448,   144,
       0,     0,     0,   449,   450,   451,   452,     0,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
       0,     0,     0,     0,     0,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,  1374,     0,   495,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,  1375,     0,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,     0,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,     0,     0,   523,
       0,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,     0,   532,     0,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,     0,   190,   547,   548,   191,
       0,   549,   550,     0,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,     0,   561,     0,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,     0,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,     0,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,     0,     0,     0,     0,  1222,  1223,  1224,
       0,  1225,  1226,  1227,  1228,  1229,  1230,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   687,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1219,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,     0,   434,   435,   436,
     135,   136,     0,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   698,   140,   444,     0,   445,
    1908,   447,   448,   144,     0,     0,     0,   449,   450,   451,
     452,     0,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,     0,     0,     0,     0,     0,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,  1909,
       0,   495,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,   508,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,     0,     0,   523,     0,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,     0,   532,     0,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,   188,     0,
     190,   547,   548,   191,     0,   549,   550,     0,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,     0,   561,     0,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   212,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,     0,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   707,   234,     0,   656,     0,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,     0,     0,     0,
       0,  1222,  1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,
    1230,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   687,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1219,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
       0,   434,   435,   436,   135,   136,     0,   138,   139,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   698,
     140,   444,     0,   445,   446,   447,   448,   144,     0,     0,
       0,   449,   450,   451,   452,     0,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,     0,     0,
       0,     0,     0,     0,     0,     0,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,   166,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   703,   507,   508,
       0,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,     0,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,     0,     0,   523,     0,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,   181,
       0,   532,     0,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,     0,   190,   547,   548,   191,     0,   549,
     550,     0,   551,     0,   194,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,     0,   561,     0,   199,   562,   563,   564,   565,   566,
     567,   568,     0,   569,   200,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,   217,
     614,   615,     0,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,   226,   638,   227,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,     0,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   708,   668,
     669,     0,     0,     0,     0,  1222,  1223,  1224,     0,  1225,
    1226,  1227,  1228,  1229,  1230,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   687,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1219,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,     0,   434,   435,   436,   135,   136,
       0,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   698,   140,   444,     0,   445,  3180,   447,
     448,   144,     0,     0,     0,   449,   450,   451,   452,     0,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,     0,     0,     0,     0,     0,     0,     0,     0,
     461,   462,   463,   464,   701,   465,   155,   156,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,     0,  3181,     0,   495,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   703,   507,   508,     0,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,     0,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,     0,
       0,   523,     0,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,     0,   532,     0,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,   188,     0,   190,   547,
     548,   191,     0,   549,   550,     0,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,   196,     0,   561,     0,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   212,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,     0,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   707,   234,     0,   656,     0,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   708,   668,   669,     0,     0,     0,     0,  1222,
    1223,  1224,     0,  1225,  1226,  1227,  1228,  1229,  1230,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   687,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1219,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,     0,   434,
     435,   436,   135,   136,     0,   138,   139,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   698,   140,   444,
       0,   445,   446,   447,   448,   144,     0,     0,     0,   449,
     450,   451,   452,     0,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,     0,     0,     0,     0,
       0,     0,     0,     0,   461,   462,   463,   464,   701,   465,
     155,   156,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,   164,   491,   492,   493,   166,
       0,   494,     0,   495,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   703,   507,   508,     0,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,     0,   175,     0,   519,   520,   521,     0,   176,     0,
     177,     0,   522,     0,     0,   523,     0,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,   181,     0,   532,
       0,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,     0,   190,   547,   548,   191,     0,   549,   550,     0,
     551,     0,   194,   552,   195,   553,   554,   555,     0,   556,
       0,     0,  4835,   558,   559,     0,     0,   560,   196,     0,
     561,     0,   199,   562,   563,   564,   565,   566,   567,   568,
       0,   569,   200,   570,   201,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,   217,   614,   615,
       0,   616,   220,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,   224,   225,     0,
       0,   637,   226,   638,   227,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   707,   234,     0,
     656,     0,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,     0,
       0,     0,     0,  1222,  1223,  1224,     0,  1225,  1226,  1227,
    1228,  1229,  1230,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,   739,   427,   428,
     429,   740,   741,   742,   743,   744,   745,   746,   430,   431,
     747,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,   748,   437,   438,   439,   440,   441,   749,   750,
     442,   443,   751,   140,   444,   752,   445,   446,   447,   448,
     144,   753,   145,   754,   449,   450,   451,   452,   148,   453,
     755,   756,   454,   455,   456,   457,   458,   459,   757,   151,
     460,   758,   759,   760,   761,   152,   762,   763,   764,   461,
     462,   463,   464,   701,   465,   155,   156,   466,   765,   467,
     766,   468,   469,   470,   471,   472,   767,   473,   474,   475,
     768,   769,   476,   477,   478,   479,   480,   770,   481,   482,
     483,   771,   484,   485,   486,   772,   487,   488,   489,   490,
     164,   491,   492,   493,   166,   773,   494,   774,   495,   496,
     168,   497,   775,   498,   776,   499,   169,   777,   170,   500,
     501,   502,   778,   503,   172,   779,   504,   780,   505,   506,
     703,   507,   508,   173,   509,   510,   511,   781,   512,   513,
     514,   515,   516,   517,   782,   518,   174,   175,   783,   519,
     520,   521,   784,   176,   785,   177,   786,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,   787,   529,   530,
     788,   531,   181,   182,   532,   183,   789,   533,   534,   535,
     790,   791,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,   792,   549,   550,   193,   551,   793,   194,   552,   195,
     553,   554,   555,   794,   556,   795,   796,   557,   558,   559,
     797,   798,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,   799,   569,   200,   570,   201,
     571,   572,   573,   800,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,   801,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   802,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,   803,   608,   609,   610,   611,   612,
     804,   613,   217,   614,   615,   219,   616,   220,   617,   805,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   806,   628,   629,   807,   630,   631,   632,   633,   634,
     635,   808,   224,   225,   809,   810,   637,   226,   638,   227,
     811,   639,   640,   641,   642,   643,   644,   645,   812,   813,
     646,   647,   648,   649,   650,   814,   815,   651,   652,   653,
     654,   655,   816,   234,   817,   656,   235,   657,   658,   659,
     660,   818,   819,   661,   820,   821,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,     0,   732,    86,    87,    88,   684,
      90,    91,    92,   685,  2312,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1923,   137,  1924,  1925,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1926,  1927,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,  1928,  1929,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1508,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,  1930,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,  2416,
     512,   513,   514,   515,   516,   517,     0,   518,   174,  2417,
       0,   519,   520,   521,  1514,  1931,     0,  1932,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1933,   189,  1934,
     547,   548,     0,     0,   549,   550,   193,   551,     0,     0,
     552,  1935,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,  2418,   560,  2419,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1936,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,  2420,   614,   615,   219,   616,  1938,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,  1939,  1940,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,  1941,  2421,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,     0,     0,    86,    87,
      88,   684,    90,    91,    92,   685,  2422,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     687,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,     0,   434,   435,
     436,   135,   136,     0,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   698,   140,   444,     0,
     445,   446,   447,   448,   144,     0,     0,     0,   449,   450,
     451,   452,     0,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,     0,   460,     0,     0,     0,     0,     0,
       0,     0,     0,   461,   462,   463,   464,   701,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   703,   507,   508,     0,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
       0,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,     0,     0,   523,     0,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,     0,   532,     0,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
       0,   190,   547,   548,   191,     0,   549,   550,     0,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,     0,   561,
       0,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,     0,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   707,   234,     0,   656,
       0,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,     0,     0,
      86,    87,    88,   684,    90,    91,    92,   685,  1101,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   687,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,     0,
     434,   435,   436,   135,   136,     0,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   698,   140,
     444,     0,   445,   446,   447,   448,   144,     0,     0,     0,
     449,   450,   451,   452,     0,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,     0,     0,     0,
       0,     0,     0,     0,     0,   461,   462,   463,   464,   701,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   703,   507,   508,     0,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,     0,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,     0,     0,   523,     0,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,     0,
     532,     0,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,     0,   190,   547,   548,   191,     0,   549,   550,
       0,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
       0,   561,     0,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,     0,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   707,   234,
       0,   656,     0,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
       0,     0,    86,    87,    88,   684,    90,    91,    92,   685,
    4883,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   419,   996,   421,
     422,   423,   424,   425,   426,   997,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   998,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   999,   168,   497,
       0,   498,     0,  1000,     0,  1001,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,  1002,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,  1003,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,  1004,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,  1005,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,  1006,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1007,  1008,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   419,   996,   421,
     422,   423,   424,   425,   426,   997,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,  1029,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   999,   168,   497,
       0,   498,     0,  1030,     0,  1001,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,  1002,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,  1003,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,  1004,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,  1005,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,  1006,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1007,  1008,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1421,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,  1001,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,  1002,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1007,  1008,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1426,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,  1001,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,  1002,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,     0,     0,     0,     0,     0,     0,     0,
    1007,  1008,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   702,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,  1593,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,     0,     0,     0,  1071,  1594,    86,    87,    88,
     684,    90,    91,    92,   685,  1072,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   687,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,     0,   434,   435,   436,
     135,   136,     0,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,  1073,   443,  1045,   140,   444,     0,   445,
     446,   447,   448,   144,     0,     0,     0,   449,   450,   451,
     452,     0,   453,  1074,     0,  1075,   455,   456,   457,   458,
     459,     0,     0,   460,     0,     0,     0,     0,     0,     0,
       0,     0,   461,   462,   463,   464,   701,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,     0,   494,
       0,   495,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   703,   507,   508,     0,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,     0,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,     0,     0,   523,     0,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,     0,   532,     0,     0,
     533,   534,  1076,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,  1077,   188,     0,
     190,   547,   548,   191,     0,   549,   550,     0,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,   196,     0,   561,     0,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,  1078,   600,   212,   601,
     602,   603,  1079,   605,   606,   706,   607,     0,   608,   609,
     610,   611,  1080,     0,   613,   217,   614,   615,     0,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1081,   225,     0,     0,  1082,
     226,   638,   227,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,  1049,   234,     0,   656,     0,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,  1083,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   708,   668,   669,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,   739,   427,   428,   429,   740,   741,   742,   743,   744,
     745,   746,   430,   431,   747,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,   748,   437,   438,   439,
     440,   441,   749,   750,   442,   443,   751,   140,   444,   752,
     445,   446,   447,   448,   144,   753,   145,   754,   449,   450,
     451,   452,   148,   453,   755,   756,   454,   455,   456,   457,
     458,   459,   757,   151,   460,   758,   759,   760,   761,   152,
     762,   763,   764,   461,   462,   463,   464,   701,   465,   155,
     156,   466,   765,   467,   766,   468,   469,   470,   471,   472,
     767,   473,   474,   475,   768,   769,   476,   477,   478,   479,
     480,   770,   481,   482,   483,   771,   484,   485,   486,   772,
     487,   488,   489,   490,   164,   491,   492,   493,   166,   773,
     494,   774,   495,   496,   168,   497,   775,   498,   776,   499,
     169,   777,   170,   500,   501,   502,   778,   503,   172,   779,
     504,   780,   505,   506,   703,   507,   508,   173,   509,   510,
     511,   781,   512,   513,   514,   515,   516,   517,   782,   518,
     174,   175,   783,   519,   520,   521,   784,   176,   785,   177,
     786,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,   787,   529,   530,   788,   531,   181,   182,   532,   183,
     789,   533,   534,   535,   790,   791,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,   188,
     189,   190,   547,   548,   191,   792,   549,   550,   193,   551,
     793,   194,   552,   195,   553,   554,   555,   794,   556,   795,
     796,   557,   558,   559,   797,   798,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,   799,
     569,   200,   570,   201,   571,   572,   573,   800,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,   801,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   802,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,   706,   607,   803,   608,
     609,   610,   611,   612,   804,   613,   217,   614,   615,   219,
     616,   220,   617,   805,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   806,   628,   629,   807,   630,
     631,   632,   633,   634,   635,   808,   224,   225,   809,   810,
     637,   226,   638,   227,   811,   639,   640,   641,   642,   643,
     644,   645,   812,   813,   646,   647,   648,   649,   650,   814,
     815,   651,   652,   653,   654,   655,   816,   234,   817,   656,
     235,   657,   658,   659,   660,   818,   819,   661,   820,   821,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   708,   668,   669,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,   739,   427,   428,   429,   740,   741,   742,   743,
     744,   745,   746,   430,   431,   747,   432,   433,   133,   434,
     435,   436,   135,   136,   137,   138,   139,   748,   437,   438,
     439,   440,   441,   749,   750,   442,   443,   751,   140,   444,
     752,   445,   446,   447,   448,   144,   753,   145,   754,   449,
     450,   451,   452,   148,   453,   755,   756,   454,   455,   456,
     457,   458,   459,   757,   151,   460,   758,   759,   760,   761,
     152,   762,   763,   764,   461,   462,   463,   464,   701,   465,
     155,   156,   466,   765,   467,   766,   468,   469,   470,   471,
     472,   767,   473,   474,   475,   768,   769,   476,   477,   478,
     479,   480,   770,   481,   482,   483,   771,   484,   485,   486,
     772,   487,   488,   489,   490,   164,   491,   492,   493,   166,
     773,   494,   774,   495,   496,   168,   497,   775,   498,   776,
     499,   169,   777,   170,   500,   501,   502,   778,   503,   172,
     779,   504,   780,   505,   506,   703,   507,   508,   173,   509,
     510,   511,   781,   512,   513,   514,   515,   516,   517,   782,
     518,   174,   175,   783,   519,   520,   521,   784,   176,   785,
     177,   786,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,   787,   529,   530,   788,   531,   181,   182,   532,
     183,   789,   533,   534,   535,   790,   791,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
     188,   189,   190,   547,   548,   191,   792,   549,   550,   193,
     551,   793,   194,   552,   195,   553,   554,   555,   794,   556,
     795,   796,   557,   558,   559,   797,   798,   560,   196,   197,
     561,   198,   199,   562,   563,   564,   565,   566,   567,   568,
     799,   569,   200,   570,   201,   571,   572,   573,   800,   574,
     575,   576,   577,   578,   579,   580,   581,   203,   582,   583,
     584,   585,   801,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   802,   597,   598,   210,   599,   600,
     212,   601,   602,   603,   604,   605,   606,   706,   607,   803,
     608,   609,   610,   611,   612,   804,   613,   217,   614,   615,
     219,   616,   220,   617,   805,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   806,   628,   629,   807,
     630,   631,   632,   633,   634,   635,   808,   224,   225,   809,
     810,   637,   226,   638,   227,   811,   639,   640,   641,   642,
     643,   644,   645,   812,   813,   646,   647,   648,   649,   650,
     814,   815,   651,   652,   653,   654,   655,   816,   234,   817,
     656,   235,   657,   658,   659,   660,   818,   819,   661,   820,
     821,   662,   663,   664,   665,   666,   667,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   708,   668,   669,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,  3239,
     424,   425,   426,   739,   427,   428,   429,   740,   741,   742,
     743,   744,   745,   746,   430,   431,   747,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,   748,   437,
     438,   439,   440,   441,   749,   750,   442,   443,   751,   140,
     444,   752,   445,   446,   447,   448,   144,   753,   145,   754,
     449,   450,   451,   452,   148,   453,   755,   756,   454,   455,
     456,   457,   458,   459,   757,   151,   460,   758,   759,   760,
     761,   152,   762,   763,   764,   461,   462,   463,   464,   701,
     465,   155,   156,   466,   765,   467,   766,   468,   469,   470,
     471,   472,   767,   473,   474,   475,   768,   769,   476,   477,
     478,  3240,   480,   770,   481,   482,   483,   771,   484,   485,
     486,   772,   487,   488,   489,   490,   164,   491,   492,   493,
     166,   773,   494,   774,   495,   496,   168,   497,   775,   498,
     776,   499,   169,   777,   170,   500,   501,   502,   778,   503,
     172,   779,   504,   780,   505,   506,   703,   507,   508,   173,
     509,   510,   511,   781,   512,   513,   514,   515,   516,   517,
     782,   518,   174,   175,   783,   519,   520,   521,   784,   176,
     785,   177,   786,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,   787,   529,   530,   788,   531,   181,   182,
     532,   183,   789,   533,   534,   535,   790,   791,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,   188,   189,   190,   547,   548,   191,   792,   549,   550,
     193,   551,   793,   194,   552,   195,   553,   554,   555,   794,
     556,   795,   796,   557,   558,   559,   797,   798,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,   799,   569,   200,   570,   201,   571,   572,   573,   800,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,   801,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   802,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,   706,   607,
     803,   608,   609,   610,   611,   612,   804,  3241,   217,   614,
     615,   219,   616,   220,   617,   805,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   806,   628,   629,
     807,   630,   631,   632,   633,   634,   635,   808,   224,   225,
     809,   810,   637,   226,   638,   227,   811,   639,   640,   641,
     642,   643,   644,   645,   812,   813,   646,   647,   648,   649,
     650,   814,   815,   651,   652,   653,   654,   655,   816,   234,
     817,   656,   235,   657,   658,   659,   660,   818,   819,   661,
     820,   821,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   708,   668,   669,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,   135,   136,   137,   138,   139,     0,
     437,   438,   439,   440,   441,     0,  1494,   442,   443,   698,
     140,   444,     0,   445,   446,   447,   448,  1497,     0,  1498,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,  1499,
    1500,  1501,  1502,  1503,  1504,  1505,   461,   462,   463,   464,
     701,   465,   155,   156,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,   164,   491,   492,
     493,  1510,     0,   494,     0,   495,   496,   168,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1513,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,   175,     0,   519,   520,   521,     0,
     176,     0,   177,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,  1517,
     182,   532,   183,     0,   533,   534,   535,  1518,  1519,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,   188,   189,   190,   547,   548,   191,     0,   549,
     550,   193,   551,     0,  1524,   552,   195,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
     196,   197,   561,   198,  1527,   562,   563,   564,   565,   566,
     567,   568,     0,   569,  1528,   570,   201,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   203,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,   212,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,  1531,   613,   217,
     614,   615,   219,   616,   220,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1533,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,   224,
     225,     0,     0,   637,  1536,   638,  1537,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,  1540,     0,   651,   652,   653,   654,   655,   707,
     234,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,   237,
    1542,  1543,  1544,  1545,  1546,  1547,  1548,  1549,   708,   668,
     669,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,   732,    86,    87,    88,   684,    90,    91,    92,
     685,     0,   686,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   733,   104,   105,   687,   734,     0,   107,   108,
     109,   110,   735,   736,   112,   113,   114,   115,     0,   116,
     737,   738,   688,   689,     0,     0,     0,   690,   691,     0,
       0,     0,     0,   692,     0,     0,     0,     0,     0,     0,
       0,     0,   693,     0,   694,     0,   695,   696,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,   136,   137,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   698,   140,   444,     0,   445,   446,   447,   448,   144,
       0,   145,     0,   449,   450,   451,   452,   148,   453,   699,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,     0,     0,     0,   152,     0,     0,     0,   461,   462,
     463,   464,   701,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   703,
     507,  1356,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,   182,   532,   183,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,   704,   542,   543,
     705,   544,   545,   546,   188,   189,   190,   547,   548,   191,
       0,   549,   550,   193,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,   197,   561,   198,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,   212,   601,   602,   603,   604,   605,
     606,   706,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,   219,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,     0,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   707,   234,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     708,   668,   669,   732,    86,    87,    88,   684,    90,    91,
      92,   685,     0,   686,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   733,   104,   105,   687,   734,     0,   107,
     108,   109,   110,   735,   736,   112,   113,   114,   115,     0,
     116,   737,   738,   688,   689,     0,     0,     0,   690,   691,
       0,     0,     0,     0,   692,     0,     0,     0,     0,     0,
       0,     0,     0,   693,     0,   694,     0,   695,   696,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   698,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
     699,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,   701,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     703,   507,  1366,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,   704,   542,
     543,   705,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,   706,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   707,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   708,   668,   669,   732,    86,    87,    88,   684,    90,
      91,    92,   685,     0,   686,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   733,   104,   105,   687,   734,     0,
     107,   108,   109,   110,   735,   736,   112,   113,   114,   115,
       0,   116,   737,   738,   688,   689,     0,     0,     0,   690,
     691,     0,     0,     0,     0,   692,     0,     0,     0,     0,
       0,     0,     0,     0,   693,     0,   694,     0,   695,   696,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,     0,  1923,
     137,  1924,  1925,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,  1926,  1927,   444,     0,   445,   446,   447,
     448,     0,     0,   145,     0,   449,   450,   451,   452,   148,
     453,   699,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,     0,     0,     0,   152,     0,     0,     0,
     461,   462,   463,   464,   701,   465,  1928,  1929,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1508,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,     0,   491,   492,   493,     0,     0,   494,     0,   495,
     496,  1930,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,     0,     0,   504,     0,   505,
     506,   703,   507,   508,   173,   509,   510,   511,  2416,   512,
     513,   514,   515,   516,   517,     0,   518,   174,  2417,     0,
     519,   520,   521,  1514,  1931,     0,  1932,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,     0,   182,   532,   183,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,   704,
     542,   543,   705,   544,   545,   546,  1933,   189,  1934,   547,
     548,     0,     0,   549,   550,   193,   551,     0,     0,   552,
    1935,   553,   554,   555,     0,   556,     0,     0,   557,   558,
     559,     0,     0,   560,  2419,   197,   561,   198,     0,   562,
     563,   564,   565,   566,   567,   568,     0,   569,     0,   570,
       0,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,  1936,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   706,   607,     0,   608,   609,   610,   611,
     612,     0,   613,  2420,   614,   615,   219,   616,  1938,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,  1939,  1940,     0,     0,   637,     0,   638,
       0,     0,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,     0,  1941,  2421,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,   668,   669,   732,    86,    87,    88,   684,
      90,    91,    92,   685,     0,   686,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   733,   104,   105,   687,   734,
       0,   107,   108,   109,   110,   735,   736,   112,   113,   114,
     115,     0,   116,   737,   738,   688,   689,     0,     0,     0,
     690,   691,     0,     0,     0,     0,   692,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,   694,     0,   695,
     696,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,     0,
    1923,   137,  1924,  1925,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,  1926,  1927,   444,     0,   445,   446,
     447,   448,     0,     0,   145,     0,   449,   450,   451,   452,
     148,   453,   699,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,   701,   465,  1928,  1929,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1508,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,     0,   491,   492,   493,     0,     0,   494,     0,
     495,   496,  1930,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   703,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,     0,
       0,   519,   520,   521,  1514,  1931,     0,  1932,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,     0,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
     704,   542,   543,   705,   544,   545,   546,  1933,   189,  1934,
     547,   548,     0,     0,   549,   550,   193,   551,  2507,     0,
     552,  1935,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,     0,   197,   561,   198,     0,
     562,   563,   564,   565,   566,   567,   568,     0,   569,     0,
     570,     0,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,  1936,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   706,   607,     0,   608,   609,   610,
     611,   612,     0,   613,  2420,   614,   615,   219,   616,  1938,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,     0,   628,   629,  4032,   630,   631,   632,
     633,   634,   635,     0,  1939,  1940,     0,     0,   637,     0,
     638,     0,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,  1941,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,   668,   669,   732,    86,    87,    88,
     684,    90,    91,    92,   685,     0,   686,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   733,   104,   105,   687,
     734,     0,   107,   108,   109,   110,   735,   736,   112,   113,
     114,   115,     0,   116,   737,   738,   688,   689,     0,     0,
       0,   690,   691,     0,     0,     0,     0,   692,     0,     0,
       0,     0,     0,     0,     0,     0,   693,     0,   694,     0,
     695,   696,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
       0,  1923,   137,  1924,  1925,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,  1926,  1927,   444,     0,   445,
     446,   447,   448,     0,     0,   145,     0,   449,   450,   451,
     452,   148,   453,   699,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,     0,     0,     0,   152,     0,
       0,     0,   461,   462,   463,   464,   701,   465,  1928,  1929,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1508,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,     0,   491,   492,   493,     0,     0,   494,
       0,   495,   496,  1930,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,     0,     0,   504,
       0,   505,   506,   703,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
       0,     0,   519,   520,   521,  1514,  1931,     0,  1932,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,     0,   182,   532,   183,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,   704,   542,   543,   705,   544,   545,   546,  1933,   189,
    1934,   547,   548,  2567,     0,   549,   550,   193,   551,     0,
       0,   552,  1935,   553,   554,   555,     0,   556,     0,     0,
     557,   558,   559,     0,     0,   560,     0,   197,   561,   198,
       0,   562,   563,   564,   565,   566,   567,   568,     0,   569,
       0,   570,     0,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,  1936,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,     0,   601,
     602,   603,   604,   605,   606,   706,   607,     0,   608,   609,
     610,   611,   612,     0,   613,  1937,   614,   615,   219,   616,
    1938,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,     0,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,  1939,  1940,     0,     0,   637,
       0,   638,     0,     0,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,     0,  1941,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   708,   668,   669,   732,    86,    87,
      88,   684,    90,    91,    92,   685,     0,   686,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   733,   104,   105,
     687,   734,     0,   107,   108,   109,   110,   735,   736,   112,
     113,   114,   115,     0,   116,   737,   738,   688,   689,     0,
       0,     0,   690,   691,     0,     0,     0,     0,   692,     0,
       0,     0,     0,     0,     0,     0,     0,   693,     0,   694,
       0,   695,   696,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,     0,  1923,   137,  1924,  1925,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,  1926,  1927,   444,     0,
     445,   446,   447,   448,     0,     0,   145,     0,   449,   450,
     451,   452,   148,   453,   699,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,   701,   465,  1928,
    1929,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1508,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,     0,   491,   492,   493,     0,     0,
     494,     0,   495,   496,  1930,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,     0,     0,
     504,     0,   505,   506,   703,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,     0,     0,   519,   520,   521,  1514,  1931,     0,  1932,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,     0,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,   704,   542,   543,   705,   544,   545,   546,  1933,
     189,  1934,   547,   548,  3861,     0,   549,   550,   193,   551,
       0,     0,   552,  1935,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,     0,   197,   561,
     198,     0,   562,   563,   564,   565,   566,   567,   568,     0,
     569,     0,   570,     0,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,  1936,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,     0,
     601,   602,   603,   604,   605,   606,   706,   607,     0,   608,
     609,   610,   611,   612,     0,   613,  1937,   614,   615,   219,
     616,  1938,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,  1939,  1940,     0,     0,
     637,     0,   638,     0,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,  1941,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   708,   668,   669,   732,    86,
      87,    88,   684,    90,    91,    92,   685,     0,   686,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   733,   104,
     105,   687,   734,     0,   107,   108,   109,   110,   735,   736,
     112,   113,   114,   115,     0,   116,   737,   738,   688,   689,
       0,     0,     0,   690,   691,     0,     0,     0,     0,   692,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
     694,     0,   695,   696,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   429,     0,     0,     0,     0,
       0,     0,     0,   430,   431,     0,   432,   433,   133,   434,
     435,   436,     0,  1923,   137,  1924,  1925,     0,   437,   438,
     439,   440,   441,     0,     0,   442,   443,  1926,  1927,   444,
       0,   445,   446,   447,   448,     0,     0,   145,     0,   449,
     450,   451,   452,   148,   453,   699,     0,   454,   455,   456,
     457,   458,   459,     0,   151,   460,     0,     0,     0,     0,
     152,     0,     0,     0,   461,   462,   463,   464,   701,   465,
    1928,  1929,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1508,
     479,   480,     0,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,   489,   490,     0,   491,   492,   493,     0,
       0,   494,     0,   495,   496,  1930,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   703,   507,   508,   173,   509,
     510,   511,     0,   512,   513,   514,   515,   516,   517,     0,
     518,   174,     0,     0,   519,   520,   521,  1514,  1931,     0,
    1932,     0,   522,   178,   179,   523,   180,   524,   525,   526,
     527,   528,     0,   529,   530,     0,   531,     0,   182,   532,
     183,     0,   533,   534,   535,     0,     0,   536,   537,   538,
     539,   540,   541,   704,   542,   543,   705,   544,   545,   546,
    1933,   189,  1934,   547,   548,     0,     0,   549,   550,   193,
     551,     0,     0,   552,  1935,   553,   554,   555,     0,   556,
       0,     0,   557,   558,   559,     0,     0,   560,     0,   197,
     561,   198,     0,   562,   563,   564,   565,   566,   567,   568,
       0,   569,     0,   570,     0,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,  1936,   582,   583,
     584,   585,     0,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   210,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   706,   607,     0,
     608,   609,   610,   611,   612,     0,   613,  1937,   614,   615,
     219,   616,  1938,   617,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,     0,   628,   629,     0,
     630,   631,   632,   633,   634,   635,     0,  1939,  1940,     0,
       0,   637,     0,   638,     0,     0,   639,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,     0,  1941,     0,
     656,   235,   657,   658,   659,   660,     0,     0,   661,     0,
       0,   662,   663,   664,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,   668,   669,   732,
      86,    87,    88,   684,    90,    91,    92,   685,     0,   686,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   733,
     104,   105,   687,   734,     0,   107,   108,   109,   110,   735,
     736,   112,   113,   114,   115,     0,   116,   737,   738,   688,
     689,     0,     0,     0,   690,   691,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,   694,     0,   695,   696,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,     0,  1923,   137,  1924,  1925,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,  1926,  1927,
     444,     0,   445,   446,   447,   448,     0,     0,   145,     0,
     449,   450,   451,   452,   148,   453,   699,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,   701,
     465,  1928,  1929,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1508,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,     0,   491,   492,   493,
       0,     0,   494,     0,   495,   496,  1930,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   703,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,     0,     0,   519,   520,   521,  1514,  1931,
       0,  1932,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,     0,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,   704,   542,   543,   705,   544,   545,
     546,  1933,   189,  1934,   547,   548,     0,     0,   549,   550,
     193,   551,     0,     0,   552,  1935,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,     0,
     197,   561,   198,     0,   562,   563,   564,   565,   566,   567,
     568,     0,   569,     0,   570,     0,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,  1936,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   706,   607,
       0,   608,   609,   610,   611,   612,     0,   613,  2420,   614,
     615,   219,   616,  1938,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,  1939,  1940,
       0,     0,   637,     0,   638,     0,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,  1941,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,   668,   669,
     732,    86,    87,    88,   684,    90,    91,    92,   685,     0,
     686,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     733,   104,   105,   687,   734,     0,   107,   108,   109,   110,
     735,   736,   112,   113,   114,   115,     0,   116,   737,   738,
     688,   689,     0,     0,     0,   690,   691,     0,     0,     0,
       0,   692,     0,     0,     0,     0,     0,     0,     0,     0,
     693,     0,   694,     0,   695,   696,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,   429,     0,     0,
       0,     0,     0,     0,     0,   430,   431,     0,   432,   433,
     133,   434,   435,   436,     0,  1923,   137,  1924,  1925,     0,
     437,   438,   439,   440,   441,     0,     0,   442,   443,  1926,
    1927,   444,     0,   445,   446,   447,   448,     0,     0,   145,
       0,   449,   450,   451,   452,   148,   453,   699,     0,   454,
     455,   456,   457,   458,   459,     0,   151,   460,     0,     0,
       0,     0,   152,     0,     0,     0,   461,   462,   463,   464,
     701,   465,  1928,  1929,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1508,   479,   480,     0,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,   489,   490,     0,   491,   492,
     493,     0,     0,   494,     0,   495,   496,  1930,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   703,   507,   508,
     173,   509,   510,   511,     0,   512,   513,   514,   515,   516,
     517,     0,   518,   174,     0,     0,   519,   520,   521,  1514,
    1931,     0,  1932,     0,   522,   178,   179,   523,   180,   524,
     525,   526,   527,   528,     0,   529,   530,     0,   531,     0,
     182,   532,   183,     0,   533,   534,   535,     0,     0,   536,
     537,   538,   539,   540,   541,   704,   542,   543,   705,   544,
     545,   546,  1933,   189,  1934,   547,   548,     0,     0,   549,
     550,   193,   551,     0,     0,   552,  1935,   553,   554,   555,
       0,   556,     0,     0,   557,   558,   559,     0,     0,   560,
       0,   197,   561,   198,     0,   562,   563,   564,   565,   566,
     567,   568,     0,   569,     0,   570,     0,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,  1936,
     582,   583,   584,   585,     0,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   210,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   706,
     607,     0,   608,   609,   610,   611,   612,     0,   613,     0,
     614,   615,   219,   616,  1938,   617,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,     0,   628,
     629,     0,   630,   631,   632,   633,   634,   635,     0,  1939,
    1940,     0,     0,   637,     0,   638,     0,     0,   639,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,     0,
    1941,     0,   656,   235,   657,   658,   659,   660,     0,     0,
     661,     0,     0,   662,   663,   664,   665,   666,   667,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   708,   668,
     669,   732,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   733,   104,   105,   687,   734,     0,   107,   108,   109,
     110,   735,   736,   112,   113,   114,   115,     0,   116,   737,
     738,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,     0,     0,   137,     0,     0,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,     0,   444,     0,   445,   446,   447,   448,     0,     0,
     145,     0,   449,   450,   451,   452,   148,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,   701,   465,     0,     0,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,     0,   491,
     492,   493,     0,     0,   494,     0,   495,   496,     0,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,     0,     0,   504,     0,   505,   506,   703,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,     0,     0,   519,   520,   521,
       0,     0,     0,     0,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
       0,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,     0,   189,     0,   547,   548,     0,     0,
     549,   550,   193,   551,     0,     0,   552,     0,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,     0,   197,   561,   198,     0,   562,   563,   564,   565,
     566,   567,   568,     0,   569,     0,   570,     0,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
       0,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
       0,   614,   615,   219,   616,     0,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,     0,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
       0,     0,     0,     0,   637,     0,   638,     0,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,     0,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   739,   427,   428,   429,   740,
     741,   742,   743,   744,   745,   746,   430,   431,   747,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
     748,   437,   438,   439,   440,   441,   749,   750,   442,   443,
       0,   140,   444,   752,   445,   446,   447,   448,   144,   753,
     145,   754,   449,   450,   451,   452,   148,   453,   755,   756,
     454,   455,   456,   457,   458,   459,   757,   151,   460,     0,
     759,   760,   761,   152,   762,   763,   764,   461,   462,   463,
     464,     0,   465,   155,   156,   466,   765,   467,   766,   468,
     469,   470,   471,   472,   767,   473,   474,   475,   768,   769,
     476,   477,   478,   479,   480,   770,   481,   482,   483,   771,
     484,   485,   486,   772,   487,   488,   489,   490,   164,   491,
     492,   493,   166,   773,   494,   774,   495,   496,   168,   497,
     775,   498,   776,   499,   169,   777,   170,   500,   501,   502,
     778,   503,   172,   779,   504,   780,   505,   506,     0,   507,
     508,   173,   509,   510,   511,   781,   512,   513,   514,   515,
     516,   517,   782,   518,   174,   175,     0,   519,   520,   521,
       0,   176,   785,   177,   786,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,   787,   529,   530,   788,   531,
     181,   182,   532,   183,   789,   533,   534,   535,   790,   791,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,   792,
     549,   550,   193,   551,   793,   194,   552,   195,   553,   554,
     555,   794,   556,   795,   796,   557,   558,   559,   797,   798,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,   799,   569,   200,   570,   201,   571,   572,
     573,   800,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,   801,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   802,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,   803,   608,   609,   610,   611,   612,   804,   613,
     217,   614,   615,   219,   616,   220,   617,   805,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   806,
     628,   629,   807,   630,   631,   632,   633,   634,   635,   808,
     224,   225,     0,   810,   637,   226,   638,   227,   811,   639,
     640,   641,   642,   643,   644,   645,     0,   813,   646,   647,
     648,   649,   650,   814,   815,   651,   652,   653,   654,   655,
       0,   234,   817,   656,   235,   657,   658,   659,   660,   818,
     819,   661,   820,   821,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,  1163,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,  2453,   445,   446,   447,   448,   144,     0,
       0,  2526,   449,   450,   451,   452,     0,   453,   699,  2454,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,  2527,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,  2456,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,  2457,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,  2458,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,  2453,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,  2454,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,  2527,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,  2456,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,  3409,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,  2457,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,  2458,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,  1060,   425,   426,  1016,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,  1017,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
    1061,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,  1018,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,  1019,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1016,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,  1017,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
    3142,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,  1018,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,  1019,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,  2453,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,  2454,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,  2527,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,  2456,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,  2457,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,  2458,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   697,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,   700,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   702,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1016,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,  1017,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,  1018,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,  1019,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
     927,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   928,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   929,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  2114,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
    2115,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,  2116,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,  2117,   499,     0,     0,     0,  2118,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,  2119,  2120,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,  2121,   605,   606,
     706,   607,     0,  2122,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,  2123,   630,  2124,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,  2125,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,  1017,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,  1018,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,  1019,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
    2103,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,  2398,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,  3006,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,  3007,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,  3008,   630,   631,  3009,   633,  3010,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
    3011,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   724,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,   702,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,   877,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1244,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1245,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,  1094,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1348,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,   130,
     131,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  3223,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,  3224,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  3235,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,  3236,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   933,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   978,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,   418,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,  1033,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,  1094,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1214,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1215,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1596,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1770,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,  1094,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1818,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1819,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
    2011,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
    2103,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,  2398,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,  4179,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,  4193,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,  4418,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,  4420,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,  4422,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,  4838,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,  1042,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1044,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,  1046,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1047,   225,     0,     0,  1048,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1088,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,  1089,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1090,   225,     0,     0,  1091,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,  1108,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1239,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1253,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1307,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1321,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1361,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1380,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1382,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1384,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1387,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1393,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,  1607,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,  1073,   443,
    1045,   140,  1608,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,  1077,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1078,   600,   212,   601,   602,   603,  1079,   605,   606,
     706,   607,     0,   608,   609,   610,   611,  1600,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1081,   225,     0,     0,  1082,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,  1083,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,  1733,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,  1044,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    1970,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    2000,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    2035,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    2037,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    2039,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,  2152,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,  2365,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,     0,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    2764,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    3153,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    3226,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    3228,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
    3333,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,  1073,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,  1077,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1078,   600,   212,   601,   602,   603,  1079,   605,   606,
     706,   607,     0,   608,   609,   610,   611,  1600,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1081,   225,     0,     0,  1082,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,  1083,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,   601,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,  1073,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,  1077,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1078,   600,   212,   601,   602,   603,  1079,   605,   606,
     706,   607,     0,   608,   609,   610,   611,  1600,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,  2444,   632,   633,   634,   635,     0,
    1081,   225,     0,     0,  1082,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,  1083,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,  1073,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,  1077,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1078,   600,   212,   601,   602,   603,  2511,   605,   606,
     706,   607,     0,   608,   609,   610,   611,  2512,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1081,   225,     0,     0,  2513,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,  1083,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,  1073,   443,
    1045,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,  1077,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1078,   600,   212,   601,   602,   603,  1079,   605,   606,
     706,   607,     0,   608,   609,   610,   611,  2512,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
    1081,   225,     0,     0,  2513,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
    1049,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,  1083,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,   684,    90,    91,    92,   685,
       0,   686,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   687,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   688,   689,     0,     0,     0,   690,   691,     0,     0,
       0,     0,   692,     0,     0,     0,     0,     0,     0,     0,
       0,   693,     0,   694,     0,   695,   696,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,     0,   434,   435,   436,   135,   136,     0,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     698,   140,   444,     0,   445,   446,   447,   448,   144,     0,
       0,     0,   449,   450,   451,   452,     0,   453,   699,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,     0,
       0,     0,     0,     0,     0,     0,     0,   461,   462,   463,
     464,   701,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   703,   507,
     508,     0,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,     0,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,     0,     0,   523,     0,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,     0,   532,     0,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,   704,   542,   543,   705,
     544,   545,   546,   188,     0,   190,   547,   548,   191,     0,
     549,   550,     0,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,     0,   561,     0,   199,   562,   563,   564,   565,
       0,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,     0,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   212,     0,   602,   603,   604,   605,   606,
     706,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,     0,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     707,   234,     0,   656,     0,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   708,
     668,   669,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115, -2436,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,   127,    35,     0,   413,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
     145,     0,     0,     0,     0,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,   156,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   193,     0,     0,   194,     0,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,     0,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   234,     0,     0,   235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115, -2437,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,   127,    35,     0,  1158,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,     0,   164,     0,     0,     0,   166,
       0,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   210,     0,     0,
     212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,     0,   230,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   234,     0,
       0,   235,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,   145,     0,     0,     0,     0,     0,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,   156,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,     0,   183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,   197,     0,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   200,
       0,   201,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,     0,     0,     0,     0,
     230,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   234,     0,     0,   235,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   181,   182,     0,   183,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,     0,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,   201,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,     0,   230,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   234,     0,     0,   235,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,   145,     0,
       0,     0,     0,     0,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,     0,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   234,
       0,     0,   235,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   418,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,  2079,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,  2080,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,  2081,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
     668,   669,     0,     0,     0,    35,     0,     0,     0,     0,
    1007,  1691,  4685,    41,    42,     0,     0,     0,     0,  4686,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,   130,   131,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
     215,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
     223,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   233,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,   236,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,     0,   668,   669,
      35,   418,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,   246,     0,     0,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   429,     0,     0,     0,     0,     0,     0,     0,   430,
     431,     0,   432,   433,   133,   434,   435,   436,   135,   136,
     137,   138,   139,     0,   437,   438,   439,   440,   441,     0,
       0,   442,   443,     0,   140,   444,     0,   445,   446,   447,
     448,   144,     0,   145,     0,   449,   450,   451,   452,   148,
     453,     0,     0,   454,   455,   456,   457,   458,   459,     0,
     151,   460,     0,     0,     0,     0,   152,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   155,   156,   466,  2300,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,   489,
     490,   164,   491,   492,   493,   166,  2079,   494,     0,   495,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,     0,   507,   508,   173,   509,   510,   511,     0,   512,
     513,   514,   515,   516,   517,     0,   518,   174,   175,     0,
     519,   520,   521,     0,   176,     0,   177,     0,   522,   178,
     179,   523,   180,   524,   525,   526,   527,   528,     0,   529,
     530,     0,   531,   181,   182,   532,   183,     0,   533,   534,
     535,     0,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   543,     0,   544,   545,   546,   188,   189,   190,   547,
     548,   191,     0,   549,   550,   193,   551,     0,   194,   552,
     195,   553,   554,   555,     0,   556,  2080,     0,   557,   558,
     559,     0,     0,   560,   196,   197,   561,   198,   199,   562,
     563,   564,   565,   566,   567,   568,     0,   569,   200,   570,
     201,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   203,   582,   583,   584,   585,     0,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   210,   599,   600,   212,   601,   602,   603,
     604,   605,   606,     0,   607,     0,   608,   609,   610,   611,
     612,     0,   613,   217,   614,   615,   219,   616,   220,   617,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,     0,   628,   629,     0,   630,   631,   632,   633,
     634,   635,     0,   224,   225,     0,     0,   637,   226,   638,
     227,  2081,   639,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,     0,   234,     0,   656,   235,   657,   658,
     659,   660,     0,     0,   661,     0,     0,   662,   663,   664,
     665,   666,   667,   237,   238,   239,   240,   241,   242,   243,
     244,   245,     0,   668,   669,     0,     0,     0,     0,     0,
       0,    35,   418,  1007,  1691,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
    2305,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,  2079,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,  2080,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,  2081,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   668,   669,     0,     0,     0,     0,
       0,     0,    35,   418,  1007,  1691,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,   429,     0,     0,     0,     0,     0,     0,
       0,   430,   431,     0,   432,   433,   133,   434,   435,   436,
     135,   136,   137,   138,   139,     0,   437,   438,   439,   440,
     441,     0,     0,   442,   443,     0,   140,   444,     0,   445,
     446,   447,   448,   144,     0,   145,     0,   449,   450,   451,
     452,   148,   453,     0,     0,   454,   455,   456,   457,   458,
     459,     0,   151,   460,     0,     0,     0,     0,   152,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   155,   156,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,   489,   490,   164,   491,   492,   493,   166,  2079,   494,
       0,   495,   496,   168,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,     0,   507,   508,   173,   509,   510,   511,
       0,   512,   513,   514,   515,   516,   517,     0,   518,   174,
     175,     0,   519,   520,   521,     0,   176,     0,   177,     0,
     522,   178,   179,   523,   180,   524,   525,   526,   527,   528,
       0,   529,   530,     0,   531,   181,   182,   532,   183,     0,
     533,   534,   535,     0,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   543,     0,   544,   545,   546,   188,   189,
     190,   547,   548,   191,     0,   549,   550,   193,   551,     0,
     194,   552,   195,   553,   554,   555,     0,   556,  2080,     0,
     557,   558,   559,     0,     0,   560,   196,   197,   561,   198,
     199,   562,   563,   564,   565,   566,   567,   568,     0,   569,
     200,   570,   201,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   203,   582,   583,   584,   585,
       0,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   210,   599,   600,   212,   601,
     602,   603,   604,   605,   606,     0,   607,     0,   608,   609,
     610,   611,   612,     0,   613,   217,   614,   615,   219,   616,
     220,   617,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,     0,   628,   629,     0,   630,   631,
     632,   633,   634,   635,     0,   224,   225,     0,     0,   637,
     226,   638,   227,  2081,   639,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,     0,   234,     0,   656,   235,
     657,   658,   659,   660,     0,     0,   661,     0,     0,   662,
     663,   664,   665,   666,   667,   237,   238,   239,   240,   241,
     242,   243,   244,   245,     0,   668,   669,     0,     0,     0,
       0,     0,     0,    35,     0,  1007,  1691,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,  2079,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,  2080,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,  2081,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,     0,   668,   669,    35,   418,
       0,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   429,
       0,     0,     0,     0,     0,     0,     0,   430,   431,     0,
     432,   433,   133,   434,   435,   436,   135,   136,   137,   138,
     139,     0,   437,   438,   439,   440,   441,     0,     0,   442,
     443,     0,   140,   444,     0,   445,   446,   447,   448,   144,
       0,   145,     0,   449,   450,   451,   452,   148,   453,     0,
       0,   454,   455,   456,   457,   458,   459,     0,   151,   460,
       0,     0,     0,     0,   152,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   155,   156,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,   489,   490,   164,
     491,   492,   493,   166,     0,   494,     0,   495,   496,   168,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,     0,
     507,   508,   173,   509,   510,   511,     0,   512,   513,   514,
     515,   516,   517,     0,   518,   174,   175,     0,   519,   520,
     521,     0,   176,     0,   177,     0,   522,   178,   179,   523,
     180,   524,   525,   526,   527,   528,     0,   529,   530,     0,
     531,   181,   182,   532,   183,     0,   533,   534,   535,     0,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   543,
       0,   544,   545,   546,   188,   189,   190,   547,   548,   191,
       0,   549,   550,   193,   551,     0,   194,   552,   195,   553,
     554,   555,     0,   556,     0,     0,   557,   558,   559,     0,
       0,   560,   196,   197,   561,   198,   199,   562,   563,   564,
     565,   566,   567,   568,     0,   569,   200,   570,   201,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   203,   582,   583,   584,   585,     0,   586,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   210,   599,   600,   212,   601,   602,   603,   604,   605,
     606,     0,   607,     0,   608,   609,   610,   611,   612,     0,
     613,   217,   614,   615,   219,   616,   220,   617,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
       0,   628,   629,     0,   630,   631,   632,   633,   634,   635,
       0,   224,   225,   636,     0,   637,   226,   638,   227,     0,
     639,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,     0,   234,     0,   656,   235,   657,   658,   659,   660,
       0,     0,   661,     0,     0,   662,   663,   664,   665,   666,
     667,   237,   238,   239,   240,   241,   242,   243,   244,   245,
       0,   668,   669,    35,   418,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,  2285,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,  2059,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   668,   669,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
    2625,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,  2626,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,   130,   131,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,  1235,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,   508,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,  3514,   504,     0,   505,   506,     0,   507,
     508,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,   508,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   668,   669,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
     430,   431,     0,   432,   433,   133,   434,   435,   436,   135,
     136,   137,   138,   139,     0,   437,   438,   439,   440,   441,
       0,     0,   442,   443,     0,   140,   444,     0,   445,   446,
     447,   448,   144,     0,   145,     0,   449,   450,   451,   452,
     148,   453,     0,     0,   454,   455,   456,   457,   458,   459,
       0,   151,   460,     0,     0,     0,     0,   152,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   155,   156,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
     489,   490,   164,   491,   492,   493,   166,     0,   494,     0,
     495,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,     0,   507,   508,   173,   509,   510,   511,     0,
     512,   513,   514,   515,   516,   517,     0,   518,   174,   175,
       0,   519,   520,   521,     0,   176,     0,   177,     0,   522,
     178,   179,   523,   180,   524,   525,   526,   527,   528,     0,
     529,   530,     0,   531,   181,   182,   532,   183,     0,   533,
     534,   535,     0,     0,   536,   537,  1251,   539,   540,   541,
       0,   542,   543,     0,   544,   545,   546,   188,   189,   190,
     547,   548,   191,     0,   549,   550,   193,   551,     0,   194,
     552,   195,   553,   554,   555,     0,   556,     0,     0,   557,
     558,   559,     0,     0,   560,   196,   197,   561,   198,   199,
     562,   563,   564,   565,   566,   567,   568,     0,   569,   200,
     570,   201,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   203,   582,   583,   584,   585,     0,
     586,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   210,   599,   600,   212,   601,   602,
     603,   604,   605,   606,     0,   607,     0,   608,   609,   610,
     611,   612,     0,   613,   217,   614,   615,   219,   616,   220,
     617,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,     0,   628,   629,     0,   630,   631,   632,
     633,   634,   635,     0,   224,   225,     0,     0,   637,   226,
     638,   227,     0,   639,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,     0,   234,     0,   656,   235,   657,
     658,   659,   660,     0,     0,   661,     0,     0,   662,   663,
     664,   665,   666,   667,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   668,   669,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   429,     0,     0,     0,     0,     0,
       0,     0,   430,   431,     0,   432,   433,   133,   434,   435,
     436,   135,   136,   137,   138,   139,     0,   437,   438,   439,
     440,   441,     0,     0,   442,   443,     0,   140,   444,     0,
     445,   446,   447,   448,   144,     0,   145,     0,   449,   450,
     451,   452,   148,   453,     0,     0,   454,   455,   456,   457,
     458,   459,     0,   151,   460,     0,     0,     0,     0,   152,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   155,
     156,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,   489,   490,   164,   491,   492,   493,   166,     0,
     494,     0,   495,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,     0,   507,   508,   173,   509,   510,
     511,     0,   512,   513,   514,   515,   516,   517,     0,   518,
     174,   175,     0,   519,   520,   521,     0,   176,     0,   177,
       0,   522,   178,   179,   523,   180,   524,   525,   526,   527,
     528,     0,   529,   530,     0,   531,   181,   182,   532,   183,
       0,   533,   534,   535,     0,     0,   536,   537,  1329,   539,
     540,   541,     0,   542,   543,     0,   544,   545,   546,   188,
     189,   190,   547,   548,   191,     0,   549,   550,   193,   551,
       0,   194,   552,   195,   553,   554,   555,     0,   556,     0,
       0,   557,   558,   559,     0,     0,   560,   196,   197,   561,
     198,   199,   562,   563,   564,   565,   566,   567,   568,     0,
     569,   200,   570,   201,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   203,   582,   583,   584,
     585,     0,   586,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   210,   599,   600,   212,
     601,   602,   603,   604,   605,   606,     0,   607,     0,   608,
     609,   610,   611,   612,     0,   613,   217,   614,   615,   219,
     616,   220,   617,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,     0,   628,   629,     0,   630,
     631,   632,   633,   634,   635,     0,   224,   225,     0,     0,
     637,   226,   638,   227,     0,   639,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,     0,   234,     0,   656,
     235,   657,   658,   659,   660,     0,     0,   661,     0,     0,
     662,   663,   664,   665,   666,   667,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   668,   669,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   429,     0,     0,     0,
       0,     0,     0,     0,   430,   431,     0,   432,   433,   133,
     434,   435,   436,   135,   136,   137,   138,   139,     0,   437,
     438,   439,   440,   441,     0,     0,   442,   443,     0,   140,
     444,     0,   445,   446,   447,   448,   144,     0,   145,     0,
     449,   450,   451,   452,   148,   453,     0,     0,   454,   455,
     456,   457,   458,   459,     0,   151,   460,     0,     0,     0,
       0,   152,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   155,   156,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,   489,   490,   164,   491,   492,   493,
     166,     0,   494,     0,   495,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,     0,   507,  1368,   173,
     509,   510,   511,     0,   512,   513,   514,   515,   516,   517,
       0,   518,   174,   175,     0,   519,   520,   521,     0,   176,
       0,   177,     0,   522,   178,   179,   523,   180,   524,   525,
     526,   527,   528,     0,   529,   530,     0,   531,   181,   182,
     532,   183,     0,   533,   534,   535,     0,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   543,     0,   544,   545,
     546,   188,   189,   190,   547,   548,   191,     0,   549,   550,
     193,   551,     0,   194,   552,   195,   553,   554,   555,     0,
     556,     0,     0,   557,   558,   559,     0,     0,   560,   196,
     197,   561,   198,   199,   562,   563,   564,   565,   566,   567,
     568,     0,   569,   200,   570,   201,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   203,   582,
     583,   584,   585,     0,   586,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   210,   599,
     600,   212,   601,   602,   603,   604,   605,   606,     0,   607,
       0,   608,   609,   610,   611,   612,     0,   613,   217,   614,
     615,   219,   616,   220,   617,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,     0,   628,   629,
       0,   630,   631,   632,   633,   634,   635,     0,   224,   225,
       0,     0,   637,   226,   638,   227,     0,   639,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,     0,   234,
       0,   656,   235,   657,   658,   659,   660,     0,     0,   661,
       0,     0,   662,   663,   664,   665,   666,   667,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   668,   669,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,   429,     0,
       0,     0,     0,     0,     0,     0,   430,   431,     0,   432,
     433,   133,   434,   435,   436,   135,   136,   137,   138,   139,
       0,   437,   438,   439,   440,   441,     0,     0,   442,   443,
       0,   140,   444,     0,   445,   446,   447,   448,   144,     0,
     145,     0,   449,   450,   451,   452,   148,   453,     0,     0,
     454,   455,   456,   457,   458,   459,     0,   151,   460,     0,
       0,     0,     0,   152,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   155,   156,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,   489,   490,   164,   491,
     492,   493,   166,     0,   494,     0,   495,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,     0,   507,
    1378,   173,   509,   510,   511,     0,   512,   513,   514,   515,
     516,   517,     0,   518,   174,   175,     0,   519,   520,   521,
       0,   176,     0,   177,     0,   522,   178,   179,   523,   180,
     524,   525,   526,   527,   528,     0,   529,   530,     0,   531,
     181,   182,   532,   183,     0,   533,   534,   535,     0,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   543,     0,
     544,   545,   546,   188,   189,   190,   547,   548,   191,     0,
     549,   550,   193,   551,     0,   194,   552,   195,   553,   554,
     555,     0,   556,     0,     0,   557,   558,   559,     0,     0,
     560,   196,   197,   561,   198,   199,   562,   563,   564,   565,
     566,   567,   568,     0,   569,   200,   570,   201,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     203,   582,   583,   584,   585,     0,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     210,   599,   600,   212,   601,   602,   603,   604,   605,   606,
       0,   607,     0,   608,   609,   610,   611,   612,     0,   613,
     217,   614,   615,   219,   616,   220,   617,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,     0,
     628,   629,     0,   630,   631,   632,   633,   634,   635,     0,
     224,   225,     0,     0,   637,   226,   638,   227,     0,   639,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
       0,   234,     0,   656,   235,   657,   658,   659,   660,     0,
       0,   661,     0,     0,   662,   663,   664,   665,   666,   667,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     668,   669,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     429,     0,     0,     0,     0,     0,     0,     0,   430,   431,
       0,   432,   433,   133,   434,   435,   436,   135,   136,   137,
     138,   139,     0,   437,   438,   439,   440,   441,     0,     0,
     442,   443,     0,   140,   444,     0,   445,   446,   447,   448,
     144,     0,   145,     0,   449,   450,   451,   452,   148,   453,
       0,     0,   454,   455,   456,   457,   458,   459,     0,   151,
     460,     0,     0,     0,     0,   152,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   155,   156,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,   489,   490,
     164,   491,   492,   493,   166,     0,   494,     0,   495,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
       0,   507,  1389,   173,   509,   510,   511,     0,   512,   513,
     514,   515,   516,   517,     0,   518,   174,   175,     0,   519,
     520,   521,     0,   176,     0,   177,     0,   522,   178,   179,
     523,   180,   524,   525,   526,   527,   528,     0,   529,   530,
       0,   531,   181,   182,   532,   183,     0,   533,   534,   535,
       0,     0,   536,   537,  1390,   539,   540,   541,     0,   542,
     543,     0,   544,   545,   546,   188,   189,   190,   547,   548,
     191,     0,   549,   550,   193,   551,     0,   194,   552,   195,
     553,   554,   555,     0,   556,     0,     0,   557,   558,   559,
       0,     0,   560,   196,   197,   561,   198,   199,   562,   563,
     564,   565,   566,   567,   568,     0,   569,   200,   570,   201,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   203,   582,   583,   584,   585,     0,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   210,   599,   600,   212,   601,   602,   603,   604,
     605,   606,     0,   607,     0,   608,   609,   610,   611,   612,
       0,   613,   217,   614,   615,   219,   616,   220,   617,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,     0,   628,   629,     0,   630,   631,   632,   633,   634,
     635,     0,   224,   225,     0,     0,   637,   226,   638,   227,
       0,   639,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,     0,   234,     0,   656,   235,   657,   658,   659,
     660,     0,     0,   661,     0,     0,   662,   663,   664,   665,
     666,   667,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   668,   669
};

static const yytype_int16 yycheck[] =
{
       2,   246,   901,    78,   381,  1445,    78,    78,  1367,    78,
     381,   209,  1075,  1129,   858,  1124,   365,  1236,  1092,  1756,
     940,    78,   117,  1415,    78,  1371,   154,   150,  1194,    78,
      84,   167,   228,  1252,  1376,    84,  2360,  1017,  1018,  1019,
    1318,  1953,  1241,  1023,  2118,  1262,  1791,  1299,   153,  2859,
    1328,   187,  1628,  1937,  2424,  2425,  2262,   901,   730,   958,
    1797,  2068,  1535,   117,   984,  1478,  1240,   162,  3219,  1506,
    1507,   223,  1246,  2274,   202,  1082,    78,  1896,   160,  3195,
    1254,  2696,    84,   171,  1801,  1304,    96,    89,  1525,  1308,
     165,  3470,  1996,  2704,  1313,   940,   106,   960,   165,  1955,
    3407,  1320,  2324,  2566,  3432,  1357,  1645,   970,   162,    78,
    3714,  1330,  3014,  1811,   958,   117,  1847,  1407,  1685,  1686,
    1687,   209,  2661,   132,  1649,  3239,  2157,  3241,   117,     2,
    2616,  3459,   142,   731,  2838,   230,  3019,  3388,   353,  1171,
    3634,   367,  1859,  3080,  1171,  4022,  3375,   157,  3017,  3018,
    3763,   153,   208,  2057,  3816,  3767,  3014,  4033,  1078,  3388,
     162,   983,   218,  1739,   216,  1783,  1864,  1865,  2951,  1408,
     167,  3073,  4012,   162,  1399,   367,   230,  3666,  1797,  1680,
    1681,  2372,  3969,  1743,  3111,  4468,  1999,  1428,  2007,  1211,
     187,  1252,  1121,  3724,  1121,  3665,  3660,  3592,  4257,  3392,
    3393,  3394,  3395,  3396,  3397,    94,   208,  4574,    30,  4576,
    1166,  1167,    21,  3941,   216,  3073,   218,    14,  2424,   208,
    2411,    88,  4762,   108,  2415,   102,   975,   216,   230,   218,
      88,    10,    72,  1078,   128,    72,  2699,   121,    72,  4010,
      37,   230,   135,   132,    81,   128,   113,  1495,  1496,    86,
    4021,    84,    86,   143,   156,   927,   838,    95,   114,   114,
     204,  4615,   182,  1553,   153,   154,   112,   180,   112,   229,
    4755,   179,   173,  1521,   163,    72,   143,    72,    75,    76,
      77,    78,   268,    25,    81,    82,    83,    84,   210,    86,
     149,    86,    75,    76,    77,    78,    95,    78,   373,    82,
     229,   373,   373,  3086,   373,   128,   229,    78,   182,   235,
    2773,  2223,  2775,   202,   403,   117,   373,  1297,   232,    72,
     199,   145,  4701,   327,   117,   141,   180,   381,    81,   153,
     403,  5132,   381,    86,  1408,   103,   104,   385,    75,    76,
      77,    78,   224,    99,    78,    82,    75,    76,    77,    78,
     106,   229,   403,    82,   184,    78,   183,    78,   268,   197,
     162,    90,   416,   231,   221,     0,    78,   416,    99,   162,
      78,    75,    76,    77,    78,   106,    14,    88,    82,   381,
      14,   229,    99,  1282,    75,    76,    77,    78,  1554,   106,
     145,    82,    14,   180,   109,  1612,    78,   180,   197,   249,
    1072,   249,   113,    37,   373,    75,    76,    77,    78,   457,
      93,  2485,    82,  5214,   416,  1581,    78,    78,   362,   246,
      90,    78,    75,    76,    77,    78,   149,   516,   230,    82,
     230,   135,   143,    75,    76,    77,    78,   230,  1282,   269,
      82,   229,   165,   516,   318,   145,   229,  4814,    90,    75,
      76,    77,    78,   310,    78,   182,    82,   268,    78,   313,
     228,   329,   230,   840,  4747,   516,   185,  1940,   145,   840,
     145,   211,  1392,   188,   187,  4262,   173,   379,    75,    76,
      77,    78,  2673,   405,   398,    82,   380,    75,    76,    77,
      78,  1928,  1929,    90,    82,  1415,   102,   380,  1935,   400,
     377,  1575,    75,    76,    77,    78,   145,   511,  4887,    82,
     326,   515,   389,   427,  1377,  4840,  4841,    90,    75,    76,
      77,    78,   264,   246,   153,    82,   313,   210,   417,   515,
     438,   636,    75,    76,    77,    78,  2420,   391,    25,    82,
     460,    88,   341,  1617,  1618,   272,  1905,  1392,   458,    75,
      76,    77,    78,   513,   682,   683,    82,   380,    75,    76,
      77,    78,  1482,   440,  3757,    82,   113,  5052,  1910,   513,
    1168,  1169,   480,    88,  2430,   374,  2115,   423,   135,   423,
    2119,   436,  2121,   416,   513,  2124,   313,   500,  1451,   448,
     516,  3842,   373,   516,   473,  1417,   143,  1771,    75,    76,
      77,    78,   373,  1466,   403,    82,  1188,   463,    75,    76,
      77,    78,   436,  3842,   516,    82,  1479,  1152,   456,  3770,
     513,   511,   516,   463,  1843,   515,  1845,  4981,   513,   513,
    4470,   513,  5172,   516,   636,    99,   363,  1482,   516,   373,
     477,  2217,   509,  1921,   367,  4432,  1820,  1899,  1397,   458,
     373,   509,   373,   436,  1853,   411,  4150,    75,    76,    77,
      78,   373,   461,  3991,    82,   373,   516,   504,   505,  2109,
     504,   505,  4400,  4401,  4402,  4403,  4404,  1894,  1926,  1927,
     411,   436,  1217,  3146,   463,  4174,  1934,  1607,  2264,   511,
    4461,   373,  2268,   516,   411,  1615,  1616,  4484,   507,  4006,
     468,  4232,  4097,  4173,   387,   516,  5073,   504,   505,   504,
     505,   373,   373,   513,   866,  2061,   373,   500,   513,  4183,
     128,    72,   405,  4187,    75,    76,    77,    78,   516,   426,
      81,    82,   515,   473,    95,    86,   436,   456,  1667,   984,
    1667,   836,   847,  1699,  3114,   458,  3116,   636,   137,   373,
      99,   504,   505,   373,   160,  5080,  3658,  3950,  3660,   436,
    5043,   436,  1607,   467,   417,   418,  1827,  2580,  1790,  1830,
    2116,   377,   987,  4832,   511,  1124,   513,   264,   515,  2125,
     333,  2498,   836,   173,   513,  3936,   840,   892,   479,   516,
     180,   840,    88,   682,   683,   180,