/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.internal.ui.refactoring.AbstractChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;

public class CompositeChangeNode
extends AbstractChangeNode {
    private final RefactoringPreviewChangeFilter fFilter;

    public CompositeChangeNode(PreviewNode parent, RefactoringPreviewChangeFilter filter, CompositeChange change) {
        super(parent, (Change)change);
        this.fFilter = filter;
    }

    @Override
    int getActive() {
        return this.getCompositeChangeActive();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return RefactoringPluginImages.DESC_OBJS_COMPOSITE_CHANGE;
    }

    @Override
    PreviewNode[] doCreateChildren() {
        ArrayList<PreviewNode> children = new ArrayList<PreviewNode>();
        this.getFlattendedChildren(children, this, (CompositeChange)this.getChange());
        return children.toArray(new PreviewNode[children.size()]);
    }

    private void getFlattendedChildren(List<PreviewNode> result, CompositeChangeNode parent, CompositeChange focus) {
        Change[] changeArray = focus.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            if (this.fFilter == null || this.fFilter.select(change)) {
                if (change instanceof CompositeChange && ((CompositeChange)change).isSynthetic()) {
                    this.getFlattendedChildren(result, parent, (CompositeChange)change);
                } else {
                    result.add(CompositeChangeNode.createNode(parent, change));
                }
            }
            ++n2;
        }
    }
}

