Program OHFILTER;

uses strings;

var

    aa_date : string [6];
    aa_utc  : string [4];
    aa_call : string [12];
    aa_rstsent : string [3];
    aa_rstrcvd : string [3];
    aa_band : string [7];
    aa_mode : string [4];
    aa_ohc : string [3];
    aa_qth : string [3];
    aa_note : string [32];
    aa_qsl : char;

    ohc_exist : array [1..923] of boolean;
    ohc_name : array [1..923] of string[18];
    qsl_cw : array [1..923] of boolean;
    qsl_ssb : array [1..923] of boolean;
    qsl_mixed : array [1..923] of boolean;

    wkd_cw : array [1..923] of boolean;
    wkd_ssb : array [1..923] of boolean;
    wkd_mixed : array [1..923] of boolean;

    qsl_cw_c : integer;
    qsl_ssb_c : integer;
    qsl_mixed_c : integer;
    wkd_cw_c : integer;
    wkd_ssb_c : integer;
    wkd_mixed_c : integer;
    wtd_cw_c : integer;
    wtd_ssb_c : integer;
    wtd_mixed_c : integer;

    piiri : integer;

    procedure alusta_kuntaluettelo;

    var

        ohcfile : text;
        s : string;
        c : char;
        i,n,code : integer;

    begin
        assign (ohcfile,'OHFILTER.OHC');
        reset (ohcfile);
        while not eof(ohcfile) do
        begin
            readln(ohcfile,s);
            val(s,n,code);
            ohc_exist[n] := true;
            readln(ohcfile,s);
            ohc_name[n] := s;
        end;
        close (ohcfile);
    end;

    procedure lopeta;
    begin
       exit;
    end;

    procedure tarkista_piiri;

    var
        s : string;
        code : integer;

    begin
        repeat
            writeln('Mist piirist olet workkinut (0..9,A,Q)? ');
            readln(s);
            if ((s='Q') or (s='q')) then lopeta;
        until((s >= '0') and (s <='9')) or (s = 'a') or (s = 'A');
        val(s,piiri,code);
    end;

    procedure tarkista_kunnat;

    var
        aa_file : text;

        cw_file : text;
        ssb_file : text;
        mixed_file : text;

        cw_text : text;
        ssb_text : text;
        mixed_text : text;

        report_text : text;

        v : integer;
        i : integer;
        s : string;
        c : char;
        code : integer;



    begin

        qsl_cw_c := 0;
        qsl_ssb_c := 0;
        qsl_mixed_c := 0;
        wkd_cw_c := 0;
        wkd_ssb_c := 0;
        wkd_mixed_c := 0;
        wtd_cw_c := 0;
        wtd_ssb_c := 0;
        wtd_mixed_c := 0;

       { Ensimmisell kierroksella kirjoitetaan QSL-lokit }

        assign (aa_file,'OHC.LOG');

        assign (cw_file,'OHCQSLC.LOG');
        assign (ssb_file,'OHCQSLP.LOG');
        assign (mixed_file,'OHCQSLM.LOG');

        assign (cw_text,'OHCQSLC.TXT');
        assign (ssb_text,'OHCQSLP.TXT');
        assign (mixed_text,'OHCQSLM.TXT');

        writeln('QSL files assigned ok');

        reset (aa_file);
        rewrite (cw_file);
        rewrite (ssb_file);
        rewrite (mixed_file);
        rewrite (cw_text);
        rewrite (ssb_text);
        rewrite (mixed_text);

        writeln('QSL files opened ok');

        while not eof(aa_file) do
        begin
            aa_date := '';
            for i := 1 to 6 do
            begin
                read(aa_file,c);
                aa_date := aa_date + c;
            end;
            aa_utc := '';
            for i := 7 to 10 do
            begin
                read(aa_file,c);
                aa_utc := aa_utc + c;
            end;
            aa_call := '';
            for i := 11 to 22 do
            begin
                read(aa_file,c);
                aa_call := aa_call + c;
            end;
            aa_rstsent := '';
            for i := 23 to 25 do
            begin
                read(aa_file,c);
                aa_rstsent := aa_rstsent + c;
            end;
            aa_rstrcvd := '';
            for i := 26 to 28 do
            begin
                read(aa_file,c);
                aa_rstrcvd := aa_rstrcvd + c;
            end;
            aa_band := '';
            for i := 29 to 35 do
            begin
                read(aa_file,c);
                aa_band := aa_band + c;
            end;
            aa_mode := '';
            for i := 36 to 39 do
            begin
                read(aa_file,c);
                aa_mode := aa_mode + c;
            end;
            aa_ohc := '';
            for i := 40 to 42 do
            begin
                read(aa_file,c);
                aa_ohc := aa_ohc + c;
            end;
            aa_qth := '';
            for i := 43 to 45 do
            begin
                read(aa_file,c);
                aa_qth := aa_qth + c;
            end;
            aa_note := '';
            for i := 46 to 77 do
            begin
                read(aa_file,c);
                aa_note := aa_note + c;
            end;
            read(aa_file,aa_qsl);

            s := aa_qth;
            v := 0;
            val(s,v,code);

            if (int(v/100) = piiri) then
            begin
                val(aa_ohc,v,code);
                if code = 0 then
                begin
                    if ((aa_mode = 'CW  ') and (qsl_cw[v] = false)) then
                    begin
                        if ((aa_qsl = '2') or (aa_qsl = '3')) then
                        begin
                            qsl_cw_c := qsl_cw_c + 1;
                            write(cw_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                            qsl_cw[v] := true;
                            writeln(cw_text,aa_date,' ',
                                          aa_utc,' ',
                                          aa_rstsent,' ',
                                          aa_rstrcvd,' ',
                                          aa_band,' ',
                                          aa_mode,' ',
                                          aa_call,' ',
                                          'QSL ',
                                          aa_ohc,' ',
                                          ohc_name[v]);
                        end; {of if code is 2 or 3}
                    end; {of if cw and no qsl}

                    if ((aa_mode = 'SSB ') and (qsl_ssb[v] = false)) then
                    begin
                        if ((aa_qsl = '2') or (aa_qsl = '3')) then
                        begin
                           qsl_ssb_c := qsl_ssb_c + 1;
                           write(ssb_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                            qsl_ssb[v] := true;
                            writeln(ssb_text,aa_date+' ',
                                           aa_utc+' ',
                                           aa_rstsent+' ',
                                           aa_rstrcvd+' ',
                                           aa_band+' ',
                                           aa_mode+' ',
                                           aa_call+' ',
                                           'QSL ',
                                           aa_ohc+' ',
                                           ohc_name[v]);
                        end; {of if qsl code 2 or 3}
                     end; {of if ssb and no qsl}

                     if qsl_mixed[v] = false then
                     begin
                         if ((aa_qsl = '2') or (aa_qsl = '3')) then
                         begin
                             qsl_mixed_c := qsl_mixed_c + 1;
                             write(mixed_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                             qsl_mixed[v] := true;
                             writeln(mixed_text,aa_date,' ',
                                              aa_utc,' ',
                                              aa_rstsent,' ',
                                              aa_rstrcvd+' ',
                                              aa_band+' ',
                                              aa_mode+' ',
                                              aa_call+' ',
                                              'QSL ',
                                              aa_ohc+' ',
                                              ohc_name[v]);
                         end; {of if qsl code 2 or 3}
                     end; {of if qsl_mixed }
                end {of if code 0}
            end; {if in right province}
        end {of while eof};

        close (aa_file);
        close (cw_file);
        close (ssb_file);
        close (mixed_file);

        writeln (cw_text,'Yhteens QSL ',qsl_cw_c,' / 456 kuntaa');
        writeln (ssb_text,'Yhteens QSL ',qsl_ssb_c,' / 456 kuntaa');
        writeln (mixed_text,'Yhteens QSL ',qsl_mixed_c,' / 456 kuntaa');

        close (cw_text);
        close (ssb_text);
        close (mixed_text);

        writeln ('QSL logs written OK');

        { Toisella kierroksella kirjoitetaan WKD-lokiin QSL-kusot }
        { Ennen sit on resetoitava QSL-liput }

        for i := 1 to 923 do
        begin
            qsl_cw[i] := false;
            qsl_ssb[i] := false;
            qsl_mixed[i] := false;
        end;

        assign (cw_file,'OHCWKDC.LOG');
        assign (ssb_file,'OHCWKDP.LOG');
        assign (mixed_file,'OHCWKDM.LOG');

        assign (cw_text,'OHCWKDC.TXT');
        assign (ssb_text,'OHCWKDP.TXT');
        assign (mixed_text,'OHCWKDM.TXT');

        writeln('WKD files assigned ok');

        reset (aa_file);
        rewrite (cw_file);
        rewrite (ssb_file);
        rewrite (mixed_file);
        rewrite (cw_text);
        rewrite (ssb_text);
        rewrite (mixed_text);

        writeln('WKD files opened ok');

        while not eof(aa_file) do
        begin
            aa_date := '';
            for i := 1 to 6 do
            begin
                read(aa_file,c);
                aa_date := aa_date + c;
            end;
            aa_utc := '';
            for i := 7 to 10 do
            begin
                read(aa_file,c);
                aa_utc := aa_utc + c;
            end;
            aa_call := '';
            for i := 11 to 22 do
            begin
                read(aa_file,c);
                aa_call := aa_call + c;
            end;
            aa_rstsent := '';
            for i := 23 to 25 do
            begin
                read(aa_file,c);
                aa_rstsent := aa_rstsent + c;
            end;
            aa_rstrcvd := '';
            for i := 26 to 28 do
            begin
                read(aa_file,c);
                aa_rstrcvd := aa_rstrcvd + c;
            end;
            aa_band := '';
            for i := 29 to 35 do
            begin
                read(aa_file,c);
                aa_band := aa_band + c;
            end;
            aa_mode := '';
            for i := 36 to 39 do
            begin
                read(aa_file,c);
                aa_mode := aa_mode + c;
            end;
            aa_ohc := '';
            for i := 40 to 42 do
            begin
                read(aa_file,c);
                aa_ohc := aa_ohc + c;
            end;
            aa_qth := '';
            for i := 43 to 45 do
            begin
                read(aa_file,c);
                aa_qth := aa_qth + c;
            end;
            aa_note := '';
            for i := 46 to 77 do
            begin
                read(aa_file,c);
                aa_note := aa_note + c;
            end;
            read(aa_file,aa_qsl);

            s := aa_qth;
            v := 0;
            val(s,v,code);

            if (int(v/100) = piiri) then
            begin
                val(aa_ohc,v,code);
                if code = 0 then
                begin
                    if ((aa_mode = 'CW  ') and (qsl_cw[v] = false)) then
                    begin
                        if ((aa_qsl = '2') or (aa_qsl = '3')) then
                        begin
                            wkd_cw_c := wkd_cw_c + 1;
                            write(cw_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                            qsl_cw[v] := true;
                            wkd_cw[v] := true;
                            writeln(cw_text,aa_date,' ',
                                          aa_utc,' ',
                                          aa_rstsent,' ',
                                          aa_rstrcvd,' ',
                                          aa_band,' ',
                                          aa_mode,' ',
                                          aa_call,' ',
                                          'QSL ',
                                          aa_ohc,' ',
                                          ohc_name[v]);
                        end; {of if qsl code 2 or 3}
                    end; {of if no qsl and cw}

                    if ((aa_mode = 'SSB ') and (qsl_ssb[v] = false)) then
                    begin
                        if ((aa_qsl = '2') or (aa_qsl = '3')) then
                        begin
                           wkd_ssb_c := wkd_ssb_c + 1;
                           write(ssb_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                            qsl_ssb[v] := true;
                            wkd_ssb[v] := true;
                            writeln(ssb_text,aa_date+' ',
                                           aa_utc+' ',
                                           aa_rstsent+' ',
                                           aa_rstrcvd+' ',
                                           aa_band+' ',
                                           aa_mode+' ',
                                           aa_call+' ',
                                           'QSL ',
                                           aa_ohc+' ',
                                           ohc_name[v]);
                        end;
                     end;

                     if qsl_mixed[v] = false then
                     begin
                         if ((aa_qsl = '2') or (aa_qsl = '3')) then
                         begin
                             wkd_mixed_c := wkd_mixed_c + 1;
                             write(mixed_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                             qsl_mixed[v] := true;
                             wkd_mixed[v] := false;
                             writeln(mixed_text,aa_date,' ',
                                              aa_utc,' ',
                                              aa_rstsent,' ',
                                              aa_rstrcvd+' ',
                                              aa_band+' ',
                                              aa_mode+' ',
                                              aa_call+' ',
                                              'QSL ',
                                              aa_ohc+' ',
                                              ohc_name[v]);
                         end; {of if qsl code 2 or 3}
                     end; {of if qsl_mixed }
                end {of if code 0}
            end; {if in right province}
        end {of while eof};

        { Kolmannella kierroksella listn WKD-lokiin WKD-kusot }

        reset (aa_file);

        writeln('WKD files reset ok');

        while not eof(aa_file) do
        begin
            aa_date := '';
            for i := 1 to 6 do
            begin
                read(aa_file,c);
                aa_date := aa_date + c;
            end;
            aa_utc := '';
            for i := 7 to 10 do
            begin
                read(aa_file,c);
                aa_utc := aa_utc + c;
            end;
            aa_call := '';
            for i := 11 to 22 do
            begin
                read(aa_file,c);
                aa_call := aa_call + c;
            end;
            aa_rstsent := '';
            for i := 23 to 25 do
            begin
                read(aa_file,c);
                aa_rstsent := aa_rstsent + c;
            end;
            aa_rstrcvd := '';
            for i := 26 to 28 do
            begin
                read(aa_file,c);
                aa_rstrcvd := aa_rstrcvd + c;
            end;
            aa_band := '';
            for i := 29 to 35 do
            begin
                read(aa_file,c);
                aa_band := aa_band + c;
            end;
            aa_mode := '';
            for i := 36 to 39 do
            begin
                read(aa_file,c);
                aa_mode := aa_mode + c;
            end;
            aa_ohc := '';
            for i := 40 to 42 do
            begin
                read(aa_file,c);
                aa_ohc := aa_ohc + c;
            end;
            aa_qth := '';
            for i := 43 to 45 do
            begin
                read(aa_file,c);
                aa_qth := aa_qth + c;
            end;
            aa_note := '';
            for i := 46 to 77 do
            begin
                read(aa_file,c);
                aa_note := aa_note + c;
            end;
            read(aa_file,aa_qsl);

            s := aa_qth;
            v := 0;
            val(s,v,code);

            if (int(v/100) = piiri) then
            begin
                val(aa_ohc,v,code);
                if code = 0 then
                begin
                    if ((aa_mode = 'CW  ') and (qsl_cw[v] = false)) then
                    begin
                        if wkd_cw[v] = false then
                             wkd_cw_c := wkd_cw_c + 1;
                            write(cw_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                            wkd_cw[v] := true;
                            writeln(cw_text,aa_date,' ',
                                          aa_utc,' ',
                                          aa_rstsent,' ',
                                          aa_rstrcvd,' ',
                                          aa_band,' ',
                                          aa_mode,' ',
                                          aa_call,' ',
                                          'WKD ',
                                          aa_ohc,' ',
                                          ohc_name[v]);
                    end;

                    if ((aa_mode = 'SSB ') and (qsl_ssb[v] = false)) then
                    begin
                        if wkd_ssb[v] = false then
                           wkd_ssb_c := wkd_ssb_c + 1;
                           write(ssb_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                            wkd_ssb[v] := true;
                            writeln(ssb_text,aa_date+' ',
                                           aa_utc+' ',
                                           aa_rstsent+' ',
                                           aa_rstrcvd+' ',
                                           aa_band+' ',
                                           aa_mode+' ',
                                           aa_call+' ',
                                           'WKD ',
                                           aa_ohc+' ',
                                           ohc_name[v]);
                     end;

                     if qsl_mixed[v] = false then

                     begin
                         if wkd_mixed[v] = false then
                             wkd_mixed_c := wkd_mixed_c + 1;
                             write(mixed_file,aa_date,
                                  aa_utc,
                                  aa_call,
                                  aa_rstsent,
                                  aa_rstrcvd,
                                  aa_band,
                                  aa_mode,
                                  aa_ohc,
                                  aa_qth,
                                  aa_note,
                                  aa_qsl);
                             wkd_mixed[v] := true;
                             writeln(mixed_text,aa_date,' ',
                                              aa_utc,' ',
                                              aa_rstsent,' ',
                                              aa_rstrcvd+' ',
                                              aa_band+' ',
                                              aa_mode+' ',
                                              aa_call+' ',
                                              'WKD ',
                                              aa_ohc+' ',
                                              ohc_name[v]);
                     end; {of if qsl_mixed }
                end {of if code 0}
            end; {if in right province}
        end {of while eof};

        close (aa_file);
        close (cw_file);
        close (ssb_file);
        close (mixed_file);

        writeln (cw_text,'Yhteens WKD ',wkd_cw_c,' / 456 kuntaa');
        writeln (ssb_text,'Yhteens WKD ',wkd_ssb_c,' / 456 kuntaa');
        writeln (mixed_text,'Yhteens WKD ',wkd_mixed_c,' / 456 kuntaa');

        close (cw_text);
        close (ssb_text);
        close (mixed_text);

        writeln ('WKD logs written OK.');

        assign (cw_file,'OHCWTDC.TXT');
        assign (ssb_file,'OHCWTDP.TXT');
        assign (mixed_file,'OHCWTDM.TXT');

        rewrite(cw_file);
        rewrite(ssb_file);
        rewrite(mixed_file);

        writeln('WTD files opened OK');
        for i := 1 to 923 do
        begin
             if (ohc_exist[i] = true) then
             begin
                  if (qsl_cw[i] = false) then
                  begin
                       if i < 10 then write(cw_file,'0');
                       if i < 100 then write(cw_file,'0');
                       write(cw_file,i);
                       if wkd_cw[i] = true then
                           write(cw_file,' WKD ')
                       else
                           write(cw_file,'     ');
                       writeln(cw_file,ohc_name[i]);
                  end;
                  if (qsl_ssb[i] = false) then
                  begin
                       if i < 10 then write(ssb_file,'0');
                       if i < 100 then write(ssb_file,'0');
                       write(ssb_file,i);
                       if wkd_ssb[i] = true then
                           write(ssb_file,' WKD ')
                       else
                           write(ssb_file,'     ');
                       writeln(ssb_file,ohc_name[i]);
                  end;
                  if (qsl_mixed[i] = false) then
                  begin
                       if i < 10 then write(mixed_file,'0');
                       if i < 100 then write(mixed_file,'0');
                       write(mixed_file,i);
                       if wkd_mixed[i] = true then
                           write(mixed_file,' WKD ')
                       else
                           write(mixed_file,'     ');
                       writeln(mixed_file,ohc_name[i]);
                  end;
             end;
        end;

        writeln(cw_file,
                'Wanted: QSL ',456-qsl_cw_c, ' / 456, WKD ',456-wkd_cw_c,' / 456');
        writeln(ssb_file,
                'Wanted: QSL ',456-qsl_ssb_c, ' / 456, WKD ',456-wkd_ssb_c,' / 456');
        writeln(mixed_file,
                'Wanted: QSL ',456-qsl_mixed_c, ' / 456, WKD ',456-wkd_mixed_c,' / 456');

        close(cw_file);
        close(ssb_file);
        close(mixed_file);

        assign(report_text,'OHCRPRT.TXT');
        rewrite(report_text);

        writeln(report_text,'Missing OH Counties');
        writeln(report_text,'');
        writeln(report_text,'WKD (QSL)');
        writeln(report_text,'');
        writeln(report_text,'CW    ',456-wkd_cw_c,' (',456-qsl_cw_c,')');
        writeln(report_text,'SSB   ',456-wkd_ssb_c,' (',456-qsl_ssb_c,')');
        writeln(report_text,'Mixed ',456-wkd_mixed_c,' (',456-qsl_mixed_c,')');

        close(report_text);

        writeln('WTD files written OK');

    end;

begin
    alusta_kuntaluettelo;
    tarkista_piiri;
    tarkista_kunnat;
    lopeta;
end.
