; W9GR 1kHz super CW filter
; Ported to the TI 320C26 DSK by Johan Forrer KC7WW Jan. 1994
; Bug fixes reported by Tom, HB9JNX re: SUB 1000, SUBK 1,15 etc.
; Added LED outputs
; FS = 12500 HZ, 4X OVERSAMPLING AT INPUT AND OUTPUT
; FIR SAMPLING FREQUENCY = 3125 HZ
; CENTER FREQUENCY = 1000 HZ
; BANDWIDTH = 150 HZ (APPROXIMATELY 200 HZ @ -3 DB)

BIOZ_0  .set	1
BIOZ_1  .set	0

CONF_1	.set	0
CONF_2  .set	1
 .if CONF_1 
	.ds	0x400		; beginning of data
 .endif
 .if CONF_2 
	.ds	0x600		; beginning of data
 .endif
;    				; AIC working parameters
;-----------------------------------------------------------------------------
TA	.set    20         	;
RA	.set    20         	;
TAp	.set    1          	;
RAp	.set    1          	;
TB	.set    20         	;
RB	.set    20         	;
AIC_CMD	.set    028h		; bit    0     =enable/disable input bandpass
				;        1     =enable/disable loopback
				;        2     =enable/disable AUX input
				;        3     =sync I/O
				; bits 5&4: 11 =+/-6V    
				;           01h=+/-3V
				;           10h=+/-1.5V
;-----PAGE 12----------------------------------------------------------------
page12:
SIGIN:   .word	0     		; INPUT SAMPLES
SIGIN1:  .word	0
SIGIN2:  .word	0
SIGIN3:  .word	0

SIGOUT:  .word	0     		; OUTPUT SAMPLES
SIGOUT1: .word	0
SIGOUT2: .word	0
SIGOUT3: .word	0

LPFI1:  .word	0  	; INPUT INTERPOLATOR 1
LPFI11:	.word 	0
LPFI12:	.word 	0
LPFI13:	.word 	0
LPFI14:	.word 	0
LPFI15:	.word 	0
LPFI16:	.word 	0
LPFI17: .word   0
LPFI18: .word	0

LPFI2:   .word 	0 	; INPUT INTERPOLATOR 2
LPFI21:	 .word	0
LPFI22:	 .word	0
LPFI23:	 .word	0
LPFI24:	 .word	0
LPFI25:	 .word	0
LPFI26:	 .word	0
LPFI27:	 .word	0
LPFI28:  .word  0
LPFI29:  .word  0
LPFI210:  .word  0
LPFI211:  .word  0
LPFI212:  .word  0

BPF:     .word     0,0,0,0,0,0,0,0,0,0   ; BANDPASS FILTER DELAY
BPF10    .word     0,0,0,0,0,0,0,0,0,0 
BPF20    .word     0,0,0,0,0,0,0,0,0,0 
BPF30    .word     0,0,0,0,0,0,0,0,0,0 
BPF40    .word     0,0,0,0,0,0,0,0,0,0 
BPF50    .word     0,0,0,0,0,0,0,0,0,0 
BPF60    .word     0,0,0,0,0,0,0,0,0,0 
BPF70    .word     0,0,0,0,0,0,0,0,0,0 
BPF80    .word     0
BPF81	 .word	   0

BPFOUT:  .word     0       	; BANDPASS FILTER OUTPUT
LED:     .word     0       	; LED DISPLAY - also use for temporary
SQUARE:  .word     0       	; INPUT SQUARED
TEMP:    .word     0       	; TEMPORARY STORAGE
ONE:   .word	   1

LPFO1:   .word  0  		; OUTPUT INTERPOLATOR 1
LPFO11:	 .word 	0 		; 6 taps
LPFO12:	 .word	0
LPFO13:	 .word	0
LPFO14:	 .word	0
LPFO15:	 .word	0

LPFO2:   .word  0     		; OUTPUT INTERPOLATOR 2
LPFO21:	 .word	0		; 4 taps
LPFO22:	 .word	0
LPFO23:	 .word	0

DITHER:  .word	   1       	; DITHER PSEUDORANDOM SEQUENCE

;-----PAGE 13----------------------------------------------------------------

; ELLIPTIC IIR HPF DATA:
; N=2 PASS 300 HZ REJ 20 HZ 0.5 DB/50 DB
; FS = 3125 HZ
; HPF COEFFICIENTS:
HPF:	.word   2853
HPF1:	.word  -5704
HPF2:	.word   2853
HPF3:	.word   5658
HPF4:	.word  -2333

INP:   .word   0       	; INPUT DELAY - USED FOR HPF
INP1:	.word	0
INP2:	.word	0

DENOM:  .word   0       	; INPUT HPF DENOMINATOR DELAY
DENOM1:	.word	0
;----------------------------------------------------------------------------
;              FINITE IMPULSE RESPONSE (FIR)
;            LINEAR PHASE DIGITAL FILTER DESIGN
;                REMEZ EXCHANGE ALGORITHM
;
;                     BANDPASS FILTER
;
;                   FILTER LENGTH =  82
;
;              ***** IMPULSE RESPONSE *****
;         H( 1) =      69.462 = H( 82)
;         H( 2) =     -57.109 = H( 81)
;         H( 3) =     -51.212 = H( 80)
;         H( 4) =     124.731 = H( 79)
;         H( 5) =     -67.342 = H( 78)
;         H( 6) =    -112.101 = H( 77)
;         H( 7) =     168.370 = H( 76)
;         H( 8) =     -35.166 = H( 75)
;         H( 9) =    -139.196 = H( 74)
;         H(10) =     121.212 = H( 73)
;         H(11) =       5.330 = H( 72)
;         H(12) =     -45.744 = H( 71)
;         H(13) =     -21.071 = H( 70)
;         H(14) =     -35.122 = H( 69)
;         H(15) =     203.506 = H( 68)
;         H(16) =    -168.662 = H( 67)
;         H(17) =    -224.986 = H( 66)
;         H(18) =     515.356 = H( 65)
;         H(19) =    -190.737 = H( 64)
;         H(20) =    -502.538 = H( 63)
;         H(21) =     683.771 = H( 62)
;         H(22) =     -48.015 = H( 61)
;         H(23) =    -637.753 = H( 60)
;         H(24) =     529.262 = H( 59)
;         H(25) =      98.797 = H( 58)
;         H(26) =    -344.629 = H( 57)
;         H(27) =      78.434 = H( 56)
;         H(28) =     -70.434 = H( 55)
;         H(29) =     497.058 = H( 54)
;         H(30) =    -372.420 = H( 53)
;         H(31) =    -823.878 = H( 52)
;         H(32) =    1673.040 = H( 51)
;         H(33) =    -406.914 = H( 50)
;         H(34) =   -2127.131 = H( 49)
;         H(35) =    2681.526 = H( 48)
;         H(36) =     218.871 = H( 47)
;         H(37) =   -3559.063 = H( 46)
;         H(38) =    3011.477 = H( 45)
;         H(39) =    1351.544 = H( 44)
;         H(40) =   -4501.184 = H( 43)
;         H(41) =    2475.272 = H( 42)
;
;                       BAND  1       BAND  2       BAND  3
; LOWER BAND EDGE      .0000000      .2960000      .3712000
; UPPER BAND EDGE      .2688000      .3440000      .5000000
; DESIRED VALUE        .0000000     1.0000000      .0000000
; WEIGHTING          10.0000000     1.0000000    10.0000000
; DEVIATION            .0021601      .0216009      .0021601
; DEVIATION IN DB   -53.3105500      .1856256   -53.3105500
;
h0	.word    69.462
	.word   -57.109
	.word   -51.212
	.word   124.731
	.word   -67.342
	.word  -112.101
	.word   168.370
	.word   -35.166
	.word  -139.196
	.word   121.212
	.word     5.330
	.word   -45.744
	.word   -21.071
	.word   -35.122
	.word   203.506
	.word  -168.662
	.word  -224.986
	.word   515.356
	.word  -190.737
	.word  -502.538
	.word   683.771
	.word   -48.015
	.word  -637.753
	.word   529.262
	.word    98.797
	.word  -344.629
	.word    78.434
	.word   -70.434
	.word   497.058
	.word  -372.420
	.word  -823.878
	.word  1673.040
	.word  -406.914
	.word -2127.131
	.word  2681.526
	.word   218.871
	.word -3559.063
	.word  3011.477
	.word  1351.544
	.word -4501.184
	.word  2475.272
	.word 2475.272
	.word -4501.184
	.word 1351.544
	.word 3011.477
	.word -3559.063
	.word  218.871
	.word 2681.526
	.word -2127.131
	.word -406.914
	.word 1673.040
	.word -823.878
	.word -372.420
	.word  497.058
	.word  -70.434
	.word   78.434
	.word -344.629
	.word   98.797
	.word  529.262
	.word -637.753
	.word  -48.015
	.word  683.771
	.word -502.538
	.word -190.737
	.word  515.356
	.word -224.986
	.word -168.662
	.word  203.506
	.word  -35.122
	.word  -21.071
	.word  -45.744
	.word    5.330
	.word  121.212
	.word -139.196
	.word  -35.166
	.word  168.370
	.word -112.101
	.word  -67.342
	.word  124.731
	.word  -51.212
h80	.word  -57.109
h81	.word   69.462

;----------------------------------------------------------------------------
; FIRST INTERPOLATION/DECIMATION HALF BAND FILTER 12500 HZ <> 6250 HZ
;
;                FINITE IMPULSE RESPONSE (FIR)
;              LINEAR PHASE DIGITAL FILTER DESIGN
;                  REMEZ EXCHANGE ALGORITHM
;
;                       BANDPASS FILTER
;
;                     FILTER LENGTH =   9
;
;                ;**** IMPULSE RESPONSE *****
;
;
;              H( 1) =  -.17244020E-04 = H(  9)
;              H( 2) =  -.35323790E-01 = H(  8)
;              H( 3) =   .58424450E-04 = H(  7)
;              H( 4) =   .28500050E+00 = H(  6)
;              H( 5) =   .49991770E+00 = H(  5)
;
;                         BAND  1       BAND  2
;   LOWER BAND EDGE      .0000000      .4360000
;   UPPER BAND EDGE      .0640000      .5000000
;   DESIRED VALUE       1.0000000      .0000000
;   WEIGHTING           1.0000000     1.0000000
;   DEVIATION            .0006465      .0006465
;   DEVIATION IN DB      .0056136   -63.7885900
;
j0	.word	0
j1	.word	-145
j2	.word	0
j3	.word	1167
j4	.word	2048
j5	.word	1167
j6	.word	0
j7	.word	-145
j8	.word	0

;----------------------------------------------------------------------------
; SECOND INTERPOLATOR/DECIMATOR HALF BAND FILTER 6250 HZ <> 3125 HZ
;*********************************************************************
;
;                FINITE IMPULSE RESPONSE (FIR)
;              LINEAR PHASE DIGITAL FILTER DESIGN
;                  REMEZ EXCHANGE ALGORITHM
;
;                       BANDPASS FILTER
;
;                     FILTER LENGTH =  13
;
;       ***** IMPULSE RESPONSE *****
;         
;
;
;              H( 1) =   .66367920E-05 = H( 13)
;              H( 2) =   .13592210E-01 = H( 12)
;              H( 3) =  -.16377250E-04 = H( 11)
;              H( 4) =  -.64672420E-01 = H( 10)
;              H( 5) =   .25843950E-04 = H(  9)
;              H( 6) =   .30201130E+00 = H(  8)
;              H( 7) =   .49996780E+00 = H(  7)
;
;                         BAND  1       BAND  2
;   LOWER BAND EDGE      .0000000      .3720000
;   UPPER BAND EDGE      .1280000      .5000000
;   DESIRED VALUE       1.0000000      .0000000
;   WEIGHTING           1.0000000     1.0000000
;   DEVIATION            .0018621      .0018621
;   DEVIATION IN DB      .0161592   -54.5997800
;---------------------------------------------------------------------------
k0	.word	0
k1 	.word	56 
k2	.word	0
k3	.word	-265
k4	.word	0
k5	.word	1237
k6	.word	2048
k7	.word	1237
k8	.word	0
k9	.word	-265
k10	.word	0
k11	.word	56
k12	.word	0
;----------------------------------------------------------------------------
;
;       At 250 WPM there are 208 elements/S or 104 Hz
;	We average over 16 elements - at 3125 Hz, this amounts to 5ms signal
;
df0	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
	.word  0
df14	.word  0
df15	.word  0

;---------------------------------------------------------------------------

	.include  "mmregs.asm"
        .ps     0xFA0A          ;
        B	RINT            ;FA0A  RINT
        .ps     0xFA0C          ;
	B	XINT		;FA0C  XINT

***********************************************************************
        .ps     0xFB00		; Bootloader transfers here
	.entry                  ; This is a must!

	SOVM
	ssxm			; set sign extention mode 
* Reset and initialze the AIC
	call	AIC_SET 
	eint			; Turn interrupts on

*----------------------------------------------------------------------------
; Lets spread the computational load over the x4 decimation/interpolation
AGAIN:
	idle
	call	LPFI1a

	ldpk	SIGOUT
	lac     SIGOUT		; output first sample
	call	DA_DISP
;----------------------------1
	idle
	call	LPFI1b
	call	LPFI2a

	ldpk	SIGOUT
	lac     SIGOUT1		; output second sample
	call	DA_DISP
;----------------------------2
	idle
	call	LPFI1a

	ldpk	SIGOUT
	lac     SIGOUT2		; output third sample
	call	DA_DISP
;----------------------------3
	idle
	call	LPFI1b
	call	LPFI2b

	ldpk	SIGOUT
	lac     SIGOUT3		; output fourth sample
	call	DA_DISP
;----------------------------4

	call	HPFa
	call	BPFa
	call	OUTSIG

	b	AGAIN

;----------------------------------------------------------------------------
; FIRST INTERPOLATOR DATA MOVE PASS 1
LPFI1a:
	ldpk	LPFI1
	DMOV    LPFI17
	DMOV    LPFI16
	DMOV    LPFI15	     ; all page 12
	DMOV    LPFI14
	DMOV    LPFI13
	DMOV    LPFI12
	DMOV    LPFI11
	DMOV    LPFI1

        ldpk     DRR         ; point to memory mapped serial port recieve reg
        lac      DRR         ; load accumulator with word received from AIC
        sfr                  ; shift right twice to remove unused lsb's
        sfr                  ;
	ldpk	LPFI1
	SACL    LPFI1   	; PUT INTO FIRST INTERPOLATOR

	ret

;----------------------------------------------------------------------------
; INPUT INTERPOLATOR 1 PASS 1
LPFI1b:
        larp     0
        lrlk     AR0,LPFI18  ; load AR0 with address of last delay element
	lrlk     AR1,j8      ; load AR1 with address of last filter coeff
        lark     AR2,7       ; load AR2 with loop counter
        zac
        lt       *-,AR1
        mpy      *-,AR0

ilp1:   ltd	 *-,AR1	     ; ARP=0 (Xn)  *NOTE* shifting input delay line 
        mpy      *-,AR2
        banz     ilp1,*-,AR0
        apac
	ADLK    1,11  	     ; ADD 0.5 TO ROUND	  ===JF===

	ldpk	TEMP	     ; set page 12
	SACH    TEMP,4 	     ; SAVE for 2ND INTERP W/ SHIFT

        ldpk     DRR         ; point to memory mapped serial port recieve reg
        lac      DRR         ; load accumulator with word received from AIC
        sfr                  ; shift right twice to remove unused lsb's
        sfr                  ;
	ldpk	LPFI1
	SACL    LPFI1        ; PUT INTO FIRST INTERPOLATOR

	ret

;----------------------------------------------------------------------------
LPFI2a:
; SECOND INTERPOLATOR DATA MOVE

	ldpk	LPFI2
	DMOV    LPFI211
	DMOV    LPFI210
	DMOV    LPFI29	     ; all page 12
	DMOV    LPFI28
	DMOV    LPFI27
	DMOV    LPFI26
	DMOV    LPFI25
	DMOV    LPFI24
	DMOV    LPFI23
	DMOV    LPFI22
	DMOV    LPFI21
	DMOV    LPFI2

	ldpk	TEMP
	lac	TEMP
	sacl	LPFI2
	ret

;----------------------------------------------------------------------------
; INPUT INTERPOLATOR 2
LPFI2b:
        larp     0
        lrlk     AR0,LPFI212 ; load AR0 with address of last delay element
	lrlk     AR1,k12     ; load AR1 with address of last filter coeff
        lark     AR2,11      ; load AR2 with loop counter
        zac
        lt       *-,AR1
        mpy      *-,AR0

ilp2:  ltd	 *-,AR1	     ; ARP=0 (Xn)  *NOTE* shifting input delay line 
        mpy      *-,AR2
        banz     ilp2,*-,AR0
        apac
	ADLK    1,11  	     ; ADD 0.5 TO ROUND

	LDPK    INP
	SACH    INP,4        ; SAVE TO HPF W/ SHIFT

	ldpk	TEMP
	lac	TEMP
	sacl	LPFI2
	ret
;----------------------------------------------------------------------------
; INPUT HIGHPASS FILTER, FS=3125, PASS 300 REJ 20.5 0.5/50 DB N=2
;       NUMERATOR:
HPFa:

	LDPK    INP
	ZAC
	LT      INP2
	MPY     HPF
	LTD     INP1
	MPY     HPF1
	LTD     INP
	MPY     HPF2

;       DENOMINATOR:

	LTA     DENOM1
	MPY     HPF4
	LTD     DENOM
	MPY     HPF3
	APAC

	ADLK    1,11         ; ADD 0.5 TO ROUND
	SACH    DENOM,4      ; SAVE WITH SHIFT

	LDPK    BPF
	SACH    BPF,4        ; ALSO SAVE IN BPF INPUT

	ret
;---------------------------------------------------------------------------
; BANDPASS FILTER
BPFa:
	
;    First form the dither word
;    15 BITS EXTENDED TO 16
;    BIT0 = BIT13 XOR BIT14

	ldpk	DITHER
	LAC     DITHER,2     ; SHIFT BIT14 TO MSB-HI
	SACH    TEMP         ; STORE TEMPORARILY
	LAC     DITHER,3     ; SHIFT BIT13 TO MSB-HI
	SACH    LED          ; STORE TEMPORARILY IN LED
	LAC     TEMP
	XOR     LED          ; FORM XOR
	ANDK    1            ; IGNORE ALL BUT LSB
	ADD     DITHER,1     ; SHIFT UP ONE BIT
	SACL    DITHER       ; STORE NEW DITHER WORD

; CW BANDPASS FILTER
        larp     0
        lrlk     AR0,BPF81   ; load AR0 with address of last delay element
	lrlk     AR1,h81     ; load AR1 with address of last filter coeff
        lark     AR2,80      ; load AR2 with loop counter

	LAC     DITHER,4     ; LOAD ACCUM WITH SHIFTED DITHER
        lt       *-,AR1
        mpy      *-,AR0

cw1:  	ltd	 *-,AR1	     ; ARP=0 (Xn)  *NOTE* shifting input delay line 
        mpy      *-,AR2
        banz     cw1,*-,AR0
        apac

	ADLK    1,11         ; ADD 0.5 TO ROUND	   ===JF===
	SACH    BPFOUT,4     ; BPF OUTPUT


	ldpk	TEMP
	SACH    TEMP,4
	ZALH    TEMP		; display on LED Display
	CALL	BARGRA
	ldpk	BPFOUT

;
; Do envelope detection for outputting signal via flag
		   	     ; first move delay line

        larp     0
        lrlk     AR0,df14    ; load AR0 with address of 2nd to last
	rptk	14
  	dmov	 *-,AR0

	lac	BPFOUT
	abs
	ldpk	df0   		; save in digital data delay
	sacl	df0
* 
* Simple CW thresholder
*
        larp     0
        lrlk     AR0,df15    ; load AR0 with address of last delay element
	zac    			; average over 16 elements
	rptk	15
  	add	 *-

	sfr
	sfr
	sfr
	sfr

	sblk	1000

	bgez	setflag	
	sxf			; reset flag
	b	getout
setflag:
	rxf	  		; set flag

getout:

	ret
;---------------------------------------------------------------------------
; Reconstruct output signal
; OUTPUT INTERPOLATOR 4 PASS 1
OUTSIG:

	ldpk	LPFO2
	ZAC
	LT      LPFO23
	MPYK    -289
	LTD     LPFO22
	MPYK    2335
	LTD     LPFO21
	MPYK    2335
	LTD     LPFO2
	MPYK    -289
	APAC
	ADLK    1,11         ; ADD 0.5 TO ROUND	  ===JF===
	SACH    SIGOUT,4     ; SAVE 1ST OUTPUT SIGNAL

; SECOND OUTPUT SIGNAL

	ZALS    LPFO22
	SACL    SIGOUT1      ; SAVE 2ND OUTPUT SIGNAL

; OUTPUT INTERPOLATOR 3

	ZAC
	LT      LPFO15
	MPYK    111
	LTD     LPFO14
	MPYK    -530
	LTD     LPFO13
	MPYK    2474
	LTD     LPFO12
	MPYK    2474
	LTD     LPFO11
	MPYK    -530
	LTD     LPFO1
	MPYK    111
	APAC
	ADLK    1,11         ; ADD 0.5 TO ROUND	  ===JF===
	SACH    LPFO2,4      ; SAVE TO INTERP 4 W/SHIFT

	ZALH    BPFOUT	     ; filter in
;	ZALH    BPF40	     ; filter out, decimators remain in line
	SACH    LPFO1

; OUTPUT INTERPOLATOR 4 PASS 2

	ZAC
	LT      LPFO23
	MPYK    -289
	LTD     LPFO22
	MPYK    2335
	LTD     LPFO21
	MPYK    2335
	LTD     LPFO2
	MPYK    -289
	APAC
	ADLK    1,11         ; ADD 0.5 TO ROUND	  ===JF===
	SACH    SIGOUT2,4    ; SAVE 3RD OUTPUT SIGNAL

; FOURTH OUTPUT SIGNAL

	ZALS    LPFO22
	SACL    SIGOUT3      ; SAVE 4TH OUTPUT SIGNAL

; LOAD OUTPUT INTERPOLATOR

	ZALH    LPFO13
	SACH    LPFO2
	ret
;---------------------------------------------------------------------------


RINT	ret
XINT	ret
****************************************************************************
* Routine to set up AIC
****************************************************************************
AIC_SET: 
*
* Reset AIC by defining some GLOBAL memory space, then
* reading it. 
* 
	dint                    ; Normally after reset interrupts are disabled
	ldpk	DXR
	lack    0x80            ; AIC reset by pulsing /BR (Global Data)
	sach    DXR             ; send 0 to DXR (AIC)
	sacl    GREG            ; 256 * 100 nS /BR pulse
	lrlk    AR0,0xFFFF      ;
	rptk    255             ; read junk from address 0xFFFF
	lac     *,0,AR0         ;

 .if CONF_1
	conf    1               ; B0    is code (FA00 - FBFF)
				; B1,B3 is data (0400 - 07FF)
 .endif
 .if CONF_2
	conf    2               ; B0,B1 is code (FA00 - FD00)
 .endif

;----------------------------------------------------------------------------
* Configure AIC.
* The transmit interrupt must be used to sense when
* the AIC has processed the commands that we are sending
* to it. Since interrupts have been disabled at entry, arm
* the transmit interrupt first.
*
	LDPK	IMR
	LAC	IMR
	ORK	020h
	SACL	IMR
        eint
;-----------------------command 00 = TX/RX A-cntrs <= TA/TB
        lalk   	TA,9
        adlk   	RA,2
        call   	AIC_2nd
;-----------------------command 01 = TX/RX A-cntrs <= TA+TA'/TB+TB'
        lalk   	TAp,9
        adlk   	RAp,2
        addk   	01h
        call   	AIC_2nd
;-----------------------command 10 = TX/RX A-cntrs <= TA-TA'/TB-TB'
        lalk   	TB,9
        adlk   	RB,2
        addk   	02h
        call   	AIC_2nd
;-----------------------command 11 = set command register
        lalk   	AIC_CMD,2
        addk   	03h
        call   	AIC_2nd
;------------------------

        nop 			; Introduce a brief delay (5*tics)
        nop
        nop
        nop
        nop

        ssxm			; Allows sign extention during shifts
        spm     0		; Disable shifts on P-reg 

* AIC is now initialized. Disable XINT, then leave only the RINT activated.

	dint
	LDPK	IMR
	LAC	IMR
	andk	0xFFCF
	ORK	010h
	SACL	IMR
	ret
;----------------------------------------------------------------
AIC_2nd: ldpk   0                 ;
         sach   DXR               ;
         idle                     ;
         adlk   6,15              ;0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
         sach   DXR               ;
         idle                     ;ACCU_hi requests 2nd XMIT
         sacl   DXR               ;
         idle                     ;ACCU_lo sets up registers
         zac                      ;
         sacl   DXR               ;make sure the word got sent
         idle                     ;
         ret                      ;

*---------------------------------------------------
* Write accumulator to D/A
*---------------------------------------------------
DA_DISP:
;	sfl
;	sfl
	andk     0fffch
	ldpk     DXR
	sacl     DXR         ; write output word to transmit register
	ret
;----------------------------------------------------------------------------
; Read from A/D
DA_IN:
        ldpk     DRR         ; point to memory mapped serial port recieve reg
        lac      DRR         ; load accumulator with word received from AIC
        sfr                  ; shift right twice to remove unused lsb's
        sfr                  ;
	ret
;----------------------------------------------------------------------------
* SQUARE INPUT FOR LED DISPLAY, 3DB/SEGMENT

BARGRA: 
	ldpk	TEMP 
	SACH    TEMP
	LT      TEMP
	MPY     TEMP
	PAC
	SACH    TEMP
	SUBH    SQUARE
	BGZ     PEAK
	ZALH    SQUARE
	SUBH    ONE
	ABS
	SACH    SQUARE
	B       DISPLAY

PEAK    ZALH    TEMP
	SACH    SQUARE

* CONVERT TO DISPLAY BY BITWISE OR

DISPLAY LAC     SQUARE,12
	SACH    LED

	LAC     SQUARE,11
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,10
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,9
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,8
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,7
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,6
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,5
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,4
	SACH    TEMP
	ZALS    TEMP
	OR      LED
	SACL    LED

	LAC     SQUARE,3
	SACH    TEMP
	ZALS    TEMP
	OR      LED

	cmpl    			; invert bits
	SACL    LED

	OUT     LED,0			; PA0
	ret
;-------------------------------------------------------------------------
	.end






















































































