/////////////////////////////////////////////////////////////////////////////
//	SB.C
//		Sound Blaster CT-VOICE.DRV helper functions.
/////////////////////////////////////////////////////////////////////////////

#include "sb.h"

static void far (*driver_mem)(void) = NULL;	// pointer to allocated CT-VOICE mem
static void far (*driver)(void) = NULL;		// CT-VOICE entry point

/////////////////////////////////////////////////////////////////////////////

int sbInit(void)
{
	_BX = 3;
	(*driver)();
	return(_AX);
}

/////////////////////////////////////////////////////////////////////////////

void sbOpen(void)
{
	FILE *f;
	long length;
	char *vp;
	char var[129];
	void far (*drv)(void);
	int ver;
										// Get a copy of the SOUND environ
										// variable.  Turn it into the path
										// for the CT-VOICE driver.
	*(var) = 0;
	vp = getenv("SOUND");
	if (!vp)
	{
		puts("\nThe SOUND environment variable could not be found.");
		exit(1);
	}
	strcpy(var,vp);
	if(var[strlen(vp)-1] != '\\')
	{
		strcat(var,"\\");
	}
	strcat(var,"drv\\CT-VOICE.DRV");
										// Open the file, chucking an error
										// if it doesn't exist.
	f = fopen(var,"rb");
	if(!f)
	{
		printf("\nCould not open %s.\n", var);
		exit(1);
	}
										// Get the driver length, allocate
										// memory for it, create an entry
										// point at offest 0x0000, load the
										// file at SEG:0000, and close it.
	length = filelength(fileno(f));
	driver_mem = (void far *)malloc((int)length + 16);
	driver = MK_FP(FP_SEG(driver_mem)+1,0);
	fread(driver,1,(int)length,f);
	fclose(f);
										// Display CT-VOICE.DRV version.
	_BX = 0;
	(*driver)();
	ver = _AX;
	printf("\nCT-VOICE.DRV version %d.%d.", (ver>>8)&0xFF, ver&0xFF);
										// Display CT-VOICE.DRV card type.
	printf("\nSound Blaster card type: %d.", sbGetType());
										// Get the BLASTER environment var.
	var[0] = 0;
	vp = getenv("BLASTER");
	if (!vp)
	{
		puts("\nCould not find the BLASTER environment variable.");
		exit(1);
	}
	strcpy(var, vp);
										// Use the CT-VOICE.DRV function 0x1C
										// to parse the BLASTER environment
										// variable and set up the Sound
										// Blaster card accordingly.
										// Put a copy of "driver" in the
										// stack segment, since the DS needs
										// to change.
	drv = driver;
	asm {
		push ds
		push es
		push di
		push si
	}
	_ES = _DS = FP_SEG(var);
	_DI = _SI = FP_OFF(var);
	_BX = 0x1C;
	(*drv)();
	asm {
		pop si
		pop di
		pop es
		pop ds
	}
										// Make sure it worked.
	if (_AX)
	{
		puts("\nThe BLASTER environment variable does not match your hardware.");
		exit(1);
	}
										// Initialize the driver.
	ver=sbInit();
	if (ver)
	{
		printf("\nError %d initializing your Sound Blaster.\n", ver);
		exit(1);
	}
}

/////////////////////////////////////////////////////////////////////////////

int sbSpeaker(int onoff)
{
	_BX = 4;
	_AX = onoff & 0x0001;
	(*driver)();
	return(_AX);
}

/////////////////////////////////////////////////////////////////////////////

void sbClose(void)
{
	_BX = 9;
	(*driver)();
}

/////////////////////////////////////////////////////////////////////////////

int sbSetStatWord(unsigned int *addr)
{
	_BX = 5;
	_ES = FP_SEG(addr);
	_DI = FP_OFF(addr);
	(*driver)();
	return(_AX);
}

/////////////////////////////////////////////////////////////////////////////

int sbOutVoc(char *buffer)
{
	_BX = 6;
	_ES = FP_SEG(buffer);
	_DI = FP_OFF(buffer);
	(*driver)();
	return(_AX);
}

/////////////////////////////////////////////////////////////////////////////

int sbInVoc(int sample_rate, char *buffer, long length)
{
	_DX = (unsigned)(length >> 16);
	_CX = (unsigned)(length & 0x0000ffff);
	_BX = 7;
	_AX = sample_rate;
	_ES = FP_SEG(buffer);
	_DI = FP_OFF(buffer);
	(*driver)();
	return(_AX);
}

/////////////////////////////////////////////////////////////////////////////

void sbStopVoc(void)
{
	_BX = 8;
	(*driver)();
}

/////////////////////////////////////////////////////////////////////////////

int sbPauseOut(void)
{
	_BX = 10;
	(*driver)();
	return _AX;
}

/////////////////////////////////////////////////////////////////////////////

int sbResumeOut(void)
{
	_BX = 11;
	(*driver)();
	return _AX;
}

/////////////////////////////////////////////////////////////////////////////

int sbSetRecSrc(int src)
{
	_BX = 17;
	_AX = src;
	(*driver)();
	return _AX;
}

/////////////////////////////////////////////////////////////////////////////

int sbSetRecMode(int mode)
{
	_BX = 16;
	_AX = mode;
	(*driver)();
	return _AX;
}

/////////////////////////////////////////////////////////////////////////////

int sbGetType(void)
{
	_BX = 20;
	(*driver)();
	return _AX;
}

/////////////////////////////////////////////////////////////////////////////

char *sbLoadVoc(char *name)
{
	FILE *f;
	char *buf;
	long length;

	f = fopen(name,"rb");
	if(!f)
		return NULL;

	length = filelength(fileno(f)) - 0x1a;

	buf = (char *)malloc((int)length);
	fseek(f,0x1a,SEEK_SET);
	fread(buf,1,length,f);

	fclose(f);
	return buf;
}

/////////////////////////////////////////////////////////////////////////////
//	end of SB.C
/////////////////////////////////////////////////////////////////////////////
