/*  MBMAIL.H - 04/01/94  */

#define mb_version 10

extern char orgbbs[7], orgdate[7], orgmsg[6], orgtime[5]; 

extern char *mbfile, *mbbfile, *msgdir;
extern int mfl, mflb;

extern char  *ufwd, *bfwd, *bufwd;
extern short ufwdm, ufwdn, bfwdm, bfwdn, bufwdn, bidnum;
extern short tstaleb, tstalen, tstaleu;
extern short tstale1, tstale2, tstale3;
extern short rstale1, rstale2, rstale3;
extern char  wpcall[ln_call];

/*  The list of calls to translate.  */

typedef struct XBBS_S
{
  char from[ln_call];
  char to[ln_call];
  struct XBBS_S *next;
} XBBS;

extern XBBS *xbbs;

/*  The list of calls to hold messages for.  */

typedef struct HOLD_S
{
  char call[ln_call];
  struct HOLD_S *next;
} HOLD;

extern HOLD *hold;

/*  Prompts associated with message commands.  */

#define num_mm 13
extern  char *mm[num_mm];

/*
 *  Message header record.
 */

#define m_read   0x0001  /* Message has been read by recipient    */
#define m_fwd    0x0002  /* Message has been forwarded            */
#define m_kill   0x0004  /* Message marked for killing            */
#define m_busy   0x0008  /* Message busy                          */

#define m_noarc  0x0010  /* Do not archive this message           */
#define m_stale  0x0020  /* Message unread and older than allowed */
#define m_hold   0x0040  /* Do not forward this message           */
#define m_bull   0x0080  /* This is a bulletin                    */

#define m_ffbull 0x0100  /* Fully forwarded bulletin              */
#define m_dup    0x0200  /* Duplicate message                     */
#define m_inc    0x0400  /* Incomplete message                    */

#define mhtitl 80      /* Length of title.                      */
#define mmhsunu 6      /* Unused                                */
#define mmesn 13       /* Number of calls in DIS list           */

typedef struct msg_hdr_s
{
  byte ext;           /* Header extension flag, or zero                  */
  word rn;            /* Record number of this record                    */
  word read;          /* # times the message has been read               */
  word number;        /* Message number                                  */
  word size;          /* Size in bytes                                   */
  char type;          /* Message type                                    */
  word stat;          /* Message status, see bit definitions above       */
  char to  [ln_call]; /* Destination call                                */
  char from[ln_call]; /* Originator call                                 */
  char bbs [ln_call]; /* Destination BBS, or distribution list           */
  char date[ln_date]; /* Entry date                                      */
  char time[ln_time]; /* Entry time                                      */
  char bid[ln_bid];   /* Bulletin ID, if this is a bulletin              */
  char title[mhtitl]; /* Title of message                                */

  char call[mmesn][ln_call]; /* Calls to send to                         */
  byte flag[mmesn];          /* TRUE if need to send, FALSE if sent      */
  byte count;                /* number of calls in list                  */
  char fwdc[ln_call];        /* Forward message bbs                      */
  char fwdd[ln_call];        /* Forward from bbs                         */
  char fwdl[ln_call];        /* Originator bbs                           */
  word orgnum;               /* Originator number                        */
  word sp1;                  /* Spare word one                           */
  word sp2;                  /* Spare word two                           */
  char htype;                /* Hold type                                */
  char fport;                /* Forward port used                        */
  char unu[mmhsunu];
} MSG_HDR;


/*
 *  Mail file header record.
 */

#define mfhsunu 231

typedef struct mail_hdr_s
{
  word next;          /* Next record to allocate         */
  word first;         /* First message header record     */
  word last;          /* Last message header record      */
  word next_msg;      /* Next message number             */
  word unt_msg;       /* next_msg at last untangle       */
  byte version;       /* File format version number      */
  word free;          /* Spare word for future use       */
  word count;         /* Number of messages              */
  char date[ln_date]; /* Date of last untangle           */
  char time[ln_time]; /* Time of last untangle           */
  char unu[mfhsunu];
} MAIL_HDR;

extern MAIL_HDR *mfhs;
extern MSG_HDR  *tmmhs;
