/*
 *  MBPORT.H - 6/20/92 - Definitions for MailBox ports.
 */

extern word p_window; /* Port bit mask    */
extern word c_flag;   /* Port command bit */
extern word b_flag;   /* Port busy bit    */

/*
 *  Device connected to the port. (port->dev)
 */

#define p_serial    1     /* Device is "raw" serial, another computer */
#define p_tnc       2     /* Device is a tnc with TAPR commands       */
#define p_console   3     /* Device is the local machine console      */

/*
 *  Permissions associated with the port. (port->priv)
 */

#define p_bbs     0x0001  /* Only BBS may connect to this port        */
#define p_ilcal   0x0002  /* Illegal call kicked off                  */
#define p_ildig   0x0004  /* Illegal digi call no no   (not imp)      */
#define p_mon     0x0008  /* Monitoring ok                            */
#define p_gate    0x0010  /* Gateway out from this port ok            */
#define p_sysop   0x0020  /* Remote sysop allowed (IF user can)       */
#define p_upload  0x0040  /* Upload allowed from this port            */
#define p_dnload  0x0080  /* Download allowed from this port          */

/*
 *  Port Mode values. (port->mode)
 */

#define sysop   0x0001   /* User is sysop                             */
#define local   0x0002   /* User is local machine console             */
#define remote  0x0004   /* User is not sysop                         */
#define idle    0x0010   /* The port is idle                          */
#define discon  0x0020   /* User has disconnected, but not logged out */
#define timeout 0x0040   /* User timed out, but not yet logged out    */
#define exclude 0x0080   /* User excluded, but not yet logged out     */
#define logout  0x0100   /* User did "B", but not yet logged out      */
#define forced  0x0200   /* User forced off, but not yet logged out   */

#define all  (local | remote | sysop)
#define ops  (local | sysop)
#define gone (discon | timeout | forced)

/*
 *  Port flags. (port->flags)
 */

#define p_dotmr  0x0001  /* Set the input timeout in getdat        */
#define p_dofwd  0x0002  /* "forward for this port now"            */
#define p_clrsys 0x0004  /* Must clear sysop mode on exit if discon*/
#define p_req    0x0008  /* Had a connect request                  */
#define p_give   0x0010  /* Ok to give time to DD on I/O           */
#define p_echo   0x0020  /* Need to echo input to user             */
#define p_lf     0x0040  /* This port needs LF after CR            */
#define p_opreq  0x0080  /* Local console wants to int user        */
#define p_term   0x0100  /* Port was used as terminal              */
#define p_trans  0x0200  /* Port in transparent mode               */

typedef struct ports_s
{
  struct ports_s *next;  /* Next port                              */
  struct ports_s *lport; /* Port this one linked to or NULL        */
  char  id;              /* Identifies port to user                */
  byte  idn;             /* Identifies port to op sys              */
  byte  dev;             /* Device connected to the port           */
  byte  ndigi;           /* # digi allowed on connect              */
  word  flags;           /* Flags                                  */
  word  priv;            /* What can you do from this port         */
  word  mode;            /* Present state of the port              */
  word  ctime;           /* "Waiting for input" timeout, seconds   */
  word  dtime;           /* "Waiting for disconnect" timeout, sec  */
  byte  errmax;          /* Allowed command errors before kick off */
  byte  errors;          /* Number of errors user has made         */
  char  *name;           /* Name of the port                       */

  byte  ec;              /* Echo TNC to console?                   */
  byte  ecmon;           /* Echo to console while monitoring?      */
  byte  ecuser;          /* Echo to user / forward to console?     */
  byte  eccmds;          /* Echo TNC commands to console?          */
  byte  tmode;           /* Transparent mode used by TNC           */
  word  ftime;           /* Forward timeout time                   */

  word  mtime;           /* Allowed monitor time                   */
  word  mcount;          /* Lines allowed in monitor               */

  byte  maxhrd;          /* Max on heard list                      */
  byte  nhrd;            /* # presently on heard list              */
  char  *heard;          /* Pointer to calls heard list            */

  byte  fwdmin;          /* Minute of the hour to forward          */
  char  rcall[ln_call];

/* Task stuff. Doesn't really belong here, but saves an indirect. */

  long  itime;           /* Time when wait for input times out     */
  long  expire;          /* Time at which we time this out         */
  byte  flds;            /* # fields in current command            */
  char  *fld[maxflds];   /* Pointers to the start of fields in cmd */
  char  *cmd;            /* The command field text                 */
  char  *line;           /* Text line last collected               */
  char  opt1;            /* Major command id                       */
  char  opt2;            /* Minor command id                       */
  word  cmdcnt;          /* # commands done since login            */
  FILE  *fl;             /* For any file required                  */
  char  *msg;            /* Error msg before prompt, or NULL       */
  struct user_s *user;   /* Pointer to user record                 */
  struct msg_hdr_s *mmhs;/* Pointer to message header record       */
} PORTS;

/*
 *  porthd is the list header.
 *  port   is the currently active port.
 *  cport  is the machine console.
 *  pipeid is the local end of the pipe.
 */

extern int pipeid;
extern PORTS *porthd, *port, *cport;
extern PORTS *findport();

