 page	60,132
; BRK.ASM   3/25/87
; by David Toth, VE3GYQ, Modified by W0RLI
;
; These are C callable routines, called by
; brkoff()  --	to set ctrl-brk interrupt (1BH) and ctrl-c interrupt (23H)
;		so that it is ignored and execution continues.
; brkon()   --	resets ctrl-brk to its normal action.

_TEXT	SEGMENT BYTE PUBLIC 'CODE'

	assume	cs:_text

	PUBLIC	_brkoff,_brkon

eswd	dw	?
bxwd	dw	?

_brkoff     proc near

	    push bp
	    mov bp,sp
	    push ds
	    push di
	    push si

	    mov ax,351bh       ; get ctl_brk interrupt vector
	    int 21h	       ; vector returned in ES:BX
	    mov cs:bxwd,bx
	    mov cs:eswd,bx     ; save the old vector to return later

	    push cs	       ; the data segment
	    pop  ds

	    mov dx,offset do_ti
	    mov ax,251bh       ;  set interrupt vector
	    int 21h	       ; ctrl-brk routine is now at do_ti

	    mov dx,offset do_it
	    mov ax,2523h       ; set interrupt vector
	    int 21h	       ; ctrl-c routine is now at do_it

	    pop  si
	    pop  di
	    pop  ds
	    pop  bp

	    ret
_brkoff     endp

; Control-C interrupt handler.

do_it	    proc far
	    clc 	       ;zero the carry flag which
	    ret 	       ;allows program to continue execution
do_it	    endp

; Control-break interrupt handler.

do_ti	    proc far
	    iret	       ;allows program to continue execution
do_ti	    endp

_brkon	    proc near

	    push bp
	    mov bp,sp
	    push ds
	    push di
	    push si

	    mov ds,cs:eswd     ; put BX word back into DX
	    mov dx,cs:bxwd     ; put BX word back into DX
	    mov ax,251bh       ; set interrupt vector
	    int 21h	       ; ctrl-brk is restored

	    pop  si
	    pop  di
	    pop  ds
	    pop  bp

	    ret
_brkon	    endp


; return status of keyboard without allowing CTRL-C to signal break.


	PUBLIC	_kbstat
_kbstat proc	near
		mov	ah,1
		int	16h
		mov	ax,0
		jz	nochar		;zero means no character available
		not	ax
nochar:
		ret
_kbstat endp

_TEXT	ENDS
	    end
