{$F-} {$R+} {$Q+} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit cMath;

  { Implements some functions which fall in the "math" class, including
    coordinates/locators conversions, and distance/azimuth calculations.
    Some bugs here! At least the latter is a dead one. Fix it if you dare. }

Interface
Type

  LocStr     = String[6];
  CoordRec   = Record
               lat, long : Real;
               End;

Function Coord2Str(c:CoordRec):String;   { Koordinaatit stringiksi }
Function Str2Coord(s:String; var c:CoordRec):Boolean; { Stringi koordinaateiksi }

Function Loc2Coord(Loc:LocStr; var coord:CoordRec):Boolean;
Function Coord2Loc(coord:CoordRec):LocStr;

Function DistAz(c1, c2: CoordRec; var az:Real):LongInt;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation
Uses
  cStrings;
Const
  earth = 40076.59;
  k     = pi / 180;
  l     = 180 / pi;
  m     = pi / 2;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Support routines... things missing in the run-time library, formulas    }
 { found in the BP 7 on-line help file 8-)                                 }

Function aSin(x:Real):Real;  { Arc sin }
Begin
 aSin := ArcTan (x/sqrt (1-sqr (x)));
End;

Function aCos(x:Real):Real;  { Arc cos }
Begin
 aCos := ArcTan (sqrt (1-sqr (x)) /x);
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function Coord2Str(c:CoordRec):String;   { Koordinaatit stringiksi }
Var
  s : String[40];
Begin

 s := Int2Str(Trunc(Abs(c.Long))) + '' + Int2Str(Round(Frac(Abs(c.Long)) * 60)) + '" ';

 If c.Long > 0
   then s := s + 'E '
   else s := s + 'W ';

 s := s + Int2Str(Trunc(Abs(c.Lat)))  + '' + Int2Str(Round(Frac(Abs(c.Lat))  * 60)) + '" ';

 If c.Lat > 0
   then s := s + 'N'
   else s := s + 'S';

 Coord2Str := s;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function Str2Coord(s:String; var c:CoordRec):Boolean; { Stringi koordinaateiksi }
Begin

 Str2Coord := False;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Convert a Mainhead locator to longitude/latitude                        }

Function Loc2Coord(Loc:LocStr; var coord:CoordRec):Boolean;
Begin

  Loc2Coord := False;

  { Check validity }
  If (Loc[1] < 'A') or (Loc[1] > 'Z') or (Loc[2] < 'A') or (Loc[2] > 'Z')
    or (Loc[3] < '0') or (Loc[3] > '9') or (Loc[4] < '0') or (Loc[4] > '9')
    or (Loc[5] < 'A') or (Loc[5] > 'Z') or (Loc[6] < 'A') or (Loc[6] > 'Z')
      then Exit;

  coord.long := (Ord(Loc[1]) - 65) * 20
          - 180
          + (Ord(Loc[3]) - 48) * 2
          + (Ord(Loc[5]) - 65) * 0.083333333
          + 0.0416666666;

  coord.lat := (Ord(Loc[2]) - 65) * 10
           - 90
           + (Ord(Loc[4]) - 48)
           + (Ord(Loc[6]) - 65) * 0.0416666666
           + 0.0208333333;

  Loc2Coord := True;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function Coord2Loc(coord:CoordRec):LocStr;
Var
  s : LocStr;
Begin

  s := '      ';


  Coord2Loc := s;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { MATIKKAPUOLI                                                            }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Calculate the distance between two points on the face of the earth      }

Function DistAz(c1, c2: CoordRec; var az:Real):LongInt;
Var
  z,  x,y, u,v  : Real;

  d, ad,
  cos_d, cos_ad : Real;

  sin_a, sin_ap,
  azi,   azi_p  : Real;

  Dist          : Real;

Begin

  x := c1.Long * k;
  y := c1.Lat * k;
  u := c2.Long * k;
  v := c2.Lat * k;

  { Distance... }

  z := v - y;

  cos_d  := cos(z) * cos(x) * cos(u) + ( sin(x) * sin(u) );
  cos_ad := cos(z) * cos(x) * cos(u + 0.000150) + ( sin(x) * sin(u + 0.000150));

  d := acos(cos_d);
  ad := acos(cos_ad);

  dist := d * l;
  DistAz := Round(dist * 111.2);

  { Azimut... }

  sin_a  := sin(z) * cos(u) / sin(d);
  sin_ap := sin(z) * cos(u + 0.000150) / sin(ad);

  azi    := asin(sin_a) * l;
  azi_p  := asin(sin_ap) * l;

  If abs(azi_p) > abs(azi)
    then If azi > 0
           then azi := 180 - azi
           else azi := (azi + 180) * -1;

  If (azi = 0) and (u < x)
    then If azi > 0
           then azi := 180 - azi
           else azi := (azi + 180) * -1;

  If azi < 0
    then azi := azi + 360;

  az := Round(azi);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.
