{$R-} {$Q-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit cStrings;

  { Implements *lots* of different character string and integer/float
    manipulation and conversion functions used elsewhere in the code. }

Interface

Uses Dos, cMath;

Type
  CharTable    = Array[Chr(0)..Chr(255)] of Char;
  CharTableRec = Record
                 Table : CharTable;
                 Desc  : String[50];
                 End;
  CharTableP   = ^CharTableRec;
  DateTimeP    = ^DateTime;
  DWord        = Array[1..4] of Byte;

Var
  TLoop             : Byte;
  IBuffer           : String[255];       { Tuleva bufferi }

  { CharSet }
  CharSets,                              { Montako merkist }
  DefaultCharSet    : Byte;              { Oletus kyttjille }
  CharSet  : Array[1..5] of CharTableP;  { Taulukot }

  { LUTit }
  UpCaseCh,                              { Lut: kirjain isoksi }
  LowCaseCh,                             { Lut: kirjain pieneksi }
  CleanCh           : CharTable;         { Lut: Binrit pois }

Const

 { CR/LF }
  Cr     = #$0D;
  Lf     = #$0A;
  CrLf   = Cr+Lf;

  Days : Array [0..6] of String[9] =
    ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
  Months : Array [1..12] of String[3] =
    ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');


 { Paloittelut }
Function FindParamStart(num:Byte):Byte; { IBufferista parametrin paikka }
Function Parse(num:Byte):String;        { IBufferista parametri }

Function AbortStr:Boolean;              { Onko IBuffer '/ex' tai ctrl-z }

 { Stringiknnkset }
Function AddLf(Const s:String):String;         { Lis Cr:ien pern puuttuvat LF:t }
Function UpCaseStr(Const s:String):String;     { Stringi isoihin kirjaimiin }
Function LowCaseStr(Const s:String):String;    { Stringi pieniin kirjaimiin }
Function Capitalize(Const s:String):String;    { Stringi isoilla alkaviin sanoihin }
Function TranslateChSet(ChSet:Byte;Const s:String):String;
                                         { Tekee merkistknnksen }
 { Str muotoilu }
Function Spaces(Len:Byte):String;        { Palauttaa vlilyntej }
Function PadLeft(Len:Byte;Const Str:String):String;  { Tytetn stringin pituus listen spaceja oikealle }
Function PadRight(Len:Byte;Const Str:String):String; { Tytetn stringin pituus listen spaceja vasemmalle }
Function CutStr(Len:Byte;Const Str:String):String;   { Maksimipituus stringille }
Function CleanStr(Str:String):String;    { Poistaa ylim. vlilynnit }
Function Format(CrEnd:Boolean; Const Prefix:String; Text:String):String;
Function Center(Const Text:String):String;     { Keskitt rivin }

Function BackSpaces(Len:Byte):String;    { Backspace (CTRL-H) merkkej }
Function StripBeeps(Str:String):String;  { CTRL-G:t pois }

 { Num => Str }
Function LeadingZero(w:Word):String;     { Wordi stringiksi, etunollat pois }
Function Int2Str(int:LongInt):String;    { Integer stringiksi }
Function IntStr(Sana:Word):String;       { Integer stringiksi 2 numeroa }
Function DW2Str(DW:DWord):String;        { DWord stringiksi }
Function Real2Str(r:Real):String;        { Real stringiksi }
Function Freq2Str(i:LongInt):String;     { Taajuus stringiksi }
Function HexB2Str(b:Byte):String;        { Byte heksamuotoon }
Function HexW2Str(w: Word):String;       { Word heksamuotoon }
Function HexL2Str(l: LongInt):String;       { Word heksamuotoon }
Function Pointer2Str(p:Pointer):String;  { Pointteri stringiksi }
Function Percentage(v,n:LongInt):String; { Prosentuaalinen osuus }
Function Bytes2Str(i:LongInt):String;    { Tavut stringiksi, max 4 merkki }
Function Bytes2StrL(i:LongInt):String;   { Tavut stringiksi }

 { Str => }
Function Str2Real(Const st:String):Real;       { String reaaliksi }
Function Str2Word(Const st:String):Word;       { String Wordiksi }
Function Str2Byte(Const st:String):Byte;       { String Byteksi }
Function Str2LInt(Const st:String):LongInt;    { String LongIntiksi }
Function Str2Freq(Const st:String):LongInt;    { String taajuudeksi }
Function Str2Bool(Const st:String):Byte;       { String booleaniksi }

 { Aakkostus }
Function StrOrd(Const First,Second:String):Boolean; { Onko jrjestyksess }

 { Time }
Function DTimeDiff(First,Last:DateTime):LongInt;
Function TimeDiff(First,Last:LongInt):LongInt;
Function DayDiff(First,Last:DateTime):LongInt; { Kahden datetimen ero piviss laskettuna }
Function Secs2Str(PTime:LongInt):String;  { Seconds => d hh:mm:ss }
Function Secs2StrS(PTime:LongInt):String; { Seconds => d/h/m/s 3 chars }
Function Mins2Str(PTime:LongInt):String;  { Minutes => d hh:mm }
Function Mins2StrS(PTime:LongInt):String; { Minutes => d/h/m 3 chars }
Function DateStr(i:LongInt):String;       { Packed => 01/10/77 }
Function DateStrS(i:LongInt):String;      { Packed => '1/1' }
Function DateStrSPad(i:LongInt):String;   { Packed => ' 1/1 ' (5 mrk pitk) }
Function TimeStrL(i:LongInt):String;      { Packed => 02:30:12 }
Function TimeStr(i:LongInt):String;       { Packed => 2:30 }
Function TimeStrP(i:LongInt):String;       { Packed => 02:30 }
Function TimeStrS(i:LongInt):String;      { Packed => 0230 }
Function DateTimeStr:String;              { Day, date, time }
Function TZ2Str(r:Real):String;           { Timezone stringiksi }

 { ********************************************************************** }

Implementation
Uses Screen, ConfFile;
Const

  MDays : Array [1..12] of Word =  { Kuukauden pivt }
    (0,
     31,
     31+28,
     31+28+31,
     31+28+31+30,
     31+28+31+30+31,
     31+28+31+30+31+30,
     31+28+31+30+31+30+31,
     31+28+31+30+31+30+31+31,
     31+28+31+30+31+30+31+31+30,
     31+28+31+30+31+30+31+31+30+31,
     31+28+31+30+31+30+31+31+30+31+30);

  MDay : Array [1..12] of Byte =  { Kuukauden pivt }
    (31,28,31,30,31,30,31,31,30,31,30,31);

 HexChars: array [0..$F] of Char = '0123456789ABCDEF';

 { ********************************************************************** }

Function FindParamStart(num:Byte):Byte;
Var Pos, Count : Byte;
Begin

 Count := 0;
 Pos := 1;

 Repeat
  While (IBuffer[Pos] <> ' ') and (Pos < Length(IBuffer)) do Inc(Pos);
  While (IBuffer[Pos] = ' ') and (Pos < Length(IBuffer)) do Inc(Pos);
  Inc(Count);
 Until (Count = num) or (Pos = Length(IBuffer));

 If Pos < Length(IBuffer)
   then FindParamStart := Pos
   else FindParamStart := 0;

End;

 { ********************************************************************** }

Function Parse(num:Byte):String;
Var
 Start,Stop,Current : Byte;
Begin

 Start := 0;
 Current := 0;

 Repeat
  Inc(Start);
 Until (Start = Length(IBuffer)) or (IBuffer[Start] = ' ') or (IBuffer[Start] = Cr);

 If (num > 0)
   then Begin
        Repeat
         { Haetaan vli }
         While (Start < Length(IBuffer)) and (IBuffer[Start] <> ' ')
          do Inc(Start);
         { Ja sen loppu }
         While (Start < Length(IBuffer)) and (IBuffer[Start] = ' ')
          do Inc(Start);
         { Parametrin loppu }
         Stop := Start+1;
         While (Stop < Length(IBuffer)) and (IBuffer[Stop] <> ' ') and (IBuffer[Stop] <> Cr)
          do Inc(Stop);
         Dec(Stop);
         Inc(Current);
         If (Start >= Length(IBuffer)) or (Stop >= Length(IBuffer))
          then Begin
               Start := 2;
               Stop := 1;
               Current := num;
               End;

        until Current = num;
        Parse := Copy(IBuffer,Start,Stop-Start+1);
        End
   else Parse := Copy(IBuffer,1,Start-1);

End; { Parse }

 { ********************************************************************** }

Function AbortStr:Boolean;              { Onko IBuffer '/ex' tai ctrl-z }
Begin

 If (IBuffer = #26 + Cr) or (LowCaseStr(IBuffer) = '/ex' + Cr)
   then AbortStr := True
   else AbortStr := False;

End;

 { ********************************************************************** }

Function AddLf(Const s:String):String;
Var l:byte;
    str:string;
Begin
 Str := '';
 for l := 1 to Length(s) do
  If s[l] = Cr then Str := Str + CrLf
               else Str := Str + s[l];

{ Lisvarmistus...
  If s[l] = Cr then begin
                    If (s[l-1] <> Lf) and (s[l+1] <> Lf)
                      Then Str := Str + Cr + Lf
                      Else Str := Str + Cr;
                    end
    else Str := Str + s[l];
}

 AddLf := Str;

End;
 { ********************************************************************** }

Function UpCaseStr(Const s:String):String;
Var l   :byte;
    str :string;
Begin
 str := '';
 for l := 1 to Length(s) do str := str + UpCaseCh[s[l]];
 UpCaseStr := str;
end;

 { ********************************************************************** }

Function LowCaseStr(Const s:String):String;
var l   :byte;
    str :string;
Begin
 Str := '';
 for l := 1 to Length(s) do str := str + LowCaseCh[s[l]];
 LowCaseStr := str;
End;

 { ********************************************************************** }

Function Capitalize(Const s:String):String;
var l      : byte;
    str    : string;
    LastCh : Char;
Begin
 Str := '';
 LastCh := ' ';
 For l := 1 to Length(s) do
   Begin
   If not (LowCaseCh[LastCh] in [' ','.','-','_','^','~',',','/','+','"','#','%','&','$'])
      then Str := Str + LowCaseCh[s[l]]
      else Str := Str + UpCaseCh[s[l]];

   LastCh := s[l];
   end;
 Capitalize := Str;
end;

 { ********************************************************************** }

Function TranslateChSet(ChSet:Byte;Const s:String):String;
var l   :byte;
    str :string;
Begin
 If ChSet = 0 then Exit;
 Str := '';
 for l := 1 to Length(s) do str := str + CharSet[ChSet]^.Table[s[l]];
 TranslateChSet := str;
End;

 { ********************************************************************** }

Function Spaces(Len:Byte):String;
Var S:String;
    L:Byte;
Begin
 S := '';
 For L := 0 to Len do S := S + ' ';
 Spaces := S;
End;

 { ********************************************************************** }

Function PadLeft(Len:Byte;Const Str:String):String;
Var L:Byte;
Begin
 If Length(Str) >= Len
   then PadLeft := Copy(Str,1,Len)
   else PadLeft := Str + Spaces(Len-Length(Str)-1);
End;

 { ********************************************************************** }

Function PadRight(Len:Byte;Const Str:String):String;
Var L:Byte;
Begin
 If Length(Str) >= Len
   then PadRight := Copy(Str,1,Len)
   else PadRight := Spaces(Len-Length(Str)-1) + Str;
End;

 { ***************************************************************** }

Function CutStr(Len:Byte;Const Str:String):String;   { Maksimipituus stringille }
Begin
If Length(Str) > Len
   then CutStr := Copy(Str,1,Len)
   else CutStr := Str;
End;

 { ***************************************************************** }

Function CleanStr(Str:String):String;
Var s       : String;
    L       : Byte;
    Ch      : Char;
    Done    : Boolean;
    CrEnd   : Boolean;
Begin
If Length(Str) > 0
 then Begin
      S := '';
      Ch := ' ';
      If Str[Length(Str)] = Cr
        then Begin
             CrEnd := True;
             While Str[Length(Str)] = Cr
              do Dec(Str[0]);
             End
        else CrEnd := False;
      While (Str[1] = ' ') and (Length(Str) > 0)
      do Str := Copy(Str,2,Length(Str)-1);
      For l := 1 to Length(Str)
        do Begin
           If (Str[l] <> ' ') or (Ch <> ' ') then S := S + Str[l];
           Ch := Str[l];
           End;
      While (Length(S) > 0) and (S[Length(S)] = ' ') do Delete(S,Length(S),1);
      If CrEnd then s := s + Cr;
      CleanStr := S;
      End
 else CleanStr := '';
End;

{ ***************************************************************** }

Function Format(CrEnd:Boolean;Const Prefix:String;Text:String):String;
Var
  s      : String; { Uloslhtev }
  plen,            { Prefixin pituus }
  tlen,            { Textin pituus }
  w,               { Sanan alkukohta }
  lw,              { Sanan loppu }
  b      : Word;   { Kuinka pitkll rivi mennn }
Begin

 { mahd. loppucr:t pois }
 While Text[Length(Text)] = Cr
   do Dec(Text[0]);

 s := Prefix;
 tlen := Length(Text);

 If tlen > 0 { Jos teksti yleens on... }
  then Begin
       plen := Length(Prefix);
       s := s + ' ';
       b := plen + 1;
       w := 1;
       While w <= tlen
        do begin
           { Sanan loppukohta }
           lw := w;
           Repeat
            Inc(lw)
           until (text[lw] = ' ') or (lw > tlen);

           If (b + (lw - w) > 77) { Jos menisi yli rivin }
              and not (lw - w + plen >= 77) { eik ole tyspitk sana }
                    then Begin
                         s := s + cr + Spaces(plen);
                         b := plen;
                         End;

           { Listn sana }
           s := s + Copy(text,w,lw-w);
           b := b + lw-w;

           { etsitn seuraavan alku }
           w := lw;
           While (Text[w] = ' ') and (w < tlen)
            do Inc(w);

           if (w <= tlen)
            then Begin
                 s := s + ' ';
                 Inc(b);
                 End;
           End

       End;

 If CrEnd then s := s + Cr;
 Format := s;


End;

{ ***************************************************************** }

Function Center(Const Text:String):String;     { Keskitt rivin }
Var Pad : Integer;
Begin

 Pad := (80 - Length(Text)) div 2;
 If Pad < 0 then Pad := 0;

 Center := Spaces(Pad) + Text;

End;

{ ***************************************************************** }

Function BackSpaces(Len:Byte):String;
Var
  b : Byte;
  s : String;
Begin

 s := '';
 For b := 1 to Len
  do s := s + Chr(8);
 BackSpaces := s;

End;

{ ***************************************************************** }

Function StripBeeps(Str:String):String;  { CTRL-G:t pois }
Begin

 While Pos(Chr(7),Str) > 0
  do Str[Pos(Chr(7),Str)] := Chr(14);

 StripBeeps := Str;

End;

{ ***************************************************************** }

Function LeadingZero(w : Word) : String;
{ Muuttaa WORDin STRINGiksi ja poistaa mahd. etunollan }
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;

 { ********************************************************************** }

Function Int2Str(int:LongInt):string;
Var s: string[11];
Begin
  Str(int,s);
  Int2str := s;
End;

 { ***************************************************************** }

Function IntStr(Sana:Word):String;
Var St:String;
Begin
 Str(Sana,St);
 If Sana < 10 then IntStr := '0'+St
    Else IntStr := St;
End;

 { ********************************************************************** }

Function DW2Str(DW:DWord):String;        { DWord stringiksi }
Var i : LongInt;
Begin
 i :=  DW[1]
     + DW[2] * 256
     + DW[3] * 65536
     + DW[4] * 1677216;

 DW2Str := Int2Str(i);
End;

 { ********************************************************************** }

Function Real2Str(r:Real):String;        { Real stringiksi }
Var St:String;
Begin
 Str(r:10:10,St);
 While St[Length(St)] = '0' do Delete(St,Length(St),1);
 If St[Length(St)] = '.' then St := St + '0';
 Real2Str := St;
End;

 { ********************************************************************** }

Function Freq2Str(i:LongInt):String;        { Taajuus stringiksi }
Var
 St : String;
Begin
 Str(i,St);
 If i < 10
   then St := '0' + St;
 Insert('.',St,Length(St));
 If Length(St) > 9
   then Dec(St[0],2);
 Freq2Str := St;
End;

 { ********************************************************************** }

Function HexB2Str(b:Byte):String;
begin
 HexB2Str :=  hexChars[b shr 4] + hexChars[b and $F];
end;

 { ********************************************************************** }

Function HexW2Str(w:Word):String;
Begin
 HexW2Str :=
       hexChars[Hi(w) shr 4]
     + hexChars[Hi(w) and $F]
     + hexChars[Lo(w) shr 4]
     + hexChars[Lo(w) and $F];
End;

 { ********************************************************************** }

Function HexL2Str(l:LongInt):String;
Begin

  HexL2Str := HexW2Str(l shr 16) + HexW2Str(l and $ffff);

End;

 { ********************************************************************** }

Function Pointer2Str(p:Pointer):String;
Begin

 Pointer2Str := HexW2Str(Seg(p^)) + ':' + HexW2Str(Ofs(p^)) + 'h';

End;

 { ********************************************************************** }

Function Percentage(v,n:LongInt):String; { Prosentuaalinen osuus }
Begin

 If n = 0
   then Percentage := '0%'
   else Percentage := Int2Str(Round(v / n * 100)) + '%';

End;

 { ********************************************************************** }

Function Bytes2Str(i:LongInt):String;    { Tavut stringiksi, max 4 merkki }
Var
 s : String[5];
Begin

 If i < 999
  then Bytes2Str := Int2Str(i) + 'b'
  else If i < 1022976
         then Begin
              s := CutStr(4,Real2Str(i / 1024));
              s[Pos('.',s)] := 'k';
              Bytes2Str := s;
              End
         else Begin
              s := CutStr(4,Real2Str(i / 1048576));
              s[Pos('.',s)] := 'M';
              Bytes2Str := s;
              End;

End;

 { ********************************************************************** }

Function Bytes2StrL(i:LongInt):String;    { Tavut stringiksi }
Var
 s    : String[30];
 b, l : Byte;
Begin

 s := Int2Str(i);
 b := 2;
 l := Length(s);
 Repeat
   If b mod 3 = 0
     then Insert(' ',s,l-b+1);
   Inc(b);
 until b >= l;

 Bytes2StrL := s;

End;

 { ********************************************************************** }
 { ********************************************************************** }

Function Str2Real(Const st:String):Real;         { String reaaliksi }
Var r:Real;
    i:Integer;
Begin
 Val(St,r,i);
 If i > 0 then r := 0;
 Str2Real := r;
End;
 { ********************************************************************** }
Function Str2Word(Const st:String):Word;         { String Wordiksi }
Var l:LongInt;
    i:Integer;
Begin
 Val(St,l,i);
 If (i > 0) or (l > 65535) or (l < 0) then l := 0;
 Str2Word := l;
End;
 { ********************************************************************** }
Function Str2Byte(Const st:String):Byte;       { String Byteksi }
Var l:LongInt;
    i:Integer;
Begin
 Val(St,l,i);
 If (i > 0) or (l > 255) or (l < 0) then l := 0;
 Str2Byte := l;
End;
 { ********************************************************************** }
Function Str2LInt(Const st:String):LongInt;     { String LongIntiksi }
Var l : LongInt;
    i : Integer;
Begin
 Val(St,l,i);
 If i <> 0 then l := 0;
 Str2LInt := l;
End;
 { ********************************************************************** }

Function Str2Freq(Const st:String):LongInt;         { String taajuudeksi }
Var r:Real;
    i:Integer;
Begin
 Val(St,r,i);
 If (i > 0) or (r > 200000000)
   then r := 0;
 Str2Freq := Round(r * 10);
End;

 { ********************************************************************** }
Function Str2Bool(Const st:String):Byte;     { String booleaniksi }

 { 0 : Eptosi
   1 : Tosi
   2 : Ei tunnistettu }
Var
 b : Byte;
Begin

 b := 2;

 If Length(st) > 0 then
 Case LowCaseCh[st[1]] of
  'y' : b := 1; { Yes }
  'n' : b := 0; { No }
  '+' : b := 1;
  '-' : b := 0;
  '1' : b := 1;
  '0' : b := 0;
  't' : b := 1; { True }
  'f' : b := 0; { False }
 End;

 If (Length(st) > 1) and (LowCaseCh[st[1]] = 'o')
   then Begin
        If LowCaseCh[st[2]] = 'n' then b := 1;
        If LowCaseCh[st[2]] = 'f' then b := 0;
        End;

 Str2Bool := b;

End;

 { ********************************************************************** }

Function StrOrd(Const First,Second:String):Boolean;    { Onko jrjestyksess }
Var
 pos, len : Byte;
 Solved,
 Result   : Boolean;
Begin

 len := Length(First);
 If len > Length(Second) then len := Length(Second);
 pos := 0;
 Solved := False;
 Result := False;

 While (not solved) and (pos < len)
  do Begin
     Inc(pos);
     If Ord(First[pos]) < Ord(Second[pos])
       then Begin
            Solved := True;
            Result := True;
            End
       else if Ord(First[pos]) > Ord(Second[pos])
              then Solved := True;
     End;

 If not Solved
  then Result := (Length(First) <= Length(Second));

 StrOrd := Result;

End;

 { ********************************************************************** }

Function DTimeDiff(First,Last:DateTime):LongInt;
Var
 i, FirstS, LastS : LongInt; { Sekunneissa }
Begin

 With First
  do Begin
     Year := Year mod 3001;
     Month := Month mod 13;
     Day := Day mod 32;
     If Month = 0 then Month := 1;
     End;

 With Last
  do Begin
     Year := Year mod 3001;
     Month := Month mod 13;
     Day := Day mod 32;
     If Month = 0 then Month := 1;
     End;

 With First
  do Begin
     FirstS := Sec;
     i := Min * 60;
     Inc(FirstS,i);
     i := Hour;
     i := i * 3600;
     Inc(FirstS,i);
     i := Day + mdays[Month];
     i := i * 86400;
     Inc(FirstS,i);
     i := (Year - 1994);
     i := i * 31536000;
     Inc(FirstS,i);
     End;

 With Last
  do Begin
     LastS := Sec;
     i := Min * 60;
     Inc(LastS,i);
     i := Hour;
     i := i * 3600;
     Inc(LastS,i);
     i := Day + mdays[Month];
     i := i * 86400;
     Inc(LastS,i);
     i := (Year - 1994);
     i := i * 31536000;
     Inc(LastS,i);
     End;

 DTimeDiff := LastS - FirstS;

End;

 { ********************************************************************** }

Function TimeDiff(First,Last:LongInt):LongInt;
Var
  FirstD, LastD : DateTime;
Begin

 UnPackTime(First,FirstD);
 UnPackTime(Last,LastD);
 TimeDiff := DTimeDiff(FirstD,LastD);

End;

 { ********************************************************************** }
 { Kahden datetimen ero }

Function DayDiff(First,Last:DateTime):LongInt;
Var
 i,l : LongInt;
Begin

 { Check for the validity of the DateTimes }

 With First
  do Begin
     Year := Year mod 3001;
     Month := Month mod 13;
     Day := Day mod 32;
     If Month = 0 then Month := 1;
     End;

 With Last
  do Begin
     Year := Year mod 3001;
     Month := Month mod 13;
     Day := Day mod 32;
     If Month = 0 then Month := 1;
     End;

 { Then, get on with it... }

 i := Last.Year;
 i := 365 * i;
 Inc(i,MDays[Last.Month]);
 Inc(i,Last.Day);

 l := First.Year;
 l := 365 * l;
 Inc(l,MDays[First.Month]);
 Inc(l,First.Day);

 DayDiff := i - l;

End;

 { ***************************************************************** }

Function Secs2Str(PTime:LongInt):String;
Var
 s   : String;
 Sec, Min, Hou : Byte;
 Day : Word;
Begin

 Sec := PTime mod 60;
 Min := Trunc(PTime / 60) mod 60;
 Hou := Trunc(PTime / 3600) mod 24;
 Day := Trunc(PTime / 86400);

 If Day > 0 then s := Int2Str(Day) + 'd '
            else s := '';
 If Hou > 0 then s := s + Int2Str(Hou) + 'h';
 If Min > 0 then s := s + Int2Str(Min) + 'm';
 If (Sec > 0) or (s = '') { If it's 0 seconds, show it anyway... }
   then s := s + Int2Str(Sec) + 's';

 Secs2Str := s;

End;

 { ********************************************************************** }

Function Secs2StrS(PTime:LongInt):String;
Var
 Sec, Min, Hou : Byte;
 Day           : Word;
Begin

 Sec := PTime mod 60;
 Min := Trunc(PTime / 60) mod 60;
 Hou := Trunc(PTime / 3600) mod 24;
 Day := Trunc(PTime / 86400);

 If Day > 0 then Secs2StrS := Int2Str(Day) + 'd'
   else If Hou > 0 then Secs2StrS := Int2Str(Hou) + 'h'
   else If Min > 0 then Secs2StrS := Int2Str(Min) + 'm'
   else Secs2StrS := Int2Str(Sec) + 's';

End;

 { ********************************************************************** }

Function Mins2Str(PTime:LongInt):String;  { Minutes => d hh:mm }
Var
 s   : String;
 Min, Hou : Byte;
 Day : Word;
Begin

 Min := PTime mod 60;
 Hou := Trunc(PTime / 60) mod 24;
 Day := Trunc(PTime / 1440);

 If Day > 0 then s := Int2Str(Day) + 'd '
            else s := '';
 If Hou > 0 then s := s + Int2Str(Hou) + 'h';
 If (Min > 0) or ((Hou=0) and (Day = 0))
   then s := s + Int2Str(Min) + 'm';

 Mins2Str := s;

End;


 { ********************************************************************** }

Function Mins2StrS(PTime:LongInt):String;
Var
 Min, Hou : Byte;
 Day           : Word;
Begin

 Min := PTime mod 60;
 Hou := Trunc(PTime / 60) mod 24;
 Day := Trunc(Ptime / 1440);

 If Day > 0 then Mins2StrS := Int2Str(Day) + 'd'
   else If Hou > 0 then Mins2StrS := Int2Str(Hou) + 'h'
   else Mins2StrS := Int2Str(Min) + 'm'

End;

 { ********************************************************************** }

Function DateStr(i:LongInt):String;
Var
  t : DateTime;
  s : String[20];
Begin
 UnPackTime(i,t);
 With Conf^.Locale do
 Case DateFormat of
  dmy : DateStr := IntStr(t.Day) + DateSeparator + IntStr(t.Month) + DateSeparator
                 + Copy(Int2Str(t.Year),3,2);
  mdy : DateStr := IntStr(t.Month) + DateSeparator + IntStr(t.Day) + DateSeparator
                 + Copy(Int2Str(t.Year),3,2);
  ymd : DateStr := Copy(Int2Str(t.Year),3,2) + DateSeparator + IntStr(t.Month) + DateSeparator
                 + IntStr(t.Day);
  ydm : DateStr := Copy(Int2Str(t.Year),3,2) + DateSeparator + IntStr(t.Day) + DateSeparator
                 + IntStr(t.Month);
 End;
End;

 { ********************************************************************** }

Function DateStrS(i:LongInt):String;      { Packed => 1/10 }
Var
  t : DateTime;
  s : String[10];
Begin
 UnPackTime(i,t);
 With Conf^.Locale do
 Begin
 Case DateFormat of
  dmy,ydm : s := Int2Str(t.Day) + DateSeparator + Int2Str(t.Month);
  mdy,ymd : s := Int2Str(t.Month) + DateSeparator + Int2Str(t.Day);
 End;
 If df_SeparatorEnd in DateFlags
   then s := s + DateSeparator;
 End;
 DateStrS := s;
End;

 { ********************************************************************** }

Function DateStrSPad(i:LongInt):String;      { Packed => ' 1/10' }
Var
  t:DateTime;
Begin
 UnPackTime(i,t);
 With Conf^.Locale do
 Case DateFormat of
  dmy,ydm : DateStrSPad := PadRight(2,Int2Str(t.Day)) + DateSeparator
                       + PadLeft(2,Int2Str(t.Month));
  mdy,ymd : DateStrSPad := PadRight(2,Int2Str(t.Month)) + DateSeparator
                       + PadLeft(2,Int2Str(t.Day));
 End;
End;

 { ********************************************************************** }

Function TimeStrL(i:LongInt):String;       { Packed => 02:30:10 }
Var
  t:DateTime;
Begin
 UnPackTime(i,t);
 With Conf^.Locale do
 TimeStrL := IntStr(t.Hour) + TimeSeparator + IntStr(t.Min) + TimeSeparator
             + IntStr(t.Sec);
End;

 { ********************************************************************** }

Function TimeStr(i:LongInt):String;       { Packed => 2:30 }
Var
  t:DateTime;
Begin
 UnPackTime(i,t);
 With conf^.Locale do
 TimeStr := Int2Str(t.Hour) + TimeSeparator + IntStr(t.Min);
End;

 { ********************************************************************** }

Function TimeStrP(i:LongInt):String;       { Packed => 02:30 }
Var
  t:DateTime;
Begin
 UnPackTime(i,t);
 With conf^.Locale do
 TimeStrP := IntStr(t.Hour) + TimeSeparator + IntStr(t.Min);
End;

 { ********************************************************************** }

Function TimeStrS(i:LongInt):String;      { Packed => 0230 }
Var
  t:DateTime;
Begin
 UnPackTime(i,t);
 TimeStrS := IntStr(t.Hour) + IntStr(t.Min);
End;

 { ********************************************************************** }

Function DateTimeStr:String;
Var s : String;
Begin

 s := Days[DayOfWeek] + ', ';

 With conf^.Locale do
 Begin
 Case DateFormat of
  dmy : s := s + Int2Str(Dt.Day) + DateSeparator + Int2Str(Dt.Month) + DateSeparator
             + Copy(Int2Str(Dt.Year),3,2);
  mdy : s := s + Int2Str(Dt.Month) + DateSeparator + Int2Str(Dt.Day) + DateSeparator
             + Copy(Int2Str(Dt.Year),3,2);
  ymd : s := s + Copy(Int2Str(Dt.Year),3,2) + DateSeparator + Int2Str(Dt.Month) + DateSeparator
             + Int2Str(Dt.Day);
  ydm : s := s + Copy(Int2Str(Dt.Year),3,2) + DateSeparator + Int2Str(Dt.Day) + DateSeparator
             + Int2Str(Dt.Month);
 End;

 s := s + ' ' + LeadingZero(Dt.Hour) + TimeSeparator + LeadingZero(Dt.Min)
        + TimeSeparator + LeadingZero(Dt.Sec);
 End;

 DateTimeStr := s;

End;

 { ********************************************************************** }

Function TZ2Str(r:Real):String;  { Timezone stringiksi }
Var St:String;
Begin
 Str(r:10:10,St);
 While St[Length(St)] = '0' do Delete(St,Length(St),1);
 If St[Length(St)] = '.' then St := St + '0';
 If St[1] <> '-' then St := '+' + St;
 TZ2Str := St;
End;

 { ********************************************************************** }

Begin

 { Up/LowCaseCht jrjestykseen }
 For TLoop := 0 to 255 do Begin
                          UpCaseCh[Chr(TLoop)] := Chr(TLoop);
                          LowCaseCh[Chr(TLoop)] := Chr(TLoop);
                          CleanCh[Chr(TLoop)] := Chr(TLoop);
                          End;

 { a..z }
 For TLoop := 65 to 90  do LowCaseCh[Chr(TLoop)] := Chr(TLoop + 32);
 For TLoop := 97 to 122 do UpCaseCh[Chr(TLoop)] := Chr(TLoop - 32);

 { poikkeukset }
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';
 LowCaseCh[''] := ''; UpCaseCh[''] := '';

 { CleanCh }
 CleanCh[Chr(7)]  := Chr(14);
 CleanCh[Chr(8)]  := '';
 CleanCh[Chr(10)] := '';

End.
