{Disable the following define if you don't have Turbo Professional}

{*********************************************************}
{*                    TPENV.PAS 1.02                     *}
{*                by TurboPower Software                 *}
{*********************************************************}

{
  Version 1.01 11/7/88
    Find master environment in Dos 3.3 and 4.0
  Version 1.02 11/14/88
    Correctly find master environment when run
      Within AUTOEXEC.BAT
}

Unit Environ;

  { DOS environment variable handling code. Originally TPENV.BAS by
    TurboPower Software, copyrighted by them, not under the GPL.
    With slight modifications by me i think. }

Interface

Type
  EnvArray = Array[0..32767] of Char;
  EnvArrayPtr = ^EnvArray;
  EnvRec =
    Record
      EnvSeg : Word;              {Segment of the environment}
      EnvLen : Word;              {Usable length of the environment}
      EnvPtr : Pointer;           {Nil except when allocated on heap}
    end;

Const
  ShellUserProc : Pointer = nil;  {Put address of ExecDos user proc here if desi

Procedure MasterEnv(Var Env : EnvRec);
  {-Return master environment Record}

Procedure CurrentEnv(Var Env : EnvRec);
  {-Return current environment Record}

Function EnvFree:Word;
  {-Return Bytes free in environment}

Function GetEnvStr(Search : String) : String;
  {-Return a String from the environment}

Function SetEnvStr(Search, Value : String) : Boolean;
  {-Set environment String, returning True if successful}

Implementation
Uses cStrings;

Type
SO =
  Record
    O : Word;
    S : Word;
  end;

Var
  CurEnv : EnvRec;

Procedure SkipAsciiZ(EPtr : EnvArrayPtr; Var EOfs : Word);
  {-Skip to end of current AsciiZ String}
begin
  While EPtr^[EOfs] <> #0 do
    Inc(EOfs);
end;

Function EnvNext(EPtr : EnvArrayPtr) : Word;
  {-Return the next available location in environment at EPtr^}
Var
  EOfs : Word;
begin
  EOfs := 0;
  if EPtr <> nil then begin
    While EPtr^[EOfs] <> #0 do begin
      SkipAsciiZ(EPtr, EOfs);
      Inc(EOfs);
    end;
  end;
  EnvNext := EOfs;
end;

Function EnvFree:Word;
  {-Return Bytes free in environment}
begin
  With CurEnv do
    if EnvSeg <> 0 then
      EnvFree := EnvLen-EnvNext(Ptr(EnvSeg, 0))-1
    else
      EnvFree := 0;
end;

Function SearchEnv(EPtr : EnvArrayPtr;
                   Var Search : String) : Word;
  {-Return the position of Search in environment, or $FFFF if not found.
    Prior to calling SearchEnv, assure that
      EPtr is not nil,
      Search is not empty
  }
Var
  SLen : Byte Absolute Search;
  EOfs : Word;
  MOfs : Word;
  SOfs : Word;
  Match : Boolean;
begin
  {Force upper Case search}
  Search := UpCaseStr(Search);

  {Assure search String ends in =}
  if Search[SLen] <> '=' then begin
    Inc(SLen);
    Search[SLen] := '=';
  end;

  EOfs := 0;
  While EPtr^[EOfs] <> #0 do begin
    {At the start of a new environment element}
    SOfs := 1;
    MOfs := EOfs;
    Repeat
      Match := (EPtr^[EOfs] = Search[SOfs]);
      if Match then begin
        Inc(EOfs);
        Inc(SOfs);
      end;
    Until not Match or (SOfs > SLen);

    if Match then begin
      {Found a match, return index of start of match}
      SearchEnv := MOfs;
      Exit;
    end;

    {Skip to end of this environment String}
    SkipAsciiZ(EPtr, EOfs);

    {Skip to start of next environment String}
    Inc(EOfs);
  end;

  {No match}
  SearchEnv := $FFFF;
end;

Procedure GetAsciiZ(EPtr : EnvArrayPtr; Var EOfs : Word; Var EStr : String);
  {-Collect AsciiZ String starting at EPtr^[EOfs]}
Var
  ELen : Byte Absolute EStr;
begin
  ELen := 0;
  While (EPtr^[EOfs] <> #0) and (ELen < 255) do begin
    Inc(ELen);
    EStr[ELen] := EPtr^[EOfs];
    Inc(EOfs);
  end;
end;

Function GetEnvStr(Search : String) : String;
  {-Return a String from the environment}
Var
  SLen : Byte Absolute Search;
  EPtr : EnvArrayPtr;
  EOfs : Word;
  EStr : String;
  ELen : Byte Absolute EStr;
begin
  With CurEnv do begin
    ELen := 0;
    if (EnvSeg <> 0) and (SLen <> 0) then begin
      {Find the search String}
      EPtr := Ptr(EnvSeg, 0);
      EOfs := SearchEnv(EPtr, Search);
      if EOfs <> $FFFF then begin
        {Skip over the search String}
        Inc(EOfs, SLen);
        {Build the result String}
        GetAsciiZ(EPtr, EOfs, EStr);
      end;
    end;
    GetEnvStr := EStr;
  end;
end;

Procedure ClearEnvRec(Var Env : EnvRec);
  {-Initialize an environment Record}
begin
  FillChar(Env, SizeOf(Env), 0);
end;

Procedure CurrentEnv(Var Env : EnvRec);
  {-Return current environment Record}
Var
  ESeg : Word;
  Mcb : Word;
begin
  With Env do begin
    ClearEnvRec(Env);
    ESeg := MemW[PrefixSeg:$2C];
    Mcb := ESeg-1;
    if (Mem[Mcb:0] <> Byte('M')) or (MemW[Mcb:1] <> PrefixSeg) then
      Exit;
    EnvSeg := ESeg;
    EnvLen := MemW[Mcb:3] shl 4;
  end;
end;

Procedure NewEnv(Var Env : EnvRec; Size : Word);
  {-Allocate a new environment (on the heap)}
Var
  Mcb : Word;
begin
  With Env do
    if MaxAvail < Size+31 then
      {Insufficient space}
      ClearEnvRec(Env)
    else begin
      {31 extra Bytes For paraGraph alignment, fake MCB}
      GetMem(EnvPtr, Size+31);
      EnvSeg := SO(EnvPtr).S+1;
      if SO(EnvPtr).O <> 0 then
        Inc(EnvSeg);
      EnvLen := Size;
      {Fill it With nulls}
      FillChar(EnvPtr^, Size+31, 0);
      {Make a fake MCB below it}
      Mcb := EnvSeg-1;
      Mem[Mcb:0] := Byte('M');
      MemW[Mcb:1] := PrefixSeg;
      MemW[Mcb:3] := (Size+15) shr 4;
    end;
end;

Function SetEnvStr(Search, Value : String) : Boolean;
  {-Set environment String, returning True if successful}
Var
  SLen : Byte Absolute Search;
  VLen : Byte Absolute Value;
  EPtr : EnvArrayPtr;
  ENext : Word;
  EOfs : Word;
  MOfs : Word;
  OldLen : Word;
  NewLen : Word;
  NulLen : Word;
begin
  With CurEnv do begin
    SetEnvStr := False;
    if (EnvSeg = 0) or (SLen = 0) then
      Exit;
    EPtr := Ptr(EnvSeg, 0);

    {Find the search String}
    EOfs := SearchEnv(EPtr, Search);

    {Get the index of the next available environment location}
    ENext := EnvNext(EPtr);

    {Get total length of new environment String}
    NewLen := SLen+VLen;

    if EOfs <> $FFFF then begin
      {Search String exists}
      MOfs := EOfs+SLen;
      {Scan to end of String}
      SkipAsciiZ(EPtr, MOfs);
      OldLen := MOfs-EOfs;
      {No extra nulls to add}
      NulLen := 0;
    end else begin
      OldLen := 0;
      {One extra null to add}
      NulLen := 1;
    end;

    if VLen <> 0 then
      {Not a pure deletion}
      if ENext+NewLen+NulLen >= EnvLen+OldLen then
        {New String won't fit}
        Exit;

    if OldLen <> 0 then begin
      {OverWrite previous environment String}
      Move(EPtr^[MOfs+1], EPtr^[EOfs], ENext-MOfs-1);
      {More space free now}
      Dec(ENext, OldLen+1);
    end;

    {Append new String}
    if VLen <> 0 then begin
      Move(Search[1], EPtr^[ENext], SLen);
      Inc(ENext, SLen);
      Move(Value[1], EPtr^[ENext], VLen);
      Inc(ENext, VLen);
    end;

    {Clear out the rest of the environment}
    FillChar(EPtr^[ENext], EnvLen-ENext, 0);

    SetEnvStr := True;
  end;
end;

Begin

  CurrentEnv(CurEnv);

end.

