{$F-} {$R+} {$Q+} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit MultiTsk;

  { Implements detection of multitasking environments, including
    DesqView, OS/2, and different M$ Windows generations, and
    generic DPMI. This information isn't actually used for anything
    else but releasing a timeslice if we have nothing else to do with
    it (which is also implemented here). For some odd reason, the
    "normal" console dos shell function appears to be here as well? }

Interface

Var
  Idle    : Boolean;    { Eik jakson aikana ole tehty mitn? }
  Comspec : String;
Const
   MultiTaskers   : boolean = false; { Any multitaskers found }

 { DesqView support }

   DesqViewActive : boolean = false; { true if running under DESQview }
   DesqViewVer    : word    = 0;     { Version number }
   DesqViewVerStr : String[6] = '';  { Version string }

 { Windows support }

   WindowsActive  : boolean   = false; { MS Windows running }
   WindowsVer     : word      = 0;     { MS Windows version number }
   WindowsVerStr  : String[8] = '';    { Version string }
   WindowsMode    : word      = 0;     { Mode number }
   WindowsModeStr : String[8] = '';    { Mode string }

 { OS/2 support }

   OS2Active      : boolean   = false; { OS/2 running }
   OS2Ver         : word      = 0;     { It's version number }
   OS2VerStr      : String[8] = '';    { ... in a string }

 { DPMI support }

   DPMIActive     : boolean    = false;  { DPMI server running }
   ReleaseTime    : boolean    = false;  { Use DPMI calls }
   DPMIVer        : word       = 0;      { DPMI server version number }
   DPMIVerStr     : String[6]  = '';     { DPMI server version string }

 { DesqView support }

Procedure DESQviewBeginCritical;
Procedure DESQviewEndCritical;

 { General multitasker support }
Procedure IdleTime;

 { Dos shell swappaillen }
Function ExecSwapped(Path, CmdLine:String):Byte;
Procedure DosShell;                     { Swappaa clussen, avaa shellin }

 { ********************************************************************** }

Implementation
Uses crt, dos, CStrings, Screen, ExecWSwp, Config;

 { ********************************************************************** }

Function Word2VerStr(w:Word):String;
Begin

  Word2VerStr := Int2Str(hi(w)) + '.' + Int2Str(lo(w));

End;

 { ********************************************************************** }
 { Ollaanko DV:n alla, versionumero }

Procedure DetectDESQview;
Var
   regs : Registers;
Begin
   regs.cx := $4445;
   regs.dx := $5351; { date cx = DE, dx = SQ }
   regs.ax := $2B01; { dos set date function }
   msdos(regs);
   if (regs.al = $ff) then
      DESQviewActive := false { if dos detected an error, no DV active }
   else begin
        MultiTaskers   := true;
        DESQviewActive := true;
        DESQviewVer    := regs.bx;
        DESQviewVerStr := Word2VerStr(regs.bx);
        end;
End;

 { ********************************************************************** }
 { DV Api kutsu }

Procedure DESQviewApiCall(Func:Word); Assembler;
Asm
   push ds
   push bp
   push sp
   push ss
   mov ax, $101A  ; { switch to DV stack }
   int $15
   mov ax, func   ; { perform API call }
   int $15
   mov ax, $1025  ; { switch off DV stack }
   int $15
   pop ss
   pop sp
   pop bp
   pop ds
End;

 { ********************************************************************** }
 { Release timeslice }

Procedure DESQviewPause;
Begin
   DESQviewApiCall($1000);
End;

 { ********************************************************************** }
 { Tell DV not to slice away until a DESQviewEndCritical is issued }

Procedure DESQviewBeginCritical;
Begin
   DESQviewApiCall($101B);
End;

 { ********************************************************************** }

Procedure DESQviewEndCritical;
Begin
   DESQviewApiCall($101C);
End;

 { ********************************************************************** }

Procedure DPMIPause;
Var
 regs : Registers;
Begin

 regs.ax := $1680;
 Intr($2f,regs);

End;

 { ********************************************************************** }

Procedure DetectWindows;
Var
 regs : Registers;
Begin

 regs.ax := $160A;
 Intr($2f,regs);
 If regs.ax = 0
  then Begin
       MultiTaskers := True;
       WindowsActive := True;
       WindowsVer := regs.bx;
       If Hi(WindowsVer) = 4
        then WindowsVerStr := '95 (' + Word2VerStr(regs.bx) + ')'
        else If (Hi(WindowsVer) = 3) and (Lo(WindowsVer) > 5)
               then WindowsVerStr := 'NT ' + Word2VerStr(regs.bx)
               else WindowsVerStr := Word2VerStr(regs.bx);
       WindowsMode := regs.cx;
       Case WindowsMode of
        $2 : WindowsModeStr := 'standard';
        $3 : WindowsModeStr := '386Enh';
        else WindowsModeStr := 'unknown';
       End;
       End;

End;

 { ********************************************************************** }

Procedure DetectOS2;
Var
 regs : Registers;
Begin

 regs.ax := $4010;
 Intr($2f,regs);
 If regs.ax = 0
  then Begin
       MultiTaskers := True;
       OS2Active := True;
       OS2Ver := regs.bx;
       OS2VerStr := 'Warp ' + Word2VerStr(regs.bx);
       End;

End;

 { ********************************************************************** }

Procedure DetectDPMI;
Var
  b       : Byte;
  regs    : Registers;
Begin

 regs.ax := $1687;
 Intr($2f,regs);
 If regs.ax = 0
  then Begin
       MultiTaskers := True;
       DPMIActive := True;
       DPMIVer := regs.dx;
       DPMIVerStr := Word2VerStr(regs.dx);
       End;

End;

 { ********************************************************************** }

Procedure DetectTaskers;
Begin

 DetectDESQview;
 DetectWindows;
 DetectOS2;
 DetectDPMI;

End;

 { ********************************************************************** }

Procedure IdleTime;
Begin

 If ReleaseTime
  then DPMIPause
  else If DesqViewActive
         then DesqViewPause;

End;

 { ********************************************************************** }

Procedure DosShell;
Var
  w     : Word;
  Saved : SavedScreen;
Begin

 Action(65,'Swapping out...');
 If InitExecSwap
   then Begin
        SaveScreen(Saved);
        OriginalScreen;
        WriteLn('Clusse: Starting DOS shell. All Clusse activity is suspended.' + CrLf
              + 'Type EXIT to leave the shell.' + CrLf);
        RestoreInterrupts; { We're gonna swap our ISR's on the disk here! }
        w := ExecWinWithSwap(Comspec,'',1,1,80,25,OrigAttr);
        SetInterrupts;
        RestoreScreen(Saved);
        ShutDownExecSwap;
        GetDate(Dt.Year,Dt.Month,Dt.Day,DayOfWeek);
        GetTime(Dt.Hour,Dt.Min,Dt.Sec,w);

        Case w of
          0 : Action(65,'Back from DOS.');
          1 : Action(65,'Swapping error.');
          2 : Action(65,'DOS shell: COMSPEC not found.');
          3 : Action(65,'DOS shell: Path not found.');
          8 : Action(65,'DOS shell: Insufficient memory.');
        End;

        End
   else Action(65,'Swapping failed!');

End;

 { ********************************************************************** }

Function ExecSwapped(Path, CmdLine:String):Byte;
Var
  Saved : SavedScreen;
  w     : Word;
Begin

  If InitExecSwap
    then Begin
         SaveScreen(Saved);
         OriginalScreen;
         RestoreInterrupts; { We're gonna swap our ISR's on the disk here! }
         ExecSwapped := ExecWinWithSwap(Path,CmdLine,1,1,80,25,OrigAttr);
         SetInterrupts;
         RestoreScreen(Saved);
         ShutDownExecSwap;
         GetDate(Dt.Year,Dt.Month,Dt.Day,DayOfWeek);
         GetTime(Dt.Hour,Dt.Min,Dt.Sec,w);
         End
    else ExecSwapped := 9;

End;

 { ********************************************************************** }
 {$IFDEF Use_286}

Function Is286Able:Boolean; Assembler;
Asm
        PUSHF
        POP     BX
        AND     BX,0FFFH
        PUSH    BX
        POPF
        PUSHF
        POP     BX
        AND     BX,0F000H
        CMP     BX,0F000H
        MOV     AX,0
        JZ      @@1
        MOV     AX,1
@@1:
End;

 {$ENDIF}
 { ***************************************************************** }

Begin { Init }

 {$IFDEF Use_286}
 If not Is286Able
   then Begin
        WriteLn(' This version of OH7LZB Clusse was compiled using 80286 instructions.' + CrLf
              + ' Your processor was not found 80286 compatible. Sorry!');
        Halt(9);
        End;
 {$ENDIF}

 DetectTaskers;

End. { Init }

