{$F-} {$R+} {$Q+} {$V-} {$B-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit PCLink;

  { Implements much of the PacketCluster linking protocol. The main
    message parser is here, for example, as are the message transmitting
    functions. This code was originally in protocol.pas, and the intention
    was to separate the PC-specific stuff here when i started to think
    about supporting another protocol, but much of the stuff is still
    in the Protocol module. }

Interface
Uses Protocol, ConfFile;

Const
  PCVersion         = 5433; { PC version number of the local node. Clusse
                              uses 5433, as i've never seen a "real"
                              PacketCluster of 5.4-33, so i can see Clusse
                              systems from the node list 8-)
                              PacketCluster doesn't seem to care about
                              the version number. }
  PCListenVersion   = 5434; { PC version number used by the listen-only
                              link interface. }

Var
  PCHops            : Byte;
  Listened          : Boolean;
  PcMsgStats        : Array[10..59] of LongInt;

 { Send a message to a link }
Procedure SendPC(n:NodeRecP; Const s:String);

 { Send a message to all links except the one it came from.
   nil means it's local, so send to all. }
Procedure SendPCAll(FromLink:LinkRecP; Const S:String);

Function Hops2PCStr:String;

Procedure Dx(Info:DxInfoP);
Procedure Announce(Info:AnnP);
Procedure WWV(Info:WWVP);
Procedure Talk(Info:TalkRecP);

Procedure DelNode(h:NodeRecP;Const Reason:String);    { Drop a cluster node }

Procedure RDbRequest(Const ToPc,FromPc,FromUser:CallRec;Stream:Word;
                     Const Qualifier,Key:String);

Procedure PC_RequestMerge(n:NodeRecP; DxCount, WWVCount:Byte);

Procedure SetUserData(FromL:LinkRecP;Const Call:CallRec;b:Byte;Const Data:String);

Procedure SendLoopCheck(p:Byte);   { PC38 }
Procedure SendCluId(p:Byte);       { PC18 }

Procedure PCRcv(p:Byte); { Receive a PC message }

 { ====================================================================== }

Implementation
Uses Screen, Dos, CStrings, BPQ, Files, Config, Database;

Type
  PPMailSock = ^PMailSock;
  PMailSock = ^TMailSock;
  TMailSock = Record
              Index     : LongInt;
              FromPc,
              ViaPc,
              ToPc,
              FromUser,
              ToUser    : CallRec;
              Time      : LongInt;
              Personal  : Boolean;
              Subject   : String[80];
              Lines     : LongInt;
              Next      : PMailSock;
              PrevP     : PPMailSock;
              End;

Var
  InMailQ    : PMailSock;

 { ====================================================================== }

Procedure SendPC(n:NodeRecP; Const s:String);
Begin

 If Assigned(n)
   then With n^.Via^
         do Begin
            Send(Sock,s);
            Kick(Sock);
            End;

End;

 { ====================================================================== }

Procedure SendPCAll(FromLink:LinkRecP; Const S:String);
Var
  l : LinkRecP;
Begin

 l := Links;
 While assigned(l)
  do Begin
     With l^ do
       If (State = LS_Linked) and (l <> FromLink)
          and (BPQ.Sock[Sock]^.Mode = SM_PCLink)
          and ((Mode = LM_Normal) or (Mode = LM_Incoming))
            then Begin
                 Send(Sock,s);
                 Kick(Sock);
                 End;
     l := l^.Next;
     End;

End;

 { ====================================================================== }
 { PacketCluster linking protocol support procedures                      }
 { ====================================================================== }

Function ParsePC(num:Byte):String;
Var
  Alku, Loppu, i : Byte;
Begin
  Alku := 0;
  Loppu := 0;
  For i := 1 to Num do
    Repeat
    Inc(Alku);
    until IBuffer[Alku] = '^';
  Loppu := Alku;
  Repeat
  Inc(Loppu);
  until IBuffer[Loppu] = '^';
  ParsePC := Copy(IBuffer,Alku + 1,Loppu-Alku-1);
  If IBuffer[Alku + 1] = '^' then ParsePC := '';
End;

Function PCDateStr(i:LongInt):String; { d-Mon-year }
Var
  t : DateTime;
  s : String;
Begin
 UnPackTime(i,t);
 If (t.Month < 1) or (t.Month > 12)
   then t.Month := 10;
 If (t.Day < 1) or (t.Day > 31)
   then t.Day := 1;
 S := Int2Str(t.Day) + '-' + Months[t.Month] + '-' + Int2Str(t.Year);
 If (t.Day < 10) then PCDateStr := ' ' + S
                 else PCDateStr := S;
End;

Function PCTimeStr(i:LongInt):String;
Var
   t : DateTime;
Begin
 UnPackTime(i,t);
 PCTimeStr := IntStr(t.Hour) + IntStr(t.Min) + 'Z';
End;

Function PCStr2DT(DateStr,TimeStr:String):LongInt;
Var
  t   : DateTime;
  i   : LongInt;
  Err : Integer;
  b   : Byte;
  s   : String;
Begin

 b := Pos('-',DateStr);
 If (b > 0) and (length(DateStr) >= 10)
  then Begin
       Val(Copy(DateStr,1,b-1),t.Day,Err);
       If Err = 0
         then Begin
              s := LowCaseStr(Copy(DateStr,b+1,3));
              b := 0;
              Repeat
                Inc(b);
              until (b > 12) or (LowCaseStr(Months[b]) = s);
              If b <= 12
                then Begin
                     t.Month := b;
                     Val(Copy(DateStr, Length(DateStr)-3, 4), i, Err);
                     If (Err = 0) and (i >= 1996) and (i <= 3000)
                       then t.Year := i
                       else t.Year := 1977;
                     End
                else t.Month := 10;
              End
         else t.Day := 1;
       End
  else Begin
       t.Day := 1;
       t.Month := 10;
       T.Year := 1977;
       End;

 { Hour }
 Val(Copy(TimeStr,1,2),t.Hour,Err);
 If (Err <> 0) or (t.Hour < 0) and (t.Hour > 23)
   then t.Hour := 0;

 { Min }
 Val(Copy(TimeStr,3,2),t.Min,Err);
 If (Err <> 0) or (t.Min < 0) or (t.Min > 60)
   then t.Min := 0;

 t.Sec := 0;
 PackTime(t,i);
 PCStr2DT := i;

End;

Procedure PCStr2Hops(pos:Byte);
Var
  b   : Byte;
  str : String[3];
Begin

 str := ParsePC(pos);
 If (str[1] = 'H')
   then PCHops := 100 - Str2Byte(Copy(str,2,Length(str)-1))
   else PCHops := 99;

End;

Function Hops2PCStr:String;
Begin

 Hops2PCStr := 'H' + Int2Str(99 - PCHops);

End;

Procedure LoopDetected(l:LinkRecP);
Begin

 With l^
  do If not (State = LS_Held) { There might be several reasons to hold a link
                                in a single message... }
       then Begin
            Action(66,'Avoiding loop - holding link to ' + Call);
            State := LS_Held;
            DReason := DR_Loop;
            Disconnect(Sock);
            LogError('Loop detected via ' + Call + ': Link held.');
            End;
End;

 { ====================================================================== }

Procedure Dx(Info:DxInfoP);
Begin

 If PCHops > 98 then Exit;
 If Info^.Info = '' then Info^.Info := ' ';
 SendPCAll(Info^.FromLink,'PC11^' + Freq2Str(Info^.Freq) + '^' +  CutStr(12,Info^.Call) + '^'
                          + PCDateStr(Info^.Time) + '^' + PCTimeStr(Info^.Time) + '^'
                          + CutStr(30,Info^.Info) + '^' + Info^.FromCall + '^'
                          + Info^.FromPc + '^' + Hops2PCStr + '^~' + Cr);

End;

 { ====================================================================== }

Procedure Announce(Info:AnnP);
Var
 s : String;
 p : Byte;
Begin

 If PCHops > 98 then Exit;
 If Info^.Msg = '' then Info^.Msg := ' ';
 s := 'PC12^' + Info^.FromCall + '^' + Info^.ToPC + '^'
    + CutStr(190,Info^.Msg) + '^ ^' + Info^.FromPC + '^';
 If Info^.Wx then s := s + '1'
             else s := s + '0';
 s := s + '^' + Hops2PCStr + '^~' + Cr;

 If (Info^.ToPC <> CluCall)
    then If Info^.ToPC = '*'
           then SendPCAll(Info^.FromLink,s)
           else If GetNode(Info^.ToPc) <> nil
                  then Begin
                       p := GetNode(Info^.ToPc)^.Via^.Sock;
                       Send(p,s);
                       Kick(p);
                       End;

End;

 { ====================================================================== }

Procedure WWV(Info:WWVP);
Begin

 If PCHops > 98 then Exit;
 If Info^.Forecast = '' then Info^.Forecast := ' ';
 SendPCAll(Info^.FromLink,'PC23^' + PcDateStr(Info^.Time) + '^' + PadRight(2,Int2Str(Info^.Hour)) + '^'
                          + PadRight(3,Int2Str(Info^.SFI)) + '^' + PadRight(3,Int2Str(Info^.A)) + '^'
                          + PadRight(2,Int2Str(Info^.K)) + '^' + Info^.Forecast + '^'
                          + Info^.FromCall + '^' + Info^.FromPC + '^'
                          + Hops2PCStr + '^~' + Cr);

End;

 { ====================================================================== }

Procedure Talk(Info:TalkRecP);
Var
  s : String;
  u : NUserRecP;
  h : NodeRecP;
Begin

 If not assigned(Info^.ToPC)
   then Exit; { Just to be sure }

 If Info^.Msg = '' then Info^.Msg := ' ';

 s := 'PC10^' + Info^.FromCall + '^';

 u := GetNUser(Info^.ToCall);
 If Assigned(u)
  then s := s + Info^.ToCall
  else s := s + Info^.ToPc^.Call;

 s := s + '^' + CutStr(200,Info^.Msg) + '^*^';

 h := GetNode(Info^.ToCall);
 If not (Assigned(u) or assigned(h))
   then s := s + Info^.ToCall
   else s := s + ' ';

 s := s + '^' + Info^.FromPC + '^~' + Cr;

 SendPC(Info^.ToPc,s);

End;

 { ====================================================================== }

Procedure PC_Talk(p:Byte);
Var
 Info : TalkRec;
 u    : NUserRecP;
 h    : NodeRecP;
 Call : CallRec;
Begin

 Info.FromCall := ParsePc(1);
 Info.ToCall := ParsePc(2);
 Info.Msg := CleanStr(ParsePc(3));
 Info.FromPc := ParsePc(6);
 Info.FromLink := Port[p];
 Info.Time := Now;

 u := GetNUser(Info.ToCall);
 If Assigned(u)
   then Info.ToPc := u^.Pc
   else Begin
        Info.ToPc := GetNode(Info.ToCall);
        Call := ParsePc(5);
        If Call <> ' '
          then Info.ToCall := Call;
        End;

 If not assigned(Info.ToPc)
   then Info.ToPc := LocalNode; { ...grngrngrngrn!!! }

 Protocol.Talk(Info);

End;

 { ====================================================================== }

Procedure PC_PingReceive(p:Byte);
Var
  FromPc, ToPc : CallRec;
  Poll         : Boolean;
  h            : NodeRecP;
  up           : Byte;
  PointPrev,
  Point        : PingRecP;
  s            : String;
  FRec         : NodeFRec;
Begin
 ToPc := ParsePc(1);
 FromPc := ParsePc(2);
 Poll := (ParsePc(3) = '1');

 If not Poll
   then Begin { This is an ansver to a ping }
        h := GetNode(FromPC);
        If assigned(h) { If this node was being pinged }
          then Begin
               h^.Pinging := False;
               Point := PingQueue;
               PointPrev := Point;
               While Assigned(Point) and (Point^.Pc <> h)
                 do Begin { Find the ping record }
                    PointPrev := Point;
                    Point := Point^.Next;
                    End;
               If Assigned(Point)
                 then Begin { Tadaa! }
                      h^.Rtt := Point^.Time;
                      h^.RttOK := True;
                      Action(68,'Pong ' + h^.Call + ' rtt ' + Secs2Str(h^.Rtt));
                      up := GetLUser(Point^.PingedBy);
                      If (up < 255)
                        then Begin
                             Send(up,'Pinged ' + h^.Call + ' rtt ' + Secs2Str(h^.Rtt) + Cr);
                             Kick(up);
                             End;

                      { Write the result on disk for future reference }
                      FRec.Call := h^.Call;
                      FRec.Via := h^.Via^.Call;
                      FRec.Hops := h^.Hops;
                      FRec.HopsOK := h^.HopsOK;
                      FRec.Ver := h^.Ver;
                      FRec.RTT := h^.RTT;
                      WriteNode(@Frec);

                      Protocol.RemovePing(h);
                      End
                 else Action(68,'Unexpected pong from ' + FromPC);
               End;
        End;

 If (ToPc = Port[p]^.MyCall)
   then Begin
        If Poll
          then Begin { Hmm... we're the target! }
               Action(68,'We were pinged by ' + FromPc);
               Send(p,'PC51^' + FromPc + '^' + Port[p]^.MyCall + '^0^' + Cr);
               Kick(p);
               End;
        End
   else Begin { Naw... route it. }
        h := GetNode(ToPc);
        If assigned(h)
          then Begin
               If not h^.Pinging and Poll then AddPing(h,FromPc,PingTimeout);
               s := 'PC51^' + ToPc + '^' + FromPc + '^';
               If Poll then s := s + '1'
                       else s := s + '0';
               s := s + '^' + Cr;
               SendPC(h,s);
               End;
        End;
End;

 { ====================================================================== }
 { User tables                                                            }
 { ====================================================================== }

Procedure PC_Users(p:Byte); { PC50 receive }
Var
 h  : NodeRecP;
 hf : NodeFP;
 u  : NUserRecP;
 w  : Word;
Begin

 h := GetNode(ParsePc(1));
 If Assigned(h) and (h <> LocalNode)
   then If (h^.Via = Port[p])
   then Begin
        h^.Users := Str2Word(ParsePc(2));

        u := Users;
        w := 0;
        While assigned(u)
         do Begin
            If u^.pc = h
              then Inc(w);
            u := u^.Next;
            End;

        If w <> h^.Users
          then h^.UsersOK := False;

        CountUsers;
        Action(67,h^.Call + ' reports ' + Int2Str(h^.Users) + ' users');

        PCStr2Hops(3);
        If PCHops <> h^.Hops
         then Begin
              h^.Hops := PCHops;
              h^.HopsOK := True;
              { to the node file }
              hf := ReadNode(h^.Call);
              If not Assigned(hf)
               then Begin
                    New(hf);
                    hf^.Call := h^.Call;
                    hf^.Via := Port[p]^.Call;
                    hf^.Ver := h^.Ver;
                    hf^.Rtt := - 1;
                    End;
              hf^.Hops := h^.Hops;
              hf^.HopsOK := True;
              WriteNode(hf);
              Dispose(hf);
              End;

        If PCHops <= 98
          then SendPCAll(h^.Via,'PC50^' + h^.Call + '^' + Int2Str(h^.Users) + '^' + Hops2PCStr + '^' + Cr);
        End
   else LoopDetected(Port[p]);

End;

 { ====================================================================== }

Procedure PC_AddUser(p:Byte);
Var
  b, i     : Byte;
  n        : NodeRecP;
  u, First : NUserRecP;
  Prev     : ^NUserRecP;
  s        : String;
Begin { AddUser }

 n := GetNode(ParsePc(1));

 If Assigned(n)
  then If (n^.Via = Port[p])
  then Begin
       First := nil;
       Prev := @First;

       b := 2;
       While (ParsePc(b+2) <> '')
        do Begin
           s := ParsePc(b);
           If not (s = ' ')
            then Begin
                 New(Prev^);
                 u := Prev^;
                 Prev := @u^.Next;
                 u^.Next := nil;

                 With u^
                  do Begin
                     i := Pos(' ',s);
                     Call := Copy(s,1,i-1);
                     Name := '';
                     PC := n;
                     Time := now;
                     Here := (s[i+3] = '1');
                     AwayStrP := nil;
                     AwayTime := now;
                     Sysop := False;
                     Privileged := False;
                     End;
                 End;
           Inc(b);
           End;

       If Assigned(First)
        then Begin
             PCStr2Hops(b);
             Protocol.AddUser(First);
             End;

       End
  else If (n <> LocalNode)
         then LoopDetected(Port[p]);

End;


 { ====================================================================== }
 { Node tables                                                            }
 { ====================================================================== }

Procedure PC_NodeAddRec(p:Byte);
Var
 m    : Byte;
 s    : String;
 first,
 h, n : NodeRecP;
 next : ^NodeRecP;
 Hf   : NodeFP;
 b    : Byte;
Begin

 Next := @h;
 First := nil;
 h := nil;
 m := 1;

 While not ((Copy(ParsePc(m),1,1) = 'H') or (m > 200))
   do Begin
      s := ParsePc(m+1);

      If (s <> '') and ValidCall(s)
        then Begin
             n := GetNode(s);
             If not Assigned(n)
               then Begin
                    New(Next^);
                    h := Next^;
                    Next := @h^.Next;
                    If First = nil
                      then First := h;

                    With h^ do
                      Begin
                      Next := nil;
                      Call := s;
                      Via  := Port[p];
                      Since := now;
                      Here := (ParsePc(m) = '1');
                      Ver := Str2Word(ParsePc(m+3));
                      Pinging := False;
                      Users := 0;
                      UsersOK := True;
                      UsersK := False;
                      Locked := False;
                      End;

                    { Node file nodes.clu }
                    hf := ReadNode(h^.Call);
                    If Assigned(hf) and (hf^.Via = h^.Via^.Call)
                      then Begin
                           h^.Rtt := hf^.Rtt;
                           If h^.Rtt = - 1
                             then h^.RttOK := False
                             else h^.RttOK := True;
                           h^.Hops := hf^.Hops;
                           h^.HopsOK := hf^.HopsOK;
                           End
                      else Begin
                           h^.Rtt := 0;
                           h^.RttOK := False;
                           h^.Hops := 0;
                           h^.HopsOK := False;
                           New(hf);
                           hf^.Call := h^.Call;
                           hf^.Via := Port[p]^.Call;
                           hf^.Hops := 0;
                           hf^.HopsOK := False;
                           hf^.Rtt := - 1;
                           End;
                    Hf^.Ver := h^.Ver;
                    WriteNode(hf);
                    Dispose(hf);
                    End
               else Begin
                    If (n^.Via <> Port[p]) and (n <> LocalNode)
                      then LoopDetected(Port[p]);
                    End;
             End;

      Inc(m,4);
      End;

 If assigned(First)
  then Begin
       PCStr2Hops(m);
       Protocol.NodeAdd(First);
       End;

End;

 { ====================================================================== }

Procedure PC_NodeDelete(p:byte;Call:CallRec;Reason:String);
Var
 h         : NodeRecP;
Begin

 h := GetNode(Call);

 If assigned(h) { Is it on the node list }
   and (h <> localNode) and (h^.Via = Port[p]) { Check for a loop ($@&# PacketCluster (TM) !) }
  then Protocol.NodeDrop(h,Reason); { DIE! }

End;

 { ====================================================================== }

Procedure DelNode(h:NodeRecP;Const Reason:String);    { Drop a cluster node }
Begin

 If PCHops <= 98
   then SendPCAll(h^.Via,'PC21^' + h^.Call + '^' + Reason + '^' + Hops2PCStr + '^' + Cr);

End;


 { ====================================================================== }
 { P C   M A I L                                                          }
 { ====================================================================== }

Procedure PC_SendSubject(p:Byte);
Var
  Ti    : TalkRec;
  nu    : NUserRecP;
Begin

  Ti.ToCall := ParsePc(3);
  nu := GetNUser(Ti.ToCall);

  If assigned(nu)
   then Begin
        With Ti do
         Begin
         Time := Now;
         ToPc := nu^.Pc;
         if assigned(nu^.Pc^.Via)
            then FromCall := nu^.Pc^.Via^.MyCall
            else FromCall := CluCall;
         FromPc := FromCall;
         FromLink := nil;
         Msg := 'You have new mail from ' + ParsePc(4) + ' on node '
              + ParsePc(2) + ': "' + ParsePc(8) + '"';
         End;
        Protocol.Talk(Ti);
        End;
End;

 { ====================================================================== }
 { "Dummy" receiving code. Dumps the received message. Ugh!               }
 { *** DISABLED *** }

Function GetMailP(NumS:String):PMailSock;
Var
  q   : PMailSock;
  Num : LongInt;
Begin

 num := Str2LInt(NumS);
 q := InMailQ;
 While Assigned(q) and not (q^.Index = num)
  do q := q^.Next;

 GetMailP := q;

End;

Procedure AddMailSocket(p:Byte); { PC28 }
Var
  q    : PMailSock;
  prev : PPMailSock;
Begin

       q := InMailQ;
       prev := @InMailQ;

       While Assigned(q)
         do Begin
            prev := @q^.Next;
            q := q^.Next;
            End;

       New(q);
       prev^ := q;
       q^.Next := nil;
       q^.PrevP := prev;

       q^.ToPc     := ParsePc(1);
       q^.ViaPc    := ParsePc(2);
       q^.ToUser   := ParsePc(3);
       q^.FromUser := ParsePc(4);
       q^.Time     := PCStr2DT(ParsePc(5),ParsePc(6));
       q^.Personal := (ParsePc(7) = '1');
       q^.Subject  := ParsePc(8);
       q^.FromPc   := ParsePc(13);
       If q^.FromPc = '' then q^.FromPc := q^.ViaPc;
       Inc(Index.Mail);
       q^.Index    := Index.Mail;
       q^.Lines    := 0;

       Send(p,'PC30^' + q^.ViaPc + '^' + q^.ToPc + '^' + Int2Str(q^.Index) + '^' + Cr);
       Kick(p);

       Action(71,'Recv #' + Int2Str(q^.Index) + ': ' + q^.FromUser + ' > ' + q^.ToUser);

End;

Procedure MailReceive(p:Byte); { PC29 }
Var
  q    : PMailSock;
Begin

  q := GetMailP(ParsePc(3));

  If Assigned(q)
    then Begin
         Inc(q^.Lines);
         If q^.Lines mod 5 = 0
           then Begin
                Send(p,'PC31^' + q^.ViaPc + '^' + q^.ToPc + '^' + Int2Str(q^.Index) + '^' + Cr);
                Kick(p);
                Action(71,'Receiving #' + Int2Str(q^.Index) + ' - ' + Int2Str(q^.Lines) + ' lines');
                End;
         End;

End;

Procedure MailAckSubject(p:Byte); { PC30 PC Mail - Ack subject }
Begin

End;

Procedure MailAckText(p:Byte);    { PC31 Mail - Ack text }
Begin

End;

Procedure MailRecEnd(p:Byte); { PC32 }
Var
  q : PMailSock;
Begin

 q := GetMailP(ParsePc(3));

 If Assigned(q)
   then Begin
        Send(p,'PC33^' + q^.ViaPc + '^' + q^.ToPc + '^' + Int2Str(q^.Index) + '^' + Cr);
        Kick(p);
        Action(71,'Received #' + Int2Str(q^.Index) + ', ' + Int2Str(q^.Lines) + ' lines.');
        q^.PrevP^ := q^.Next;
        If Assigned(q^.Next)
          then q^.Next^.PrevP := q^.PrevP;
        Dispose(q);
        End;
End;

Procedure MailRecAbort(p:Byte); { PC42 }
Var
  q : PMailSock;
Begin

 q := GetMailP(ParsePc(3));

 If Assigned(q)
   then Begin
        Action(71,'Aborted receiving #' + Int2Str(q^.Index) + '.');
        q^.PrevP^ := q^.Next;
        If Assigned(q^.Next)
          then q^.Next^.PrevP := q^.PrevP;
        Dispose(q);
        End;

End;


 { ====================================================================== }
 { PC 44-48 - Remote databases                                            }
 { ====================================================================== }

Procedure RDbRequest(Const ToPc,FromPc,FromUser:CallRec;Stream:Word;
                     Const Qualifier,Key:String);
Begin

 SendPC(GetNode(ToPc),'PC44^' + ToPc + '^' + FromPc + '^' + Int2Str(Stream) + '^'
             + Qualifier + '^' + Key + '^' + FromUser + '^' + Cr);

End;

Procedure PC_RDbRequest(p:Byte);     { PC44 - Remote DB request }
Var
  ToPc, FromPc,
  FromUser       : CallRec;
  Stream         : Word;
  Qualifier, Key : String;
Begin

  ToPc := ParsePc(1);
  FromPc := ParsePc(2);
  Stream := Str2Word(ParsePc(3));
  Qualifier := ParsePc(4);
  Key := ParsePc(5);
  FromUser := ParsePc(6);

  If ToPc = Port[p]^.MyCall
    then Database.RDbRequest(p,1,FromPc,FromUser,Stream,Qualifier,Key)
    else RDbRequest(ToPc,FromPc,FromUser,Stream,Qualifier,Key);

End;

Procedure PC_RDbResponse(p:Byte);    { PC45 - Remote DB response }
Var
  ToPc, FromPc : CallRec;
  Stream       : Byte;
  Info         : String;
  n            : NodeRecP;
Begin

  ToPc := ParsePc(1);
  FromPc := ParsePc(2);
  Stream := Str2Byte(ParsePc(3));
  Info := ParsePc(4);

  If ToPc = Port[p]^.MyCall
    then Database.RDbResponse(FromPc,Stream,Info)
    else Begin
         n := GetNode(ToPc);
         If Assigned(n)
          and (n^.Via <> Port[p]) { Check for a loop ($@&# PacketCluster (TM) !) }
           then SendPC(n,'PC45^' + ToPc + '^' + FromPc + '^' + Int2Str(Stream) + '^'
                     + Info + '^~' + Cr);
         End;
End;

Procedure PC_RDbResponseEnd(p:Byte); { PC46 - Remote DB response end }
Var
  ToPc, FromPc : CallRec;
  Stream       : Byte;
  n            : NodeRecP;
Begin

  ToPc := ParsePc(1);
  FromPc := ParsePc(2);
  Stream := Str2Byte(ParsePc(3));

  If ToPc = Port[p]^.MyCall
    then Database.RDbResponseEnd(FromPc,Stream)
    else Begin
         n := GetNode(ToPc);
         If Assigned(n)
          and (n^.Via <> Port[p]) { Check for a loop ($@&# PacketCluster (TM) !) }
           then SendPc(n,'PC46^' + ToPc + '^' + FromPc + '^'
                     + Int2Str(Stream) + '^' + Cr);
         End;
End;

Procedure PC_RDbUpdate(p:Byte);      { PC47 - Remote DB update }
Var
  ToPc, FromPc, User : CallRec;
  n                  : NodeRecP;
Begin

  ToPc := ParsePc(1);
  FromPc := ParsePc(2);
  User := ParsePc(3);

  If ToPc = Port[p]^.MyCall
    then Begin
         End
    else Begin
         n := GetNode(ToPc);
         If Assigned(n)
          and (n^.Via <> Port[p]) { Check for a loop ($@&# PacketCluster (TM) !) }
           then SendPC(n,'PC47^' + ToPc + '^' + FromPc + '^'
                     + User + '^' + ParsePc(4) + '^' + ParsePc(5) + '^' + Cr);
         End;
End;

Procedure PC_RUserDbUpdate(p:Byte);  { PC48 - Remote user DB update }
Var
  ToPc, FromPc, User : CallRec;
  Stream             : Word;
  n                  : NodeRecP;
Begin

  ToPc := ParsePc(1);
  FromPc := ParsePc(2);
  Stream := Str2Word(ParsePc(3));
  User := ParsePc(6);

  If ToPc = Port[p]^.MyCall
    then Begin
         End
    else Begin
         n := GetNode(ToPc);
         If Assigned(n)
          and (n^.Via <> Port[p]) { Check for a loop ($@&# PacketCluster (TM) !) }
           then SendPC(n,'PC48^' + ToPc + '^' + FromPc + '^'
                     + '^' + Int2Str(Stream) + '^' + ParsePc(4) + '^' + ParsePc(5) + '^' + User + '^' + Cr);
         End;
End;


 { ====================================================================== }
 { PC 41 - Set user data                                                  }
 { ====================================================================== }


Procedure PC_SetUserData(p:Byte);
Var
  b : Byte;
  c : CallRec;
Begin

 PCStr2Hops(4);

 c := ParsePC(1);
 b := Str2Byte(ParsePC(2));
 If (b >= 1) and (b <= 4)
  then Protocol.SetUserData(GetNUser(c),Port[p],c,b,ParsePC(3));

End;

Procedure SetUserData(FromL:LinkRecP;Const Call:CallRec;b:Byte;Const Data:String);
Begin

 If PCHops <= 98
   then SendPCAll(FromL,'PC41^' + Call + '^' + Int2Str(b) + '^' + Data + '^'
                  + Hops2PCStr + '^~' + Cr);

End;

 { ====================================================================== }
 { PC 25 - Dx/WWV merge request                                           }
 { ====================================================================== }

Procedure PC_MergeReq(p:Byte);
Var
  FromPC, ToPC : CallRec;
Begin

  ToPC := ParsePC(1);
  If (ToPC = Port[p]^.MyCall) and not (GetNode(FromPC) = nil)
    then Begin
         FromPC := ParsePC(2);
         SendDXMerge(p,FromPC,Str2Byte(ParsePC(3)));
         End;

End;

Procedure PC_RequestMerge(n:NodeRecP; DxCount, WWVCount:Byte);
Begin
  SendPC(n,'PC25^' + n^.Call + '^' + n^.Via^.MyCall + '^'
          + Int2Str(DxCount) + '^' + Int2Str(WWVCount) + '^' + Cr);
End;

Procedure PC_DxMerge(l:LinkRecP);
Var
 DxInfo : DxInfoP;
Begin

 New(DxInfo);
 With DxInfo^
  do Begin
     Freq := Str2Freq(ParsePc(1));
     Call := ParsePc(2);
     Time := PCStr2Dt(ParsePc(3),ParsePc(4));
     Info := CleanStr(ParsePc(5));
     FromCall := ParsePc(6);
     FromPC := Call;
     FromLink := l;
     If FromPc <> CluCall
       then Protocol.Dx(DxInfo)
       else Dispose(DxInfo);
     End;

End;

Procedure PC_WWVMerge(l:LinkRecP);
Var
  dat     : DateTime;
  WWVInfo : WWVRec;
Begin

  With WWVInfo
   do Begin
      Time := PCStr2Dt(ParsePc(1),ParsePc(2));
      UnPackTime(Time,dat);
      Hour := dat.Hour;
      SFI := Str2Word(ParsePc(3));
      A   := Str2Word(ParsePc(4));
      K   := Str2Word(ParsePc(5));
      Forecast := CleanStr(ParsePc(6));
      FromCall := ParsePc(7);
      FromPC   := ParsePc(8);
      FromLink := l;
      End;

  Protocol.WWV(WWVInfo);

End;

 { ====================================================================== }
 { DX, WWV, Announcements                                                 }
 { ====================================================================== }

Procedure PC_Dx(l:LinkRecP);
Var
  DxInfo : DxInfoP;
Begin

 New(DxInfo);
 With DxInfo^
   do Begin
      Freq := Str2Freq(ParsePc(1));
      Call := ParsePc(2);
      Time := PCStr2Dt(ParsePc(3),ParsePc(4));
      Info := CleanStr(ParsePc(5));
      FromCall := ParsePc(6);
      FromPC := ParsePc(7);
      FromLink := l;
      End;
 PCStr2Hops(8);
 Protocol.Dx(DxInfo);

End;

Procedure PC_Ann(l:LinkRecP);
Var
  AnnInfo : AnnP;
Begin

 New(AnnInfo);
 With AnnInfo^
   do Begin
      FromCall := ParsePc(1);
      ToPc     := ParsePc(2);
      Msg      := CleanStr(ParsePc(3));
      Sysop    := (ParsePc(4) = '*');
      FromPc   := ParsePc(5);
      Wx       := (ParsePc(6) = '1');
      Time     := Now;
      FromLink := l;
      End;
 PCStr2Hops(7);
 Protocol.Announce(AnnInfo);

End;

Procedure PC_WWV(l:LinkRecP);
Var
  WWVInfo : WWVRec;
  dat     : DateTime;
Begin

  With WWVInfo
   do Begin
      Time := PCStr2Dt(ParsePc(1),ParsePc(2));
      UnPacktime(Time,dat);
      Hour := dat.Hour;
      SFI := Str2Word(ParsePc(3));
      A   := Str2Word(ParsePc(4));
      K   := Str2Word(ParsePc(5));
      Forecast := CleanStr(ParsePc(6));
      FromCall := ParsePc(7);
      FromPC   := ParsePc(8);
      FromLink := l;
      PCStr2Hops(9);
      End;

  Protocol.WWV(WWVInfo);

End;

 { ====================================================================== }
 { Some local support procedures                                          }
 { ====================================================================== }

 { When initiating a new link, send the full node table. Local node must
   be sent first, then the rest. PacketCluster sends all nodes in one PC19
   message (or more, if they do not fit in one ax.25 frame). This causes
   some problems, since the hop count is 99 for all nodes - they get
   distributed farther than they should be. Here, we use one PC19 per a
   value of the hop counter, multiple nodes in one PC19 if possible. }

Procedure SendPCNodeList(p:Byte);
Var
  n      : NodeRecP;
  s      : String;     { String to be sent }
  Count  : Byte;       { How many nodes in this PC19 }
  hFound,              { Are we searching for nodes with the hop counter
                         above? If not, get the next unlocked node record }
  Done   : Boolean;    { All nodes sent? }

 Procedure NDataStr;
 Begin

   n^.Locked := True; { Lock the record! }
   If Length(s) > 220
     then Begin { Uhh, frame filling up, flush it! }
          s := s + Hops2PCStr + '^' + Cr;
          Send(p,s);
          Count := 0;
          s := 'PC19^';
          End;
   If n^.Here
     then s := s + '1'
     else s := s + '0';

   s := s + '^' + n^.Call + '^0^' + Int2Str(n^.Ver) + '^';
   Inc(Count);

 End;

Begin

 { Send local node first! }
 s := 'PC19^0^' + CluCall + '^0^' + Int2Str(PCVersion) + '^H99^' + Cr;
 Send(p,s);
 s := 'PC19^';
 PCHops := 1;
 Count := 0;
 hFound := True;
 LocalNode^.Locked := True;
 Done := False;

 Repeat { Loop until Done }

   n := Nodes;
   While assigned(n)
     do Begin
        If { looking for nodes with the same hop counter: }
           (hFound and (n^.Via <> Port[p]) and n^.HopsOK and (n^.Hops = PCHops) and (not n^.Locked) )
           { OR looking for an unlocked node: }
           or ((not hFound) and (n^.Via <> Port[p]) and n^.HopsOK and (not n^.Locked) and (n^.Hops < 99))
          then Begin
               If not hFound
                 then Begin { Okay, we found an unsent one, go look for others
                              with the same hop counter }
                      hFound := True;
                      PCHops := n^.Hops;
                      End;
               NDataStr;
               End;
        n := n^.Next;
        End;

   If (Count > 0) { If there are nodes in this message, flush it }
     then Begin
          s := s + Hops2PCStr + '^' + Cr;
          Send(p,s);
          Count := 0;
          s := 'PC19^';
          End;

   If not hFound then Done := True;
   hFound := False;

 until Done;

 { Then, send the ones with unknown hop count. }
 n := Nodes;
 PCHops := 1;  { I really don't know what to do with these. }
 While assigned(n)
  do Begin
     If (not n^.HopsOK) and (not n^.Locked) and (n^.Via <> Port[p])
       then NDataStr;
     n := n^.Next;
     End;

 If (Count > 0) { If there are nodes in this message, flush it }
   then Begin
        s := s + Hops2PCStr + '^' + Cr;
        Send(p,s);
        End;

 ClearNLocks; { All n^.Locked := False }

End;

 { ====================================================================== }

Procedure SendPCUserList(p:Byte);
Var
  s : String;
  n : NodeRecP;
  u : NUserRecP;
  b : Byte;
Begin

 n := Nodes;
 While assigned(n)
  do Begin
     If (n^.Via <> Port[p]) and (n^.Hops < 99)
      then Begin
           s := 'PC16^' + n^.Call;
           b := 0;
           If n^.HopsOK  { If at all possible, use the actual hop count of the node }
            then PCHops := n^.Hops
            else PCHops := 1;

           u := Users;
           While Assigned(u)
             do Begin
                If (u^.Pc = n)
                  then Begin
                       If Length(s) > 225
                         then Begin { Frame filling up, flush it... }
                              s := s + '^' + Hops2PCStr + '^' + Cr;
                              Send(p,s);
                              s := 'PC16^' + n^.Call;
                              b := 0;
                              End;
                       s := s + '^' + u^.Call + ' - ';
                       If u^.Here
                         then s := s + '1'
                         else s := s + '0';
                       Inc(b);
                       End;
                u := u^.Next;
                End;


          If b > 0
            then Begin
                 s := s + '^' + Hops2PCStr + '^' + Cr;
                 Send(p,s);
                 End;
          End;

     n := n^.Next;
     End;

End;

 { ====================================================================== }
 { PC38 - Match against node table to avoid looping }

Procedure CheckLoop(p:Byte);
Var
  b : Byte;
  c : CallRec;
Begin

 { Convert the comma-separated field to a ^-separated string for ParsePc }
 IBuffer :=  '^' + ParsePc(1) + '^';
 b := 0;
 While b < Length(IBuffer)
  do Begin
     Inc(b);
     If iBuffer[b] = ','
       then iBuffer[b] := '^';
     End;

 b := 1;
 c := ParsePc(b);

 Repeat

   If (GetNode(c) <> nil) and (c <> CluCall)
     then Begin
          LoopDetected(Port[p]);
          b := 253;
          End;

   Inc(b);
   c := ParsePc(b);
 Until (c = '') or (b = 254);

End;

Procedure SendLoopCheck(p:Byte);
Var
  n : NodeRecP;
  s : String;
Begin

 s := 'PC38^';
 n := Nodes;
 While Assigned(n)
  do Begin
     If Length(s) > 225
       then Begin { Frame filling up, flush it... }
            Dec(s[0]);
            s := s + '^~' + Cr;
            Send(p,s);
            s := 'PC38^';
            End;
     s := s + n^.Call + ',';
     n := n^.Next;
     End;

 Dec(s[0]);
 s := s + '^~' + Cr;
 Send(p,s);

End;

 { ====================================================================== }
 { The first message sent to an incoming link                             }

Procedure SendCluId(p:Byte);
Begin

  Send(p,'PC18^ HELO <' + CluId + '-0.1-0> (' + Versio + ') ^' + Int2Str(PCVersion) + '^' + Cr);

End;

 { ====================================================================== }
 { Things done after finishing a link                                     }

Procedure PC_InitDone(l:LinkRecP);
Begin

 With l^
  do If (Mode = LM_Normal) or (Mode = LM_Incoming) then
      Begin { InitDone }
      PC := GetNode(Call);
      If PC <> nil
        then Begin
             AddPing(PC,MyCall,PingTimeout); { Pingataan }
             Send(Sock,'PC50^' + MyCall + '^' + Int2Str(LUserCount) + '^H');
             If Mode = LM_Incoming
               then Send(Sock, '1^' + Cr) { Local users count }
               else Send(Sock, '99^' + Cr);
             If (PCPollDx > 0) or (PCPollWWV > 0) { Merge spots }
               then PC_RequestMerge(PC, PCPollDx, PCPollWWV);
             Kick(Sock); { Merge dx & wwv }
             Action(66,'Finished handshaking ' + Call);
             End
        else Begin
             State := LS_Held;
             Disconnect(Sock);
             Action(66,'Wrong callsign in links.ini - ' + Call + ' not found.');
             LogError('Wrong callsign in links.ini for ' + Call
                       + ': doesn''t match the neighbouring node. Link held.');
             End;
      End;

End;

 { ====================================================================== }
 { PacketCluster proto receiver                                           }
 { ====================================================================== }

Procedure PCRcv(p:Byte);
Var
  MsgType  : Byte;
  b        : Byte;
  i,m      : Integer;
  dat      : DateTime;
  s        : String;
  l        : LinkRecP;

 Function CheckDisc:Boolean;
 Const DiscStrings : Array[1..6] of String[10]
          = ('disconnect', 'reconnect', 'fail', 'busy', 'timeout', 'reset');
 Var l : Byte;
 Label out;
 Begin
 s := LowCaseStr(IBuffer);
 For l := 1 to 6
   do If Pos(DiscStrings[l],s) > 0
     then Begin
          Disconnect(p);
          Goto out;
          End;

 For l := 1 to Port[p]^.DiscStrings
   do If Pos(Port[p]^.DiscStr[l],s) > 0
     then Begin
          Disconnect(p);
          Goto out;
          End;

  out:

 End;

 { ******* }

Begin

 l := Port[p];

 { Is this a valid message }
 Inc(PCInvalid);
 If (Copy(IBuffer,1,2) <> 'PC') and CheckDisc
   then Exit;

 Val(Copy(IBuffer,3,2),MsgType,i);
 If i <> 0 then Exit; { yk en sy! }

 Dec(PCInvalid);
 Inc(PCReceived);
 s := '';

 If (MsgType >= 10) and (MsgType <= 51)
   then Inc(PCMsgStats[MsgType]);

 With l^
   do Begin
      If Mode = LM_Listen
        then Listened := True;
      If State = LS_Held { If we've encontered a loop and disconnected the link, }
        then Exit;       { but we're still receiving buffered messages ... }

 Case MsgType of

 10 : PC_Talk(p); { Talk }
 11 : PC_Dx(l); { DX Info }
 12 : If (Mode = LM_Normal) or (Mode = LM_Incoming) then PC_Ann(l);

 { 13-15: conference mode }

 16 : If (Mode = LM_Normal) or (Mode = LM_Incoming) then PC_AddUser(p);

 17 : If (Mode = LM_Normal) or (Mode = LM_Incoming) then
      { DeleteUser }
      Begin
      PCStr2Hops(3);
      DeleteUser(l,ParsePc(1),GetNode(ParsePc(2)),now);
      End;

 18 : Begin { RequestInit }
      Ver := Str2Word(ParsePc(2));
      If Mode = LM_Normal
        then Begin
             SendPCNodeList(p);
             SendPCUserList(p);
             End
        else Send(p,'PC19^0^' + MyCall + '^0^'
                   + Int2Str(PCListenVersion) + '^H1^' + Cr);

      Send(p,'PC20^' + Cr); { That's all from me... }

      Kick(p);
      If not (State = LS_Linked)
        then Protocol.LinkMade(l);
      End;

 19 : If (Mode = LM_Normal) or (Mode = LM_Incoming) then
      PC_NodeAddRec(p); { NodeAdd }

 20 : Begin
      If (Mode = LM_Normal) or (Mode = LM_Incoming)
        then Begin
             SendPCNodeList(p);
             SendPCUserList(p);
             End;

      Send(p,'PC22^' + Cr); { That's all from me... }

      Kick(p);
      If not (State = LS_Linked)
        then Protocol.LinkMade(l);

      PC_InitDone(l);
      End;

 21 : If (Mode = LM_Normal) or (Mode = LM_Incoming) then
      Begin { NodeDelete }
      PCStr2Hops(3);
      PC_NodeDelete(p,ParsePc(1),CleanStr(ParsePc(2)));
      End;

 22 : PC_InitDone(l);

 23 : PC_WWV(l);

 24 : If (Mode = LM_Normal) or (Mode = LM_Incoming) then
      Begin { User here/away status }
      PCStr2Hops(3);
      If ParsePc(2) = '1'
       then SetHere(l,ParsePc(1))
       else SetAway(l,ParsePc(1),'');
      End;

 25 : PC_MergeReq(p); { dx/wwv merge request }
 26 : PC_DxMerge(l);
 27 : PC_WWVMerge(l);

{ 28 : AddMailSocket(p);}  { PC Mail - Send subject }
 28 : PC_SendSubject(p);
{ 29 : MailReceive(p);    { PC Mail - Send text }
{ 30 : MailAckSubject(p); { PC Mail - Ack subject }
{ 31 : MailAckText(p);    { PC Mail - Ack text }
{ 32 : MailRecEnd(p);     { PC Mail - End of text }
{ 33 : AckCompleteText }

 { 34-36 : Remote commands }

 { 37 : Needs database update }

 38 : If (State = LS_Init) and (Mode = LM_Normal)
        then Begin
             Action(66,'Handshaking with ' + Call);
             CheckLoop(p);  { Match against node table to avoid looping }
             End;

 39 : Begin
      DReason := DR_Remote;
      Disconnect(p);     { Delete node & disconnect: this does it all 8-) }
      End;

 { 40 : PC File forwarding }

 41 : PC_SetUserData(p);

 42 : MailRecAbort(p);   { PC Mail - Abort forwarding }

 { 43 : PC Mail - external mail, sendsubject }

 44 : PC_RDbRequest(p);     { Remote DB request }
 45 : PC_RDbResponse(p);    { Remote DB response }
 46 : PC_RDbResponseEnd(p); { Remote DB response end }
 47 : PC_RDbUpdate(p);      { Remote DB update }
 48 : PC_RUserDbUpdate(p);  { Remote user DB update }

 { 49 : Delete bulletin mail }

 50 : If (Mode = LM_Normal) or (Mode = LM_Incoming) then
      PC_Users(p); { Users count }
 51 : PC_PingReceive(p); { Ping }

 Else Inc(PCUnknown);
 End; { Case MsgType }

 PCHops := 0;
 Listened := False;

 End; { With Link[po]^ }

End;

 { ====================================================================== }

End.
