
Unit ConfFile;

Interface

Uses
     {$IFDEF SETUP}Dos, Objects, Views, Dialogs, Strings;
     {$ELSE}Dos;{$ENDIF}
Const
  GroupsAvail  = 20;
  PromptsAvail = 8;

  { Colors }
  cmStat1        = 136;
  cmStat2        = 137;
  cmStat3        = 138;
  cmStatVer      = 139;
  cmStatAction   = 140;
  cmStatClock    = 141;
  cmStatCritical = 142;

  cmRxRec        = 143;
  cmRxHi         = 144;
  cmRxCon        = 145;

  cmTxWin        = 146;

  cmMonSystem    = 147;
  cmMonCritical  = 148;
  cmMonHeaders   = 149;
  cmMonText      = 150;

Type

  {$IFNDEF SETUP}
  PPalette = ^TPalette;
  TPalette = Array[0..255] of Byte;

  pWord        = ^Word;
  pByte        = ^Byte;
  {$ENDIF}

  THeadStr     = Array[1..80] of Char;
  TSignature   = Array [1..9] of Char;

  CallRec      = String[10];
  TIfType      = (G8BPQ, Flex);
  TDateFormat  = (dmy, mdy, ymd, ydm);

  TDateItems   = (df_SeparatorEnd, df_unused1, df_unused2);
  PDateFlags   = ^TDateFlags;
  TDateFlags   = Set of TDateItems;

  MonitorItems = (MO_Band, MO_Actions);
  TMonitorMode = Set of MonitorItems;

  LogItems     = (L_Updown, L_LUser, L_NUser, L_Node, L_Link, L_SU, L_Console);
  PLogItems    = ^TLogItems;
  TLogItems    = Set of LogItems;

  MessageItems = (M_Dx, M_Ann, M_WWV, M_Wx, M_Talk, M_User, M_Localuser,
                  M_Node, M_Link);
  PMessages    = ^TMessages;
  TMessages    = Set of MessageItems;

  FlagItems    = (f_Beeps, f_Timestamp, f_Timer, f_PCCompat, f_Filter);
  PFlags       = ^TFlags;
  TFlags       = Set of FlagItems;

  LoginItems   = (LO_LDx, LO_LAnn, LO_LWWV, LO_LUser, LO_LNode, LO_LLink,
                 LO_Fortune, LO_Unused1, LO_Unused2);
  PLoginItems  = ^TLoginItems;
  TLoginItems  = Set of LoginItems;

  RightItems   = (R_Login, R_ARESLogin, R_Interact, R_WideAct,
                  R_AresCMD, R_LinkCMD, R_HaltCMD, R_suCMD, R_AllCMD,
                  R_NeverExpire, R_Norights
                  );

  fRightItems  = (R_FileCMD, R_AllFiles, R_InWrite, R_UserWrite, R_AllWrite,
                  R_PubExec, R_UserExec, R_AllExec, R_DosExec, R_uu2, R_Nofrights);

  PRights      = ^TRights;
  TRights      = Set of RightItems;
  PfRights     = ^TfRights;
  TfRights     = Set of fRightItems;

  PGroup       = ^TGroup;
  TGroup       = Record
                 Used    : Boolean;
                 Name    : String[15];
                 Rights  : TRights;
                 fRights : TfRights;
                 End;

  PSecretNumber = ^TSecretNumber;
  TSecretNumber = Array[0..255] of Byte;

  PCrtMode      = ^TCrtMode;
  TCrtMode      = (CM_Auto, CM_Direct, CM_BIOS);

  { Configuration data }
  CF_HeadRec    = Record { Header for the config file }
                  HeadStr        : THeadStr;
                  Signature      : TSignature;
                  Version        : Word;
                  End;

  CF_LocaleRec  = Record { Date/time format and other internationalization }
                  DateFormat     : TDateFormat;
                  DateFlags      : TDateFlags;
                  DateSeparator  : Char;
                  TimeSeparator  : Char;
                  End;

  CF_Interface  = Record { Interface parameters }
                  IfType         : TIfType;      { BPQ or PC/FlexNet }

                  Start_port,                    { First BPQ stream -1 }
                  No_ports,                      { How many streams }
                  BPQInt,                        { BPQ interrupt }
                  ApplNum,                       { BPQ application number }

                  Max_paclen     : Byte;         { Maximum packet length }
                  Link_reset     : Word;         { Link timeout reset time }
                  Usr_timeout    : Word;         { Timeout }

                  Buf_treshold   : Byte;         { How Low Can You Go (tm) }

                  MonitorMode    : TMonitorMode; { Monitor window mode }
                  End;

  CF_UDefaults  = Record { Default user parameters }
                  DGroup         : Byte;         { Default group }
                  DPrompt        : Byte;         { Prompt }
                  DMessages,                     { etc etc etc... }
                  DBeeps         : TMessages;
                  DFlags         : TFlags;
                  DLogin         : TLoginItems;
                  End;

  CF_Adm        = Record { Administrative stuff }
                  OpGroup           : Byte;           { Operator group }
                  SysopCall         : CallRec;        { Sysop's callsign }
                  SysopSecretNumber : TSecretNumber;  { Sysopin password, first byte is the length }
                  LogMask           : TLogItems;      { What to log }
                  End;

  CF_Convers    = Record { conversd }
                  DefaultChan       : Word;         { Default channel }
                  ConvHostName      : String[10];   { Convers hostname }
                  End;

  CF_Crt        = Record { Screen }
                  CrtType           : Byte;         { CRT type }
                  CrtMode           : TCrtMode;     { How many lines }
                  Pal               : TPalette;     { Color palette }
                  End;

  CF_Expiration = Record { Expiration }
                  ExpiryHour   : Byte;
                  ExpiryTimes  : Record { How long to store data }
                                 Dx,    { in days }
                                 Ann,
                                 WWV,
                                 Last,
                                 LUser,
                                 NUser,
                                 Node   : Word;
                                 End;
                  End;

  CF_Buffers    = Record { Buffer sizes }
                  BufSizes     : Record { Not really used yet! }
                                 Dx,
                                 Ann,
                                 WWV,
                                 Last,
                                 NUser,
                                 Node   : Word;
                                 End;
                  End;

  TSoundHw      = (SHW_none, SHW_lptDac, SHW_sb); { Sound hardware type }
  TidType       = (IDT_every, { every idInterval, even when nothing else to say }
                   IDT_used,  { every idInterval, only when something else to say }
                   IDT_always); { after every transmission }

  CF_Sound      = Record { Audio interface }
                  { Hardware settings }
                  SoundHw      : TSoundHw;

                  lptBase      : Word;
                  lptInt       : Byte;

                  sbBase       : Word;
                  sbInt        : Byte;
                  sbDMA        : Byte;

                  { Other parameters }

                  Mycall       : CallRec;
                  idInterval   : Word;     { in minutes, 0: disable }
                  idType       : TidType;

                  cwSpeed      : Byte; { WPM }
                  cwFreq       : Word; { CW beep frequency }

                  txHead       : Word; { milliseconds }
                  txTail       : Word; { milliseconds }

                  End;

  PConfig = ^TConfig;
  TConfig = Record

    Header         : CF_HeadRec;   { Header }
    Locale         : CF_LocaleRec; { Date/time format and other local stuff}

    { General parameters }
    CluCall        : CallRec;
    ConsoleCall    : CallRec;
    QTHLoc         : String[6];

    Ifc            : CF_Interface;  { Interface parameters }
    UDefaults      : CF_UDefaults;  { Default user parameters }
    Groups         : Array[1..GroupsAvail] of TGroup; { Privilege groups }
    Adm            : CF_Adm;        { Administrative stuff }
    Exp            : CF_Expiration; { Expiration }
    Buf            : CF_Buffers;    { Buffer sizes }
    Conv           : CF_Convers;    { Conversd }
    Crt            : CF_Crt;        { Screen }
    Sound          : CF_Sound;      { Audio interface }

  End;

Var
  Conf : PConfig;

  {$IFDEF SETUP}
  DefaultsUsed : Boolean;
  {$ENDIF}

  {$IFDEF Clusse}
  CluPath       : PathStr;   { Ohjelman sijainti }
  {$ENDIF}

Function ReadConfig:Byte;
Procedure WriteConfig;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

Implementation
{$IFDEF SETUP}
Uses
  App, HelpFile, MsgBox;
{$ENDIF}
{$IFDEF Clusse}
Uses
  CStrings;
{$ENDIF}
Const

  ConfVer    = 1;

{$IFDEF SETUP}
  Cr         = #$0D;
  Lf         = #$0A;
  CrLf       = Cr+Lf;
  EOF        = #$1A;
  HeadString : THeadStr
             =   'Clusse binary configuration file.' + CrLf
              + 'NOT to be edited by hand!' + CrLf + EOF;
  Nocall     : CallRec = 'N0CALL';
{$ENDIF}
  Sign       : TSignature
             = '!Hessu''s!';
  fName      = 'clusse.cfg';

{$IFDEF upd}
  CluPath = '';
{$ENDIF}

Var
  b : Byte;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }
 {$IFDEF SETUP}

Procedure DefPalette;
Const
  CCluColor      = #127#127#47#121#46#113#44#31#30#27#48#113#124#127#112;
  CCluBlackWhite = #127#127#47#121#46#113#44#31#30#27#48#113#124#127#112;
  CCluMonochrome = #127#127#47#121#46#113#44#31#30#27#48#113#124#127#112;
  CNewColor = CAppColor + CHelpColor + CCluColor;
  CNewBlackWhite = CAppBlackWhite + CHelpBlackWhite + CCluBlackWhite;
  CNewMonochrome = CAppMonochrome + CHelpMonochrome + CCluMonochrome;
  P: array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  Conf^.Crt.Pal := P[AppPalette];
end;

Procedure DefaultConfig;
Var b : Word;
Begin

 With Conf^
  do Begin
     With Header
      do Begin
         HeadStr            := HeadString;
         Signature          := Sign;
         Version            := ConfVer;
         End;

     CluCall            := nocall;
     ConsoleCall        := nocall;
     QTHLoc             := 'AA00AA';

     With Locale
      do Begin
         DateFormat         := dmy;
         DateFlags          := [df_SeparatorEnd];
         DateSeparator      := '.';
         TimeSeparator      := ':';
         End;

     With Ifc
      do Begin
         IfType             := G8BPQ;

         Start_port         := 0;
         No_ports           := 64;
         BPQInt             := 127;
         ApplNum            := 1;

         Max_Paclen         := 230;
         Link_reset         := 0;

         Buf_treshold       := 20;

         MonitorMode        := [MO_Band];

         Usr_timeout        := 10080;
         End;

     With UDefaults
      do Begin
         DGroup             := 10;
         DPrompt            := 1;
         DMessages          := [m_Dx, m_Ann, m_WWV, m_Wx, m_Talk];
         DBeeps             := [m_Dx, m_Ann, m_Talk];
         DFlags             := [f_Beeps, f_Filter];
         DLogin             := [LO_Fortune, LO_LDx];
         End;

     With Groups[1]
      do Begin
         Used     := False;
         Name     := 'Unused';
         Rights   := [R_Login, R_Interact];
         fRights  := [R_FileCMD, R_inWrite, R_PubExec];
         End;

     For b := 2 to 20
      do Groups[b] := Groups[1];

     With Groups[1]
      do Begin
         Used     := True;
         Name     := 'Excluded';
         Rights   := [R_NeverExpire];
         fRights  := [];
         End;

     With Groups[2]
      do Begin
         Used     := True;
         Name     := 'Jerk';
         Rights   := [R_Login];
         fRights  := [];
         End;

     With Groups[10]
      do Begin
         Used     := True;
         Name     := 'User';
         Rights   := [R_Login, R_Interact, R_WideAct];
         fRights  := [R_FileCMD, R_InWrite,
                     R_PubExec];
         End;

     With Groups[13]
      do Begin
         Used     := True;
         Name     := 'User/ARES';
         Rights   := [R_Login, R_ARESLogin, R_Interact, R_WideAct];
         fRights  := [R_FileCMD, R_InWrite,
                     R_PubExec];
         End;

     With Groups[14]
      do Begin
         Used     := True;
         Name     := 'ARES operator';
         Rights   := [R_Login, R_ARESLogin, R_Interact, R_WideAct,
                     R_ARESCmd, R_NeverExpire];
         fRights  := [R_FileCMD, R_InWrite,
                     R_PubExec];
         End;

     With Groups[18]
      do Begin
         Used     := True;
         Name     := 'Operator';
         Rights   := [R_Login, R_ARESLogin, R_Interact, R_WideAct,
                     R_LinkCmd,
                     R_ARESCmd, R_suCMD, R_NeverExpire];
         fRights  := [R_FileCMD, R_InWrite, R_UserWrite,
                     R_PubExec];
         End;

     With Groups[20]
      do Begin
         Used     := True;
         Name     := 'Superuser';
         Rights   := [R_Login, R_ARESLogin, R_Interact, R_WideAct,
                     R_LinkCMD,
                     R_AresCmd, R_HaltCMD, R_AllCMD, R_suCMD];
         fRights  := [R_FileCMD, R_AllFiles, R_InWrite, R_UserWrite, R_AllWrite,
                     R_PubExec, R_UserExec, R_AllExec, R_DosExec];

         End;

     With Adm
      do Begin
         OpGroup      := 18;
         SysopCall    := nocall;

         For b := 6 to 255
           do SysopSecretNumber[b] := 0;
         SysopSecretNumber[0] := 5;
         For b := 1 to 5
           do SysopSecretNumber[b] := b;

         LogMask := [L_UpDown, L_LUser, L_SU];

         End;

     With Exp
      do Begin
         ExpiryHour := 2;
         With ExpiryTimes
           do Begin
              Dx     := 14;
              Ann    := 30;
              WWV    := 30;
              Last   := 7;
              LUser  := 120;
              NUser  := 60;
              Node   := 60;
              End;
         End;


     With Buf do
     With BufSizes
      do Begin
         Dx     := 200;
         Ann    := 50;
         WWV    := 10;
         Last   := 50;
         NUser  := 200;
         Node   := 100;
         End;

     With Conv
      do Begin
         DefaultChan := 139;
         ConvHostName := 'Kakola';
         End;

     With Crt
      do Begin
         CrtType := 1;
         CrtMode := CM_Auto;
         DefPalette;
         End;

     With Sound
      do Begin
         SoundHw := SHW_none;

         lptBase := $3bc;
         lptInt  := 7;

         sbBase := $220;
         sbInt  := 5;
         sbDMA  := 1;

         Mycall     := nocall;
         idInterval := 15;
         idType     := IDT_Used;

         cwSpeed := 18;
         cwFreq := 700;

         txHead := 300;
         txTail := 100;

         End;

     End;

End;

 {$ENDIF}
 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

Function ReadConfig:Byte;
Var
  f      : File;
  {$IFDEF DUMP_COLORS}
  t      : Text;
  b      : Byte;
  {$ENDIF}

Begin

 {$IFDEF SETUP}
 Assign(f,fName);
 {$ELSE}
 New(Conf);
 Assign(f,CluPath + fName);
 {$ENDIF}

 Reset(f,1);
 BlockRead(f,Conf^,SizeOf(Conf^));
 Close(f);

 If IOResult <> 0
   then Begin
        ReadConfig := 1;
        {$IFDEF SETUP}
        DefaultConfig;
        DefaultsUsed := True;
        {$ENDIF}
        Exit;
        End
   else Begin
        ReadConfig := 0;
        {$IFDEF SETUP}
        DefaultsUsed := False;
        {$ENDIF}
        End;

 With Conf^.Header
  do Begin
     If Signature <> Sign
       then Begin
            ReadConfig := 2;
            Exit;
            End;
     If Version <> ConfVer
       then Begin
            ReadConfig := 3;
            Exit;
            End;
     End;

 {$IFDEF DUMP_COLORS}
 Assign(t,'palette.txt');
 Rewrite(t);
 for b := 1 to 255
  do Write(t,'#',Ord(Conf^.Crt.Pal[b]), ',', CrLf);
 Close(t);
 {$ENDIF}

End;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

Procedure WriteConfig;
Var
  f      : File;
Begin

 {$IFDEF SETUP}
 Conf^.Header.HeadStr   := HeadString;
 Conf^.Header.Signature := Sign;
 Assign(f,fName);
 {$ELSE}
 Assign(f,CluPath + fName);
 {$ENDIF}

 Rewrite(f,1);
 BlockWrite(f,Conf^,SizeOf(Conf^));
 Close(f);
 {$IFDEF SETUP}
 If IOResult <> 0
   then MessageBox(^C'Could not write configuration file! UGH!',
                   nil, mfError + mfOkButton);
 {$ENDIF}

End;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

Begin

 For b := 1 to SizeOf(Sign)
  do Sign[b] := Chr(Ord(Sign[b]) xor b);

End.
