
Unit SetForm;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile;

Type

  PCallValidator = ^TCallValidator;
  TCallValidator = object(TValidator)
    Function IsValid(const S: string): Boolean; virtual;
    procedure Error; virtual;
  end;

  PCStr = ^TCStr;
  TCStr = object(TInputLine)
    constructor Init(var Bounds: TRect; Dat:PString; AMaxLen: Integer);
    destructor Done; virtual;
  end;

  PCallStr = ^TCallStr;
  TCallStr = object(TCStr)
    constructor Init(var Bounds: TRect; Dat:PString; AMaxLen: Integer);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  PLocStr = ^TLocStr;
  TLocStr = object(TCStr)
    constructor Init(var Bounds: TRect; Dat:PString);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  PCChr = ^TCChr;
  TCChr = object(TInputLine)
    ChrData : PChar;
    constructor Init(var Bounds: TRect; Dat:PChar);
    destructor Done; virtual;
  end;

  PByte      = ^Byte;
  PByteEntry = ^TByteEntry;
  TByteEntry = object(TInputLine)
    ByteData : PByte;
    constructor Init(var Bounds: TRect; Dat:PByte; CharLen, LowLimit,
                     HighLimit : Byte);
    destructor Done; virtual;
  end;

  PWord     = ^Word;
  PWordEntry = ^TWordEntry;
  TWordEntry = object(TInputLine)
    WordData : PWord;
    constructor Init(var Bounds: TRect; Dat:PWord; CharLen:Byte; LowLimit,
                     HighLimit : Word);
    destructor Done; virtual;
  end;

  PHexWordEntry = ^THexWordEntry;
  THexWordEntry = object(TInputLine)
    WordData : PWord;
    constructor Init(var Bounds: TRect; Dat:PWord; CharLen:Byte; LowLimit,
                     HighLimit : Word);
    destructor Done; virtual;
  end;


 { General settings }

  PDateFormat = ^TDateFormat;
  TDateFormat = object(TRadioButtons)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PDateFlagEntry = ^TDateFlagEntry;
  TDateFlagEntry = object(TCheckBoxes)
    Constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PIfType = ^TIfType;
  TIfType = object(TRadioButtons)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PGenSets = ^TGenSets;
  TGenSets = object(TDialog)
    Backup     : PConfig;
    Abandon    : Boolean;
    Call       : PCallStr;
    ConCall    : PCallStr;
    QTHLoc     : PLocStr;
    DateFormat : PDateFormat;
    DateFlags  : PDateFlagEntry;
    DateSepar,
    TimeSepar  : PCChr;
    IfType     : PIfType;
    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

 { Interface settings }

  PMonitorMode = ^TMonitorMode;
  TMonitorMode = object(TCheckBoxes)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;


  PIfSets = ^TIfSets;
  TIfSets = object(TDialog)
    Backup     : PConfig;
    Abandon    : Boolean;
    BPQInt,
    ApplNum,
    Max_paclen,
    Start_port,
    No_ports      : PByteEntry;
    Link_reset    : PWordEntry;
    Usr_Timeout   : PWordEntry;
    Buf_treshold  : PByteEntry;
    MonitorMode   : PMonitorMode;
    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RGenSets: TStreamRec = (
     ObjType: 10042;
     VmtLink: Ofs(TypeOf(TGenSets)^);
     Load:    @TGenSets.Load;
     Store:   @TGenSets.Store
  );

  RIfSets: TStreamRec = (
     ObjType: 10043;
     VmtLink: Ofs(TypeOf(TIfSets)^);
     Load:    @TIfSets.Load;
     Store:   @TIfSets.Store
  );

Procedure RegisterSetForm;
Procedure RegisterIfSetForm;
Function Int2Str(int:LongInt):String;

Implementation { ********************************************************* }

Uses
  MsgBox, SetHelp;

Const
 HexChars: array [0..$F] of Char = '0123456789abcdef';

 { Some support routines.... }

Function Str2Word(st:String):Word;         { String Wordiksi }
Var l:LongInt;
    i:Integer;
Begin
 Val(St,l,i);
 If (i > 0) or (l > 65535) or (l < 0) then l := 0;
 Str2Word := l;
End;

Function Str2Byte(st:String):Byte;       { String Byteksi }
Var l:LongInt;
    i:Integer;
Begin
 Val(St,l,i);
 If (i > 0) or (l > 255) or (l < 0) then l := 0;
 Str2Byte := l;
End;

Function Int2Str(int:LongInt):String;
Var s: string[11];
Begin
 Str(int,s);
 Int2str := s;
End;

Function HexW2Str(w:Word):String;
Begin
 HexW2Str :=
       hexChars[Hi(w) shr 4]
     + hexChars[Hi(w) and $F]
     + hexChars[Lo(w) shr 4]
     + hexChars[Lo(w) and $F];
End;

 { *** TCallValidator *** *** *** *** *** *** *** *** *** *** *** *** *** }

Function TCallValidator.IsValid(const S: string): Boolean;
Var
  stat : Boolean;
  num,
  chr,
  b    : Byte;
Begin

 stat := True;
 chr := 0;
 num := 0;

 For b := 1 to Length(s)
  do { Onko sek kirjaimia ett numeroita? }
     If (Ord(s[b]) >= 48) and (Ord(s[b]) <= 57) { Onko numero? }
       then Inc(num)
       else If (Ord(s[b]) >= 65) and (Ord(s[b]) <= 90) { Kirjain? }
              then Inc(chr)
              else { Tm ei ollut kirjain EIK numero! }
                   If not ((s[b] = '/') or (s[b] = '-')) { Poikkeukset... }
                     then stat := False;

 If not ((num > 0) and (chr > 1))
   then stat := False;

 IsValid := stat;

End;

Procedure TCallValidator.Error;
Begin

 MessageBox(^C'This is not a valid callsign!',
           nil, mfError + mfOkButton);
End;

 { *** TCStr *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TCStr.Init(var Bounds: TRect; Dat: PString; AMaxLen: Integer);
Begin

 inherited Init(Bounds, AMaxLen);
 FreeMem(Data,AMaxLen + 1);
 Data := Dat;

End;

Destructor TCStr.Done;
Begin

 GetMem(Data, MaxLen + 1);
 inherited Done;

End;

 { *** TCallStr *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TCallStr.Init(var Bounds: TRect; Dat:PString; AMaxLen: Integer);
Begin

 inherited Init(Bounds, Dat, AMaxLen);
 SetValidator(New(PCallValidator,Init))

End;

Procedure TCallStr.HandleEvent(var Event: TEvent);
Begin

 Case Event.What of
   evKeyDown : Event.CharCode := Upcase(Event.CharCode);
 End;
 inherited HandleEvent(Event);

End;

 { *** TLocStr *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TLocStr.Init(var Bounds: TRect; Dat:PString);
Begin

 inherited Init(Bounds, Dat, 6);
{ SetValidator(New(PLocValidator,Init))}

End;

Procedure TLocStr.HandleEvent(var Event: TEvent);
Begin

 Case Event.What of
   evKeyDown : Begin
               Event.CharCode := Upcase(Event.CharCode);

               If (Event.CharCode = #0) or (Event.CharCode = #8)
                 then inherited HandleEvent(Event)
                 else

               If ((Event.CharCode >= 'A') and (Event.CharCode <= 'Z'))
                 or ((Event.CharCode >= '0') and (Event.CharCode <= '9'))
                 then Begin
                      If (CurPos < 2) or (CurPos > 3)
                        then Begin
                             If (Event.CharCode >= 'A') and (Event.CharCode <= 'Z')
                               then inherited HandleEvent(Event);
                             End
                        else If (Event.CharCode >= '0') and (Event.CharCode <= '9')
                               then inherited HandleEvent(Event);
                      ClearEvent(Event);
                      End;
               End;
   else inherited HandleEvent(Event);
 End;

End;

 { *** TCChr *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TCChr.Init(var Bounds: TRect; Dat:PChar);
Begin

 inherited Init(Bounds, 1);
 ChrData := Dat;
 Data^ := ChrData^;

End;

Destructor TCChr.Done;
Begin

 ChrData^ := Data^[1];
 inherited Done;

End;

 { *** TByteEntry *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TByteEntry.Init(var Bounds: TRect; Dat:PByte; CharLen, LowLimit,
                            HighLimit : Byte);
Begin

 inherited Init(Bounds, CharLen);
 ByteData := Dat;
 Data^ := Int2Str(ByteData^);
 SetValidator(New(PRangeValidator,Init(LowLimit,HighLimit)))

End;

Destructor TByteEntry.Done;
Begin

 ByteData^ := Str2Byte(Data^);
 inherited Done;

End;

 { *** TWordEntry *** *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TWordEntry.Init(var Bounds: TRect; Dat:PWord; CharLen:Byte;
                            LowLimit, HighLimit : Word);
Begin

 inherited Init(Bounds, CharLen);
 WordData := Dat;
 Data^ := Int2Str(WordData^);
 SetValidator(New(PRangeValidator,Init(LowLimit,HighLimit)))

End;

Destructor TWordEntry.Done;
Begin

 WordData^ := Str2Word(Data^);
 inherited Done;

End;

 { *** THexWordEntry *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor THexWordEntry.Init(var Bounds: TRect; Dat:PWord; CharLen:Byte;
                            LowLimit, HighLimit : Word);
Begin

 inherited Init(Bounds, CharLen);
 WordData := Dat;
 Data^ := HexW2Str(WordData^);
{ SetValidator(New(PRangeValidator,Init(LowLimit,HighLimit)));}
End;

Destructor THexWordEntry.Done;
Begin

 WordData^ := Str2Word('$' + Data^);
 inherited Done;

End;

 { ********************************************************************* }
 {  General settings                                                     }
 { ********************************************************************* }

 { *** TDateFormat  *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TDateFormat.Init(var Bounds: TRect; AStrings: PSItem);
Var
 i : LongInt;
Begin

 inherited Init(Bounds, AStrings);
 i := Ord(Conf^.Locale.DateFormat);
 SetData(i);

End;

Destructor TDateFormat.Done;
Begin

 With Conf^.Locale do
 Case Value of
   0 : DateFormat := dmy;
   1 : DateFormat := mdy;
   2 : DateFormat := ymd;
   3 : DateFormat := ydm;
 End;
 inherited Done;

End;

 { *** TDateFlags *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TDateFlagEntry.Init(var Bounds: TRect; AStrings: PSItem);
Var
 i : ^Byte;
Begin

 inherited Init(Bounds, AStrings);

 i := @Conf^.Locale.DateFlags;

 SetData(i^);

End;

Destructor TDateFlagEntry.Done;
Var
 i : Word;
 m : PDateFlags;
Begin

 GetData(i);
 m := @i;
 Conf^.Locale.DateFlags := m^;

 inherited Done;

End;

 { *** TIfType *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TIfType.Init(var Bounds: TRect; AStrings: PSItem);
Var
 i : LongInt;
Begin

 inherited Init(Bounds, AStrings);
 i := Ord(Conf^.Ifc.IfType);
 SetData(i);

End;

Destructor TIfType.Done;
Begin

 With Conf^.Ifc do
 Case Value of
   0 : IfType := g8bpq;
   1 : IfType := flex;
 End;
 inherited Done;

End;

 { *** TGenSets *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TGenSets.Init;
Var
  R : TRect;
Begin

  R.Assign(0, 0, 55, 21);
  inherited Init(R,'General settings');
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

  R.Assign(21,2,32,3);
  Insert(New(PCallStr, Init(R,@Conf^.CluCall,9)));

  R.Assign(2, 2, 19, 3);
  Insert(New(PLabel, Init(R, '~N~ode callsign:', Call)));

  R.Assign(21,3,32,4);
  ConCall := New(PCallStr, Init(R,@Conf^.ConsoleCall,9));
  Insert(ConCall);

  R.Assign(2, 3, 20, 4);
  Insert(New(PLabel, Init(R, '~C~onsole callsign:', ConCall)));

  R.Assign(21,5,29,6);
  QTHLoc := New(PLocStr, Init(R,@Conf^.QTHLoc));
  Insert(QTHLoc);

  R.Assign(2, 5, 19, 6);
  Insert(New(PLabel, Init(R, '~Q~TH locator:', QTHLoc)));

  R.Assign(16, 7, 40, 9);
  DateFormat := New(PDateFormat, Init(R,
    NewSItem('DDMMYY', NewSItem('MMDDYY',
    NewSItem('YYMMDD', NewSItem('YYDDMM',nil))))));
  Insert(DateFormat);

  R.Assign(2, 7, 15, 8);
  Insert(New(PLabel, Init(R, 'Date ~f~ormat:', DateFormat)));

  R.Assign(16, 10, 53, 11);
  DateFlags := New(PDateFlagEntry, Init(R,
    NewSItem('Separator character in the end', nil)));
  Insert(DateFlags);

  R.Assign(2, 10, 15, 11);
  Insert(New(PLabel, Init(R, 'Date f~l~ags:', DateFlags)));

  R.Assign(21, 12, 24, 13);
  DateSepar := New(PCChr, Init(R, @Conf^.Locale.DateSeparator));
  Insert(DateSepar);

  R.Assign(2, 12, 19, 13);
  Insert(New(PLabel, Init(R, 'Separators: ~D~ate', DateSepar)));

  R.Assign(31, 12, 34, 13);
  TimeSepar := New(PCChr, Init(R, @Conf^.Locale.TimeSeparator));
  Insert(TimeSepar);

  R.Assign(24, 12, 29, 13);
  Insert(New(PLabel, Init(R, '~T~ime', TimeSepar)));

  R.Assign(15, 14, 40, 16);
  IfType := New(PIfType, Init(R,
    NewSItem('~G~8BPQ Packet Switch', NewSItem('~P~C/FlexNet', nil))));
  Insert(IfType);

  R.Assign(2, 14, 14, 15);
  Insert(New(PLabel, Init(R, '~I~nterface:', IfType)));

  R.Assign(9, 17, 19, 19);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

  SelectNext(False);

End;

Destructor TGenSets.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TGenSets.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TGenSets.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TGenSets.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;

Procedure RegisterSetForm;
Begin
  RegisterType(RGenSets);
End;

 { ********************************************************************* }
 {  Interface-specific settings                                          }
 { ********************************************************************* }

 { *** TMonitorMode *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TMonitorMode.Init(var Bounds: TRect; AStrings: PSItem);
Var
 i : Word;
Begin

 i := 0;
 inherited Init(Bounds, AStrings);

 If MO_Band in Conf^.Ifc.MonitorMode
   then i := i or 1;
 If MO_Actions in Conf^.Ifc.MonitorMode
   then i := i or 2;

 SetData(i);

End;

Destructor TMonitorMode.Done;
Var
 i : Word;
Begin

 GetData(i);

 With Conf^.Ifc
  do Begin
     If i and 1 = 1
       then Include(MonitorMode, MO_Band)
       else Exclude(MonitorMode, MO_Band);
     If i and 2 = 2
       then Include(MonitorMode, MO_Actions)
       else Exclude(MonitorMode, MO_Actions);
     End;

 inherited Done;

End;

 { *** TIfSets *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TIfSets.Init;
Var
  R : TRect;
Const
  InfoXEnd   = 29;
  EntryXPos  = 31;
Begin

  Case Conf^.Ifc.IfType of

    G8BPQ : Begin
            R.Assign(0, 0, 41, 20);
            inherited Init(R,'G8BPQ settings');
            HelpCtx := hcBPQSets;

            R.Assign(EntryXPos,2,EntryXPos + 5,3);
            BPQInt := New(PByteEntry, Init(R,@Conf^.Ifc.BPQInt,3,1,255));
            Insert(BPQInt);

            R.Assign(2, 2, InfoXEnd, 3);
            Insert(New(PLabel, Init(R, 'G8BPQ ~I~nterrupt:', BPQInt)));

            R.Assign(EntryXPos,3,EntryXPos + 3,4);
            ApplNum := New(PByteEntry, Init(R,@Conf^.Ifc.ApplNum,1,1,8));
            Insert(ApplNum);

            R.Assign(2, 3, InfoXEnd, 4);
            Insert(New(PLabel, Init(R, '~A~pplication number:', ApplNum)));

            Inc(Conf^.Ifc.Start_Port);
            R.Assign(EntryXPos,5,EntryXPos + 5,6);
            Start_port := New(PByteEntry, Init(R,@Conf^.Ifc.Start_port,2,1,64));
            Insert(Start_Port);

            R.Assign(2, 5, InfoXEnd, 6);
            Insert(New(PLabel, Init(R, '~F~irst BPQ stream used:', Start_port)));

            R.Assign(EntryXPos,6,EntryXPos + 5,7);
            No_ports := New(PByteEntry, Init(R,@Conf^.Ifc.No_ports,2,1,64));
            Insert(No_ports);

            R.Assign(2, 6, InfoXEnd, 7);
            Insert(New(PLabel, Init(R, 'Amount of ~s~treams used:', No_ports)));

            R.Assign(EntryXPos,8, EntryXPos + 5,9);
            Max_paclen := New(PByteEntry, Init(R,@Conf^.Ifc.Max_paclen,3,80,230));
            Insert(Max_paclen);

            R.Assign(2, 8, InfoXEnd, 9);
            Insert(New(PLabel, Init(R, 'Maximum ~p~aclen:', Max_paclen)));

            R.Assign(EntryXPos,9,EntryXPos + 7,10);
            Link_reset := New(PWordEntry, Init(R,@Conf^.Ifc.Link_reset,5,0,65535));
            Insert(Link_reset);

            R.Assign(2, 9, InfoXEnd, 10);
            Insert(New(PLabel, Init(R, 'Link timer ~r~eset interval:', Link_reset)));

            R.Assign(EntryXPos,10,EntryXPos + 7,11);
            Usr_Timeout := New(PWordEntry, Init(R,@Conf^.Ifc.Usr_Timeout,5,0,65535));
            Insert(Usr_Timeout);

            R.Assign(2, 10, InfoXEnd, 11);
            Insert(New(PLabel, Init(R, 'User ~i~nactivity timeout:', Usr_Timeout)));

            R.Assign(EntryXPos,12,EntryXPos + 5,13);
            Buf_Treshold := New(PByteEntry, Init(R,@Conf^.Ifc.Buf_treshold,3,5,100));
            Insert(Buf_Treshold);

            R.Assign(2, 12, InfoXEnd, 13);
            Insert(New(PLabel, Init(R, 'Buffer ~t~reshold:', Buf_treshold)));

            R.Assign(22, 14, 36, 16);
            MonitorMode := New(PMonitorMode, Init(R,
               NewSItem('~B~and', NewSItem('A~c~tions', nil))));
            Insert(MonitorMode);

            R.Assign(2, 14, 19, 15);
            Insert(New(PLabel, Init(R, '~M~onitored items:', MonitorMode)));

            R.Assign(9, 17, 19, 19);
            Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
            Inc(R.A.X, 12); Inc(R.B.X, 12);
            Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

            End;

    Flex  : Begin
            R.Assign(0, 0, 41, 15);
            inherited Init(R,'PC/FlexNet settings');
            HelpCtx := hcFlexSets;

            R.Assign(EntryXPos,2,EntryXPos + 4,3);
            No_ports := New(PByteEntry, Init(R,@Conf^.Ifc.No_ports,2,1,64));
            Insert(No_ports);

            R.Assign(2, 2, InfoXEnd, 3);
            Insert(New(PLabel, Init(R, 'Maximum Clusse ~u~sers:', No_ports)));

            R.Assign(EntryXPos,4, EntryXPos + 5,5);
            Max_paclen := New(PByteEntry, Init(R,@Conf^.Ifc.Max_paclen,3,80,255));
            Insert(Max_paclen);

            R.Assign(2, 4, InfoXEnd, 5);
            Insert(New(PLabel, Init(R, 'Maximum ~p~aclen:', Max_paclen)));

            R.Assign(EntryXPos,6,EntryXPos + 7,7);
            Link_reset := New(PWordEntry, Init(R,@Conf^.Ifc.Link_reset,5,0,65535));
            Insert(Link_reset);

            R.Assign(2, 6, InfoXEnd, 7);
            Insert(New(PLabel, Init(R, 'Link timer ~r~eset interval:', Link_reset)));

            R.Assign(EntryXPos,7,EntryXPos + 7,8);
            Usr_Timeout := New(PWordEntry, Init(R,@Conf^.Ifc.Usr_Timeout,5,0,65535));
            Insert(Usr_Timeout);

            R.Assign(2, 7, InfoXEnd, 8);
            Insert(New(PLabel, Init(R, 'User ~i~nactivity timeout:', Usr_Timeout)));


            R.Assign(22, 9, 36, 11);
            MonitorMode := New(PMonitorMode, Init(R,
               NewSItem('~B~and', NewSItem('A~c~tions', nil))));
            Insert(MonitorMode);

            R.Assign(2, 9, 19, 10);
            Insert(New(PLabel, Init(R, '~M~onitored items:', MonitorMode)));

            R.Assign(9, 12, 19, 14);
            Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
            Inc(R.A.X, 12); Inc(R.B.X, 12);
            Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

            End;

  End;

  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TIfSets.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

 Dec(Conf^.Ifc.Start_Port);

End;

Constructor TIfSets.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TIfSets.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TIfSets.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;

Procedure RegisterIfSetForm;
Begin
  RegisterType(RIfSets);
End;

End.
