
Unit s_Snd;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm;

Type

   { Sound parameters }

  PSoundHwType = ^TSoundHwType;
  TSoundHwType = object(TRadioButtons)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PidType = ^TidType;
  TidType = object(TRadioButtons)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PSnd = ^TSnd;
  TSnd = object(TDialog)
    Backup      : PConfig;
    Abandon     : Boolean;

    SoundHwType : PSoundHwType;

    lptBase     : PHexWordEntry;
    lptInt      : PByteEntry;

    Mycall      : pCallStr;
    idInterval  : pWordEntry;
    idType      : pIdType;

    sbBase      : PHexWordEntry;
    sbInt       : PByteEntry;
    sbDMA       : PByteEntry;

    cwSpeed     : PByteEntry;
    cwFreq      : PWordEntry;

    txHead      : PWordEntry;
    txTail      : PWordEntry;

    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RSnd: TStreamRec = (
     ObjType: 10049;
     VmtLink: Ofs(TypeOf(TSnd)^);
     Load:    @TSnd.Load;
     Store:   @TSnd.Store
  );

Procedure RegisterSndForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TSoundHwType *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TSoundHwType.Init(var Bounds: TRect; AStrings: PSItem);
Var i : LongInt;
Begin

 inherited Init(Bounds, AStrings);
 i := Ord(Conf^.Sound.SoundHw);
 SetData(i);

End;

Destructor TSoundHwType.Done;
Begin

 Move(Value,Conf^.Sound.SoundHw,1);
 inherited Done;

End;

 { *** TidType *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TidType.Init(var Bounds: TRect; AStrings: PSItem);
Var i : LongInt;
Begin

 inherited Init(Bounds, AStrings);
 i := Ord(Conf^.Sound.idType);
 SetData(i);

End;

Destructor TidType.Done;
Begin

 Move(Value,Conf^.Sound.idType,1);
 inherited Done;

End;

 { *** TScr *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TSnd.Init;
Var
  R : TRect;
Begin

  R.Assign(0, 0, 70, 20);
  inherited Init(R,'Sound settings');

  { Ensimminen sarake }

  R.Assign(4, 3, 25, 6);
  SoundHwType := New(PSoundHwType, Init(R,
    NewSItem('~N~one (disable)',
    NewSItem('~L~PT port DAC',
    NewSItem('~S~ound Blaster',nil)))));
  SoundHwType^.EnableMask := 1;
  Insert(SoundHwType);

  R.Assign(2, 2, 17, 3);
  Insert(New(PLabel, Init(R, '~H~ardware used:', SoundHwType)));

  R.Assign(20, 8, 26, 9);
  lptBase := New(PHexWordEntry, Init(R,@Conf^.Sound.lptBase,4,1,$400));
  Insert(lptBase);

  R.Assign(4, 8, 20, 9);
  Insert(New(PLabel, Init(R, 'Base address:', lptBase)));

  R.Assign(2, 7, 27, 8);
  Insert(New(PLabel, Init(R, 'LPT port ~D~AC settings:', lptBase)));

  R.Assign(20, 9, 24, 10);
  lptInt := New(PByteEntry, Init(R,@Conf^.Sound.lptInt,2,1,15));
  Insert(lptInt);

  R.Assign(4, 9, 20, 10);
  Insert(New(PLabel, Init(R, 'Interrupt:', lptInt)));

  R.Assign(20, 12, 26, 13);
  sbBase := New(PHexWordEntry, Init(R,@Conf^.Sound.sbBase,4,1,$400));
  Insert(sbBase);

  R.Assign(4, 12, 20, 13);
  Insert(New(PLabel, Init(R, 'Base address:', sbBase)));

  R.Assign(2, 11, 27, 12);
  Insert(New(PLabel, Init(R, 'Sound ~B~laster settings:', sbBase)));

  R.Assign(20, 13, 24, 14);
  sbInt := New(PByteEntry, Init(R,@Conf^.Sound.sbInt,2,1,15));
  Insert(sbInt);

  R.Assign(4, 13, 20, 14);
  Insert(New(PLabel, Init(R, 'Interrupt:', sbInt)));

  R.Assign(20, 14, 23, 15);
  sbDMA := New(PByteEntry, Init(R,@Conf^.Sound.sbDMA,1,0,3));
  Insert(sbDMA);

  R.Assign(4, 14, 20, 15);
  Insert(New(PLabel, Init(R, 'DMA channel:', sbDMA)));

  { Toinen sarake }

  R.Assign(29, 3, 66, 6);
  idType := New(PidType, Init(R,
    NewSItem('Every ID interval',
    NewSItem('Every ID interval when speaking',
    NewSItem('Every transmission',nil)))));
  Insert(idType);
  R.Assign(27, 2, 40, 3);
  Insert(New(PLabel, Init(R, '~I~D style:', idType)));

  R.Assign(44,7,55,8);
  Mycall := New(PCallStr, Init(R,@Conf^.Sound.Mycall,9));
  Insert(Mycall);
  R.Assign(28, 7, 42, 8);
  Insert(New(PLabel, Init(R, '~C~allsign:', Mycall)));

  R.Assign(44, 8, 51, 9);
  idInterval := New(PWordEntry, Init(R,@Conf^.Sound.idInterval,5,5,65535));
  Insert(idInterval);
  R.Assign(28, 8, 42, 9);
  Insert(New(PLabel, Init(R, 'ID in~t~erval:', idInterval)));
  R.Assign(51, 8, 62, 9);
  Insert(New(PLabel, Init(R, 'minutes', idInterval)));

  R.Assign(44, 9, 49, 10);
  cwSpeed := New(PByteEntry, Init(R,@Conf^.Sound.cwSpeed,3,4,255));
  Insert(cwSpeed);
  R.Assign(28, 9, 42, 10);
  Insert(New(PLabel, Init(R, 'CW s~p~eed:', cwSpeed)));
  R.Assign(49, 9, 62, 10);
  Insert(New(PLabel, Init(R, 'WPM', cwSpeed)));

  R.Assign(44, 10, 51, 11);
  cwFreq := New(PWordEntry, Init(R,@Conf^.Sound.cwFreq,4,100,3000));
  Insert(cwFreq);
  R.Assign(28, 10, 42, 11);
  Insert(New(PLabel, Init(R, 'CW pitc~h~:', cwFreq)));
  R.Assign(51, 10, 62, 11);
  Insert(New(PLabel, Init(R, 'Hz', cwFreq)));

  R.Assign(44, 12, 51, 13);
  txHead := New(PWordEntry, Init(R,@Conf^.Sound.txHead,4,0,9999));
  Insert(txHead);
  R.Assign(28, 12, 42, 13);
  Insert(New(PLabel, Init(R, 'TX delay:', txHead)));
  R.Assign(51, 12, 62, 13);
  Insert(New(PLabel, Init(R, 'ms', txHead)));

  R.Assign(44, 13, 51, 14);
  txTail := New(PWordEntry, Init(R,@Conf^.Sound.txTail,4,0,9999));
  Insert(txTail);
  R.Assign(28, 13, 42, 14);
  Insert(New(PLabel, Init(R, 'TX tail:', txTail)));
  R.Assign(51, 13, 62, 14);
  Insert(New(PLabel, Init(R, 'ms', txTail)));

  { Alaosa }

  R.Assign(6, 17, 16, 19);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TSnd.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TSnd.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TSnd.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TSnd.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterSndForm;
Begin
  RegisterType(RSnd);
End;

End.
